/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.gameresult.ui;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.ViewFlipper;
import androidx.core.view.ViewCompat;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.single.model.SingleGameResultRankItem;
import com.yy.hiyo.dyres.api.DyResLoader;

public class SingleGameResultRankItemView
extends YYConstraintLayout {
    private static final String TAG = "SingleResultRankItem";
    private SingleGameResultRankItem mRankItem;
    private YYTextView mRankText;
    private YYTextView mRankChangeText;
    private CircleImageView mRankAvatar;
    private YYTextView mRankNameText;
    private YYTextView mRankScoreText;
    private ViewFlipper mViewFlipper;
    private static final int FLIP_COUNT = 4;
    private IRankItemListener mRankItemListener;

    public SingleGameResultRankItemView(Context context) {
        super(context);
        this.init();
    }

    public SingleGameResultRankItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SingleGameResultRankItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        SingleGameResultRankItemView.inflate((Context)this.getContext(), (int)R.layout.single_game_result_rank_item, (ViewGroup)this);
        this.setClipChildren(false);
        this.mRankText = (YYTextView)this.findViewById(R.id.result_rank);
        this.mRankChangeText = (YYTextView)this.findViewById(R.id.result_rank_rise);
        this.mRankAvatar = (CircleImageView)this.findViewById(R.id.result_rank_avatar);
        this.mRankNameText = (YYTextView)this.findViewById(R.id.result_rank_name);
        this.mRankScoreText = (YYTextView)this.findViewById(R.id.result_rank_score);
        this.mRankScoreText.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mRankText.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
    }

    public void setData(SingleGameResultRankItem data) {
        if (data != null) {
            this.mRankItem = data;
            boolean isMe = this.mRankItem.uid == AccountUtil.getUid();
            this.setActivated(isMe);
            if (isMe && this.mRankItem.changedRank != 0) {
                this.mRankChangeText.setBackgroundResource(R.drawable.result_rank_change);
                this.mRankChangeText.setVisibility(0);
                this.mRankChangeText.getBackground().setLevel(this.mRankItem.changedRank > 0 ? 1 : 0);
                this.mRankChangeText.setText((CharSequence)String.valueOf(Math.abs(this.mRankItem.changedRank)));
                this.mRankChangeText.setTextColor(ResourceUtils.getColor((int)(this.mRankItem.changedRank > 0 ? R.color.result_rank_up : R.color.result_rank_down)));
                this.updateFlipper(this.mRankItem.changedRank);
            } else {
                this.mRankChangeText.setVisibility(8);
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"user uid: %s", (Object[])new Object[]{data.uid});
            }
            if (isMe) {
                this.playSvga();
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (SingleGameResultRankItemView.this.mRankItemListener != null) {
                            SingleGameResultRankItemView.this.mRankItemListener.onRankItemSvgaFinished();
                        }
                    }
                }, 1500L);
            }
            this.mRankText.setText((CharSequence)String.valueOf(this.mRankItem.rank));
            ImageLoader.loadImage((RecycleImageView)this.mRankAvatar, (String)(this.mRankItem.avatar + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.icon_avatar_default_female);
            this.mRankNameText.setText((CharSequence)this.mRankItem.name);
            this.mRankScoreText.setText((CharSequence)String.valueOf(this.mRankItem.score));
        } else {
            this.mRankAvatar.setImageResource(R.drawable.icon_avatar_default_female);
            this.mRankChangeText.setVisibility(4);
            this.mRankNameText.setVisibility(4);
            this.mRankScoreText.setVisibility(4);
        }
    }

    private void updateFlipper(int changedRank) {
        ViewStub viewFlipperStub = (ViewStub)this.findViewById(R.id.result_rank_flipper_stub);
        this.mViewFlipper = (ViewFlipper)viewFlipperStub.inflate();
        final int flipCount = Math.min(Math.abs(changedRank), 4);
        int to = this.mRankItem.rank;
        int sign = changedRank > 0 ? 1 : -1;
        int textColor = ResourceUtils.getColor((int)R.color.game_result_yellow);
        Typeface typeface = FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi);
        for (int i = flipCount; i >= 0; --i) {
            YYTextView yyTextView = new YYTextView(this.getContext());
            yyTextView.setTypeface(typeface);
            yyTextView.setTextColor(textColor);
            yyTextView.setText((CharSequence)String.valueOf(to + sign * i));
            yyTextView.setTextSize(24.0f);
            yyTextView.setIncludeFontPadding(false);
            this.mViewFlipper.addView((View)yyTextView);
        }
        this.mRankText.setVisibility(4);
        this.mViewFlipper.setFlipInterval(400);
        this.mViewFlipper.setInAnimation(this.getContext(), changedRank > 0 ? R.anim.result_rank_flipper_up_in : R.anim.result_rank_flipper_down_in);
        this.mViewFlipper.setOutAnimation(this.getContext(), changedRank > 0 ? R.anim.result_rank_flipper_up_out : R.anim.result_rank_flipper_down_out);
        this.mViewFlipper.getInAnimation().setAnimationListener(new Animation.AnimationListener(){
            int count = 0;
            int maxCount = flipCount;

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"SingleGameResultRankItemView", (String)"count  %d, maxCount %d", (Object[])new Object[]{this.count, this.maxCount});
                }
                if (this.count >= this.maxCount) {
                    SingleGameResultRankItemView.this.mViewFlipper.stopFlipping();
                    SingleGameResultRankItemView.this.scaleText();
                }
                ++this.count;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mViewFlipper.startFlipping();
    }

    private void scaleText() {
        if (this.mViewFlipper != null) {
            ViewCompat.animate((View)this.mViewFlipper).scaleX(0.67f).scaleY(0.67f).setDuration(300L).setInterpolator((Interpolator)new AccelerateDecelerateInterpolator()).start();
        }
    }

    private void playSvga() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"play svga", (Object[])new Object[0]);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewGroup parent = (ViewGroup)SingleGameResultRankItemView.this.getParent();
                    ViewStub stub = (ViewStub)SingleGameResultRankItemView.this.findViewById(R.id.game_result_rank_item_svga_stub);
                    SVGAImageView svgaImageView = (SVGAImageView)stub.inflate();
                    svgaImageView.setLoopCount(1);
                    ViewGroup.LayoutParams params = svgaImageView.getLayoutParams();
                    params.width = Math.min(parent.getWidth(), 2 * SingleGameResultRankItemView.this.getWidth());
                    params.height = Math.min(parent.getHeight(), 2 * SingleGameResultRankItemView.this.getHeight());
                    svgaImageView.requestLayout();
                    DyResLoader.INSTANCE.loadSvga(svgaImageView, DR.game_result_rank_item, true);
                }
                catch (Exception e) {
                    MLog.error((Object)SingleGameResultRankItemView.TAG, (String)"play svga error: %s", (Object[])new Object[]{e.toString()});
                }
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mViewFlipper != null) {
            this.mViewFlipper.stopFlipping();
        }
    }

    public void setRankItemListener(IRankItemListener rankItemListener) {
        this.mRankItemListener = rankItemListener;
    }

    public boolean isMe() {
        return this.mRankItem != null && this.mRankItem.isMe();
    }

    public static interface IRankItemListener {
        public void onRankItemSvgaFinished();
    }
}

