/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single.gameresult;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.gamemodule.simplegame.single.gameresult.ISingleGameResultUICallbacks;
import com.yy.game.gamemodule.simplegame.single.gameresult.ui.SingleGameResultWindow;
import com.yy.game.gamemodule.simplegame.single.model.SingleGameResultData;
import com.yy.game.gamemodule.simplegame.single.model.SingleGameResultRankItem;
import com.yy.game.msg.GameMsgDef;
import com.yy.hiyo.game.GameBaseMsgDef;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameResultShareService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.singlegame.SingleGamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.base.ShareItemClickListener;
import com.yy.socialplatformbase.callback.IShareCallBack;
import com.yy.socialplatformbase.data.ShareData;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.json.JSONArray;
import org.json.JSONObject;

public class SingleGameResultWindowController
extends DefaultController
implements ISingleGameResultUICallbacks,
ISharePage {
    private static final String TAG = "SingleGameResultWindowController";
    public static final int RESULT_VISIVILITY = 1;
    private SingleGameResultWindow mWindow;
    private String mGameResult;
    private SingleGameResultData mData;
    private GameInfo mGameInfo;
    private GameModel mGameModel;
    private String mRoomId = "";
    private SingleGamePlayContext mPlayContext;
    private boolean needShowGameResult = false;
    private static final long SHOW_LOADING_DELAY_TIME = 500L;
    private static final long SHOW_SIMPLE_GAME_RESULT_PAGE_DELAY_TIME = 1500L;
    private boolean hasShownSimpleGameResultPage = false;
    private IGameLifecycle mGameLifecycle = new GameLifeWrapper(){

        public void onPreloadGame(GamePlayContext context) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SingleGameResultWindowController.TAG, (String)"onPreloadGame", (Object[])new Object[0]);
            }
            SingleGameResultWindowController.this.reset();
        }

        public void onLoadGameFinish(GamePlayContext context, int finishType, DefaultWindow window) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SingleGameResultWindowController.TAG, (String)("onLoadGameFinish finishType = " + finishType), (Object[])new Object[0]);
            }
        }

        public void onPlayGameStart(GamePlayContext context) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SingleGameResultWindowController.TAG, (String)"onPlayGameStart", (Object[])new Object[0]);
            }
        }

        public void onPlayGameFinish(GamePlayContext context, int finishType) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SingleGameResultWindowController.TAG, (String)("onPlayGameFinish finishType = " + finishType), (Object[])new Object[0]);
            }
            if (context instanceof SingleGamePlayContext) {
                SingleGameResultWindowController.this.mPlayContext = (SingleGamePlayContext)context;
            }
        }

        public void onPreGameExit(GamePlayContext context) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SingleGameResultWindowController.TAG, (String)"onPreGameExit", (Object[])new Object[0]);
            }
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SingleGameResultWindowController.TAG, (String)"onGameExited", (Object[])new Object[0]);
            }
        }
    };
    private Runnable mShowLoadingRunnable = new Runnable(){

        @Override
        public void run() {
            if (SingleGameResultWindowController.this.mDialogLinkManager != null) {
                SingleGameResultWindowController.this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
            }
        }
    };
    private Runnable mShowSimpleResultPageRunnable = new Runnable(){

        @Override
        public void run() {
            SingleGameResultWindowController.this.parseGameResult(SingleGameResultWindowController.this.mGameResult, SingleGameResultWindowController.this.needShowGameResult);
        }
    };

    public SingleGameResultWindowController(Environment env) {
        super(env);
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle(this.mGameLifecycle);
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == GameMsgDef.SINGLE_GAME_RESULT_SHOW) {
            if (msg.obj instanceof GameModel) {
                this.mGameModel = (GameModel)msg.obj;
            }
            Bundle bundle = msg.getData();
            this.mGameResult = bundle.getString("single_game_result");
            this.mRoomId = bundle.getString("single_game_room_id");
            String gid = bundle.getString("single_game_id");
            this.mGameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gid);
            int visibility = bundle.getInt("single_game_result_window_visibility");
            if (visibility != 1) {
                if (this.mWindow == null) {
                    this.mWindow = new SingleGameResultWindow((Context)this.mContext, this);
                    this.mWindow.setSingleTop(false);
                    this.mWindow.setTransparent(true);
                }
                this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, false);
                this.uploadGameRecordToServer(this.getCurGameId(), this.mGameResult, this.mRoomId, true);
            } else {
                this.uploadGameRecordToServer(this.getCurGameId(), this.mGameResult, this.mRoomId, false);
            }
            if (AccountUtil.isLoginByGuest()) {
                long lastTime = SettingFlags.getLongValue((String)"play_game_time");
                if (lastTime <= 0L) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"KEY_PLAY_GAME lastTime <= 0", (Object[])new Object[0]);
                    }
                    SettingFlags.increase((String)"play_game_count");
                } else if (System.currentTimeMillis() - lastTime > 86400000L) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"KEY_PLAY_GAME >", (Object[])new Object[0]);
                    }
                    SettingFlags.increase((String)"play_game_count");
                }
            }
        }
        return super.handleMessageSync(msg);
    }

    public void handleMessage(Message msg) {
        Bundle data;
        super.handleMessage(msg);
        if (msg.what == GameMsgDef.MSG_GAME_RECORD_CHANGE && (data = msg.getData()) != null) {
            String gameId = data.getString("gameId");
            this.mGameResult = data.getString("record");
            this.uploadGameRecordToServer(gameId, this.mGameResult, this.mRoomId, false);
        }
    }

    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1) {
            this.exitGameResultWindow();
        }
        return true;
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        this.mDeviceMgr.hideSysStatusBar();
        super.onWindowShown(abstractWindow);
        this.reportShow();
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        this.reset();
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).unRegisterGameLifecycle(this.mGameLifecycle);
        YYTaskExecutor.removeTask((Runnable)this.mShowLoadingRunnable);
        YYTaskExecutor.removeTask((Runnable)this.mShowSimpleResultPageRunnable);
        this.hasShownSimpleGameResultPage = false;
        super.onWindowDetach(abstractWindow);
    }

    @Override
    public void onBackClick() {
        this.exitGameResultWindow();
    }

    @Override
    public void playAgain() {
        if (this.mGameInfo != null && this.mPlayContext != null) {
            this.mPlayContext.setGameResult("");
            ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).restartGame(this.mGameInfo, (GamePlayContext)this.mPlayContext);
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("function_id", "play_again").put("gid", this.getCurGameId()).put("page_id", "2").put("token", ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
        }
    }

    private void reset() {
        this.mGameResult = null;
        this.mData = null;
        this.mGameInfo = null;
        this.mWindow = null;
    }

    private String getCurGameId() {
        return this.mGameInfo == null || this.mGameInfo.getGid() == null ? "" : this.mGameInfo.getGid();
    }

    public void share(int channelId) {
        if (this.mGameInfo != null && this.mData != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "5").put("gid", this.getCurGameId()).put("share_channel", this.getShareChannel(channelId)));
            String shareBgUrl = "";
            shareBgUrl = this.mGameInfo.getSingleGameShareBgUrl() != null ? this.mGameInfo.getSingleGameShareBgUrl() : (this.mGameInfo.getIconUrl() != null ? this.mGameInfo.getIconUrl() : "");
            ((IGameResultShareService)this.getServiceManager().getService(IGameResultShareService.class)).share(channelId, this.mGameInfo.getGid(), this.mGameInfo.getGname(), shareBgUrl, this.mData.score, this.mData.bestHistoryScore, this.mData.bestDayScore, new IShareCallBack(){

                public void onShareSuccess(ShareData data) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SingleGameResultWindowController.TAG, (String)"onShareSuccess", (Object[])new Object[0]);
                    }
                }

                public void onShareCanceled(ShareData data) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SingleGameResultWindowController.TAG, (String)"onShareCanceled", (Object[])new Object[0]);
                    }
                }

                public void onShareError(ShareData data, Exception e) {
                    MLog.error((Object)SingleGameResultWindowController.TAG, (String)("onShareError e = " + e.getMessage()), (Object[])new Object[0]);
                }
            }, false);
        }
    }

    private String getShareChannel(int channelId) {
        if (channelId == 2) {
            return "3";
        }
        if (channelId == 3) {
            return "4";
        }
        if (channelId == 1) {
            return "2";
        }
        if (channelId == 5) {
            return "1";
        }
        if (channelId == 9) {
            return "6";
        }
        return "5";
    }

    @Override
    public void onShareRecordBtnClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("room_id", this.mRoomId).put("function_id", "sharerecord_click").put("gid", this.getCurGameId()).put("page_id", "2").put("token", ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
        IIntlShareService shareService = (IIntlShareService)this.getServiceManager().getService(IIntlShareService.class);
        if (shareService != null) {
            shareService.showShareBottomDialog((ISharePage)this, new ShareItemClickListener(){

                public void onShareItemClick(int channelId) {
                    SingleGameResultWindowController.this.share(channelId);
                }
            }, new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog2) {
                    SingleGameResultWindowController.this.onShareDialogDismiss();
                }
            });
        }
    }

    @Override
    public void toRankList() {
        Message msg = Message.obtain();
        msg.what = GameMsgDef.MSG_OPEN_SINGLE_GAME_RANK_LIST;
        msg.obj = true;
        this.sendMessage(msg);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025737").put("gid", this.mGameInfo != null ? this.mGameInfo.getGid() : "").put("function_id", "rank_click").put("page_id", "result_page"));
    }

    public void onShareDialogDismiss() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onShareDialogDismiss", (Object[])new Object[0]);
        }
    }

    private void uploadGameRecordToServer(final String gameId, final String record, String roomId, final boolean needShowResult) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[uploadGameRecordToServer] gameId: %s, record: %s", (Object[])new Object[]{gameId, record});
        }
        if (TextUtils.isEmpty((CharSequence)gameId) || TextUtils.isEmpty((CharSequence)record)) {
            if (needShowResult) {
                this.exitGameResultWindow();
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            roomId = "";
        }
        this.needShowGameResult = needShowResult;
        if (needShowResult) {
            this.showLoading();
            YYTaskExecutor.postToMainThread((Runnable)this.mShowSimpleResultPageRunnable, (long)1500L);
        }
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put("result", record);
        map.put("gameId", gameId);
        map.put("isDay", "true");
        map.put("roomId", roomId);
        Object result = MsgDispatcher.getInstance().sendMessageSync(GameBaseMsgDef.CallOutSide.IS_ACTIVITY_SYNC, (Object)this.mGameModel);
        if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
            map.put("isActivity", "true");
            map.put("activityMethodUri", (String)MsgDispatcher.getInstance().sendMessageSync(GameBaseMsgDef.CallOutSide.GET_ACTIVITY_ID_SYNC, (Object)this.mGameModel));
        }
        HttpUtil.httpReq((String)UriProvider.getSingleGameResultUrl(), map, (int)2, (INetRespCallback)new INetRespCallback<SingleGameResultData>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)SingleGameResultWindowController.TAG, (String)"uploadGameRecordToServer onError exception: %s", (Object[])new Object[]{e.getMessage()});
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)SingleGameResultWindowController.this.mContext, (String)e.getMessage(), (int)0);
                }
                SingleGameResultWindowController.this.hideLoading();
                YYTaskExecutor.removeTask((Runnable)SingleGameResultWindowController.this.mShowSimpleResultPageRunnable);
                if (!SingleGameResultWindowController.this.hasShownSimpleGameResultPage) {
                    SingleGameResultWindowController.this.parseGameResult(record, needShowResult);
                }
            }

            public void onResponse(String response, BaseResponseBean<SingleGameResultData> res, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameResultWindowController.TAG, (String)"[uploadGameRecordToServer] response: %s", (Object[])new Object[]{response});
                }
                SingleGameResultWindowController.this.hideLoading();
                YYTaskExecutor.removeTask((Runnable)SingleGameResultWindowController.this.mShowSimpleResultPageRunnable);
                if (res != null && res.isSuccess() && res.data != null) {
                    ((SingleGameResultData)res.data).gameId = gameId;
                    if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)SingleGameResultWindowController.TAG, (String)"[uploadGameRecordToServer] onResponse gameId: %s , res.data: %s", (Object[])new Object[]{gameId, res.data});
                    }
                    SingleGameResultWindowController.this.mData = (SingleGameResultData)res.data;
                    if (needShowResult) {
                        SingleGameResultWindowController.this.getUserInfo();
                    }
                    if (SingleGameResultWindowController.this.mWindow != null && needShowResult) {
                        SingleGameResultWindowController.this.mWindow.update(SingleGameResultWindowController.this.mData);
                    }
                    NotificationCenter.getGlobalInstance().notify(new Notification(NotificationIdDef.SINGLE_GAME_SCORE_UPDATE, res.data));
                } else {
                    if (RuntimeContext.sIsDebuggable) {
                        ToastUtils.showToast((Context)SingleGameResultWindowController.this.mContext, (String)StringUtils.formatWitUSLocal((String)"something error,please contact developer, error message: %s", (Object[])new Object[]{response}), (int)0);
                    }
                    if (!SingleGameResultWindowController.this.hasShownSimpleGameResultPage) {
                        SingleGameResultWindowController.this.parseGameResult(record, needShowResult);
                    }
                }
            }
        });
    }

    private void parseGameResult(String gameResult, boolean needShowResult) {
        block7: {
            this.hideLoading();
            if (StringUtils.isEmpty((String)gameResult)) {
                if (needShowResult) {
                    this.exitGameResultWindow();
                }
                return;
            }
            try {
                JSONObject jsonObject = JsonParser.obtainJSONObject((String)gameResult);
                JSONObject result = jsonObject.getJSONObject("result");
                if (result == null) {
                    return;
                }
                JSONArray scoreArray = result.getJSONArray("jifen");
                if (scoreArray == null) {
                    return;
                }
                String score = scoreArray.getString(0);
                this.mData = new SingleGameResultData();
                this.mData.score = StringUtils.parseInt((String)score, (int)0);
                if (this.mWindow != null && needShowResult) {
                    this.mWindow.update(this.mData);
                    this.hasShownSimpleGameResultPage = true;
                }
                NotificationCenter.getGlobalInstance().notify(new Notification(NotificationIdDef.SINGLE_GAME_SCORE_UPDATE, (Object)this.mData));
            }
            catch (Exception e) {
                e.printStackTrace();
                MLog.error((Object)TAG, (String)"parse json error: %s", (Object[])new Object[]{e.getMessage()});
                if (!needShowResult) break block7;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SingleGameResultWindowController.this.exitGameResultWindow();
                    }
                });
            }
        }
    }

    private void showLoading() {
        YYTaskExecutor.postToMainThread((Runnable)this.mShowLoadingRunnable, (long)500L);
    }

    public void hideLoading() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        YYTaskExecutor.removeTask((Runnable)this.mShowLoadingRunnable);
    }

    private void exitGameResultWindow() {
        this.hasShownSimpleGameResultPage = false;
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).leaveCurrentGame(null);
        this.sendMessage(GameMsgDef.MSG_REQ_SINGLE_GAME_LIST_MIDDLE_INFO);
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
        }
    }

    private void getUserInfo() {
        if (this.mData == null) {
            return;
        }
        if (this.mData.ranks == null || this.mData.ranks.size() == 0) {
            return;
        }
        ArrayList<Long> uids = new ArrayList<Long>();
        for (SingleGameResultRankItem rankItem : this.mData.ranks) {
            if (rankItem == null) continue;
            uids.add(rankItem.uid);
        }
        if (uids.isEmpty()) {
            return;
        }
        IUserInfoService userInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
        if (userInfoService == null) {
            return;
        }
        userInfoService.getUserInfo(uids, new OnProfileListCallback(){

            public void onUISuccess(List<UserInfoBean> userInfo) {
                if (SingleGameResultWindowController.this.mData == null) {
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameResultWindowController.TAG, (String)"[getUserInfo] onUISuccess: %s", (Object[])new Object[]{userInfo});
                }
                if (userInfo != null) {
                    for (UserInfoBean user : userInfo) {
                        SingleGameResultWindowController.this.fillUserInfo(((SingleGameResultWindowController)SingleGameResultWindowController.this).mData.ranks, user);
                    }
                }
                if (SingleGameResultWindowController.this.mWindow != null) {
                    SingleGameResultWindowController.this.mWindow.updateRankUi(SingleGameResultWindowController.this.mData);
                }
            }

            public void onError(Call call, Exception e, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameResultWindowController.TAG, (String)"[getUserInfo] onError: ", (Object[])new Object[]{e});
                }
            }

            public void onResponseError(int id2, String message, String response) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SingleGameResultWindowController.TAG, (String)"[getUserInfo] onResponseError: %s", (Object[])new Object[]{message});
                }
            }
        });
    }

    private void fillUserInfo(List<SingleGameResultRankItem> rankItems, UserInfoBean user) {
        if (rankItems == null || user == null) {
            return;
        }
        for (SingleGameResultRankItem rankItem : rankItems) {
            if (rankItem == null || rankItem.uid != user.getUid()) continue;
            rankItem.avatar = user.getAvatar();
            rankItem.name = user.getNick();
        }
    }

    private void reportShow() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("room_id", this.mRoomId).put("gid", this.getCurGameId()).put("function_id", "show").put("page_id", "2").put("token", ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
    }

    public String getPageName() {
        return "single_game_result_page";
    }
}

