/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.single;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.gamemodule.activity.mpl.MPLRankGameResultWindowController;
import com.yy.game.gamemodule.activity.mpl.MplReporter;
import com.yy.game.gamemodule.activity.mpl.OnMplRankGameResultShowEvent;
import com.yy.game.gamemodule.activity.mpl.ui.IMPLInvalidDialogCallback;
import com.yy.game.gamemodule.activity.mpl.ui.MplInvalidDialog;
import com.yy.game.gamemodule.activity.mpl.ui.MplInvalidType;
import com.yy.game.gamemodule.base.NormalGamePlayer;
import com.yy.game.gamemodule.base.gameview.BaseGameView;
import com.yy.game.gamemodule.base.gameview.WindowGameView;
import com.yy.game.gamemodule.simplegame.ISimpleGameCallback;
import com.yy.game.gamemodule.simplegame.ISimpleGameUICallback;
import com.yy.game.gamemodule.simplegame.SimpleGameAppsFlyerReporter;
import com.yy.game.gamemodule.simplegame.SimpleGameHiidoReporter;
import com.yy.game.gamemodule.simplegame.SimpleGameType;
import com.yy.game.gamemodule.simplegame.SimpleGameWindow;
import com.yy.game.gamemodule.simplegame.protocol.SimpleGameProtoController;
import com.yy.game.gamemodule.simplegame.protocol.callback.ISimpleGameProtoCallback;
import com.yy.game.gamemodule.simplegame.single.model.SingleGameExceptionBean;
import com.yy.game.gamemodule.simplegame.single.model.SingleGameRecordState;
import com.yy.game.growth.GameExitHelper;
import com.yy.game.module.gameroom.ui.GameWindowConfig;
import com.yy.game.module.jscallappmodule.model.GameScore;
import com.yy.game.module.jscallappmodule.model.SingleGameBestScoreReq;
import com.yy.game.msg.GameMsgDef;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.IGameDialogCallback;
import com.yy.hiyo.game.base.helper.GameReportV1;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.SingleGameBestHistoryInfo;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import common.ERet;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import okhttp3.Call;
import org.json.JSONException;
import org.json.JSONObject;

public class SingleGamePlayer
extends NormalGamePlayer
implements ISimpleGameProtoCallback.IGetSingleGameUrlCallback,
ISimpleGameUICallback {
    private static final String TAG = "SingleGamePlayer";
    private final SimpleGameProtoController mSimpleGameProtoController;
    private MPLRankGameResultWindowController mMPLRankGameResultWindowController;
    private static final Long GAME_TIMEOUT = 5000L;
    private boolean isNeedSaveGameRecord = false;
    private long mSingleGameStartTime = 0L;
    private GameModel mGameModel;
    private static final String PK_EXCEPTION_FINISH_TYPE = "socket_disconnect";
    private static final int SCREEN_LANDSCAPE_TYPE = 2;
    public static final String CURRENT_GAME_ID = "gameId";
    public static final String CURRENT_GAME_RECORD = "record";
    private SimpleGameWindow mGameWindow;
    private ISimpleGameCallback mSimpleGameCallback = new ISimpleGameCallback(){

        @Override
        public String getGameId() {
            if (SingleGamePlayer.this.gameRunningContext != null && SingleGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                return SingleGamePlayer.this.gameRunningContext.getGameInfo().getGid();
            }
            return "";
        }

        @Override
        public SimpleGameType getGameType() {
            return SimpleGameType.SINGLE;
        }

        @Override
        public void showExitDialog() {
            SingleGamePlayer.this.onBackClick();
        }

        @Override
        public GamePlayContext getGamePlayContext() {
            return SingleGamePlayer.this.gameRunningContext;
        }
    };
    private Runnable getUrlTimer = new Runnable(){

        @Override
        public void run() {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.game_loading_fail), (int)0);
            SingleGamePlayer.this.exitRoom(8);
        }
    };

    public SingleGamePlayer(Environment env, IGameLifecycle callback2) {
        super(env, callback2);
        this.mSimpleGameProtoController = new SimpleGameProtoController(env);
    }

    @Override
    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
    }

    @Override
    public int preLoadGame(GamePlayContext context) {
        if (context == null || context.getGameInfo() == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException("onPreloadGame game info is null.");
            }
            return 1;
        }
        this.getSingleGameUrl(context.getGameInfo());
        return 0;
    }

    @Override
    public void onPreloadGameInner(@Nonnull GamePlayContext context) {
        super.onPreloadGameInner(context);
        ((BaseGameView)this.getBaseGameView()).showGameView();
    }

    @Override
    public void onLoadGameFinishInner(GamePlayContext context, int finishType) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("SingleGamePlayer onLoadGameFinish = " + finishType), (Object[])new Object[0]);
        }
        if (finishType == 0) {
            YYTaskExecutor.removeTask((Runnable)this.getUrlTimer);
            if (this.getBaseGameView() != null) {
                ((BaseGameView)this.getBaseGameView()).hideGameLoading();
            }
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_loading_fail), (int)0);
            this.exitRoom(1006, 2);
            if (context != null && context.getGameInfo() != null) {
                SimpleGameHiidoReporter.reportGameLoadFailed(context.getGameInfo().getGid());
            }
        }
        GameReportV1.Companion.reportGameStartPlayedTime(this.gameRunningContext.getGameInfo().getGid(), 0L, Integer.toString(finishType), "");
    }

    @Override
    public int restartGame(GameInfo info, GamePlayContext context) {
        if (info != null && context != null) {
            this.getCocosMessageProxy().getCocosProxyController().callGameFunction(CocosProxyType.gamePlayAgain, "{}");
            this.mSingleGameStartTime = System.currentTimeMillis();
            return 0;
        }
        return super.restartGame(info, context);
    }

    @Override
    public void leaveGameExt() {
        this.exitRoom(7);
    }

    @Override
    public void onPlayGameStartInner(GamePlayContext context) {
        super.onPlayGameStartInner(context);
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        MLog.error((Object)TAG, (String)"SingleGamePlayer onPlayGameStart", (Object[])new Object[0]);
        if (this.mSimpleGameProtoController != null && this.mGameModel != null) {
            this.mSimpleGameProtoController.reportSingleGameStart(this.mGameModel, this.mGameModel.getRoomid());
        }
        SimpleGameHiidoReporter.reportGameLoad(context.getGameInfo().getGid(), context.getGameInfo().getGameMode());
        this.mSingleGameStartTime = System.currentTimeMillis();
        SimpleGameHiidoReporter.reportSingleGameStart(context.getGameInfo().getGid(), context.getRoomId());
        SettingFlags.setBoolean((String)("played_" + context.getGameInfo().getGid()), (boolean)true);
        SimpleGameAppsFlyerReporter.reportSingleGameStart();
    }

    @Override
    public void onPlayGameFinishInner(GamePlayContext context, int finishType) {
        super.onPlayGameFinishInner(context, finishType);
        if (context == null || context.getGameInfo() == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException("game play context or info can not be null");
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("SingleGamePlayer onPlayGameFinish = " + finishType), (Object[])new Object[0]);
        }
        if (finishType == 1) {
            this.showGameResult(context);
            if (this.mSingleGameStartTime > 0L) {
                SimpleGameHiidoReporter.reportSingleGameDuration(context.getGameInfo().getGid(), this.mSingleGameStartTime);
                SimpleGameHiidoReporter.reportSingleGameFinishAndTime(context.getGameInfo().getGid(), "", context.getRoomId(), this.mSingleGameStartTime);
                this.mSingleGameStartTime = 0L;
            }
        } else if (finishType == 2) {
            String result = context.getGameResult();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"single game PKExceptionFinish result: %s", (Object[])new Object[]{result});
            }
            if (StringUtils.isNotEmpty((String)result)) {
                try {
                    SingleGameExceptionBean data = (SingleGameExceptionBean)JsonParser.parseJsonObject((String)result, SingleGameExceptionBean.class);
                    if (data != null && StringUtils.isNotEmpty((String)data.type) && PK_EXCEPTION_FINISH_TYPE.equals(data.type)) {
                        Message msg = Message.obtain();
                        msg.what = GameMsgDef.MSG_NOTIFY_SINGLE_GAME_LIST_DISCONNECT;
                        this.sendMessageSync(msg);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (String)"single game pk exception: %s", (Object[])new Object[]{e.toString()});
                }
            }
            this.exitRoom(1);
        }
        SimpleGameHiidoReporter.reportGameLoadSuccess(context.getGameInfo().getGid());
        SimpleGameHiidoReporter.reportGameShow(context.getGameInfo().getGid());
    }

    @Override
    public void onPreGameExitInner(GamePlayContext context) {
        super.onPreGameExitInner(context);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"SingleGamePlayer onPreGameExitInner", (Object[])new Object[0]);
        }
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        this.showGameExitDialog();
        YYTaskExecutor.removeTask((Runnable)this.getUrlTimer);
        SimpleGameHiidoReporter.reportGameExit(context.getGameInfo().getGid(), 3);
        if (this.mSimpleGameProtoController != null) {
            this.mSimpleGameProtoController.clearGetSingleGameUrlReq();
        }
    }

    @Override
    public void onGameExitedInner(GamePlayContext context, int exitType) {
        super.onGameExitedInner(context, exitType);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"SingleGamePlayer onGameExitedInner", (Object[])new Object[0]);
        }
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        this.hideGameExitDialog();
        ((BaseGameView)this.getBaseGameView()).destroyGameView();
        if (this.mSingleGameStartTime > 0L) {
            if (exitType != 7) {
                SimpleGameHiidoReporter.reportSingleGameDuration(context.getGameInfo().getGid(), this.mSingleGameStartTime);
            }
            SimpleGameHiidoReporter.reportSingleGameDurationWithABTest(context.getGameInfo().getGid(), this.mSingleGameStartTime);
            this.mSingleGameStartTime = 0L;
        }
    }

    @Override
    public void onGetSingleGameUrl(int res, String gameId, String url, String roomId) {
        this.gameRunningContext.setRoomId(roomId);
        this.gameRunningContext.setGameUrl(url);
        this.mGameModel = this.gameRunningContext.buildGameModel();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"[onGetSingleGameUrl] res: %d, gameId: %s, url: %s", (Object[])new Object[]{res, gameId, url});
        }
        if (this.gameRunningContext != null && StringUtils.isNotEmpty((String)gameId) && StringUtils.equals((String)gameId, (String)this.gameRunningContext.getGameInfo().getGid())) {
            if (res == ERet.kRetSuccess.getValue()) {
                YYTaskExecutor.removeTask((Runnable)this.getUrlTimer);
                if (this.getBaseGameView() != null) {
                    ((BaseGameView)this.getBaseGameView()).loadGameView();
                } else {
                    MLog.error((Object)TAG, (String)"SingleGamePlayer onGetSingleGameUrl game window does not exist.", (Object[])new Object[0]);
                    if (RuntimeContext.sIsDebuggable) {
                        throw new IllegalArgumentException("game window does not exist.");
                    }
                }
            } else {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.single_game_enter_fail), (int)1);
                this.exitRoom(8);
                if (res == 1013) {
                    this.showMplInvalidDialog(MplInvalidType.GAME_INVALID);
                } else if (res == 1014) {
                    this.showMplInvalidDialog(MplInvalidType.POWER_LOW);
                } else if (res == 1015) {
                    this.showMplInvalidDialog(MplInvalidType.MONEY_LOW);
                }
            }
        } else {
            MLog.error((Object)TAG, (String)"[onGetSingleGameUrl] no waiting this game", (Object[])new Object[0]);
        }
    }

    private void showGameResult(GamePlayContext context) {
        int mplPlayType = Integer.parseInt(context.getExtendValue("mpl_playType", (Object)0).toString());
        String mplRoomId = (String)context.getExtendValue("mpl_id", (Object)"");
        if (StringUtils.isNotEmpty((String)mplRoomId) && mplPlayType == 2) {
            this.showMplRankGameResult(mplRoomId, context);
        } else {
            Message msg = Message.obtain();
            msg.what = GameMsgDef.SINGLE_GAME_RESULT_SHOW;
            Bundle bundle = new Bundle();
            if (this.mGameModel != null && StringUtils.equal((String)((String)this.mGameModel.getExt("key_show_result_mode", (Object)"")), (String)"2")) {
                bundle.putInt("single_game_result_window_visibility", 1);
                this.exitRoom(1);
            }
            bundle.putString("single_game_result", context.getGameResult());
            bundle.putString("single_game_room_id", context.getRoomId());
            bundle.putString("single_game_id", context.getGameInfo().getGid());
            msg.setData(bundle);
            this.sendMessageSync(msg);
        }
    }

    private void showMplRankGameResult(String mplRoomId, GamePlayContext context) {
        if (this.mMPLRankGameResultWindowController == null) {
            this.mMPLRankGameResultWindowController = new MPLRankGameResultWindowController(this.getEnvironment());
        }
        OnMplRankGameResultShowEvent event = new OnMplRankGameResultShowEvent(context.getGameInfo().getGid(), context.getRoomId(), context);
        this.mMPLRankGameResultWindowController.showWindow(event);
    }

    private void getSingleGameUrl(GameInfo info) {
        if (info != null && StringUtils.isNotEmpty((String)info.getGid())) {
            YYTaskExecutor.postToMainThread((Runnable)this.getUrlTimer, (long)GAME_TIMEOUT);
            String payload = "";
            String mplId = this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString();
            if (!TextUtils.isEmpty((CharSequence)mplId)) {
                JsonStringBuilder builder = JsonStringBuilder.newBuilder();
                builder.put("src", (Object)"mlp").put("id", (Object)mplId);
                payload = builder.buildJson();
            } else if (!TextUtils.isEmpty((CharSequence)payload)) {
                payload = this.gameRunningContext.getExtendValue("js_paylod", (Object)"").toString();
            }
            boolean createNewIfNoRoom = (Boolean)this.gameRunningContext.getExtendValue("createNewIfNoRoom", (Object)false);
            this.mSimpleGameProtoController.sendGetSingleGameUrl(info.getGid(), "", "", payload, createNewIfNoRoom, this);
        }
    }

    @Override
    public CocosProxyType[] getSupportedCocosProxyType() {
        return new CocosProxyType[]{CocosProxyType.gameRecordChange, CocosProxyType.showSingleGameToastView, CocosProxyType.getCurrentSingleGameSaveState, CocosProxyType.gameForceExit, CocosProxyType.getSingleGameBestScore, CocosProxyType.hideBackBtn};
    }

    @Override
    public void onReceiveGameEvent(String context, long seqId, int event, Vector<String> args) {
        super.onReceiveGameEvent(context, seqId, event, args);
        String result = "";
        if (args != null && args.size() > 0) {
            result = args.get(0);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"SingleGamePlayer onReceiveGameEvent event: %d , result: %s", (Object[])new Object[]{event, result});
        }
        this.handleGameEvent(context, seqId, event, result);
    }

    private String getGameId() {
        if (this.gameRunningContext != null && this.gameRunningContext.getGameInfo() != null) {
            return this.gameRunningContext.getGameInfo().getGid();
        }
        return "";
    }

    private void handleGameEvent(final String context, final long seqId, int event, final String result) {
        if (CocosProxyType.getCurrentSingleGameSaveState.getEvent() == event) {
            this.parseSingleGameRecordState(result);
        } else if (CocosProxyType.showSingleGameToastView.getEvent() == event) {
            Notification notification = Notification.obtain((int)GameNotificationDef.SINGLE_GAME_SHOW_TOAST_VIEW);
            notification.extObj = result;
            NotificationCenter.getGlobalInstance().notify(notification);
        } else if (CocosProxyType.gameRecordChange.getEvent() == event) {
            Message message = Message.obtain();
            message.what = GameMsgDef.MSG_GAME_RECORD_CHANGE;
            Bundle bundle = new Bundle();
            bundle.putString(CURRENT_GAME_ID, this.getGameId());
            bundle.putString(CURRENT_GAME_RECORD, result);
            message.setData(bundle);
            this.sendMessage(message);
        } else if (CocosProxyType.getSingleGameBestScore.getEvent() == event) {
            if (StringUtils.isNotEmpty((String)result)) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SingleGameBestScoreReq data = (SingleGameBestScoreReq)JsonParser.parseJsonObject((String)result, SingleGameBestScoreReq.class);
                        if (data != null && data.gameIds != null && !data.gameIds.isEmpty()) {
                            SingleGamePlayer.this.requestBestHistory(data.gameIds, context, seqId);
                        }
                    }
                });
            }
        } else if (CocosProxyType.hideBackBtn.getEvent() == event) {
            if (this.mGameWindow != null) {
                this.mGameWindow.hideExitView();
            }
        } else if (CocosProxyType.gameForceExit.getEvent() == event) {
            this.isNeedSaveGameRecord = false;
            int code = 1005;
            int type = 1001;
            try {
                JSONObject json = null;
                json = JsonParser.obtainJSONObject((String)result);
                code = json.optInt("exitCode", 1005);
                type = json.optInt("exitType", 1001);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.exitRoom(code, type, 2);
        }
    }

    private void parseSingleGameRecordState(String response) {
        if (StringUtils.isEmpty((String)response)) {
            return;
        }
        try {
            SingleGameRecordState saveState = (SingleGameRecordState)JsonParser.parseJsonObject((String)response, SingleGameRecordState.class);
            if (saveState != null) {
                this.isNeedSaveGameRecord = saveState.isSaveRecord;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"parse json error: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    @Override
    protected void onBackClick() {
        super.onBackClick();
        String gid = "";
        if (this.gameRunningContext != null && this.gameRunningContext.getGameInfo() != null) {
            gid = this.gameRunningContext.getGameInfo().getGid();
        }
        GameExitHelper.INSTANCE.callBeforeExit(gid, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

            public Unit invoke(Boolean needConfirm) {
                if (needConfirm.booleanValue()) {
                    if (SingleGamePlayer.this.getBaseGameView() != null) {
                        String dialogTip = "";
                        dialogTip = SingleGamePlayer.this.isNeedSaveGameRecord ? ResourceUtils.getString((int)R.string.single_game_save_record_tip) : ResourceUtils.getString((int)R.string.single_game_not_save_record_tip);
                        ((BaseGameView)SingleGamePlayer.this.getBaseGameView()).showExitConfirmDialog(dialogTip, ResourceUtils.getString((int)R.string.single_game_exit_game_sure), ResourceUtils.getString((int)R.string.single_game_exit_game_cancel), new IGameDialogCallback(){

                            public void onOk() {
                                SingleGamePlayer.this.isNeedSaveGameRecord = false;
                                if (MLog.isLogLevelBlowInfo()) {
                                    MLog.info((Object)SingleGamePlayer.TAG, (String)"foreExit", (Object[])new Object[0]);
                                }
                                SingleGamePlayer.this.getCocosMessageProxy().getGameProxyService().getBaseService().appGameExit(SingleGamePlayer.this.gameRunningContext.getRoomId());
                                SingleGamePlayer.this.exitRoom(1002, 2);
                            }

                            public void onCancel() {
                            }
                        });
                    }
                } else {
                    SingleGamePlayer.this.isNeedSaveGameRecord = false;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SingleGamePlayer.TAG, (String)"foreExit", (Object[])new Object[0]);
                    }
                    SingleGamePlayer.this.getCocosMessageProxy().getGameProxyService().getBaseService().appGameExit(SingleGamePlayer.this.gameRunningContext.getRoomId());
                    SingleGamePlayer.this.exitRoom(2);
                }
                return null;
            }
        });
    }

    @Override
    public void showGameExitDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)R.string.game_exit), true, true, null));
        }
    }

    @Override
    public void hideGameExitDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    private void requestBestHistory(List<String> gameIdList, final String context, final long seqId) {
        final ArrayList list = new ArrayList();
        List cacheData = ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).requestSingleGameBestScore(gameIdList, true, (INetRespCallback)new INetRespCallback<List<SingleGameBestHistoryInfo>>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)SingleGamePlayer.TAG, (String)"[requestBestHistory]", (Throwable)e, (Object[])new Object[0]);
                SingleGamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.getSingleGameBestScoreCallback, JsonParser.toJson((Object)list));
            }

            public void onResponse(String response, BaseResponseBean<List<SingleGameBestHistoryInfo>> res, int id2) {
                if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)SingleGamePlayer.TAG, (String)"[requestBestHistory] response: %s", (Object[])new Object[]{response});
                }
                if (res != null && res.isSuccess()) {
                    if (res.data != null) {
                        list.addAll(SingleGamePlayer.this.transform((List)res.data));
                    } else {
                        MLog.error((Object)SingleGamePlayer.TAG, (String)"[requestBestHistory] null data", (Object[])new Object[0]);
                    }
                } else {
                    MLog.error((Object)SingleGamePlayer.TAG, (String)"[requestBestHistory] msg: %s", (Object[])new Object[]{res == null ? "null res" : res.message});
                }
                SingleGamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.getSingleGameBestScoreCallback, JsonParser.toJson((Object)list));
            }
        });
        if (cacheData != null && !cacheData.isEmpty()) {
            this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.getSingleGameBestScoreCallback, JsonParser.toJson(this.transform(cacheData)));
        }
    }

    private List<GameScore> transform(List<SingleGameBestHistoryInfo> input) {
        ArrayList<GameScore> list = new ArrayList<GameScore>();
        for (SingleGameBestHistoryInfo info : input) {
            if (info == null) continue;
            GameScore score = new GameScore();
            score.gameId = info.gameId;
            score.score = info.bestHistory;
            list.add(score);
        }
        return list;
    }

    private void showMplInvalidDialog(MplInvalidType type) {
        IMPLInvalidDialogCallback callback2 = new IMPLInvalidDialogCallback(){

            @Override
            public void onDismiss() {
            }
        };
        MplInvalidDialog dialog2 = new MplInvalidDialog((Context)this.mContext, type, callback2);
        dialog2.show();
        if (type == MplInvalidType.MONEY_LOW) {
            MplReporter.INSTANCE.noRupeeToastShow();
        } else if (type == MplInvalidType.POWER_LOW) {
            MplReporter.INSTANCE.noPowerToastShow();
        }
    }

    public WindowGameView initGameView() {
        GameWindowConfig gameWindowConfig = new GameWindowConfig(this.gameRunningContext.getGameInfo().isSupportFullScreen());
        this.mGameWindow = new SimpleGameWindow((Context)this.mContext, (UICallBacks)this, this.mSimpleGameCallback, AbstractWindow.WindowLayerType.USE_ALL_LAYER, 103, gameWindowConfig);
        return new WindowGameView(this.mGameWindow, this.mIWindowGameViewCallback);
    }

    public BaseGameView<SimpleGameWindow> getBaseGameView() {
        return (BaseGameView)super.getBaseGameView();
    }
}

