/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.samescreen.list.costom;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.game.R;

public class SameScreenGuide
extends YYConstraintLayout
implements View.OnClickListener {
    View mTopTip;
    View mBottomTip;
    ValueAnimator mTopAnimator;
    ValueAnimator mBottomAnimator;
    ValueAnimator mLeftAnimator;
    ValueAnimator mRightAnimator;
    public Runnable mRemoveSelfTask;
    public Runnable mDelayTask;
    private View mLeftFlag;
    private View mRightFlag;

    public SameScreenGuide(@NonNull Context context) {
        this(context, null);
    }

    public SameScreenGuide(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SameScreenGuide(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        SameScreenGuide.inflate((Context)this.getContext(), (int)R.layout.game_view_samescreen_guide, (ViewGroup)this);
        this.mTopTip = this.findViewById(R.id.samescreen_top_tip);
        this.mBottomTip = this.findViewById(R.id.samescreen_bottom_tip);
        this.mLeftFlag = this.findViewById(R.id.left_flag);
        this.mRightFlag = this.findViewById(R.id.right_flag);
        this.setOnClickListener(this);
        this.mTopTip.setRotation(180.0f);
        this.mLeftAnimator = ObjectAnimator.ofFloat((Object)this.mLeftFlag, (String)"rotation", (float[])new float[]{0.0f, 30.0f});
        this.mLeftAnimator.setRepeatCount(-1);
        this.mLeftAnimator.setRepeatMode(2);
        this.mLeftAnimator.setDuration(600L);
        this.mRightAnimator = ObjectAnimator.ofFloat((Object)this.mRightFlag, (String)"rotation", (float[])new float[]{0.0f, -30.0f});
        this.mRightAnimator.setRepeatCount(-1);
        this.mRightAnimator.setRepeatMode(2);
        this.mRightAnimator.setDuration(600L);
        this.mTopAnimator = ObjectAnimator.ofFloat((Object)this.mTopTip, (String)"translationY", (float[])new float[]{0.0f, 50.0f, 0.0f});
        this.mBottomAnimator = ObjectAnimator.ofFloat((Object)this.mBottomTip, (String)"translationY", (float[])new float[]{0.0f, -50.0f, 0.0f});
        this.mTopAnimator.setDuration(1000L);
        this.mBottomAnimator.setDuration(1000L);
        this.mTopAnimator.setRepeatMode(2);
        this.mTopAnimator.setRepeatCount(-1);
        this.mBottomAnimator.setRepeatMode(2);
        this.mBottomAnimator.setRepeatCount(-1);
        this.mRemoveSelfTask = new Runnable(){

            @Override
            public void run() {
                SameScreenGuide.this.removeSelf();
            }
        };
        this.mDelayTask = new Runnable(){

            @Override
            public void run() {
                SameScreenGuide.this.mTopAnimator.start();
                SameScreenGuide.this.mBottomAnimator.start();
                SameScreenGuide.this.mLeftFlag.setPivotX(0.0f);
                SameScreenGuide.this.mLeftFlag.setPivotY((float)SameScreenGuide.this.mLeftFlag.getMeasuredHeight());
                SameScreenGuide.this.mRightFlag.setPivotX((float)SameScreenGuide.this.mRightFlag.getMeasuredWidth());
                SameScreenGuide.this.mRightFlag.setPivotY((float)SameScreenGuide.this.mRightFlag.getMeasuredHeight());
                SameScreenGuide.this.mLeftAnimator.start();
                SameScreenGuide.this.mRightAnimator.start();
                SameScreenGuide.this.postDelayed(SameScreenGuide.this.mRemoveSelfTask, 3000L);
            }
        };
        this.postDelayed(this.mDelayTask, 500L);
    }

    public void onClick(View v) {
        this.removeSelf();
    }

    private void removeSelf() {
        block3: {
            try {
                if (this.getParent() != null && this.getParent() instanceof ViewGroup) {
                    ((ViewGroup)this.getParent()).removeView((View)this);
                }
            }
            catch (Exception e) {
                if (!MLog.isLogLevelBlowInfo()) break block3;
                MLog.info((Object)"SameScreenGuide", (String)"removeSelf error %s", (Object[])new Object[]{e});
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mDelayTask != null) {
            this.getHandler().removeCallbacks(this.mDelayTask);
            this.getHandler().removeCallbacks(this.mRemoveSelfTask);
            if (this.mTopAnimator != null) {
                this.mTopAnimator.cancel();
            }
            if (this.mBottomAnimator != null) {
                this.mBottomAnimator.cancel();
            }
            if (this.mLeftAnimator != null) {
                this.mLeftAnimator.cancel();
            }
            if (this.mRightAnimator != null) {
                this.mRightAnimator.cancel();
            }
        }
    }
}

