/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.samescreen.list.costom;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.viewpager.widget.PagerAdapter;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.samescreen.list.SelectSameScreenController;
import com.yy.hiyo.game.base.bean.SameScreenGameBean;
import java.util.HashMap;
import java.util.Map;

public class SameScreenGameAdapter
extends PagerAdapter {
    private static final String TAG = "SameScreenGameAdapter";
    private Context mContext;
    private Map<Integer, CardView> mBgCache = new HashMap<Integer, CardView>();
    private Map<Integer, View> mDownloadMark = new HashMap<Integer, View>();
    private int mItemHeight;
    private SelectSameScreenController mSelectSameScreenController;

    public SameScreenGameAdapter(Context context, SelectSameScreenController screenGameController) {
        this.mContext = context;
        this.mSelectSameScreenController = screenGameController;
    }

    public CardView getRootView(int position) {
        return this.mBgCache.get(position);
    }

    public int getCount() {
        return this.mSelectSameScreenController.getSameScreenDatas().size();
    }

    public int getItemPosition(Object object) {
        return -1;
    }

    public void updateDownedMark(int position, float percentage) {
        View view = this.mDownloadMark.get(position);
        if (view != null) {
            if ((double)percentage > 0.95) {
                view.setVisibility(8);
                return;
            }
            if (view.getVisibility() == 8) {
                view.setVisibility(0);
            }
            if ((double)percentage < 0.1) {
                percentage = 0.1f;
            }
            int height = (int)((float)this.mItemHeight * (1.0f - percentage));
            if (view.getLayoutParams() instanceof FrameLayout.LayoutParams) {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
                if (lp != null) {
                    lp.height = height;
                }
                view.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        final View root = LayoutInflater.from((Context)this.mContext).inflate(R.layout.game_item_samescreen_select, container, false);
        CardView cardView = (CardView)root.findViewById(R.id.samescreen_item_container);
        View downLoadMark = root.findViewById(R.id.samescreen_download_mark);
        RecycleImageView imageView = (RecycleImageView)root.findViewById(R.id.iv_samescreen_game);
        final SameScreenGameBean sameScreenGameBean = this.mSelectSameScreenController.getSameScreenDatas().get(position);
        ImageLoader.loadBitmap((RecycleImageView)imageView, (String)sameScreenGameBean.iconUrl, (int)R.drawable.game_samscreen_cover);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SameScreenGameAdapter.this.mSelectSameScreenController.onSameScreenGameItemClick(sameScreenGameBean.id);
            }
        });
        container.addView(root);
        this.mBgCache.put(position, cardView);
        this.mDownloadMark.put(position, downLoadMark);
        if (this.mItemHeight == 0) {
            downLoadMark.post(new Runnable(){

                @Override
                public void run() {
                    SameScreenGameAdapter.this.mItemHeight = root.getMeasuredHeight();
                }
            });
        }
        YYTextView tvMaintain = (YYTextView)root.findViewById(R.id.tv_maintain);
        FontUtils.setFontType((TextView)tvMaintain, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        if (sameScreenGameBean.isBetaTest) {
            tvMaintain.setVisibility(0);
            tvMaintain.setText((CharSequence)ResourceUtils.getString((int)R.string.tag_beta_test));
            tvMaintain.setBackgroundResource(R.drawable.beta_a);
        } else if (sameScreenGameBean.fixing || sameScreenGameBean.isFull) {
            tvMaintain.setVisibility(0);
            tvMaintain.setText((CharSequence)ResourceUtils.getString((int)(sameScreenGameBean.isFull ? R.string.btn_full : R.string.maintaining)));
            tvMaintain.setBackgroundResource(R.drawable.maintaining_a);
        } else {
            tvMaintain.setVisibility(4);
        }
        return root;
    }
}

