/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.samescreen.list;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.cardview.widget.CardView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.appbase.ui.widget.status.IRequestCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.samescreen.list.SelectSameScreenController;
import com.yy.game.gamemodule.simplegame.samescreen.list.costom.SameScreenGameAdapter;
import com.yy.game.gamemodule.simplegame.samescreen.list.costom.SameScreenGuide;
import com.yy.game.gamemodule.simplegame.samescreen.list.costom.SameScreenNameView;
import com.yy.game.gamemodule.simplegame.samescreen.list.costom.SizeGradientPageTransform;
import com.yy.hiyo.game.base.bean.SameScreenGameBean;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class SelectSameScreenWindow
extends DefaultWindow {
    private static final String TAG = "SelectSameScreenWindow";
    private static final String SAME_SCREEN_GUIDE_SHOW_COUNT = "SAME_SCREEN_GUIDE_SHOW_COUNT";
    private static final long LOADING_TIMEOUT = 5000L;
    private static final int MAX_COUNT = 3;
    private static final float CARD_SHADOW = ResolutionUtils.dip2Px((float)10.0f);
    private SelectSameScreenController mSelectSameScreenController;
    private ViewPager mSameGameViewPager;
    private CommonStatusLayout mStatusLayout;
    private SameScreenGameAdapter mSameScreenAdapter;
    private View mRootView;
    private SameScreenNameView mTopPlayer;
    private SameScreenNameView mBottomPlayer;
    private CardView mLastSelectedView;
    private int mCurrentPosition = -1;
    private View mExit;
    private Rect mViewPagerRect = new Rect();
    private TouchEventHolder mTouchEventHolder;
    private Runnable mLoadingTimeout = new Runnable(){

        @Override
        public void run() {
            if (SelectSameScreenWindow.this.mStatusLayout != null) {
                SelectSameScreenWindow.this.mStatusLayout.setVisibility(0);
                SelectSameScreenWindow.this.mStatusLayout.showError();
            }
        }
    };

    public SelectSameScreenWindow(Context context, UICallBacks sameScreenCallBack) {
        super(context, sameScreenCallBack, "SelectSameScreen");
        this.mSelectSameScreenController = (SelectSameScreenController)sameScreenCallBack;
        this.createViews();
        this.setNeedFullScreen(true);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        int count = SettingFlags.getIntValue((String)SAME_SCREEN_GUIDE_SHOW_COUNT, (int)0);
        if (count < 3) {
            this.getBaseLayer().addView((View)new SameScreenGuide(this.getContext()), (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            SettingFlags.setIntValue((String)SAME_SCREEN_GUIDE_SHOW_COUNT, (int)(++count));
        }
    }

    private void createViews() {
        this.getBaseLayer().setBackgroundColor(-1);
        this.mRootView = SelectSameScreenWindow.inflate((Context)this.getContext(), (int)R.layout.game_samescreen_select, null);
        this.getBaseLayer().addView(this.mRootView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.mRootView = this.findViewById(R.id.samescreenRoot);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.mSameGameViewPager = (ViewPager)this.findViewById(R.id.samescreen_viewpager);
        this.mTopPlayer = (SameScreenNameView)this.findViewById(R.id.samescreen_game_name_top);
        this.mBottomPlayer = (SameScreenNameView)this.findViewById(R.id.samescreen_game_name_bottom);
        this.mExit = this.findViewById(R.id.exit_select);
        this.mSameGameViewPager.setPageMargin(ResolutionUtils.dip2Px((float)16.0f));
        this.mSameGameViewPager.setPageTransformer(true, (ViewPager.PageTransformer)new SizeGradientPageTransform());
        this.mTouchEventHolder = new TouchEventHolder(this.getContext());
        this.mRootView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return SelectSameScreenWindow.this.delegateTouch(event);
            }
        });
        this.mSameGameViewPager.post(new Runnable(){

            @Override
            public void run() {
                SelectSameScreenWindow.this.mSameGameViewPager.getHitRect(SelectSameScreenWindow.this.mViewPagerRect);
            }
        });
        this.mExit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectSameScreenWindow.this.mSelectSameScreenController.exitSelect();
            }
        });
        this.mSameScreenAdapter = new SameScreenGameAdapter(this.getContext(), this.mSelectSameScreenController);
        this.mSameGameViewPager.setAdapter((PagerAdapter)this.mSameScreenAdapter);
        this.mSameGameViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                SelectSameScreenWindow.this.selectPager(position);
                ((IGameAudioService)SelectSameScreenWindow.this.mSelectSameScreenController.getServiceManager().getService(IGameAudioService.class)).play("samescreenSwitchGame");
            }

            public void onPageScrolled(int position, float offset, int offsetPixels) {
                super.onPageScrolled(position, offset, offsetPixels);
                SelectSameScreenWindow.this.mTopPlayer.scaleNameTv(Math.abs(offset - 0.5f) * 2.0f);
                SelectSameScreenWindow.this.mBottomPlayer.scaleNameTv(Math.abs(offset - 0.5f) * 2.0f);
            }
        });
        this.mStatusLayout.setRequestCallback(new IRequestCallback(){

            public void onRequest(int type) {
                if (SelectSameScreenWindow.this.checkNetAndLoading()) {
                    SelectSameScreenWindow.this.mSelectSameScreenController.querySameScreenGames();
                }
            }
        });
    }

    private boolean delegateTouch(MotionEvent event) {
        if (this.mViewPagerRect.contains((int)event.getX(), (int)event.getY())) {
            return this.mSameGameViewPager.dispatchTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.mTouchEventHolder.from(event.getX(), event.getY());
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.mTouchEventHolder.to(event.getX(), event.getY());
                if (!this.mTouchEventHolder.isClick()) break;
                MotionEvent mockEvent = MotionEvent.obtain((MotionEvent)event);
                mockEvent.setAction(3);
                this.mSameGameViewPager.dispatchTouchEvent(mockEvent);
                mockEvent.recycle();
                return true;
            }
            case 3: {
                break;
            }
        }
        return this.mSameGameViewPager.dispatchTouchEvent(event);
    }

    public void onShown() {
        super.onShown();
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024421").put("function_id", "show"));
        if (FP.empty(this.mSelectSameScreenController.getSameScreenDatas())) {
            this.checkNetAndLoading();
        } else {
            YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
            if (this.mStatusLayout != null) {
                this.mStatusLayout.hideAllStatus();
            }
            if (this.mCurrentPosition == -1) {
                this.onGameFetched();
            }
        }
    }

    private void onGameFetched() {
        if (this.mCurrentPosition == -1) {
            this.mCurrentPosition = 0;
        }
        this.mSameScreenAdapter.notifyDataSetChanged();
        this.mSameGameViewPager.setOffscreenPageLimit(this.mSelectSameScreenController.getSameScreenDatas().size());
        this.mSameGameViewPager.setCurrentItem(this.mCurrentPosition, false);
        this.selectPager(this.mCurrentPosition);
    }

    public void setCurrentPosition(int position) {
        if (this.mSameGameViewPager != null) {
            this.mSameGameViewPager.setCurrentItem(position, false);
            this.selectPager(position);
        }
    }

    public void updateData(List<SameScreenGameBean> list) {
        if (!FP.empty(list)) {
            YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
            if (this.mStatusLayout != null) {
                this.mStatusLayout.hideAllStatus();
            }
            this.onGameFetched();
        }
    }

    private void selectPager(int position) {
        String bgImgUrl;
        this.mCurrentPosition = position;
        if (this.mCurrentPosition > this.mSelectSameScreenController.getSameScreenDatas().size()) {
            return;
        }
        this.mSelectSameScreenController.setCurrentGid(position);
        SameScreenGameBean screenGameBean = this.mSelectSameScreenController.getSameScreenDatas().get(this.mCurrentPosition);
        if (this.mTopPlayer != null) {
            this.mTopPlayer.setGameName(screenGameBean.name, screenGameBean.bannerImgUrl);
        }
        if (this.mBottomPlayer != null) {
            this.mBottomPlayer.setGameName(screenGameBean.name, screenGameBean.bannerImgUrl);
        }
        if (this.mLastSelectedView != null) {
            this.mLastSelectedView.setCardElevation(0.0f);
        }
        if (!StringUtils.isEmpty((String)(bgImgUrl = this.mSelectSameScreenController.getSameScreenDatas().get((int)this.mCurrentPosition).gameBackGroundImgUrl))) {
            ImageLoader.loadBitmap((Context)this.getContext(), (String)this.resizeImageUrl(bgImgUrl), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                public void onLoadFailed(Exception e) {
                    SelectSameScreenWindow.this.setDefaultBackground();
                }

                public void onResourceReady(Bitmap bitmap) {
                    if (SelectSameScreenWindow.this.mRootView != null) {
                        BitmapDrawable drawable2 = new BitmapDrawable(SelectSameScreenWindow.this.getResources(), bitmap);
                        if (Build.VERSION.SDK_INT >= 16) {
                            SelectSameScreenWindow.this.mRootView.setBackground((Drawable)drawable2);
                        } else {
                            SelectSameScreenWindow.this.mRootView.setBackgroundDrawable((Drawable)drawable2);
                        }
                    }
                }
            });
        } else {
            this.setDefaultBackground();
        }
        this.selectedViewCover();
    }

    private String resizeImageUrl(String url) {
        int width = ScreenUtils.getInstance().getWidthPixels();
        int height = ScreenUtils.getInstance().getHeightPixels();
        return url + YYImageUtils.getThumbnailPostfixPx((int)width, (int)height, (boolean)false);
    }

    private void setDefaultBackground() {
        if (this.mRootView != null) {
            this.mRootView.setBackgroundResource(R.drawable.bg_game_same_screen_select);
        }
    }

    private void selectedViewCover() {
        this.mLastSelectedView = this.mSameScreenAdapter.getRootView(this.mCurrentPosition);
        if (this.mLastSelectedView != null) {
            this.mLastSelectedView.setCardElevation(CARD_SHADOW);
        } else if (this.mSameGameViewPager != null) {
            this.mSameGameViewPager.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SelectSameScreenWindow.this.selectedViewCover();
                }
            }, 100L);
        }
    }

    public void updateDownloadProgress(int position, float progress) {
        this.mSameScreenAdapter.updateDownedMark(position, progress);
    }

    private boolean checkNetAndLoading() {
        if (this.mStatusLayout == null) {
            return true;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.mStatusLayout.setVisibility(0);
            this.mStatusLayout.showNetworkError();
            return false;
        }
        this.mStatusLayout.setVisibility(0);
        this.mStatusLayout.showLoading();
        YYTaskExecutor.removeTask((Runnable)this.mLoadingTimeout);
        YYTaskExecutor.postToMainThread((Runnable)this.mLoadingTimeout, (long)5000L);
        return true;
    }

    private static class TouchEventHolder {
        private final int touchSlop;
        private float fromX;
        private float fromY;
        private float toX;
        private float toY;

        TouchEventHolder(Context context) {
            this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        }

        private boolean isClick() {
            return Math.abs(this.toX - this.fromX) < (float)this.touchSlop && Math.abs(this.toY - this.fromY) < (float)this.touchSlop;
        }

        public void from(float x, float y) {
            this.fromX = x;
            this.fromY = y;
        }

        public void to(float x, float y) {
            this.toX = x;
            this.toY = y;
        }
    }
}

