/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.samescreen.list;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.gamemodule.simplegame.samescreen.list.SelectSameScreenWindow;
import com.yy.game.module.gameload.LoadGamePageManager;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.base.MsgGameDefProvider;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.bean.SameScreenDataItem;
import com.yy.hiyo.game.base.bean.SameScreenGameBean;
import com.yy.hiyo.game.base.bean.SameScreenGameListRsp;
import com.yy.hiyo.game.base.helper.ModifyJsGameHelper;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.Call;

public class SelectSameScreenController
extends DefaultWindowController {
    private static final String TAG = "SelectSameScreenController";
    public static final String KEY_AUTO_DOWNLOAD = "KEY_AUTO_DOWNLOAD";
    public static final String KEY_AUTO_START = "KEY_AUTO_START";
    private List<SameScreenGameBean> mSameScreenGameBeans;
    private List<GameInfo> mGameInfos;
    private SelectSameScreenWindow mSelectSameScreenWindow;
    private String mDowningGame;
    String mCurrentShowedGid;
    private String mJumpGid;
    private String mAutoDownloadGameId;
    private String mLastResponse;
    private boolean needCheckNotify = false;
    public static List<GameInfo> sScreenGames = null;

    public SelectSameScreenController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.GAME_DOWNLOAD_FINISH, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.GAME_DOWNLOAD_ERROR, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
        this.mSameScreenGameBeans = new ArrayList<SameScreenGameBean>();
        this.mGameInfos = new ArrayList<GameInfo>();
    }

    public void showSelectWindow() {
        if (this.mSelectSameScreenWindow == null) {
            this.mSelectSameScreenWindow = new SelectSameScreenWindow((Context)this.mContext, (UICallBacks)this);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mSelectSameScreenWindow, true);
    }

    public List<SameScreenGameBean> getSameScreenDatas() {
        return this.mSameScreenGameBeans;
    }

    public void onSameScreenGameItemClick(final String gameId) {
        this.mAutoDownloadGameId = null;
        this.downloadAndStart(gameId, true, new Runnable(){

            @Override
            public void run() {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024421").put("function_id", "start_game").put("gid", gameId));
            }
        });
    }

    public void exitSelect() {
        this.mWindowMgr.popWindow(true, (AbstractWindow)this.mSelectSameScreenWindow);
        this.mSelectSameScreenWindow = null;
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mSelectSameScreenWindow == abstractWindow) {
            this.mSelectSameScreenWindow = null;
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == MsgGameDefProvider.SELECT_SAMESCREEN) {
            Bundle bundle;
            this.mJumpGid = (String)msg.obj;
            this.showSelectWindow();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"samescreen data is empty ,try query ", (Object[])new Object[0]);
            }
            this.querySameScreenGames();
            if (!FP.empty(this.mSameScreenGameBeans)) {
                this.jumpToTargetGame();
            }
            if ((bundle = msg.getData()) != null) {
                boolean autoDownload = bundle.getBoolean(KEY_AUTO_DOWNLOAD, false);
                boolean autoStart = bundle.getBoolean(KEY_AUTO_START, false);
                if (autoDownload && !FP.empty((CharSequence)this.mJumpGid)) {
                    this.mAutoDownloadGameId = this.mJumpGid;
                    GameInfo gameInfo = this.getSameScreenGameInfo(this.mAutoDownloadGameId);
                    if (gameInfo != null) {
                        this.downloadAndStart(this.mAutoDownloadGameId, autoStart, null);
                    }
                }
            }
        } else if (msg.what == MsgGameDefProvider.QUERY_SAMESCREEN_GAMES) {
            this.querySameScreenGames();
        }
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationIdDef.GAME_DOWNLOAD_FINISH) {
            if (notification.extObj instanceof GameInfo) {
                GameInfo info = (GameInfo)notification.extObj;
                String downloadSucceedGid = info.getGid();
                if (downloadSucceedGid.equals(this.mCurrentShowedGid) && downloadSucceedGid.equals(this.mDowningGame) && this.mSelectSameScreenWindow != null) {
                    if (!this.mCurrentShowedGid.equals(this.mAutoDownloadGameId)) {
                        this.startGame((GameInfo)notification.extObj);
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024421").put("function_id", "start_game").put("gid", this.mCurrentShowedGid));
                    }
                    this.mAutoDownloadGameId = null;
                }
                this.unWatchDownload(info);
            }
        } else if (notification.id == NotificationIdDef.GAME_DOWNLOAD_ERROR) {
            if (notification.extObj instanceof GameInfo) {
                GameInfo info = (GameInfo)notification.extObj;
                this.unWatchDownload(info);
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS && this.needCheckNotify) {
            this.notifySameScreenChanged();
        }
        super.notify(notification);
    }

    public void querySameScreenGames() {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("gameMode", "2");
        HttpUtil.httpReq((String)UriProvider.generateGameListApiUrl((String)"/gameMeta/go/getListByMode"), params, (int)2, (INetRespCallback)new INetRespCallback<SameScreenGameListRsp>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)SelectSameScreenController.TAG, (String)"querySameScreenGames onError ", (Throwable)e, (Object[])new Object[0]);
            }

            public void onResponse(String response, BaseResponseBean<SameScreenGameListRsp> res, int id2) {
                List items;
                if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)SelectSameScreenController.TAG, (String)"querySameScreenGames response %s", (Object[])new Object[]{response});
                }
                if (StringUtils.equal((String)SelectSameScreenController.this.mLastResponse, (String)response)) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SelectSameScreenController.TAG, (String)"is the same response", (Object[])new Object[0]);
                    }
                    return;
                }
                SelectSameScreenController.this.mLastResponse = response;
                if (res != null && res.isSuccess() && res.data != null && (items = SelectSameScreenController.this.modifyGameList(((SameScreenGameListRsp)res.data).list)) != null && items.size() > 0) {
                    SelectSameScreenController.this.mSameScreenGameBeans.clear();
                    for (SameScreenDataItem sameScreenDataItem : items) {
                        SelectSameScreenController.this.mSameScreenGameBeans.add(sameScreenDataItem.gameBean);
                    }
                    SelectSameScreenController.this.checkWaitingOffline(SelectSameScreenController.this.mSameScreenGameBeans);
                    if (SelectSameScreenController.this.mSelectSameScreenWindow != null) {
                        SelectSameScreenController.this.mSelectSameScreenWindow.updateData(SelectSameScreenController.this.mSameScreenGameBeans);
                    }
                    SelectSameScreenController.this.parseGameInfo(SelectSameScreenController.this.mSameScreenGameBeans);
                    SelectSameScreenController.this.jumpToTargetGame();
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20027427").put("function_id", "2").put("event_time", String.valueOf(System.currentTimeMillis())).put("error_code", "0").put("game_type", "2");
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)SelectSameScreenController.TAG, (String)JsonParser.toJson((Object)hiidoEvent), (Object[])new Object[0]);
                            }
                            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
                        }
                    });
                }
            }
        });
    }

    private void checkWaitingOffline(List<SameScreenGameBean> list) {
        HashMap<String, Integer> gameIdMap = new HashMap<String, Integer>();
        if (!FP.empty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                SameScreenGameBean item = list.get(i);
                if (item == null || !item.isWaitingOffline) continue;
                gameIdMap.put(item.id, i);
            }
        }
        if (!FP.empty(gameIdMap)) {
            for (Map.Entry entry : gameIdMap.entrySet()) {
                if (entry == null) continue;
                int position = (Integer)entry.getValue();
                if (this.getServiceManager() == null || this.getServiceManager().getService(IGameInfoService.class) == null) continue;
                if (((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).isOftenPlayUser((String)entry.getKey())) {
                    SameScreenGameBean dataItem = list.remove(position);
                    list.add(dataItem);
                    continue;
                }
                list.remove(position);
            }
        }
    }

    private void jumpToTargetGame() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)SelectSameScreenController.this.mJumpGid)) {
                    int position = 0;
                    for (SameScreenGameBean bean : SelectSameScreenController.this.mSameScreenGameBeans) {
                        if (!bean.id.equals(SelectSameScreenController.this.mJumpGid)) continue;
                        position = SelectSameScreenController.this.mSameScreenGameBeans.indexOf(bean);
                        break;
                    }
                    if (null != SelectSameScreenController.this.mSelectSameScreenWindow) {
                        SelectSameScreenController.this.mSelectSameScreenWindow.setCurrentPosition(position);
                    }
                }
            }
        }, (long)400L);
    }

    void setCurrentGid(int position) {
        if (this.mGameInfos.size() > position) {
            this.mCurrentShowedGid = this.mGameInfos.get(position).getGid();
            this.report(this.mCurrentShowedGid);
        }
    }

    private void report(String gid) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025783").put("gid", gid).put("game_type", "3"));
    }

    private void parseGameInfo(List<SameScreenGameBean> sameScreenGameBeans) {
        this.mGameInfos.clear();
        sScreenGames = new ArrayList<GameInfo>();
        for (SameScreenGameBean sameScreenGameBean : sameScreenGameBeans) {
            GameInfo info = SelectSameScreenController.convertItemToInfo(sameScreenGameBean);
            this.mGameInfos.add(info);
            sScreenGames.add(info);
        }
        if (!FP.empty((CharSequence)this.mAutoDownloadGameId)) {
            this.downloadAndStart(this.mAutoDownloadGameId, false, null);
        }
        this.notifySameScreenChanged();
    }

    private void notifySameScreenChanged() {
        if (!FP.empty(this.mGameInfos) && this.getServiceManager() != null && this.getServiceManager().getService(IGameInfoService.class) != null) {
            ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).updateSameScreenGameInfo(this.mGameInfos);
        } else {
            this.needCheckNotify = true;
        }
    }

    private int getPositionByGid(String gid) {
        for (int index = 0; index < this.mGameInfos.size(); ++index) {
            GameInfo gameInfo = this.mGameInfos.get(index);
            if (!gid.equals(gameInfo.getGid())) continue;
            return index;
        }
        return -1;
    }

    private GameInfo getSameScreenGameInfo(String gid) {
        int index = this.getPositionByGid(gid);
        if (index != -1) {
            return this.mGameInfos.get(index);
        }
        return null;
    }

    public void downloadAndStart(String gameId, boolean autoStart, Runnable startCallback) {
        block13: {
            try {
                GameInfo gameInfo = this.getSameScreenGameInfo(gameId);
                if (gameInfo == null) {
                    return;
                }
                if (this.getServiceManager() == null || this.getServiceManager().getService(IGameService.class) == null) {
                    return;
                }
                if (!((IGameService)this.getServiceManager().getService(IGameService.class)).checkMinSupportVersion(gameId)) {
                    return;
                }
                boolean useRemote = RemoteGameDebugService.Companion.useRemoteIp(gameId);
                if (useRemote) {
                    GameDownloadUtils.deleteAllGameDebug();
                }
                boolean isValid = !useRemote && ((IGameService)this.getServiceManager().getService(IGameService.class)).isGameValid(gameInfo);
                this.setCurrentGid(this.getPositionByGid(gameId));
                if (isValid) {
                    if (autoStart) {
                        this.startGame(gameInfo);
                        if (startCallback != null) {
                            startCallback.run();
                        }
                    }
                } else {
                    if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.str_network_not_capable), (int)0);
                        return;
                    }
                    this.mDowningGame = gameInfo.getGid();
                    if (this.mSelectSameScreenWindow != null) {
                        this.mSelectSameScreenWindow.updateDownloadProgress(this.getPositionByGid(this.mDowningGame), 0.0f);
                    }
                    Kvo.autoBindingTo((KvoSource)gameInfo.downloadInfo, (Object)((Object)this));
                    gameInfo.downloadInfo.setFrom(GameDownloadInfo.DownloadFrom.sameScreen);
                    ((IGameService)this.getServiceManager().getService(IGameService.class)).downloadGame(gameInfo);
                    LoadGamePageManager.getInstance().preLoadGamePage(this.mDowningGame);
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"onSameScreenGameItemClick isValid %s", (Object[])new Object[]{isValid});
                }
            }
            catch (Exception e) {
                if (!MLog.isLogLevelBlowInfo()) break block13;
                MLog.info((Object)TAG, (String)"onSameScreenGameItemClick error %s", (Object[])new Object[0]);
            }
        }
    }

    @KvoMethodAnnotation(name="progress", sourceClass=GameDownloadInfo.class, thread=1)
    public void onUpdateProgress(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onUpdateProgress gid: %s, state: %s, cur: %s, total: %s", (Object[])new Object[]{info.gameId, info.getState(), info.getProgress(), info.getTotalBytes()});
        }
        if (info.getState() != GameDownloadInfo.DownloadState.downloading || this.isSilentDownload(info)) {
            return;
        }
        this.updateProgress(info);
    }

    private void updateProgress(GameDownloadInfo info) {
        if (info != null) {
            this.updateDownloadProgress(info.gameId, info.getTotalBytes(), info.getProgress());
        }
    }

    private boolean isSilentDownload(GameDownloadInfo info) {
        return info.downloadType == GameDownloadInfo.DownloadType.silent;
    }

    private void unWatchDownload(GameInfo info) {
        if (info != null) {
            Kvo.autoUnbindingFrom((KvoSource)info.downloadInfo, (Object)((Object)this));
        }
    }

    private void startGame(GameInfo gameInfo) {
        if (this.getServiceManager() != null && this.getServiceManager().getService(IGameCenterService.class) != null) {
            ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, new GamePlayContext(GameContextDef.JoinFrom.FROM_DEFAULT));
            this.mAutoDownloadGameId = null;
        }
    }

    private void updateDownloadProgress(String gid, long total, long cur) {
        if (this.mSelectSameScreenWindow != null) {
            this.mSelectSameScreenWindow.updateDownloadProgress(this.getPositionByGid(gid), (float)cur * 1.0f / (float)total);
        }
    }

    public static GameInfo convertItemToInfo(@NonNull SameScreenGameBean screenGameBean) {
        return GameInfo.newBuilder((GameInfoSource)GameInfoSource.SAMESCEEN).gid(screenGameBean.id).gname(screenGameBean.name).desc(screenGameBean.desc).iconUrl(screenGameBean.iconUrl).modulerUrl(screenGameBean.modulerUrl).modulerMd5(screenGameBean.modulerMd5).modulerVer(screenGameBean.modulerVer).fixing(screenGameBean.fixing).defLang(screenGameBean.defLang).langList(screenGameBean.langList).screenDire(screenGameBean.screenDire).gameMode(screenGameBean.gameMode).gameType(screenGameBean.gameType).isFull(screenGameBean.isFull).minSupportAppVersion(screenGameBean.minSupportApp).isBetaTest(screenGameBean.isBetaTest).isWaitingOffline(screenGameBean.isWaitingOffline).socketType(screenGameBean.socketType).moduleGray(screenGameBean.moduleGray).build();
    }

    private List<SameScreenDataItem> modifyGameList(List<SameScreenDataItem> list) {
        ArrayList<SameScreenDataItem> tempOriginList = new ArrayList<SameScreenDataItem>(list);
        CopyOnWriteArrayList<SameScreenGameBean> gameList = new CopyOnWriteArrayList<SameScreenGameBean>();
        for (SameScreenDataItem dataItem : tempOriginList) {
            gameList.add(dataItem.gameBean);
        }
        ModifyJsGameHelper.Companion.modifyJsSameScreenGame(gameList, tempOriginList);
        return tempOriginList;
    }
}

