/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.samescreen;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.gamemodule.base.NormalGamePlayer;
import com.yy.game.gamemodule.base.gameview.BaseGameView;
import com.yy.game.gamemodule.base.gameview.IGameView;
import com.yy.game.gamemodule.base.gameview.WindowGameView;
import com.yy.game.gamemodule.simplegame.ISimpleGameCallback;
import com.yy.game.gamemodule.simplegame.ISimpleGameUICallback;
import com.yy.game.gamemodule.simplegame.SimpleGameAppsFlyerReporter;
import com.yy.game.gamemodule.simplegame.SimpleGameHiidoReporter;
import com.yy.game.gamemodule.simplegame.SimpleGameType;
import com.yy.game.gamemodule.simplegame.SimpleGameWindow;
import com.yy.game.growth.GameExitHelper;
import com.yy.game.module.gameroom.ui.GameWindowConfig;
import com.yy.hiyo.game.base.bean.IGameDialogCallback;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import java.util.HashMap;
import java.util.Vector;
import javax.annotation.Nonnull;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class SameScreenGamePlayer
extends NormalGamePlayer
implements ISimpleGameUICallback {
    private static final String TAG = "SameScreenGamePlayer";
    private long mSameScreenGameStartTime = 0L;
    private static final int SCREEN_LANDSCAPE_TYPE = 2;
    private ISimpleGameCallback mSimpleGameCallback = new ISimpleGameCallback(){

        @Override
        public String getGameId() {
            if (SameScreenGamePlayer.this.gameRunningContext != null && SameScreenGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                return SameScreenGamePlayer.this.gameRunningContext.getGameInfo().getGid();
            }
            return "";
        }

        @Override
        public SimpleGameType getGameType() {
            return SimpleGameType.SAMESCREEN;
        }

        @Override
        public void showExitDialog() {
            SameScreenGamePlayer.this.onBackClick();
        }
    };

    SameScreenGamePlayer(Environment env, IGameLifecycle callback2) {
        super(env, callback2);
    }

    @Override
    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
    }

    @Override
    public int preLoadGame(GamePlayContext context) {
        if (context != null && context.getGameInfo() != null) {
            return 0;
        }
        if (RuntimeContext.sIsDebuggable) {
            throw new IllegalArgumentException("onPreloadGame game info is null.");
        }
        return 1;
    }

    @Override
    public void onPreloadGameInner(@Nonnull GamePlayContext context) {
        super.onPreloadGameInner(context);
        this.getBaseGameView().showGameView();
        this.getBaseGameView().loadGameView();
        ((IGameAudioService)this.getServiceManager().getService(IGameAudioService.class)).play("samescreenSelectGame");
    }

    @Override
    public void onLoadGameFinishInner(GamePlayContext context, int finishType) {
        super.onLoadGameFinishInner(context, finishType);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("SingleGamePlayer onLoadGameFinish = " + finishType), (Object[])new Object[0]);
        }
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        if (finishType == 0) {
            if (this.getBaseGameView() != null) {
                this.getBaseGameView().hideGameLoading();
            }
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_loading_fail), (int)0);
            this.exitRoom(1006, 2);
            SimpleGameHiidoReporter.reportGameLoadFailed(context.getGameInfo().getGid());
        }
    }

    @Override
    public void onPlayGameStartInner(GamePlayContext context) {
        super.onPlayGameStartInner(context);
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        SimpleGameAppsFlyerReporter.reportSameScreenStart();
        SimpleGameHiidoReporter.reportGameLoad(context.getGameInfo().getGid(), context.getGameInfo().getGameMode());
    }

    @Override
    public void leaveGameExt() {
        this.exitRoom(1004, 2);
    }

    @Override
    public void onPlayGameFinishInner(GamePlayContext context, int finishType) {
        super.onPlayGameFinishInner(context, finishType);
        if (context == null || context.getGameInfo() == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException("game play context or info can not be null");
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("SingleGamePlayer onPlayGameFinish = " + finishType), (Object[])new Object[0]);
        }
        if (finishType == 1 || finishType == 2) {
            this.exitRoom(1);
            SimpleGameHiidoReporter.reportGameLoadSuccess(context.getGameInfo().getGid());
        }
        if (finishType == 1) {
            SimpleGameHiidoReporter.reportSameScreenGameFinish(context.getGameInfo().getGid());
        }
        SimpleGameHiidoReporter.reportGameShow(context.getGameInfo().getGid());
    }

    @Override
    public CocosProxyType[] getSupportedCocosProxyType() {
        return new CocosProxyType[0];
    }

    @Override
    public void onReceiveGameEvent(String context, long seqId, int event, Vector<String> args) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"SameScreenPlayer onReceiveGameEvent: %d", (Object[])new Object[]{event});
        }
    }

    @Override
    public void onPreGameExitInner(GamePlayContext context) {
        super.onPreGameExitInner(context);
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        this.showGameExitDialog();
        SimpleGameHiidoReporter.reportGameExit(context.getGameInfo().getGid(), 2);
    }

    @Override
    public void onGameExitedInner(GamePlayContext context, int exitType) {
        super.onGameExitedInner(context, exitType);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"SameScreenPlayer onGameExitedInner", (Object[])new Object[0]);
        }
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        this.hideGameExitDialog();
        this.getBaseGameView().destroyGameView();
        this.saveGuestPlayGameCount();
        if (this.mSameScreenGameStartTime > 0L) {
            SimpleGameHiidoReporter.reportSameScreenGameDuration(context.getGameInfo().getGid(), this.mSameScreenGameStartTime);
            this.mSameScreenGameStartTime = 0L;
        }
        if (exitType == 1) {
            ((IGameAudioService)this.getServiceManager().getService(IGameAudioService.class)).play("samescreenGameOver");
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("reportType", "1");
            params.put("gameId", context.getGameInfo().getGid());
            HttpUtil.httpReq((String)UriProvider.generateApiUrl((String)"/single/sameScreen/report"), params, (int)2, null);
        }
    }

    @Override
    protected void onBackClick() {
        super.onBackClick();
        String gid = "";
        if (this.gameRunningContext != null && this.gameRunningContext.getGameInfo() != null) {
            gid = this.gameRunningContext.getGameInfo().getGid();
        }
        GameExitHelper.INSTANCE.callBeforeExit(gid, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

            public Unit invoke(Boolean needConfirm) {
                if (needConfirm.booleanValue()) {
                    if (SameScreenGamePlayer.this.getBaseGameView() != null) {
                        SameScreenGamePlayer.this.getBaseGameView().showExitConfirmDialog(ResourceUtils.getString((int)R.string.samescreen_game_exit_confirm), ResourceUtils.getString((int)R.string.dialog_btn_yes), ResourceUtils.getString((int)R.string.dialog_btn_no), new IGameDialogCallback(){

                            public void onOk() {
                                SameScreenGamePlayer.this.exitRoom(1002, 2);
                            }

                            public void onCancel() {
                            }
                        });
                    } else {
                        SameScreenGamePlayer.this.exitRoom(2);
                    }
                } else {
                    SameScreenGamePlayer.this.exitRoom(2);
                }
                return null;
            }
        });
    }

    private void saveGuestPlayGameCount() {
        if (AccountUtil.isLoginByGuest()) {
            long lastTime = SettingFlags.getLongValue((String)"play_game_time");
            if (lastTime <= 0L) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"KEY_PLAY_GAME lastTime <= 0", (Object[])new Object[0]);
                }
                SettingFlags.increase((String)"play_game_count");
            } else if (System.currentTimeMillis() - lastTime > 86400000L) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"KEY_PLAY_GAME >", (Object[])new Object[0]);
                }
                SettingFlags.increase((String)"play_game_count");
            }
        }
    }

    @Override
    public void showGameExitDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)R.string.game_exit), true, true, null));
        }
    }

    @Override
    public void hideGameExitDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    public BaseGameView<? extends IGameView> initGameView() {
        GameWindowConfig gameWindowConfig = new GameWindowConfig(this.gameRunningContext.getGameInfo().isSupportFullScreen());
        SimpleGameWindow simpleGameWindow = new SimpleGameWindow((Context)this.mContext, (UICallBacks)this, this.mSimpleGameCallback, AbstractWindow.WindowLayerType.USE_ALL_LAYER, 103, gameWindowConfig);
        if (this.gameRunningContext.getGameInfo().getScreenDire() == 2) {
            simpleGameWindow.setScreenOrientationType(0);
        } else {
            simpleGameWindow.setScreenOrientationType(3);
        }
        return new WindowGameView(simpleGameWindow, this.mIWindowGameViewCallback);
    }
}

