/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.protocol;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.service.IUserInfoService;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.game.gamemodule.simplegame.protocol.callback.ISimpleGameProtoCallback;
import com.yy.hiyo.game.GameBaseMsgDef;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.ERet;
import common.Header;
import ikxd.pkgame.IKXDPKGameUri;
import ikxd.pkgame.IKXDPkGameProto;
import ikxd.pkgame.PPkGameSinglePlayerGameReq;
import ikxd.pkgame.PPkGameSinglePlayerGameRes;
import java.util.HashMap;
import okhttp3.Call;

public class SimpleGameProtoController
extends DefaultController {
    private static final String TAG = "SimpleGameProtoController";
    private SingleGameUrlProtoHolder singleGameUrlProtoHolder;
    private IProtoCallback<IKXDPkGameProto> pkGameCallback = new IProtoCallback<IKXDPkGameProto>(){

        public void onResponse(@Nullable IKXDPkGameProto proto) {
            if (proto == null) {
                return;
            }
            switch (proto.uri) {
                case kUriIKXDPKGameSinglePlayerGameRes: {
                    SimpleGameProtoController.this.onGetSingleGameUrl(proto.header, proto.single_player_game_res);
                    break;
                }
            }
        }

        public boolean retryWhenTimeout(boolean canRetry) {
            return true;
        }

        public boolean retryWhenError(boolean canRetry, String reason, int code) {
            return true;
        }
    };

    public SimpleGameProtoController(Environment env) {
        super(env);
    }

    public void reportSingleGameStart(GameModel gameModel, String roomId) {
        String gameId = "";
        HashMap<String, String> params = new HashMap<String, String>();
        if (gameModel != null && gameModel.getGameInfo() != null) {
            Object result;
            gameId = gameModel.getGameInfo().getGid();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"[reportSingleGameStart] gameId: %s", (Object[])new Object[]{gameId});
            }
            if ((result = MsgDispatcher.getInstance().sendMessageSync(GameBaseMsgDef.CallOutSide.IS_ACTIVITY_SYNC, (Object)gameModel)) instanceof Boolean && ((Boolean)result).booleanValue()) {
                params.put("isActivity", "true");
                params.put("activityMethodUri", (String)MsgDispatcher.getInstance().sendMessageSync(GameBaseMsgDef.CallOutSide.GET_ACTIVITY_ID_SYNC, (Object)gameModel));
            }
        }
        params.put("gameId", gameId);
        params.put("roomId", roomId);
        String reportUrl = "";
        if (gameModel != null && gameModel.getGameInfo() != null) {
            int gameMode = gameModel.getGameInfo().getGameMode();
            if (gameMode == 3) {
                reportUrl = "/single/join";
            } else if (gameMode == 6) {
                reportUrl = "/gameRoom/join";
            }
        } else {
            return;
        }
        HttpUtil.httpReq((String)(UriProvider.getIkxdApiHost() + reportUrl), params, (int)2, (INetRespCallback)new INetRespCallback<Void>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)SimpleGameProtoController.TAG, (String)"[reportSingleGameStart]", (Throwable)e, (Object[])new Object[0]);
            }

            public void onResponse(String response, BaseResponseBean<Void> res, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)SimpleGameProtoController.TAG, (String)"[reportSingleGameStart] response: %s", (Object[])new Object[]{response});
                }
            }
        });
    }

    @Nullable
    private UserInfoBean getMyUserInfo() {
        return ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
    }

    public void sendGetSingleGameUrl(String gameId, String roomId, String payload, String jsPayload, boolean createNewIfNoRoom, ISimpleGameProtoCallback.IGetSingleGameUrlCallback callback2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"[sendGetSingleGameUrl] gameId: %s", (Object[])new Object[]{gameId});
        }
        if (!TextUtils.isEmpty((CharSequence)gameId)) {
            UserInfoBean myUserInfo = this.getMyUserInfo();
            this.singleGameUrlProtoHolder = new SingleGameUrlProtoHolder();
            this.singleGameUrlProtoHolder.gameId = gameId;
            this.singleGameUrlProtoHolder.callback = callback2;
            if (myUserInfo != null) {
                PPkGameSinglePlayerGameReq.Builder builder = new PPkGameSinglePlayerGameReq.Builder().game_id(gameId).nick(myUserInfo.getNick() == null ? "" : myUserInfo.getNick()).avatar_url(myUserInfo.getAvatar() == null ? "" : myUserInfo.getAvatar()).sex(Long.valueOf(myUserInfo.getSex())).room_id(roomId == null ? "" : roomId).create_nx(Boolean.valueOf(createNewIfNoRoom));
                builder.source(jsPayload);
                PPkGameSinglePlayerGameReq req = builder.build();
                Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
                this.singleGameUrlProtoHolder.seqId = header.seqid;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"[sendGetSingleGameUrl] gameId: %s, seqId: %d", (Object[])new Object[]{gameId, header.seqid});
                }
                IKXDPkGameProto proto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriIKXDPKGameSinglePlayerGameReq).single_player_game_req(req).build();
                ProtoManager.getInstance().send((AndroidMessage)proto, this.pkGameCallback);
            } else {
                MLog.error((Object)TAG, (String)"[sendGetSingleGameUrl] can not get user info", (Object[])new Object[0]);
                this.singleGameUrlProtoHolder.call(ERet.kRetErrParameter.getValue(), "", "");
            }
        }
    }

    public void clearGetSingleGameUrlReq() {
        this.singleGameUrlProtoHolder = null;
    }

    private void onGetSingleGameUrl(Header header, PPkGameSinglePlayerGameRes singlePlayerGameRes) {
        if (header == null || singlePlayerGameRes == null) {
            MLog.error((Object)TAG, (String)"[onGetSingleGameUrl] wrong res, something null", (Object[])new Object[0]);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"[onGetSingleGameUrl] result: %d, seqId: %d", (Object[])new Object[]{header.code, header.seqid});
        }
        if (this.singleGameUrlProtoHolder != null && this.singleGameUrlProtoHolder.seqId == header.seqid) {
            String url = "";
            String roomId = "";
            if (header.code == (long)ERet.kRetSuccess.getValue()) {
                url = singlePlayerGameRes.resource == null ? "" : singlePlayerGameRes.resource.url;
                roomId = singlePlayerGameRes.resource == null ? "" : singlePlayerGameRes.resource.roomId;
            }
            this.singleGameUrlProtoHolder.call(header.code.intValue(), url, roomId);
            this.singleGameUrlProtoHolder = null;
        } else {
            MLog.error((Object)TAG, (String)"[onGetSingleGameUrl] not match req", (Object[])new Object[0]);
        }
    }

    private static class SingleGameUrlProtoHolder {
        public long seqId;
        public String gameId;
        public ISimpleGameProtoCallback.IGetSingleGameUrlCallback callback;

        private SingleGameUrlProtoHolder() {
        }

        public void call(int res, String url, String roomId) {
            if (this.callback != null) {
                this.callback.onGetSingleGameUrl(res, this.gameId, url, roomId);
            }
        }
    }
}

