/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame.indie;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.service.model.RoomUserMicStatus;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.gamemodule.BaseGameCallAppRouter;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.NormalGamePlayer;
import com.yy.game.gamemodule.base.gameview.BaseGameView;
import com.yy.game.gamemodule.base.gameview.IGameView;
import com.yy.game.gamemodule.base.gameview.WindowGameView;
import com.yy.game.gamemodule.simplegame.ISimpleGameCallback;
import com.yy.game.gamemodule.simplegame.ISimpleGameUICallback;
import com.yy.game.gamemodule.simplegame.SimpleGameHiidoReporter;
import com.yy.game.gamemodule.simplegame.SimpleGameType;
import com.yy.game.gamemodule.simplegame.SimpleGameWindow;
import com.yy.game.gamemodule.simplegame.indie.IIndieGameCallAppCallback;
import com.yy.game.gamemodule.simplegame.indie.IndieGameCallAppRouter;
import com.yy.game.gamemodule.simplegame.indie.IndieGameInfoInvalid;
import com.yy.game.gamemodule.simplegame.protocol.SimpleGameProtoController;
import com.yy.game.gamemodule.simplegame.protocol.callback.ISimpleGameProtoCallback;
import com.yy.game.growth.GameExitHelper;
import com.yy.game.module.gameroom.ui.GameLoadingPage;
import com.yy.game.module.gameroom.ui.GameWindowConfig;
import com.yy.game.module.jscallappmodule.model.GetRelationBean;
import com.yy.game.utils.GameReportHelper;
import com.yy.game.utils.GameStateDef;
import com.yy.game.utils.Utils;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.IGameDialogCallback;
import com.yy.hiyo.game.base.helper.GameReportV1;
import com.yy.hiyo.game.base.singlegame.indie.GameAction;
import com.yy.hiyo.game.base.singlegame.indie.IndieGamePlayContext;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.pkgame.PkGamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.voice.base.bean.GameUserSpeakStatus;
import com.yy.hiyo.voice.base.bean.MicStatusBean;
import com.yy.hiyo.voice.base.bean.UserSpeakStatus;
import com.yy.hiyo.voice.base.roomvoice.AbsVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.IRoomLifeCycleCallback;
import com.yy.hiyo.voice.base.roomvoice.IRoomManagerService;
import com.yy.hiyo.voice.base.roomvoice.RoomSlot;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import common.ERet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.annotation.Nonnull;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class IndieGamePlayer
extends NormalGamePlayer
implements ISimpleGameProtoCallback.IGetSingleGameUrlCallback,
ISimpleGameUICallback,
IIndieGameCallAppCallback {
    private static final Long GAME_EXIT_TIMEOUT = 500L;
    private final SimpleGameProtoController mSimpleGameProtoController;
    private static final String TAG = "IndieGamePlayer";
    private static final Long GAME_TIMEOUT = 20000L;
    private GameModel mGameModel;
    private long mOtherUid;
    private RoomSlot mRoomSlot;
    private int mShowAppVolumeType = 0;
    private static final int SCREEN_LANDSCAPE_TYPE = 2;
    private Map<Long, Integer> mSpeakStatus = new HashMap<Long, Integer>();
    private ISimpleGameCallback mSimpleGameCallback = new ISimpleGameCallback(){

        @Override
        public String getGameId() {
            if (IndieGamePlayer.this.gameRunningContext != null && IndieGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                return IndieGamePlayer.this.gameRunningContext.getGameInfo().getGid();
            }
            return "";
        }

        @Override
        public SimpleGameType getGameType() {
            return SimpleGameType.INDIE;
        }

        @Override
        public void showExitDialog() {
        }
    };
    private Runnable mExitRunable = new YYTaskExecutor.RunnableEx(){

        public void run() {
            IndieGamePlayer.this.exitRoom(1002, 2);
            if (IndieGamePlayer.this.gameRunningContext != null && IndieGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20029429").put("function_id", "protection_begin").put("gid", ((IndieGamePlayer)IndieGamePlayer.this).gameRunningContext.getGameInfo().gid));
            }
        }
    };
    private Runnable getUrlTimer = new Runnable(){

        @Override
        public void run() {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.game_loading_fail), (int)0);
            IndieGamePlayer.this.exitRoom(8);
        }
    };
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public IndieGamePlayer(Environment env, IGameLifecycle callback2) {
        super(env, callback2);
        this.mSimpleGameProtoController = new SimpleGameProtoController(env);
    }

    @Override
    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
    }

    @Override
    public int preLoadGame(GamePlayContext context) {
        if (context != null && context.getGameInfo() != null) {
            return 0;
        }
        if (RuntimeContext.sIsDebuggable) {
            throw new IllegalArgumentException("onPreloadGame game info is null.");
        }
        return 1;
    }

    @Override
    public void onLoadGameFinishInner(GamePlayContext context, int finishType) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("SingleGamePlayer onLoadGameFinish = " + finishType), (Object[])new Object[0]);
        }
        if (finishType == 0) {
            YYTaskExecutor.removeTask((Runnable)this.getUrlTimer);
            if (this.getBaseGameView() != null) {
                this.getBaseGameView().hideGameLoading();
            }
        } else {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_loading_fail), (int)0);
            this.exitRoom(16);
            if (context != null && context.getGameInfo() != null) {
                SimpleGameHiidoReporter.reportGameLoadFailed(context.getGameInfo().getGid());
            }
        }
        GameReportV1.Companion.reportGameStartPlayedTime(this.gameRunningContext.getGameInfo().getGid(), 0L, Integer.toString(finishType), "");
        if (context != null && this.isFromGameGroup(context.mFrom)) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "enter_urala_game_show").put("gameid", context.getGameInfo().gid));
        }
    }

    @Override
    public void onPreloadGameInner(@Nonnull GamePlayContext context) {
        super.onPreloadGameInner(context);
        this.getBaseGameView().showGameView();
        if (context instanceof IndieGamePlayContext) {
            this.getSingleGameUrl(context.getGameInfo(), context.getRoomId(), ((IndieGamePlayContext)context).getPayload(), ((IndieGamePlayContext)context).getGameAction());
        } else if (context instanceof PkGamePlayContext) {
            this.onGetSingleGameUrl(0, context.getGameInfo().gid, context.getGameUrl(), context.getRoomId());
        } else {
            this.getSingleGameUrl(context.getGameInfo(), context.getRoomId(), "", null);
        }
    }

    @Override
    public void leaveGameExt() {
        this.exitRoom(7);
    }

    @Override
    public void onPlayGameStartInner(GamePlayContext context) {
        super.onPlayGameStartInner(context);
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"IndieGamePlayer onPlayGameStart", (Object[])new Object[0]);
        }
        if (this.mSimpleGameProtoController != null && this.mGameModel != null) {
            this.mSimpleGameProtoController.reportSingleGameStart(this.mGameModel, this.mGameModel.getRoomid());
        }
        SimpleGameHiidoReporter.reportGameLoad(context.getGameInfo().getGid(), context.getGameInfo().getGameMode());
    }

    @Override
    public void onPlayGameFinishInner(GamePlayContext context, int finishType) {
        super.onPlayGameFinishInner(context, finishType);
        if (context == null || context.getGameInfo() == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException("game play context or info can not be null");
            }
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("SingleGamePlayer onPlayGameFinish = " + finishType), (Object[])new Object[0]);
        }
        if (finishType == 1 || finishType == 2) {
            this.exitRoom(1);
        }
        SimpleGameHiidoReporter.reportGameLoadSuccess(context.getGameInfo().getGid());
        SimpleGameHiidoReporter.reportGameShow(context.getGameInfo().getGid());
    }

    @Override
    public void onPreGameExitInner(GamePlayContext context) {
        super.onPreGameExitInner(context);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"SingleGamePlayer onPreGameExitInner", (Object[])new Object[0]);
        }
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mExitRunable);
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        this.showGameExitDialog();
        YYTaskExecutor.removeTask((Runnable)this.getUrlTimer);
        if (this.mSimpleGameProtoController != null) {
            this.mSimpleGameProtoController.clearGetSingleGameUrlReq();
        }
    }

    @Override
    public void onGameExitedInner(GamePlayContext context, int exitType) {
        Object showResult;
        super.onGameExitedInner(context, exitType);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"SingleGamePlayer onGameExitedInner", (Object[])new Object[0]);
        }
        if (context == null || context.getGameInfo() == null) {
            return;
        }
        HashMap ext = this.gameRunningContext.getExtendData();
        if (ext != null && (showResult = ext.get("key_show_result_mode")) instanceof String && StringUtils.equal((String)((String)showResult), (String)"2")) {
            this.setGameExitType(11);
        }
        this.hideGameExitDialog();
        this.getBaseGameView().destroyGameView();
        this.mShowAppVolumeType = 0;
        this.leaveVoiceRoom();
        if (context.mFrom == GameContextDef.JoinFrom.FROM_INDIE_GAME_INVITE || this.isFromGameGroup(context.mFrom)) {
            this.goToChannel(context);
        } else if (this.canGoToIm()) {
            this.gotoIM();
        }
    }

    private boolean canGoToIm() {
        return this.gameResultWebBean != null && this.gameResultWebBean.getExt() != null && this.gameResultWebBean.getExt().getMatchMode() == 1;
    }

    private void goToChannel(@NonNull GamePlayContext context) {
        String channelId = (String)context.getExtendValue("extend_channel_id", (Object)"");
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        EnterParam enterParam = EnterParam.obtain((String)channelId, (int)29);
        message.obj = enterParam;
        this.sendMessage(message);
        if (this.isFromGameGroup(context.mFrom)) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "game_return_group_click").put("gameid", context.getGameInfo().gid));
        }
    }

    private boolean isFromGameGroup(GameContextDef.JoinFrom from) {
        return from == GameContextDef.JoinFrom.FROM_GAME_GROUP || from == GameContextDef.JoinFrom.FROM_GAME_INNER_MSG;
    }

    @Override
    protected void onReceiveSpeakChange(UserSpeakStatus userSpeakStatus) {
        this.sendSpeakingStatus(userSpeakStatus);
    }

    public synchronized void sendSpeakingStatus(UserSpeakStatus speakStatuses) {
        if (speakStatuses == null) {
            return;
        }
        Integer status = this.mSpeakStatus.get(speakStatuses.getUid());
        if (status != null && status.intValue() == speakStatuses.getStatus()) {
            return;
        }
        this.mSpeakStatus.put(speakStatuses.getUid(), speakStatuses.getStatus());
        ArrayList<GameUserSpeakStatus> speakStatusesList = new ArrayList<GameUserSpeakStatus>();
        GameUserSpeakStatus gameUserSpeakStatus = new GameUserSpeakStatus(speakStatuses.getUid(), speakStatuses.getStatus());
        speakStatusesList.add(gameUserSpeakStatus);
        if (!this.isExitIng()) {
            this.getCocosMessageProxy().getCocosProxyController().appNotifyGame(this.gameRunningContext.getRoomId(), CocosProxyType.appStateSpeaking.getEvent(), speakStatusesList);
        }
    }

    @Override
    public void onGetSingleGameUrl(int res, String gameId, String url, String roomId) {
        String oldRoomId = this.gameRunningContext.getRoomId();
        this.gameRunningContext.setRoomId(roomId);
        this.gameRunningContext.setGameUrl(url);
        this.mGameModel = this.gameRunningContext.buildGameModel();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"[onGetSingleGameUrl] res: %d, gameId: %s, url: %s", (Object[])new Object[]{res, gameId, url});
        }
        if (StringUtils.isNotEmpty((String)gameId) && StringUtils.equals((String)gameId, (String)this.gameRunningContext.getGameInfo().getGid())) {
            if (res == ERet.kRetSuccess.getValue()) {
                YYTaskExecutor.removeTask((Runnable)this.getUrlTimer);
                if (this.getBaseGameView() != null) {
                    this.getBaseGameView().loadGameView();
                } else {
                    MLog.error((Object)TAG, (String)"SingleGamePlayer onGetSingleGameUrl game window does not exist.", (Object[])new Object[0]);
                    if (RuntimeContext.sIsDebuggable) {
                        throw new IllegalArgumentException("game window does not exist.");
                    }
                }
            } else {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.single_game_enter_fail), (int)1);
                this.exitRoom(8);
                Object channelId = this.gameRunningContext.getExtendValue("extend_channel_id", (Object)"");
                IGameCenterService service = (IGameCenterService)ServiceManagerProxy.getService(IGameCenterService.class);
                if (service != null) {
                    service.appendInvalidIndieGameInvite((Object)new IndieGameInfoInvalid(String.valueOf(channelId), gameId, res, oldRoomId, System.currentTimeMillis()));
                }
                if (this.gameRunningContext != null && this.gameRunningContext.mFrom == GameContextDef.JoinFrom.FROM_INDIE_GAME_INVITE) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "game_invalidation_prompt_show").put("gid", gameId));
                }
            }
        } else {
            MLog.error((Object)TAG, (String)"[onGetSingleGameUrl] no waiting this game", (Object[])new Object[0]);
        }
    }

    private void getSingleGameUrl(GameInfo info, String roomId, String payload, @Nullable GameAction gameAction) {
        if (info != null && StringUtils.isNotEmpty((String)info.getGid())) {
            YYTaskExecutor.postToMainThread((Runnable)this.getUrlTimer, (long)GAME_TIMEOUT);
            if (StringUtils.isNotEmpty((String)payload)) {
                this.gameRunningContext.addExtendValue("extend_from_h5", (Object)payload);
            }
            if (gameAction == null) {
                SettingFlags.setStringValue((String)"key_game_action", (String)GameAction.getDEFAULT().toJson());
            } else {
                SettingFlags.setStringValue((String)"key_game_action", (String)gameAction.toJson());
            }
            String jsPaylod = "";
            String mplId = this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString();
            if (!TextUtils.isEmpty((CharSequence)mplId)) {
                JsonStringBuilder builder = JsonStringBuilder.newBuilder();
                builder.put("src", (Object)"mlp").put("id", (Object)mplId);
                jsPaylod = builder.buildJson();
            } else if (TextUtils.isEmpty((CharSequence)jsPaylod)) {
                jsPaylod = this.gameRunningContext.getExtendValue("js_paylod", (Object)"").toString();
            }
            boolean createNewIfNoRoom = (Boolean)this.gameRunningContext.getExtendValue("createNewIfNoRoom", (Object)false);
            this.mSimpleGameProtoController.sendGetSingleGameUrl(info.getGid(), roomId, payload, jsPaylod, createNewIfNoRoom, this);
        }
    }

    @Override
    public CocosProxyType[] getSupportedCocosProxyType() {
        return new CocosProxyType[]{CocosProxyType.gameForceExit, CocosProxyType.notifyAppAllPlayersRes, CocosProxyType.showAppVolumeControl, CocosProxyType.joinVoiceRoom, CocosProxyType.leaveVoiceRoom, CocosProxyType.operateMic, CocosProxyType.micStatusQuery};
    }

    @Override
    public void onReceiveGameEvent(String context, long seqId, int event, Vector<String> args) {
        super.onReceiveGameEvent(context, seqId, event, args);
        String result = "";
        if (args != null && args.size() > 0) {
            result = args.get(0);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"SingleGamePlayer onReceiveGameEvent event: %d , result: %s", (Object[])new Object[]{event, result});
        }
        this.handleGameEvent(context, seqId, event, result);
    }

    private void handleGameEvent(String context, long seqId, int event, final String result) {
        if (CocosProxyType.gameForceExit.getEvent() == event) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"foreExit", (Object[])new Object[0]);
            }
            String gid = "";
            if (this.gameRunningContext != null && this.gameRunningContext.getGameInfo() != null) {
                gid = this.gameRunningContext.getGameInfo().getGid();
            }
            GameExitHelper.INSTANCE.callBeforeExit(gid, false, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

                public Unit invoke(Boolean needConfirm) {
                    IndieGamePlayer.this.getCocosMessageProxy().getGameProxyService().getBaseService().appGameExit(IndieGamePlayer.this.gameRunningContext.getRoomId());
                    int code = 1005;
                    int type = 1001;
                    try {
                        JSONObject json = null;
                        json = JsonParser.obtainJSONObject((String)result);
                        code = json.optInt("exitCode", 1005);
                        type = json.optInt("exitType", 1001);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    IndieGamePlayer.this.exitRoom(code, type, 2);
                    return null;
                }
            });
        } else if (CocosProxyType.notifyAppAllPlayersRes.getEvent() == event) {
            this.handleGameNotifyAppPlayers(result);
        } else if (CocosProxyType.showAppVolumeControl.getEvent() == event) {
            this.handleShowAppVolumeControl(result);
        } else if (CocosProxyType.joinVoiceRoom.getEvent() == event) {
            this.joinVoiceRoom(result);
        } else if (CocosProxyType.leaveVoiceRoom.getEvent() == event) {
            this.leaveVoiceRoom(result);
        } else if (CocosProxyType.operateMic.getEvent() == event) {
            this.operateMic(context, seqId, result);
        } else if (CocosProxyType.micStatusQuery.getEvent() == event) {
            this.queryUserMicStatus(context, seqId, result);
        }
    }

    private void handleGameNotifyAppPlayers(final String json) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handleGameNotifyAppPlayers json: %s", (Object[])new Object[]{json});
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    final List uids = JsonParser.parseJsonList((String)json, Long.class);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (IndieGamePlayer.this.gameRunningContext == null) {
                                return;
                            }
                            List infos = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, null);
                            if (infos != null && !infos.isEmpty()) {
                                for (UserInfoKS infoKS : infos) {
                                    IndieGamePlayer.this.gameRunningContext.updateUserInfo(infoKS.uid, infoKS);
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    MLog.error((Object)IndieGamePlayer.TAG, (Throwable)e);
                }
            }
        });
    }

    private void handleShowAppVolumeControl(final String json) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handleShowAppVolumeControl json: %s", (Object[])new Object[]{json});
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jo = JsonParser.obtainJSONObject((String)json);
                    int type = jo.getInt("showAppVolumeControl");
                    IndieGamePlayer.this.mShowAppVolumeType = type > 3 || type < 0 ? 0 : type;
                }
                catch (Exception e) {
                    MLog.error((Object)IndieGamePlayer.TAG, (Throwable)e);
                }
            }
        });
    }

    private void joinVoiceRoom(String json) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"joinVoiceRoom json: %s", (Object[])new Object[]{json});
        }
        if (StringUtils.isEmpty((String)json)) {
            return;
        }
        this.mSpeakStatus.clear();
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)json);
            String roomId = jo.getString("channelId");
            if (StringUtils.isEmpty((String)roomId)) {
                return;
            }
            this.mRoomSlot = ((IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class)).joinRoom(roomId, 9, new IRoomLifeCycleCallback(){

                public void onRoomCreate(RoomSlot room, int type, Object ... e) {
                }

                public void onRoomRestart(RoomSlot room, int type) {
                }

                public void onRoomResume(RoomSlot room, int type) {
                }

                public void onRoomPause(RoomSlot room, int type) {
                }

                public void onRoomDestory(RoomSlot room, int type) {
                    IndieGamePlayer.this.mRoomSlot = null;
                }
            });
            if (this.mRoomSlot != null) {
                if (this.mRoomSlot.room != null) {
                    this.mBinder.singleBindSourceTo((KvoSource)this.mRoomSlot.room.mMyStatus);
                }
                this.mBinder.singleBindSourceTo((KvoSource)this.mRoomSlot.room);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void leaveVoiceRoom(final String json) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"leaveVoiceRoom json: %s", (Object[])new Object[]{json});
        }
        this.mSpeakStatus.clear();
        if (StringUtils.isEmpty((String)json)) {
            return;
        }
        final RoomSlot roomSlot = this.mRoomSlot;
        if (roomSlot == null) {
            return;
        }
        if (roomSlot.room == null) {
            this.mRoomSlot = null;
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jo = JsonParser.obtainJSONObject((String)json);
                    String roomId = jo.getString("channelId");
                    if (roomSlot == null || roomSlot.room == null) {
                        return;
                    }
                    if (!StringUtils.isEmpty((String)roomId) && roomId.equals(roomSlot.room.mSessionId)) {
                        ((IRoomManagerService)IndieGamePlayer.this.getServiceManager().getService(IRoomManagerService.class)).leaveRoom(roomSlot, 9);
                    }
                }
                catch (JSONException e) {
                    MLog.error((Object)IndieGamePlayer.TAG, (Throwable)e);
                }
            }
        });
    }

    private void operateMic(String context, long seqId, String json) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"operateMic json: %s", (Object[])new Object[]{json});
        }
        if (StringUtils.isEmpty((String)json)) {
            return;
        }
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)json);
            String roomId = jo.getString("channelId");
            boolean openMic = jo.getBoolean("operateMic");
            if (this.mRoomSlot == null || this.mRoomSlot.room == null) {
                this.operateMicCallback(context, seqId, roomId, false, 6);
                return;
            }
            int code = this.mRoomSlot.room.changeMicStatus(openMic);
            this.operateMicCallback(context, seqId, roomId, this.mRoomSlot.room.getMyStatus().isMicOpen(), code);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void operateMicCallback(String context, long seqId, final String roomId, final boolean isOpen, final int code) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"operateMicCallback roomId: %s, isOpen: %s, code: %s", (Object[])new Object[]{roomId, isOpen, code});
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jo = JsonParser.obtainJSONObject();
                    jo.put("channelId", (Object)roomId);
                    jo.put("operateMic", isOpen);
                    jo.put("code", code);
                    IndieGamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(CocosProxyType.operateMicCallback, jo.toString());
                }
                catch (JSONException e) {
                    MLog.error((Object)IndieGamePlayer.TAG, (Throwable)e);
                }
            }
        });
    }

    private void leaveVoiceRoom() {
        this.mBinder.clearAllKvoConnections();
        RoomSlot roomSlot = this.mRoomSlot;
        if (roomSlot == null) {
            return;
        }
        if (roomSlot.room == null) {
            this.mRoomSlot = null;
            return;
        }
        ((IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class)).leaveRoom(roomSlot, 9);
    }

    @Override
    public void showGameExitDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)R.string.game_exit), true, true, null));
        }
    }

    @Override
    public void hideGameExitDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    private void queryUserMicStatus(final String context, final long seqId, final String reqJson) {
        YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                if (IndieGamePlayer.this.mRoomSlot != null && ((IndieGamePlayer)IndieGamePlayer.this).mRoomSlot.room != null) {
                    try {
                        long tUid = ((GetRelationBean)JsonParser.parseJsonObject((String)reqJson, GetRelationBean.class)).getUid();
                        if (IndieGamePlayer.this.mRoomSlot != null && ((IndieGamePlayer)IndieGamePlayer.this).mRoomSlot.room != null) {
                            boolean isHaveUser = false;
                            for (RoomUserMicStatus roomUserMicStatus : ((IndieGamePlayer)IndieGamePlayer.this).mRoomSlot.room.getRoomUserMicStatusList()) {
                                if (roomUserMicStatus.getUid() != tUid) continue;
                                isHaveUser = true;
                                MicStatusBean micStatusBean = new MicStatusBean(Long.valueOf(roomUserMicStatus.getUid()), roomUserMicStatus.isMicOpen() ? 1 : 0);
                                IndieGamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.micStatusQueryCallBack, (Object)micStatusBean);
                            }
                            if (!isHaveUser) {
                                MicStatusBean micStatusBean = new MicStatusBean(Long.valueOf(tUid), 0);
                                IndieGamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.micStatusQueryCallBack, (Object)micStatusBean);
                            }
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)IndieGamePlayer.TAG, (Throwable)e);
                    }
                }
            }
        });
    }

    @KvoMethodAnnotation(sourceClass=RoomUserMicStatus.class, thread=1, name="micOpen")
    public void onMyMicStatusChange(KvoEventIntent event) {
        RoomUserMicStatus roomUserMicStatus = (RoomUserMicStatus)event.source();
        if (roomUserMicStatus == null) {
            return;
        }
        GameLoger.debug("indieGameTag", "RoomUserMicStatus %s", roomUserMicStatus.isMicOpen());
        this.sendMicStatus();
    }

    @KvoMethodAnnotation(sourceClass=AbsVoiceRoom.class, name="mRoomUserMicStatusList", thread=1)
    public void onRoomMicStatusChanged(KvoEventIntent event) {
        GameLoger.debug("indieGameTag", "onRoomMicStatusChanged %s", event);
        this.sendMicStatus();
    }

    private void sendMicStatus() {
        ArrayList<MicStatusBean> micStatusBeanList = new ArrayList<MicStatusBean>();
        if (this.mRoomSlot != null && this.mRoomSlot.room != null) {
            for (RoomUserMicStatus roomUserMicStatus : this.mRoomSlot.room.getRoomUserMicStatusList()) {
                micStatusBeanList.add(new MicStatusBean(Long.valueOf(roomUserMicStatus.getUid()), roomUserMicStatus.isMicOpen() ? 1 : 0));
            }
        }
        this.getCocosMessageProxy().getCocosProxyController().appNotifyGame(this.gameRunningContext.getRoomId(), CocosProxyType.onMicStatusChange.getEvent(), micStatusBeanList);
    }

    @Override
    public BaseGameCallAppRouter getCustomerGameCallAPPRouter() {
        return new IndieGameCallAppRouter(this.getEnvironment(), this.getCocosMessageProxy().getCocosProxyController(), this);
    }

    @Override
    public void showExitDialog() {
        final String gid = this.gameRunningContext != null && this.gameRunningContext.getGameInfo() != null ? this.gameRunningContext.getGameInfo().getGid() : "";
        GameExitHelper.INSTANCE.callBeforeExit(gid, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

            public Unit invoke(Boolean needConfirm) {
                if (needConfirm.booleanValue()) {
                    if (IndieGamePlayer.this.getBaseGameView() == null) {
                        MLog.error((Object)IndieGamePlayer.TAG, (String)"game window can not be null.", (Object[])new Object[0]);
                    } else {
                        IndieGamePlayer.this.getBaseGameView().showExitConfirmDialog(ResourceUtils.getString((int)R.string.samescreen_game_exit_confirm), ResourceUtils.getString((int)R.string.dialog_btn_yes), ResourceUtils.getString((int)R.string.dialog_btn_no), new IGameDialogCallback(){

                            public void onOk() {
                                IndieGamePlayer.this.handleExit();
                                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20029429").put("function_id", "runaway_click").put("gid", gid));
                            }

                            public void onCancel() {
                            }
                        });
                    }
                } else {
                    IndieGamePlayer.this.handleExit();
                }
                return null;
            }
        });
    }

    private void handleExit() {
        GameLoger.info("indieGameTag", "on exit dialog ok click", new Object[0]);
        if (StringUtils.isEmpty((String)this.gameRunningContext.getGameResult())) {
            GameLoger.info("indieGameTag", "on user escape form game, gid:%s", this.gameRunningContext.getGameInfo() != null ? this.gameRunningContext.getGameInfo().gid : "");
            this.getCocosMessageProxy().getGameProxyService().getBaseService().appGameExit(this.gameRunningContext.getRoomId());
            YYTaskExecutor.postToMainThread((Runnable)this.mExitRunable, (long)GAME_EXIT_TIMEOUT);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    try {
                        IndieGamePlayer.this.exitRoomWithType();
                    }
                    catch (Exception e) {
                        MLog.error((Object)IndieGamePlayer.TAG, (Throwable)e);
                        IndieGamePlayer.this.exitRoom(1);
                    }
                }
            });
        }
    }

    @Override
    protected int exitNoStart() {
        TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.user_escape), (int)0);
        GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.getGameStartTime()), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.NOT_START.value(), 0, this.isGoldGame);
        if (this.gameRunningContext.getFrom().getId() == IGameService.GAME_FROM.FROM_IM.value() || this.gameRunningContext.getFrom().getId() == IGameService.GAME_FROM.FROM_NOTIFY.value()) {
            return 1;
        }
        if (this.gameRunningContext.getFrom() == GameContextDef.JoinFrom.FROM_HAGO_GROUP) {
            return 5;
        }
        return 2;
    }

    @Override
    public void receiveGameResult(final @NotNull String reqJson) {
        if (this.gameRunningContext.getOtherUserInfo() != null) {
            this.mSessionId = Utils.getSessionId(AccountUtil.getUid(), this.gameRunningContext.getOtherUserInfo().uid);
            this.mOtherUid = this.gameRunningContext.getOtherUserInfo().uid;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                IndieGamePlayer.this.gameRunningContext.setGameResult(reqJson);
                IndieGamePlayer.this.generateGameResult();
                IndieGamePlayer.this.insertAndGetResultDataFromDB(IndieGamePlayer.this.gameRunningContext.getGameResultBean());
            }
        });
        if (this.gameRunningContext != null && this.gameRunningContext.getGameInfo() != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20029429").put("function_id", "result_receive").put("gid", this.gameRunningContext.getGameInfo().gid));
        }
    }

    public BaseGameView<? extends IGameView> initGameView() {
        GameWindowConfig gameWindowConfig = new GameWindowConfig(this.gameRunningContext.getGameInfo().isSupportFullScreen());
        SimpleGameWindow simpleGameWindow = new SimpleGameWindow((Context)this.mContext, (UICallBacks)this, this.mSimpleGameCallback, AbstractWindow.WindowLayerType.USE_ALL_LAYER, 103, gameWindowConfig);
        simpleGameWindow.getLoadingPage().setCallBack(new GameLoadingPage.ILoadingViewCallback(){

            @Override
            public void onCloseClick() {
                IndieGamePlayer.this.exitRoom(1002, 2);
            }

            @Override
            public long closeTimer() {
                return 2000L;
            }

            @Override
            public int loadingPageType() {
                if (GameInfo.isNewGameLoad((GameInfo)IndieGamePlayer.this.gameRunningContext.getGameInfo())) {
                    return 2;
                }
                return 1;
            }

            @Override
            public DResource getCusLoadingSvgaKey() {
                return null;
            }

            @Override
            public List<String> getLoadingTips() {
                return IndieGamePlayer.this.getCurrentGameLoader().getGameLoadingTips();
            }
        });
        return new WindowGameView(simpleGameWindow, this.mIWindowGameViewCallback);
    }

    public void gotoIM() {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.IM_ROOM_SHOW;
        Bundle bundle = new Bundle();
        bundle.putLong("target_uid", this.mOtherUid);
        bundle.putString("im_game_id", this.gameRunningContext.getGameInfo().getGid());
        bundle.putInt("bundle_im_from", 4);
        bundle.putInt("im_page_scene", 1);
        bundle.putBoolean("im_game_panel", true);
        msg.setData(bundle);
        this.sendMessageSync(msg);
    }
}

