/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.gamemodule.simplegame.ISimpleGameCallback;
import com.yy.game.gamemodule.simplegame.SimpleGameType;
import com.yy.game.module.gameload.LoadGamePageManager;
import com.yy.game.module.gameroom.ui.AbsGameWindow;
import com.yy.game.module.gameroom.ui.GameWindowConfig;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;

@SuppressLint(value={"ViewConstructor"})
public class SimpleGameWindow
extends AbsGameWindow {
    private View mExitView;
    private final ISimpleGameCallback mSimpleGameCallback;
    private View.OnClickListener mExitGameOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SimpleGameWindow.this.mSimpleGameCallback != null) {
                SimpleGameWindow.this.mSimpleGameCallback.showExitDialog();
            }
        }
    };

    public SimpleGameWindow(Context context, UICallBacks callBacks, ISimpleGameCallback callback2, AbstractWindow.WindowLayerType useLayerType, int windowType, GameWindowConfig gameWindowConfig) {
        super(context, callBacks, useLayerType, gameWindowConfig);
        this.setWindowType(windowType);
        this.mSimpleGameCallback = callback2;
    }

    @Override
    public void initViews(GamePlayContext gamePlayContext, IGameLifecycle gameLifecycle) {
        if (this.mSimpleGameCallback != null && this.mSimpleGameCallback.getGameType() != null && this.mSimpleGameCallback.getGameType() != SimpleGameType.INDIE) {
            this.mExitView = SimpleGameWindow.inflate((Context)this.getContext(), (int)R.layout.simplegame_exit, null);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ResolutionUtils.dip2Px((float)30.0f), ResolutionUtils.dip2Px((float)30.0f));
            params.topMargin = ResolutionUtils.dip2Px((float)15.0f);
            params.leftMargin = ResolutionUtils.dip2Px((float)15.0f);
            this.getExtLayer().addView(this.mExitView, (ViewGroup.LayoutParams)params);
            this.mExitView.setOnClickListener(this.mExitGameOnClickListener);
            this.mExitView.setVisibility(8);
        }
        super.initViews(gamePlayContext, gameLifecycle);
    }

    @Override
    public void initCusFuncView(RelativeLayout container) {
    }

    public void hideExitView() {
        if (this.mExitView != null && this.mExitView.getVisibility() == 0) {
            this.mExitView.setVisibility(8);
        }
    }

    @Override
    public void onLoadGameBg(RecycleImageView bgView) {
        if (this.mSimpleGameCallback != null && StringUtils.isNotEmpty((String)this.mSimpleGameCallback.getGameId())) {
            LoadGamePageManager.getInstance().loadGameLoadingPage(bgView, this.mSimpleGameCallback.getGameId());
        }
    }

    @Override
    public void hideGameLoading() {
        super.hideGameLoading();
        if (this.mExitView != null) {
            this.mExitView.setVisibility(0);
        }
    }
}

