/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.simplegame;

import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public final class SimpleGameHiidoReporter {
    private SimpleGameHiidoReporter() {
    }

    public static void reportGameLoadFailed(String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("function_id", "load_fail").put("gid", gameId));
    }

    public static void reportGameLoadSuccess(String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("function_id", "load_success").put("gid", gameId));
    }

    public static void reportGameShow(String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "show").put("act_uid", "0").put("roomid", "0").put("gid", gameId));
    }

    public static void reportGameLoad(String gameId, int gameMode) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("function_id", "load").put("gid", gameId).put("game_type", String.valueOf(gameMode)));
    }

    public static void reportGameExit(String gameId, int gameType) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("is_exit", "1").put("game_type", String.valueOf(gameType)).put("gid", gameId));
    }

    public static void reportSingleGameDuration(String gameId, long startTime) {
        String duration = String.valueOf(System.currentTimeMillis() - startTime);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025735").put("gid", gameId).put("game_time", duration));
    }

    public static void reportSingleGameStart(String gameId, String roomId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("function_id", "game_start").put("gid", gameId).put("room_id", roomId).put("token", ServiceManagerProxy.getServiceManager() == null ? null : ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
    }

    public static void reportSingleGameDurationWithABTest(String gameId, long startTime) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("gid", gameId).put("game_time", String.valueOf(Math.abs(System.currentTimeMillis() - startTime))).put("token", ServiceManagerProxy.getServiceManager() == null ? null : ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
    }

    public static void reportSingleGameFinishAndTime(String gameId, String gamePlayTimes, String roomId, long startTime) {
        String gameTime = String.valueOf(System.currentTimeMillis() - startTime);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024337").put("room_id", roomId).put("game_time", gameTime).put("function_id", "game_finish").put("gid", gameId).put("page_id", "2").put("token", ServiceManagerProxy.getServiceManager() == null ? null : ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getAlgorithmTokenUrlencode()));
    }

    public static void reportSingleGameType(String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025783").put("gid", gameId).put("game_type", "2"));
    }

    public static void reportSameScreenGameDuration(String gameId, long startTime) {
        String duration = String.valueOf(System.currentTimeMillis() - startTime);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024421").put("gid", gameId).put("game_time", duration).put("function_id", "finish_game"));
    }

    public static void reportSameScreenGameFinish(String gameId) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024421").put("function_id", "finish_game").put("gid", gameId));
    }
}

