/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.match;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.bean.GameDataModel;
import com.yy.game.bean.GameMatch2v2NotifyRes;
import com.yy.game.bean.I2V2PkMatchListener;
import com.yy.game.gamemodule.pkgame.match.PkGameMatcher;
import com.yy.game.module.matchgame.I2v2GameMatchInterface;
import com.yy.game.module.matchgame.ui.Match2V2GameWindow;
import com.yy.game.module.matchgame.ui.TwoVsTwoMatchPager;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameMatchNotifyRes;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.game.service.bean.Game2V2MatchContext;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;

public class TwoVsTwoMatcher
extends PkGameMatcher
implements I2V2PkMatchListener {
    private static final String TAG = "TwoVsTwoMatcher";
    private static final long MATCH_SUCCESS_DELAY = 2000L;
    Match2V2GameWindow m2v2MatchWindow;
    UserInfoKS mFriUserInfo;

    public TwoVsTwoMatcher(Environment env, IMatchGameLifecycle lifeCallback) {
        super(env, lifeCallback);
    }

    @Override
    public I2v2GameMatchInterface getMatchView(GameInfo gameInfo) {
        return new TwoVsTwoMatchPager((Context)this.mContext, this, false);
    }

    @Override
    public void onPreMatch(GameInfo gameInfo, GameMatchContext config) {
        if (this.m2v2MatchWindow == null) {
            this.m2v2MatchWindow = new Match2V2GameWindow((Context)this.mContext, (UICallBacks)this, AbstractWindow.WindowLayerType.USE_ALL_LAYER, gameInfo);
        }
        this.showMatchGameView(this.m2v2MatchWindow);
    }

    @Override
    void loadPkMatchView(GameInfo gameInfo, UserInfoKS userInfoKS, GameMatchContext config) {
        UserInfoKS friendUserInfo;
        if (this.m2v2MatchWindow == null) {
            return;
        }
        this.m2v2MatchWindow.initView(gameInfo);
        this.m2v2MatchWindow.updateGameInfo(gameInfo);
        this.m2v2MatchWindow.updateMyInfoView(config.getMyUserInfoKS());
        if (config instanceof Game2V2MatchContext && StringUtils.isNotEmpty((String)((Game2V2MatchContext)config).getPkId()) && (friendUserInfo = ((Game2V2MatchContext)config).getFriendUserInfo()) != null) {
            this.m2v2MatchWindow.updateFriendsView(friendUserInfo);
            this.mFriUserInfo = ((Game2V2MatchContext)config).getFriendUserInfo();
        }
        if (this.mFriUserInfo == null) {
            this.m2v2MatchWindow.startMatchAnim(false);
        } else {
            this.m2v2MatchWindow.startMatchAnim(true);
        }
    }

    @Override
    public void startMatchInner(GameMatchContext gameMatchContext) {
        if (gameMatchContext instanceof Game2V2MatchContext) {
            GameDataModel.instance.gameMatchReq(gameMatchContext.getMyUserInfoKS(), this.mGameInfo, this.mTargetSex, ((Game2V2MatchContext)gameMatchContext).getPkId(), gameMatchContext);
        } else {
            GameDataModel.instance.gameMatchReq(gameMatchContext.getMyUserInfoKS(), this.mGameInfo, this.mTargetSex, gameMatchContext);
        }
    }

    @Override
    synchronized void initAndStartTimer() {
        if (!this.isShowTipAnim()) {
            super.initAndStartTimer();
        }
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (abstractWindow == this.m2v2MatchWindow) {
            this.m2v2MatchWindow = null;
        }
    }

    @Override
    public synchronized void onGameMatchSuccess(GameMatchNotifyRes gameMatchNotifyRes) {
    }

    @Override
    public synchronized void on2V2GameMatchSuccess(final GameMatch2v2NotifyRes gameMatchNotifyRes) {
        if (!this.onPreMatchSuccessInner(this.mGameInfo, this.mMatchConfig, gameMatchNotifyRes.getGameId(), gameMatchNotifyRes.getResource().getRoomid())) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"\u6536\u52302v2\u6e38\u620f\u5339\u914d\u6210\u529f\u901a\u77e5 %s", (Object[])new Object[]{gameMatchNotifyRes.toString()});
        }
        this.mMatchConfig.setUrl(gameMatchNotifyRes.getResource().getUrl());
        this.mMatchConfig.setRoomId(gameMatchNotifyRes.getResource().getRoomid());
        if (this.mGameInfo != null) {
            final HiidoEvent matchEvent = HiidoEvent.obtain().eventId("20023775").put("function_id", "success_match").put("match_time", String.valueOf(System.currentTimeMillis() - this.mStartTime)).put("gid", this.mGameInfo.getGid());
            if (this.mMatchConfig.getMyUserInfoKS() != null) {
                matchEvent.put("mgender", this.mMatchConfig.getMyUserInfoKS().getSex() == 0 ? "F" : "M");
                if (this.mFriUserInfo != null) {
                    matchEvent.put("tgender", this.mFriUserInfo.getSex() == 0 ? "F" : "M");
                }
            }
            YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TwoVsTwoMatcher.TAG, (String)JsonParser.toJson((Object)matchEvent), (Object[])new Object[0]);
                    }
                }
            });
            HiidoStatis.reportEvent((HiidoEvent)matchEvent);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Game2V2MatchContext game2V2MatchContext = new Game2V2MatchContext(TwoVsTwoMatcher.this.mMatchConfig.getFrom());
                game2V2MatchContext.copyFromGameMatchContext(TwoVsTwoMatcher.this.mMatchConfig);
                if (TwoVsTwoMatcher.this.mMatchConfig instanceof Game2V2MatchContext) {
                    game2V2MatchContext.setPkId(((Game2V2MatchContext)TwoVsTwoMatcher.this.mMatchConfig).getPkId());
                    game2V2MatchContext.setFriendUserInfo(((Game2V2MatchContext)TwoVsTwoMatcher.this.mMatchConfig).getFriendUserInfo());
                }
                game2V2MatchContext.setMineTeamUserMap(gameMatchNotifyRes.getMyTeamMap());
                game2V2MatchContext.setOtherTeamUserMap(gameMatchNotifyRes.getOtherTeamMap());
                TwoVsTwoMatcher.this.onMatchFinish(TwoVsTwoMatcher.this.mGameInfo, (GameMatchContext)game2V2MatchContext, 0);
                TwoVsTwoMatcher.this.destroyWindow(TwoVsTwoMatcher.this.mGameInfo, (GameMatchContext)game2V2MatchContext);
            }
        }, (long)2360L);
        this.onMatch2v2SuccessView(gameMatchNotifyRes);
    }

    @Override
    public void on2V2GameMatchCancelNotify(String pkId) {
        if (this.mMatchConfig instanceof Game2V2MatchContext && pkId.equals(((Game2V2MatchContext)this.mMatchConfig).getPkId())) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.friend_cancel_match), (int)0);
            this.cancelMatchInner();
            this.onMatchFinish(this.mGameInfo, this.mMatchConfig, 2);
        }
    }

    @Override
    public void cancelMatchInner() {
        if (this.mFriUserInfo == null) {
            super.cancelMatchInner();
        } else {
            this.gotoIM(this.mFriUserInfo);
        }
    }

    private void gotoIM(UserInfoKS userInfoKS) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.IM_ROOM_SHOW;
        Bundle bundle = new Bundle();
        bundle.putLong("target_uid", userInfoKS.getUid());
        bundle.putInt("bundle_im_from", 10);
        bundle.putInt("im_page_scene", 1);
        msg.setData(bundle);
        this.sendMessageSync(msg);
        this.popMatchGameWindow(false);
    }

    public void onMatch2v2SuccessView(GameMatch2v2NotifyRes gameMatchNotifyRes) {
        if (this.mMatchGameWindow == null || gameMatchNotifyRes == null) {
            return;
        }
        this.stopMatchTimer();
        this.m2v2MatchWindow.stopMatchAnim();
        ArrayList<UserInfoKS> userInfoKSArrayList = new ArrayList<UserInfoKS>();
        for (UserInfoKS userInfoKS : gameMatchNotifyRes.getOtherTeamMap().values()) {
            userInfoKSArrayList.add(userInfoKS);
        }
        if (this.mFriUserInfo == null) {
            this.m2v2MatchWindow.updateTVMatch(GameDef.MatchStatus.MATCHING_SUCCESS, gameMatchNotifyRes.getMatchTips());
            for (UserInfoKS userInfoKS : gameMatchNotifyRes.getMyTeamMap().values()) {
                if (userInfoKS.getUid() == AccountUtil.getUid()) continue;
                this.m2v2MatchWindow.updateFriendsView(userInfoKS);
            }
        }
        this.m2v2MatchWindow.updateOtherTeamView(userInfoKSArrayList);
        this.m2v2MatchWindow.startMatchSuccessAnim();
        ((IGameAudioService)this.getServiceManager().getService(IGameAudioService.class)).play("pkMatchingSuccessVoice");
    }

    private void saveMatchTipsSuccess() {
        SettingFlags.setBoolean((String)("game_2v2_have_played" + AccountUtil.getUid()), (boolean)true);
    }

    @Override
    public void onMatchTipFinish() {
        this.saveMatchTipsSuccess();
        super.onMatchTipFinish();
    }

    @Override
    public void reset() {
        super.reset();
        this.mFriUserInfo = null;
    }

    @Override
    public boolean isShowTipAnim() {
        boolean hasFlag = SettingFlags.getBoolean((String)("game_2v2_have_played" + AccountUtil.getUid()), (boolean)false);
        return !hasFlag && this.mMatchConfig.mFrom == GameContextDef.JoinFrom.FROM_HOME;
    }
}

