/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.match;

import android.app.Activity;
import android.content.Context;
import android.os.Message;
import android.os.SystemClock;
import android.view.KeyEvent;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.OnGetHeadFrameCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SpannableStringUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.bean.GameDataModel;
import com.yy.game.bean.IPkMatchListener;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.activity.mpl.MplReporter;
import com.yy.game.gamemodule.activity.mpl.ui.IMPLInvalidDialogCallback;
import com.yy.game.gamemodule.activity.mpl.ui.MplInvalidDialog;
import com.yy.game.gamemodule.activity.mpl.ui.MplInvalidType;
import com.yy.game.gamemodule.base.GameDownloadPresenter;
import com.yy.game.gamemodule.base.NormalGameMatcher;
import com.yy.game.gamemodule.base.ui.GameFakeDownloadPresenter;
import com.yy.game.metric.GameMetricCode;
import com.yy.game.metric.GameMetricHelper;
import com.yy.game.module.matchgame.IGameMatchInterface;
import com.yy.game.module.matchgame.IMatchGameUICallbacks;
import com.yy.game.module.matchgame.ui.AllGameMatchPager;
import com.yy.game.module.matchgame.ui.MatchGameWindow;
import com.yy.game.module.matchgame.ui.PkMatchLoadingPage;
import com.yy.game.utils.GameReportHelper;
import com.yy.game.utils.GameStateDef;
import com.yy.game.utils.PkMatchPoolStatHelper;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameMatchNotifyRes;
import com.yy.hiyo.game.base.bean.MatchPoolAnswerNotifyRes;
import com.yy.hiyo.game.base.bean.MatchPoolDownloadFinishReq;
import com.yy.hiyo.game.base.bean.MatchPoolInviteAnswerReq;
import com.yy.hiyo.game.base.bean.MatchPoolInviteNotifyRes;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.callback.IMatchGameCallback;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

public class PkGameMatcher
extends NormalGameMatcher
implements IMatchGameUICallbacks,
IPkMatchListener {
    public static final long AVTOR_ANIM_TIME = 80L;
    public static final long PKIMG_ANIM_TIME = 280L;
    private static final int MAX_MATCH_RETRY_TIME = 5;
    private static final long MAX_MATCH_POOL_WAIT_TIME = 62000L;
    private static final String TAG = "PkGameMatcher";
    private volatile int mTimeOutNumber = 0;
    int mTargetSex;
    private volatile boolean bInitTimer;
    GameDownloadPresenter mGameDownloader;
    MatchSuccessRunnable matchSuccessRunnable;
    MatchInviteTimeoutRunnable mMatchInviteTimeoutRunnable;
    GameDownloadPresenter mMatchDownloader;
    GameFakeDownloadPresenter mFakeDownloader;
    Runnable mInviteSuccessWaitTimeoutRunnable;
    private long mMatchTime = 0L;
    private Runnable mMatchTimer = new Runnable(){

        @Override
        public void run() {
            PkGameMatcher.this.mMatchTime++;
            if (PkGameMatcher.this.mMatchGameWindow != null) {
                boolean isGameFirstPageOpen;
                if (RuntimeContext.sIsDebuggable && PkGameMatcher.this.mMatchTime >= 30L && RuntimeContext.sIsDebuggable && (isGameFirstPageOpen = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false)) && PkGameMatcher.this.mMatchGameWindow != null) {
                    PkGameMatcher.this.mMatchGameWindow.stopMatchAnim();
                    MatchGameWindow window = PkGameMatcher.this.mMatchGameWindow;
                    PkGameMatcher.this.mMatchGameWindow = null;
                    PkGameMatcher.this.mWindowMgr.popWindow(true, (AbstractWindow)window);
                    Message message = new Message();
                    message.what = BaseMsgDef.MSG_GAME_FIRST_PAGE_AUTO_TEST;
                    message.obj = PkGameMatcher.this.mGameInfo.getGid();
                    PkGameMatcher.this.sendMessage(message);
                    return;
                }
                IGameMatchInterface matchPager = PkGameMatcher.this.mMatchGameWindow.getGameMatchPager();
                if (matchPager != null) {
                    matchPager.updateTVMatch(GameDef.MatchStatus.MATCHING, ResourceUtils.getString((int)R.string.matching) + "   " + PkGameMatcher.this.mMatchTime + "s");
                }
                PkGameMatcher.this.startGameMatchTimer();
            }
        }
    };

    public PkGameMatcher(Environment env, IMatchGameLifecycle lifeCallback) {
        super(env, lifeCallback);
    }

    @Override
    public void matchGame(GameInfo gameInfo, GameMatchContext config, IMatchGameCallback callback2) {
        super.matchGame(gameInfo, config, callback2);
    }

    @Override
    protected synchronized boolean onPreMatchSuccessInner(GameInfo gameInfo, GameMatchContext matchContext, String gid, String roomId) {
        return super.onPreMatchSuccessInner(gameInfo, matchContext, gid, roomId);
    }

    public void onPreMatch(GameInfo gameInfo, GameMatchContext config) {
        this.initView(gameInfo);
    }

    @Override
    public void onPrepareGameMatchInner(final GameInfo gameInfo, GameMatchContext matchConfig) {
        this.mGameDownloader = new GameDownloadPresenter(gameInfo);
        UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
        this.mMatchConfig.setMyUserInfoKS(userInfoKS);
        this.onPreMatch(gameInfo, matchConfig);
        this.mGameDownloader.checkGameDownload(gameInfo, true);
        if (this.mMatchGameWindow != null) {
            this.mGameDownloader.getHasDownloadPkg().observe((LifecycleOwner)this.mMatchGameWindow.mLifeCycleOwner, state -> {
                if (this.mMatchGameWindow == null) {
                    return;
                }
                if (state == 2) {
                    this.mStartTime = System.currentTimeMillis();
                    this.loadPkMatchView(gameInfo, userInfoKS, matchConfig);
                    this.onGameMatchStart(gameInfo, matchConfig);
                    this.initAndStartTimer();
                } else if (state == 0) {
                    this.mMatchGameWindow.mLoading.setListener(new PkMatchLoadingPage.ILoadingListener(){

                        @Override
                        public void onCloseClick() {
                            PkGameMatcher.this.cancelMatch(4);
                        }

                        @Override
                        @NotNull
                        public List<String> getLoadingTips() {
                            return PkGameMatcher.this.mGameDownloader.getDownloadTips(gameInfo);
                        }
                    });
                    this.mMatchGameWindow.loadLoadingView(gameInfo);
                    this.mGameDownloader.getDownloadProgress().observe((LifecycleOwner)this.mMatchGameWindow.mLifeCycleOwner, aLong -> {
                        if (this.mMatchGameWindow != null) {
                            this.mMatchGameWindow.updateLoadingProgress(aLong.intValue());
                        }
                    });
                } else if (state == 3) {
                    this.onGameMatchFail(11);
                }
            });
        }
    }

    void loadPkMatchView(GameInfo gameInfo, UserInfoKS userInfoKS, GameMatchContext config) {
        if (this.mMatchGameWindow == null) {
            return;
        }
        this.mMatchGameWindow.hideLoading();
        int entryCoins = 0;
        boolean isGoldGame = false;
        boolean isShowGoldUI = false;
        if (config != null) {
            entryCoins = (Integer)config.getExtendValue("goldGameEntry", (Object)0);
            isGoldGame = (Boolean)config.getExtendValue("isGoldGame", (Object)false);
            isShowGoldUI = (Boolean)config.getExtendValue("coins_game_show_flag_ui", (Object)false);
        }
        this.mMatchGameWindow.initView(gameInfo);
        this.mMatchGameWindow.updateGameInfo(gameInfo);
        this.mMatchGameWindow.startMatchAnim();
        this.mMatchGameWindow.updateMyInfoView(userInfoKS);
        this.mMatchGameWindow.updateGoldEntryView(isShowGoldUI, entryCoins);
        if (StringUtils.isNotEmpty((String)this.mMatchConfig.getExtendValue("mpl_id", (Object)"").toString())) {
            this.mMatchGameWindow.showMplBanner(R.drawable.bg_mpl_bottom);
        }
    }

    private void initView(GameInfo gameInfo) {
        if (this.mMatchGameWindow == null) {
            this.mMatchGameWindow = new MatchGameWindow((Context)this.mContext, (UICallBacks)this, AbstractWindow.WindowLayerType.USE_ALL_LAYER, gameInfo);
        }
        this.showMatchGameView(this.mMatchGameWindow);
    }

    synchronized void initAndStartTimer() {
        if (this.bInitTimer) {
            return;
        }
        this.mMatchTime = 0L;
        this.bInitTimer = true;
        this.startGameMatchTimer();
        this.startMatch(this.mMatchConfig);
    }

    @Override
    public void onBackGroundChange(boolean foreground) {
        if (!foreground) {
            this.cancelMatch(1);
        }
    }

    @Override
    public void onNetworkNotAvailable() {
        super.onNetworkNotAvailable();
        this.cancelMatch(2);
    }

    private void startGameMatchTimer() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mMatchTimer);
        YYTaskExecutor.postToMainThread((Runnable)this.mMatchTimer, (long)1000L);
    }

    void stopMatchTimer() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mMatchTimer);
        this.mMatchTime = 0L;
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
    }

    @Override
    public void onGameMatchStart(GameInfo info, GameMatchContext matchConfig) {
        GameDataModel.instance.addGameMatchListener(this);
        this.mTargetSex = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "match_gender"), (int)0);
        super.onGameMatchStart(info, matchConfig);
    }

    private synchronized void startMatch(GameMatchContext gameMatchContext) {
        GameMetricCode.USE_MATCH_TIME = SystemClock.elapsedRealtime();
        this.startMatchInner(gameMatchContext);
    }

    public void startMatchInner(GameMatchContext gameMatchContext) {
        if (gameMatchContext == null) {
            return;
        }
        GameDataModel.instance.gameMatchReq(gameMatchContext.getMyUserInfoKS(), this.mGameInfo, this.mTargetSex, this.mMatchConfig);
    }

    @Override
    public IGameMatchInterface getMatchView(GameInfo gameInfo) {
        return new AllGameMatchPager((Context)this.mContext, this, false);
    }

    @Override
    public void cancelMatch(int errorCode) {
        GameLoger.info("matchGame", "%s \u53d6\u6d88\u5339\u914d\uff0c\u53d6\u6d88\u539f\u56e0 %d", "[\u6e38\u620f\u5339\u914d]", errorCode);
        if (errorCode != 4) {
            GameDataModel.instance.gameMatchCancelReq(2L);
            GameDataModel.instance.stopGameMatchBeat();
            if (errorCode == 3) {
                MatchPoolInviteNotifyRes notifyRes = this.mMatchConfig.getMatchInviteNotify();
                if (notifyRes != null) {
                    if (notifyRes.getInviteeUid() == this.mMatchConfig.getMyUserInfoKS().getUid()) {
                        Boolean accept = notifyRes.getAccept();
                        if (accept == null) {
                            PkMatchPoolStatHelper.INSTANCE.reportInviteClose();
                        } else if (accept.booleanValue()) {
                            PkMatchPoolStatHelper.INSTANCE.reportInviteMatchSuccessClose();
                        }
                    }
                    this.mMatchConfig.setMatchInviteNotify(null);
                    this.mMatchConfig.setOtherUserInfoKs(null);
                }
            } else if (errorCode == 5) {
                ToastUtils.showToast((Activity)this.mContext, (int)R.string.game_match_invite_timeout_toast, (int)1);
            }
        } else {
            this.mGameDownloader.destroy();
        }
        this.stopMatchTimer();
        GameReportHelper.reportGameInfo(GameModel.newBuilder().gameInfo(this.mGameInfo).build(), (int)(System.currentTimeMillis() - this.mStartTime), 0, GameStateDef.GAME_FINISH_REASON.FORCE_FINISH.value(), 1, this.mGameInfo != null && this.mGameInfo.isGoldMode());
        final long matchTime = this.mMatchTime;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PkGameMatcher.this.mGameInfo != null) {
                    HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20023775").put("function_id", "cancel_match").put("match_time", String.valueOf(matchTime)).put("gid", PkGameMatcher.this.mGameInfo.getGid());
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PkGameMatcher.TAG, (String)JsonParser.toJson((Object)hiidoEvent), (Object[])new Object[0]);
                    }
                    HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
                }
            }
        });
        if (this.mMatchConfig != null && this.mMatchConfig.getExtendValue("isMatchAi", (Object)false) != null && ((Boolean)this.mMatchConfig.getExtendValue("isMatchAi", (Object)false)).booleanValue()) {
            this.mMatchConfig.addExtendValue("isMatchAi", (Object)false);
        }
        this.cancelMatchInner();
        this.onMatchFinish(this.mGameInfo, this.mMatchConfig, 2);
    }

    public void cancelMatchInner() {
        this.destroyWindow(this.mGameInfo, this.mMatchConfig);
    }

    @Override
    public void onMatchTipFinish() {
        if (this.mMatchConfig.getMyUserInfoKS() != null) {
            this.initAndStartTimer();
        }
    }

    @Override
    public String getHeadFrameUrl(int frame) {
        return null;
    }

    @Override
    public void onMatchGuideStart() {
    }

    @Override
    public boolean isShowTipAnim() {
        return false;
    }

    @Override
    public void showMplInvalidDialog(MplInvalidType type) {
        IMPLInvalidDialogCallback callback2 = new IMPLInvalidDialogCallback(){

            @Override
            public void onDismiss() {
            }
        };
        MplInvalidDialog dialog2 = new MplInvalidDialog((Context)this.mContext, type, callback2);
        dialog2.show();
        if (type == MplInvalidType.MONEY_LOW) {
            MplReporter.INSTANCE.noRupeeToastShow();
        } else if (type == MplInvalidType.POWER_LOW) {
            MplReporter.INSTANCE.noPowerToastShow();
        }
    }

    @Override
    public boolean isNewGameload() {
        return GameInfo.isNewGameLoad((GameInfo)this.mGameInfo);
    }

    @Override
    public boolean isMatchPoolInvite() {
        return this.mMatchConfig != null && this.mMatchConfig.getMatchInviteNotify() != null;
    }

    @Override
    public synchronized void onGameMatchSuccess(GameMatchNotifyRes gameMatchNotifyRes) {
        GameMatchContext gameMatchContext = this.mMatchConfig;
        MatchPoolInviteNotifyRes matchPoolInviteNotify = gameMatchContext.getMatchInviteNotify();
        gameMatchContext.addExtendValue("isGoldGame", (Object)gameMatchNotifyRes.isGoldGame());
        if (!this.onPreMatchSuccessInner(this.mGameInfo, gameMatchContext, gameMatchNotifyRes.getGameId(), gameMatchNotifyRes.getResource().getRoomid())) {
            return;
        }
        if (matchPoolInviteNotify != null) {
            gameMatchContext.setMatchInviteNotify(null);
            if (this.mFakeDownloader != null) {
                this.mFakeDownloader.stopDownload(true);
                this.mFakeDownloader = null;
            }
            PkMatchPoolStatHelper.INSTANCE.reportInviteGameStart();
        }
        GameLoger.error("baseGame", "[\u6e38\u620f\u5339\u914d]\u5339\u914d\u6210\u529f=%s", gameMatchNotifyRes);
        UserInfoKS temp = new UserInfoKS();
        temp.setNick(gameMatchNotifyRes.getNick());
        temp.setSex((int)gameMatchNotifyRes.getSex());
        temp.setUid(gameMatchNotifyRes.getUid());
        temp.setAvatar(gameMatchNotifyRes.getAvatarUrl());
        UserInfoModule userInfoModule = (UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class);
        UserInfoKS userInfoBean = userInfoModule.updateUserInfoIfNotExist(temp);
        gameMatchContext.setUrl(gameMatchNotifyRes.getResource().getUrl());
        gameMatchContext.setRoomId(gameMatchNotifyRes.getResource().getRoomid());
        gameMatchContext.setOtherUserInfoKs(userInfoBean);
        if (this.mGameInfo != null) {
            final HiidoEvent matchEvent = HiidoEvent.obtain().eventId("20023775").put("function_id", "success_match").put("match_time", String.valueOf(System.currentTimeMillis() - this.mStartTime)).put("gid", this.mGameInfo.getGid());
            long tUid = userInfoBean.getUid();
            if (SystemUtils.isAI((long)tUid)) {
                matchEvent.put("match_type", String.valueOf(2));
            } else {
                matchEvent.put("match_type", String.valueOf(1));
            }
            if (gameMatchContext.getMyUserInfoKS() != null) {
                matchEvent.put("mgender", gameMatchContext.getMyUserInfoKS().getSex() == 0 ? "F" : "M");
                matchEvent.put("tgender", gameMatchContext.getOtherUserInfoKs().getSex() == 0 ? "F" : "M");
            }
            matchEvent.put("match_reason", String.valueOf(gameMatchNotifyRes.getMatchRule()));
            YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PkGameMatcher.TAG, (String)JsonParser.toJson((Object)matchEvent), (Object[])new Object[0]);
                    }
                }
            });
            HiidoStatis.reportEvent((HiidoEvent)matchEvent);
        }
        if (this.mInviteSuccessWaitTimeoutRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mInviteSuccessWaitTimeoutRunnable);
            this.mInviteSuccessWaitTimeoutRunnable = null;
        }
        if (this.matchSuccessRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.matchSuccessRunnable);
        }
        this.matchSuccessRunnable = new MatchSuccessRunnable(gameMatchContext);
        YYTaskExecutor.postToMainThread((Runnable)this.matchSuccessRunnable, (long)860L);
        this.onMatchSuccessView(gameMatchContext, gameMatchNotifyRes.getMatchTips());
    }

    @Override
    public void onMatchInviteNotify(MatchPoolInviteNotifyRes notifyRes) {
        if (this.mMatchConfig != null && notifyRes != null) {
            UserInfoKS myInfo;
            MLog.debug((Object)TAG, (String)("onGameMatchInvite notifyRes:" + notifyRes), (Object[])new Object[0]);
            this.mMatchConfig.setMatchInviteNotify(notifyRes);
            IGameInfoService gameInfoService2 = (IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class);
            if (gameInfoService2 != null) {
                this.mInviteGameInfo = gameInfoService2.getGameInfoByGid(notifyRes.getGameId());
            }
            if ((myInfo = this.mMatchConfig.getMyUserInfoKS()) != null && myInfo.getUid() == notifyRes.getInviteeUid()) {
                this.onGameMatchInviteForInvitee();
            } else if (myInfo != null && myInfo.getUid() == notifyRes.getInviterUid()) {
                this.onGameMatchInviteForInviter();
            } else {
                MLog.warn((Object)TAG, (String)"onGameMatchInvite ignore, myInfo is null: %b,inviterUid: %d, inviteeUid: %d", (Object[])new Object[]{myInfo == null, notifyRes.getInviterUid(), notifyRes.getInviteeUid()});
            }
        }
    }

    @Override
    public void onMatchInviteResponse(MatchPoolAnswerNotifyRes answerNotify) {
        if (answerNotify == null) {
            MLog.warn((Object)TAG, (String)"onGameMatchAnswer ignore, answerNotify is null", (Object[])new Object[0]);
            return;
        }
        if (this.mInviteSuccessWaitTimeoutRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mInviteSuccessWaitTimeoutRunnable);
            this.mInviteSuccessWaitTimeoutRunnable = null;
        }
        if (answerNotify.getAccepted()) {
            MatchPoolInviteNotifyRes inviteNotify = this.mMatchConfig.getMatchInviteNotify();
            if (inviteNotify != null && !StringUtils.equal((String)inviteNotify.getInviteId(), (String)answerNotify.getInviteId())) {
                MLog.warn((Object)TAG, (String)"onMatchInviteResponse accept ignore, invited is equal", (Object[])new Object[0]);
                return;
            }
            this.handleMatchInviteResponse(answerNotify);
        } else {
            MatchPoolInviteNotifyRes inviteNotify = this.mMatchConfig.getMatchInviteNotify();
            if (inviteNotify == null) {
                MLog.warn((Object)TAG, (String)"onMatchInviteResponse cancel ignore, inviteNotify is null", (Object[])new Object[0]);
                return;
            }
            if (!StringUtils.equal((String)inviteNotify.getInviteId(), (String)answerNotify.getInviteId())) {
                MLog.warn((Object)TAG, (String)"onMatchInviteResponse cancel ignore, inviteId: %s is not equal to %s", (Object[])new Object[]{inviteNotify.getInviteId(), answerNotify.getInviteId()});
                return;
            }
            MatchPoolAnswerNotifyRes.Builder builder = answerNotify.newBuilder();
            builder.setInviterUid(inviteNotify.getInviterUid());
            builder.setInviteeUid(inviteNotify.getInviteeUid());
            this.handleMatchInviteResponse(builder.build());
        }
    }

    private void handleMatchInviteResponse(@NotNull MatchPoolAnswerNotifyRes answerNotify) {
        UserInfoKS myInfo = this.mMatchConfig.getMyUserInfoKS();
        if (myInfo == null) {
            return;
        }
        if (myInfo.getUid() == answerNotify.getInviterUid()) {
            this.handleMatchInviteResponseForInviter(answerNotify);
        } else if (myInfo.getUid() == answerNotify.getInviteeUid()) {
            this.handleMatchInviteResponseForInvitee(answerNotify);
        }
    }

    private void handleMatchInviteResponseForInviter(@NotNull MatchPoolAnswerNotifyRes answerNotify) {
        UserInfoKS myInfo = this.mMatchConfig.getMyUserInfoKS();
        if (myInfo == null) {
            return;
        }
        MLog.debug((Object)TAG, (String)("handleMatchInviteResponseForInviter accept: " + answerNotify.getAccepted()), (Object[])new Object[0]);
        if (answerNotify.getAccepted()) {
            MatchPoolInviteNotifyRes.Builder builder = new MatchPoolInviteNotifyRes.Builder();
            builder.setInviteId(answerNotify.getInviteId());
            builder.setGameId(this.mGameInfo.getGid());
            builder.setGameVer((long)StringUtils.safeParseInt((String)this.mGameInfo.getModulerVer()));
            builder.setInviteeUid(answerNotify.getInviteeUid());
            builder.setInviterUid(answerNotify.getInviterUid());
            builder.setInviterNick(myInfo.getNick());
            builder.setInviterSex((long)myInfo.getSex());
            builder.setInviterAvatar(myInfo.getAvatar());
            this.mMatchConfig.setMatchInviteNotify(builder.build());
            UserInfoKS temp = new UserInfoKS();
            temp.setNick(answerNotify.getInviteeNick());
            temp.setSex((int)answerNotify.getInviteeSex());
            temp.setUid(answerNotify.getInviteeUid());
            temp.setAvatar(answerNotify.getInviteeAvatar());
            UserInfoModule userInfoModule = (UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class);
            UserInfoKS inviteeInfo = userInfoModule.updateUserInfoIfNotExist(temp);
            this.mMatchConfig.setOtherUserInfoKs(inviteeInfo);
            this.onMatchInviteViewUpdate(inviteeInfo);
            if (this.mMatchGameWindow != null) {
                this.mFakeDownloader = new GameFakeDownloadPresenter(this.mGameInfo);
                this.mFakeDownloader.getDownloadProgress().observe((LifecycleOwner)this.mMatchGameWindow.mLifeCycleOwner, (Observer)new Observer<Integer>(){

                    public void onChanged(Integer progress) {
                        MLog.debug((Object)PkGameMatcher.TAG, (String)("fakeDownloader onChange progress: " + progress), (Object[])new Object[0]);
                        if (PkGameMatcher.this.mMatchGameWindow != null) {
                            PkGameMatcher.this.mMatchGameWindow.updateUserProgress(false, progress);
                        }
                    }
                });
                this.mFakeDownloader.startDownload();
            }
            if (this.mInviteSuccessWaitTimeoutRunnable != null) {
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mInviteSuccessWaitTimeoutRunnable);
                this.mInviteSuccessWaitTimeoutRunnable = null;
            }
            this.mInviteSuccessWaitTimeoutRunnable = new Runnable(){

                @Override
                public void run() {
                    if (PkGameMatcher.this.mInviteSuccessWaitTimeoutRunnable != null) {
                        PkGameMatcher.this.cancelMatch(5);
                    }
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)this.mInviteSuccessWaitTimeoutRunnable, (long)62000L);
            PkMatchPoolStatHelper.INSTANCE.reportInviteMatchSuccess();
        } else {
            UserInfoKS otherInfo = this.mMatchConfig.getOtherUserInfoKs();
            if (otherInfo != null && otherInfo.getUid() == answerNotify.getInviteeUid()) {
                this.mMatchConfig.setOtherUserInfoKs(null);
                if (this.mFakeDownloader != null) {
                    this.mFakeDownloader.stopDownload(false);
                }
                ToastUtils.showToast((Activity)this.mContext, (int)R.string.game_match_invite_fail_toast, (int)1);
                this.onMatchRecoverViewUpdate();
            }
            this.mMatchConfig.setMatchInviteNotify(null);
        }
    }

    private void handleMatchInviteResponseForInvitee(@NotNull MatchPoolAnswerNotifyRes answerNotify) {
        MLog.debug((Object)TAG, (String)("handleMatchInviteResponseForInvitee accept: " + answerNotify.getAccepted()), (Object[])new Object[0]);
        MatchPoolInviteNotifyRes inviteNotify = this.mMatchConfig.getMatchInviteNotify();
        if (inviteNotify == null) {
            MLog.debug((Object)TAG, (String)"handleGameMatchAnswerForInvitee ignore, inviteNotify is null", (Object[])new Object[0]);
            return;
        }
        if (!answerNotify.getAccepted()) {
            UserInfoKS otherUserInfo = this.mMatchConfig.getOtherUserInfoKs();
            if (otherUserInfo != null && otherUserInfo.getUid() == answerNotify.getInviterUid()) {
                this.mMatchConfig.setOtherUserInfoKs(null);
                this.mMatchConfig.setLastInviteId(inviteNotify.getInviteId());
                ToastUtils.showToast((Activity)this.mContext, (int)R.string.game_match_invite_fail_toast, (int)1);
                this.onMatchRecoverViewUpdate();
                Boolean accept = inviteNotify.getAccept();
                MLog.debug((Object)TAG, (String)("handleMatchInviteResponseForInvitee inviteNotify accept: " + accept), (Object[])new Object[0]);
                if (accept == null) {
                    PkMatchPoolStatHelper.INSTANCE.reportInviteCancel();
                } else if (accept.booleanValue()) {
                    PkMatchPoolStatHelper.INSTANCE.reportInviteSuccessCancel();
                }
            }
            this.mMatchConfig.setMatchInviteNotify(null);
        }
    }

    @Override
    public void answerMatchInvite(boolean accept) {
        this.answerMatchInvite(accept, false);
    }

    private void answerMatchInvite(boolean accept, boolean isTimeout) {
        if (this.mMatchGameWindow == null) {
            MLog.warn((Object)TAG, (String)"answerMatchInvite fail, matchGameWindow is null", (Object[])new Object[0]);
            return;
        }
        if (this.mMatchInviteTimeoutRunnable != null) {
            this.mMatchInviteTimeoutRunnable.cancel();
            this.mMatchInviteTimeoutRunnable = null;
        }
        this.mMatchGameWindow.hideInviteNotice();
        MatchPoolInviteNotifyRes inviteNotifyRes = this.mMatchConfig.getMatchInviteNotify();
        if (inviteNotifyRes == null) {
            MLog.warn((Object)TAG, (String)"answerMatchInvite accept: %b error, inviteNotifyRes is null", (Object[])new Object[0]);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"answerMatchInvite accept: %b, isTimeout: %b", (Object[])new Object[]{accept, isTimeout});
        }
        if (accept) {
            inviteNotifyRes.setAccept(Boolean.valueOf(true));
            this.onAnswerMatchInviteAccept(this.mMatchGameWindow, inviteNotifyRes);
        } else {
            inviteNotifyRes.setAccept(Boolean.valueOf(false));
            this.onAnswerMatchInviteReject(this.mMatchGameWindow, inviteNotifyRes);
        }
        PkMatchPoolStatHelper.INSTANCE.reportInviteAction(accept, isTimeout);
    }

    private void onAnswerMatchInviteAccept(@NotNull MatchGameWindow matchGameWindow, @NotNull MatchPoolInviteNotifyRes inviteNotifyRes) {
        this.mGameInfo = this.mInviteGameInfo;
        GameDataModel.instance.setMatchGameId(this.mInviteGameInfo.getGid());
        if (this.mMatchGameWindow != null) {
            this.mMatchGameWindow.updateGameInfo(this.mGameInfo);
        }
        MatchPoolInviteAnswerReq.Builder answerReqBuilder = new MatchPoolInviteAnswerReq.Builder();
        answerReqBuilder.setAccept(true);
        answerReqBuilder.setGameId(this.mInviteGameInfo.getGid());
        answerReqBuilder.setInviteId(inviteNotifyRes.getInviteId());
        UserInfoKS myInfo = this.mMatchConfig.getMyUserInfoKS();
        if (myInfo != null) {
            answerReqBuilder.setInviteeUid(myInfo.getUid());
            answerReqBuilder.setInviteeSex((long)myInfo.getSex());
            answerReqBuilder.setInviteeNick(myInfo.getNick());
            answerReqBuilder.setInviteeAvatar(myInfo.getAvatar());
        }
        this.mMatchDownloader = new GameDownloadPresenter(this.mInviteGameInfo);
        if (this.mMatchDownloader.isGameValid(this.mInviteGameInfo, true)) {
            answerReqBuilder.setNeedDownload(false);
            answerReqBuilder.setGameVer((long)StringUtils.safeParseInt((String)this.mInviteGameInfo.getModulerVer()));
        } else {
            answerReqBuilder.setNeedDownload(true);
            answerReqBuilder.setGameVer(0L);
            this.mMatchDownloader.getHasDownloadPkg().observe((LifecycleOwner)matchGameWindow.mLifeCycleOwner, (Observer)new Observer<Integer>(){

                public void onChanged(Integer state) {
                    if (PkGameMatcher.this.mMatchDownloader == null) {
                        return;
                    }
                    MLog.debug((Object)PkGameMatcher.TAG, (String)("matchDownloader onChange state: " + state), (Object[])new Object[0]);
                    if (state == 2) {
                        String inviteId;
                        MatchPoolInviteNotifyRes inviteNotifyRes = PkGameMatcher.this.mMatchConfig.getMatchInviteNotify();
                        if (inviteNotifyRes == null) {
                            MLog.warn((Object)PkGameMatcher.TAG, (String)"download finish inviteNotifyRes is null", (Object[])new Object[0]);
                            inviteId = PkGameMatcher.this.mMatchConfig.getLastInviteId();
                        } else {
                            inviteId = inviteNotifyRes.getInviteId();
                        }
                        MatchPoolDownloadFinishReq.Builder builder = new MatchPoolDownloadFinishReq.Builder();
                        builder.setInviteId(inviteId);
                        builder.setGameId(PkGameMatcher.this.mGameInfo.getGid());
                        builder.setGameVer((long)StringUtils.safeParseInt((String)PkGameMatcher.this.mGameInfo.getModulerVer()));
                        GameDataModel.instance.answerMatchPoolDownloadFinish(builder.build());
                        if (PkGameMatcher.this.mMatchGameWindow != null) {
                            PkGameMatcher.this.mMatchGameWindow.updateUserProgress(true, 100);
                        }
                        PkGameMatcher.this.mMatchDownloader = null;
                    } else if (state == 0 && PkGameMatcher.this.mMatchGameWindow != null) {
                        PkGameMatcher.this.mMatchGameWindow.updateUserProgress(true, 0);
                    }
                }
            });
            this.mMatchDownloader.getDownloadProgress().observe((LifecycleOwner)matchGameWindow.mLifeCycleOwner, (Observer)new Observer<Long>(){

                public void onChanged(Long progress) {
                    MLog.debug((Object)PkGameMatcher.TAG, (String)("matchDownloader onChangeProgress: " + progress), (Object[])new Object[0]);
                    if (PkGameMatcher.this.mMatchGameWindow != null) {
                        PkGameMatcher.this.mMatchGameWindow.updateUserProgress(true, progress.intValue());
                    }
                }
            });
            this.mMatchDownloader.checkGameDownload(this.mInviteGameInfo, true, true);
            if (this.mInviteSuccessWaitTimeoutRunnable != null) {
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mInviteSuccessWaitTimeoutRunnable);
                this.mInviteSuccessWaitTimeoutRunnable = null;
            }
            this.mInviteSuccessWaitTimeoutRunnable = new Runnable(){

                @Override
                public void run() {
                    if (PkGameMatcher.this.mInviteSuccessWaitTimeoutRunnable != null) {
                        PkGameMatcher.this.cancelMatch(5);
                    }
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)this.mInviteSuccessWaitTimeoutRunnable, (long)62000L);
        }
        GameDataModel.instance.answerMatchPoolInvite(answerReqBuilder.build());
        PkMatchPoolStatHelper.INSTANCE.reportInviteMatchSuccess();
    }

    private void onAnswerMatchInviteReject(@NotNull MatchGameWindow matchGameWindow, @NotNull MatchPoolInviteNotifyRes inviteNotifyRes) {
        this.mInviteGameInfo = null;
        this.mMatchConfig.setOtherUserInfoKs(null);
        this.mMatchConfig.setMatchInviteNotify(null);
        MatchPoolInviteAnswerReq.Builder answerReqBuilder = new MatchPoolInviteAnswerReq.Builder();
        answerReqBuilder.setAccept(false);
        answerReqBuilder.setInviteId(inviteNotifyRes.getInviteId());
        GameDataModel.instance.answerMatchPoolInvite(answerReqBuilder.build());
        this.onMatchRecoverViewUpdate();
    }

    protected void onGameMatchInviteForInviter() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onGameMatchInviteForInviter", (Object[])new Object[0]);
        }
    }

    protected void onGameMatchInviteForInvitee() {
        MatchPoolInviteNotifyRes notifyRes = this.mMatchConfig.getMatchInviteNotify();
        if (notifyRes == null) {
            return;
        }
        if (this.mInviteGameInfo == null) {
            MLog.warn((Object)TAG, (String)("onGameMatchInviteForInvitee auto reject game: " + notifyRes.getGameId() + " because not found gameInfo"), (Object[])new Object[0]);
            this.answerMatchInvite(false, false);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onGameMatchInviteForInvitee", (Object[])new Object[0]);
        }
        UserInfoKS temp = new UserInfoKS();
        temp.setNick(notifyRes.getInviterNick());
        temp.setSex((int)notifyRes.getInviterSex());
        temp.setUid(notifyRes.getInviterUid());
        temp.setAvatar(notifyRes.getInviterAvatar());
        UserInfoModule userInfoModule = (UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class);
        UserInfoKS inviterInfo = userInfoModule.updateUserInfoIfNotExist(temp);
        this.mMatchConfig.setOtherUserInfoKs(inviterInfo);
        this.onMatchInviteViewUpdate(inviterInfo);
        if (this.mMatchInviteTimeoutRunnable != null) {
            this.mMatchInviteTimeoutRunnable.cancel();
            this.mMatchInviteTimeoutRunnable = null;
        }
        this.mMatchInviteTimeoutRunnable = new MatchInviteTimeoutRunnable(5000L);
        this.mMatchInviteTimeoutRunnable.run();
        PkMatchPoolStatHelper.INSTANCE.reportInviteExposure();
    }

    private void onMatchInviteViewUpdate(UserInfoKS otherInfo) {
        if (this.mMatchGameWindow != null) {
            this.stopMatchTimer();
            this.mMatchGameWindow.updateotherView(otherInfo);
            this.onMatchSuccessView(this.mMatchConfig, "");
            IGameMatchInterface matchPager = this.mMatchGameWindow.getGameMatchPager();
            if (matchPager != null) {
                matchPager.updateTVMatch(GameDef.MatchStatus.MATCHING_SUCCESS, "");
            }
        }
    }

    private void onMatchRecoverViewUpdate() {
        if (this.mMatchGameWindow != null) {
            this.startGameMatchTimer();
            this.mMatchGameWindow.startMatchAnim();
        }
    }

    private void onMatchSuccessView(GameMatchContext gameMatchContext, String matchTips) {
        if (this.mMatchGameWindow == null || gameMatchContext == null) {
            return;
        }
        UserInfoKS userInfoBean = gameMatchContext.getOtherUserInfoKs();
        this.stopMatchTimer();
        this.mMatchGameWindow.stopMatchAnim();
        this.mMatchGameWindow.updateTVMatch(GameDef.MatchStatus.MATCHING_SUCCESS, matchTips);
        this.mMatchGameWindow.updateotherView(userInfoBean);
        this.getOtherHeadFrame(userInfoBean, this.mGameInfo);
        this.mMatchGameWindow.startMatchSuccessAnim();
        ((IGameAudioService)this.getServiceManager().getService(IGameAudioService.class)).play("pkMatchingSuccessVoice");
    }

    @Override
    public void onGameMatchFail(int failType) {
        this.stopMatchTimer();
        GameReportHelper.reportGameInfo(this.mMatchConfig.update2GameModel(this.mGameInfo), (int)(System.currentTimeMillis() - this.mStartTime), 0, GameStateDef.GAME_FINISH_REASON.LOAD_FAIL.value(), 1, this.mGameInfo != null && this.mGameInfo.isGoldMode());
        if (failType == 7) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"NOT_HAVE_UID", (Object[])new Object[0]);
            }
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.match_fail), (int)0);
        } else if (failType == 4) {
            MLog.error((Object)TAG, (String)"NOT_HAVE_GAME", (Object[])new Object[0]);
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.nogame_matchfail_tip), (int)0);
        } else if (failType == 5 || failType == 6) {
            boolean isMaintain = failType == 5;
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)(isMaintain ? R.string.game_maintening : R.string.tips_game_full)), (int)1);
        } else if (failType == 8) {
            MLog.error((Object)TAG, (String)"match failed:mpl_id is invalid", (Object[])new Object[0]);
            this.showMplInvalidDialog(MplInvalidType.GAME_INVALID);
        } else if (failType == 9) {
            MLog.error((Object)TAG, (String)"match failed:power low", (Object[])new Object[0]);
            this.showMplInvalidDialog(MplInvalidType.POWER_LOW);
        } else if (failType == 10) {
            MLog.error((Object)TAG, (String)"match failed:money low", (Object[])new Object[0]);
            this.showMplInvalidDialog(MplInvalidType.MONEY_LOW);
        }
        this.destroyWindow(this.mGameInfo, this.mMatchConfig);
        this.onMatchFinish(this.mGameInfo, this.mMatchConfig, failType);
    }

    @Override
    public void onGameMatchRetry() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"MATCH_OVER_TIME", (Object[])new Object[0]);
        }
        if (this.mMatchGameWindow != null && this.mGameInfo != null) {
            if (this.mTimeOutNumber >= 5) {
                boolean isGameFirstPageOpen;
                GameReportHelper.reportGameInfo(this.mMatchConfig.update2GameModel(this.mGameInfo), (int)(System.currentTimeMillis() - this.mStartTime), 0, GameStateDef.GAME_FINISH_REASON.OVER_TIME.value(), 1, this.mGameInfo.isGoldMode());
                TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.internet_unstable), (int)0);
                if (RuntimeContext.sIsDebuggable && (isGameFirstPageOpen = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false)) && this.mMatchGameWindow != null) {
                    this.mMatchGameWindow.stopMatchAnim();
                    MatchGameWindow window = this.mMatchGameWindow;
                    this.mMatchGameWindow = null;
                    this.mWindowMgr.popWindow(true, (AbstractWindow)window);
                    Message message = new Message();
                    message.what = BaseMsgDef.MSG_GAME_FIRST_PAGE_AUTO_TEST;
                    message.obj = this.mGameInfo.getGid();
                    this.sendMessage(message);
                    return;
                }
                this.onMatchFinish(this.mGameInfo, this.mMatchConfig, 3);
                this.destroyWindow(this.mGameInfo, this.mMatchConfig);
                long time = GameMetricCode.USE_MATCH_TIME > 0L ? SystemClock.elapsedRealtime() - GameMetricCode.USE_MATCH_TIME : 0L;
                GameMetricCode.USE_MATCH_TIME = 0L;
                GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchReq", time, "1000");
            } else {
                ++this.mTimeOutNumber;
                this.startMatchInner(this.mMatchConfig);
            }
        }
    }

    private void getOtherHeadFrame(UserInfoKS userInfoKS, GameInfo gameInfo) {
        if (gameInfo.getGameMode() == 1) {
            ((IHonorService)this.getServiceManager().getService(IHonorService.class)).getSingleHeadFrame(userInfoKS.getUid(), new OnGetHeadFrameCallback(){

                public void onGetHeadFrameSuccess(List<Integer> list) {
                    if (list != null && !list.isEmpty() && PkGameMatcher.this.mMatchGameWindow != null && PkGameMatcher.this.mMatchGameWindow.getGameMatchPager() != null && PkGameMatcher.this.mMatchGameWindow.getGameMatchPager() instanceof AllGameMatchPager) {
                        ((AllGameMatchPager)PkGameMatcher.this.mMatchGameWindow.getGameMatchPager()).updateOtherHeadFrame(list.get(0));
                    }
                }

                public void onError(Call call, Exception e, int id2) {
                }

                public void onResponseError(int id2, String message, String response) {
                }
            });
        }
    }

    @Override
    public void popMatchGameWindow(boolean makeGameWindowNull) {
        if (this.mMatchGameWindow != null) {
            this.mMatchGameWindow.startMatchAnim();
        }
        super.popMatchGameWindow(makeGameWindowNull);
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.reset();
        if (abstractWindow == this.mMatchGameWindow) {
            this.mMatchGameWindow = null;
        }
        this.stopMatchTimer();
    }

    @Override
    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        GameDataModel.instance.stopGameMatchBeat();
        if (this.mMatchGameWindow != null) {
            this.mMatchGameWindow.stopMatchTipAnim();
        }
    }

    protected boolean onWindowBackKeyEvent() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onWindowBackKeyEvent FORCE_CANCEL", (Object[])new Object[0]);
        }
        this.cancelMatch(3);
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        MLog.debug((Object)TAG, (String)"reset", (Object[])new Object[0]);
        this.stopMatchTimer();
        if (this.mInviteSuccessWaitTimeoutRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mInviteSuccessWaitTimeoutRunnable);
            this.mInviteSuccessWaitTimeoutRunnable = null;
        }
        if (this.matchSuccessRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.matchSuccessRunnable);
            this.matchSuccessRunnable = null;
        }
        this.bInitTimer = false;
        this.mTimeOutNumber = 0;
        if (this.mMatchInviteTimeoutRunnable != null) {
            this.mMatchInviteTimeoutRunnable.cancel();
            this.mMatchInviteTimeoutRunnable = null;
        }
        if (this.mMatchDownloader != null) {
            this.mMatchDownloader.destroy();
            this.mMatchDownloader = null;
        }
        if (this.mFakeDownloader != null) {
            this.mFakeDownloader.stopDownload(false);
            this.mFakeDownloader = null;
        }
    }

    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        boolean retVal = false;
        if (keyCode == 4 && event.getAction() == 1) {
            if (!this.mIsMatchSuccess) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"onWindowKeyEvent KEYCODE_BACK ACTION_UP", (Object[])new Object[0]);
                }
                this.cancelMatch(3);
            }
            return true;
        }
        return retVal;
    }

    class MatchInviteTimeoutRunnable
    implements Runnable {
        private long mCountDown;
        private CharSequence mInviteTip;
        private boolean pass;

        MatchInviteTimeoutRunnable(long countDown) {
            this.mCountDown = countDown;
            MatchPoolInviteNotifyRes notifyRes = PkGameMatcher.this.mMatchConfig.getMatchInviteNotify();
            if (notifyRes == null || PkGameMatcher.this.mInviteGameInfo == null) {
                MLog.debug((Object)PkGameMatcher.TAG, (String)"MatchInviteTimeoutRunnable fail, notifyRes or inviteGameInfo is null", (Object[])new Object[0]);
                this.pass = false;
            } else {
                this.pass = true;
                String name = PkGameMatcher.this.mInviteGameInfo.getGname();
                String tip = notifyRes.getInviterSex() == 1L ? ResourceUtils.getString((int)R.string.game_match_invite_male_tip, (Object[])new Object[]{name}) : ResourceUtils.getString((int)R.string.game_match_invite_female_tip, (Object[])new Object[]{name});
                int index = tip.indexOf(name);
                this.mInviteTip = SpannableStringUtil.getSpannableString((SpannableStringUtil.ISpannableBlock[])new SpannableStringUtil.ISpannableBlock[]{new SpannableStringUtil.SpannableStringBlock((CharSequence)tip.substring(0, index), ResourceUtils.getColor((int)R.color.color_999999)), new SpannableStringUtil.SpannableStringBlock((CharSequence)name, ResourceUtils.getColor((int)R.color.color_ffc102)), new SpannableStringUtil.SpannableStringBlock((CharSequence)tip.substring(index + name.length()), ResourceUtils.getColor((int)R.color.color_999999))});
            }
        }

        void cancel() {
            this.pass = false;
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this);
        }

        @Override
        public void run() {
            if (this.pass) {
                if (PkGameMatcher.this.mMatchGameWindow != null) {
                    if (this.mCountDown > 0L) {
                        PkGameMatcher.this.mMatchGameWindow.showInviteNotice(PkGameMatcher.this.mInviteGameInfo, this.mInviteTip, this.mCountDown);
                    } else {
                        PkGameMatcher.this.answerMatchInvite(true, true);
                        return;
                    }
                }
                this.mCountDown -= 1000L;
                YYTaskExecutor.postToMainThread((Runnable)this, (long)1000L);
            }
        }
    }

    class MatchSuccessRunnable
    implements Runnable {
        GameMatchContext gameMatchContext;

        MatchSuccessRunnable(GameMatchContext context) {
            this.gameMatchContext = context;
        }

        @Override
        public void run() {
            PkGameMatcher.this.onMatchFinish(PkGameMatcher.this.mGameInfo, this.gameMatchContext, 0);
            PkGameMatcher.this.destroyWindow(PkGameMatcher.this.mGameInfo, this.gameMatchContext);
        }
    }
}

