/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.gameresult.ui;

import android.animation.AnimatorSet;
import android.content.Context;
import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.GameCooperationRank;
import com.yy.game.bean.GameResultMsgBean;
import com.yy.game.gamemodule.pkgame.gameresult.GameResultViewFactory;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultUICallbacks;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultView;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.coins.GameCoinResult;
import java.util.LinkedList;
import net.ihago.money.api.mpl.GetUserVitalityRupeeRes;

public class GameResultWindow
extends DefaultWindow {
    private IGameResultUICallbacks mGameResultCallbacks;
    private IGameResultView mGameResultView;
    private DialogLinkManager mDialogLinkManager;
    private boolean isGlodGame;

    public GameResultWindow(Context context, UICallBacks callBacks) {
        super(context, callBacks, "GameResult");
    }

    public GameResultWindow(Context context, UICallBacks callBacks, AbstractWindow.WindowLayerType useLayerType, boolean isGlodGame) {
        super(context, callBacks, useLayerType, "GameResult");
        if (callBacks instanceof IGameResultUICallbacks) {
            this.mGameResultCallbacks = (IGameResultUICallbacks)callBacks;
        }
        this.isGlodGame = isGlodGame;
        this.initView();
        this.setWindowType(102);
        this.setPushAnimationType(3);
        this.setNeedFullScreen(true);
        this.setOnClickListener(v -> {});
    }

    public IGameResultUICallbacks getmGameResultCallbacks() {
        return this.mGameResultCallbacks;
    }

    public void setmGameResultCallbacks(IGameResultUICallbacks mGameResultCallbacks) {
        this.mGameResultCallbacks = mGameResultCallbacks;
    }

    public void initView() {
        if (this.mGameResultView == null && this.mGameResultCallbacks != null && this.mGameResultCallbacks.getGameModel() != null) {
            if (this.mGameResultCallbacks.getGameModel().getGameInfo() != null) {
                this.mGameResultCallbacks.getGameModel().getGameInfo().setGoldGame(this.isGlodGame);
            }
            this.mGameResultView = GameResultViewFactory.getSingleton().getResultView(this.getContext(), this.mGameResultCallbacks.getGameModel().getGameInfo(), this.mGameResultCallbacks);
        }
        this.mGameResultView.showView(this.getBaseLayer());
    }

    public void startLikeAnim() {
        this.mGameResultView.startLikeAnim();
    }

    public void updateScore(int myScore, int otherScore) {
        this.mGameResultView.updateScore(myScore, otherScore);
    }

    public void updateDoubleScore(int score) {
        if (this.mGameResultView != null) {
            this.mGameResultView.updateDoubleScore(score);
        }
    }

    public void showScoreError(int reason) {
        this.mGameResultView.showScoreError(reason);
    }

    public void updateSceneView(int gameScene) {
        this.mGameResultView.updateSceneView(gameScene);
    }

    public void updateUserInfo(UserInfoBean myinfo, UserInfoBean otherinfo) {
        this.mGameResultView.updateUserInfo(myinfo, otherinfo);
    }

    public void update2v2UserInfos(UserInfoKS me, UserInfoKS friends, UserInfoKS other0, UserInfoKS other1) {
        this.mGameResultView.update2v2UserInfos(me, friends, other0, other1);
    }

    public void setBtnDisable() {
        this.mGameResultView.setBtnDisable();
    }

    public void updateResultBG(GameDef.GameResult result, boolean showNewRegisterGameResult, int lastWinCount) {
        this.mGameResultView.updateResultBG(result, showNewRegisterGameResult, lastWinCount);
    }

    public void showLoadingDialog() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.getContext());
        }
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
    }

    public void hideLoadingDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
        this.mDialogLinkManager = null;
    }

    public AnimatorSet getPushAnimator(AbstractWindow backWindow) {
        if (this.mGameResultView == null) {
            return null;
        }
        return this.mGameResultView.getPushAnimator((AbstractWindow)this, backWindow);
    }

    public void updateBtnTextFromPlayWithAI() {
        this.mGameResultView.updateBtnTextFromPlayWithAI();
    }

    public void updateChangeOption(boolean isHide) {
        this.mGameResultView.updateChangeOption(isHide);
    }

    public void showLikeGuide() {
        this.mGameResultView.showLikeGuide();
    }

    public void onOtherLeft(boolean isLeft) {
        this.mGameResultView.updateOtherStatus(isLeft);
        this.mGameResultView.setPlayAgainEnable(false);
    }

    public void onMessageArrived(LinkedList<GameResultMsgBean> imMessageQueue) {
        this.mGameResultView.onMessageArrived(imMessageQueue);
    }

    public void onMessageSend(LinkedList<GameResultMsgBean> imMessageQueue) {
        this.mGameResultView.onMessageSend(imMessageQueue);
    }

    public void clearMsg(boolean isMe) {
        this.mGameResultView.clearMsg(isMe);
    }

    public void showEmoj(EmojiBean emojiBean, int postion) {
        this.mGameResultView.showEmoj(emojiBean, postion);
    }

    public void showBarrageView(BarrageInfo barrageInfo) {
        this.mGameResultView.showBarrageView(barrageInfo);
    }

    public void updateOtherHeadFrameType(int frame) {
        this.mGameResultView.updateOtherHeadFrameType(frame);
    }

    public void updateJoinBtn(GameDef.PKGameInviteStatus type) {
        this.mGameResultView.updateJoinBtn(type);
        if (StringUtils.isNotEmpty((String)this.mGameResultCallbacks.getGamePlayContext().getExtendValue("mpl_id", (Object)"").toString())) {
            this.mGameResultView.updateJoinBtn(GameDef.PKGameInviteStatus.PLAY_AGAIN);
        }
    }

    public CharSequence getMsgText(GameDef.PKGameInviteStatus type, String gameName) {
        return this.mGameResultView.getMsgText(type, gameName);
    }

    public void updateLike(boolean isEnable) {
        this.mGameResultView.updateLike(isEnable);
    }

    public void showLikeTip() {
        this.mGameResultView.showLikeTip();
    }

    public void updateScoreRank(GameCooperationRank data) {
        if (this.mGameResultView != null) {
            this.mGameResultView.updateScoreRank(data);
        }
    }

    public void showUserLeaveTip(String exitReason) {
        if (this.mGameResultView != null) {
            this.mGameResultView.showUserLeaveTip(exitReason);
        }
    }

    public void startLightAnim() {
        if (this.mGameResultView != null) {
            this.mGameResultView.startLightAnim();
        }
    }

    public void stopLightAnim() {
        if (this.mGameResultView != null) {
            this.mGameResultView.cancelLightAnim();
        }
    }

    public void onShown() {
        super.onShown();
        if (this.mGameResultView != null) {
            this.mGameResultView.onShow();
            AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.FINISH_SHOW_TOTAL));
        }
    }

    public void onHidden() {
        super.onHidden();
        if (this.mGameResultView != null) {
            this.mGameResultView.onHidden();
        }
    }

    public void resetJoinTips() {
        if (this.mGameResultView != null) {
            this.mGameResultView.resetJoinTips();
        }
    }

    public void showChangeOpponent() {
        if (this.mGameResultView != null) {
            this.mGameResultView.showChangeOpponent();
        }
    }

    public void showCoinResult(String tips, GameCoinResult result) {
        if (this.mGameResultView != null) {
            this.mGameResultView.showCoinResult(tips, result);
        }
    }

    public void hideMoreGame() {
        if (this.mGameResultView != null) {
            this.mGameResultView.hideMoreGameBtn();
        }
    }

    public void initForMpl(final int myGameResult) {
        if (this.mGameResultView != null) {
            this.mGameResultCallbacks.getMplRewardLimit(new ICommonCallback<GetUserVitalityRupeeRes>(){

                public void onSuccess(GetUserVitalityRupeeRes getUserVitalityRupeeRes, Object ... ext) {
                    int rewardCount;
                    int rewardType = (Integer)GameResultWindow.this.mGameResultCallbacks.getGamePlayContext().getExtendValue("mpl_award_type", (Object)-1);
                    int showCount = rewardCount = ((Integer)GameResultWindow.this.mGameResultCallbacks.getGamePlayContext().getExtendValue("mpl_award_cost", (Object)-1)).intValue();
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"AbstractWindow", (String)"initForMpl , shouldWin: %s, maxWinRupee: %s, maxWinPower: %s", (Object[])new Object[]{rewardCount, getUserVitalityRupeeRes.limit_rupee, getUserVitalityRupeeRes.limit_vitality});
                    }
                    if (rewardCount == -1) {
                        return;
                    }
                    if (rewardType == -1) {
                        return;
                    }
                    if (rewardType == 2) {
                        showCount = getUserVitalityRupeeRes.limit_rupee < (long)rewardCount ? getUserVitalityRupeeRes.limit_rupee.intValue() : rewardCount;
                    } else if (rewardType == 1) {
                        showCount = getUserVitalityRupeeRes.limit_vitality < (long)rewardCount ? getUserVitalityRupeeRes.limit_vitality.intValue() : rewardCount;
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"AbstractWindow", (String)"showCount: %s", (Object[])new Object[]{showCount});
                    }
                    GameResultWindow.this.mGameResultView.initForMpl(myGameResult, rewardType, showCount);
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"AbstractWindow", (String)("getMplRewardLimit fail:" + msg), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    public void othersSayHelloToMe(long uid) {
        if (this.mGameResultView != null) {
            this.mGameResultView.othersSayHelloToMe(uid);
        }
    }

    public boolean interceptBackClick() {
        if (this.mGameResultView != null) {
            return this.mGameResultView.interceptBackClick();
        }
        return false;
    }

    public boolean interceptMicClick() {
        if (this.mGameResultView != null) {
            return this.mGameResultView.interceptMicClick();
        }
        return false;
    }

    public void updateOthersAlbum(UserInfoBean otherInfo) {
        if (this.mGameResultView != null) {
            this.mGameResultView.updateOthersAlbum(otherInfo);
        }
    }

    public void onPkInviteOverTime() {
        if (this.mGameResultView != null) {
            this.mGameResultView.onPkInviteOverTime();
        }
    }

    public void onPkCanceled() {
        if (this.mGameResultView != null) {
            this.mGameResultView.onPkCanceled();
        }
    }
}

