/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.gameresult.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Html;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.bubble.BubbleLinearLayout;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.RelativePos;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.GameCooperationRank;
import com.yy.game.bean.GameResultMsgBean;
import com.yy.game.gamemodule.pkgame.gameresult.CoinGameResultHelper;
import com.yy.game.gamemodule.pkgame.gameresult.GameResultTipsManager;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultUICallbacks;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultView;
import com.yy.game.gamemodule.pkgame.gameresult.ui.BaseResultPager;
import com.yy.game.wight.GameEmotionAnimView;
import com.yy.hiyo.coins.base.ICoinsService;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.api.IDRCallback;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.game.GameBaseMsgDef;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.coins.GameCoinResult;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.LinkedList;
import java.util.Random;
import net.ihago.act.api.goldcoingame.UserResultInfo;
import org.jetbrains.annotations.NotNull;

public class GameResultLandPager
extends BaseResultPager
implements IGameResultView {
    private static final String TAG = "GameResultLandPager";
    private static final String KEY_SHOW_COINS_GUIDE = "key_show_coins_guide";
    private boolean isGlodGame = false;
    private View mContent;
    private IGameResultUICallbacks mGameResultUICallBacks;
    private TextView mTvScore;
    private TextView mTvMyName;
    private TextView mTvOtherName;
    private ViewGroup mLayoutMine;
    private ViewGroup mLayoutOther;
    private HeadFrameImageView mImMyHead;
    private HeadFrameImageView mImOtherHead;
    private View mExpressView;
    private View mTopView;
    private TextView mTvImFirst;
    private TextView mTvImSecond;
    private RecycleImageView mIvImFirst;
    private RecycleImageView mIvImSecond;
    private LinearLayout mLlImFirst;
    private LinearLayout mLlImSecond;
    private FrameLayout mFlImContainer;
    private TextView mTvImFirstMine;
    private TextView mTvImSecondMine;
    private LinearLayout mLlImFirstMine;
    private LinearLayout mLlImSecondMine;
    private GameEmotionAnimView mLeftGameEmotionAnimView;
    private GameEmotionAnimView mRightGameEmotionAnimView;
    private TextView mBtnJoin;
    private TextView mBtnJoinTmp;
    private TextView mBtnChangeOp;
    private RecycleImageView mBackImageView;
    private View mStreakWinArea;
    private TextView mStreakWinCount;
    private TextView mStreakWinText;
    private YYRelativeLayout mFlUserContent;
    private RecycleImageView mImgGameLikeOther;
    private SVGAImageView mLikeSVGAImageView;
    private SVGAImageView mLikeSuccessSVGAImageView;
    private SVGAImageView mBackSVGAImageView;
    private SVGAImageView mNewGameResultView;
    private BubblePopupWindow mUserLeaveTipPopupWindow;
    private BubbleLinearLayout mUserLeaveBubbleLayout;
    private YYTextView mUserLeaveTipText;
    private Random mRandom;
    private ImageView mIvLightView;
    private YYTextView tvCoinTips;
    private SVGAImageView svgaCoinSuccess;
    private CoinGameResultHelper coinGameResultHelper = new CoinGameResultHelper();
    private boolean mIsPlayAgainChanged = false;
    private static final String FORCE_EXIT = "force_exit";
    private static final String ESCAPE = "escape";
    private SVGAImageView svgaGameCoins;
    private int instance;
    private YYTextView otherCoinnum;
    private YYTextView mCoinschange;
    private YYTextView mCoinnum;
    private View otherLlCoinsNum;
    private View mLlCoinsNum;
    private boolean openAnim;
    private GameInfo gameInfo;
    private RecycleImageView bgResulitAvatar;
    private RecycleImageView pkImg;
    private long mTargetUid;
    private RecycleImageView otherHeadCrown;
    private RecycleImageView myHeadCrown;
    private YYImageView myHeadBg;
    private YYImageView otherHeadBg;
    private View limit;
    private YYTextView mLimitContent;
    private YYTextView mTvLeft;

    public GameResultLandPager(Context context, IGameResultUICallbacks mGameUICallbacks) {
        super(context);
        this.mGameResultUICallBacks = mGameUICallbacks;
        this.createView(context);
    }

    public GameResultLandPager(Context context) {
        super(context);
        this.createView(context);
    }

    public GameResultLandPager(Context context, IGameResultUICallbacks uiCallbacks, GameInfo gameInfo) {
        super(context);
        this.mGameResultUICallBacks = uiCallbacks;
        this.gameInfo = gameInfo;
        if (gameInfo != null) {
            this.isGlodGame = gameInfo.isGoldGame();
        }
        this.createView(context);
    }

    private void createView(Context context) {
        this.mContent = GameResultLandPager.inflate((Context)context, (int)R.layout.game_result_layout_land, null);
        this.addView(this.mContent, new ViewGroup.LayoutParams(-1, -1));
        this.svgaCoinSuccess = (SVGAImageView)this.mContent.findViewById(R.id.svg_coin_success);
        this.svgaCoinSuccess.setFillMode(SVGAImageView.FillMode.Forward);
        this.svgaCoinSuccess.setClearsAfterStop(false);
        this.mFlUserContent = (YYRelativeLayout)this.mContent.findViewById(R.id.layout_user);
        this.mLlImFirst = (LinearLayout)this.mContent.findViewById(R.id.game_result_im1_ll);
        this.mIvImFirst = (RecycleImageView)this.mContent.findViewById(R.id.game_result_im1_iv);
        this.mLlImSecond = (LinearLayout)this.mContent.findViewById(R.id.game_result_im2_ll);
        this.mIvImSecond = (RecycleImageView)this.mContent.findViewById(R.id.game_result_im2_iv);
        if (this.mExpressView == null) {
            this.mExpressView = this.mGameResultUICallBacks.getHorExpressBarView();
        }
        this.instance = ResolutionUtils.dip2Px((float)35.0f);
        if (this.mExpressView != null && this.mExpressView.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.mExpressView.getParent()).removeView(this.mExpressView);
        }
        this.mExpressView = this.mGameResultUICallBacks.getHorExpressBarView();
        this.mBtnJoin = (TextView)this.mContent.findViewById(R.id.btn_join);
        this.mBtnJoinTmp = (TextView)this.mContent.findViewById(R.id.btn_join_tmp);
        this.mBtnJoin.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBtnJoin.setStateListAnimator(ResourceUtils.getStateListAnimator((int)R.animator.result_btn_selector));
        }
        this.mBtnJoin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GameResultLandPager.this.mIsPlayAgainChanged) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023779").put("function_id", "play_again_pop_click"));
                }
                GameResultLandPager.this.mGameResultUICallBacks.onPlayGameClicked();
            }
        });
        this.mTvScore = (TextView)this.mContent.findViewById(R.id.tv_score);
        this.mTvScore.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mBtnChangeOp = (TextView)this.mContent.findViewById(R.id.btn_change_op);
        this.mBackSVGAImageView = (SVGAImageView)this.mContent.findViewById(R.id.svg_back);
        this.mBackSVGAImageView.setFillMode(SVGAImageView.FillMode.Forward);
        this.mBackSVGAImageView.setClearsAfterStop(false);
        this.mNewGameResultView = (SVGAImageView)this.mContent.findViewById(R.id.svga_new_result);
        this.mNewGameResultView.setClearsAfterStop(false);
        this.mBackImageView = (RecycleImageView)this.mContent.findViewById(R.id.img_back);
        this.mLikeSVGAImageView = (SVGAImageView)this.mContent.findViewById(R.id.svg_like);
        this.mLikeSuccessSVGAImageView = (SVGAImageView)this.mContent.findViewById(R.id.svg_like_success);
        this.mTvImFirstMine = (TextView)this.mContent.findViewById(R.id.game_result_mine_im1_tv);
        this.mTvImSecondMine = (TextView)this.mContent.findViewById(R.id.game_result_mine_im2_tv);
        this.mLlImFirstMine = (LinearLayout)this.mContent.findViewById(R.id.game_result_mine_im1_ll);
        this.mLlImSecondMine = (LinearLayout)this.mContent.findViewById(R.id.game_result_mine_im2_ll);
        this.mTvImFirst = (TextView)this.findViewById(R.id.game_result_im1_tv);
        this.mTvImSecond = (TextView)this.findViewById(R.id.game_result_im2_tv);
        this.mFlImContainer = (FrameLayout)this.findViewById(R.id.fl_mine_im_container);
        this.mIvLightView = (ImageView)this.findViewById(R.id.iv_game_result_light);
        this.mBtnChangeOp.setText((CharSequence)ResourceUtils.getString((int)R.string.more_game));
        this.svgaGameCoins = (SVGAImageView)this.mContent.findViewById(R.id.game_coins_svga);
        this.bgResulitAvatar = (RecycleImageView)this.mContent.findViewById(R.id.bg_game_result_avatar);
        this.pkImg = (RecycleImageView)this.mContent.findViewById(R.id.icon_pk);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBtnChangeOp.setStateListAnimator(ResourceUtils.getStateListAnimator((int)R.animator.result_btn_selector));
        }
        this.mBtnChangeOp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GameResultLandPager.this.isGlodGame) {
                    GameResultLandPager.this.mGameResultUICallBacks.clickChangeOpponent();
                } else {
                    if (GameResultLandPager.this.mGameResultUICallBacks.getIsGuideAi()) {
                        GameResultLandPager.this.mGameResultUICallBacks.onPracticeAgain();
                        return;
                    }
                    GameResultLandPager.this.mGameResultUICallBacks.continueClick();
                    GameResultLandPager.this.mGameResultUICallBacks.reportGameResult("more_game");
                }
            }
        });
        this.mBtnChangeOp.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mTopView = this.mGameResultUICallBacks.getTopBarView();
        RelativeLayout.LayoutParams topLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        topLayoutParams.addRule(10);
        topLayoutParams.setMargins(0, ResourceUtils.getDimen((int)R.dimen.ver_game_result_top_padding), 0, 0);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(11);
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mTopView.measure(w, h);
        int height = this.mTopView.getMeasuredHeight();
        layoutParams.setMargins(0, height + ResolutionUtils.dip2Px((float)30.0f), ResolutionUtils.dip2Px((float)15.0f), 0);
        this.addView(this.mTopView, (ViewGroup.LayoutParams)topLayoutParams);
        this.addView(this.mExpressView, (ViewGroup.LayoutParams)layoutParams);
        this.initMineLayout();
        this.initOtherLayout();
        int userContentTopMargin = 0;
        ConstraintLayout.LayoutParams otherheadParams = (ConstraintLayout.LayoutParams)this.mImOtherHead.getLayoutParams();
        ConstraintLayout.LayoutParams myHeadParams = (ConstraintLayout.LayoutParams)this.mImMyHead.getLayoutParams();
        if (this.isGlodGame) {
            int leftMargin;
            DyResLoader.INSTANCE.getResFilePath(DR.game_result_avatar, new IDRCallback(){

                public void onFailed(@NotNull String msg) {
                    MLog.error((Object)GameResultLandPager.TAG, (String)msg, (Object[])new Object[0]);
                }

                public void onSucceed(@NotNull String data) {
                    if (!FP.empty((CharSequence)data)) {
                        Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)data, (ImageConfig)ImageConfig.fullImageConfig(), (boolean)false);
                        if (bitmap == null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)GameResultLandPager.TAG, (String)"DyResLoader.game_result_avatar bitmap is null", (Object[])new Object[0]);
                            }
                            return;
                        }
                        GameResultLandPager.this.bgResulitAvatar.setImageBitmap(bitmap);
                        GameResultLandPager.this.bgResulitAvatar.setVisibility(0);
                    }
                }
            });
            this.mContent.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_coins_game_bg));
            DyResLoader.INSTANCE.getResFilePath(com.yy.hiyo.game.base.DR.bg_game_coins_result_land, new IDRCallback(){

                public void onFailed(@NotNull String msg) {
                    MLog.error((Object)GameResultLandPager.TAG, (String)msg, (Object[])new Object[0]);
                }

                public void onSucceed(@NotNull String data) {
                    if (!FP.empty((CharSequence)data)) {
                        Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)data, (ImageConfig)ImageConfig.fullImageConfig(), (boolean)false);
                        if (bitmap == null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)GameResultLandPager.TAG, (String)"DyResLoader.bg_game_coins_result_land bitmap is null", (Object[])new Object[0]);
                            }
                            return;
                        }
                        BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                        GameResultLandPager.this.mContent.setBackgroundDrawable((Drawable)drawable2);
                    }
                }
            });
            this.pkImg.setVisibility(0);
            this.mTvScore.setVisibility(8);
            this.mBtnChangeOp.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_game_result_match_other));
            float topMargin = ResolutionUtils.dip2Px((float)128.0f);
            int avatarWidth = ResolutionUtils.dip2Px((float)66.0f);
            float screenHeight = ResolutionUtils.getScreenHeight((Context)context);
            float screenWidth = ResolutionUtils.getScreenWidth((Context)context);
            float top = 0.0f;
            top = screenHeight > screenWidth ? topMargin / screenWidth : topMargin / screenHeight;
            myHeadParams.verticalBias = top;
            otherheadParams.verticalBias = top;
            myHeadParams.rightMargin = leftMargin = ResolutionUtils.dip2Px((float)50.0f);
            otherheadParams.leftMargin = leftMargin;
            this.mImMyHead.setLayoutParams((ViewGroup.LayoutParams)myHeadParams);
            this.mImOtherHead.setLayoutParams((ViewGroup.LayoutParams)otherheadParams);
            this.mImOtherHead.setFrameWidthAndHeight(avatarWidth, 0);
            this.mImMyHead.setFrameWidthAndHeight(avatarWidth, 0);
            ViewStub streak = (ViewStub)this.findViewById(R.id.viewstub_streak_win_area);
            FrameLayout.LayoutParams stubparams = (FrameLayout.LayoutParams)streak.getLayoutParams();
            stubparams.topMargin = ResolutionUtils.dip2Px((float)30.0f);
            streak.setLayoutParams((ViewGroup.LayoutParams)stubparams);
            this.mGameResultUICallBacks.reportGameResult("change_match_but_show");
        } else {
            float divide = this.mContent.findViewById(R.id.ll_operation_bottom).getY() - (float)ResolutionUtils.dip2Px((float)80.0f);
            userContentTopMargin = (int)((float)ResolutionUtils.dip2Px((float)80.0f) + divide / 2.0f);
            FrameLayout.LayoutParams userContentLayoutParams = (FrameLayout.LayoutParams)this.mFlUserContent.getLayoutParams();
            userContentLayoutParams.topMargin = userContentTopMargin;
            this.mFlUserContent.setLayoutParams((ViewGroup.LayoutParams)userContentLayoutParams);
        }
        View userLeaveView = LayoutInflater.from((Context)context).inflate(R.layout.game_result_user_leave_tip_land_layout, null);
        this.mUserLeaveBubbleLayout = (BubbleLinearLayout)userLeaveView.findViewById(R.id.user_leave_tip_layout);
        this.mUserLeaveTipText = (YYTextView)userLeaveView.findViewById(R.id.user_leave_tip_text);
        this.mUserLeaveTipPopupWindow = new BubblePopupWindow(userLeaveView, (BubbleStyle)this.mUserLeaveBubbleLayout);
        this.mUserLeaveTipPopupWindow.setCancelOnTouch(false);
        this.mUserLeaveTipPopupWindow.setCancelOnTouchOutside(false);
        this.mUserLeaveTipPopupWindow.setClippingEnabled(false);
        HeadFrameType headFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
        Kvo.addKvoBinding((KvoSource)headFrameType, (Object)this, (String)"onMyHeadFrameTypeUpdate");
        DyResLoader.INSTANCE.loadSvga(this.mLikeSuccessSVGAImageView, DR.game_like_success, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
            }

            public void onFailed(Exception e) {
            }
        });
    }

    private void goCoinsShop() {
        MsgDispatcher.getInstance().sendMessage(GameBaseMsgDef.CallOutSide.MSG_GOTO_COINS_MALL);
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onMyHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.mImMyHead != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.mImMyHead.setHeadFrame(this.mGameResultUICallBacks.getHeadFrameUrl(frame));
        }
    }

    private void initOtherLayout() {
        if (this.mContent != null) {
            this.mLayoutOther = (ViewGroup)this.mContent.findViewById(R.id.layout_other);
            this.mTvOtherName = (TextView)this.mLayoutOther.findViewById(R.id.tv_user_name);
            this.mImOtherHead = (HeadFrameImageView)this.mLayoutOther.findViewById(R.id.img_avtor);
            this.mImgGameLikeOther = (RecycleImageView)this.mLayoutOther.findViewById(R.id.iv_btn_like);
            this.mImgGameLikeOther.setVisibility(0);
            this.otherCoinnum = (YYTextView)this.mLayoutOther.findViewById(R.id.tv_coins_num);
            this.otherHeadBg = (YYImageView)this.mLayoutOther.findViewById(R.id.iv_ring);
            this.otherLlCoinsNum = this.mLayoutOther.findViewById(R.id.layout_coins);
            this.otherHeadCrown = (RecycleImageView)this.mLayoutOther.findViewById(R.id.iv_crown);
            this.mTvLeft = (YYTextView)this.mContent.findViewById(R.id.tv_left);
            this.otherCoinnum.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
            this.mRightGameEmotionAnimView = (GameEmotionAnimView)this.mLayoutOther.findViewById(R.id.right_emotion);
            this.mImgGameLikeOther.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GameResultLandPager.this.mGameResultUICallBacks.likeResult();
                }
            });
            this.mImOtherHead.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Object info;
                    if (GameResultLandPager.this.mGameResultUICallBacks != null && (info = GameResultLandPager.this.mImOtherHead.getTag()) instanceof UserInfoBean) {
                        GameResultLandPager.this.mGameResultUICallBacks.showUserProfileCard(((UserInfoBean)info).getUid());
                    }
                }
            });
            this.expandViewTouchDelegate((View)this.mImgGameLikeOther);
        }
    }

    private void initMineLayout() {
        if (this.mContent != null) {
            this.mLayoutMine = (ViewGroup)this.mContent.findViewById(R.id.layout_mine);
            this.mTvMyName = (TextView)this.mLayoutMine.findViewById(R.id.tv_user_name);
            this.mImMyHead = (HeadFrameImageView)this.mLayoutMine.findViewById(R.id.img_avtor);
            this.mLeftGameEmotionAnimView = (GameEmotionAnimView)this.mLayoutMine.findViewById(R.id.left_emotion);
            this.mCoinschange = (YYTextView)this.mLayoutMine.findViewById(R.id.tv_coins_change_num);
            this.mCoinnum = (YYTextView)this.mLayoutMine.findViewById(R.id.tv_coins_num);
            this.myHeadCrown = (RecycleImageView)this.mLayoutMine.findViewById(R.id.iv_crown);
            this.myHeadBg = (YYImageView)this.mLayoutMine.findViewById(R.id.iv_ring);
            this.limit = this.mLayoutMine.findViewById(R.id.layout_coin_limit);
            this.mLimitContent = (YYTextView)this.mLayoutMine.findViewById(R.id.tv_limit);
            this.mLlCoinsNum = this.mLayoutMine.findViewById(R.id.layout_coins);
            this.mCoinschange.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
            this.mCoinnum.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
            this.mLlCoinsNum.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GameResultLandPager.this.goCoinsShop();
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023779").put("function_id", "my_cions_click"));
                }
            });
        }
    }

    private void updateRightBubbleMaxWidth(final TextView textView, final boolean hasLeftIcon, long delay) {
        if (this.mImOtherHead == null || textView == null) {
            return;
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                ViewGroup parent = (ViewGroup)GameResultLandPager.this.mImOtherHead.getParent();
                int emojiBarWidth = ResolutionUtils.dip2Px((float)50.0f);
                int maxWidth = parent.getWidth() - GameResultLandPager.this.mImOtherHead.getRight() - emojiBarWidth - (hasLeftIcon ? ResolutionUtils.dip2Px((float)64.0f) : 10);
                textView.setMaxWidth(maxWidth);
            }
        }, delay);
    }

    @Override
    public void showView(ViewGroup parentView) {
        parentView.addView((View)this);
    }

    @Override
    public void updateScore(int myScore, int otherScore) {
        this.mTvScore.setText((CharSequence)(String.valueOf(myScore) + " : " + String.valueOf(otherScore)));
    }

    @Override
    public void updateSceneView(int gameScene) {
        if (this.mGameResultUICallBacks.getIsGuideAi()) {
            this.mBtnChangeOp.setVisibility(0);
            return;
        }
        if (gameScene == IGameService.GAME_FROM.FROM_MATCH.value()) {
            this.mBtnChangeOp.setVisibility(0);
        }
    }

    @Override
    public void setPlayAgainEnable(boolean isEnable) {
        this.mBtnJoin.setEnabled(isEnable);
        this.mBtnJoinTmp.setEnabled(isEnable);
        if (!isEnable) {
            this.mBtnJoin.setBackgroundResource(R.drawable.shape_bg_btn_play_again_disable);
            this.mBtnJoinTmp.setBackgroundResource(R.drawable.shape_bg_btn_play_again_disable);
        }
    }

    @Override
    public void showLikeGuide() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameResultLandPager.this.playBtnLikeSvga(DR.game_result_like_guide, true);
            }
        }, (long)300L);
    }

    @Override
    public View getOtherBtnLikeView() {
        return this.mImgGameLikeOther;
    }

    @Override
    public void updateChangeOption(boolean isHide) {
        this.mBtnChangeOp.setVisibility(isHide ? 8 : 0);
    }

    @Override
    public void updateOtherStatus(boolean isLeft) {
        this.mTvLeft.setVisibility(isLeft ? 0 : 8);
    }

    @Override
    public void updateUserInfo(UserInfoBean myinfo, UserInfoBean otherinfo) {
        if (myinfo != null) {
            this.mTvMyName.setText((CharSequence)myinfo.getNick());
            ImageLoader.loadImage((RecycleImageView)this.mImMyHead.getCircleImageView(), (String)(myinfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)ResolutionUtils.dip2Px((float)66.0f))), (int)AvatarUtils.getDefaultAvatar((int)myinfo.getSex()));
            this.mImMyHead.setTag((Object)myinfo);
        }
        if (otherinfo != null) {
            this.mTargetUid = otherinfo.getUid();
            this.mTvOtherName.setText((CharSequence)otherinfo.getNick());
            ImageLoader.loadImage((RecycleImageView)this.mImOtherHead.getCircleImageView(), (String)(otherinfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)otherinfo.getSex()));
            this.mImOtherHead.setTag((Object)otherinfo);
        }
    }

    @Override
    public void update2v2UserInfos(UserInfoKS me, UserInfoKS friends, UserInfoKS other0, UserInfoKS other1) {
    }

    @Override
    public void setBtnDisable() {
        if (this.mBtnJoin != null) {
            this.mBtnJoin.setEnabled(false);
        }
    }

    @Override
    public void updateResultBG(GameDef.GameResult result, final boolean showNewResult, final int lastWinCount) {
        int lastStreakWin = this.mGameResultUICallBacks.getLastStreakWincount();
        this.mBackSVGAImageView.setVisibility(8);
        this.mBackImageView.setVisibility(8);
        if (result == GameDef.GameResult.GAME_WIN) {
            if (this.isGlodGame) {
                this.mBackImageView.setVisibility(0);
                this.myHeadCrown.setVisibility(0);
                this.myHeadBg.setVisibility(0);
                this.myHeadBg.setBackgroundResource(R.drawable.game_result_win);
                this.otherHeadBg.setBackgroundResource(R.drawable.game_result_lose);
                this.otherHeadBg.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mBackImageView, (int)R.drawable.game_result_record_banner_win);
            } else if (SettingFlagBaseKeys.enableSvg()) {
                this.mBackSVGAImageView.setVisibility(0);
                DyResLoader.INSTANCE.loadSvga(this.mBackSVGAImageView, DR.game_success_land, new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameResultLandPager.TAG, (String)"updateResultBG onFinished", (Object[])new Object[0]);
                        }
                        GameResultLandPager.this.mBackSVGAImageView.startAnimation();
                    }

                    public void onFailed(final Exception e) {
                        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                            public void run() {
                                if (GameResultLandPager.this.mBackImageView == null) {
                                    return;
                                }
                                GameResultLandPager.this.mBackImageView.setVisibility(0);
                                ImageLoader.loadImage((RecycleImageView)GameResultLandPager.this.mBackImageView, (int)R.drawable.game_win);
                                MLog.error((Object)GameResultLandPager.TAG, (Throwable)e);
                            }
                        });
                    }
                });
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (showNewResult && GameResultLandPager.this.mNewGameResultView != null) {
                            DResource gameSvga = lastWinCount == 0 ? DR.game_first_win : (lastWinCount == 1 ? DR.game_second_win : DR.game_third_win);
                            DyResLoader.INSTANCE.loadSvga(GameResultLandPager.this.mNewGameResultView, gameSvga, new ISvgaLoadCallback(){

                                public void onFinished(SVGAVideoEntity entity) {
                                    if (MLog.isLogLevelBlowInfo()) {
                                        MLog.info((Object)GameResultLandPager.TAG, (String)"updateResultBG new register onFinished", (Object[])new Object[0]);
                                    }
                                    if (GameResultLandPager.this.mNewGameResultView != null && entity != null) {
                                        if (lastWinCount == 0) {
                                            SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
                                            TextPaint textPaint = new TextPaint();
                                            textPaint.setColor(-1);
                                            textPaint.setTextSize((float)ResolutionUtils.spToPx((float)12.0f));
                                            textPaint.setTypeface(Typeface.create((Typeface)Typeface.SANS_SERIF, (int)1));
                                            dynamicEntity.setDynamicText(ResourceUtils.getString((int)R.string.short_tips_first_win), textPaint, "hint");
                                            SVGADrawable drawable2 = new SVGADrawable(entity, dynamicEntity);
                                            GameResultLandPager.this.mNewGameResultView.setImageDrawable((Drawable)drawable2);
                                        }
                                        GameResultLandPager.this.mNewGameResultView.startAnimation();
                                    }
                                }

                                public void onFailed(Exception e) {
                                    MLog.error((Object)GameResultLandPager.TAG, (Throwable)e);
                                }
                            });
                        }
                    }
                }, (long)1000L);
            } else {
                this.mBackImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mBackImageView, (int)R.drawable.game_win);
            }
            if (lastStreakWin >= 1 && !showNewResult) {
                this.ensureStreakwinUi();
                this.coinGameResultHelper.updateWinOrLostTs();
                this.mStreakWinArea.setBackgroundResource(R.drawable.streak_win_bk);
                this.mStreakWinCount.setVisibility(0);
                this.mStreakWinCount.setText((CharSequence)String.valueOf(lastStreakWin + 1));
                this.mStreakWinText.setText(R.string.winning_streak);
            }
        } else if (result == GameDef.GameResult.GAME_LOSE) {
            if (this.isGlodGame) {
                this.mBackImageView.setVisibility(0);
                this.otherHeadCrown.setVisibility(0);
                this.otherHeadBg.setVisibility(0);
                this.otherHeadBg.setBackgroundResource(R.drawable.game_result_win);
                this.myHeadBg.setBackgroundResource(R.drawable.game_result_lose);
                this.myHeadBg.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mBackImageView, (int)R.drawable.game_result_record_banner_lose);
            } else if (SettingFlagBaseKeys.enableSvg()) {
                this.mBackSVGAImageView.setVisibility(0);
                DyResLoader.INSTANCE.loadSvga(this.mBackSVGAImageView, DR.game_fail_land, new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameResultLandPager.TAG, (String)"updateResultBG onFinished", (Object[])new Object[0]);
                        }
                        GameResultLandPager.this.mBackSVGAImageView.startAnimation();
                    }

                    public void onFailed(final Exception e) {
                        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                            public void run() {
                                if (GameResultLandPager.this.mBackImageView == null) {
                                    return;
                                }
                                GameResultLandPager.this.mBackImageView.setVisibility(0);
                                ImageLoader.loadImage((RecycleImageView)GameResultLandPager.this.mBackImageView, (int)R.drawable.game_lose);
                                MLog.error((Object)GameResultLandPager.TAG, (Throwable)e);
                            }
                        });
                    }
                });
                this.newRegisterGameNotWin(showNewResult, lastWinCount);
            } else {
                this.mBackImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mBackImageView, (int)R.drawable.game_lose);
            }
            if (lastStreakWin > 1 && !showNewResult) {
                this.ensureStreakwinUi();
                this.coinGameResultHelper.updateWinOrLostTs();
                this.mStreakWinArea.setBackgroundResource(R.drawable.streak_lose_bk);
                this.mStreakWinCount.setVisibility(8);
                this.mStreakWinText.setText(R.string.losing_streak);
            }
        } else if (result == GameDef.GameResult.GAME_DRAW) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("GAME_DRAW" + String.valueOf(AccountUtil.getUid())), (Object[])new Object[0]);
            }
            if (this.isGlodGame) {
                this.mBackImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mBackImageView, (int)R.drawable.game_result_record_banner_tie);
            } else if (SettingFlagBaseKeys.enableSvg()) {
                this.mBackSVGAImageView.setVisibility(0);
                DyResLoader.INSTANCE.loadSvga(this.mBackSVGAImageView, DR.game_draw_land, new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (GameResultLandPager.this.mBackSVGAImageView != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)GameResultLandPager.TAG, (String)"updateResultBG onFinished", (Object[])new Object[0]);
                            }
                            GameResultLandPager.this.mBackSVGAImageView.startAnimation();
                        }
                    }

                    public void onFailed(final Exception e) {
                        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                            public void run() {
                                if (GameResultLandPager.this.mBackImageView == null) {
                                    return;
                                }
                                GameResultLandPager.this.mBackImageView.setVisibility(0);
                                ImageLoader.loadImage((RecycleImageView)GameResultLandPager.this.mBackImageView, (int)R.drawable.game_tie);
                                MLog.error((Object)GameResultLandPager.TAG, (Throwable)e);
                            }
                        });
                    }
                });
                this.newRegisterGameNotWin(showNewResult, lastWinCount);
            } else {
                this.mBackImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mBackImageView, (int)R.drawable.game_tie);
            }
            if (!showNewResult && lastStreakWin > 1) {
                this.ensureStreakwinUi();
                this.coinGameResultHelper.updateWinOrLostTs();
                this.mStreakWinArea.setBackgroundResource(R.drawable.streak_lose_bk);
                this.mStreakWinCount.setVisibility(8);
                this.mStreakWinText.setText(R.string.losing_streak);
            }
        }
    }

    private void newRegisterGameNotWin(final boolean showNewResult, final int lastWinCount) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (showNewResult && GameResultLandPager.this.mNewGameResultView != null) {
                    DResource gameSvga = lastWinCount == 0 ? DR.game_first_lose : (lastWinCount == 1 ? DR.game_second_lose : DR.game_third_lose);
                    DyResLoader.INSTANCE.loadSvga(GameResultLandPager.this.mNewGameResultView, gameSvga, new ISvgaLoadCallback(){

                        public void onFinished(SVGAVideoEntity entity) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)GameResultLandPager.TAG, (String)"updateResultBG new register onFinished", (Object[])new Object[0]);
                            }
                            if (GameResultLandPager.this.mNewGameResultView != null && entity != null) {
                                if (lastWinCount == 0) {
                                    SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
                                    TextPaint textPaint = new TextPaint();
                                    textPaint.setColor(-1);
                                    textPaint.setTextSize((float)ResolutionUtils.spToPx((float)12.0f));
                                    textPaint.setTypeface(Typeface.create((Typeface)Typeface.SANS_SERIF, (int)1));
                                    dynamicEntity.setDynamicText(ResourceUtils.getString((int)R.string.short_tips_first_lost), textPaint, "hint");
                                    SVGADrawable drawable2 = new SVGADrawable(entity, dynamicEntity);
                                    GameResultLandPager.this.mNewGameResultView.setImageDrawable((Drawable)drawable2);
                                }
                                GameResultLandPager.this.mNewGameResultView.startAnimation();
                            }
                        }

                        public void onFailed(Exception e) {
                            MLog.error((Object)GameResultLandPager.TAG, (Throwable)e);
                        }
                    });
                }
            }
        }, (long)1000L);
    }

    private void ensureStreakwinUi() {
        ViewStub s;
        if (this.mStreakWinArea == null && (s = (ViewStub)this.findViewById(R.id.viewstub_streak_win_area)) != null) {
            this.mStreakWinArea = s.inflate().findViewById(R.id.streak_win_area);
            this.tvCoinTips = (YYTextView)this.mContent.findViewById(R.id.tv_coin_tips);
            this.mStreakWinCount = (TextView)this.mStreakWinArea.findViewById(R.id.streak_count);
            this.mStreakWinText = (TextView)this.mStreakWinArea.findViewById(R.id.streak_text);
        }
    }

    @Override
    public AnimatorSet getPushAnimator(AbstractWindow frontWindow, AbstractWindow backWindow) {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator alphaOut = ObjectAnimator.ofFloat((Object)backWindow, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator scaleYOut = ObjectAnimator.ofFloat((Object)backWindow, (String)"scaleY", (float[])new float[]{1.0f, 1.2f});
        ObjectAnimator scaleXOut = ObjectAnimator.ofFloat((Object)backWindow, (String)"scaleX", (float[])new float[]{1.0f, 1.2f});
        View join = this.mContent.findViewById(R.id.btn_join_layout);
        ObjectAnimator alphaIn = ObjectAnimator.ofFloat((Object)frontWindow, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        float move = 160.0f * this.getContext().getResources().getDisplayMetrics().density;
        ObjectAnimator svgaAlphaDown = ObjectAnimator.ofFloat((Object)this.mBackSVGAImageView, (String)"translationY", (float[])new float[]{-move, 0.0f});
        ObjectAnimator streakWinAreaAlphaDown = ObjectAnimator.ofFloat((Object)this.mStreakWinArea, (String)"translationY", (float[])new float[]{-move, 0.0f});
        ObjectAnimator urerAlphaDown = ObjectAnimator.ofFloat((Object)this.mFlUserContent, (String)"translationY", (float[])new float[]{-move, 0.0f});
        ObjectAnimator btnJoinAlphaUp = ObjectAnimator.ofFloat((Object)join, (String)"translationY", (float[])new float[]{move, 0.0f});
        ObjectAnimator mBtnChangeOpAlphaUp = ObjectAnimator.ofFloat((Object)this.mBtnChangeOp, (String)"translationY", (float[])new float[]{move, 0.0f});
        ObjectAnimator expressAlphaUp = ObjectAnimator.ofFloat((Object)this.mExpressView, (String)"translationY", (float[])new float[]{move, 0.0f});
        int duration = 240;
        int startDelay = 60;
        alphaOut.setDuration((long)duration);
        scaleYOut.setDuration((long)duration);
        scaleXOut.setDuration((long)duration);
        alphaIn.setDuration((long)duration);
        svgaAlphaDown.setDuration((long)duration).setStartDelay((long)(startDelay * 2));
        streakWinAreaAlphaDown.setDuration((long)duration).setStartDelay((long)startDelay);
        urerAlphaDown.setDuration((long)duration);
        btnJoinAlphaUp.setDuration((long)duration);
        mBtnChangeOpAlphaUp.setDuration((long)duration).setStartDelay((long)startDelay);
        expressAlphaUp.setDuration((long)duration).setStartDelay((long)(startDelay * 2));
        if (this.mBackSVGAImageView != null) {
            this.mBackSVGAImageView.setTranslationY(-move);
        }
        if (this.mStreakWinArea != null) {
            this.mStreakWinArea.setTranslationY(-move);
        }
        if (this.mBtnChangeOp != null) {
            this.mBtnChangeOp.setTranslationY(move);
        }
        if (this.mExpressView != null) {
            this.mExpressView.setTranslationY(move);
        }
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.play((Animator)alphaOut).with((Animator)scaleYOut).with((Animator)scaleXOut).with((Animator)alphaIn).with((Animator)urerAlphaDown).with((Animator)btnJoinAlphaUp).with((Animator)streakWinAreaAlphaDown).with((Animator)mBtnChangeOpAlphaUp).with((Animator)svgaAlphaDown).with((Animator)expressAlphaUp);
        return animatorSet;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    @Override
    public void updateBtnTextFromPlayWithAI() {
        this.mBtnJoin.setTextSize(2, 18.0f);
        this.mBtnChangeOp.setTextSize(2, 18.0f);
        this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.game_result_play_with_real_people));
        this.mBtnJoin.setBackgroundResource(R.drawable.red_round_3_selector);
        this.mBtnChangeOp.setText((CharSequence)ResourceUtils.getString((int)R.string.game_result_practice_again));
    }

    @Override
    public void onMessageArrived(LinkedList<GameResultMsgBean> imMessageQueue) {
        if (imMessageQueue == null || imMessageQueue.size() <= 0) {
            return;
        }
        this.hideLikeTipWindow();
        this.hideUserLeaveTip();
        if (imMessageQueue.size() == 1) {
            GameResultMsgBean bean = imMessageQueue.get(0);
            if (bean != null) {
                this.updateRightBubbleMaxWidth(this.mTvImFirst, !TextUtils.isEmpty((CharSequence)bean.getGameIcon()), 0L);
                if (TextUtils.isEmpty((CharSequence)bean.getGameIcon())) {
                    this.mTvImFirst.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(bean.getContent().toString()));
                } else {
                    this.mTvImFirst.setText(bean.getContent());
                }
                this.startIM1Animator();
                this.mLlImFirst.setVisibility(0);
                this.mLlImSecond.setVisibility(8);
                if (!TextUtils.isEmpty((CharSequence)bean.getGameIcon())) {
                    this.mIvImFirst.setVisibility(0);
                    ImageLoader.loadImage((RecycleImageView)this.mIvImFirst, (String)bean.getGameIcon());
                } else {
                    this.mIvImFirst.setVisibility(8);
                }
            }
        } else if (imMessageQueue.size() == 2) {
            GameResultMsgBean firstBean;
            GameResultMsgBean bean = imMessageQueue.get(0);
            if (bean != null) {
                this.updateRightBubbleMaxWidth(this.mTvImSecond, !TextUtils.isEmpty((CharSequence)bean.getGameIcon()), 0L);
                if (TextUtils.isEmpty((CharSequence)bean.getGameIcon())) {
                    this.mTvImSecond.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(bean.getContent().toString()));
                } else {
                    this.mTvImSecond.setText(bean.getContent());
                }
                if (!TextUtils.isEmpty((CharSequence)bean.getGameIcon())) {
                    this.mIvImSecond.setVisibility(0);
                    ImageLoader.loadImage((RecycleImageView)this.mIvImSecond, (String)bean.getGameIcon());
                } else {
                    this.mIvImSecond.setVisibility(8);
                }
            }
            if ((firstBean = imMessageQueue.get(1)) != null) {
                this.updateRightBubbleMaxWidth(this.mTvImFirst, !TextUtils.isEmpty((CharSequence)firstBean.getGameIcon()), 0L);
                if (TextUtils.isEmpty((CharSequence)firstBean.getGameIcon())) {
                    this.mTvImFirst.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(firstBean.getContent().toString()));
                } else {
                    this.mTvImFirst.setText(firstBean.getContent());
                }
                if (!TextUtils.isEmpty((CharSequence)firstBean.getGameIcon())) {
                    this.mIvImFirst.setVisibility(0);
                    ImageLoader.loadImage((RecycleImageView)this.mIvImFirst, (String)firstBean.getGameIcon());
                } else {
                    this.mIvImFirst.setVisibility(8);
                }
            }
            this.startIM1Animator();
            this.startIM2Animator();
            this.mLlImFirst.setVisibility(0);
            this.mLlImSecond.setVisibility(0);
        }
    }

    @Override
    public void onMessageSend(LinkedList<GameResultMsgBean> imMessageQueue) {
        if (imMessageQueue == null) {
            return;
        }
        if (this.isGlodGame) {
            this.limit.setVisibility(8);
        }
        this.mFlImContainer.setVisibility(0);
        if (imMessageQueue.size() == 1) {
            this.mLlImSecondMine.setVisibility(8);
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(0);
            this.mTvImFirstMine.setText(gameResultMsgBean.getContent());
            this.startIM1Animator();
            this.mLlImFirstMine.setVisibility(0);
        } else if (imMessageQueue.size() == 2) {
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(1);
            this.mTvImFirstMine.setText(gameResultMsgBean.getContent());
            this.mTvImSecondMine.setText(imMessageQueue.get(0).getContent());
            this.mLlImFirstMine.setVisibility(0);
            this.mLlImSecondMine.setVisibility(0);
            this.startIM1Animator();
            this.startIM2Animator();
        }
    }

    @Override
    public void clearMsg(boolean isMe) {
        if (isMe) {
            this.mFlImContainer.setVisibility(8);
        } else {
            this.mLlImFirst.setVisibility(8);
            this.mLlImSecond.setVisibility(8);
        }
    }

    private void startIM2Animator() {
        this.mLlImFirst.post(new Runnable(){

            @Override
            public void run() {
                int height;
                int n = height = GameResultLandPager.this.mLlImFirst.getHeight() > 0 ? GameResultLandPager.this.mLlImFirst.getHeight() : ResolutionUtils.dip2Px((float)40.0f);
                if (GameResultLandPager.this.mIvImSecond.getVisibility() == 8) {
                    height = ResolutionUtils.dip2Px((float)40.0f);
                }
                ObjectAnimator transAnimator = ObjectAnimator.ofFloat((Object)GameResultLandPager.this.mLlImSecond, (String)"translationY", (float[])new float[]{0.0f, height});
                ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)GameResultLandPager.this.mLlImSecond, (String)"alpha", (float[])new float[]{1.0f, 0.3f});
                AnimatorSet set = new AnimatorSet();
                set.setDuration(300L);
                set.playTogether(new Animator[]{transAnimator, alphaAnimator});
                set.start();
            }
        });
    }

    private void startIM1Animator() {
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this.mLlImFirst, (String)"scaleX", (float[])new float[]{0.0f, 1.3f, 1.0f});
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this.mLlImFirst, (String)"scaleY", (float[])new float[]{0.0f, 1.3f, 1.0f});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(500L);
        set.playTogether(new Animator[]{animatorX, animatorY});
        set.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        set.start();
    }

    @Override
    public void showEmoj(EmojiBean emojiBean, int postion) {
        if (postion == 0) {
            if (this.mLeftGameEmotionAnimView != null) {
                this.mLeftGameEmotionAnimView.playEmotion(emojiBean);
            }
        } else if (this.mRightGameEmotionAnimView != null) {
            this.mRightGameEmotionAnimView.playEmotion(emojiBean);
        }
    }

    @Override
    public void showBarrageView(BarrageInfo barrageInfo) {
    }

    @Override
    public void updateJoinBtn(GameDef.PKGameInviteStatus type) {
        this.mBtnJoin.setEnabled(true);
        if (this.mGameResultUICallBacks.getIsGuideAi()) {
            this.updateBtnTextFromPlayWithAI();
            return;
        }
        this.mBtnJoin.setTextSize(2, 20.0f);
        this.mBtnChangeOp.setTextSize(2, 20.0f);
        if (type == GameDef.PKGameInviteStatus.JOIN_GAME) {
            this.mBtnJoinTmp.setText((CharSequence)ResourceUtils.getString((int)R.string.joingame));
            this.mBtnJoinTmp.setBackgroundResource(R.drawable.green_round_3);
            this.mBtnJoinTmp.setVisibility(0);
            ObjectAnimator alphaIn = ObjectAnimator.ofFloat((Object)this.mBtnJoinTmp, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator alphaOut = ObjectAnimator.ofFloat((Object)this.mBtnJoin, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            ObjectAnimator scaleYIn = ObjectAnimator.ofFloat((Object)this.mBtnJoinTmp, (String)"scaleY", (float[])new float[]{0.8f, 1.0f});
            ObjectAnimator scaleYOut = ObjectAnimator.ofFloat((Object)this.mBtnJoin, (String)"scaleY", (float[])new float[]{1.0f, 0.8f});
            ObjectAnimator scaleXIn = ObjectAnimator.ofFloat((Object)this.mBtnJoinTmp, (String)"scaleX", (float[])new float[]{0.8f, 1.0f});
            ObjectAnimator scaleXOut = ObjectAnimator.ofFloat((Object)this.mBtnJoin, (String)"scaleX", (float[])new float[]{1.0f, 0.8f});
            AnimatorSet animSet = new AnimatorSet();
            animSet.play((Animator)alphaIn).with((Animator)alphaOut).with((Animator)scaleYIn).with((Animator)scaleYOut).with((Animator)scaleXIn).with((Animator)scaleXOut);
            animSet.setDuration(150L);
            animSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    GameResultLandPager.this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.joingame));
                    GameResultLandPager.this.mBtnJoin.setBackgroundResource(R.drawable.green_round_3);
                    GameResultLandPager.this.mBtnJoin.setScaleX(1.0f);
                    GameResultLandPager.this.mBtnJoin.setScaleY(1.0f);
                    GameResultLandPager.this.mBtnJoin.setAlpha(1.0f);
                    GameResultLandPager.this.mBtnJoinTmp.setVisibility(8);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            animSet.start();
        } else if (type == GameDef.PKGameInviteStatus.JOIN_OTHER_GAME) {
            if (!(MLog.isLogLevelAboveDebug() || MLog.isLogLevelAboveDebug() || MLog.isLogLevelAboveDebug())) {
                MLog.debug((Object)TAG, (String)ResourceUtils.getString((int)R.string.join_ohter_game), (Object[])new Object[0]);
            }
            this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.joingame));
            this.mBtnJoin.setBackgroundResource(R.drawable.green_round_3);
        } else if (type == GameDef.PKGameInviteStatus.PLAY_AGAIN) {
            this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.play_again));
            this.mBtnJoin.setBackgroundResource(R.drawable.red_round_3_selector);
        } else if (type == GameDef.PKGameInviteStatus.WAIT_OPPOENT) {
            this.stopLightAnim();
            this.mBtnJoin.setEnabled(false);
            this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.wait_for_oppent));
            this.mBtnJoin.setBackgroundResource(R.drawable.gary_round_3);
        }
    }

    @Override
    public CharSequence getMsgText(GameDef.PKGameInviteStatus type, String gameName) {
        if (type == GameDef.PKGameInviteStatus.JOIN_GAME) {
            return ResourceUtils.getString((int)R.string.letplayagain);
        }
        if (type == GameDef.PKGameInviteStatus.JOIN_OTHER_GAME) {
            String textStr = "<font color=\"#ffffff\">" + ResourceUtils.getString((int)R.string.play_antnother) + "</font> <font color=\"#fff000\">" + gameName + "</font>";
            return Html.fromHtml((String)textStr);
        }
        if (type == GameDef.PKGameInviteStatus.PLAY_AGAIN) {
            return null;
        }
        if (type == GameDef.PKGameInviteStatus.WAIT_OPPOENT) {
            return ResourceUtils.getString((int)R.string.ready);
        }
        return null;
    }

    @Override
    public void updateLike(boolean isEnable) {
        this.hideUserLeaveTip();
        this.playBtnLikeSvga(DR.game_result_like_pressed, false);
    }

    @Override
    public void startLikeAnim() {
        DyResLoader.INSTANCE.loadSvga(this.mLikeSVGAImageView, DR.game_result_like_full_screen, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                GameResultLandPager.this.playLikedSvga();
            }

            public void onFailed(Exception e) {
            }
        });
    }

    private void playLikedSvga() {
        if (this.mLikeSVGAImageView != null) {
            this.mLikeSVGAImageView.startAnimation();
            this.mLikeSVGAImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GameResultLandPager.this.mLikeSVGAImageView.stopAnimation();
                    GameResultLandPager.this.mLikeSVGAImageView.setVisibility(8);
                }
            });
        }
    }

    private void expandViewTouchDelegate(final View view) {
        ((View)view.getParent()).post(new Runnable(){

            @Override
            public void run() {
                Rect bounds = new Rect();
                view.setEnabled(true);
                view.getHitRect(bounds);
                bounds.top = view.getTop() + ResolutionUtils.dip2Px((float)20.0f);
                bounds.bottom = view.getBottom() + ResolutionUtils.dip2Px((float)20.0f);
                bounds.left = view.getLeft() + ResolutionUtils.dip2Px((float)20.0f);
                bounds.right = view.getRight() + ResolutionUtils.dip2Px((float)20.0f);
                TouchDelegate touchDelegate = new TouchDelegate(bounds, view);
                if (View.class.isInstance(view.getParent())) {
                    ((View)view.getParent()).setTouchDelegate(touchDelegate);
                }
            }
        });
    }

    @Override
    public void showLikeTip() {
        if (this.isGlodGame) {
            return;
        }
        this.showLikeTipWindow((View)this.mImgGameLikeOther);
    }

    @Override
    public void showScoreError(int reason) {
    }

    @Override
    public void showUserLeaveTip(String exitReason) {
        if (StringUtils.isEmpty((String)exitReason)) {
            return;
        }
        if (this.mUserLeaveTipPopupWindow != null && this.mUserLeaveTipText != null && !this.checkOtherBubbleShowing()) {
            int exitType;
            String userLeaveTipText;
            if (this.mRandom == null) {
                this.mRandom = new Random();
            }
            if (StringUtils.isEmpty((String)(userLeaveTipText = this.getUserLeaveTipText(exitReason, exitType = this.mRandom.nextInt(2))))) {
                return;
            }
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    GameResultLandPager.this.mUserLeaveBubbleLayout.setVisibility(0);
                    GameResultLandPager.this.mUserLeaveTipText.setText((CharSequence)userLeaveTipText);
                    RelativePos relativePos = new RelativePos(2, 0);
                    GameResultLandPager.this.mUserLeaveTipPopupWindow.showArrowTo((View)GameResultLandPager.this.mImOtherHead, relativePos, 10, 0);
                }
            }, 1000L);
        }
    }

    private boolean checkOtherBubbleShowing() {
        return this.mLlImSecond != null && this.mLlImSecond.getVisibility() == 0 || this.isLikeTipWindowShow();
    }

    private String getUserLeaveTipText(String exitReason, int exitType) {
        String tip = "";
        if (FORCE_EXIT.equals(exitReason)) {
            tip = exitType == 0 ? ResourceUtils.getString((int)R.string.short_tips_game_exit_by_initiative_one) : ResourceUtils.getString((int)R.string.short_tips_game_exit_by_initiative_two);
        } else if (ESCAPE.equals(exitReason)) {
            tip = exitType == 0 ? ResourceUtils.getString((int)R.string.short_tips_game_exit_by_passive_one) : ResourceUtils.getString((int)R.string.short_tips_game_exit_by_passive_two);
        }
        return tip;
    }

    public void hideUserLeaveTip() {
        if (this.mUserLeaveTipPopupWindow != null && this.mUserLeaveTipPopupWindow.isShowing()) {
            this.mUserLeaveTipPopupWindow.dismiss();
        }
    }

    @Override
    public void updateScoreRank(GameCooperationRank data) {
    }

    @Override
    public void onHidden() {
        this.hideLikeTipWindow();
        if (this.mUserLeaveTipPopupWindow != null) {
            this.mUserLeaveTipPopupWindow.dismiss();
        }
    }

    @Override
    public void updateDoubleScore(int score) {
    }

    @Override
    public void startLightAnim() {
        if (this.mIvLightView != null) {
            this.mIvLightView.setVisibility(0);
        }
        this.startLightAnim((View)this.mBtnJoin, (View)this.mIvLightView);
    }

    @Override
    public void cancelLightAnim() {
        this.stopLightAnim();
    }

    @Override
    public void resetJoinTips() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String playAgainTips = GameResultTipsManager.Instance.getPlayAgainTips();
                if (!TextUtils.isEmpty((CharSequence)playAgainTips) && GameResultLandPager.this.mBtnJoin != null) {
                    GameResultLandPager.this.mIsPlayAgainChanged = true;
                    GameResultLandPager.this.mBtnJoin.setText((CharSequence)playAgainTips);
                    GameResultLandPager.this.startLightAnim();
                }
            }
        }, (long)500L);
    }

    @Override
    public void showChangeOpponent() {
    }

    @Override
    public void showCoinResult(final String tips, final GameCoinResult result) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"showCoinResult", (Object[])new Object[0]);
        }
        if (result != null) {
            this.ensureStreakwinUi();
            this.mLlCoinsNum.setVisibility(0);
            this.otherLlCoinsNum.setVisibility(0);
            this.mCoinnum.setText((CharSequence)String.valueOf(result.getCurrentCoins()));
            if (result.getOthers() != null && result.getOthers().get(this.mTargetUid) != null) {
                int otherNew = FP.orInt((Long)((UserResultInfo)result.getOthers().get((Object)Long.valueOf((long)this.mTargetUid))).balance);
                this.otherCoinnum.setText((CharSequence)String.valueOf(otherNew));
            }
            if (result.getChangeCoins() != 0L) {
                String changeCoins = String.valueOf(result.getChangeCoins());
                if (result.getChangeCoins() < 0L) {
                    this.mCoinschange.setTextColor(ResourceUtils.getColor((int)R.color.font_black_op_26));
                } else {
                    changeCoins = "+" + changeCoins;
                }
                this.mCoinschange.setVisibility(0);
                this.mCoinschange.setText((CharSequence)changeCoins);
            }
            if (result.getChangeCoins() == 0L) {
                this.showUpLimit(tips);
                return;
            }
            if (result.getChangeCoins() < 0L) {
                this.svgaGameCoins.setRotationY(180.0f);
            }
            DyResLoader.INSTANCE.loadSvga(this.svgaGameCoins, DR.game_result_coins, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                    if (GameResultLandPager.this.svgaGameCoins != null) {
                        GameResultLandPager.this.svgaGameCoins.startAnimation();
                        GameResultLandPager.this.openAnim = false;
                        ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).play("coinEnterPool");
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameResultLandPager.TAG, (String)"showCoinResult start svga", (Object[])new Object[0]);
                        }
                        GameResultLandPager.this.svgaGameCoins.setCallback(new SVGACallback(){

                            public void onPause() {
                            }

                            public void onFinished() {
                            }

                            public void onRepeat() {
                            }

                            public void onStep(int i, double v) {
                                if (i == 56 && !GameResultLandPager.this.openAnim) {
                                    GameResultLandPager.this.openAnim = true;
                                    GameResultLandPager.this.startCoinsChangeAnim(tips);
                                    GameResultLandPager.this.startCoinsAnim(result);
                                }
                            }
                        });
                    }
                }

                public void onFailed(Exception e) {
                }
            });
        }
    }

    @Override
    public void onShow() {
    }

    private void startCoinsAnim(GameCoinResult result) {
        int oldCoins = (int)(result.getCurrentCoins() - result.getChangeCoins());
        int newCoins = (int)result.getCurrentCoins();
        this.startCoinsNumAnim(this.mCoinnum, oldCoins, newCoins, true);
        if (result.getOthers() != null && result.getOthers().get(this.mTargetUid) != null) {
            int otherNew = ((UserResultInfo)result.getOthers().get((Object)Long.valueOf((long)this.mTargetUid))).balance.intValue();
            int otherOld = (int)((long)otherNew + result.getChangeCoins());
            this.startCoinsNumAnim(this.otherCoinnum, otherOld, otherNew, false);
        }
    }

    @Override
    public void updateOtherHeadFrameType(int frame) {
        if (this.mImOtherHead != null) {
            this.mImOtherHead.setHeadFrame(this.mGameResultUICallBacks.getHeadFrameUrl(frame));
        }
    }

    public void startCoinsNumAnim(final YYTextView mTvCoinnum, int oldCoins, int newCoins, final boolean isMyUser) {
        if (mTvCoinnum == null) {
            return;
        }
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{oldCoins, newCoins});
        valueAnimator.setDuration(1000L);
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (isMyUser) {
                    long coins = ((ICoinsService)ServiceManagerProxy.getServiceManager().getService(ICoinsService.class)).coinStateData().gameCoinCount;
                    mTvCoinnum.setText((CharSequence)String.valueOf(coins));
                }
            }
        });
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                mTvCoinnum.setText((CharSequence)valueAnimator.getAnimatedValue().toString());
            }
        });
        valueAnimator.start();
    }

    public void startCoinsChangeAnim(final String tips) {
        ObjectAnimator anim2 = this.getTranslationAnim((View)this.mCoinschange, this.instance);
        anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                GameResultLandPager.this.mCoinschange.setVisibility(8);
                GameResultLandPager.this.showUpLimit(tips);
            }
        });
        anim2.setDuration(200L).start();
    }

    @NonNull
    private ObjectAnimator getTranslationAnim(View view, int instance) {
        PropertyValuesHolder trans = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{0 - instance});
        return ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{trans});
    }

    public void showUpLimit(String tips) {
        if (ResourceUtils.getString((int)R.string.tips_up_to_limit).equals(tips)) {
            this.limit.setVisibility(0);
            this.mLimitContent.setText((CharSequence)tips);
        }
    }

    @Override
    public void hideMoreGameBtn() {
        if (this.mBtnChangeOp != null) {
            this.mBtnChangeOp.setVisibility(8);
        }
    }
}

