/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.gameresult.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Html;
import android.text.TextUtils;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.GameCooperationRank;
import com.yy.game.bean.GameResultMsgBean;
import com.yy.game.gamemodule.pkgame.gameresult.GameResultTipsManager;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultUICallbacks;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultView;
import com.yy.game.gamemodule.pkgame.gameresult.ui.BaseResultPager;
import com.yy.game.wight.GameEmotionAnimView;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.coins.GameCoinResult;
import com.yy.hiyo.game.service.IGameService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.LinkedList;

public class GameResultDoubleLandPager
extends BaseResultPager
implements IGameResultView {
    private static final String TAG = "GameResultDoubleLandPager";
    private View mContent;
    private IGameResultUICallbacks mGameResultUICallBacks;
    private TextView mTvAnd;
    private TextView mTvMyName;
    private TextView mTvOtherName;
    private ViewGroup mLayoutMine;
    private ViewGroup mLayoutOther;
    private RoundImageView mImMyHead;
    private RoundImageView mImOtherHead;
    private RecycleImageView mImgMySex;
    private RecycleImageView mImgOtherSex;
    private View mExpressView;
    private View mTopView;
    private GameEmotionAnimView mLeftGameEmotionAnimView;
    private GameEmotionAnimView mRightGameEmotionAnimView;
    private TextView mBtnJoin;
    private TextView mBtnJoinTmp;
    private TextView mBtnChangeOp;
    private RecycleImageView mImgGameLikeMe;
    private RecycleImageView mImgGameLikeOther;
    private SVGAImageView mBackSVGAImageView;
    private SVGAImageView mLikeSVGAImageView;
    private SVGAImageView mLikeSuccessSVGAImageView;
    private TextView mTvGameResultRank;
    private TextView mTvGameResultScore;
    private YYFrameLayout mImOtherContainer;
    private YYFrameLayout mImMyContainer;
    private YYTextView mTvOtherImFirst;
    private YYTextView mTvOtherImSecond;
    private YYTextView mTvMyImFirst;
    private YYTextView mTvMyImSecond;
    private RecycleImageView mOtherImageView;
    private RecycleImageView mOtherPreImageView;
    private LinearLayout mOtherMsgLayoutFirst;
    private LinearLayout mOtherMsgLayoutSecond;
    private LinearLayout mMyMsgLayoutFirst;
    private LinearLayout mMyMsgLayoutSecond;
    private ImageView mIvLightView;
    private static final int RESULT_LOAD_FAIL = -1;
    private static final int RESULT_EXIT = -2;
    private boolean mIsPlayAgainChanged = false;

    public GameResultDoubleLandPager(Context context, IGameResultUICallbacks mGameUICallbacks) {
        super(context);
        this.mGameResultUICallBacks = mGameUICallbacks;
        this.createView(context);
    }

    private void createView(Context context) {
        this.mContent = GameResultDoubleLandPager.inflate((Context)context, (int)R.layout.game_result_double_team_land, null);
        this.mContent.setPadding(0, ResourceUtils.getDimen((int)R.dimen.ver_game_result_top_padding), 0, 0);
        this.addView(this.mContent, new ViewGroup.LayoutParams(-1, -1));
        View mineView = this.mContent.findViewById(R.id.layout_mine);
        RecycleImageView tvMineLike = (RecycleImageView)mineView.findViewById(R.id.img_like);
        tvMineLike.setVisibility(8);
        TextView tvScoreTips = (TextView)this.mContent.findViewById(R.id.tv_score_tips);
        tvScoreTips.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mImOtherContainer = (YYFrameLayout)this.mContent.findViewById(R.id.fl_im_other_container);
        this.mImMyContainer = (YYFrameLayout)this.mContent.findViewById(R.id.fl_im_my_container);
        this.mTvGameResultScore = (TextView)this.mContent.findViewById(R.id.tv_game_result_score);
        this.mTvGameResultRank = (TextView)this.mContent.findViewById(R.id.tv_game_result_rank);
        this.mTvGameResultRank.setTypeface(Typeface.defaultFromStyle((int)1));
        if (this.mExpressView == null) {
            this.mExpressView = this.mGameResultUICallBacks.getHorExpressBarView();
        }
        if (this.mExpressView != null && this.mExpressView.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.mExpressView.getParent()).removeView(this.mExpressView);
        }
        this.mExpressView = this.mGameResultUICallBacks.getHorExpressBarView();
        this.mBtnJoin = (TextView)this.mContent.findViewById(R.id.btn_join);
        this.mBtnJoinTmp = (TextView)this.mContent.findViewById(R.id.btn_join_tmp);
        this.mBtnJoin.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBtnJoin.setStateListAnimator(ResourceUtils.getStateListAnimator((int)R.animator.result_btn_selector));
        }
        this.mBtnJoin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GameResultDoubleLandPager.this.mIsPlayAgainChanged) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023779").put("function_id", "play_again_pop_click"));
                }
                GameResultDoubleLandPager.this.mGameResultUICallBacks.onPlayGameClicked();
            }
        });
        this.mTvAnd = (TextView)this.mContent.findViewById(R.id.tv_team_and);
        this.mTvAnd.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mBtnChangeOp = (TextView)this.mContent.findViewById(R.id.btn_change_op);
        this.mBackSVGAImageView = (SVGAImageView)this.mContent.findViewById(R.id.svg_back);
        this.mLikeSVGAImageView = (SVGAImageView)this.mContent.findViewById(R.id.svg_like);
        this.mLikeSuccessSVGAImageView = (SVGAImageView)this.mContent.findViewById(R.id.svg_like_success);
        this.mBtnChangeOp.setText((CharSequence)ResourceUtils.getString((int)R.string.more_game));
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBtnChangeOp.setStateListAnimator(ResourceUtils.getStateListAnimator((int)R.animator.result_btn_selector));
        }
        this.mBtnChangeOp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GameResultDoubleLandPager.this.mGameResultUICallBacks.getIsGuideAi()) {
                    GameResultDoubleLandPager.this.mGameResultUICallBacks.onPracticeAgain();
                    return;
                }
                GameResultDoubleLandPager.this.mGameResultUICallBacks.continueClick();
                GameResultDoubleLandPager.this.mGameResultUICallBacks.reportGameResult("more_game");
            }
        });
        this.mImOtherContainer = (YYFrameLayout)this.findViewById(R.id.fl_im_other_container);
        this.mImMyContainer = (YYFrameLayout)this.findViewById(R.id.fl_im_my_container);
        this.mTvOtherImFirst = (YYTextView)this.mImOtherContainer.findViewById(R.id.game_result_im1_tv);
        this.mTvOtherImSecond = (YYTextView)this.mImOtherContainer.findViewById(R.id.game_result_im2_tv);
        this.mTvMyImFirst = (YYTextView)this.mImMyContainer.findViewById(R.id.game_result_im1_tv);
        this.mTvMyImSecond = (YYTextView)this.mImMyContainer.findViewById(R.id.game_result_im2_tv);
        this.mOtherImageView = (RecycleImageView)this.mImOtherContainer.findViewById(R.id.game_img);
        this.mOtherPreImageView = (RecycleImageView)this.mImOtherContainer.findViewById(R.id.game_img_2);
        this.mOtherMsgLayoutFirst = (LinearLayout)this.mImOtherContainer.findViewById(R.id.msg_layout_1);
        this.mOtherMsgLayoutSecond = (LinearLayout)this.mImOtherContainer.findViewById(R.id.msg_layout_2);
        this.mMyMsgLayoutFirst = (LinearLayout)this.mImMyContainer.findViewById(R.id.msg_layout_1);
        this.mMyMsgLayoutSecond = (LinearLayout)this.mImMyContainer.findViewById(R.id.msg_layout_2);
        this.mIvLightView = (ImageView)this.findViewById(R.id.iv_game_result_light);
        this.mBtnChangeOp.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mTopView = this.mGameResultUICallBacks.getTopBarView();
        RelativeLayout.LayoutParams topLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        topLayoutParams.addRule(10);
        topLayoutParams.setMargins(0, ResourceUtils.getDimen((int)R.dimen.ver_game_result_top_padding), 0, 0);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(11);
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mTopView.measure(w, h);
        int height = this.mTopView.getMeasuredHeight();
        layoutParams.setMargins(0, height + ResolutionUtils.dip2Px((float)30.0f), ResolutionUtils.dip2Px((float)15.0f), 0);
        this.addView(this.mTopView, (ViewGroup.LayoutParams)topLayoutParams);
        this.addView(this.mExpressView, (ViewGroup.LayoutParams)layoutParams);
        this.initMineLayout();
        this.initOtherLayout();
        DyResLoader.INSTANCE.loadSvga(this.mBackSVGAImageView, DR.single_game_result_new_record, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
                if (GameResultDoubleLandPager.this.mBackSVGAImageView != null) {
                    GameResultDoubleLandPager.this.mBackSVGAImageView.startAnimation();
                }
            }

            public void onFailed(Exception e) {
            }
        });
        DyResLoader.INSTANCE.loadSvga(this.mLikeSuccessSVGAImageView, DR.game_like_success, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
            }

            public void onFailed(Exception e) {
            }
        });
    }

    private void initOtherLayout() {
        if (this.mContent != null) {
            this.mLayoutOther = (ViewGroup)this.mContent.findViewById(R.id.layout_other);
            this.mTvOtherName = (TextView)this.mLayoutOther.findViewById(R.id.tv_user_name_right);
            this.mImOtherHead = (RoundImageView)this.mLayoutOther.findViewById(R.id.img_avtor_right);
            this.mRightGameEmotionAnimView = (GameEmotionAnimView)this.findViewById(R.id.emotion_right);
            this.mImgGameLikeOther = (RecycleImageView)this.mLayoutOther.findViewById(R.id.iv_btn_like);
            this.mImgGameLikeOther.setVisibility(0);
            this.mImgGameLikeOther.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GameResultDoubleLandPager.this.mGameResultUICallBacks.likeResult();
                }
            });
            this.mImOtherHead.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Object info;
                    if (GameResultDoubleLandPager.this.mGameResultUICallBacks != null && (info = GameResultDoubleLandPager.this.mImOtherHead.getTag()) instanceof UserInfoBean) {
                        GameResultDoubleLandPager.this.mGameResultUICallBacks.showUserProfileCard(((UserInfoBean)info).getUid());
                    }
                }
            });
            this.expandViewTouchDelegate((View)this.mImgGameLikeOther);
        }
    }

    private void initMineLayout() {
        if (this.mContent != null) {
            this.mLayoutMine = (ViewGroup)this.mContent.findViewById(R.id.layout_mine);
            this.mTvMyName = (TextView)this.mLayoutMine.findViewById(R.id.tv_user_name);
            this.mImMyHead = (RoundImageView)this.mLayoutMine.findViewById(R.id.img_avtor);
            this.mLeftGameEmotionAnimView = (GameEmotionAnimView)this.findViewById(R.id.emotion);
            this.mImgGameLikeMe = (RecycleImageView)this.mLayoutMine.findViewById(R.id.img_like);
            this.mImgGameLikeMe.setVisibility(8);
        }
    }

    public GameResultDoubleLandPager(Context context) {
        super(context);
        this.createView(context);
    }

    @Override
    public void showView(ViewGroup parentView) {
        parentView.addView((View)this);
    }

    @Override
    public void updateScore(int myScore, int otherScore) {
    }

    @Override
    public void updateSceneView(int gameScene) {
        if (this.mGameResultUICallBacks.getIsGuideAi()) {
            this.mBtnChangeOp.setVisibility(0);
            return;
        }
        if (gameScene == IGameService.GAME_FROM.FROM_MATCH.value()) {
            this.mBtnChangeOp.setVisibility(0);
        }
    }

    @Override
    public void updateUserInfo(UserInfoBean myinfo, UserInfoBean otherinfo) {
        if (myinfo != null) {
            this.mTvMyName.setText((CharSequence)(FP.empty((CharSequence)myinfo.getNick()) ? "" : myinfo.getNick().trim()));
            ImageLoader.loadImage((RecycleImageView)this.mImMyHead, (String)(myinfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)myinfo.getSex()));
            this.mImMyHead.setTag((Object)myinfo);
        }
        if (otherinfo != null) {
            this.mTvOtherName.setText((CharSequence)(FP.empty((CharSequence)otherinfo.getNick()) ? "" : otherinfo.getNick().trim()));
            ImageLoader.loadImage((RecycleImageView)this.mImOtherHead, (String)(otherinfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)otherinfo.getSex()));
            this.mImOtherHead.setTag((Object)otherinfo);
        }
    }

    @Override
    public void update2v2UserInfos(UserInfoKS me, UserInfoKS friends, UserInfoKS other0, UserInfoKS other1) {
    }

    @Override
    public void setBtnDisable() {
        if (this.mBtnJoin != null) {
            this.mBtnJoin.setEnabled(false);
        }
    }

    @Override
    public void updateResultBG(GameDef.GameResult result, boolean showNewResult, int lastWinCount) {
    }

    @Override
    public AnimatorSet getPushAnimator(AbstractWindow frontWindow, AbstractWindow backWindow) {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator alphaOut = ObjectAnimator.ofFloat((Object)backWindow, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator scaleYOut = ObjectAnimator.ofFloat((Object)backWindow, (String)"scaleY", (float[])new float[]{1.0f, 1.2f});
        ObjectAnimator scaleXOut = ObjectAnimator.ofFloat((Object)backWindow, (String)"scaleX", (float[])new float[]{1.0f, 1.2f});
        View join = this.mContent.findViewById(R.id.btn_join_layout);
        ObjectAnimator alphaIn = ObjectAnimator.ofFloat((Object)frontWindow, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        float move = 160.0f * this.getContext().getResources().getDisplayMetrics().density;
        ObjectAnimator svgaAlphaDown = ObjectAnimator.ofFloat((Object)this.mBackSVGAImageView, (String)"translationY", (float[])new float[]{-move, 0.0f});
        ObjectAnimator btnJoinAlphaUp = ObjectAnimator.ofFloat((Object)join, (String)"translationY", (float[])new float[]{move, 0.0f});
        ObjectAnimator mBtnChangeOpAlphaUp = ObjectAnimator.ofFloat((Object)this.mBtnChangeOp, (String)"translationY", (float[])new float[]{move, 0.0f});
        ObjectAnimator expressAlphaUp = ObjectAnimator.ofFloat((Object)this.mExpressView, (String)"translationY", (float[])new float[]{move, 0.0f});
        int duration = 240;
        int startDelay = 60;
        alphaOut.setDuration((long)duration);
        scaleYOut.setDuration((long)duration);
        scaleXOut.setDuration((long)duration);
        alphaIn.setDuration((long)duration);
        svgaAlphaDown.setDuration((long)duration).setStartDelay((long)(startDelay * 2));
        btnJoinAlphaUp.setDuration((long)duration);
        mBtnChangeOpAlphaUp.setDuration((long)duration).setStartDelay((long)startDelay);
        expressAlphaUp.setDuration((long)duration).setStartDelay((long)(startDelay * 2));
        if (this.mBackSVGAImageView != null) {
            this.mBackSVGAImageView.setTranslationY(-move);
        }
        if (this.mBtnChangeOp != null) {
            this.mBtnChangeOp.setTranslationY(move);
        }
        if (this.mExpressView != null) {
            this.mExpressView.setTranslationY(move);
        }
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.play((Animator)alphaOut).with((Animator)scaleYOut).with((Animator)scaleXOut).with((Animator)alphaIn).with((Animator)btnJoinAlphaUp).with((Animator)mBtnChangeOpAlphaUp).with((Animator)svgaAlphaDown).with((Animator)expressAlphaUp);
        return animatorSet;
    }

    @Override
    public void updateBtnTextFromPlayWithAI() {
        this.mBtnJoin.setTextSize(2, 18.0f);
        this.mBtnChangeOp.setTextSize(2, 18.0f);
        this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.game_result_play_with_real_people));
        this.mBtnJoin.setBackgroundResource(R.drawable.red_round_3_selector);
        this.mBtnChangeOp.setText((CharSequence)ResourceUtils.getString((int)R.string.game_result_practice_again));
    }

    @Override
    public void onMessageArrived(LinkedList<GameResultMsgBean> imMessageQueue) {
        if (imMessageQueue == null || imMessageQueue.size() <= 0) {
            return;
        }
        this.hideLikeTipWindow();
        if (imMessageQueue.size() == 1) {
            this.mOtherMsgLayoutSecond.setVisibility(8);
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(0);
            if (StringUtils.isNotEmpty((String)gameResultMsgBean.getGameIcon())) {
                this.mOtherImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mOtherImageView, (String)gameResultMsgBean.getGameIcon());
            } else {
                this.mOtherImageView.setVisibility(8);
            }
            if (TextUtils.isEmpty((CharSequence)gameResultMsgBean.getGameIcon())) {
                this.mTvOtherImFirst.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(gameResultMsgBean.getContent().toString()));
            } else {
                this.mTvOtherImFirst.setText(gameResultMsgBean.getContent());
            }
            this.startIM1Animator();
            this.mOtherMsgLayoutFirst.setVisibility(0);
        } else if (imMessageQueue.size() == 2) {
            this.mImOtherContainer.setVisibility(0);
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(1);
            if (StringUtils.isNotEmpty((String)gameResultMsgBean.getGameIcon())) {
                this.mOtherImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mOtherImageView, (String)gameResultMsgBean.getGameIcon());
            } else {
                this.mOtherImageView.setVisibility(8);
            }
            if (TextUtils.isEmpty((CharSequence)gameResultMsgBean.getGameIcon())) {
                this.mTvOtherImFirst.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(gameResultMsgBean.getContent().toString()));
            } else {
                this.mTvOtherImFirst.setText(gameResultMsgBean.getContent());
            }
            GameResultMsgBean firstGameResultBean = imMessageQueue.get(0);
            if (TextUtils.isEmpty((CharSequence)firstGameResultBean.getGameIcon())) {
                this.mTvOtherImSecond.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(firstGameResultBean.getContent().toString()));
            } else {
                this.mTvOtherImSecond.setText(firstGameResultBean.getContent());
            }
            if (!TextUtils.isEmpty((CharSequence)firstGameResultBean.getGameIcon())) {
                this.mOtherPreImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mOtherPreImageView, (String)firstGameResultBean.getGameIcon());
            } else {
                this.mOtherPreImageView.setVisibility(8);
            }
            this.mOtherMsgLayoutFirst.setVisibility(0);
            this.mOtherMsgLayoutSecond.setVisibility(0);
            this.startIM1Animator();
            this.startIM2Animator();
        }
    }

    private void startIM2Animator() {
        this.mOtherMsgLayoutFirst.post(new Runnable(){

            @Override
            public void run() {
                int height;
                int n = height = GameResultDoubleLandPager.this.mOtherMsgLayoutFirst.getHeight() > 0 ? GameResultDoubleLandPager.this.mOtherMsgLayoutFirst.getHeight() : ResolutionUtils.dip2Px((float)40.0f);
                if (GameResultDoubleLandPager.this.mOtherMsgLayoutSecond.getVisibility() == 8) {
                    height = ResolutionUtils.dip2Px((float)40.0f);
                }
                ObjectAnimator transAnimator = ObjectAnimator.ofFloat((Object)GameResultDoubleLandPager.this.mOtherMsgLayoutSecond, (String)"translationY", (float[])new float[]{0.0f, height});
                ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)GameResultDoubleLandPager.this.mOtherMsgLayoutSecond, (String)"alpha", (float[])new float[]{1.0f, 0.3f});
                AnimatorSet set = new AnimatorSet();
                set.setDuration(300L);
                set.playTogether(new Animator[]{transAnimator, alphaAnimator});
                set.start();
            }
        });
    }

    private void startIM1Animator() {
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this.mOtherMsgLayoutFirst, (String)"scaleX", (float[])new float[]{0.0f, 1.3f, 1.0f});
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this.mOtherMsgLayoutFirst, (String)"scaleY", (float[])new float[]{0.0f, 1.3f, 1.0f});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(500L);
        set.playTogether(new Animator[]{animatorX, animatorY});
        set.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        set.start();
    }

    @Override
    public void onMessageSend(LinkedList<GameResultMsgBean> imMessageQueue) {
        if (imMessageQueue == null) {
            return;
        }
        if (imMessageQueue.size() == 1) {
            this.mMyMsgLayoutSecond.setVisibility(8);
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(0);
            this.mTvMyImFirst.setText(gameResultMsgBean.getContent());
            this.startIM1Animator();
            this.mMyMsgLayoutFirst.setVisibility(0);
        } else if (imMessageQueue.size() == 2) {
            this.mImMyContainer.setVisibility(0);
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(1);
            this.mTvMyImFirst.setText(gameResultMsgBean.getContent());
            this.mTvMyImSecond.setText(imMessageQueue.get(0).getContent());
            this.mMyMsgLayoutFirst.setVisibility(0);
            this.mMyMsgLayoutSecond.setVisibility(0);
            this.startIM1Animator();
            this.startIM2Animator();
        }
    }

    @Override
    public void clearMsg(boolean isMe) {
        if (isMe) {
            this.mMyMsgLayoutFirst.setVisibility(8);
            this.mMyMsgLayoutSecond.setVisibility(8);
        } else {
            this.mOtherMsgLayoutFirst.setVisibility(8);
            this.mOtherMsgLayoutSecond.setVisibility(8);
        }
    }

    @Override
    public void showEmoj(EmojiBean emojiBean, int postion) {
        if (postion == 0) {
            if (this.mLeftGameEmotionAnimView != null) {
                this.mLeftGameEmotionAnimView.playEmotion(emojiBean);
            }
        } else if (this.mRightGameEmotionAnimView != null) {
            this.mRightGameEmotionAnimView.playEmotion(emojiBean);
        }
    }

    @Override
    public void showBarrageView(BarrageInfo barrageInfo) {
    }

    @Override
    public void updateJoinBtn(GameDef.PKGameInviteStatus type) {
        this.mBtnJoin.setEnabled(true);
        if (this.mGameResultUICallBacks.getIsGuideAi()) {
            this.updateBtnTextFromPlayWithAI();
            return;
        }
        this.mBtnJoin.setTextSize(2, 20.0f);
        this.mBtnChangeOp.setTextSize(2, 20.0f);
        if (type == GameDef.PKGameInviteStatus.JOIN_GAME) {
            this.mBtnJoinTmp.setText((CharSequence)ResourceUtils.getString((int)R.string.joingame));
            this.mBtnJoinTmp.setBackgroundResource(R.drawable.green_round_3);
            this.mBtnJoinTmp.setVisibility(0);
            ObjectAnimator alphaIn = ObjectAnimator.ofFloat((Object)this.mBtnJoinTmp, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator alphaOut = ObjectAnimator.ofFloat((Object)this.mBtnJoin, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            ObjectAnimator scaleYIn = ObjectAnimator.ofFloat((Object)this.mBtnJoinTmp, (String)"scaleY", (float[])new float[]{0.8f, 1.0f});
            ObjectAnimator scaleYOut = ObjectAnimator.ofFloat((Object)this.mBtnJoin, (String)"scaleY", (float[])new float[]{1.0f, 0.8f});
            ObjectAnimator scaleXIn = ObjectAnimator.ofFloat((Object)this.mBtnJoinTmp, (String)"scaleX", (float[])new float[]{0.8f, 1.0f});
            ObjectAnimator scaleXOut = ObjectAnimator.ofFloat((Object)this.mBtnJoin, (String)"scaleX", (float[])new float[]{1.0f, 0.8f});
            AnimatorSet animSet = new AnimatorSet();
            animSet.play((Animator)alphaIn).with((Animator)alphaOut).with((Animator)scaleYIn).with((Animator)scaleYOut).with((Animator)scaleXIn).with((Animator)scaleXOut);
            animSet.setDuration(150L);
            animSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    GameResultDoubleLandPager.this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.joingame));
                    GameResultDoubleLandPager.this.mBtnJoin.setBackgroundResource(R.drawable.green_round_3);
                    GameResultDoubleLandPager.this.mBtnJoin.setScaleX(1.0f);
                    GameResultDoubleLandPager.this.mBtnJoin.setScaleY(1.0f);
                    GameResultDoubleLandPager.this.mBtnJoin.setAlpha(1.0f);
                    GameResultDoubleLandPager.this.mBtnJoinTmp.setVisibility(8);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            animSet.start();
        } else if (type == GameDef.PKGameInviteStatus.JOIN_OTHER_GAME) {
            if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)ResourceUtils.getString((int)R.string.join_ohter_game), (Object[])new Object[0]);
            }
            this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.joingame));
            this.mBtnJoin.setBackgroundResource(R.drawable.green_round_3);
        } else if (type == GameDef.PKGameInviteStatus.PLAY_AGAIN) {
            this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.play_again));
            this.mBtnJoin.setBackgroundResource(R.drawable.red_round_3_selector);
        } else if (type == GameDef.PKGameInviteStatus.WAIT_OPPOENT) {
            this.stopLightAnim();
            this.mBtnJoin.setEnabled(false);
            this.mBtnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.wait_for_oppent));
            this.mBtnJoin.setBackgroundResource(R.drawable.gary_round_3);
        }
    }

    @Override
    public void showLikeGuide() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameResultDoubleLandPager.this.playBtnLikeSvga(DR.game_result_like_guide, true);
            }
        }, (long)300L);
    }

    @Override
    public View getOtherBtnLikeView() {
        return this.mImgGameLikeOther;
    }

    @Override
    public CharSequence getMsgText(GameDef.PKGameInviteStatus type, String gameName) {
        if (type == GameDef.PKGameInviteStatus.JOIN_GAME) {
            return ResourceUtils.getString((int)R.string.letplayagain);
        }
        if (type == GameDef.PKGameInviteStatus.JOIN_OTHER_GAME) {
            String textStr = "<font color=\"#ffffff\">" + ResourceUtils.getString((int)R.string.play_antnother) + "</font> <font color=\"#fff000\">" + gameName + "</font>";
            return Html.fromHtml((String)textStr);
        }
        if (type == GameDef.PKGameInviteStatus.PLAY_AGAIN) {
            return null;
        }
        if (type == GameDef.PKGameInviteStatus.WAIT_OPPOENT) {
            return ResourceUtils.getString((int)R.string.ready);
        }
        return null;
    }

    private void expandViewTouchDelegate(final View view) {
        ((View)view.getParent()).post(new Runnable(){

            @Override
            public void run() {
                Rect bounds = new Rect();
                view.setEnabled(true);
                view.getHitRect(bounds);
                bounds.top = view.getTop() + ResolutionUtils.dip2Px((float)20.0f);
                bounds.bottom = view.getBottom() + ResolutionUtils.dip2Px((float)20.0f);
                bounds.left = view.getLeft() + ResolutionUtils.dip2Px((float)20.0f);
                bounds.right = view.getRight() + ResolutionUtils.dip2Px((float)20.0f);
                TouchDelegate touchDelegate = new TouchDelegate(bounds, view);
                if (View.class.isInstance(view.getParent())) {
                    ((View)view.getParent()).setTouchDelegate(touchDelegate);
                }
            }
        });
    }

    @Override
    public void updateLike(boolean isEnable) {
        this.playBtnLikeSvga(DR.game_result_like_pressed, false);
    }

    @Override
    public void startLikeAnim() {
        if (this.mLikeSVGAImageView == null) {
            return;
        }
        DyResLoader.INSTANCE.loadSvga(this.mLikeSVGAImageView, DR.game_result_like_full_screen, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                GameResultDoubleLandPager.this.playLikedSvga();
            }

            public void onFailed(Exception e) {
            }
        });
    }

    private void playLikedSvga() {
        if (this.mLikeSVGAImageView != null) {
            this.mLikeSVGAImageView.startAnimation();
            this.mLikeSVGAImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GameResultDoubleLandPager.this.mLikeSVGAImageView.stopAnimation();
                    GameResultDoubleLandPager.this.mLikeSVGAImageView.setVisibility(8);
                }
            });
        }
    }

    @Override
    public void showLikeTip() {
        this.showLikeTipWindow((View)this.mImgGameLikeOther);
    }

    @Override
    public void showScoreError(int reason) {
        if (this.mTvGameResultScore == null) {
            return;
        }
        if (reason == -1) {
            this.mTvGameResultScore.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
            this.mTvGameResultScore.setTextSize(2, 20.0f);
            this.mTvGameResultScore.setText((CharSequence)ResourceUtils.getString((int)R.string.game_double_null_score));
        } else if (reason == -2) {
            this.mTvGameResultScore.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.CaptainAmerica));
            this.mTvGameResultScore.setTextSize((float)ResourceUtils.getDimen((int)R.dimen.double_game_result_score));
            this.mTvGameResultScore.setText((CharSequence)"0");
            if (this.mTvGameResultRank != null) {
                this.mTvGameResultRank.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_team_game_exit_hint));
            }
        }
    }

    @Override
    public void showUserLeaveTip(String exitReason) {
    }

    @Override
    public void updateScoreRank(GameCooperationRank data) {
        if (this.mTvGameResultRank != null && !TextUtils.isEmpty((CharSequence)data.rankValue)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("updateScoreRank:" + data.rankValue), (Object[])new Object[0]);
            }
            this.mTvGameResultRank.setText((CharSequence)data.rankValue);
        }
    }

    @Override
    public void onHidden() {
        this.hideLikeTipWindow();
    }

    @Override
    public void updateDoubleScore(int score) {
        if (this.mTvGameResultScore != null) {
            this.mTvGameResultScore.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.CaptainAmerica));
            this.mTvGameResultScore.setTextSize((float)ResourceUtils.getDimen((int)R.dimen.double_game_result_score));
            this.mTvGameResultScore.setText((CharSequence)(score + ""));
        }
    }

    @Override
    public void startLightAnim() {
        if (this.mIvLightView != null) {
            this.mIvLightView.setVisibility(0);
        }
        this.startLightAnim((View)this.mBtnJoin, (View)this.mIvLightView);
    }

    @Override
    public void cancelLightAnim() {
        this.stopLightAnim();
    }

    @Override
    public void resetJoinTips() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String playAgainTips = GameResultTipsManager.Instance.getPlayAgainTips();
                if (!TextUtils.isEmpty((CharSequence)playAgainTips) && GameResultDoubleLandPager.this.mBtnJoin != null) {
                    GameResultDoubleLandPager.this.mIsPlayAgainChanged = true;
                    GameResultDoubleLandPager.this.mBtnJoin.setText((CharSequence)playAgainTips);
                    GameResultDoubleLandPager.this.startLightAnim();
                }
            }
        }, (long)500L);
    }

    @Override
    public void showChangeOpponent() {
    }

    @Override
    public void showCoinResult(String tips, GameCoinResult result) {
    }

    @Override
    public void onShow() {
    }

    @Override
    public void updateOtherHeadFrameType(int frame) {
    }
}

