/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.gameresult.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Html;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.bubble.BubbleLinearLayout;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.guid.GuidFactory;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.GameCooperationRank;
import com.yy.game.bean.GameResultMsgBean;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultUICallbacks;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultView;
import com.yy.game.gamemodule.pkgame.gameresult.ui.BaseResultPager;
import com.yy.game.wight.GameEmotionAnimView;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.coins.GameCoinResult;
import com.yy.hiyo.game.service.IGameService;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class GameResult2V2Page
extends BaseResultPager
implements IGameResultView {
    public static final String TAG = "GameResult2V2Page";
    IGameResultUICallbacks mGameResultUICallBacks;
    private View mContent;
    View mExpressView;
    View mTopView;
    ViewGroup mLayoutMine;
    ViewGroup mLayoutOther;
    ViewGroup mLayoutTarget0;
    ViewGroup mLayoutTarget1;
    HeadFrameImageView mImMyHead;
    HeadFrameImageView mImOtherHead;
    HeadFrameImageView mImTargetHead0;
    HeadFrameImageView mImTargethead1;
    RecycleImageView ivMineCrown;
    RecycleImageView ivOtherCrown;
    RecycleImageView ivTarget0Crown;
    RecycleImageView ivTarget1Crown;
    YYTextView tvAnd;
    YYTextView tvVs;
    YYLinearLayout mLLTarget;
    YYTextView mTvOtherIm1;
    YYTextView mTvOtherIm2;
    YYTextView mTvMyIm1;
    YYTextView mTvMyIm2;
    RecycleImageView mOtherImageView;
    RecycleImageView mMyImageView;
    RecycleImageView mOtherImageViewSecond;
    RecycleImageView mImgGameLikeMe;
    RecycleImageView mImgGameLikeOther;
    YYFrameLayout mImMyContainer;
    YYRelativeLayout mImOtherContainer;
    LinearLayout mMyMsgLayout1;
    LinearLayout mMyMsgLayout2;
    BubbleLinearLayout mOtherMsgLayout1;
    BubbleLinearLayout mOtherMsgLayout2;
    YYTextView mTvMyname;
    YYTextView mTvOtherName;
    YYTextView mRightTvPop;
    private GameEmotionAnimView myGameEmotionAnimView;
    private GameEmotionAnimView friendGameEmotionAnimView;
    private GameEmotionAnimView targetGameEmotionAnimView0;
    private GameEmotionAnimView targetGameEmotionAnimView1;
    TextView btnJoin;
    TextView btnJoinTmp;
    TextView mBtnChangeOp;
    SVGAImageView likeSVGAImageView;
    SVGAImageView likeSuccessSVGAImageView;
    SVGAImageView backSVGAImageView;
    SVGAImageView newRegisterGameResult;
    RecycleImageView backImageView;
    View streakWinArea;
    TextView streakWinCount;
    TextView streakWinText;
    TextView mTvTapContinue;
    boolean showingTargetUsers = true;
    boolean dismissingTargetUsers = false;
    List<Runnable> msgRunnables = new ArrayList<Runnable>();
    private ImageView mIvLightView;
    private View mTvMyNameGap;
    private View mTvOtherNameGap;
    private boolean hasLikeOthers = false;

    public GameResult2V2Page(Context context, IGameResultUICallbacks mGameUICallbacks) {
        super(context);
        this.mGameResultUICallBacks = mGameUICallbacks;
        this.createView(context);
    }

    public GameResult2V2Page(Context context) {
        super(context);
        this.createView(context);
    }

    public void createView(Context context) {
        this.mContent = GameResult2V2Page.inflate((Context)context, (int)R.layout.game_result_2v2_layout, null);
        this.mContent.setPadding(0, ResourceUtils.getDimen((int)R.dimen.ver_game_result_top_padding), 0, 0);
        this.addView(this.mContent, new ViewGroup.LayoutParams(-1, -1));
        if (this.mExpressView == null) {
            this.mExpressView = this.mGameResultUICallBacks.getExpressBarView();
        }
        if (this.mExpressView != null && this.mExpressView.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.mExpressView.getParent()).removeView(this.mExpressView);
        }
        this.mExpressView = this.mGameResultUICallBacks.getExpressBarView();
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(12);
        layoutParams.addRule(14);
        layoutParams.setMargins(0, 0, 0, ResourceUtils.getDimen((int)R.dimen.game_express_bottom));
        this.btnJoin = (TextView)this.mContent.findViewById(R.id.btn_join);
        this.btnJoinTmp = (TextView)this.mContent.findViewById(R.id.btn_join_tmp);
        this.btnJoin.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        if (Build.VERSION.SDK_INT >= 21) {
            this.btnJoin.setStateListAnimator(ResourceUtils.getStateListAnimator((int)R.animator.result_btn_selector));
        }
        this.btnJoin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GameResult2V2Page.this.shouldInterceptActionBeforeTransationViews(new Runnable(){

                    @Override
                    public void run() {
                        GameResult2V2Page.this.mGameResultUICallBacks.onPlayGameClicked();
                    }
                })) {
                    return;
                }
                GameResult2V2Page.this.mGameResultUICallBacks.onPlayGameClicked();
            }
        });
        this.mBtnChangeOp = (TextView)this.mContent.findViewById(R.id.btn_change_op);
        this.mBtnChangeOp.setText((CharSequence)ResourceUtils.getString((int)R.string.more_game));
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBtnChangeOp.setStateListAnimator(ResourceUtils.getStateListAnimator((int)R.animator.result_btn_selector));
        }
        this.mBtnChangeOp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GameResult2V2Page.this.mGameResultUICallBacks.getIsGuideAi()) {
                    GameResult2V2Page.this.mGameResultUICallBacks.onPracticeAgain();
                    return;
                }
                GameResult2V2Page.this.mGameResultUICallBacks.continueClick();
                GameResult2V2Page.this.mGameResultUICallBacks.reportGameResult("more_game");
            }
        });
        this.mBtnChangeOp.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.addView(this.mExpressView, (ViewGroup.LayoutParams)layoutParams);
        this.mTopView = this.mGameResultUICallBacks.getTopBarView();
        RelativeLayout.LayoutParams topLayoutParams = new RelativeLayout.LayoutParams(-1, -2);
        topLayoutParams.addRule(10);
        topLayoutParams.setMargins(0, ResourceUtils.getDimen((int)R.dimen.ver_game_result_top_padding), 0, 0);
        this.addView(this.mTopView, (ViewGroup.LayoutParams)topLayoutParams);
        this.backSVGAImageView = (SVGAImageView)this.mContent.findViewById(R.id.svg_back);
        this.newRegisterGameResult = (SVGAImageView)this.mContent.findViewById(R.id.svga_new_result);
        this.newRegisterGameResult.setClearsAfterStop(false);
        this.backImageView = (RecycleImageView)this.mContent.findViewById(R.id.img_back);
        this.likeSVGAImageView = (SVGAImageView)this.mContent.findViewById(R.id.svg_like);
        this.likeSuccessSVGAImageView = (SVGAImageView)this.mContent.findViewById(R.id.svg_like_success);
        this.backSVGAImageView.setFillMode(SVGAImageView.FillMode.Forward);
        this.backSVGAImageView.setClearsAfterStop(false);
        this.mImOtherContainer = (YYRelativeLayout)this.findViewById(R.id.fl_im_other_container);
        this.mImMyContainer = (YYFrameLayout)this.findViewById(R.id.fl_im_my_container);
        this.mTvOtherIm1 = (YYTextView)this.mImOtherContainer.findViewById(R.id.game_result_im1_tv);
        this.mTvOtherIm2 = (YYTextView)this.mImOtherContainer.findViewById(R.id.game_result_im2_tv);
        this.mTvMyIm1 = (YYTextView)this.mImMyContainer.findViewById(R.id.game_result_im1_tv);
        this.mTvMyIm2 = (YYTextView)this.mImMyContainer.findViewById(R.id.game_result_im2_tv);
        this.mOtherImageView = (RecycleImageView)this.mImOtherContainer.findViewById(R.id.game_img);
        this.mOtherImageViewSecond = (RecycleImageView)this.mImOtherContainer.findViewById(R.id.game_img_2);
        this.mMyImageView = (RecycleImageView)this.mImMyContainer.findViewById(R.id.game_img);
        this.mOtherMsgLayout1 = (BubbleLinearLayout)this.mImOtherContainer.findViewById(R.id.msg_layout_1);
        this.mOtherMsgLayout2 = (BubbleLinearLayout)this.mImOtherContainer.findViewById(R.id.msg_layout_2);
        this.mMyMsgLayout1 = (LinearLayout)this.mImMyContainer.findViewById(R.id.msg_layout_1);
        this.mMyMsgLayout2 = (LinearLayout)this.mImMyContainer.findViewById(R.id.msg_layout_2);
        this.mTvTapContinue = (TextView)this.findViewById(R.id.tv_continue);
        this.mIvLightView = (ImageView)this.findViewById(R.id.iv_game_result_light);
        this.mTvTapContinue.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mTvTapContinue.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GameResult2V2Page.this.mGameResultUICallBacks.continueClick();
                if (GameResult2V2Page.this.mGameResultUICallBacks.getResult() != null && GameResult2V2Page.this.mGameResultUICallBacks.getGameModel() != null) {
                    GameResult2V2Page.this.mGameResultUICallBacks.reportGameResult("tap_to_contine");
                }
            }
        });
        this.mTvTapContinue.setVisibility(8);
        this.mLLTarget = (YYLinearLayout)this.mContent.findViewById(R.id.ll_target);
        this.initMineLayout();
        this.initOtherLayout();
        this.initTarget0Layout();
        this.initTarget1Layout();
        DyResLoader.INSTANCE.loadSvga(this.likeSuccessSVGAImageView, DR.game_like_success, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
            }

            public void onFailed(Exception e) {
            }
        });
    }

    private boolean shouldInterceptActionBeforeTransationViews(Runnable runnable2) {
        if (this.showingTargetUsers) {
            this.showingTargetUsers = false;
            this.dismissingTargetUsers = true;
            this.transViewAnim();
            this.msgRunnables.add(runnable2);
            return true;
        }
        if (this.dismissingTargetUsers) {
            this.msgRunnables.add(runnable2);
            return true;
        }
        return false;
    }

    private void expandViewTouchDelegate(final View view) {
        ((View)view.getParent()).post(new Runnable(){

            @Override
            public void run() {
                Rect bounds = new Rect();
                view.setEnabled(true);
                view.getHitRect(bounds);
                bounds.top = view.getTop() + ResolutionUtils.dip2Px((float)20.0f);
                bounds.bottom = view.getBottom() + ResolutionUtils.dip2Px((float)20.0f);
                bounds.left = view.getLeft() + ResolutionUtils.dip2Px((float)20.0f);
                bounds.right = view.getRight() + ResolutionUtils.dip2Px((float)20.0f);
                TouchDelegate touchDelegate = new TouchDelegate(bounds, view);
                if (View.class.isInstance(view.getParent())) {
                    ((View)view.getParent()).setTouchDelegate(touchDelegate);
                }
            }
        });
    }

    public void initMineLayout() {
        if (this.mContent != null) {
            this.mLayoutMine = (ViewGroup)this.mContent.findViewById(R.id.layout_mine);
            this.mTvMyname = (YYTextView)this.mLayoutMine.findViewById(R.id.tv_user_name);
            this.mTvMyNameGap = this.mLayoutMine.findViewById(R.id.v_gap);
            this.mTvMyNameGap.setVisibility(8);
            this.mImMyHead = (HeadFrameImageView)this.mLayoutMine.findViewById(R.id.img_avtor);
            this.mImMyHead.setPivotX(0.5f);
            this.mImMyHead.setPivotY(0.0f);
            this.ivMineCrown = (RecycleImageView)this.mLayoutMine.findViewById(R.id.iv_crown);
            this.mImgGameLikeMe = (RecycleImageView)this.mLayoutMine.findViewById(R.id.img_like);
            this.myGameEmotionAnimView = (GameEmotionAnimView)this.mLayoutMine.findViewById(R.id.emotion);
            this.mTvMyname.setVisibility(8);
            this.mImgGameLikeMe.setVisibility(8);
            this.tvAnd = (YYTextView)this.mContent.findViewById(R.id.tv_and);
            this.tvAnd.setVisibility(4);
        }
    }

    public void initOtherLayout() {
        if (this.mContent != null) {
            this.mLayoutOther = (ViewGroup)this.mContent.findViewById(R.id.layout_other);
            this.mTvOtherName = (YYTextView)this.mLayoutOther.findViewById(R.id.tv_user_name);
            this.mTvOtherNameGap = this.mLayoutOther.findViewById(R.id.v_gap);
            this.mTvOtherNameGap.setVisibility(8);
            this.mImOtherHead = (HeadFrameImageView)this.mLayoutOther.findViewById(R.id.img_avtor);
            this.mImOtherHead.setPivotX(0.5f);
            this.mImOtherHead.setPivotY(0.0f);
            this.ivOtherCrown = (RecycleImageView)this.mLayoutOther.findViewById(R.id.iv_crown);
            this.mImgGameLikeOther = (RecycleImageView)this.mLayoutOther.findViewById(R.id.iv_btn_like);
            this.friendGameEmotionAnimView = (GameEmotionAnimView)this.mLayoutOther.findViewById(R.id.emotion);
            this.mImgGameLikeOther.setVisibility(0);
            this.mImgGameLikeOther.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GameResult2V2Page.this.mGameResultUICallBacks.likeResult();
                }
            });
            this.mImOtherHead.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("ifield", 1);
                    statContent.put("sfield", GuidFactory.getInstance().getGuid());
                    statContent.put("perftype", "r_head_click");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }
            });
            this.expandViewTouchDelegate((View)this.mImgGameLikeOther);
            this.mOtherMsgLayout1.setArrowTo((View)this.mTvOtherName);
            this.mOtherMsgLayout2.setArrowTo((View)this.mTvOtherName);
            this.mTvOtherName.setVisibility(8);
            this.mImOtherHead.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Object info = GameResult2V2Page.this.mImOtherHead.getTag();
                    if (GameResult2V2Page.this.mGameResultUICallBacks != null && info instanceof UserInfoKS) {
                        GameResult2V2Page.this.mGameResultUICallBacks.showUserProfileCard(((UserInfoKS)info).uid);
                    }
                }
            });
        }
    }

    private void initTarget0Layout() {
        if (this.mContent != null) {
            this.mLayoutTarget0 = (ViewGroup)this.mContent.findViewById(R.id.layout_target0);
            this.mLayoutTarget0.findViewById(R.id.tv_user_name).setVisibility(8);
            this.mLayoutTarget0.findViewById(R.id.img_like).setVisibility(8);
            this.ivTarget0Crown = (RecycleImageView)this.mLayoutTarget0.findViewById(R.id.iv_crown);
            this.targetGameEmotionAnimView0 = (GameEmotionAnimView)this.mLayoutTarget0.findViewById(R.id.emotion);
            this.ivTarget0Crown.setVisibility(8);
            this.mImTargetHead0 = (HeadFrameImageView)this.mLayoutTarget0.findViewById(R.id.img_avtor);
            this.tvVs = (YYTextView)this.mContent.findViewById(R.id.tv_vs);
            FontUtils.setFontType((TextView)this.tvVs, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
            this.mImTargetHead0.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Object info = GameResult2V2Page.this.mImTargetHead0.getTag();
                    if (GameResult2V2Page.this.mGameResultUICallBacks != null && info instanceof UserInfoKS) {
                        GameResult2V2Page.this.mGameResultUICallBacks.showUserProfileCard(((UserInfoKS)info).uid);
                    }
                }
            });
        }
    }

    private void initTarget1Layout() {
        if (this.mContent != null) {
            this.mLayoutTarget1 = (ViewGroup)this.mContent.findViewById(R.id.layout_target1);
            this.mLayoutTarget1.findViewById(R.id.tv_user_name).setVisibility(8);
            this.mLayoutTarget1.findViewById(R.id.img_like).setVisibility(8);
            this.ivTarget1Crown = (RecycleImageView)this.mLayoutTarget1.findViewById(R.id.iv_crown);
            this.targetGameEmotionAnimView1 = (GameEmotionAnimView)this.mLayoutTarget1.findViewById(R.id.emotion);
            this.ivTarget1Crown.setVisibility(8);
            this.mImTargethead1 = (HeadFrameImageView)this.mLayoutTarget1.findViewById(R.id.img_avtor);
            this.mImTargethead1.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Object info = GameResult2V2Page.this.mImTargethead1.getTag();
                    if (GameResult2V2Page.this.mGameResultUICallBacks != null && info instanceof UserInfoKS) {
                        GameResult2V2Page.this.mGameResultUICallBacks.showUserProfileCard(((UserInfoKS)info).uid);
                    }
                }
            });
        }
    }

    private void updateWinView(boolean win) {
        this.ivMineCrown.setVisibility(win ? 0 : 8);
        this.ivOtherCrown.setVisibility(win ? 0 : 8);
        this.ivTarget0Crown.setVisibility(win ? 8 : 0);
        this.ivTarget1Crown.setVisibility(win ? 8 : 0);
        this.mImMyHead.getCircleImageView().setBorderColor(ResourceUtils.getColor((int)R.color.game_head_bg_blue));
        this.mImOtherHead.getCircleImageView().setBorderColor(ResourceUtils.getColor((int)R.color.game_head_bg_blue));
        this.mImTargetHead0.getCircleImageView().setBorderColor(ResourceUtils.getColor((int)R.color.game_head_bg_read));
        this.mImTargethead1.getCircleImageView().setBorderColor(ResourceUtils.getColor((int)R.color.game_head_bg_read));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.updateViewLayout();
    }

    @Override
    public void showLikeGuide() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameResult2V2Page.this.playBtnLikeSvga(DR.game_result_like_guide, true);
            }
        }, (long)300L);
    }

    @Override
    public View getOtherBtnLikeView() {
        return this.mImgGameLikeOther;
    }

    private void updateViewLayout() {
        this.post(new Runnable(){

            @Override
            public void run() {
                int[] location1 = new int[2];
                GameResult2V2Page.this.mImOtherHead.getLocationInWindow(location1);
                int maxWidth = ResolutionUtils.dip2Px((float)150.0f);
                int locationY = location1[1] + GameResult2V2Page.this.mImOtherHead.getHeight() - ResolutionUtils.dip2Px((float)5.0f) + ResolutionUtils.dip2Px((float)25.0f);
                int locationX = ScreenUtils.getInstance().getWidthPixels() - ScreenUtils.getInstance().getWidthPixels() / 2;
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)GameResult2V2Page.this.mImOtherContainer.getLayoutParams();
                params.width = maxWidth;
                params.topMargin = locationY;
                params.leftMargin = locationX;
                params.addRule(9);
                GameResult2V2Page.this.mImOtherContainer.setLayoutParams((ViewGroup.LayoutParams)params);
                int[] location2 = new int[2];
                GameResult2V2Page.this.mImMyHead.getLocationInWindow(location2);
                int maxWidthMy = (location2[0] + GameResult2V2Page.this.mImMyHead.getWidth() / 2 - ResolutionUtils.dip2Px((float)15.0f)) * 2;
                int locationYMy = location2[1] + GameResult2V2Page.this.mImMyHead.getHeight() - ResolutionUtils.dip2Px((float)5.0f) + ResolutionUtils.dip2Px((float)25.0f);
                int locationXMy = ResolutionUtils.dip2Px((float)15.0f);
                RelativeLayout.LayoutParams paramsMy = (RelativeLayout.LayoutParams)GameResult2V2Page.this.mImMyContainer.getLayoutParams();
                paramsMy.width = maxWidthMy;
                paramsMy.topMargin = locationYMy;
                paramsMy.leftMargin = locationXMy;
                GameResult2V2Page.this.mImMyContainer.setLayoutParams((ViewGroup.LayoutParams)paramsMy);
                GameResult2V2Page.this.updateLikeBtnView();
            }
        });
    }

    void updateLikeBtnView() {
        int[] location = new int[2];
        this.mImgGameLikeOther.getLocationInWindow(location);
        int locationX = location[0] - (this.likeSuccessSVGAImageView.getWidth() / 2 - this.mImgGameLikeOther.getWidth() / 2);
        int locationY = location[1] - (this.likeSuccessSVGAImageView.getHeight() - this.mImgGameLikeOther.getHeight() - ResolutionUtils.dip2Px((float)5.0f));
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.likeSuccessSVGAImageView.getLayoutParams();
        int nameWidth = this.mTvOtherName.getWidth();
        params.topMargin = nameWidth > 200 ? locationY - ResolutionUtils.dip2Px((float)9.0f) : locationY - ResolutionUtils.dip2Px((float)10.0f);
        params.leftMargin = locationX;
        this.likeSuccessSVGAImageView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void startLikeAnim() {
        DyResLoader.INSTANCE.loadSvga(this.likeSVGAImageView, DR.game_result_like_full_screen, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                GameResult2V2Page.this.playLikedSvga();
            }

            public void onFailed(Exception e) {
            }
        });
    }

    private void playLikedSvga() {
        if (this.likeSVGAImageView != null) {
            this.likeSVGAImageView.startAnimation();
            this.likeSVGAImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GameResult2V2Page.this.likeSVGAImageView.stopAnimation();
                    GameResult2V2Page.this.likeSVGAImageView.setVisibility(8);
                }
            });
        }
    }

    @Override
    public void showUserLeaveTip(String exitReason) {
    }

    @Override
    public void showLikeTip() {
        this.showLikeTipWindow((View)this.mImgGameLikeOther);
    }

    @Override
    public void showScoreError(int reason) {
    }

    @Override
    public void updateResultBG(GameDef.GameResult result, final boolean showNewResult, final int lastWinCount) {
        int lastStreakWin = this.mGameResultUICallBacks.getLastStreakWincount();
        this.updateWinView(result == GameDef.GameResult.GAME_WIN);
        if (result == GameDef.GameResult.GAME_WIN) {
            if (SettingFlagBaseKeys.enableSvg()) {
                this.backSVGAImageView.setVisibility(0);
                DyResLoader.INSTANCE.loadSvga(this.backSVGAImageView, DR.game_success, new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameResult2V2Page.TAG, (String)"updateResultBG onFinished", (Object[])new Object[0]);
                        }
                        GameResult2V2Page.this.backSVGAImageView.startAnimation();
                    }

                    public void onFailed(Exception e) {
                        MLog.error((Object)GameResult2V2Page.TAG, (String)("updateResultBG error:" + e), (Object[])new Object[0]);
                    }
                });
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (showNewResult && GameResult2V2Page.this.newRegisterGameResult != null) {
                            DResource gameSvga = lastWinCount == 0 ? DR.game_first_win : (lastWinCount == 1 ? DR.game_second_win : DR.game_third_win);
                            DyResLoader.INSTANCE.loadSvga(GameResult2V2Page.this.newRegisterGameResult, gameSvga, new ISvgaLoadCallback(){

                                public void onFinished(SVGAVideoEntity entity) {
                                    if (MLog.isLogLevelBlowInfo()) {
                                        MLog.info((Object)GameResult2V2Page.TAG, (String)"updateResultBG new register onFinished", (Object[])new Object[0]);
                                    }
                                    if (GameResult2V2Page.this.newRegisterGameResult != null && entity != null) {
                                        if (lastWinCount == 0) {
                                            SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
                                            TextPaint textPaint = new TextPaint();
                                            textPaint.setColor(-1);
                                            textPaint.setTypeface(Typeface.create((Typeface)Typeface.SANS_SERIF, (int)1));
                                            textPaint.setTextSize((float)ResolutionUtils.spToPx((float)12.0f));
                                            dynamicEntity.setDynamicText(ResourceUtils.getString((int)R.string.short_tips_first_win), textPaint, "hint");
                                            SVGADrawable drawable2 = new SVGADrawable(entity, dynamicEntity);
                                            GameResult2V2Page.this.newRegisterGameResult.setImageDrawable((Drawable)drawable2);
                                        }
                                        GameResult2V2Page.this.newRegisterGameResult.startAnimation();
                                    }
                                }

                                public void onFailed(Exception e) {
                                    MLog.error((Object)GameResult2V2Page.TAG, (String)("new register err:" + e), (Object[])new Object[0]);
                                }
                            });
                        }
                    }
                }, (long)1000L);
            } else {
                this.backImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.backImageView, (int)R.drawable.game_win);
            }
            if (lastStreakWin >= 1 && !showNewResult) {
                this.ensureStreakwinUi();
                this.streakWinArea.setBackgroundResource(R.drawable.streak_win_bk);
                this.streakWinCount.setVisibility(0);
                this.streakWinCount.setText((CharSequence)String.valueOf(lastStreakWin + 1));
                this.streakWinText.setText(R.string.winning_streak);
            }
        } else if (result == GameDef.GameResult.GAME_LOSE) {
            if (SettingFlagBaseKeys.enableSvg()) {
                this.backSVGAImageView.setVisibility(0);
                DyResLoader.INSTANCE.loadSvga(this.backSVGAImageView, DR.game_fail, new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameResult2V2Page.TAG, (String)"updateResultBG onFinished", (Object[])new Object[0]);
                        }
                        GameResult2V2Page.this.backSVGAImageView.startAnimation();
                    }

                    public void onFailed(Exception e) {
                        MLog.error((Object)GameResult2V2Page.TAG, (Throwable)e);
                    }
                });
                this.newRegisterNotWin(showNewResult, lastWinCount);
            } else {
                this.backImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.backImageView, (int)R.drawable.game_lose);
            }
            if (lastStreakWin > 1 && !showNewResult) {
                this.ensureStreakwinUi();
                this.streakWinArea.setBackgroundResource(R.drawable.streak_lose_bk);
                this.streakWinCount.setVisibility(8);
                this.streakWinText.setText(R.string.losing_streak);
            }
        } else if (result == GameDef.GameResult.GAME_DRAW) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("GAME_DRAW" + String.valueOf(AccountUtil.getUid())), (Object[])new Object[0]);
            }
            if (SettingFlagBaseKeys.enableSvg()) {
                this.backSVGAImageView.setVisibility(0);
                DyResLoader.INSTANCE.loadSvga(this.backSVGAImageView, DR.game_draw, new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameResult2V2Page.TAG, (String)"updateResultBG onFinished", (Object[])new Object[0]);
                        }
                        GameResult2V2Page.this.backSVGAImageView.startAnimation();
                    }

                    public void onFailed(Exception e) {
                        MLog.error((Object)GameResult2V2Page.TAG, (Throwable)e);
                    }
                });
                this.newRegisterNotWin(showNewResult, lastWinCount);
            } else {
                this.backImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.backImageView, (int)R.drawable.game_tie);
            }
            if (!showNewResult && lastStreakWin > 1) {
                this.ensureStreakwinUi();
                this.streakWinArea.setBackgroundResource(R.drawable.streak_lose_bk);
                this.streakWinCount.setVisibility(8);
                this.streakWinText.setText(R.string.losing_streak);
            }
        }
    }

    private void newRegisterNotWin(final boolean showNewResult, final int lastWinCount) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (showNewResult && GameResult2V2Page.this.newRegisterGameResult != null) {
                    DResource gameSvga = lastWinCount == 0 ? DR.game_first_lose : (lastWinCount == 1 ? DR.game_second_lose : DR.game_third_lose);
                    DyResLoader.INSTANCE.loadSvga(GameResult2V2Page.this.newRegisterGameResult, gameSvga, new ISvgaLoadCallback(){

                        public void onFinished(SVGAVideoEntity entity) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)GameResult2V2Page.TAG, (String)"updateResultBG new register onFinished", (Object[])new Object[0]);
                            }
                            if (GameResult2V2Page.this.newRegisterGameResult != null && entity != null) {
                                if (lastWinCount == 0) {
                                    SVGADynamicEntity dynamicEntity = new SVGADynamicEntity();
                                    TextPaint textPaint = new TextPaint();
                                    textPaint.setColor(-1);
                                    textPaint.setTypeface(Typeface.create((Typeface)Typeface.SANS_SERIF, (int)1));
                                    textPaint.setTextSize((float)ResolutionUtils.spToPx((float)12.0f));
                                    dynamicEntity.setDynamicText(ResourceUtils.getString((int)R.string.short_tips_first_lost), textPaint, "hint");
                                    SVGADrawable drawable2 = new SVGADrawable(entity, dynamicEntity);
                                    GameResult2V2Page.this.newRegisterGameResult.setImageDrawable((Drawable)drawable2);
                                }
                                GameResult2V2Page.this.newRegisterGameResult.startAnimation();
                            }
                        }

                        public void onFailed(Exception e) {
                            MLog.error((Object)GameResult2V2Page.TAG, (String)("newRegisterNotWin err:" + e), (Object[])new Object[0]);
                        }
                    });
                }
            }
        }, (long)1000L);
    }

    @Override
    public void updateUserInfo(UserInfoBean myInfo, UserInfoBean otherInfoBean) {
    }

    @Override
    public void update2v2UserInfos(UserInfoKS me, UserInfoKS friends, UserInfoKS other0, UserInfoKS other1) {
        if (me != null) {
            if (this.mTvMyname != null) {
                this.mTvMyname.setText((CharSequence)me.getNick());
            }
            if (this.mImMyHead != null) {
                ImageLoader.loadImage((RecycleImageView)this.mImMyHead.getCircleImageView(), (String)(me.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)me.getSex()));
                this.mImMyHead.setTag((Object)me);
            }
        }
        if (friends != null) {
            if (this.mTvOtherName != null) {
                this.mTvOtherName.setText((CharSequence)friends.getNick());
            }
            if (this.mImOtherHead != null) {
                ImageLoader.loadImage((RecycleImageView)this.mImOtherHead.getCircleImageView(), (String)(friends.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)friends.getSex()));
                this.mImOtherHead.setTag((Object)friends);
            }
        }
        if (other0 != null && this.mImTargetHead0 != null) {
            ImageLoader.loadImage((RecycleImageView)this.mImTargetHead0.getCircleImageView(), (String)(other0.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)other0.getSex()));
            this.mImTargetHead0.setTag((Object)other0);
        }
        if (other1 != null && this.mImTargethead1 != null) {
            ImageLoader.loadImage((RecycleImageView)this.mImTargethead1.getCircleImageView(), (String)(other1.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)other1.getSex()));
            this.mImTargethead1.setTag((Object)other1);
        }
    }

    @Override
    public void showEmoj(EmojiBean emojiBean, int postion) {
        if (postion == 0) {
            if (this.myGameEmotionAnimView != null) {
                this.myGameEmotionAnimView.playEmotion(emojiBean);
            }
        } else if (postion == 1) {
            if (this.friendGameEmotionAnimView != null) {
                this.friendGameEmotionAnimView.playEmotion(emojiBean);
            }
        } else if (postion == 2) {
            if (this.targetGameEmotionAnimView0 != null) {
                this.targetGameEmotionAnimView0.playEmotion(emojiBean);
            }
        } else if (postion == 3 && this.targetGameEmotionAnimView1 != null) {
            this.targetGameEmotionAnimView1.playEmotion(emojiBean);
        }
    }

    @Override
    public void showBarrageView(BarrageInfo barrageInfo) {
    }

    @Override
    public void updateJoinBtn(GameDef.PKGameInviteStatus type) {
        this.btnJoin.setEnabled(true);
        if (this.mGameResultUICallBacks.getIsGuideAi()) {
            this.updateBtnTextFromPlayWithAI();
            return;
        }
        this.btnJoin.setTextSize(2, 20.0f);
        this.mBtnChangeOp.setTextSize(2, 20.0f);
        if (type == GameDef.PKGameInviteStatus.JOIN_GAME) {
            this.btnJoinTmp.setText((CharSequence)ResourceUtils.getString((int)R.string.joingame));
            this.btnJoinTmp.setBackgroundResource(R.drawable.green_round_3);
            this.btnJoinTmp.setVisibility(0);
            ObjectAnimator alphaIn = ObjectAnimator.ofFloat((Object)this.btnJoinTmp, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator alphaOut = ObjectAnimator.ofFloat((Object)this.btnJoin, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            ObjectAnimator scaleYIn = ObjectAnimator.ofFloat((Object)this.btnJoinTmp, (String)"scaleY", (float[])new float[]{0.8f, 1.0f});
            ObjectAnimator scaleYOut = ObjectAnimator.ofFloat((Object)this.btnJoin, (String)"scaleY", (float[])new float[]{1.0f, 0.8f});
            ObjectAnimator scaleXIn = ObjectAnimator.ofFloat((Object)this.btnJoinTmp, (String)"scaleX", (float[])new float[]{0.8f, 1.0f});
            ObjectAnimator scaleXOut = ObjectAnimator.ofFloat((Object)this.btnJoin, (String)"scaleX", (float[])new float[]{1.0f, 0.8f});
            AnimatorSet animSet = new AnimatorSet();
            animSet.play((Animator)alphaIn).with((Animator)alphaOut).with((Animator)scaleYIn).with((Animator)scaleYOut).with((Animator)scaleXIn).with((Animator)scaleXOut);
            animSet.setDuration(150L);
            animSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    GameResult2V2Page.this.btnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.joingame));
                    GameResult2V2Page.this.btnJoin.setBackgroundResource(R.drawable.green_round_3);
                    GameResult2V2Page.this.btnJoin.setScaleX(1.0f);
                    GameResult2V2Page.this.btnJoin.setScaleY(1.0f);
                    GameResult2V2Page.this.btnJoin.setAlpha(1.0f);
                    GameResult2V2Page.this.btnJoinTmp.setVisibility(8);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            animSet.start();
        } else if (type == GameDef.PKGameInviteStatus.JOIN_OTHER_GAME) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)ResourceUtils.getString((int)R.string.join_ohter_game), (Object[])new Object[0]);
            }
            this.btnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.joingame));
            this.btnJoin.setBackgroundResource(R.drawable.green_round_3);
        } else if (type == GameDef.PKGameInviteStatus.PLAY_AGAIN) {
            this.btnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.play_again));
            this.btnJoin.setBackgroundResource(R.drawable.red_round_3_selector);
        } else if (type == GameDef.PKGameInviteStatus.WAIT_OPPOENT) {
            this.stopLightAnim();
            this.btnJoin.setEnabled(false);
            this.btnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.wait_for_oppent));
            this.btnJoin.setBackgroundResource(R.drawable.gary_round_3);
        }
    }

    @Override
    public void updateBtnTextFromPlayWithAI() {
        if (LanguageUtils.isRussian()) {
            this.btnJoin.setTextSize(2, 15.0f);
        } else {
            this.btnJoin.setTextSize(2, 18.0f);
        }
        this.mBtnChangeOp.setTextSize(2, 18.0f);
        this.btnJoin.setText((CharSequence)ResourceUtils.getString((int)R.string.game_result_play_with_real_people));
        this.btnJoin.setBackgroundResource(R.drawable.red_round_3_selector);
        this.mBtnChangeOp.setText((CharSequence)ResourceUtils.getString((int)R.string.game_result_practice_again));
    }

    @Override
    public CharSequence getMsgText(GameDef.PKGameInviteStatus type, String gameName) {
        if (type == GameDef.PKGameInviteStatus.JOIN_GAME) {
            return ResourceUtils.getString((int)R.string.letplayagain);
        }
        if (type == GameDef.PKGameInviteStatus.JOIN_OTHER_GAME) {
            String textStr = "<font color=\"#ffffff\">" + ResourceUtils.getString((int)R.string.play_antnother) + "</font> <font color=\"#fff000\">" + gameName + "</font>";
            return Html.fromHtml((String)textStr);
        }
        if (type == GameDef.PKGameInviteStatus.PLAY_AGAIN) {
            return null;
        }
        if (type == GameDef.PKGameInviteStatus.WAIT_OPPOENT) {
            return ResourceUtils.getString((int)R.string.ready);
        }
        return null;
    }

    @Override
    public void updateLike(boolean isEnable) {
        this.playBtnLikeSvga(DR.game_result_like_pressed, false);
    }

    @Override
    public void updateScoreRank(GameCooperationRank data) {
    }

    @Override
    public void onHidden() {
        if (this.mLikeTipPopupWindow != null) {
            this.mLikeTipPopupWindow.dismiss();
        }
    }

    @Override
    public void updateDoubleScore(int score) {
    }

    @Override
    public void startLightAnim() {
        if (this.mIvLightView != null) {
            this.mIvLightView.setVisibility(0);
        }
        this.startLightAnim((View)this.btnJoin, (View)this.mIvLightView);
    }

    @Override
    public void cancelLightAnim() {
        this.stopLightAnim();
    }

    @Override
    public void resetJoinTips() {
    }

    @Override
    public void showChangeOpponent() {
    }

    @Override
    public void showCoinResult(String tips, GameCoinResult result) {
    }

    @Override
    public void onShow() {
    }

    @Override
    public void updateOtherHeadFrameType(int frame) {
        if (this.mImOtherHead != null) {
            this.mImOtherHead.setHeadFrame(this.mGameResultUICallBacks.getHeadFrameUrl(frame));
        }
    }

    @Override
    public void setBtnDisable() {
        if (this.btnJoin != null) {
            this.btnJoin.setEnabled(false);
        }
    }

    private void startIM1Animator() {
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this.mOtherMsgLayout1, (String)"scaleX", (float[])new float[]{0.0f, 1.3f, 1.0f});
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this.mOtherMsgLayout1, (String)"scaleY", (float[])new float[]{0.0f, 1.3f, 1.0f});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(500L);
        set.playTogether(new Animator[]{animatorX, animatorY});
        set.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animatorX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                GameResult2V2Page.this.mOtherMsgLayout1.invalidate();
            }
        });
        set.start();
    }

    private void startIM2Animator() {
        this.mOtherMsgLayout1.post(new Runnable(){

            @Override
            public void run() {
                int height = GameResult2V2Page.this.mOtherMsgLayout1.getHeight() > 0 ? GameResult2V2Page.this.mOtherMsgLayout1.getHeight() : ResolutionUtils.dip2Px((float)40.0f);
                ObjectAnimator transAnimator = ObjectAnimator.ofFloat((Object)GameResult2V2Page.this.mOtherMsgLayout2, (String)"translationY", (float[])new float[]{0.0f, height});
                ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)GameResult2V2Page.this.mOtherMsgLayout2, (String)"alpha", (float[])new float[]{1.0f, 0.3f});
                AnimatorSet set = new AnimatorSet();
                set.setDuration(300L);
                set.playTogether(new Animator[]{transAnimator, alphaAnimator});
                transAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        GameResult2V2Page.this.mOtherMsgLayout2.invalidate();
                    }
                });
                set.start();
            }
        });
    }

    @Override
    public void onMessageArrived(final LinkedList<GameResultMsgBean> imMessageQueue) {
        if (imMessageQueue == null || imMessageQueue.size() <= 0) {
            return;
        }
        if (this.shouldInterceptActionBeforeTransationViews(new Runnable(){

            @Override
            public void run() {
                GameResult2V2Page.this.onMessageArrived(imMessageQueue);
            }
        })) {
            return;
        }
        this.hideLikeTipWindow();
        if (imMessageQueue.size() == 1) {
            this.mOtherMsgLayout2.setVisibility(8);
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(0);
            if (StringUtils.isNotEmpty((String)gameResultMsgBean.getGameIcon())) {
                this.mOtherImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mOtherImageView, (String)gameResultMsgBean.getGameIcon());
            } else {
                this.mOtherImageView.setVisibility(8);
            }
            if (TextUtils.isEmpty((CharSequence)gameResultMsgBean.getGameIcon())) {
                this.mTvOtherIm1.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(gameResultMsgBean.getContent().toString()));
            } else {
                this.mTvOtherIm1.setText(gameResultMsgBean.getContent());
            }
            this.startIM1Animator();
            this.mOtherMsgLayout1.setVisibility(0);
            int length = gameResultMsgBean.getContent().length();
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mOtherMsgLayout1.getLayoutParams();
            if (length < 5) {
                params.rightMargin = 0;
            }
            this.mOtherMsgLayout1.setLayoutParams((ViewGroup.LayoutParams)params);
        } else if (imMessageQueue.size() == 2) {
            this.mImOtherContainer.setVisibility(0);
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(1);
            if (StringUtils.isNotEmpty((String)gameResultMsgBean.getGameIcon())) {
                this.mOtherImageView.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mOtherImageView, (String)gameResultMsgBean.getGameIcon());
            } else {
                this.mOtherImageView.setVisibility(8);
            }
            if (TextUtils.isEmpty((CharSequence)gameResultMsgBean.getGameIcon())) {
                this.mTvOtherIm1.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(gameResultMsgBean.getContent().toString()));
            } else {
                this.mTvOtherIm1.setText(gameResultMsgBean.getContent());
            }
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mOtherMsgLayout1.getLayoutParams();
            params.rightMargin = gameResultMsgBean.getContent().length() < 5 ? 0 : -ResolutionUtils.dip2Px((float)40.0f);
            this.mOtherMsgLayout1.setLayoutParams((ViewGroup.LayoutParams)params);
            RelativeLayout.LayoutParams secondParams = (RelativeLayout.LayoutParams)this.mOtherMsgLayout2.getLayoutParams();
            secondParams.rightMargin = imMessageQueue.get(0).getContent().length() < 5 ? 0 : -ResolutionUtils.dip2Px((float)40.0f);
            this.mOtherMsgLayout2.setLayoutParams((ViewGroup.LayoutParams)secondParams);
            if (TextUtils.isEmpty((CharSequence)imMessageQueue.get(0).getGameIcon())) {
                this.mOtherImageViewSecond.setVisibility(8);
                this.mTvOtherIm2.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(imMessageQueue.get(0).getContent().toString()));
            } else {
                this.mOtherImageViewSecond.setVisibility(0);
                this.mTvOtherIm2.setText(imMessageQueue.get(0).getContent());
                ImageLoader.loadImage((RecycleImageView)this.mOtherImageViewSecond, (String)imMessageQueue.get(0).getGameIcon());
            }
            this.mOtherMsgLayout1.setVisibility(0);
            this.mOtherMsgLayout2.setVisibility(0);
            this.startIM1Animator();
            this.startIM2Animator();
        }
    }

    private void transViewAnim() {
        int animationTs = 460;
        int screenWidth = ScreenUtils.getInstance().getWidthPixels();
        ObjectAnimator transxAnim = ObjectAnimator.ofFloat((Object)this.mLLTarget, (String)"translationX", (float[])new float[]{0.0f, (float)screenWidth / 2.0f});
        ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)this.mLLTarget, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        transxAnim.setDuration((long)animationTs);
        alphaAnim.setDuration((long)animationTs);
        ObjectAnimator selfAnim = ObjectAnimator.ofFloat((Object)this.mLayoutMine, (String)"translationX", (float[])new float[]{0.0f, ResolutionUtils.dip2Px((float)62.0f)});
        selfAnim.setDuration((long)animationTs);
        ObjectAnimator selfScaleXAnim = ObjectAnimator.ofFloat((Object)this.mImMyHead, (String)"scaleX", (float[])new float[]{1.0f, 1.2f});
        selfScaleXAnim.setDuration((long)animationTs);
        ObjectAnimator selfScaleYAnim = ObjectAnimator.ofFloat((Object)this.mImMyHead, (String)"scaleY", (float[])new float[]{1.0f, 1.2f});
        selfScaleYAnim.setDuration((long)animationTs);
        ObjectAnimator otherAnim = ObjectAnimator.ofFloat((Object)this.mLayoutOther, (String)"translationX", (float[])new float[]{0.0f, ResolutionUtils.dip2Px((float)107.0f)});
        otherAnim.setDuration((long)animationTs);
        ObjectAnimator otherScaleXAnim = ObjectAnimator.ofFloat((Object)this.mImOtherHead, (String)"scaleX", (float[])new float[]{1.0f, 1.2f});
        otherScaleXAnim.setDuration((long)animationTs);
        ObjectAnimator otherScaleYAnim = ObjectAnimator.ofFloat((Object)this.mImOtherHead, (String)"scaleY", (float[])new float[]{1.0f, 1.2f});
        otherScaleYAnim.setDuration((long)animationTs);
        int delay = 160;
        ObjectAnimator andAnim = ObjectAnimator.ofFloat((Object)this.tvAnd, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator myNameAnim = ObjectAnimator.ofFloat((Object)this.mTvMyname, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator otherNameAnim = ObjectAnimator.ofFloat((Object)this.mTvOtherName, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        andAnim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                GameResult2V2Page.this.tvAnd.setVisibility(0);
                GameResult2V2Page.this.mTvMyname.setVisibility(0);
                GameResult2V2Page.this.mTvOtherName.setVisibility(0);
                GameResult2V2Page.this.mTvOtherNameGap.setVisibility(GameResult2V2Page.this.hasLikeOthers ? 8 : 0);
            }

            public void onAnimationEnd(Animator animation) {
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        andAnim.setDuration((long)(animationTs - delay));
        myNameAnim.setDuration((long)(animationTs - delay));
        otherNameAnim.setDuration((long)(animationTs - delay));
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)transxAnim).with((Animator)alphaAnim).with((Animator)selfAnim).with((Animator)otherAnim).after((long)delay).with((Animator)andAnim).with((Animator)myNameAnim).with((Animator)otherNameAnim);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                GameResult2V2Page.this.dismissingTargetUsers = false;
                if (GameResult2V2Page.this.msgRunnables != null && !GameResult2V2Page.this.msgRunnables.isEmpty()) {
                    for (Runnable runnable2 : GameResult2V2Page.this.msgRunnables) {
                        if (runnable2 == null) continue;
                        runnable2.run();
                    }
                    GameResult2V2Page.this.msgRunnables.clear();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        set.start();
    }

    @Override
    public void onMessageSend(LinkedList<GameResultMsgBean> imMessageQueue) {
        if (imMessageQueue.size() == 1) {
            this.mMyMsgLayout2.setVisibility(8);
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(0);
            this.mTvMyIm1.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(gameResultMsgBean.getContent().toString()));
            this.startIM1Animator();
            this.mMyMsgLayout1.setVisibility(0);
        } else if (imMessageQueue.size() == 2) {
            this.mImMyContainer.setVisibility(0);
            GameResultMsgBean gameResultMsgBean = imMessageQueue.get(1);
            this.mTvMyIm1.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(gameResultMsgBean.getContent().toString()));
            this.mTvMyIm2.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(imMessageQueue.get(0).getContent().toString()));
            this.mMyMsgLayout1.setVisibility(0);
            this.mMyMsgLayout2.setVisibility(0);
            this.startIM1Animator();
            this.startIM2Animator();
        }
    }

    @Override
    public void clearMsg(boolean isMe) {
        if (isMe) {
            this.mMyMsgLayout1.setVisibility(8);
            this.mMyMsgLayout2.setVisibility(8);
        } else {
            this.mOtherMsgLayout1.setVisibility(8);
            this.mOtherMsgLayout2.setVisibility(8);
        }
    }

    private void ensureStreakwinUi() {
        ViewStub s;
        if (this.streakWinArea == null && (s = (ViewStub)this.findViewById(R.id.viewstub_streak_win_area)) != null) {
            this.streakWinArea = s.inflate().findViewById(R.id.streak_win_area);
            this.streakWinCount = (TextView)this.streakWinArea.findViewById(R.id.streak_count);
            this.streakWinText = (TextView)this.streakWinArea.findViewById(R.id.streak_text);
        }
    }

    @Override
    public void updateSceneView(int gameScene) {
        if (this.mGameResultUICallBacks.getIsGuideAi()) {
            this.mBtnChangeOp.setVisibility(0);
            this.mTvTapContinue.setVisibility(8);
            return;
        }
        if (gameScene == IGameService.GAME_FROM.FROM_MATCH.value()) {
            this.mBtnChangeOp.setVisibility(0);
        } else {
            this.mBtnChangeOp.setVisibility(0);
        }
    }

    @Override
    public AnimatorSet getPushAnimator(AbstractWindow frontWindow, AbstractWindow backWindow) {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator alphaOut = ObjectAnimator.ofFloat((Object)backWindow, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator scaleYOut = ObjectAnimator.ofFloat((Object)backWindow, (String)"scaleY", (float[])new float[]{1.0f, 1.2f});
        ObjectAnimator scaleXOut = ObjectAnimator.ofFloat((Object)backWindow, (String)"scaleX", (float[])new float[]{1.0f, 1.2f});
        View urer = this.mContent.findViewById(R.id.layout_user);
        View join = this.mContent.findViewById(R.id.btn_join_layout);
        ObjectAnimator alphaIn = ObjectAnimator.ofFloat((Object)frontWindow, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        float move = 160.0f * this.getContext().getResources().getDisplayMetrics().density;
        ObjectAnimator svgaAlphaDown = ObjectAnimator.ofFloat((Object)this.backSVGAImageView, (String)"translationY", (float[])new float[]{-move, 0.0f});
        ObjectAnimator streakWinAreaAlphaDown = ObjectAnimator.ofFloat((Object)this.streakWinArea, (String)"translationY", (float[])new float[]{-move, 0.0f});
        ObjectAnimator urerAlphaDown = ObjectAnimator.ofFloat((Object)urer, (String)"translationY", (float[])new float[]{-move, 0.0f});
        ObjectAnimator btnJoinAlphaUp = ObjectAnimator.ofFloat((Object)join, (String)"translationY", (float[])new float[]{move, 0.0f});
        ObjectAnimator mBtnChangeOpAlphaUp = ObjectAnimator.ofFloat((Object)this.mBtnChangeOp, (String)"translationY", (float[])new float[]{move, 0.0f});
        ObjectAnimator mTvTapContinueAlphaUp = ObjectAnimator.ofFloat((Object)this.mTvTapContinue, (String)"translationY", (float[])new float[]{move, 0.0f});
        ObjectAnimator expressAlphaUp = ObjectAnimator.ofFloat((Object)this.mExpressView, (String)"translationY", (float[])new float[]{move, 0.0f});
        int duration = 240;
        int startDelay = 60;
        alphaOut.setDuration((long)duration);
        scaleYOut.setDuration((long)duration);
        scaleXOut.setDuration((long)duration);
        alphaIn.setDuration((long)duration);
        svgaAlphaDown.setDuration((long)duration).setStartDelay((long)(startDelay * 2));
        streakWinAreaAlphaDown.setDuration((long)duration).setStartDelay((long)startDelay);
        urerAlphaDown.setDuration((long)duration);
        btnJoinAlphaUp.setDuration((long)duration);
        mBtnChangeOpAlphaUp.setDuration((long)duration).setStartDelay((long)startDelay);
        mTvTapContinueAlphaUp.setDuration((long)duration).setStartDelay((long)(startDelay * 2));
        expressAlphaUp.setDuration((long)duration).setStartDelay((long)(startDelay * 2));
        if (this.backSVGAImageView != null) {
            this.backSVGAImageView.setTranslationY(-move);
        }
        if (this.streakWinArea != null) {
            this.streakWinArea.setTranslationY(-move);
        }
        if (this.mBtnChangeOp != null) {
            this.mBtnChangeOp.setTranslationY(move);
        }
        if (this.mTvTapContinue != null) {
            this.mTvTapContinue.setTranslationY(move);
        }
        if (this.mExpressView != null) {
            this.mExpressView.setTranslationY(move);
        }
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.play((Animator)alphaOut).with((Animator)scaleYOut).with((Animator)scaleXOut).with((Animator)alphaIn).with((Animator)urerAlphaDown).with((Animator)btnJoinAlphaUp).with((Animator)streakWinAreaAlphaDown).with((Animator)mBtnChangeOpAlphaUp).with((Animator)svgaAlphaDown).with((Animator)mTvTapContinueAlphaUp).with((Animator)expressAlphaUp);
        return animatorSet;
    }

    @Override
    public void showView(ViewGroup parentView) {
        parentView.addView((View)this);
    }

    @Override
    public void updateScore(int myScore, int otherScore) {
    }
}

