/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.gameresult.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.BubbleTextView;
import com.yy.appbase.ui.widget.bubble.RelativePos;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class BaseResultPager
extends YYRelativeLayout {
    private static final int LIKE_TIP_SHOW_TIME = 5000;
    protected BubblePopupWindow mLikeTipPopupWindow;
    protected BubbleTextView mTvLikeTip;
    private Animation mLightAnim;
    protected SVGAImageView svgaLikeMe;
    protected boolean mIfShowAfter = false;

    public BaseResultPager(Context context) {
        super(context);
        this.initLikeTipWindow();
    }

    public BaseResultPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initLikeTipWindow();
    }

    public BaseResultPager(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initLikeTipWindow();
    }

    protected void showLikeTipWindow(View view) {
        RelativePos relativePos = new RelativePos(0, 0);
        relativePos.setVerticalRelate(2);
        this.mLikeTipPopupWindow.showArrowTo(view, relativePos, 0, 10);
        this.mLikeTipPopupWindow.setCancelOnLater(5000L);
    }

    protected void hideLikeTipWindow() {
        if (this.mLikeTipPopupWindow != null) {
            this.mLikeTipPopupWindow.dismiss();
        }
    }

    private void initLikeTipWindow() {
        View gameResultLikeView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.game_result_like_textview, null);
        this.mTvLikeTip = (BubbleTextView)gameResultLikeView.findViewById(R.id.tv_like_tip);
        this.mTvLikeTip.setFillColor(ResourceUtils.getColor((int)R.color.game_like_pop_color));
        this.mTvLikeTip.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        this.mLikeTipPopupWindow = new BubblePopupWindow(gameResultLikeView, (BubbleStyle)this.mTvLikeTip);
        this.mLikeTipPopupWindow.setCancelOnTouch(false);
        this.mLikeTipPopupWindow.setCancelOnTouchOutside(false);
    }

    protected boolean isLikeTipWindowShow() {
        return this.mLikeTipPopupWindow != null && this.mLikeTipPopupWindow.isShowing();
    }

    protected void startLightAnim(final View targetView, final View lightView) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (targetView == null || lightView == null) {
                    return;
                }
                BaseResultPager.this.initLightAnim(targetView.getMeasuredWidth() + lightView.getMeasuredWidth());
                if (BaseResultPager.this.mLightAnim != null) {
                    lightView.startAnimation(BaseResultPager.this.mLightAnim);
                }
            }
        });
    }

    protected void stopLightAnim() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BaseResultPager.this.mLightAnim != null) {
                    BaseResultPager.this.mLightAnim.cancel();
                }
            }
        });
    }

    protected void playBtnLikeSvga(final DResource resPath, boolean ifShowLikeAfterClick) {
        this.mIfShowAfter = ifShowLikeAfterClick;
        this.initSvgaLike();
        DyResLoader.INSTANCE.loadSvga(this.svgaLikeMe, resPath, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                BaseResultPager.this.svgaLikeMe.setVisibility(0);
                if (BaseResultPager.this.getOtherBtnLikeView() != null) {
                    BaseResultPager.this.getOtherBtnLikeView().setVisibility(8);
                }
                BaseResultPager.this.svgaLikeMe.startAnimation();
                if (resPath == DR.game_result_like_guide) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023779").put("function_id", "like_pop"));
                }
            }

            public void onFailed(Exception e) {
            }
        });
    }

    protected void initSvgaLike() {
        if (this.svgaLikeMe == null) {
            this.svgaLikeMe = new SVGAImageView(this.getContext());
            this.addView((View)this.svgaLikeMe, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(ResolutionUtils.dip2Px((float)80.0f), ResolutionUtils.dip2Px((float)120.0f)));
            int[] likeLocation = new int[2];
            if (this.getOtherBtnLikeView() != null) {
                this.getOtherBtnLikeView().getLocationInWindow(likeLocation);
            }
            this.svgaLikeMe.setTranslationX((float)(likeLocation[0] - (ResolutionUtils.dip2Px((float)80.0f) - ResolutionUtils.dip2Px((float)36.0f)) / 2));
            this.svgaLikeMe.setTranslationY((float)(likeLocation[1] - (ResolutionUtils.dip2Px((float)120.0f) - ResolutionUtils.dip2Px((float)45.0f))));
            this.svgaLikeMe.setCallback(new SVGACallback(){

                public void onPause() {
                }

                public void onFinished() {
                    BaseResultPager.this.svgaLikeMe.setVisibility(8);
                    if (BaseResultPager.this.getOtherBtnLikeView() != null) {
                        BaseResultPager.this.getOtherBtnLikeView().setEnabled(BaseResultPager.this.mIfShowAfter);
                        BaseResultPager.this.getOtherBtnLikeView().setVisibility(BaseResultPager.this.mIfShowAfter ? 0 : 8);
                    }
                }

                public void onRepeat() {
                }

                public void onStep(int i, double v) {
                }
            });
            this.svgaLikeMe.setLoopCount(1);
        }
    }

    public View getOtherBtnLikeView() {
        return null;
    }

    private void initLightAnim(int width) {
        if (this.mLightAnim == null) {
            if (width <= 0) {
                return;
            }
            if (LanguageUtils.isRtl()) {
                width = -width;
            }
            this.mLightAnim = new TranslateAnimation(0.0f, (float)width, 0.0f, 0.0f);
            this.mLightAnim.setFillAfter(false);
            this.mLightAnim.setRepeatCount(-1);
            this.mLightAnim.setDuration(500L);
            this.mLightAnim.setStartOffset(1000L);
        }
    }
}

