/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.gameresult;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.GameResultDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.growth.ExperimentParam;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.growth.IExperimentCallBack;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.like.bean.GameResultLikeBean;
import com.yy.appbase.like.bean.GameResultLikeNotifyBean;
import com.yy.appbase.newuserpath.INewUserService;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.ILikeService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.OnGetHeadFrameCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IProfileOperationCallback;
import com.yy.appbase.service.callback.OnAlbumCallback;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.service.model.RoomUserMicStatus;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.GameCooperationRank;
import com.yy.game.bean.GameDataCenter;
import com.yy.game.bean.GameDataModel;
import com.yy.game.bean.GameResultDb;
import com.yy.game.bean.GameResultMsgBean;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.activity.mpl.MplReporter;
import com.yy.game.gamemodule.pkgame.gameresult.GameResultNotifyService;
import com.yy.game.gamemodule.pkgame.gameresult.GameResultTipsManager;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultUICallbacks;
import com.yy.game.gamemodule.pkgame.gameresult.RequestManager;
import com.yy.game.gamemodule.pkgame.gameresult.coin.CoinGameResultGuidePresenter;
import com.yy.game.gamemodule.pkgame.gameresult.coin.ICoinGameBackGuideCallback;
import com.yy.game.gamemodule.pkgame.gameresult.ui.GameResultWindow;
import com.yy.game.growth.GameExitHelper;
import com.yy.game.growth.GameResultAiData;
import com.yy.game.growth.GameSendAction;
import com.yy.game.module.gameroom.barrageview.IBarrageViewUiCallback;
import com.yy.game.module.gameroom.barrageview.MessageBarrageViewController;
import com.yy.game.module.gameroom.expressionbar.ExpressBarController;
import com.yy.game.module.gameroom.expressionbar.IExpressBarUiCallback;
import com.yy.game.module.gameroom.topbar.ITopBarUiCallback;
import com.yy.game.module.gameroom.topbar.TopBarController;
import com.yy.game.msg.GameMsgDef;
import com.yy.game.msg.OnGameResultShowEvent;
import com.yy.game.utils.Utils;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.BaseGameReqBean;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.GameResultBean;
import com.yy.hiyo.game.base.GameWinDBQueryResult;
import com.yy.hiyo.game.base.IGameMsgListener;
import com.yy.hiyo.game.base.IMGamePkAcceptNotifyBean;
import com.yy.hiyo.game.base.IMGamePkCancelNotifyBean;
import com.yy.hiyo.game.base.IMGamePkNotifyBean;
import com.yy.hiyo.game.base.IMGameReqBean;
import com.yy.hiyo.game.base.IMGameResBean;
import com.yy.hiyo.game.base.IMPKAcceptReqBean;
import com.yy.hiyo.game.base.IMPKAcceptResBean;
import com.yy.hiyo.game.base.SimpleGameResultBean;
import com.yy.hiyo.game.base.bean.CheckGoinConifg;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInviteData;
import com.yy.hiyo.game.base.teamgame.TeamInviteResCodeHelper;
import com.yy.hiyo.game.coins.GameCoinResult;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.IGameMessageService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.Game2V2MatchContext;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.bean.pkgame.PkGamePlayContext;
import com.yy.hiyo.game.service.callback.IIMGameInviteListener;
import com.yy.hiyo.game.service.callback.IIMPKGameListener;
import com.yy.hiyo.game.service.callback.IIMTeamGameListener;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImNotificationBaseDef;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.im.base.ImRecommendGameInfoManager;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.user.base.OpenProfileStatistic;
import com.yy.hiyo.voice.base.roomvoice.AbsVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.IRoomLifeCycleCallback;
import com.yy.hiyo.voice.base.roomvoice.IRoomManagerService;
import com.yy.hiyo.voice.base.roomvoice.RoomSlot;
import com.yy.hiyo.wallet.base.IAdService;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.pkgame.EPkGameIMPkFromType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.ihago.act.api.goldcoingame.GameResultState;
import net.ihago.base.api.accessrecords.EPage;
import net.ihago.channel.srv.teamBattle.TeamNotify;
import net.ihago.channel.srv.teamBattle.Uri;
import net.ihago.money.api.mpl.GetUserVitalityRupeeRes;
import okhttp3.Call;

public class GameResultWindowController
extends DefaultController
implements IGameResultUICallbacks,
IGameMsgListener,
IRoomLifeCycleCallback,
IProfileOperationCallback {
    public static final String TAG = "GameResultWindowController";
    public static final int EMOTION_POSITION_0 = 0;
    public static final int EMOTION_POSITION_1 = 1;
    public static final int EMOTION_POSITION_2 = 2;
    public static final int EMOTION_POSITION_3 = 3;
    private static final int INVITE_TIMER = 30;
    private static final int SHOW_TIP_TIMER = 500;
    public static final long THREE_WIN_ANIMAL_DELAY = 1000L;
    public static final long LOADING_DIALOG_DELAY = 500L;
    private GameResultWindow mGameResultWindow;
    private ExpressBarController mExpressBarController;
    private TopBarController mTopBarController;
    private MessageBarrageViewController mMessageBarrageViewController;
    private int mLeftWinCount;
    private int mRightWinCount;
    private GameDef.GameResult mGameResult;
    private String mSendPkId = "";
    private String mReceivePkId = "";
    private volatile String mGameId = "";
    private LinkedList<GameResultMsgBean> imMessageQueueRecived = new LinkedList();
    private LinkedList<GameResultMsgBean> imMessageQueueSend = new LinkedList();
    private int mMineScore = 0;
    private String mSessionId = "";
    private long mTargetId;
    private GameDataCenter mDataCenter;
    private RoomSlot<AbsVoiceRoom> mRoomSlot;
    private IRoomManagerService mRoomService;
    private int mGameScene = IGameService.GAME_FROM.FROM_IM.value();
    private static final long GUIDE_AI_UID = 900000000L;
    private boolean mIsGuideAi;
    private volatile int mInviteType = 1;
    private boolean mHadSendEmoj;
    private boolean mFromGameHall;
    private static final int RESULT_LOAD_FAIL = -1;
    private static final int RESULT_EXIT = -2;
    private volatile int mMultiMode = 0;
    private UserInfoKS myUserInfo;
    private UserInfoKS friendUserInfo;
    private UserInfoKS otherUserInfo0;
    private UserInfoKS otherUserInfo1;
    private boolean isGoldGame = false;
    private static final int STATE_NONE = 0;
    private static final int STATE_SENDING_INVITE = 1;
    private static final int STATE_SEND_INVITE_SUCCESS = 2;
    private static final int STATE_RECEIVE_INVITE = 3;
    private int mInviteState = 0;
    private boolean isGlodModel = false;
    private boolean mIsOtherLeft;
    private boolean mFirstLose = false;
    private GamePlayContext gameRunningContext;
    private GameResultNotifyService mNotifyService;
    private long mOtherUid = 0L;
    private boolean isReceiveGoldGameInvite;
    private INotifyDispatchService.INotifyHandler mNotifyHandler = new INotifyDispatchService.INotifyHandler<TeamNotify>(){

        public void onHandleNotify(TeamNotify notify) {
            if (notify.uri == Uri.UriExitResultPageNotify && GameResultWindowController.this.gameRunningContext != null && StringUtils.equal((String)notify.exitPage.roomId, (String)GameResultWindowController.this.gameRunningContext.getRoomId()) && GameResultWindowController.this.mTargetId == notify.exitPage.exitUid && GameResultWindowController.this.mFromGameHall) {
                GameResultWindowController.this.mIsOtherLeft = true;
                if (GameResultWindowController.this.mGameResultWindow != null) {
                    GameResultWindowController.this.mGameResultWindow.onOtherLeft(true);
                }
            }
        }
    };
    private IExperimentCallBack mResultAiCallBack = new IExperimentCallBack(){

        public void onNotify(Object param) {
            if (param instanceof GameSendAction) {
                GameSendAction action = (GameSendAction)param;
                if (action.getGiveLike() && GameResultWindowController.this.mGameResultWindow != null) {
                    GameResultWindowController.this.mGameResultWindow.startLikeAnim();
                }
                if (action.getEmojiBean() != null && GameResultWindowController.this.mGameResultWindow != null) {
                    GameResultWindowController.this.mGameResultWindow.showEmoj(action.getEmojiBean(), action.getIndex());
                }
            }
        }
    };
    private Runnable mWinScoreUpdateTask = new Runnable(){

        @Override
        public void run() {
            if (GameResultWindowController.this.mGameResult != null) {
                GameResultAiData data = new GameResultAiData();
                data.setTargetUid(GameResultWindowController.this.mTargetId);
                data.setGameResult(GameResultWindowController.this.mGameResult);
                data.setMyScore(GameResultWindowController.this.mLeftWinCount);
                data.setOtherScore(GameResultWindowController.this.mRightWinCount);
                ExperimentParam param = new ExperimentParam((Object)data, GameResultWindowController.this.mResultAiCallBack);
                MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.GAME_RESULT_AI_SCORE, (Object)param);
            }
        }
    };
    private Runnable mGetCooperationRankRunnable = new Runnable(){

        @Override
        public void run() {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("otherUid", GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo().getUid() + "");
            params.put("gid", GameResultWindowController.this.mDataCenter.getGameModel().getGameInfo().getGid());
            params.put("score", GameResultWindowController.this.mMineScore + "");
            HttpUtil.httpReq((String)UriProvider.getCooperationRank(), params, (int)1, (INetRespCallback)new INetRespCallback<GameCooperationRank>(){

                public void onError(Call call, Exception e, int id2) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameResultWindowController.TAG, (String)("getCooperationRank:\u518d\u6b21\u91cd\u8bd5\u5931\u8d25" + e.toString()), (Object[])new Object[0]);
                    }
                }

                public void onResponse(String response, BaseResponseBean<GameCooperationRank> res, int id2) {
                    if (res.isSuccess() && GameResultWindowController.this.mGameResultWindow != null) {
                        if (((GameCooperationRank)res.data).gid != null && ((GameCooperationRank)res.data).gid.equals(GameResultWindowController.this.mDataCenter.getGameModel().getGameInfo().getGid())) {
                            GameResultWindowController.this.mGameResultWindow.updateScoreRank((GameCooperationRank)res.data);
                        } else if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameResultWindowController.TAG, (String)("\u83b7\u53d6\u5230\u7684\u670d\u52a1\u7aef\u7684gid:" + ((GameCooperationRank)res.data).gid + ", \u5b9e\u9645\u4e0a\u7684gid:" + GameResultWindowController.this.mDataCenter.getGameModel().getGameInfo().getGid()), (Object[])new Object[0]);
                        }
                    }
                }
            });
        }
    };
    private IIMGameInviteListener mImGameInviteListener = new IIMGameInviteListener(){

        public void onGameInviteArrived(GameMessageModel gameMessageModel) {
            if (gameMessageModel != null) {
                long uid = gameMessageModel.getFromUserId();
                if (uid != GameResultWindowController.this.mTargetId) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameResultWindowController.TAG, (String)("\u63a5\u53d7\u5230\u7684PK\u9080\u8bf7\u548c\u5f53\u524d\u7684\u5bf9\u8c61\u4e0d\u662f\u540c\u4e2auid\uff0c\u73b0\u5728\u7684uid:" + GameResultWindowController.this.mTargetId + ", \u63a5\u53d7\u5230\u7684uid:" + uid), (Object[])new Object[0]);
                    }
                    return;
                }
                String gameId = gameMessageModel.getGameId();
                int pkType = gameMessageModel.getType();
                String pkId = gameMessageModel.getPkId();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameResultWindowController.TAG, (String)"\u6536\u5230PK\u9080\u8bf7==>uid=%s, gameId=%s, pkType=%d, pkId=%s", (Object[])new Object[]{uid, gameId, pkType, pkId});
                }
                if (GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo() == null) {
                    MLog.error((Object)GameResultWindowController.TAG, (String)"\u6536\u5230PK\u9080\u8bf7==>otherinfo=null", (Object[])new Object[0]);
                    return;
                }
                GameResultWindowController.this.mInviteType = gameMessageModel.getInviteType();
                GameResultWindowController.this.mMultiMode = gameMessageModel.getGameTemplate();
                GameResultWindowController.this.isReceiveGoldGameInvite = gameMessageModel.isGoldGame();
                if (GameResultWindowController.this.mInviteType == 2) {
                    pkId = gameMessageModel.getTeamId();
                }
                if (pkType == 1 && GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo() != null && uid == GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo().getUid()) {
                    GameResultWindowController.this.onPkCanceled(pkId);
                } else {
                    GameResultWindowController.this.onPkMsgReceived(pkId, gameId, pkType);
                }
            }
        }

        public void onGameInviteIncompatibled() {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameResultWindowController.TAG, (String)"\u6e38\u620f\u4e0d\u517c\u5bb9", (Object[])new Object[0]);
            }
        }
    };
    private Runnable mGameAutoTestRunnable = new Runnable(){

        @Override
        public void run() {
            if (RuntimeContext.sIsDebuggable) {
                GameResultWindowController.this.onPlayGameClicked();
            }
        }
    };
    IIMTeamGameListener mIIMTteamGameListener = new IIMTeamGameListener(){

        public void onTeamGameImInviteSuccessRes(String gameId, String teamId, int gameTemplate) {
        }

        public void onTeamGameImInviteFailRes(long code, String gameId) {
        }

        public void onTeamGameImCancelSuccessRes(String teamId, long targetUid) {
        }

        public void onTeamGameImCancelFailRes(long code) {
        }

        public void onTeamGameImInviteAcceptRes(String gameId, String teamId, boolean accept, int teamTemplete) {
            if (!StringUtils.equal((String)teamId, (String)GameResultWindowController.this.mReceivePkId)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameResultWindowController.TAG, (String)"\u63a5\u53d7\u9080\u8bf7\u8fd4\u56deteamId != \u6536\u5230\u9080\u8bf7teamId", (Object[])new Object[0]);
                }
                return;
            }
            GameResultWindowController.this.onJoinTeamAccept(teamId, gameId, teamTemplete);
            ((IGameInviteService)GameResultWindowController.this.getServiceManager().getService(IGameInviteService.class)).removeGameInvite(teamId);
            GameResultWindowController.this.cancelSendInvite();
        }

        public void onTeamGameImInviteAcceptFailRes(String gameId, String teamId, boolean accept, long code) {
            GameInfo gameInfo;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameResultWindowController.TAG, (String)"onTeamGameImInviteAcceptFailRes gameId=%s, code=%d", (Object[])new Object[]{gameId, code});
            }
            if ((gameInfo = ((IGameInfoService)GameResultWindowController.this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId)) == null) {
                return;
            }
            TeamInviteResCodeHelper.handleResCode((long)code, (Context)GameResultWindowController.this.mContext, (DefaultController)GameResultWindowController.this, (GameInfo)gameInfo);
        }

        public void onTeamGameImAcceptNotify(String gameId, String teamId, int template, boolean isAccept) {
        }
    };
    private IIMPKGameListener mIImpkGameListener = new IIMPKGameListener(){

        public void onPkGameImPkRes(IMGameResBean imGameResBean) {
            GameResultWindowController.this.dismissResultLoading();
            if (GameResultWindowController.this.mGameResultWindow == null) {
                return;
            }
            GameResultWindowController.this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.WAIT_OPPOENT);
            GameResultWindowController.this.mInviteState = 2;
            GameResultWindowController.this.mSendPkId = imGameResBean.getPkId();
            GameInfo gameInfo = ((IGameInfoService)GameResultWindowController.this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(imGameResBean.getGameId());
            if (gameInfo == null) {
                return;
            }
            if (imGameResBean.getCode() == 1011L) {
                GameResultWindowController.this.mSendPkId = "";
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)1);
                if (GameResultWindowController.this.mGameResultWindow != null) {
                    GameResultWindowController.this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.PLAY_AGAIN);
                    GameResultWindowController.this.mInviteState = 0;
                }
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_FULL));
                return;
            }
            if (imGameResBean.getCode() == 1010L) {
                GameResultWindowController.this.mSendPkId = "";
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)1);
                if (GameResultWindowController.this.mGameResultWindow != null) {
                    GameResultWindowController.this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.PLAY_AGAIN);
                    GameResultWindowController.this.mInviteState = 0;
                }
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_MAINTAINING));
                return;
            }
            if (!GameResultWindowController.this.mFromGameHall) {
                ((IGameInviteService)GameResultWindowController.this.getServiceManager().getService(IGameInviteService.class)).addGameInvite(gameInfo, AccountUtil.getUid(), imGameResBean.getTargetUid(), GameResultWindowController.this.mSendPkId, 1, System.currentTimeMillis(), 0, imGameResBean.isGoldGame());
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameResultWindowController.TAG, (String)"\u5f00\u59cb\u53d1\u9001\u9080\u8bf7", (Object[])new Object[0]);
            }
            GameMessageModel model = new GameMessageModel();
            model.setPkId(GameResultWindowController.this.mSendPkId);
            model.setType(0);
            model.setToUserId(imGameResBean.getTargetUid());
            model.setGameId(imGameResBean.getGameId());
            model.setGameName(gameInfo.getGname());
            model.setGameVersion(StringUtils.safeParseInt((String)gameInfo.getModulerVer()));
            model.setInviteType(1);
            model.setGoldGame(imGameResBean.isGoldGame());
            model.setFrom(GameResultWindowController.this.mFromGameHall ? 1 : 0);
            if (GameResultWindowController.this.mDataCenter.getGameModel().getMyUserInfo() != null) {
                model.setFromUserName(GameResultWindowController.this.mDataCenter.getGameModel().getMyUserInfo().getNick());
                model.setFromUserAvatar(GameResultWindowController.this.mDataCenter.getGameModel().getMyUserInfo().getAvatar());
                model.setFromUserSex(GameResultWindowController.this.mDataCenter.getGameModel().getMyUserInfo().getSex());
            }
            YYTaskExecutor.execute(() -> {
                ImMsgReqParam reqParam = ImDataFactory.INSTANCE.sendPkMsg(model);
                if (reqParam != null) {
                    ((ImService)GameResultWindowController.this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(reqParam, null);
                }
            });
            AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent(AppsFlyerEvent.INVITE_GAME_NUM));
            if (!StringUtils.isEmpty((String)GameResultWindowController.this.mSendPkId)) {
                GameResultWindowController.this.startInviteTimer();
            }
        }

        public void onPkAcceptRes(IMPKAcceptResBean imGameResBean) {
            GameResultWindowController.this.onPkAccept(imGameResBean.getPkId(), imGameResBean.getGameId(), imGameResBean.getResource().getUrl(), imGameResBean.getResource().getRoomid(), false, imGameResBean.isGoldGame());
            GameResultWindowController.this.cancelSendInvite();
        }

        public void onPKGameNotify(IMGamePkNotifyBean imGameResBean) {
        }

        public void onPKGameAccptNotify(final IMGamePkAcceptNotifyBean imGameResBean) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GameResultWindowController.this.dismissResultLoading();
                    if (imGameResBean.isAccept()) {
                        GameResultWindowController.this.onPkAccept(imGameResBean.getPkId(), imGameResBean.getGameId(), imGameResBean.getResource().getUrl(), imGameResBean.getResource().getRoomid(), true, imGameResBean.isGoldGame());
                    } else {
                        GameResultWindowController.this.onPkDeclined(imGameResBean.getPkId());
                    }
                }
            });
        }

        public void onPKGameCancelNotify(IMGamePkCancelNotifyBean imGameResBean) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)GameResultWindowController.TAG, (String)"onPKGameCancelNotify", (Object[])new Object[0]);
            }
        }

        public void onPkCancelRes() {
        }

        public void onPkFail(BaseGameReqBean gameReqBean) {
            GameResultWindowController.this.dismissResultLoading();
        }
    };
    private Runnable mInviteTimer = new YYTaskExecutor.RunnableEx(){

        public void run() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GameResultWindowController.this.onPkInviteOverTime();
                }
            });
        }
    };
    GameLifeWrapper mGameLifeWrapper = new GameLifeWrapper(){

        public void onLoadGameFinish(GamePlayContext context, int finishType, DefaultWindow sWindow) {
            if (GameResultWindowController.this.mGameResultWindow != null) {
                GameResultWindow window = GameResultWindowController.this.mGameResultWindow;
                GameResultWindowController.this.mGameResultWindow = null;
                GameResultWindowController.this.mWindowMgr.popWindow(true, (AbstractWindow)window);
            }
        }
    };
    IMatchGameLifecycle iMatchGameLifecycle = new IMatchGameLifecycle(){

        public void prepareGameMatch(GameInfo ginfo, @Nonnull GameMatchContext matchConfig) {
        }

        public void onGameMatchStart(GameInfo info, @Nonnull GameMatchContext matchConfig) {
            GameResultWindowController.this.exitRoom(5);
        }

        public void onMatchFinish(GameInfo gameInfo, @Nonnull GameMatchContext matchContext, int matchType) {
        }
    };
    ProgressDialog mLoadingDialog;
    private final YYTaskExecutor.RunnableEx showLoadingDialog = new YYTaskExecutor.RunnableEx(){

        public void run() {
            if (this.getArg() instanceof Boolean && ((Boolean)this.getArg()).booleanValue()) {
                GameResultWindowController.this.showLoading();
            }
        }
    };
    private ICommonCallback<GameCoinResult> gameCoinResultCallback = new ICommonCallback<GameCoinResult>(){

        public void onSuccess(GameCoinResult gameCoinResult, Object ... ext) {
            if (GameResultWindowController.this.mGameResultWindow != null) {
                GameResultWindowController.this.mGameResultWindow.showCoinResult(ResourceUtils.getString((int)(gameCoinResult.getState() == GameResultState.kStateReachLimit.getValue() ? R.string.tips_up_to_limit : R.string.tips_my_coins)), gameCoinResult);
            }
        }

        public void onFail(int errCode, String msg, Object ... ext) {
        }
    };

    public GameResultWindowController(Environment env) {
        super(env);
        this.mRoomService = (IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class);
        this.mNotifyService = new GameResultNotifyService();
        this.mNotifyService.addHandler(this.mNotifyHandler);
        this.registerMessage(BaseMsgDef.MSG_IF_RECEIVE_GAME_INVITE);
        this.readEmojiData();
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == BaseMsgDef.MSG_IF_RECEIVE_GAME_INVITE) {
            return !this.mFromGameHall;
        }
        return super.handleMessageSync(msg);
    }

    public void initWindow(OnGameResultShowEvent onGameResultShowEvent, boolean hadSendEmoj) {
        boolean finalIsQuitFromAiGame;
        this.mIsOtherLeft = false;
        if (onGameResultShowEvent != null && onGameResultShowEvent.getmGameDataCenter() != null) {
            this.gameRunningContext = onGameResultShowEvent.getmGameDataCenter().getGameRunningContext();
            if (this.gameRunningContext != null) {
                this.isGlodModel = (Boolean)this.gameRunningContext.getExtendValue("isGoldGame", (Object)false);
            }
        }
        if (this.getCurrentWindow() == this.mGameResultWindow) {
            return;
        }
        if (onGameResultShowEvent == null || onGameResultShowEvent.getmGameDataCenter() == null) {
            return;
        }
        this.mHadSendEmoj = hadSendEmoj;
        this.mLeftWinCount = 0;
        this.mRightWinCount = 0;
        this.mDataCenter = onGameResultShowEvent.getmGameDataCenter();
        if (onGameResultShowEvent.getmGameScene() >= 0) {
            this.mGameScene = onGameResultShowEvent.getmGameScene();
        }
        this.mGameResultWindow = new GameResultWindow((Context)this.mContext, (UICallBacks)this, AbstractWindow.WindowLayerType.USE_ALL_LAYER, this.isGlodModel);
        if (this.mDataCenter.getGameModel().getOtherInfo() != null) {
            this.mSessionId = Utils.getSessionId(AccountUtil.getUid(), this.mDataCenter.getGameModel().getOtherInfo().getUid());
            this.mTargetId = this.mDataCenter.getGameModel().getOtherInfo().getUid();
        }
        if (this.mDataCenter.getGameModel().getGameInfo() != null) {
            this.mWindowMgr.pushWindow((AbstractWindow)this.mGameResultWindow, false);
        }
        this.mIsGuideAi = false;
        if (this.mDataCenter.getGameModel().getOtherInfo().getUid() == 900000000L) {
            this.mGameResultWindow.updateBtnTextFromPlayWithAI();
            this.mIsGuideAi = true;
        }
        if (this.gameRunningContext != null) {
            this.mFromGameHall = (Boolean)this.gameRunningContext.getExtendValue("from_game_hall", (Object)false);
            this.mGameResultWindow.updateChangeOption(this.mFromGameHall);
        }
        this.updateGameReuslt(this.mDataCenter.getGameResultBean());
        this.updateUserInfo(onGameResultShowEvent);
        this.getOtherHeadFrameType();
        this.initBtn();
        if (AccountUtil.isLoginByGuest()) {
            this.updatePlayedGameCount();
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameResultWindowController.this.autoPlayGameTest();
            }
        }, (long)5000L);
        ((IHonorService)this.getServiceManager().getService(IHonorService.class)).reportNightCatHonorTask();
        boolean isQuitFromAiGame = false;
        if (this.mDataCenter.getGameResultBean() != null) {
            List uids;
            GameResultTipsManager.Instance.initCondition(this.mGameScene, this.mTargetId, this.mDataCenter.getGameResultBean().isExitFromGame(), this.mDataCenter.getGameModel().getGameInfo().getGameMode());
            boolean isForceExit = this.mDataCenter.getGameResultBean().isExitFromGame();
            if (isForceExit && (uids = this.mDataCenter.getGameResultBean().getUsers()) != null) {
                for (String uid : uids) {
                    long uidLong = StringUtils.safeParseLong((String)uid);
                    if (!SystemUtils.isAI((long)uidLong)) continue;
                    isQuitFromAiGame = true;
                    if (!MLog.isLogLevelBlowInfo()) break;
                    MLog.info((Object)TAG, (String)"is force quit game with ai!!!", (Object[])new Object[0]);
                    break;
                }
            }
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isQuitFromAiGame = %s", (Object[])new Object[]{isQuitFromAiGame});
        }
        long delayMillis = (finalIsQuitFromAiGame = isQuitFromAiGame) ? 0L : 1000L;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameResultWindowController.this.sendMessage(GameMsgDef.MSG_GET_GOLD_GAME_RESULT, finalIsQuitFromAiGame ? 1 : 0, 0, GameResultWindowController.this.gameCoinResultCallback);
            }
        }, (long)delayMillis);
        String mplId = this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString();
        if (StringUtils.isNotEmpty((String)mplId)) {
            MplReporter.INSTANCE.gameResultShow(this.gameRunningContext.getGameInfo().gid, mplId, 1, 0, 0);
        }
        this.handleLikeStatus();
        MsgDispatcher.getInstance().sendMessage(GameMsgDef.GAME_PK_FINISH);
    }

    private void handleLikeStatus() {
        if (this.mFirstLose && this.mGameResultWindow != null) {
            this.mGameResultWindow.showLikeGuide();
        }
    }

    private void getOtherHeadFrameType() {
        if (this.mDataCenter.getGameModel().getGameInfo().getGameMode() == 1 && this.mGameResultWindow != null) {
            ((IHonorService)this.getServiceManager().getService(IHonorService.class)).getSingleHeadFrame(this.mTargetId, new OnGetHeadFrameCallback(){

                public void onGetHeadFrameSuccess(List<Integer> list) {
                    if (list == null || list.isEmpty() || GameResultWindowController.this.mGameResultWindow == null) {
                        return;
                    }
                    GameResultWindowController.this.mGameResultWindow.updateOtherHeadFrameType(list.get(0));
                }

                public void onError(Call call, Exception e, int id2) {
                }

                public void onResponseError(int id2, String message, String response) {
                }
            });
        }
    }

    private void checkInviteStatus() {
        if (this.mTargetId == 0L) {
            return;
        }
        if (this.getServiceManager() != null && this.getServiceManager().getService(IGameInviteService.class) != null) {
            List gameInviteDataList = ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getInviteList(AccountUtil.getUid(), this.mTargetId);
            if (gameInviteDataList == null || gameInviteDataList.size() == 0) {
                return;
            }
            GameInviteData gameInviteData = (GameInviteData)gameInviteDataList.get(gameInviteDataList.size() - 1);
            if (gameInviteData == null) {
                return;
            }
            if (gameInviteData.mState != 2) {
                return;
            }
            if (this.mGameResultWindow != null && gameInviteData.mGameInfo != null) {
                this.onPkMsgReceived(gameInviteData.mPkId, gameInviteData.mGameInfo.getGid(), 0);
            }
        }
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        this.registerMessage(BaseMsgDef.MSG_USER_LEAVE_IM_ROOM);
        NotificationCenter.getGlobalInstance().register(GameNotificationDef.GAME_WIN_COUNT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationBaseDef.IM_RECEIVE_SINGLE_MESSAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationBaseDef.IM_GAME_RESULT_SAY_HELLO, (INotify)this);
        NotificationCenter.getGlobalInstance().register(GameNotificationDef.GAME_RESULT_INSEAT_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(GameNotificationDef.GAME_RESUTL_LIKE_RECIVED, (INotify)this);
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).registerGameMsgListener((IGameMsgListener)this);
        ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getPkGameInviteService().registerPKGameNotify(this.mIImpkGameListener);
        ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).registerGameInviteListener(this.mImGameInviteListener);
        if (this.mDataCenter != null && this.mDataCenter.getGameModel() != null && this.mDataCenter.getGameModel().getOtherInfo() != null) {
            this.mOtherUid = this.mDataCenter.getGameModel().getOtherInfo().getUid();
        }
        this.mRoomSlot = this.mRoomService.joinRoom(this.mSessionId, 2, (IRoomLifeCycleCallback)this);
        this.bindingRoomData(this.mRoomSlot);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameResultWindowController.this.showLikeTip();
                GameResultWindowController.this.showRecommendReason();
            }
        }, (long)500L);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameResultWindowController.this.showLikeTip();
                GameResultWindowController.this.showRecommendReason();
            }
        }, (long)500L);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle((IGameLifecycle)this.mGameLifeWrapper);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameMatchEvent(this.iMatchGameLifecycle);
        if (this.mDataCenter != null && this.mDataCenter.getGameModel() != null && this.mDataCenter.getGameModel().getGameInfo() != null && this.mDataCenter.getGameModel().getGameInfo().getGameMode() == 7) {
            ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).sendJoinRoomReq(this.mDataCenter.getGameModel().getRoomid());
        }
        this.registerOtherLeftNotify();
    }

    private void registerOtherLeftNotify() {
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.mNotifyService);
    }

    private void unregisterOtherLeftNotify() {
        this.mIsOtherLeft = false;
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mNotifyService);
    }

    private void getCooperationRank() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("otherUid", this.mDataCenter.getGameModel().getOtherInfo().getUid() + "");
        params.put("gid", this.mDataCenter.getGameModel().getGameInfo().getGid());
        params.put("score", this.mMineScore + "");
        HttpUtil.httpReq((String)UriProvider.getCooperationRank(), params, (int)1, (INetRespCallback)new INetRespCallback<GameCooperationRank>(){

            public void onError(Call call, Exception e, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameResultWindowController.TAG, (String)("getCooperationRank:" + e.toString()), (Object[])new Object[0]);
                }
                YYTaskExecutor.removeTask((Runnable)GameResultWindowController.this.mGetCooperationRankRunnable);
                YYTaskExecutor.execute((Runnable)GameResultWindowController.this.mGetCooperationRankRunnable, (long)10000L);
            }

            public void onResponse(String response, BaseResponseBean<GameCooperationRank> res, int id2) {
                if (res.isSuccess() && GameResultWindowController.this.mGameResultWindow != null) {
                    if (((GameCooperationRank)res.data).gid != null && ((GameCooperationRank)res.data).gid.equals(GameResultWindowController.this.mDataCenter.getGameModel().getGameInfo().getGid())) {
                        GameResultWindowController.this.mGameResultWindow.updateScoreRank((GameCooperationRank)res.data);
                    } else if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameResultWindowController.TAG, (String)("\u83b7\u53d6\u5230\u7684\u670d\u52a1\u7aef\u7684gid:" + ((GameCooperationRank)res.data).gid + ", \u5b9e\u9645\u4e0a\u7684gid:" + GameResultWindowController.this.mDataCenter.getGameModel().getGameInfo().getGid()), (Object[])new Object[0]);
                    }
                }
            }
        });
    }

    private void bindingRoomData(RoomSlot<AbsVoiceRoom> roomSlot) {
        if (roomSlot != null && roomSlot.room != null) {
            if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"bindingRoomData", (Object[])new Object[0]);
            }
            if (roomSlot.room != null) {
                Kvo.autoBindingTo((KvoSource)roomSlot.room.mMyStatus, (Object)this);
            }
        }
    }

    private void unBindingRoomData(RoomSlot<AbsVoiceRoom> roomSlot) {
        if (roomSlot != null && roomSlot.room != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"unBindingRoomData", (Object[])new Object[0]);
            }
            if (roomSlot.room != null && roomSlot.room instanceof AbsVoiceRoom) {
                Kvo.autoUnbindingFrom((KvoSource)roomSlot.room.mMyStatus, (Object)this);
            }
        }
    }

    @KvoMethodAnnotation(sourceClass=RoomUserMicStatus.class, thread=1, name="micOpen")
    public void onMyMicStatusChange(KvoEventIntent event) {
        RoomUserMicStatus roomUserMicStatus = (RoomUserMicStatus)event.source();
        if (roomUserMicStatus != null) {
            this.getTopBarController().updateMicView(roomUserMicStatus.isMicOpen());
        }
    }

    private void updatePlayedGameCount() {
        long lastTime = SettingFlags.getLongValue((String)"play_game_time");
        if (lastTime <= 0L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"KEY_PLAY_GAME lastTime <= 0", (Object[])new Object[0]);
            }
            SettingFlags.increase((String)"play_game_count");
        } else if (System.currentTimeMillis() - lastTime > 86400000L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"KEY_PLAY_GAME >", (Object[])new Object[0]);
            }
            SettingFlags.increase((String)"play_game_count");
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.MSG_USER_LEAVE_IM_ROOM) {
            // empty if block
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        int id2 = notification.id;
        if (id2 == GameNotificationDef.GAME_WIN_COUNT) {
            if (notification.extObj == null) {
                return;
            }
            GameWinDBQueryResult gameWinDBQueryResult = (GameWinDBQueryResult)notification.extObj;
            if (gameWinDBQueryResult.getGameResultBean() != null && gameWinDBQueryResult.getGameResultBean().getWinners() != null && gameWinDBQueryResult.getGameResultBean().getWinners().contains(String.valueOf(AccountUtil.getUid()))) {
                this.mLeftWinCount = gameWinDBQueryResult.getGameCount();
                if (this.mGameResultWindow != null) {
                    this.mGameResultWindow.updateScore(this.mLeftWinCount, this.mRightWinCount);
                }
            } else {
                this.mRightWinCount = gameWinDBQueryResult.getGameCount();
                if (this.mGameResultWindow != null) {
                    this.mGameResultWindow.updateScore(this.mLeftWinCount, this.mRightWinCount);
                }
            }
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mWinScoreUpdateTask);
            YYTaskExecutor.postToMainThread((Runnable)this.mWinScoreUpdateTask, (long)250L);
        } else if (id2 == ImNotificationBaseDef.IM_GAME_RESULT_SAY_HELLO) {
            if (notification.extObj instanceof Long) {
                this.othersSayHelloToMe((Long)notification.extObj);
            }
        } else if (id2 == ImNotificationBaseDef.IM_RECEIVE_SINGLE_MESSAGE) {
            if (this.mGameResultWindow != null && this.mGameResultWindow.isShown()) {
                List list;
                Object msgs = notification.extObj;
                if (msgs instanceof ImMessageDBBean) {
                    if (((ImMessageDBBean)msgs).getUid() == this.mOtherUid) {
                        this.handleIMMessage((ImMessageDBBean)msgs);
                    }
                } else if (msgs instanceof List && !(list = (List)msgs).isEmpty()) {
                    for (ImMessageDBBean msg : list) {
                        if (msg.getUid() != this.mOtherUid) continue;
                        this.handleIMMessage(msg);
                    }
                }
            }
        } else if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            if (this.mGameResultWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mGameResultWindow);
            }
        } else if (notification.id == GameNotificationDef.GAME_RESULT_INSEAT_SUCCESS) {
            GameResultBean gameResultBean;
            if (notification.extObj instanceof GameResultBean && (gameResultBean = (GameResultBean)notification.extObj).getWinners() != null) {
                GameResultBean.Builder builder = GameResultBean.newBuilder((GameResultBean)gameResultBean);
                builder.winners(gameResultBean.getLosers());
                GameResultBean loseBean = builder.build();
                MyBox myBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(GameResultDBBean.class);
                if (myBox == null) {
                    return;
                }
                GameResultDb.getInstance().queryGameWinCount(gameResultBean, myBox);
                GameResultDb.getInstance().queryGameWinCount(loseBean, myBox);
            }
        } else if (notification.id == GameNotificationDef.GAME_RESUTL_LIKE_RECIVED && notification.extObj instanceof GameResultLikeNotifyBean) {
            GameResultLikeNotifyBean gameResultLikeNotifyBean = (GameResultLikeNotifyBean)notification.extObj;
            if (this.mGameResultWindow != null) {
                this.mGameResultWindow.startLikeAnim();
            }
            TopToastUtils.showToast((CharSequence)gameResultLikeNotifyBean.getText(), (int)0);
            this.reportGameResult("liked");
        }
    }

    private void othersSayHelloToMe(long uid) {
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.othersSayHelloToMe(uid);
        }
    }

    private void handleIMMessage(ImMessageDBBean messageDBBean) {
        UserInfoBean info = this.mDataCenter.getGameModel().getOtherInfo();
        if (info == null) {
            return;
        }
        if (messageDBBean.getMsgType() == 13) {
            return;
        }
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.stopLightAnim();
        }
        if (messageDBBean.getMsgType() == 5) {
            this.onReceiveMsg(GameResultMsgBean.newBuilder().content(messageDBBean.getContent()).build());
        } else if (messageDBBean.getContentType() == 2) {
            this.onReceiveMsg(GameResultMsgBean.newBuilder().content(ResourceUtils.getString((int)R.string.gameresult_photo_im, (Object[])new Object[]{this.getWho(info.getSex())})).msgType(0).build());
        } else if (messageDBBean.getContentType() == 1) {
            this.onReceiveMsg(GameResultMsgBean.newBuilder().content(messageDBBean.getContent()).msgType(0).build());
        }
    }

    private String getWho(int sex) {
        int id2 = sex == 1 ? R.string.he : R.string.she;
        return ResourceUtils.getString((int)id2);
    }

    private void onReceiveMsg(GameResultMsgBean msg) {
        if (msg == null) {
            return;
        }
        this.imMessageQueueRecived.add(msg);
        while (this.imMessageQueueRecived.size() > 2) {
            this.imMessageQueueRecived.poll();
        }
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.onMessageArrived(this.imMessageQueueRecived);
        }
    }

    private void onSendMsg(GameResultMsgBean msg) {
        if (msg == null) {
            return;
        }
        this.imMessageQueueSend.add(msg);
        while (this.imMessageQueueSend.size() > 2) {
            this.imMessageQueueSend.poll();
        }
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.onMessageSend(this.imMessageQueueSend);
        }
    }

    private void clearMsg(boolean isMe) {
        if (isMe) {
            this.imMessageQueueSend.clear();
        } else {
            this.imMessageQueueRecived.clear();
        }
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.clearMsg(isMe);
        }
    }

    private ExpressBarController getExpressBarController() {
        if (this.mExpressBarController == null) {
            this.mExpressBarController = new ExpressBarController(new IExpressBarUiCallback(){

                @Override
                public void onSendEmotionClick(final EmojiBean bean) {
                    GameResultWindowController.this.reportGameResult("emoji_click");
                    MLog.debug((Object)"GameResultAiPresenter", (String)"onSendEmotionClick", (Object[])new Object[0]);
                    if (GameResultWindowController.this.mGameResultWindow != null) {
                        GameResultWindowController.this.mGameResultWindow.showEmoj(bean, 0);
                    }
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (GameResultWindowController.this.mDataCenter.getGameModel().getGameInfo().getGameMode() == 7) {
                                ((IGameMessageService)GameResultWindowController.this.getServiceManager().getService(IGameMessageService.class)).sendMsgReqBroadcast(JsonParser.toJson((Object)bean), GameResultWindowController.this.mDataCenter.getGameModel().getRoomid(), 1L);
                            } else if (GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo() != null) {
                                ((IGameMessageService)GameResultWindowController.this.getServiceManager().getService(IGameMessageService.class)).sendMsgReqUnio(new Gson().toJson((Object)bean, EmojiBean.class), GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo().getUid(), 1L);
                            }
                            if (!GameResultWindowController.this.mHadSendEmoj) {
                                ((IHonorService)GameResultWindowController.this.getServiceManager().getService(IHonorService.class)).reportSendEmojHonorTask();
                                GameResultWindowController.this.mHadSendEmoj = true;
                            }
                        }
                    });
                }
            }, this.getEnvironment());
        }
        return this.mExpressBarController;
    }

    public MessageBarrageViewController getMessageBarrageController() {
        if (this.mMessageBarrageViewController == null) {
            this.mMessageBarrageViewController = new MessageBarrageViewController(new IBarrageViewUiCallback(){

                @Override
                public void onSendMessageBarrage(String barrageMsg) {
                    if (TextUtils.isEmpty((CharSequence)barrageMsg)) {
                        return;
                    }
                    UserInfoBean myUserInfo = GameResultWindowController.this.mDataCenter.getGameModel().getMyUserInfo();
                    UserInfoBean otherUserInfo = GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo();
                    if (myUserInfo != null && otherUserInfo != null) {
                        ((IGameMessageService)GameResultWindowController.this.getServiceManager().getService(IGameMessageService.class)).sendMsgReq(otherUserInfo.getUid(), myUserInfo, barrageMsg);
                    }
                }
            }, this.getEnvironment());
        }
        return this.mMessageBarrageViewController;
    }

    @Override
    public void exitRoom(int type) {
        this.dismissResultLoading();
        String action = this.gameRunningContext.getExtendValue("exitgameAction", (Object)"").toString();
        String gameId = this.gameRunningContext.getExtendValue("sourceGame", (Object)"").toString();
        if (type == 1) {
            if ("back_to_game".equals(action) && StringUtils.isNotEmpty((String)gameId) && !StringUtils.equal((String)gameId, (String)this.gameRunningContext.getGameInfo().gid)) {
                this.gotoOtherGameWindow(gameId);
            } else {
                this.gotoIM(false);
            }
        } else if (type == 4) {
            this.gotoIM(false);
        } else if (type == 3) {
            this.gotoGameWindow();
        } else if (type == 14) {
            this.gotoChannel();
        } else if (type == 15) {
            this.gotoHomeGame();
        } else if (type == 5) {
            this.cancelSendInvite();
            if ("back_to_game".equals(action) && StringUtils.isNotEmpty((String)gameId) && !StringUtils.equal((String)gameId, (String)this.gameRunningContext.getGameInfo().gid)) {
                this.gotoOtherGameWindow(gameId);
            } else if (this.mGameResultWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mGameResultWindow);
            }
        }
    }

    private void gotoHomeGame() {
        if (ServiceManagerProxy.getService(IYYUriService.class) != null) {
            ((IHomeService)ServiceManagerProxy.getService(IHomeService.class)).toGame();
        }
    }

    private void gotoChannel() {
        if (this.mGameResultWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mGameResultWindow);
        }
        String channelId = (String)this.gameRunningContext.getExtendValue("extend_channel_id", (Object)"");
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        EnterParam enterParam = EnterParam.obtain((String)channelId, (int)29);
        Object token = this.gameRunningContext.getExtendValue("KEY_CHANNEL_INVITE_TOKEN", (Object)"");
        if (token instanceof String) {
            enterParam.pwdToken = (String)token;
        }
        enterParam.subPage = this.mFromGameHall ? 1 : 0;
        message.obj = enterParam;
        this.sendMessage(message);
    }

    @Override
    public void onMicClick() {
        if (this.mGameResultWindow != null && this.mGameResultWindow.interceptMicClick()) {
            return;
        }
        if (this.mRoomSlot != null && this.mRoomSlot.room != null) {
            if (!this.mRoomSlot.room.mMyStatus.isMicOpen()) {
                PermissionHelper.requestRecordAudioPermission((Activity)this.mContext, (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        if (GameResultWindowController.this.mRoomSlot != null && ((GameResultWindowController)GameResultWindowController.this).mRoomSlot.room != null) {
                            ((GameResultWindowController)GameResultWindowController.this).mRoomSlot.room.changeMicStatus(!((GameResultWindowController)GameResultWindowController.this).mRoomSlot.room.mMyStatus.isMicOpen());
                        }
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                    }
                });
            } else if (this.mRoomSlot != null && this.mRoomSlot.room != null) {
                this.mRoomSlot.room.changeMicStatus(!this.mRoomSlot.room.mMyStatus.isMicOpen());
            }
        }
    }

    @Override
    public void onBackClick() {
        this.reportGameResult("back_click");
        CoinGameResultGuidePresenter.INSTANCE.checkForCoinGameGuide(this.isGlodModel && this.mGameResult == GameDef.GameResult.GAME_WIN, this.mDialogLinkManager, new ICoinGameBackGuideCallback(){

            @Override
            public void realBackClick() {
                String gid = "";
                if (GameResultWindowController.this.mDataCenter != null && GameResultWindowController.this.mDataCenter.getGameResultBean() != null) {
                    gid = GameResultWindowController.this.mDataCenter.getGameResultBean().getGameID();
                }
                if (StringUtils.isEmpty((String)gid)) {
                    gid = GameResultWindowController.this.mGameId;
                }
                GameExitHelper.INSTANCE.callBeforeExit(gid, false, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

                    public Unit invoke(Boolean needConfirm) {
                        GameResultWindowController.this.handleExitByBackClick();
                        return null;
                    }
                });
            }
        });
    }

    private void handleExitByBackClick() {
        if (this.mGameResultWindow != null && this.mGameResultWindow.interceptBackClick()) {
            return;
        }
        if (this.mIsGuideAi) {
            if (this.mGameScene == IGameService.GAME_FROM.FROM_IM.value()) {
                this.exitRoom(1);
            } else {
                this.exitRoom(5);
            }
            return;
        }
        if (this.mGameScene == GameContextDef.JoinFrom.FROM_HAGO_GROUP.getId()) {
            this.exitRoom(14);
        } else if (StringUtils.isNotEmpty((String)this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString())) {
            this.exitRoom(5);
        } else {
            this.exitRoom(1);
        }
        if (!this.mIsOtherLeft && this.gameRunningContext != null && this.mFromGameHall) {
            RequestManager.INSTANCE.requestLeavePage(AccountUtil.getUid(), this.mTargetId, this.gameRunningContext.getRoomId());
        }
    }

    @Override
    public void onSendEmotionClick(final EmojiBean bean) {
        this.reportGameResult("emoji_click");
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.showEmoj(bean, 0);
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo() != null) {
                    if (GameResultWindowController.this.mDataCenter.getGameModel().getGameInfo().getGameMode() == 7) {
                        ((IGameMessageService)GameResultWindowController.this.getServiceManager().getService(IGameMessageService.class)).sendMsgReqBroadcast(JsonParser.toJson((Object)bean), GameResultWindowController.this.mDataCenter.getGameModel().getRoomid(), 1L);
                    } else {
                        ((IGameMessageService)GameResultWindowController.this.getServiceManager().getService(IGameMessageService.class)).sendMsgReqUnio(new Gson().toJson((Object)bean, EmojiBean.class), GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo().getUid(), 1L);
                    }
                }
                if (!GameResultWindowController.this.mHadSendEmoj) {
                    ((IHonorService)GameResultWindowController.this.getServiceManager().getService(IHonorService.class)).reportSendEmojHonorTask();
                    GameResultWindowController.this.mHadSendEmoj = true;
                }
            }
        });
    }

    void gotoOtherGameWindow(String gameId) {
        String jumpLink = "hago://game/jumpGame?autoMatch=true&gameId=" + gameId + "&openGameSource=7";
        ((IYYUriService)ServiceManagerProxy.getService(IYYUriService.class)).handleUriString(jumpLink);
        if (this.mGameResultWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mGameResultWindow);
        }
    }

    @Override
    public GameModel getGameModel() {
        return this.mDataCenter.getGameModel();
    }

    @Override
    public void onSendMessageBarrage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        UserInfoBean myUserInfo = this.mDataCenter.getGameModel().getMyUserInfo();
        UserInfoBean otherUserInfo = this.mDataCenter.getGameModel().getOtherInfo();
        if (myUserInfo != null && otherUserInfo != null) {
            ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).sendMsgReq(otherUserInfo.getUid(), myUserInfo, message);
        }
    }

    private void gotoIM(boolean isInvitation) {
        this.reportGameResult("enter_im");
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.IM_ROOM_SHOW;
        Bundle bundle = new Bundle();
        UserInfoBean otherUserInfo = this.mDataCenter.getGameModel().getOtherInfo();
        boolean fromShadowAi = false;
        if (otherUserInfo != null) {
            long shadowUid = otherUserInfo.getShadowUid();
            if (shadowUid != 0L) {
                INewUserService newUserService = (INewUserService)ServiceManagerProxy.getService(INewUserService.class);
                IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
                if (userInfoService != null) {
                    ArrayList<Long> uidList = new ArrayList<Long>(2);
                    uidList.add(shadowUid);
                    uidList.add(otherUserInfo.getUid());
                    userInfoService.clearUserCache(uidList);
                }
                if (newUserService != null) {
                    newUserService.onReturnIM(shadowUid, otherUserInfo.getUid());
                }
                bundle.putLong("target_uid", shadowUid);
                fromShadowAi = true;
            } else {
                bundle.putLong("target_uid", otherUserInfo.getUid());
            }
        }
        if (!fromShadowAi) {
            if (this.mDataCenter.getGameModel().getGameInfo() != null) {
                bundle.putString("im_game_id", this.mDataCenter.getGameModel().getGameInfo().getGid());
                bundle.putBoolean("is_pk_game_mode", this.mDataCenter.getGameModel().getGameInfo().getGameMode() == 1);
            }
            bundle.putBoolean("from_pk_game_result_page", true);
            bundle.putBoolean("is_game_win", this.mGameResult == GameDef.GameResult.GAME_WIN);
            bundle.putInt("my_game_result", this.mGameResult == null ? -1 : this.mGameResult.ordinal());
            bundle.putInt("my_win_count", this.mLeftWinCount);
            bundle.putInt("opponent_win_count", this.mRightWinCount);
        }
        if (this.mIsGuideAi && isInvitation) {
            bundle.putBoolean("bundle_ai_guide_invation_game", this.mIsGuideAi);
        }
        bundle.putBoolean("im_room_invation", isInvitation);
        bundle.putInt("bundle_im_from", 4);
        bundle.putInt("im_page_source", 7);
        bundle.putInt("im_page_scene", 1);
        bundle.putBoolean("im_game_panel", true);
        msg.setData(bundle);
        this.sendMessageSync(msg);
        if (this.mGameResultWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mGameResultWindow);
        }
    }

    private void ifNotDownloadGotoIM() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"ifNotDownloadGotoIM mReceivePkId=%s, mGameId=%s", (Object[])new Object[]{this.mReceivePkId, this.mGameId});
        }
        this.reportGameResult("enter_im");
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.IM_ROOM_SHOW;
        Bundle bundle = new Bundle();
        UserInfoBean otherUserInfo = this.mDataCenter.getGameModel().getOtherInfo();
        boolean fromShadowAi = false;
        if (otherUserInfo != null) {
            long shadowUid = otherUserInfo.getShadowUid();
            if (shadowUid != 0L) {
                INewUserService newUserService = (INewUserService)ServiceManagerProxy.getService(INewUserService.class);
                IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
                if (userInfoService != null) {
                    ArrayList<Long> uidList = new ArrayList<Long>(2);
                    uidList.add(shadowUid);
                    uidList.add(otherUserInfo.getUid());
                    userInfoService.clearUserCache(uidList);
                }
                if (newUserService != null) {
                    newUserService.onReturnIM(shadowUid, otherUserInfo.getUid());
                }
                bundle.putLong("target_uid", shadowUid);
                fromShadowAi = true;
            } else {
                bundle.putLong("target_uid", otherUserInfo.getUid());
            }
        }
        bundle.putInt("bundle_im_from", 4);
        bundle.putInt("im_page_source", 7);
        bundle.putInt("im_page_scene", 1);
        if (!fromShadowAi) {
            if (this.mDataCenter.getGameModel().getGameInfo() != null) {
                bundle.putString("im_game_id", this.mGameId);
            }
            GameMessageModel gameMessageModel = new GameMessageModel();
            gameMessageModel.setPkId(this.mReceivePkId);
            gameMessageModel.setGameId(this.mGameId);
            bundle.putSerializable("bundle_im_join_game", (Serializable)gameMessageModel);
        }
        bundle.putBoolean("im_game_panel", true);
        msg.setData(bundle);
        this.sendMessageSync(msg);
        if (this.mGameResultWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mGameResultWindow);
        }
    }

    private void gotoGameWindow() {
        IUserInfoService userInfoService;
        PkGamePlayContext gamePlayContext = new PkGamePlayContext(GameContextDef.JoinFrom.FROM_IM);
        gamePlayContext.setGameUrl(this.mDataCenter.getGameModel().getGameUrl());
        gamePlayContext.setGameInfo(this.mDataCenter.getGameModel().getGameInfo());
        gamePlayContext.setRoomId(this.mDataCenter.getGameModel().getRoomid());
        gamePlayContext.mFrom = this.mGameScene == GameContextDef.JoinFrom.FROM_HAGO_GROUP.getId() ? GameContextDef.JoinFrom.FROM_HAGO_GROUP : GameContextDef.JoinFrom.FROM_IM;
        Object channelId = this.gameRunningContext.getExtendValue("extend_channel_id", null);
        if (channelId != null) {
            gamePlayContext.addExtendValue("extend_channel_id", channelId);
        }
        if ((userInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)) != null) {
            final UserInfoBean lastOtherInfo = this.mDataCenter.getGameModel().getOtherInfo();
            final UserInfoKS self = new UserInfoKS();
            self.uid = AccountUtil.getUid();
            final UserInfoKS other = new UserInfoKS();
            other.uid = lastOtherInfo.getUid();
            other.shadowUid = lastOtherInfo.getShadowUid();
            UserInfoBean myUserInfo = userInfoService.getUserInfo(AccountUtil.getUid(), new OnProfileListCallback(){

                public void onUISuccess(List<UserInfoBean> userInfoList) {
                    if (userInfoList == null) {
                        return;
                    }
                    for (UserInfoBean u : userInfoList) {
                        if (u.getUid() != self.getUid()) continue;
                        self.update(u);
                        break;
                    }
                }

                public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
                }

                public void onResponseError(int id2, @Nullable String message, @Nullable String response) {
                }
            });
            UserInfoBean otherUserInfo = null;
            if (lastOtherInfo.getShadowUid() != 0L) {
                UserInfoBean temp = userInfoService.getUserInfo(lastOtherInfo.getShadowUid(), new OnProfileListCallback(){

                    public void onUISuccess(List<UserInfoBean> userInfoList) {
                        if (userInfoList == null) {
                            return;
                        }
                        for (UserInfoBean u : userInfoList) {
                            if (u.getUid() != lastOtherInfo.getShadowUid()) continue;
                            other.update(u);
                            other.setUid(lastOtherInfo.getUid());
                            other.setShadowUid(lastOtherInfo.getShadowUid());
                            break;
                        }
                    }

                    public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
                    }

                    public void onResponseError(int id2, @Nullable String message, @Nullable String response) {
                    }
                });
                if (temp != null) {
                    otherUserInfo = new UserInfoBean(temp);
                    otherUserInfo.setUid(lastOtherInfo.getUid());
                    otherUserInfo.setShadowUid(lastOtherInfo.getShadowUid());
                }
            } else {
                otherUserInfo = userInfoService.getUserInfo(lastOtherInfo.getUid(), new OnProfileListCallback(){

                    public void onUISuccess(List<UserInfoBean> userInfoList) {
                        if (userInfoList == null) {
                            return;
                        }
                        for (UserInfoBean u : userInfoList) {
                            if (u.getUid() != other.getUid()) continue;
                            other.update(u);
                            break;
                        }
                    }

                    public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
                    }

                    public void onResponseError(int id2, @Nullable String message, @Nullable String response) {
                    }
                });
            }
            if (myUserInfo != null) {
                self.update(myUserInfo);
                gamePlayContext.updateUserInfo(self.uid, self);
            }
            if (otherUserInfo != null) {
                other.update(otherUserInfo);
                gamePlayContext.updateUserInfo(other.uid, other);
            }
        }
        gamePlayContext.addExtendValue("isGoldGame", (Object)this.isGoldGame);
        if (((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(this.mDataCenter.getGameModel().getGameInfo(), (GamePlayContext)gamePlayContext) == 0) {
            if (this.mGameResultWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mGameResultWindow);
            }
        } else {
            this.exitRoom(1);
        }
    }

    @Override
    public View getExpressBarView() {
        return this.getExpressBarController().getExpressBar();
    }

    @Override
    public View getHorExpressBarView() {
        return this.getExpressBarController().getHorExpressBar();
    }

    @Override
    public View getTopBarView() {
        return this.getTopBarController().getTopBar();
    }

    @Override
    public View getMessageBarrageView() {
        return this.getMessageBarrageController().getMessageBarrageView(this.mDataCenter.getGameModel().getGameInfo());
    }

    @Override
    public void onPlayGameClicked() {
        if (!ProtoManager.getInstance().isWSConnected()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onPlayGameClicked web socket disconnect", (Object[])new Object[0]);
            }
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            return;
        }
        if (!RepeatClickUtils.canRepeatClick((String)"gameresult_playAgain", (long)500L)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onPlayGameClicked click too fast", (Object[])new Object[0]);
            }
            return;
        }
        if (StringUtils.isNotEmpty((String)this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString())) {
            GameMatchContext gameMatchContext = new GameMatchContext(GameContextDef.JoinFrom.FROM_PLAY_AGAIN);
            gameMatchContext.addAllExtendValue((Map)this.gameRunningContext.getExtendData());
            ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).matchGame(this.mDataCenter.getGameModel().getGameInfo(), gameMatchContext, null);
            return;
        }
        if (this.mIsGuideAi) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mGameResultWindow);
            GameMatchContext gameMatchContext = new GameMatchContext(GameContextDef.JoinFrom.FROM_PLAY_AGAIN);
            ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).matchGame(this.mDataCenter.getGameModel().getGameInfo(), gameMatchContext, null);
            this.reportGameResult("play_with_real_click");
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onPlayGameClicked==>mSendPkId=%s, mReceivePkId=%s", (Object[])new Object[]{this.mSendPkId, this.mReceivePkId});
        }
        if (this.mInviteState == 1) {
            MLog.error((Object)TAG, (String)"has sending invite!!!", (Object[])new Object[0]);
            return;
        }
        boolean isCurrentCoinGame = false;
        GameInfo ginfo = null;
        if (StringUtils.isEmpty((String)this.mSendPkId) && StringUtils.isEmpty((String)this.mReceivePkId)) {
            Object obj = this.sendMessageSync(GameMsgDef.MSG_IS_GOLD_GAME);
            if (obj instanceof Boolean) {
                isCurrentCoinGame = (Boolean)obj;
            }
            ginfo = this.mDataCenter.getGameModel().getGameInfo();
            this.mInviteState = 1;
        } else {
            isCurrentCoinGame = this.isReceiveGoldGameInvite;
            ginfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.mGameId);
        }
        final boolean finalIsCurrentCoinGame = isCurrentCoinGame;
        final Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (GameResultWindowController.this.mInviteState == 1) {
                    GameResultWindowController.this.clearMsg(true);
                    GameResultWindowController.this.invitePkGame(finalIsCurrentCoinGame);
                    GameResultWindowController.this.reportGameResult("play_again");
                } else if (GameResultWindowController.this.mInviteState == 3) {
                    GameResultWindowController.this.acceptGameInvite(GameResultWindowController.this.mInviteType);
                    GameResultWindowController.this.reportGameResult("join_click");
                } else {
                    MLog.error((Object)GameResultWindowController.TAG, (String)"error state!!!,state:%d, pkId:%s, receiveId:%s", (Object[])new Object[]{GameResultWindowController.this.mInviteState, GameResultWindowController.this.mSendPkId, GameResultWindowController.this.mReceivePkId});
                }
            }
        };
        final GameInfo gameInfo = ginfo;
        if (gameInfo != null && isCurrentCoinGame) {
            this.sendMessage(BaseMsgDef.MSG_CHECK_SELF_COIN_ENOUGH, -1, -1, new CheckGoinConifg((ICommonCallback)new ICommonCallback<CheckGoinConifg>(){

                public void onSuccess(CheckGoinConifg o, Object ... ext) {
                    if (o != null) {
                        if (o.status == 1) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)GameResultWindowController.TAG, (String)"self enough ,check opposite", (Object[])new Object[0]);
                            }
                            long otherUid = 0L;
                            if (GameResultWindowController.this.mDataCenter != null && GameResultWindowController.this.mDataCenter.getGameModel() != null && GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo() != null) {
                                otherUid = GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo().getUid();
                            }
                            if (otherUid == 0L) {
                                if (MLog.isLogLevelBlowInfo()) {
                                    MLog.info((Object)GameResultWindowController.TAG, (String)"uid = 0\uff0cretrurn \uff01\uff01\uff01", (Object[])new Object[0]);
                                }
                                return;
                            }
                            ArrayList<Long> uid = new ArrayList<Long>();
                            uid.add(otherUid);
                            GameResultWindowController.this.sendMessage(GameMsgDef.MSG_CHECK_USER_COINS, -1, -1, new CheckGoinConifg((ICommonCallback)new ICommonCallback<CheckGoinConifg>(){

                                public void onSuccess(CheckGoinConifg checkGoinConifg, Object ... ext) {
                                    if (checkGoinConifg != null) {
                                        if (MLog.isLogLevelBlowInfo()) {
                                            MLog.info((Object)GameResultWindowController.TAG, (String)"check opponent user coins back,status:%d", (Object[])new Object[]{checkGoinConifg.status});
                                        }
                                        if (checkGoinConifg.status == 1) {
                                            runnable2.run();
                                        } else {
                                            GameResultWindowController.this.showCoinToast();
                                            if (GameResultWindowController.this.mInviteState == 1) {
                                                GameResultWindowController.this.mInviteState = 0;
                                            }
                                        }
                                    } else if (GameResultWindowController.this.mInviteState == 1) {
                                        GameResultWindowController.this.mInviteState = 0;
                                    }
                                }

                                public void onFail(int errCode, String msg, Object ... ext) {
                                    if (GameResultWindowController.this.mInviteState == 1) {
                                        GameResultWindowController.this.mInviteState = 0;
                                    }
                                }
                            }, gameInfo, uid));
                        } else if (o.status == 2 && GameResultWindowController.this.mInviteState == 1) {
                            GameResultWindowController.this.mInviteState = 0;
                        }
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameResultWindowController.TAG, (String)"check self coins back,status:%d", (Object[])new Object[]{o.status});
                        }
                    } else if (GameResultWindowController.this.mInviteState == 1) {
                        GameResultWindowController.this.mInviteState = 0;
                    }
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameResultWindowController.TAG, (String)"check self coins back fail!!!,code:%d, msg:%s", (Object[])new Object[]{errCode, msg});
                    }
                    if (GameResultWindowController.this.mInviteState == 1) {
                        GameResultWindowController.this.mInviteState = 0;
                    }
                }
            }, gameInfo, 1));
        } else {
            runnable2.run();
        }
    }

    private void showCoinToast() {
        ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.tips_opponent_coin_not_enought), (int)0);
    }

    private void autoPlayGameTest() {
        boolean isGameAutoOpen;
        boolean isGameFirstPageOpen;
        if (RuntimeContext.sIsDebuggable && (isGameFirstPageOpen = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false)) && this.mGameResultWindow != null) {
            if (this.mDataCenter.getGameModel().getGameInfo() != null) {
                this.mWindowMgr.popWindow(true, (AbstractWindow)this.mGameResultWindow);
                Message message = new Message();
                message.what = BaseMsgDef.MSG_GAME_FIRST_PAGE_AUTO_TEST;
                message.obj = this.mDataCenter.getGameModel().getGameInfo().getGid();
                this.sendMessage(message);
            }
            return;
        }
        if (RuntimeContext.sIsDebuggable && (isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false))) {
            int gameAutoTime = SettingFlags.getIntValue((String)"gameautotime");
            YYTaskExecutor.postToMainThread((Runnable)this.mGameAutoTestRunnable, (long)gameAutoTime);
        }
    }

    @Override
    public void continueClick() {
        this.exitRoom(1);
        this.showFastInputView();
    }

    @Override
    public void changeOneBtnClick() {
        this.exitRoom(5);
    }

    @Override
    public boolean getIsGuideAi() {
        return this.mIsGuideAi;
    }

    @Override
    public void onPracticeAgain() {
        this.gotoIM(true);
        this.reportGameResult("prac_again_click");
    }

    @Override
    public String getHeadFrameUrl(int frame) {
        return ((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame);
    }

    @Override
    public void showUserProfileCard(long uid) {
        this.reportGameResult("photo_click");
        int direction = 1;
        if (this.mDataCenter.getGameModel().getGameInfo().getScreenDire() == 2) {
            direction = 0;
        }
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).showProfileCard((Context)this.mContext, direction, uid, (IProfileOperationCallback)this, true);
        OpenProfileStatistic.INSTANCE.reportFrom(EPage.kEPageGame, uid);
    }

    @Override
    public void clickChangeOpponent() {
        GameLoger.info("pkGame", "clickChangeOpponent", new Object[0]);
        this.cancelSendInvite();
        GameMatchContext matchContext = new GameMatchContext(GameContextDef.JoinFrom.FROM_PK_GAME_RESULT_PAGE);
        GameInfo gameInfo = this.mDataCenter.getGameModel().getGameInfo();
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).matchGame(gameInfo, matchContext, null);
        if (this.isGlodModel) {
            this.reportGameResult("change_match_but_click");
        } else {
            this.reportGameResult("change_match_click");
        }
    }

    @Override
    public GamePlayContext getGamePlayContext() {
        return this.gameRunningContext;
    }

    @Override
    public void getMplRewardLimit(ICommonCallback<GetUserVitalityRupeeRes> callback2) {
        GameDataModel.instance.getMplRewardLimit(this.gameRunningContext.getGameInfo().gid, callback2);
    }

    @Override
    public void sayHello() {
        ((ImService)this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(ImDataFactory.INSTANCE.gameResultSayHelloMsg(this.mTargetId), null);
        this.exitRoom(4);
    }

    @Override
    public void getOthersUserAlbum(long uid) {
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getAlbum(uid, new OnAlbumCallback(){

            public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
            }

            public void onResponseError(int id2, @Nullable String message, @Nullable String response) {
            }

            public void onUISuccess(List<String> list, long uid) {
                GameResultWindowController.this.updateOthersAlbum(list);
            }
        });
    }

    private void updateOthersAlbum(@Nullable List<String> list) {
        if (this.mGameResultWindow != null && !FP.empty(list) && this.mDataCenter.getGameModel().getOtherInfo() != null) {
            this.mDataCenter.getGameModel().getOtherInfo().setAlbum(list);
            this.mGameResultWindow.updateOthersAlbum(this.mDataCenter.getGameModel().getOtherInfo());
        }
    }

    private void showFastInputView() {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.IM_FAST_INPUT_SHOW_FROM_MORE_GAME;
        this.sendMessageSync(msg);
    }

    @Override
    public void updateGameReuslt(GameResultBean gameResultBean) {
        if (gameResultBean == null || StringUtils.isEmpty((String)gameResultBean.getGameID())) {
            this.exitRoom(1);
            return;
        }
        if (this.mDataCenter.getGameModel().getGameInfo() == null || this.mDataCenter.getGameModel().getMyUserInfo() == null || this.mDataCenter.getGameModel().getOtherInfo() == null) {
            return;
        }
        if (this.mGameResultWindow != null && this.mDataCenter.getGameResultBean() != null) {
            String exitReason = this.mDataCenter.getGameResultBean().getExitReason();
            this.mGameResultWindow.showUserLeaveTip(exitReason);
        }
        if (this.mDataCenter.getGameModel().getGameInfo().getGameMode() == 5) {
            List scoreList = gameResultBean.getScore();
            if (scoreList != null && scoreList.size() > 1) {
                if (this.mGameResultWindow != null) {
                    this.mMineScore = Integer.parseInt((String)scoreList.get(0));
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"updateGameResult:notify:%s", (Object[])new Object[]{this.mMineScore});
                    }
                    this.mGameResultWindow.updateDoubleScore(this.mMineScore);
                }
            } else if (this.mGameResultWindow != null) {
                if (gameResultBean.isExitFromGame()) {
                    this.mGameResultWindow.showScoreError(-2);
                } else {
                    this.mGameResultWindow.showScoreError(-1);
                }
            }
            if (this.mGameResultWindow != null) {
                this.mGameResultWindow.resetJoinTips();
            }
            if (this.mMineScore == 0) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("\u53cc\u4eba\u5408\u4f5c\u6e38\u620f:gameId:" + this.mDataCenter.getGameModel().getGameInfo().getGid() + "\uff0c\u5206\u6570\u4e3a0"), (Object[])new Object[0]);
                }
                return;
            }
            this.getCooperationRank();
            return;
        }
        int lastWinCount = (Integer)this.sendMessageSync(GameMsgDef.NEW_REGISTER_LAST_WIN_COUNT);
        boolean needShowNewUserGameResult = (Boolean)this.sendMessageSync(GameMsgDef.NEW_REGISTER_NEED_SHOW_GAME_RESULT);
        if (gameResultBean.isDraw()) {
            this.mGameResult = GameDef.GameResult.GAME_DRAW;
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("isDraw_uid" + String.valueOf(AccountUtil.getUid())), (Object[])new Object[0]);
            }
            GameDataModel.putGame_lose_count(this.mDataCenter.getGameModel().getGameInfo().getGid(), 0);
            if (this.mGameResultWindow != null) {
                this.mGameResultWindow.updateResultBG(GameDef.GameResult.GAME_DRAW, needShowNewUserGameResult, lastWinCount);
            }
            GameResultTipsManager.Instance.setGameResult(GameDef.GameResult.GAME_DRAW);
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_RESULT, (Object)new SimpleGameResultBean(GameDef.GameResult.GAME_DRAW, gameResultBean.getGameID(), this.gameRunningContext.mFrom)));
            List<String> my = Collections.singletonList(String.valueOf(this.mDataCenter.getGameModel().getMyUserInfo().getUid()));
            List<String> other = Collections.singletonList(String.valueOf(this.mDataCenter.getGameModel().getOtherInfo().getUid()));
            GameResultBean.Builder builder = GameResultBean.newBuilder();
            builder.users(gameResultBean.getUsers());
            builder.winners(my);
            MyBox myBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(GameResultDBBean.class);
            if (myBox == null) {
                return;
            }
            GameResultDb.getInstance().queryGameWinCount(builder.build(), myBox);
            builder.winners(other);
            GameResultDb.getInstance().queryGameWinCount(builder.build(), myBox);
            ((IAdService)this.getServiceManager().getService(IAdService.class)).setGameWinStreakTime(this.getLastStreakWincount());
        } else if (gameResultBean.getWinners().contains(String.valueOf(AccountUtil.getUid()))) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("GAME_WIN" + String.valueOf(AccountUtil.getUid())), (Object[])new Object[0]);
            }
            this.mGameResult = GameDef.GameResult.GAME_WIN;
            if (this.mGameResultWindow != null) {
                this.mGameResultWindow.updateResultBG(GameDef.GameResult.GAME_WIN, needShowNewUserGameResult, lastWinCount);
            }
            GameResultTipsManager.Instance.setGameResult(GameDef.GameResult.GAME_WIN);
            if (needShowNewUserGameResult) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027939").put("function_id", "get_crow").put("crow_num", String.valueOf(lastWinCount + 1)));
            }
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_RESULT, (Object)new SimpleGameResultBean(GameDef.GameResult.GAME_WIN, gameResultBean.getGameID(), this.gameRunningContext.mFrom)));
            GameDataModel.putGame_lose_count(this.mDataCenter.getGameModel().getGameInfo().getGid(), 0);
            this.sendMessageSync(GameMsgDef.NEW_REGISTER_INCREASE_WIN_COUNT);
            ((IAdService)this.getServiceManager().getService(IAdService.class)).setGameWinStreakTime(this.getLastStreakWincount() + 1);
        } else {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("GAME_LOSE" + gameResultBean.getLosers()), (Object[])new Object[0]);
            }
            this.mGameResult = GameDef.GameResult.GAME_LOSE;
            if (GameDataModel.getGame_lose_count().get(this.mDataCenter.getGameModel().getGameInfo().getGid()) != null) {
                int count = GameDataModel.getGame_lose_count().get(this.mDataCenter.getGameModel().getGameInfo().getGid());
                GameDataModel.putGame_lose_count(this.mDataCenter.getGameModel().getGameInfo().getGid(), ++count);
            } else {
                GameDataModel.putGame_lose_count(this.mDataCenter.getGameModel().getGameInfo().getGid(), 1);
            }
            if (this.mGameResultWindow != null) {
                this.mGameResultWindow.updateResultBG(GameDef.GameResult.GAME_LOSE, needShowNewUserGameResult, lastWinCount);
            }
            GameResultTipsManager.Instance.setGameResult(GameDef.GameResult.GAME_LOSE);
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_RESULT, (Object)new SimpleGameResultBean(GameDef.GameResult.GAME_LOSE, gameResultBean.getGameID(), this.gameRunningContext.mFrom)));
            ((IAdService)this.getServiceManager().getService(IAdService.class)).setGameWinStreakTime(0);
        }
        if (gameResultBean.getWinners() != null) {
            GameResultBean.Builder builder = GameResultBean.newBuilder((GameResultBean)gameResultBean);
            builder.winners(gameResultBean.getLosers());
            GameResultBean loseBean = builder.build();
            MyBox myBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(GameResultDBBean.class);
            if (myBox == null) {
                return;
            }
            GameResultDb.getInstance().queryGameWinCount(gameResultBean, myBox);
            GameResultDb.getInstance().queryGameWinCount(loseBean, myBox);
        }
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.resetJoinTips();
        }
        if (StringUtils.isNotEmpty((String)this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString())) {
            int result = -1;
            result = this.mGameResult == GameDef.GameResult.GAME_WIN ? 0 : (this.mGameResult == GameDef.GameResult.GAME_LOSE ? 2 : 1);
            this.mGameResultWindow.initForMpl(result);
        }
        this.mFirstLose = !this.mFirstLose && this.mGameResult != GameDef.GameResult.GAME_WIN;
        CoinGameResultGuidePresenter.INSTANCE.requestCoinActivities();
    }

    private void updateUserInfo(OnGameResultShowEvent event) {
        if (this.mDataCenter.getGameModel().getMyUserInfo() != null && this.mDataCenter.getGameModel().getOtherInfo() != null && this.mGameResultWindow != null) {
            this.mGameResultWindow.updateUserInfo(this.mDataCenter.getGameModel().getMyUserInfo(), this.mDataCenter.getGameModel().getOtherInfo());
        }
        if (event != null && this.mGameResultWindow != null) {
            this.myUserInfo = event.getMe();
            this.friendUserInfo = event.getFriend();
            this.otherUserInfo0 = event.getOther0();
            this.otherUserInfo1 = event.getOther1();
            this.mGameResultWindow.update2v2UserInfos(this.myUserInfo, this.friendUserInfo, this.otherUserInfo0, this.otherUserInfo1);
        }
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.updateSceneView(this.mGameScene);
        }
    }

    @Override
    public void acceptGameInvite(int inviteType) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"acceptGameInvite==>mReceivePkId=%s", (Object[])new Object[]{this.mReceivePkId});
        }
        if (this.mDataCenter.getGameModel().getMyUserInfo() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"acceptGameInvite==>getMyUserInfo=null", (Object[])new Object[0]);
            }
            return;
        }
        IGameService iGameService = (IGameService)this.getServiceManager().getService(IGameService.class);
        if (iGameService == null) {
            return;
        }
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.mGameId);
        if (gameInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"acceptGameInvite,gameinfo = null", (Object[])new Object[0]);
            }
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.game_info_error), (int)0);
            return;
        }
        boolean isGameValid = iGameService.isGameValid(gameInfo);
        if (!isGameValid) {
            this.ifNotDownloadGotoIM();
            gameInfo.downloadInfo.setFrom(GameDownloadInfo.DownloadFrom.im);
            iGameService.downloadGame(gameInfo);
            return;
        }
        if (StringUtils.isEmpty((String)this.mReceivePkId)) {
            if (!TextUtils.isEmpty((CharSequence)this.mSendPkId)) {
                this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.WAIT_OPPOENT);
                this.mInviteState = 2;
            } else {
                this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.PLAY_AGAIN);
                this.mInviteState = 0;
            }
            return;
        }
        if (inviteType == 2) {
            if (this.mDataCenter.getGameModel().getOtherInfo() == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"acceptGameInvite,getOtherInfo = null", (Object[])new Object[0]);
                }
                ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.user_info_get_error), (int)0);
                return;
            }
            ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getGameTeamInviteService().teamImInviteAccept(this.mGameId, this.mMultiMode, this.mReceivePkId, true, this.mDataCenter.getGameModel().getOtherInfo().getUid(), this.mIIMTteamGameListener);
        } else {
            IMPKAcceptReqBean.Builder builder = IMPKAcceptReqBean.newBuilder();
            IMPKAcceptReqBean bean = builder.my_nick(this.mDataCenter.getGameModel().getMyUserInfo().getNick()).my_pic_url(this.mDataCenter.getGameModel().getMyUserInfo().getAvatar()).my_sex(this.mDataCenter.getGameModel().getMyUserInfo().getSex()).pk_id(this.mReceivePkId).gameVersion(gameInfo.getModulerVer()).accept(true).build();
            this.showResultLoading();
            if (this.mGameResultWindow != null) {
                this.mGameResultWindow.setBtnDisable();
            }
            ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getPkGameInviteService().pkGameImPkAcceptReq(bean, this.mIImpkGameListener);
        }
    }

    private void invitePkGame(boolean isGoldGameInvite) {
        if (this.mDataCenter != null && this.mDataCenter.getGameModel().getGameInfo() != null && this.mDataCenter.getGameModel().getOtherInfo() != null && this.mGameResultWindow != null) {
            GameInfo gameInfo = this.mDataCenter.getGameModel().getGameInfo();
            IGameService iGameService = (IGameService)this.getServiceManager().getService(IGameService.class);
            if (iGameService == null) {
                return;
            }
            boolean isGameValid = iGameService.isGameValid(gameInfo);
            if (!isGameValid) {
                this.ifNotDownloadGotoIM();
                gameInfo.downloadInfo.setFrom(GameDownloadInfo.DownloadFrom.im);
                iGameService.downloadGame(gameInfo);
                return;
            }
            UserInfoKS userInfoKS = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
            IMGameReqBean imGameReqBean = IMGameReqBean.newBuilder().gameId(gameInfo.getGid()).myNick(userInfoKS.getNick()).myPicUrl(userInfoKS.getAvatar()).mySex(userInfoKS.getSex()).targetUid(this.mDataCenter.getGameModel().getOtherInfo().getUid()).gameVerion(gameInfo.getModulerVer()).isGoldGame(isGoldGameInvite).fromType((long)EPkGameIMPkFromType.EPkGameIMPkFromTypeResult.getValue()).build();
            this.showResultLoading();
            this.onSendMsg(GameResultMsgBean.newBuilder().content(this.mGameResultWindow.getMsgText(GameDef.PKGameInviteStatus.WAIT_OPPOENT, "")).build());
            ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getPkGameInviteService().pkGameReq(imGameReqBean, this.mIImpkGameListener);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042069").put("function_id", "start_game_invite_click").put("gid", gameInfo.gid).put("invite_source", "2").put("invite_type", "1"));
        }
    }

    @Override
    public int getLastStreakWincount() {
        if (GameDataModel.instance.getWinStreakData() != null) {
            return GameDataModel.instance.getWinStreakData().win_streak_count.intValue();
        }
        return 0;
    }

    @Override
    public GameResultBean getResult() {
        return this.mDataCenter.getGameResultBean();
    }

    @Override
    public void reportGameResult(String functionId) {
        if (this.getGameModel().getGameInfo() == null) {
            return;
        }
        HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20023779").put("function_id", functionId).put("roomid", this.getGameModel().getRoomid()).put("gid", this.getGameModel().getGameInfo().getGid());
        if (this.mGameScene == IGameService.GAME_FROM.FROM_MATCH.value()) {
            hiidoEvent.put("soure_id", String.valueOf(1));
        } else {
            hiidoEvent.put("soure_id", String.valueOf(2));
        }
        int gameMode = 0;
        gameMode = this.getGameModel().getGameInfo().getGameMode() == 5 ? 3 : (this.getGameModel().getGameInfo().getGameMode() == 1 ? 2 : 1);
        hiidoEvent.put("result_page_type", String.valueOf(gameMode));
        if (!StringUtils.isEmpty((String)ImRecommendGameInfoManager.INSTANCE.getMatchReason())) {
            hiidoEvent.put("reason_type", String.valueOf(ImRecommendGameInfoManager.INSTANCE.getMatchReasonType()));
        }
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
    }

    private TopBarController getTopBarController() {
        if (this.mTopBarController == null) {
            this.mTopBarController = new TopBarController(new ITopBarUiCallback(){

                @Override
                public void onBackClick() {
                    GameResultWindowController.this.onBackClick();
                }

                @Override
                public void onMicClick() {
                    GameResultWindowController.this.onMicClick();
                }

                @Override
                public void onUserClick(long uid) {
                }
            }, this.getEnvironment());
        }
        return this.mTopBarController;
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onWindowShown", (Object[])new Object[0]);
        }
        this.changeScreenOrientation();
        this.reportGameResult("show");
        this.checkInviteStatus();
        this.sendGameInvite();
        ((IAdService)this.getServiceManager().getService(IAdService.class)).cacheAd(300, null);
    }

    private void sendGameInvite() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String gameInviteTips = GameResultTipsManager.Instance.getGameInviteTips();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameResultWindowController.TAG, (String)"\u83b7\u53d6\u5230\u7684\u9080\u8bf7\u6587\u6848:%s", (Object[])new Object[]{gameInviteTips});
                }
                if (!TextUtils.isEmpty((CharSequence)gameInviteTips)) {
                    GameResultWindowController.this.reportGameResult("play_again_pop");
                    GameResultWindowController.this.onReceiveMsg(GameResultMsgBean.newBuilder().content(gameInviteTips).build());
                    if (GameResultWindowController.this.mGameResultWindow != null) {
                        GameResultWindowController.this.mGameResultWindow.startLightAnim();
                    }
                }
            }
        }, (long)2000L);
    }

    private void changeScreenOrientation() {
        if (this.mDataCenter.getGameModel() == null || this.mGameResultWindow == null) {
            return;
        }
        if (this.mDataCenter.getGameModel().getGameInfo() == null) {
            return;
        }
        if (this.mDataCenter.getGameModel().getGameInfo().getScreenDire() == 2) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u5207\u6362\u6210\u6a2a\u5c4f", (Object[])new Object[0]);
            }
            this.mGameResultWindow.setScreenOrientationType(0);
        } else if (this.mDataCenter.getGameModel().getGameInfo().getScreenDire() == 1) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u5207\u6362\u6210\u7ad6\u5c4f", (Object[])new Object[0]);
            }
            this.mGameResultWindow.setScreenOrientationType(3);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IHonorService)GameResultWindowController.this.getServiceManager().getService(IHonorService.class)).enterFocusWindow();
            }
        }, (long)500L);
    }

    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        boolean retVal = false;
        if (keyCode == 4 && event.getAction() == 1) {
            this.onBackClick();
            return true;
        }
        return retVal;
    }

    public void onExpressNotify(final long senderUid, final String value) {
        try {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (GameResultWindowController.this.mDataCenter != null && GameResultWindowController.this.mDataCenter.getGameModel() != null && GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo() != null && senderUid == GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo().getUid()) {
                        final EmojiBean emojiBean = (EmojiBean)JsonParser.parseJsonObject((String)value, EmojiBean.class);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (GameResultWindowController.this.mGameResultWindow != null) {
                                    GameResultWindowController.this.mGameResultWindow.showEmoj(emojiBean, 1);
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void onExpressBrocstNotify(String barcastId, final long uid, final String value) {
        try {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    final EmojiBean emojiBean = (EmojiBean)JsonParser.parseJsonObject((String)value, EmojiBean.class);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (GameResultWindowController.this.mGameResultWindow != null) {
                                if (GameResultWindowController.this.myUserInfo != null && ((GameResultWindowController)GameResultWindowController.this).myUserInfo.uid == uid) {
                                    GameResultWindowController.this.mGameResultWindow.showEmoj(emojiBean, 0);
                                } else if (GameResultWindowController.this.friendUserInfo != null && ((GameResultWindowController)GameResultWindowController.this).friendUserInfo.uid == uid) {
                                    GameResultWindowController.this.mGameResultWindow.showEmoj(emojiBean, 1);
                                } else if (GameResultWindowController.this.otherUserInfo0 != null && ((GameResultWindowController)GameResultWindowController.this).otherUserInfo0.uid == uid) {
                                    GameResultWindowController.this.mGameResultWindow.showEmoj(emojiBean, 2);
                                } else if (GameResultWindowController.this.otherUserInfo1 != null && ((GameResultWindowController)GameResultWindowController.this).otherUserInfo1.uid == uid) {
                                    GameResultWindowController.this.mGameResultWindow.showEmoj(emojiBean, 3);
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void onSendMsgRes() {
    }

    public void onJoinRoomSuccess() {
    }

    public void onJoinRoomFail(long code) {
    }

    public void onBarrageNotify(final BarrageInfo barrageInfo, final String id2, final int type) {
        try {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (type == 1 ? !TextUtils.isEmpty((CharSequence)id2) && !TextUtils.isEmpty((CharSequence)GameResultWindowController.this.mDataCenter.getGameModel().getRoomid()) && !id2.equals(GameResultWindowController.this.mDataCenter.getGameModel().getRoomid()) : type == 0 && !TextUtils.isEmpty((CharSequence)id2) && GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo() != null && !id2.equals(String.valueOf(GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo().getUid()))) {
                        return;
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (GameResultWindowController.this.mGameResultWindow != null) {
                                GameResultWindowController.this.mGameResultWindow.showBarrageView(barrageInfo);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.imMessageQueueRecived.clear();
        this.stopInviteTimer();
        this.dismissResultLoading();
        this.mDialogLinkManager.dismissDialog();
        if (this.mRoomSlot != null) {
            this.unBindingRoomData(this.mRoomSlot);
            this.mRoomService.leaveRoom(this.mRoomSlot, 6);
        }
        this.mGameResultWindow = null;
        this.mTopBarController = null;
        this.mExpressBarController = null;
        this.mMessageBarrageViewController = null;
        this.unregisterOtherLeftNotify();
        NotificationCenter.getGlobalInstance().unregister(GameNotificationDef.GAME_WIN_COUNT, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(ImNotificationBaseDef.IM_RECEIVE_SINGLE_MESSAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(GameNotificationDef.GAME_RESULT_INSEAT_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(GameNotificationDef.GAME_RESUTL_LIKE_RECIVED, (INotify)this);
        this.unregisterFromMsgDispatcher();
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).unRegisterGameMsgListener((IGameMsgListener)this);
        ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getPkGameInviteService().unregisterPKGameNotify(this.mIImpkGameListener);
        GameDataModel.instance.setmWinStreakData(null);
        this.mOtherUid = 0L;
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).unRegisterGameLifecycle((IGameLifecycle)this.mGameLifeWrapper);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).unRegisterGameMatchEvent(this.iMatchGameLifecycle);
        ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).unRegisterGameInviteListener(this.mImGameInviteListener);
        this.resetData();
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.stopLightAnim();
        }
        if (this.mDataCenter != null && this.mDataCenter.getGameModel() != null && this.mDataCenter.getGameModel().getGameInfo() != null && this.mDataCenter.getGameModel().getGameInfo().getGameMode() == 7) {
            ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).sendLeaveRoomReq(this.mDataCenter.getGameModel().getRoomid());
        }
        ImRecommendGameInfoManager.INSTANCE.setMatchReason("");
    }

    private void insertAndGetResultDataFromDB(GameResultBean gameResultBean) {
        if (gameResultBean != null && gameResultBean.getWinners() != null) {
            MyBox myBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(GameResultDBBean.class);
            if (myBox == null) {
                return;
            }
            if (!gameResultBean.isDraw()) {
                GameResultDb.getInstance().insertGameResult(gameResultBean, myBox);
            }
        }
    }

    private void onPkInviteOverTime() {
        if (this.mGameResultWindow == null) {
            return;
        }
        this.stopInviteTimer();
        this.dismissResultLoading();
        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.invitation_expried), (int)0);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPkInviteOverTime", (Object[])new Object[0]);
        }
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.PLAY_AGAIN);
            this.mGameResultWindow.onPkInviteOverTime();
            this.mInviteState = 0;
        }
        this.resetData();
    }

    private void resetData() {
        this.mSendPkId = "";
        this.mReceivePkId = "";
        this.mGameId = "";
        this.mInviteState = 0;
        this.clearMsg(false);
        this.clearMsg(true);
    }

    private void onPkMsgReceived(final String pkId, final String gameId, final int pkType) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GameResultWindowController.this.mGameResultWindow == null) {
                    return;
                }
                if (StringUtils.isNotEmpty((String)GameResultWindowController.this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString())) {
                    return;
                }
                if (StringUtils.isEmpty((String)pkId)) {
                    return;
                }
                if (pkType == 0) {
                    GameResultWindowController.this.mReceivePkId = pkId;
                    GameResultWindowController.this.mGameId = gameId;
                    if (GameResultWindowController.this.mGameResultWindow != null && GameResultWindowController.this.mDataCenter.getGameModel().getGameInfo() != null) {
                        if (gameId.equals(GameResultWindowController.this.mDataCenter.getGameModel().getGameInfo().getGid())) {
                            if (GameResultWindowController.this.mGameResultWindow != null) {
                                GameResultWindowController.this.reportGameResult("game_invite");
                                GameResultWindowController.this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.JOIN_GAME);
                                GameResultWindowController.this.mInviteState = 3;
                                if (GameResultWindowController.this.mGameResultWindow != null) {
                                    GameResultWindowController.this.mGameResultWindow.stopLightAnim();
                                    GameResultWindowController.this.onReceiveMsg(GameResultMsgBean.newBuilder().content(GameResultWindowController.this.mGameResultWindow.getMsgText(GameDef.PKGameInviteStatus.JOIN_GAME, "")).gid(gameId).msgType(1).build());
                                }
                                if (!MLog.isLogLevelAboveDebug()) {
                                    MLog.debug((Object)GameResultWindowController.TAG, (String)"onReceiveMsg==>uid=%s,gameid=%s,pkType=%d", (Object[])new Object[]{GameResultWindowController.this.mDataCenter.getGameModel().getOtherInfo().getUid(), gameId, pkType});
                                }
                            }
                        } else {
                            GameInfo gameInfo = ((IGameInfoService)GameResultWindowController.this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                            if (GameResultWindowController.this.mGameResultWindow != null && gameInfo != null) {
                                GameResultWindowController.this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.JOIN_OTHER_GAME);
                                GameResultWindowController.this.mInviteState = 3;
                                if (GameResultWindowController.this.mGameResultWindow != null) {
                                    GameResultWindowController.this.mGameResultWindow.stopLightAnim();
                                    GameResultWindowController.this.onReceiveMsg(GameResultMsgBean.newBuilder().content(GameResultWindowController.this.mGameResultWindow.getMsgText(GameDef.PKGameInviteStatus.JOIN_OTHER_GAME, gameInfo.getGname())).gameIcon(gameInfo.getImIconUrl()).gid(gameId).msgType(1).build());
                                }
                            } else {
                                GameResultWindowController.this.mReceivePkId = "";
                                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_error), (int)0);
                                MLog.error((Object)GameResultWindowController.TAG, (String)"onPkMsgReceived ==>gameInfo = null", (Object[])new Object[0]);
                            }
                        }
                        if (!StringUtils.isEmpty((String)GameResultWindowController.this.mReceivePkId)) {
                            GameResultWindowController.this.startInviteTimer();
                        }
                        if (SystemUtils.isAI((long)GameResultWindowController.this.mTargetId)) {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "receive_ai_invite").put("scence", "2"));
                        }
                    }
                }
            }
        });
    }

    private void onPkCanceled(String pkId) {
        if (this.mReceivePkId.equals(pkId)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.invitation_canceled), (int)0);
                    GameResultWindowController.this.mReceivePkId = "";
                    if (GameResultWindowController.this.mGameResultWindow != null) {
                        GameResultWindowController.this.mGameResultWindow.hideLoadingDialog();
                        if (!TextUtils.isEmpty((CharSequence)GameResultWindowController.this.mSendPkId)) {
                            GameResultWindowController.this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.WAIT_OPPOENT);
                            GameResultWindowController.this.mInviteState = 2;
                        } else {
                            GameResultWindowController.this.stopInviteTimer();
                            GameResultWindowController.this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.PLAY_AGAIN);
                            GameResultWindowController.this.mGameResultWindow.onPkCanceled();
                            GameResultWindowController.this.mInviteState = 0;
                        }
                        GameResultWindowController.this.clearMsg(false);
                    }
                }
            });
        }
    }

    private void onPkDeclined(String pkId) {
        if (StringUtils.equal((String)pkId, (String)this.mSendPkId)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.invitation_declined), (int)0);
            this.mSendPkId = "";
            if (this.mGameResultWindow != null) {
                if (!TextUtils.isEmpty((CharSequence)this.mReceivePkId)) {
                    this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.JOIN_OTHER_GAME);
                    this.mInviteState = 3;
                } else {
                    this.stopInviteTimer();
                    this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.PLAY_AGAIN);
                    this.mInviteState = 0;
                }
                this.clearMsg(true);
            }
        }
    }

    private void onPkAccept(String pkId, String gameId, String gameUrl, String roomId, boolean isSendByMe, boolean isGoldGame) {
        this.isGoldGame = isGoldGame;
        IGameInviteService iGameInviteService = (IGameInviteService)this.getServiceManager().getService(IGameInviteService.class);
        if (iGameInviteService != null && iGameInviteService.isGameInviteExist(pkId)) {
            iGameInviteService.removeGameInvite(pkId);
        }
        this.dismissResultLoading();
        if (this.mDataCenter.getGameModel().getGameInfo() == null || ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId) == null) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_error), (int)0);
            return;
        }
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo != null && gameInfo.getGameMode() != 7 && StringUtils.isEmpty((String)gameUrl)) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.out_data), (int)0);
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"out_data==>", (Object[])new Object[0]);
            }
            if (isSendByMe) {
                this.mSendPkId = "";
            } else {
                this.mReceivePkId = "";
            }
            if (this.mGameResultWindow != null) {
                this.mGameResultWindow.updateJoinBtn(GameDef.PKGameInviteStatus.PLAY_AGAIN);
                this.mInviteState = 0;
            }
            return;
        }
        if (gameInfo != null) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"EXIT_TO_GAME==>gid=%s,", (Object[])new Object[]{gameId});
            }
            if (gameInfo.getGameMode() == 7) {
                Game2V2MatchContext gameMatchContext = new Game2V2MatchContext(GameContextDef.JoinFrom.FROM_IM);
                if (gameInfo.getExt() != null) {
                    gameMatchContext.addAllKV(gameInfo.getExt());
                }
                gameMatchContext.setPkId(pkId);
                gameMatchContext.setFriendUserInfo(this.friendUserInfo);
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).matchGame(gameInfo, (GameMatchContext)gameMatchContext, null);
                if (this.mGameResultWindow != null) {
                    this.mWindowMgr.popWindow(false, (AbstractWindow)this.mGameResultWindow);
                }
            } else {
                GameModel.Builder builder = GameModel.newBuilder((GameModel)this.mDataCenter.getGameModel());
                builder.game_url(gameUrl).roomid(roomId).gameInfo(gameInfo);
                this.mDataCenter.setGameModel(builder.build());
                this.exitRoom(3);
            }
            if (isSendByMe) {
                this.mSendPkId = "";
            } else {
                this.mReceivePkId = "";
            }
        } else if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"EXIT_TO_GAME==>gameInfo=null", (Object[])new Object[0]);
        }
    }

    private void onJoinTeamAccept(String teamId, String gameId, int teamTemplete) {
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo == null) {
            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_error), (int)0);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"onJoinTeamAccept gameinfo==null gameid=%s", (Object[])new Object[]{gameId});
            }
            return;
        }
        GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(GameContextDef.JoinFrom.FROM_IM);
        teamMatchContext.setGameInfo(gameInfo);
        teamMatchContext.setMultiModeCode(teamTemplete);
        teamMatchContext.setTeamId(teamId);
        teamMatchContext.setInviteUid(this.mTargetId);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).teamMatchGame(gameInfo, teamMatchContext);
        if (this.mGameResultWindow != null) {
            GameResultWindow window = this.mGameResultWindow;
            this.mGameResultWindow = null;
            this.mWindowMgr.popWindow(true, (AbstractWindow)window);
        }
    }

    private void readEmojiData() {
        EmojiManager.INSTANCE.init();
    }

    public void onRoomCreate(RoomSlot room, int type, Object ... e) {
    }

    public void onRoomRestart(RoomSlot room, int type) {
    }

    public void onRoomResume(RoomSlot room, int type) {
    }

    public void onRoomPause(RoomSlot room, int type) {
    }

    public void onRoomDestory(RoomSlot room, int type) {
    }

    private void startInviteTimer() {
        YYTaskExecutor.removeTask((Runnable)this.mInviteTimer);
        YYTaskExecutor.execute((Runnable)this.mInviteTimer, (long)30000L);
    }

    private void stopInviteTimer() {
        YYTaskExecutor.removeTask((Runnable)this.mInviteTimer);
    }

    @Override
    public void likeResult() {
        if (this.mDataCenter.getGameModel().getOtherInfo() == null || this.mDataCenter.getGameModel().getGameInfo() == null) {
            MLog.error((Object)TAG, (String)"otherinfo=null", (Object[])new Object[0]);
            return;
        }
        if (!RepeatClickUtils.canRepeatClick((String)"result_like_click")) {
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        this.reportGameResult("like");
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"gameResultLike start", (Object[])new Object[0]);
        }
        GameResultLikeBean gameResultLikeBean = GameResultLikeBean.newBuilder().id(this.mDataCenter.getGameModel().getRoomid()).ltype((long)this.mDataCenter.getGameModel().getGameInfo().getGameMode()).tuid(this.mDataCenter.getGameModel().getOtherInfo().getUid()).build();
        ((ILikeService)this.getServiceManager().getService(ILikeService.class)).gameResultLike(gameResultLikeBean, (INetRespCallback)new INetRespCallback<GameResultLikeBean>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)GameResultWindowController.TAG, (String)"gameResultLike onError:%s", (Object[])new Object[]{e.toString()});
            }

            public void onResponse(String response, BaseResponseBean<GameResultLikeBean> res, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameResultWindowController.TAG, (String)"gameResultLike onResponse:%s,res.code=%s", (Object[])new Object[]{response, res.code});
                }
            }
        });
        if (this.mGameResultWindow != null) {
            this.mGameResultWindow.updateLike(false);
        }
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_RESULT_LIKE, (Object)this.mDataCenter.getGameModel().getOtherInfo().getUid()));
    }

    public void showLikeTip() {
        if (this.mGameResultWindow == null) {
            return;
        }
        boolean ishow = SettingFlags.getBoolean((String)("game_result_like_show" + AccountUtil.getUid()), (boolean)true);
        if (ishow) {
            if (this.imMessageQueueRecived != null && this.imMessageQueueRecived.size() > 0) {
                return;
            }
            if (this.mGameResultWindow != null) {
                this.mGameResultWindow.showLikeTip();
            }
            SettingFlags.setBoolean((String)("game_result_like_show" + AccountUtil.getUid()), (boolean)false);
        }
    }

    private void showRecommendReason() {
        if (this.mGameResultWindow == null) {
            return;
        }
        boolean isShow = SettingFlags.getBoolean((String)("game_result_like_show" + AccountUtil.getUid()), (boolean)true);
        if (!isShow && !StringUtils.isEmpty((String)ImRecommendGameInfoManager.INSTANCE.getMatchReason())) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"ImRecommendGameInfoManager", (String)"showRecommendReason=%s", (Object[])new Object[]{ImRecommendGameInfoManager.INSTANCE.getMatchReason()});
            }
            this.onReceiveMsg(GameResultMsgBean.newBuilder().content(ImRecommendGameInfoManager.INSTANCE.getMatchReason()).build());
            this.reportGameResult("reason_show");
        }
    }

    private void cancelSendInvite() {
        if (this.getServiceManager().getService(IGameInviteService.class) != null) {
            ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).cancelSendInvite(this.mTargetId);
        }
    }

    private void showInternetError() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast((Context)GameResultWindowController.this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            }
        });
    }

    public void onProfileClicked() {
    }

    public void onVpClicked() {
    }

    private void showLoading() {
        if (this.mDialogLinkManager == null) {
            return;
        }
        if (this.mLoadingDialog == null) {
            this.mLoadingDialog = new ProgressDialog("", false, false, new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog2) {
                    GameResultWindowController.this.mLoadingDialog = null;
                }
            });
        }
        this.mDialogLinkManager.showDialog((BaseDialog)this.mLoadingDialog);
    }

    private void finishLoading() {
        if (this.mDialogLinkManager == null || this.mLoadingDialog == null) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GameResultWindowController.this.mLoadingDialog != null && GameResultWindowController.this.mDialogLinkManager != null) {
                    GameResultWindowController.this.mDialogLinkManager.dismissDialog();
                }
            }
        });
    }

    public void showResultLoading() {
        this.showLoadingDialog.setArg((Object)true);
        YYTaskExecutor.postToMainThread((Runnable)this.showLoadingDialog, (long)500L);
    }

    public void dismissResultLoading() {
        this.showLoadingDialog.setArg((Object)false);
        this.finishLoading();
    }

    private void initBtn() {
        if ((this.mGameScene == GameContextDef.JoinFrom.FROM_HAGO_GROUP.getId() || StringUtils.isNotEmpty((String)this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString())) && this.mGameResultWindow != null) {
            this.mGameResultWindow.hideMoreGame();
        }
    }
}

