/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.gameresult;

import android.content.Context;
import androidx.annotation.NonNull;
import com.yy.appbase.abtest.serverab.ServerAB;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultUICallbacks;
import com.yy.game.gamemodule.pkgame.gameresult.IGameResultView;
import com.yy.game.gamemodule.pkgame.gameresult.ui.GameResult2V2LandPage;
import com.yy.game.gamemodule.pkgame.gameresult.ui.GameResult2V2Page;
import com.yy.game.gamemodule.pkgame.gameresult.ui.GameResultDoubleLandPager;
import com.yy.game.gamemodule.pkgame.gameresult.ui.GameResultDoublePager;
import com.yy.game.gamemodule.pkgame.gameresult.ui.GameResultLandPager;
import com.yy.game.gamemodule.pkgame.gameresult.ui.GameResultPager;
import com.yy.game.gamemodule.pkgame.gameresult.ui.GameResultPagerNew;
import com.yy.game.gamemodule.pkgame.gameresult.ui.withgallery.GameResultPagerWithGallery;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.config.GameCommonConfig;
import com.yy.hiyo.game.base.config.GameCommonConfigData;

public class GameResultViewFactory {
    private static final String TAG = "GameResultViewFactory";
    private static volatile GameResultViewFactory singleton;

    private GameResultViewFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GameResultViewFactory getSingleton() {
        if (singleton != null) return singleton;
        Class<GameResultViewFactory> clazz = GameResultViewFactory.class;
        synchronized (GameResultViewFactory.class) {
            if (singleton != null) return singleton;
            singleton = new GameResultViewFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @NonNull
    public IGameResultView getResultView(Context context, GameInfo gameInfo, IGameResultUICallbacks uiCallbacks) {
        if (gameInfo != null) {
            if (gameInfo.getGameMode() == 1) {
                if (gameInfo.getScreenDire() == 1) {
                    GameCommonConfigData data;
                    boolean bossSwitch = false;
                    AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.GAME_COMMON_CONFIG);
                    if (config instanceof GameCommonConfig && (data = ((GameCommonConfig)config).getData()) != null) {
                        bossSwitch = data.getGameResultPageWithGallery();
                    }
                    boolean matchAb = ServerAB.Companion.match("social_game_match", "2");
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("matchAb=" + matchAb + ", bossSwitch=" + bossSwitch), (Object[])new Object[0]);
                    }
                    if (bossSwitch && matchAb) {
                        return new GameResultPagerWithGallery(context, uiCallbacks, gameInfo);
                    }
                    return new GameResultPagerNew(context, uiCallbacks, gameInfo);
                }
                if (gameInfo.getScreenDire() == 2) {
                    return new GameResultLandPager(context, uiCallbacks, gameInfo);
                }
            } else if (gameInfo.getGameMode() == 5) {
                if (gameInfo.getScreenDire() == 1) {
                    return new GameResultDoublePager(context, uiCallbacks);
                }
                if (gameInfo.getScreenDire() == 2) {
                    return new GameResultDoubleLandPager(context, uiCallbacks);
                }
            } else if (gameInfo.getGameMode() == 7) {
                if (gameInfo.getScreenDire() == 1) {
                    return new GameResult2V2Page(context, uiCallbacks);
                }
                return new GameResult2V2LandPage(context, uiCallbacks);
            }
            return new GameResultPager(context, uiCallbacks);
        }
        return new GameResultPager(context, uiCallbacks);
    }
}

