/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.gameresult;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.service.bean.GameContextDef;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import okhttp3.Call;
import org.json.JSONArray;
import org.json.JSONObject;

public enum GameResultTipsManager {
    Instance;

    private static final String TAG = "GameResultTipsManager";
    private int mJoinFrom;
    private long mTargetUid;
    private boolean mIsExitFromGame;
    private GameDef.GameResult mGameResult;
    private int mGameMode;
    private List<String> mSinglePkGameWinList = new ArrayList<String>();
    private List<String> mSinglePkGameLoseList = new ArrayList<String>();
    private List<String> mSinglePkGameTieList = new ArrayList<String>();
    private List<String> mDoublePkGameWinList = new ArrayList<String>();
    private List<String> mDoublePkGameLoseList = new ArrayList<String>();
    private List<String> mDoublePkGameTieList = new ArrayList<String>();
    private List<String> mCoGameList = new ArrayList<String>();
    private List<String> mSinglePkGamePlayAgainWinList = new ArrayList<String>();
    private List<String> mSinglePkGamePlayAgainLoseList = new ArrayList<String>();
    private List<String> mSinglePkGamePlayAgainTieList = new ArrayList<String>();
    private List<String> mDoublePkGamePlayAgainWinList = new ArrayList<String>();
    private List<String> mDoublePkGamePlayAgainLoseList = new ArrayList<String>();
    private List<String> mDoublePkGamePlayAgainTieList = new ArrayList<String>();
    private List<String> mCoPlayAgainList = new ArrayList<String>();
    private boolean mIsLikeShow = true;

    public void initConfig() {
        if (this.mSinglePkGameWinList.size() > 0) {
            return;
        }
        HttpUtil.httpReq((String)UriProvider.getResultTipsConfig(), null, (int)1, (INetRespCallback)new INetRespCallback<JSONObject>(){

            public void onError(Call call, Exception e, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameResultTipsManager.TAG, (String)"getBubbleConfig\u51fa\u9519:%s", (Object[])new Object[]{e.toString()});
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onResponse(String response, BaseResponseBean<JSONObject> res, int id2) {
                if (res.isSuccess()) {
                    try {
                        int i;
                        int length;
                        JSONArray coGameArray;
                        JSONObject coJson;
                        JSONObject pk2v2Json;
                        JSONObject buttonTextJson;
                        JSONObject bubbleTextJson;
                        JSONObject pk1v1Json;
                        JSONObject dataJson;
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameResultTipsManager.TAG, (String)"getResultTipsConfig:%s", (Object[])new Object[]{response});
                        }
                        if ((dataJson = JsonParser.obtainJSONObject((String)response).optJSONObject("data")) == null) {
                            if (!MLog.isLogLevelBlowInfo()) return;
                            MLog.info((Object)GameResultTipsManager.TAG, (String)"getResultTipsConfig\u62ff\u5230\u7684dataJson\u4e3a\u7a7a", (Object[])new Object[0]);
                            return;
                        }
                        if (dataJson.has("pk1v1") && (pk1v1Json = dataJson.optJSONObject("pk1v1")) != null) {
                            if (pk1v1Json.has("bubble_text")) {
                                bubbleTextJson = pk1v1Json.optJSONObject("bubble_text");
                                GameResultTipsManager.this.pickUpPkData(bubbleTextJson, GameResultTipsManager.this.mSinglePkGameWinList, GameResultTipsManager.this.mSinglePkGameLoseList, GameResultTipsManager.this.mSinglePkGameTieList);
                            }
                            if (pk1v1Json.has("button_text")) {
                                buttonTextJson = pk1v1Json.optJSONObject("button_text");
                                GameResultTipsManager.this.pickUpPkData(buttonTextJson, GameResultTipsManager.this.mSinglePkGamePlayAgainWinList, GameResultTipsManager.this.mSinglePkGamePlayAgainLoseList, GameResultTipsManager.this.mSinglePkGamePlayAgainTieList);
                            }
                        }
                        if (dataJson.has("pk2v2") && (pk2v2Json = dataJson.optJSONObject("pk2v2")) != null) {
                            if (pk2v2Json.has("bubble_text")) {
                                bubbleTextJson = pk2v2Json.optJSONObject("bubble_text");
                                GameResultTipsManager.this.pickUpPkData(bubbleTextJson, GameResultTipsManager.this.mDoublePkGameWinList, GameResultTipsManager.this.mDoublePkGameLoseList, GameResultTipsManager.this.mDoublePkGameTieList);
                            }
                            if (pk2v2Json.has("button_text")) {
                                buttonTextJson = pk2v2Json.optJSONObject("button_text");
                                GameResultTipsManager.this.pickUpPkData(buttonTextJson, GameResultTipsManager.this.mDoublePkGamePlayAgainWinList, GameResultTipsManager.this.mDoublePkGamePlayAgainLoseList, GameResultTipsManager.this.mDoublePkGamePlayAgainTieList);
                            }
                        }
                        if (!dataJson.has("co_game") || (coJson = dataJson.optJSONObject("co_game")) == null) return;
                        if (coJson.has("bubble_text") && (bubbleTextJson = coJson.optJSONObject("bubble_text")) != null && bubbleTextJson.has("co_game") && (coGameArray = bubbleTextJson.optJSONArray("co_game")) != null) {
                            length = coGameArray.length();
                            for (i = 0; i < length; ++i) {
                                if (GameResultTipsManager.this.mCoGameList == null) continue;
                                GameResultTipsManager.this.mCoGameList.add(coGameArray.getString(i));
                            }
                        }
                        if (!coJson.has("button_text") || (buttonTextJson = coJson.optJSONObject("button_text")) == null || !buttonTextJson.has("co_game") || (coGameArray = buttonTextJson.optJSONArray("co_game")) == null) return;
                        length = coGameArray.length();
                        for (i = 0; i < length; ++i) {
                            if (GameResultTipsManager.this.mCoPlayAgainList == null) continue;
                            GameResultTipsManager.this.mCoPlayAgainList.add(coGameArray.getString(i));
                        }
                        return;
                    }
                    catch (Exception e) {
                        MLog.error((Object)GameResultTipsManager.TAG, (String)"getBubbleConfig\u51fa\u9519:%s", (Object[])new Object[]{e.toString()});
                        return;
                    }
                } else {
                    if (!MLog.isLogLevelBlowInfo()) return;
                    MLog.info((Object)GameResultTipsManager.TAG, (String)"\u8bf7\u6c42\u5931\u8d25:%s", (Object[])new Object[]{res});
                }
            }
        });
    }

    private void pickUpPkData(JSONObject json, List<String> winList, List<String> loseList, List<String> tieList) {
        block9: {
            if (json == null) {
                return;
            }
            try {
                JSONArray pkGameTieArray;
                JSONArray pkGameLoseArray;
                int i;
                int length;
                JSONArray pkGameWinArray;
                if (json.has("pk_game_win") && (pkGameWinArray = json.optJSONArray("pk_game_win")) != null) {
                    length = pkGameWinArray.length();
                    for (i = 0; i < length; ++i) {
                        if (winList == null) continue;
                        winList.add(pkGameWinArray.getString(i));
                    }
                }
                if (json.has("pk_game_lose") && (pkGameLoseArray = json.optJSONArray("pk_game_lose")) != null) {
                    length = pkGameLoseArray.length();
                    for (i = 0; i < length; ++i) {
                        if (loseList == null) continue;
                        loseList.add(pkGameLoseArray.getString(i));
                    }
                }
                if (json.has("pk_game_tie") && (pkGameTieArray = json.optJSONArray("pk_game_tie")) != null) {
                    length = pkGameTieArray.length();
                    for (i = 0; i < length; ++i) {
                        if (tieList == null) continue;
                        tieList.add(pkGameTieArray.getString(i));
                    }
                }
            }
            catch (Exception e) {
                if (!MLog.isLogLevelBlowInfo()) break block9;
                MLog.info((Object)TAG, (String)"pickUpPkData\u51fa\u9519:%s", (Object[])new Object[]{e});
            }
        }
    }

    public void initCondition(int joinFrom, long uid, boolean isExitFromGame, int gameMode) {
        this.mJoinFrom = joinFrom;
        this.mTargetUid = uid;
        this.mIsExitFromGame = isExitFromGame;
        this.mGameMode = gameMode;
        this.mIsLikeShow = SettingFlags.containKey((String)("game_result_like_show" + AccountUtil.getUid())) ? SettingFlags.getBoolean((String)("game_result_like_show" + AccountUtil.getUid()), (boolean)true) : true;
    }

    public void setGameResult(GameDef.GameResult gameResult) {
        this.mGameResult = gameResult;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"\u62ff\u5230\u7684\u6e38\u620f\u7ed3\u679c:%s", (Object[])new Object[]{gameResult});
        }
    }

    private boolean isInviteTipsShow() {
        Random rand = new Random();
        int number = rand.nextInt(2);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"Uid:%s, \u5bf9\u6bd4\u6570:%s, \u968f\u673a\u6570:%s", (Object[])new Object[]{this.mTargetUid, 2, number});
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isAi:%s, isFromMatch:%s", (Object[])new Object[]{SystemUtils.isAI((long)this.mTargetUid), this.mJoinFrom == GameContextDef.JoinFrom.FROM_MATCH.getId()});
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"\u81ea\u5df1\u662f\u5426\u9003\u8dd1:%s, \u662f\u5426\u9700\u8981\u51fa\u73b0\u70b9\u8d5e\u5f15\u5bfc\u6c14\u6ce1:%s", (Object[])new Object[]{this.mIsExitFromGame, this.mIsLikeShow});
        }
        return !SystemUtils.isAI((long)this.mTargetUid) && !this.mIsExitFromGame && this.mJoinFrom == GameContextDef.JoinFrom.FROM_MATCH.getId() && number == 1 && !this.mIsLikeShow;
    }

    private boolean randomValue() {
        Random random = new Random();
        int abNum = random.nextInt(2);
        return abNum != 0;
    }

    public String getGameInviteTips() {
        if (this.isInviteTipsShow()) {
            if (this.mGameMode == 1) {
                return this.getPKGameTips(this.mSinglePkGameWinList, this.mSinglePkGameLoseList, this.mSinglePkGameTieList);
            }
            if (this.mGameMode == 5) {
                if (this.mCoGameList.size() > 0) {
                    return this.mCoGameList.get(this.getRandomIndex(this.mCoGameList.size()));
                }
            } else if (this.mGameMode == 7) {
                return this.getPKGameTips(this.mDoublePkGameWinList, this.mDoublePkGameLoseList, this.mDoublePkGameTieList);
            }
            return "";
        }
        return "";
    }

    private String getPKGameTips(List<String> winList, List<String> loseList, List<String> tieList) {
        if (GameDef.GameResult.GAME_DRAW == this.mGameResult) {
            if (tieList.size() > 0) {
                return tieList.get(this.getRandomIndex(tieList.size()));
            }
        } else if (GameDef.GameResult.GAME_LOSE == this.mGameResult) {
            if (winList.size() > 0) {
                return winList.get(this.getRandomIndex(winList.size()));
            }
        } else if (GameDef.GameResult.GAME_WIN == this.mGameResult && loseList.size() > 0) {
            return loseList.get(this.getRandomIndex(loseList.size()));
        }
        return "";
    }

    private int getRandomIndex(int length) {
        Random random = new Random();
        if (length > 1) {
            return random.nextInt(length - 1);
        }
        return 0;
    }

    public String getPlayAgainTips() {
        if (this.mGameMode == 1) {
            return this.getPKGameTips(this.mSinglePkGamePlayAgainWinList, this.mSinglePkGamePlayAgainLoseList, this.mSinglePkGamePlayAgainTieList);
        }
        if (this.mGameMode == 5) {
            if (this.mCoPlayAgainList.size() > 0) {
                return this.mCoPlayAgainList.get(this.getRandomIndex(this.mCoPlayAgainList.size()));
            }
        } else if (this.mGameMode == 7) {
            return this.getPKGameTips(this.mDoublePkGamePlayAgainWinList, this.mDoublePkGamePlayAgainLoseList, this.mDoublePkGamePlayAgainTieList);
        }
        return "";
    }
}

