/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame.gameresult;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.view.View;
import android.widget.TextView;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.game.DR;
import com.yy.game.R;
import com.yy.hiyo.dyres.api.DyResLoader;

public class CoinGameResultHelper {
    private static final long SHOW_DISTANCE = 1000L;
    private long updateWinOrLostTs = 0L;

    public void updateWinOrLostTs() {
        this.updateWinOrLostTs = System.currentTimeMillis();
    }

    public void showCoinResult(final SVGAImageView successSvga, final TextView tvTips, final TextView tvResult, final TextView tvChange, final View bgView, final String tips, int gameResult, final long changeCoins, final long balance) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (successSvga == null || tvTips == null || tvResult == null || tvChange == null || bgView == null) {
                    return;
                }
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        tvTips.setText((CharSequence)tips);
                        bgView.setBackgroundResource(changeCoins >= 0L ? R.drawable.streak_win_bk : R.drawable.streak_lose_bk);
                        CoinGameResultHelper.this.setCoinText(tvResult, balance - changeCoins);
                        tvResult.setTextSize(17.0f);
                        tvResult.setTypeface(Typeface.DEFAULT_BOLD);
                        tvChange.setTextSize(17.0f);
                        tvChange.setTypeface(Typeface.DEFAULT_BOLD);
                        tvChange.setVisibility(0);
                        tvChange.setTextColor(Color.parseColor((String)(changeCoins >= 0L ? "#FFFFD700" : "#80FFFFFF")));
                        tvChange.setText((CharSequence)(changeCoins >= 0L ? "+" + changeCoins : "" + changeCoins));
                        ObjectAnimator xAnim = ObjectAnimator.ofFloat((Object)tvChange, (String)View.SCALE_X.getName(), (float[])new float[]{1.0f, 1.5f, 0.6f, 1.0f});
                        xAnim.setDuration(1500L);
                        ObjectAnimator yAnim = ObjectAnimator.ofFloat((Object)tvChange, (String)View.SCALE_Y.getName(), (float[])new float[]{1.0f, 1.5f, 0.6f, 1.0f});
                        yAnim.setDuration(1500L);
                        ObjectAnimator alphAnim = ObjectAnimator.ofFloat((Object)tvChange, (String)View.ALPHA.getName(), (float[])new float[]{1.0f, 0.0f});
                        alphAnim.setDuration(500L);
                        alphAnim.setStartDelay(1000L);
                        AnimatorSet animatorSet = new AnimatorSet();
                        animatorSet.playTogether(new Animator[]{xAnim, yAnim, alphAnim});
                        animatorSet.start();
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CoinGameResultHelper.this.setCoinText(tvResult, balance);
                                if (tvChange != null) {
                                    tvChange.setVisibility(8);
                                }
                            }
                        }, (long)2000L);
                    }
                };
                if (changeCoins >= 0L) {
                    successSvga.setVisibility(0);
                    DyResLoader.INSTANCE.loadSvga(successSvga, DR.game_result_win_coins, new ISvgaLoadCallback(){

                        public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                            if (successSvga != null) {
                                successSvga.startAnimation();
                            }
                        }

                        public void onFailed(Exception e) {
                        }
                    });
                    YYTaskExecutor.postToMainThread((Runnable)runnable2, (long)1000L);
                } else {
                    runnable2.run();
                }
            }
        };
        long current = System.currentTimeMillis();
        long dis = 1000L - (current - this.updateWinOrLostTs);
        if (dis > 0L) {
            YYTaskExecutor.postToMainThread((Runnable)runnable2, (long)dis);
        } else {
            runnable2.run();
        }
    }

    private void setCoinText(TextView tvResult, long coins) {
        if (tvResult != null) {
            String img = "IMG";
            String firstNum = " " + coins;
            String str = img + firstNum;
            SpannableString spannableString = new SpannableString((CharSequence)str);
            Drawable drawable2 = ResourceUtils.getDrawable((int)R.drawable.bg_single_coin);
            drawable2.setBounds(0, 0, (int)((float)drawable2.getIntrinsicWidth() / 1.5f), (int)((float)drawable2.getIntrinsicHeight() / 1.5f));
            spannableString.setSpan((Object)new ImageSpan(drawable2, 1), 0, img.length(), 17);
            spannableString.setSpan((Object)new ForegroundColorSpan(ResourceUtils.getColor((int)R.color.white)), img.length(), img.length() + firstNum.length(), 17);
            tvResult.setText((CharSequence)spannableString);
            tvResult.setVisibility(0);
        }
    }
}

