/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.util.Pair;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.appbase.data.GameMasterBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.OnGetHeadFrameCallback;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.service.model.RoomUserMicStatus;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.game.R;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.GameDataCenter;
import com.yy.game.bean.GameDataModel;
import com.yy.game.bean.GameResultWebBean;
import com.yy.game.bean.OpenSceneBean;
import com.yy.game.cocos2d.EngineContext;
import com.yy.game.gamemodule.BaseGameCallAppRouter;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.activity.mpl.MPLRankGameResultWindowController;
import com.yy.game.gamemodule.activity.mpl.OnMplRankGameResultShowEvent;
import com.yy.game.gamemodule.base.NormalGamePlayer;
import com.yy.game.gamemodule.base.gameview.WindowGameView;
import com.yy.game.gamemodule.pkgame.PkGameCallAppRouter;
import com.yy.game.gamemodule.pkgame.gameresult.GameResultWindowController;
import com.yy.game.module.gameload.LoadGamePageManager;
import com.yy.game.module.gameroom.StreakWinInterruptedHelper;
import com.yy.game.module.gameroom.barrageview.MessageBarrageView;
import com.yy.game.module.gameroom.barrageview.MessageBarrageViewController;
import com.yy.game.module.gameroom.expressionbar.ExpressBarController;
import com.yy.game.module.gameroom.topbar.ITopBarUiCallback;
import com.yy.game.module.gameroom.topbar.TopBarController;
import com.yy.game.module.gameroom.ui.AbsGameWindow;
import com.yy.game.module.gameroom.ui.AbstractFunctionLayer;
import com.yy.game.module.gameroom.ui.CustomerFuntionLayer;
import com.yy.game.module.gameroom.ui.EmptyFuntionLayer;
import com.yy.game.module.gameroom.ui.GameLoadingPage;
import com.yy.game.module.gameroom.ui.GameWindowConfig;
import com.yy.game.module.gameroom.ui.HorizontalFuntionLayer;
import com.yy.game.module.gameroom.ui.IFunctionLayerCallback;
import com.yy.game.module.gameroom.ui.VerticalFuntionLayer;
import com.yy.game.module.jscallappmodule.model.GetRelationBean;
import com.yy.game.module.streakwin.StreakWinController;
import com.yy.game.msg.GameMsgDef;
import com.yy.game.msg.OnGameResultShowEvent;
import com.yy.game.utils.GameReportHelper;
import com.yy.game.utils.GameStateDef;
import com.yy.game.utils.Utils;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.GameResultBean;
import com.yy.hiyo.game.base.IGameMsgListener;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.IGameDialogCallback;
import com.yy.hiyo.game.base.module.appcallgamemodle.AppNotifyGameDefine;
import com.yy.hiyo.game.base.module.jscallappmodule.IComGameCallAppCallBack;
import com.yy.hiyo.game.base.streakwin.StreakWinData;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameMessageService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.voice.base.bean.GameUserSpeakStatus;
import com.yy.hiyo.voice.base.bean.MicStatusBean;
import com.yy.hiyo.voice.base.bean.UserSpeakStatus;
import com.yy.hiyo.voice.base.roomvoice.AbsVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.IRoomManagerService;
import com.yy.hiyo.voice.base.roomvoice.RoomSlot;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.gameresult.PKWinStreakPush;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

public class PkGamePlayer
extends NormalGamePlayer {
    private static final String TAG = "PkGamePlayer";
    private TopBarController mTopBarController;
    ExpressBarController mExpressBarController;
    MessageBarrageViewController mMessageBarrageViewController;
    BizCollector bizCollector = new BizCollector();
    private RoomSlot<AbsVoiceRoom> mRoomSlot;
    String mSessionId;
    private long selfUid;
    private long targetUid;
    IRoomManagerService mRoomService;
    int micInitState;
    long mVoiceStartTime;
    long tap;
    boolean mIsHiddenFinish;
    private StreakWinController mStreakWindowController;
    private MPLRankGameResultWindowController mMPLRankGameResultWindowController;
    protected GameResultWindowController mGameResultWindowController;
    private StreakWinInterruptedHelper streakWinInterruptedHelper;
    boolean mHadSendEmoj;
    AbstractFunctionLayer abstractFunctionLayer;
    private GameResultWebBean gameResultWebBean = null;
    private static final Long GAME_EXIT_TIMEOUT = 3000L;
    private Runnable showSmileEmojiTask = new ShowAiSmileTask();
    private static final int SHOW_AI_SMILE_COUNTS = 3;
    private int curCounts = 0;
    private int isShowMaster = 0;
    private GameMasterBean mGameMasterBean;
    private boolean mGameStarted = false;
    private Runnable mExitRunable = new YYTaskExecutor.RunnableEx(){

        public void run() {
            PkGamePlayer.this.exitRoom(1002, 2);
        }
    };
    private IGameMsgListener mGameMsgListener = new IGameMsgListener(){

        public void onExpressNotify(long senderUid, String value) {
            try {
                YYTaskExecutor.execute(() -> {
                    if (PkGamePlayer.this.gameRunningContext.getOtherUserInfo() == null || senderUid != PkGamePlayer.this.gameRunningContext.getOtherUserInfo().getUid()) {
                        return;
                    }
                    EmojiBean emojiBean = (EmojiBean)JsonParser.parseJsonObject((String)value, EmojiBean.class);
                    YYTaskExecutor.postToMainThread(() -> {
                        if (emojiBean != null && PkGamePlayer.this.abstractFunctionLayer != null) {
                            PkGamePlayer.this.abstractFunctionLayer.showEmojOther(emojiBean);
                        }
                    });
                });
            }
            catch (Exception e) {
                MLog.error((Object)PkGamePlayer.TAG, (Throwable)e);
            }
        }

        public void onExpressBrocstNotify(String barcastId, long uid, String value) {
        }

        public void onSendMsgRes() {
        }

        public void onJoinRoomSuccess() {
        }

        public void onJoinRoomFail(long code) {
        }

        public void onBarrageNotify(BarrageInfo value, String id2, int type) {
            try {
                YYTaskExecutor.execute(() -> {
                    if (type == 0 && !TextUtils.isEmpty((CharSequence)id2) && PkGamePlayer.this.gameRunningContext.getOtherUserInfo() != null && !id2.equals(String.valueOf(PkGamePlayer.this.gameRunningContext.getOtherUserInfo().getUid()))) {
                        return;
                    }
                    YYTaskExecutor.postToMainThread(() -> {
                        MessageBarrageView messageBarrageView;
                        if (value != null && value.user != null && value.mDanmu != null && PkGamePlayer.this.mMessageBarrageViewController != null && (messageBarrageView = PkGamePlayer.this.mMessageBarrageViewController.getMessageBarrageView(PkGamePlayer.this.gameRunningContext.getGameInfo())) != null) {
                            messageBarrageView.showBarrageView(value.user.avatar, value.mDanmu.txt, -16126);
                        }
                    });
                });
            }
            catch (Exception e) {
                MLog.error((Object)PkGamePlayer.TAG, (Throwable)e);
            }
        }
    };
    private PkGameCallAppRouter.IPkGameCallAppCallback mIPkGameCallAppCallback = new PkGameCallAppRouter.IPkGameCallAppCallback(){

        @Override
        public void receiveGameResult(@NotNull String reqJson) {
            PkGamePlayer.this.handlePosetGameResult(reqJson);
        }

        @Override
        public void generateGameResult() {
            this.generateGameResult();
        }

        @Override
        public void handleGameForceExit(int exitCode, int exitType) {
            PkGamePlayer.this.handleGameForceExit(exitCode, exitType);
        }

        @Override
        public void handleUpdateInputBarrageView(@NotNull String reqJson) {
            PkGamePlayer.this.handleUpdateInputBarrageView(reqJson);
        }

        @Override
        public void handleShowInputBarrageView() {
            PkGamePlayer.this.handleShowInputBarrageView();
        }

        @Override
        @NotNull
        public OpenSceneBean getOpenScene() {
            OpenSceneBean openSceneBean = new OpenSceneBean();
            openSceneBean.setOpenScene(PkGamePlayer.this.gameRunningContext.getFrom().getId());
            return openSceneBean;
        }

        @Override
        @NotNull
        public RoomSlot<AbsVoiceRoom> getRoomSlot() {
            return PkGamePlayer.this.mRoomSlot;
        }

        @Override
        public GameInfo getGamingInfo() {
            return PkGamePlayer.this.getCurPlayingGameContext().getGameInfo();
        }

        @Override
        public GamePlayContext getGameContext() {
            return PkGamePlayer.this.getCurPlayingGameContext();
        }

        @Override
        public Activity getContext() {
            return PkGamePlayer.this.mContext;
        }

        @Override
        @Nullable
        public EngineContext getEngineContext() {
            if (PkGamePlayer.this.getBaseGameView().getGameWindow() != null) {
                return PkGamePlayer.this.getBaseGameView().getGameWindow().getEngineContext();
            }
            return null;
        }
    };
    protected final KvoBinder mBinder = new KvoBinder((Object)this);
    private IFunctionLayerCallback iFunctionLayerCallback = new IFunctionLayerCallback(){

        @Override
        public synchronized TopBarController getTopBarController() {
            if (PkGamePlayer.this.mTopBarController == null) {
                PkGamePlayer.this.mTopBarController = new TopBarController(new ITopBarUiCallback(){

                    @Override
                    public void onBackClick() {
                        PkGamePlayer.this.onBackClick();
                    }

                    @Override
                    public void onMicClick() {
                        PkGamePlayer.this.onMicClickInner();
                    }

                    @Override
                    public void onUserClick(long uid) {
                        if (uid != AccountUtil.getUid()) {
                            PkGamePlayer.this.showProfileCard(uid);
                        }
                    }
                }, PkGamePlayer.this.getEnvironment());
            }
            return PkGamePlayer.this.mTopBarController;
        }

        @Override
        public synchronized ExpressBarController getExpressBarController() {
            if (PkGamePlayer.this.mExpressBarController == null) {
                PkGamePlayer.this.mExpressBarController = new ExpressBarController(bean -> {
                    if (bean == null) {
                        return;
                    }
                    if (PkGamePlayer.this.gameRunningContext.getOtherUserInfo() != null && PkGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "emoji").put("emoji_id", String.valueOf(bean.getId())).put("act_uid", String.valueOf(((PkGamePlayer)PkGamePlayer.this).gameRunningContext.getOtherUserInfo().uid)).put("roomid", PkGamePlayer.this.gameRunningContext.getRoomId()).put("gid", PkGamePlayer.this.gameRunningContext.getGameInfo().getGid()));
                    }
                    if (PkGamePlayer.this.abstractFunctionLayer != null) {
                        PkGamePlayer.this.abstractFunctionLayer.showEmoj(bean);
                    }
                    YYTaskExecutor.execute(() -> {
                        if (!PkGamePlayer.this.mHadSendEmoj) {
                            ((IHonorService)PkGamePlayer.this.getServiceManager().getService(IHonorService.class)).reportSendEmojHonorTask();
                        }
                        PkGamePlayer.this.mHadSendEmoj = true;
                        ((IGameMessageService)PkGamePlayer.this.getServiceManager().getService(IGameMessageService.class)).sendMsgReqUnio(JsonParser.toJson((Object)bean), PkGamePlayer.this.gameRunningContext.getOtherUserInfo().getUid(), 1L);
                    });
                }, PkGamePlayer.this.getEnvironment());
            }
            return PkGamePlayer.this.mExpressBarController;
        }

        @Override
        public synchronized MessageBarrageViewController getMessageBarrageViewController() {
            if (PkGamePlayer.this.mMessageBarrageViewController == null) {
                PkGamePlayer.this.mMessageBarrageViewController = new MessageBarrageViewController(barrageMsg -> {
                    if (TextUtils.isEmpty((CharSequence)barrageMsg)) {
                        return;
                    }
                    UserInfoBean myUserInfo = ((IUserInfoService)PkGamePlayer.this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
                    UserInfoKS otherUserInfo = PkGamePlayer.this.gameRunningContext.getOtherUserInfo();
                    if (myUserInfo != null && otherUserInfo != null) {
                        ((IGameMessageService)PkGamePlayer.this.getServiceManager().getService(IGameMessageService.class)).sendMsgReq(otherUserInfo.getUid(), myUserInfo, barrageMsg);
                    }
                }, PkGamePlayer.this.getEnvironment());
            }
            return PkGamePlayer.this.mMessageBarrageViewController;
        }
    };

    private void onMicClickInner() {
        if (this.mRoomSlot != null && this.mRoomSlot.room != null) {
            if (!this.mRoomSlot.room.mMyStatus.isMicOpen()) {
                HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20023777").put("link_time", String.valueOf(this.tap)).put("act_uid", String.valueOf(this.targetUid)).put("roomid", this.gameRunningContext.getRoomId()).put("gid", this.gameRunningContext.getGameInfo().getGid());
                hiidoEvent.put("function_id", "strat_mic");
                HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
                PermissionHelper.requestRecordAudioPermission((Activity)this.mContext, (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        if (PkGamePlayer.this.mRoomSlot != null && ((PkGamePlayer)PkGamePlayer.this).mRoomSlot.room != null && !((PkGamePlayer)PkGamePlayer.this).mRoomSlot.room.mMyStatus.isMicOpen()) {
                            ((PkGamePlayer)PkGamePlayer.this).mRoomSlot.room.changeMicStatus(!((PkGamePlayer)PkGamePlayer.this).mRoomSlot.room.mMyStatus.isMicOpen());
                        }
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                    }
                });
            } else {
                this.tap = Math.abs((System.currentTimeMillis() - this.mVoiceStartTime) / 1000L);
                if (this.gameRunningContext.getGameInfo() != null && this.mVoiceStartTime > 0L) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("link_time", String.valueOf(this.tap)).put("act_uid", String.valueOf(this.targetUid)).put("roomid", this.gameRunningContext.getRoomId()).put("gid", this.gameRunningContext.getGameInfo().getGid()).put("function_id", "end_mic"));
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("link_time", String.valueOf(this.tap)).put("act_uid", String.valueOf(this.targetUid)).put("roomid", this.gameRunningContext.getRoomId()).put("gid", this.gameRunningContext.getGameInfo().getGid()).put("function_id", "off_mic"));
                }
                this.mVoiceStartTime = 0L;
                this.mRoomSlot.room.changeMicStatus(!this.mRoomSlot.room.mMyStatus.isMicOpen());
            }
        }
    }

    @Override
    public CocosProxyType[] getSupportedCocosProxyType() {
        return new CocosProxyType[0];
    }

    private void handleShowInputBarrageView() {
        if (this.mMessageBarrageViewController != null) {
            this.mMessageBarrageViewController.showInputView();
        }
    }

    private void handleUpdateInputBarrageView(String reqJson) {
        if (this.mMessageBarrageViewController != null) {
            this.mMessageBarrageViewController.updateBarrageViewPosition(reqJson);
        }
    }

    PkGamePlayer(Environment env, IGameLifecycle callback2) {
        super(env, callback2);
        this.mStreakWindowController = new StreakWinController(this.getEnvironment(), () -> {
            if (this.isPlaying()) {
                return;
            }
            this.showGameResult(this.gameRunningContext.getGameResultBean(), this.gameRunningContext.getFrom().getId());
        });
        this.mGameResultWindowController = new GameResultWindowController(this.getEnvironment());
        this.streakWinInterruptedHelper = new StreakWinInterruptedHelper();
        this.mMPLRankGameResultWindowController = new MPLRankGameResultWindowController(this.getEnvironment());
    }

    private void handleGameForceExit(final int exitCode, final int exitType) {
        YYTaskExecutor.execute(() -> {
            this.setGameExitType(2);
            this.generateGameResult();
        }, (Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                PkGamePlayer.this.exitRoom(exitCode, exitType, 2);
            }
        });
    }

    private void handlePosetGameResult(String reqJson) {
        this.gameRunningContext.setGameResult(reqJson);
        if (!StringUtils.isEmpty((String)this.gameRunningContext.getGameResult())) {
            GameDataModel.instance.postGameResult(this.gameRunningContext.buildGameModel(), this.gameRunningContext.getGameResult());
        }
        YYTaskExecutor.execute(this::generateGameResult);
    }

    @Override
    public int preLoadGame(GamePlayContext gamePlayContext) {
        if (this.gameRunningContext.getGameInfo() == null || StringUtils.isEmpty((String)this.gameRunningContext.getGameUrl()) || gamePlayContext.getOtherUserInfo() == null || gamePlayContext.getUserInfo(AccountUtil.getUid()) == null) {
            GameLoger.error("pkGame", "preLoadGame error: getGame_url:%s,gameInfo:%s,other:%s,self:%s", this.gameRunningContext.getGameUrl(), this.gameRunningContext.getGameInfo(), gamePlayContext.getOtherUserInfo(), gamePlayContext.getUserInfo(AccountUtil.getUid()));
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_loading_fail), (int)0);
            return 1;
        }
        return 0;
    }

    @Override
    public void onPreloadGameInner(@NotNull @NonNull GamePlayContext context) {
        super.onPreloadGameInner(context);
        this.mGameStarted = false;
        this.mHadSendEmoj = false;
        this.mRoomService = (IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class);
        this.initDate(context);
        this.initView(this.getCurPlayingGameContext());
        if (this.getBaseGameView() != null) {
            this.getBaseGameView().showGameView();
            this.getBaseGameView().loadGameView();
        }
        this.bizCollector.reportGame(true);
        this.bizCollector.reportQuickMsgs();
        GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.getGameStartTime()), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.GAME_START.value(), 0, this.isGoldGame);
    }

    public void initDate(GamePlayContext context) {
        UserInfoKS other = context.getOtherUserInfo();
        this.targetUid = other.uid;
        UserInfoKS self = this.gameRunningContext.getUserInfo(AccountUtil.getUid());
        this.selfUid = self.uid;
        this.mSessionId = Utils.getSessionId(self.uid, other.uid);
    }

    public void initView(GamePlayContext context) {
        ((IHonorService)this.getServiceManager().getService(IHonorService.class)).getSingleHeadFrame(context.getOtherUserInfo().uid, new OnGetHeadFrameCallback(){

            public void onGetHeadFrameSuccess(List<Integer> list) {
                if (list == null || list.isEmpty()) {
                    return;
                }
                if (PkGamePlayer.this.mTopBarController != null) {
                    PkGamePlayer.this.mTopBarController.updateOtherHeadFrameType(((IHonorService)PkGamePlayer.this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(list.get(0).intValue()));
                }
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
        HeadFrameType headFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
        Kvo.addKvoBinding((KvoSource)headFrameType, (Object)this, (String)"onMyHeadFrameTypeUpdate");
        if (this.mTopBarController != null) {
            this.mTopBarController.updateLeftUser(context.getUserInfo(AccountUtil.getUid()));
            this.mTopBarController.updateRightUser(context.getOtherUserInfo());
        }
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).getMessagePool(this.gameRunningContext.getGameInfo().getGid(), bean -> {
            if (this.mMessageBarrageViewController != null && bean != null) {
                this.mMessageBarrageViewController.setMessageList(bean.msgs);
            }
        });
    }

    @Override
    public void onPlayGameStartInner(GamePlayContext context) {
        super.onPlayGameStartInner(context);
        GameDataModel.instance.postGameJoin(this.gameRunningContext.buildGameModel(), this.gameRunningContext.getFrom().getId());
        AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent().eventId("Start_PK_Game"));
        GameInfo gameInfo = this.gameRunningContext != null ? this.gameRunningContext.getGameInfo() : null;
        this.mGameStarted = true;
        if (gameInfo != null && this.mGameFirstFrameTime > 0L) {
            long cost = System.currentTimeMillis() - this.mGameFirstFrameTime;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"GameReportV1", (String)"onPlayGameStartInner cost:%d", (Object[])new Object[]{cost});
            }
        }
    }

    @Override
    public void onGameLoadingFinishInner() {
        super.onGameLoadingFinishInner();
        Object isFirstMatchAi = this.sendMessageSync(GameMsgDef.NEW_REGISTER_FIRST_MATCH_AI);
        if (isFirstMatchAi instanceof Boolean && ((Boolean)isFirstMatchAi).booleanValue()) {
            YYTaskExecutor.postToMainThread((Runnable)this.showSmileEmojiTask, (long)10000L);
        }
        this.bizCollector.reportGameLoadFinish();
    }

    @Override
    public void onPlayGameFinishInner(GamePlayContext context, int finishType) {
        YYTaskExecutor.execute(this::generateGameResult, () -> {
            if (finishType == 2) {
                GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.getGameStartTime()), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.EXECPTION_FINISH.value(), 0, this.isGoldGame);
                this.exitRoom(16);
            } else if (finishType == 1) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("GAME_PK_FINISH" + context.getGameResult()), (Object[])new Object[0]);
                }
                GameReportHelper.reportGameInfo(context.buildGameModel(), (int)(System.currentTimeMillis() - this.getGameStartTime()), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.FINISH.value(), 0, this.gameRunningContext.getGameResult(), this.isGoldGame);
                GameDataModel.instance.postGameResult(this.gameRunningContext.buildGameModel(), this.gameRunningContext.getGameResult());
                this.exitRoomWithType();
            }
        });
    }

    @Override
    public void onLoadGameFinishInner(GamePlayContext context, int finishType) {
        super.onLoadGameFinishInner(context, finishType);
        if (finishType == 2) {
            if (RuntimeContext.sIsDebuggable) {
                boolean isGameFirstPageOpen = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                if (isGameFirstPageOpen || isGameAutoOpen) {
                    this.exitRoom(1);
                } else {
                    this.onLoadFail();
                }
            } else {
                this.onLoadFail();
            }
            if (this.getCurrentGameLoader() != null) {
                this.getCurrentGameLoader().gameCode(2L);
            }
        } else if (finishType == 3) {
            GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.getGameStartTime()), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.OVER_TIME.value(), 0, this.isGoldGame);
            if (RuntimeContext.sIsDebuggable) {
                boolean isGameFirstPageOpen = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                if (isGameFirstPageOpen || isGameAutoOpen) {
                    this.exitRoom(1);
                } else {
                    this.timeoutFail();
                }
            } else {
                this.timeoutFail();
            }
        } else if (finishType == 0) {
            this.getCurrentGameLoader().gameCode(0L);
        }
    }

    @Override
    public void onPreGameExitInner(GamePlayContext context) {
        super.onPreGameExitInner(context);
        this.bizCollector.reportGameExit();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mExitRunable);
    }

    private void timeoutFail() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"timeoutFail", (Object[])new Object[0]);
        }
        if (this.gameRunningContext.getFrom().equals((Object)GameContextDef.JoinFrom.FROM_HAGO_GROUP)) {
            this.exitRoom(14);
        } else {
            this.exitRoom(4);
        }
    }

    void onLoadFail() {
        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_loading_fail), (int)0);
        if (this.gameRunningContext.getFrom().equals((Object)GameContextDef.JoinFrom.FROM_HAGO_GROUP)) {
            this.exitRoom(14);
        } else {
            this.exitRoom(4);
        }
        this.bizCollector.reportGameLoadFail();
    }

    @Override
    public void onGameExitedInner(GamePlayContext context, int exitType) {
        Object showResult;
        super.onGameExitedInner(context, exitType);
        HashMap ext = this.gameRunningContext.getExtendData();
        if (ext != null && (showResult = ext.get("key_show_result_mode")) instanceof String && StringUtils.equal((String)((String)showResult), (String)"2")) {
            this.setGameExitType(11);
        }
        this.bizCollector.reportGame(false);
        YYTaskExecutor.removeTask((Runnable)this.showSmileEmojiTask);
        this.curCounts = 0;
        if (this.getBaseGameView() != null) {
            YYTaskExecutor.postToMainThread(() -> {
                this.mIsHiddenFinish = true;
                int gameExitType = this.getGameExitType();
                if (gameExitType == 4) {
                    this.gotoIM(this.gameRunningContext);
                } else if (gameExitType == 5 || gameExitType == 11 || gameExitType == 12) {
                    this.mIsHiddenFinish = false;
                    this.getBaseGameView().destroyGameView();
                } else if (gameExitType == 6) {
                    this.gotoMatch();
                } else if (gameExitType == 14) {
                    this.goToChannel(this.gameRunningContext);
                } else {
                    boolean isFromGameChallenge = (Boolean)this.gameRunningContext.getExtendValue("from_game_challenge", (Object)false);
                    if (isFromGameChallenge) {
                        this.goToChannel(this.gameRunningContext);
                        return;
                    }
                    GameResultBean gameResultBean = this.gameRunningContext.getGameResultBean();
                    this.insertAndGetResultDataFromDB(gameResultBean);
                    boolean showNewRegisterGameResult = (Boolean)this.sendMessageSync(GameMsgDef.NEW_REGISTER_NEED_SHOW_GAME_RESULT);
                    int lastWinCounts = (Integer)this.sendMessageSync(GameMsgDef.NEW_REGISTER_LAST_WIN_COUNT);
                    if (showNewRegisterGameResult && lastWinCounts == 2 && gameResultBean != null && gameResultBean.getWinners() != null && gameResultBean.getWinners().contains(String.valueOf(AccountUtil.getUid()))) {
                        this.showStreakWinWindow(2);
                    } else if (!showNewRegisterGameResult && this.isShowStreakWin(gameResultBean)) {
                        this.showStreakWinWindow(4);
                    } else {
                        this.showGameResult(gameResultBean, this.gameRunningContext.getFrom().getId());
                    }
                    this.checkAndHandleStreakWinInterrupted();
                }
            });
        }
    }

    @Override
    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onWindowHidden == mIsHiddenFinish\uff1a" + this.mIsHiddenFinish), (Object[])new Object[0]);
        }
        if (abstractWindow == this.getBaseGameView().getGameWindow() && this.mIsHiddenFinish) {
            AbstractWindow window = abstractWindow;
            YYTaskExecutor.postToMainThread(() -> {
                if (window != null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"onWindowHidden_popWindow", (Object[])new Object[0]);
                    }
                    if (this.getBaseGameView() != null) {
                        this.getBaseGameView().destroyGameView();
                    }
                }
            });
            this.mIsHiddenFinish = false;
        }
    }

    private void checkAndHandleStreakWinInterrupted() {
        GameResultBean gameResultBean = this.gameRunningContext.getGameResultBean();
        if (this.streakWinInterruptedHelper.checkStreakWinInterrupted(gameResultBean)) {
            PKWinStreakPush pkWinStreakPush;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkAndHandleStreakWinInterrupted true", (Object[])new Object[0]);
            }
            if ((pkWinStreakPush = GameDataModel.instance.getWinStreakData()) == null) {
                return;
            }
            int winStreakCount = FP.orInt((Long)pkWinStreakPush.win_streak_count);
            String content = ResourceUtils.getString((int)R.string.winning_streak_interrupted_im_msg, (Object[])new Object[]{winStreakCount});
            StreakWinData streakWinData = StreakWinData.fromPKWinStreakPush((PKWinStreakPush)pkWinStreakPush);
            YYTaskExecutor.execute(() -> {
                String extra2 = JsonParser.toJson((Object)streakWinData);
                YYTaskExecutor.execute(() -> {
                    Pair pair = ImDataFactory.INSTANCE.sendStreakWinInterruptedMsg(10L, content, extra2);
                    ((ImService)this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMToDbMsg((ImMsgReqParam)pair.first, (ImMessageDBBean)pair.second, null);
                    this.streakWinInterruptedHelper.saveNotifyTime();
                });
            });
        }
    }

    private boolean isShowStreakWin(GameResultBean gameResultBean) {
        return this.mStreakWindowController.isStreakWinShow(gameResultBean);
    }

    private void showGameResult(GameResultBean gameResultBean, int gameFrom) {
        int mplPlayType = Integer.parseInt(this.gameRunningContext.getExtendValue("mpl_playType", (Object)0).toString());
        if (StringUtils.isNotEmpty((String)this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString()) && mplPlayType == 2) {
            this.showMplRankGameResult();
        } else {
            OnGameResultShowEvent onGameResultShowEvent = new OnGameResultShowEvent();
            GameDataCenter gameDataCenter = new GameDataCenter();
            gameDataCenter.setGameModel(this.gameRunningContext.buildGameModel());
            gameDataCenter.setGameRunningContext(this.gameRunningContext);
            gameDataCenter.setGameResultBean(gameResultBean);
            onGameResultShowEvent.setmGameDataCenter(gameDataCenter);
            onGameResultShowEvent.setmGameScene(gameFrom);
            this.beforeShowGameResult(onGameResultShowEvent);
            this.mGameResultWindowController.initWindow(onGameResultShowEvent, this.mHadSendEmoj);
        }
    }

    private void showMplRankGameResult() {
        String mplRoomId = (String)this.gameRunningContext.getExtendValue("mpl_id", (Object)"");
        OnMplRankGameResultShowEvent event = new OnMplRankGameResultShowEvent(this.gameRunningContext.getGameInfo().gid, this.gameRunningContext.getRoomId(), this.gameRunningContext);
        this.mMPLRankGameResultWindowController.showWindow(event);
    }

    protected void beforeShowGameResult(OnGameResultShowEvent event) {
    }

    @Override
    protected void onBackClick() {
        super.onBackClick();
        if (this.getBaseGameView() != null) {
            GameLoger.info("pkGame", "on show exit dialog", new Object[0]);
            this.getBaseGameView().showExitConfirmDialog(ResourceUtils.getString((int)R.string.game_exit_confirm), ResourceUtils.getString((int)R.string.ok), ResourceUtils.getString((int)R.string.str_button_cancel), new IGameDialogCallback(){

                public void onOk() {
                    GameLoger.info("pkGame", "on exit dialog ok click", new Object[0]);
                    PkGamePlayer.this.bizCollector.reportGameForceExit();
                    if (StringUtils.isEmpty((String)PkGamePlayer.this.gameRunningContext.getGameResult())) {
                        GameLoger.info("pkGame", "on user escape form game, gid:%s", PkGamePlayer.this.gameRunningContext.getGameInfo() != null ? ((PkGamePlayer)PkGamePlayer.this).gameRunningContext.getGameInfo().gid : "");
                        PkGamePlayer.this.getCocosMessageProxy().getGameProxyService().getBaseService().appGameExitWithType(PkGamePlayer.this.gameRunningContext.getRoomId(), PkGamePlayer.this.getCurPlayingGame().isWebGame() ? "hg.pkExit.notify" : "appGameExit");
                        YYTaskExecutor.postToMainThread((Runnable)PkGamePlayer.this.mExitRunable, (long)GAME_EXIT_TIMEOUT);
                    } else {
                        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                            public void run() {
                                try {
                                    PkGamePlayer.this.exitRoomWithType();
                                }
                                catch (Exception e) {
                                    MLog.error((Object)PkGamePlayer.TAG, (Throwable)e);
                                    PkGamePlayer.this.exitRoom(1);
                                }
                            }
                        });
                    }
                }

                public void onCancel() {
                    GameLoger.info("pkGame", "on exit dialog cancel click", new Object[0]);
                    if (PkGamePlayer.this.getBaseGameView() != null) {
                        PkGamePlayer.this.getBaseGameView().hideExitDialog();
                    }
                }
            });
        }
    }

    public void initFunViews(RelativeLayout container) {
        GameInfo gameInfo = this.gameRunningContext.getGameInfo();
        this.abstractFunctionLayer = null;
        if (gameInfo.getScreenDire() == 1) {
            this.abstractFunctionLayer = gameInfo.getRoomTemplate() == 1 ? new VerticalFuntionLayer((Activity)this.mContext, container) : (gameInfo.getRoomTemplate() == 3 ? new EmptyFuntionLayer((Activity)this.mContext, container) : new CustomerFuntionLayer((Activity)this.mContext, container));
        } else if (gameInfo.getScreenDire() == 2) {
            this.abstractFunctionLayer = gameInfo.getRoomTemplate() == 1 ? new HorizontalFuntionLayer((Activity)this.mContext, container) : (gameInfo.getRoomTemplate() == 3 ? new EmptyFuntionLayer((Activity)this.mContext, container) : new CustomerFuntionLayer((Activity)this.mContext, container));
        }
        if (this.abstractFunctionLayer != null) {
            this.abstractFunctionLayer.setCallback(this.iFunctionLayerCallback);
            this.abstractFunctionLayer.showViews(gameInfo);
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class, thread=1)
    public void onMyHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.mTopBarController != null) {
            this.mTopBarController.updateMyHeadFrameType(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache((int)((HeadFrameType)event.source()).headFrameType));
        }
    }

    @KvoMethodAnnotation(sourceClass=RoomUserMicStatus.class, thread=1, name="micOpen", flag=1)
    public void onMyMicStatusChange(KvoEventIntent event) {
        RoomUserMicStatus roomUserMicStatus = (RoomUserMicStatus)event.source();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"RoomUserMicStatus %s", (Object[])new Object[]{roomUserMicStatus.isMicOpen()});
        }
        if (this.mTopBarController == null) {
            return;
        }
        this.mTopBarController.updateMicStatusView(AccountUtil.getUid(), roomUserMicStatus.isMicOpen());
        this.mTopBarController.updateMicView(roomUserMicStatus.isMicOpen());
        if (roomUserMicStatus.isMicOpen()) {
            this.mVoiceStartTime = System.currentTimeMillis();
        }
        this.sendMicStatus();
    }

    private void sendMicStatus() {
        ArrayList<MicStatusBean> micStatusBeanList = new ArrayList<MicStatusBean>();
        if (this.mRoomSlot != null && this.mRoomSlot.room != null) {
            for (RoomUserMicStatus roomUserMicStatus : this.mRoomSlot.room.getRoomUserMicStatusList()) {
                micStatusBeanList.add(new MicStatusBean(Long.valueOf(roomUserMicStatus.getUid()), roomUserMicStatus.isMicOpen() ? 1 : 0));
            }
        }
        if (this.getAppNotifyGameRouter() != null) {
            this.getAppNotifyGameRouter().notifyGame(micStatusBeanList, AppNotifyGameDefine.OnMicStatusChangeNotify);
        }
    }

    private void queryUserMicStatus(final String reqJson, final IComGameCallAppCallBack gameCallAppCallBack) {
        YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                if (PkGamePlayer.this.mRoomSlot != null && ((PkGamePlayer)PkGamePlayer.this).mRoomSlot.room != null) {
                    try {
                        long tUid = ((GetRelationBean)JsonParser.parseJsonObject((String)reqJson, GetRelationBean.class)).getUid();
                        if (PkGamePlayer.this.mRoomSlot != null && ((PkGamePlayer)PkGamePlayer.this).mRoomSlot.room != null) {
                            boolean isHaveUser = false;
                            for (RoomUserMicStatus roomUserMicStatus : ((PkGamePlayer)PkGamePlayer.this).mRoomSlot.room.getRoomUserMicStatusList()) {
                                if (roomUserMicStatus.getUid() != tUid) continue;
                                isHaveUser = true;
                                MicStatusBean micStatusBean = new MicStatusBean(Long.valueOf(roomUserMicStatus.getUid()), roomUserMicStatus.isMicOpen() ? 1 : 0);
                                if (gameCallAppCallBack == null) continue;
                                gameCallAppCallBack.callGame((Object)micStatusBean);
                            }
                            if (!isHaveUser) {
                                MicStatusBean micStatusBean = new MicStatusBean(Long.valueOf(tUid), 0);
                                if (gameCallAppCallBack != null) {
                                    gameCallAppCallBack.callGame((Object)micStatusBean);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)PkGamePlayer.TAG, (Throwable)e);
                    }
                }
            }
        });
    }

    @KvoMethodAnnotation(sourceClass=RoomUserMicStatus.class, thread=1, name="micOpen", flag=2)
    public void onOtherMicStatusChange(KvoEventIntent event) {
        RoomUserMicStatus roomUserMicStatus = (RoomUserMicStatus)event.source();
        ((TopBarController)this.iFunctionLayerCallback.getTopBarController()).updateMicStatusView(roomUserMicStatus.getUid(), roomUserMicStatus.isMicOpen());
        this.sendMicStatus();
    }

    @KvoMethodAnnotation(sourceClass=UserSpeakStatus.class, name="state", thread=1, flag=1)
    public void onMySpeakStatusChange(KvoEventIntent event) {
        UserSpeakStatus userSpeakStatus = (UserSpeakStatus)event.source();
        if (this.mRoomSlot != null && this.mRoomSlot.room != null && this.mRoomSlot.room.getMyStatus().isMicOpen()) {
            ((TopBarController)this.iFunctionLayerCallback.getTopBarController()).updateLeftVoice(userSpeakStatus.getStatus() != 0);
            this.sendSpeakingStatus(userSpeakStatus);
        }
    }

    @KvoMethodAnnotation(sourceClass=UserSpeakStatus.class, name="state", thread=1, flag=2)
    public void onOtherSpeakStatusChange(KvoEventIntent event) {
        UserSpeakStatus userSpeakStatus = (UserSpeakStatus)event.source();
        if (this.mRoomSlot != null && this.mRoomSlot.room != null && this.mRoomSlot.room.getOtherStatus().isMicOpen()) {
            this.mTopBarController.updateRightVoice(userSpeakStatus.getStatus() != 0);
            this.sendSpeakingStatus(userSpeakStatus);
        }
    }

    private synchronized void sendSpeakingStatus(UserSpeakStatus speakStatuses) {
        YYTaskExecutor.execute(() -> {
            try {
                if (speakStatuses == null) {
                    return;
                }
                ArrayList<GameUserSpeakStatus> speakStatusesList = new ArrayList<GameUserSpeakStatus>();
                GameUserSpeakStatus gameUserSpeakStatus = new GameUserSpeakStatus(speakStatuses.getUid(), speakStatuses.getStatus());
                speakStatusesList.add(gameUserSpeakStatus);
                if (!this.isExitIng() && this.getAppNotifyGameRouter() != null) {
                    this.getAppNotifyGameRouter().notifyGame(speakStatusesList, AppNotifyGameDefine.OnSpeakStatusChangeNotify);
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        });
    }

    @Override
    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        this.initAfterWindowAttach();
    }

    public void initAfterWindowAttach() {
        this.mRoomSlot = ((IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class)).joinRoom(this.mSessionId, 1, null);
        this.bindingRoomData(this.mRoomSlot);
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).registerGameMsgListener(this.mGameMsgListener);
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.destoryMicWhenDetach();
        if (this.mMessageBarrageViewController != null) {
            this.mMessageBarrageViewController.onWindowDetach(abstractWindow);
            this.mMessageBarrageViewController = null;
        }
        this.mTopBarController = null;
        this.mExpressBarController = null;
        YYTaskExecutor.removeTask((Runnable)this.showSmileEmojiTask);
        this.curCounts = 0;
    }

    void destoryMicWhenDetach() {
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).unRegisterGameMsgListener(this.mGameMsgListener);
        if (this.mRoomSlot != null && this.mRoomSlot.room != null && this.mRoomSlot.room.getMyStatus().isMicOpen() && this.mRoomSlot.room.getOtherStatus().isMicOpen()) {
            ((IHonorService)this.getServiceManager().getService(IHonorService.class)).reportOpenSoundHonorTask();
        }
        if (this.mRoomSlot != null && this.mRoomSlot.room != null && this.gameRunningContext.getOtherUserInfo() != null && this.gameRunningContext.getGameInfo() != null) {
            this.bizCollector.reportOutMic(this.mRoomSlot);
            this.unBindingRoomData(this.mRoomSlot);
            this.mRoomService.leaveRoom(this.mRoomSlot, 5);
        }
    }

    private void unBindingRoomData(RoomSlot<AbsVoiceRoom> roomSlot) {
        if (roomSlot.room != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"unRoomDataBinding", (Object[])new Object[0]);
            }
            if (roomSlot.room.mMyStatus != null) {
                this.mBinder.clearKvoConnectionWithFlag((KvoSource)roomSlot.room.mMyStatus, 1);
            }
            if (roomSlot.room.mOtherStatus != null) {
                this.mBinder.clearKvoConnectionWithFlag((KvoSource)roomSlot.room.mOtherStatus, 2);
            }
            this.unBindSpeak(AccountUtil.getUid(), 1);
            if (this.gameRunningContext.getOtherUserInfo() != null) {
                this.unBindSpeak(this.gameRunningContext.getOtherUserInfo().getUid(), 2);
            }
        }
    }

    private void bindingRoomData(RoomSlot<AbsVoiceRoom> roomSlot) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"bindingRoomData", (Object[])new Object[0]);
        }
        if (roomSlot.room != null) {
            this.micInitState = roomSlot.room.mMyStatus.isMicOpen() ? 1 : 0;
            this.mBinder.singleBindSourceWithFlag((KvoSource)roomSlot.room.mMyStatus, 1);
            if (roomSlot.room != null) {
                this.mBinder.singleBindSourceWithFlag((KvoSource)roomSlot.room.mOtherStatus, 2);
            }
            this.bindSpeak(AccountUtil.getUid(), 1);
            if (this.gameRunningContext.getOtherUserInfo() != null) {
                this.bindSpeak(this.gameRunningContext.getOtherUserInfo().uid, 2);
            }
        }
    }

    private void bindSpeak(long uid, int flag) {
        UserSpeakStatus userSpeakBean = (UserSpeakStatus)this.mRoomService.getSpeaks().get(uid);
        if (this.mRoomService.getSpeaks().get(uid) == null) {
            userSpeakBean = new UserSpeakStatus(uid, 0);
            this.mRoomService.getSpeaks().put(uid, userSpeakBean);
        }
        this.mBinder.singleBindSourceWithFlag((KvoSource)userSpeakBean, flag);
    }

    private void unBindSpeak(long uid, int flag) {
        UserSpeakStatus userSpeakBean = (UserSpeakStatus)this.mRoomService.getSpeaks().get(uid);
        if (userSpeakBean != null) {
            this.mBinder.clearKvoConnectionWithFlag((KvoSource)userSpeakBean, flag);
        }
    }

    @Override
    public void leaveGameExt() {
        this.exitRoom(5);
    }

    public void gotoIM(GamePlayContext gameRunningContext) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.IM_ROOM_SHOW;
        Bundle bundle = new Bundle();
        bundle.putLong("target_uid", this.targetUid);
        bundle.putString("im_game_id", gameRunningContext.getGameInfo().getGid());
        bundle.putInt("bundle_im_from", 4);
        bundle.putInt("im_page_scene", 1);
        bundle.putBoolean("im_game_panel", true);
        msg.setData(bundle);
        this.sendMessageSync(msg);
    }

    void gotoMatch() {
        GameMatchContext gameMatchContext = new GameMatchContext(GameContextDef.JoinFrom.FROM_HOME);
        if (StringUtils.isNotEmpty((String)this.gameRunningContext.getExtendValue("mpl_id", (Object)"").toString()) && this.gameRunningContext.getExtendData() != null) {
            gameMatchContext.addAllExtendValue((Map)this.gameRunningContext.getExtendData());
        }
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).matchGame(this.gameRunningContext.getGameInfo(), gameMatchContext, null);
    }

    @Override
    protected void resetLocal() {
        super.resetLocal();
        this.gameResultWebBean = null;
        this.abstractFunctionLayer = null;
    }

    private void showStreakWinWindow(int showType) {
        this.mStreakWindowController.initSteakWin(this.gameRunningContext.getGameResultBean(), showType);
    }

    @Override
    public BaseGameCallAppRouter getCustomerGameCallAPPRouter() {
        return new PkGameCallAppRouter(this.getEnvironment(), this.getCocosMessageProxy().getCocosProxyController(), this.mIPkGameCallAppCallback);
    }

    private void goToChannel(@NonNull GamePlayContext context) {
        String channelId = (String)context.getExtendValue("extend_channel_id", (Object)"");
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        EnterParam enterParam = EnterParam.obtain((String)channelId, (int)29);
        enterParam.pwdToken = (String)this.gameRunningContext.getExtendValue("KEY_CHANNEL_INVITE_TOKEN", (Object)"");
        boolean isFromGameHall = (Boolean)context.getExtendValue("from_game_hall", (Object)false);
        boolean isFromGameChallenge = (Boolean)this.gameRunningContext.getExtendValue("from_game_challenge", (Object)false);
        enterParam.subPage = isFromGameHall ? 1 : (isFromGameChallenge ? 2 : 0);
        message.obj = enterParam;
        this.sendMessage(message);
    }

    public WindowGameView initGameView() {
        GameWindowConfig gameWindowConfig = new GameWindowConfig(this.gameRunningContext.getGameInfo().isSupportFullScreen());
        AbsGameWindow gameWindow = new AbsGameWindow((Context)this.mContext, (UICallBacks)this, AbstractWindow.WindowLayerType.USE_ALL_LAYER, gameWindowConfig){

            @Override
            public void initCusFuncView(RelativeLayout container) {
                PkGamePlayer.this.initFunViews(container);
            }

            @Override
            public void onLoadGameBg(RecycleImageView bgView) {
                bgView.setAutoTransforToWebpFlag(false);
                LoadGamePageManager.getInstance().loadGameLoadingPage(bgView, PkGamePlayer.this.gameRunningContext.getGameInfo().getGid());
            }
        };
        gameWindow.getLoadingPage().setCallBack(new GameLoadingPage.ILoadingViewCallback(){

            @Override
            public void onCloseClick() {
                PkGamePlayer.this.exitRoom(1002, 2);
            }

            @Override
            public long closeTimer() {
                return 0L;
            }

            @Override
            public int loadingPageType() {
                if (GameInfo.isNewGameLoad((GameInfo)PkGamePlayer.this.gameRunningContext.getGameInfo())) {
                    return 2;
                }
                return 1;
            }

            @Override
            public DResource getCusLoadingSvgaKey() {
                return null;
            }

            @Override
            public List<String> getLoadingTips() {
                return PkGamePlayer.this.getCurrentGameLoader().getGameLoadingTips();
            }
        });
        gameWindow.getLoadingPage().updateClose(false);
        return new WindowGameView(gameWindow, this.mIWindowGameViewCallback);
    }

    @Override
    public void onFullScreenShortCutChange(boolean isShortCut) {
        super.onFullScreenShortCutChange(isShortCut);
        this.abstractFunctionLayer.offsetCutmode(isShortCut);
    }

    private class ShowAiSmileTask
    implements Runnable {
        ShowAiSmileTask() {
        }

        @Override
        public void run() {
            if (PkGamePlayer.this.curCounts < 3 && PkGamePlayer.this.abstractFunctionLayer != null) {
                EmojiBean smile = EmojiBean.newBuilder().id(1).build();
                PkGamePlayer.this.abstractFunctionLayer.showEmojOther(smile);
                PkGamePlayer.this.curCounts++;
                YYTaskExecutor.postToMainThread((Runnable)this, (long)300L);
            }
        }
    }

    class BizCollector {
        private static final String GAME_ID = "game_id";
        private static final String CRASH = "Crash_";

        BizCollector() {
        }

        void reportGame(boolean isStart) {
            String gameId = SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)PkGamePlayer.this.mContext, GAME_ID, 0).getString(GAME_ID, "");
            if (isStart) {
                if (StringUtils.isNotEmpty((String)gameId)) {
                    HiidoStatis.reportReturnCode((String)(CRASH + SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)PkGamePlayer.this.mContext, GAME_ID, 0).getString(GAME_ID, "")), (long)0L, (String)"");
                }
                gameId = PkGamePlayer.this.gameRunningContext.getGameInfo().getGid();
                if (PkGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("function_id", "load").put("gid", gameId).put("game_type", String.valueOf(PkGamePlayer.this.gameRunningContext.getGameInfo().getGameMode())));
                }
                AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent().eventId("entergame"));
            } else {
                gameId = "";
                GameDataModel.instance.postGameLeave(PkGamePlayer.this.gameRunningContext, PkGamePlayer.this.gameRunningContext.getFrom().getId());
                if (PkGamePlayer.this.mRoomSlot != null && ((PkGamePlayer)PkGamePlayer.this).mRoomSlot.room != null && ((PkGamePlayer)PkGamePlayer.this).mRoomSlot.room.mMyStatus.isMicOpen()) {
                    if (PkGamePlayer.this.mVoiceStartTime > 0L) {
                        PkGamePlayer.this.tap = Math.abs((System.currentTimeMillis() - PkGamePlayer.this.mVoiceStartTime) / 1000L);
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "end_mic").put("link_time", String.valueOf(PkGamePlayer.this.tap)).put("act_uid", String.valueOf(PkGamePlayer.this.targetUid)).put("roomid", PkGamePlayer.this.gameRunningContext.getRoomId()).put("gid", PkGamePlayer.this.gameRunningContext.getGameInfo().getGid()));
                    }
                    PkGamePlayer.this.mVoiceStartTime = 0L;
                }
                if (PkGamePlayer.this.gameRunningContext.getGameInfo() != null && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PkGamePlayer.TAG, (String)"GAME_ROOM_leave,current_gid=%s,room_id=%s", (Object[])new Object[]{PkGamePlayer.this.gameRunningContext.getGameInfo().getGid(), PkGamePlayer.this.gameRunningContext.getRoomId()});
                }
            }
            SharedPreferences mSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)PkGamePlayer.this.mContext, GAME_ID, 0);
            SharedPreferences.Editor edit = mSharedPreferences.edit();
            edit.putString(GAME_ID, gameId);
            edit.apply();
        }

        void reportQuickMsgs() {
            if (PkGamePlayer.this.gameRunningContext.getGameInfo() != null && PkGamePlayer.this.gameRunningContext.getGameInfo().isQuickNews() && PkGamePlayer.this.gameRunningContext.getOtherUserInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "quick_msg_show").put("act_uid", String.valueOf(PkGamePlayer.this.gameRunningContext.getOtherUserInfo().getUid())).put("roomid", PkGamePlayer.this.gameRunningContext.getRoomId()).put("gid", PkGamePlayer.this.gameRunningContext.getGameInfo().getGid()));
            }
        }

        void reportGameLoadFinish() {
            if (PkGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("function_id", "load_success").put("match_time", String.valueOf(System.currentTimeMillis() - PkGamePlayer.this.getGameStartTime())).put("gid", PkGamePlayer.this.gameRunningContext.getGameInfo().getGid()).put("game_type", String.valueOf(PkGamePlayer.this.gameRunningContext.getGameInfo().getGameMode())));
            }
            if (PkGamePlayer.this.gameRunningContext.getGameInfo() != null && PkGamePlayer.this.gameRunningContext.getOtherUserInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "show").put("act_uid", String.valueOf(PkGamePlayer.this.gameRunningContext.getOtherUserInfo().getUid())).put("roomid", PkGamePlayer.this.gameRunningContext.getRoomId()).put("gid", PkGamePlayer.this.gameRunningContext.getGameInfo().getGid()));
            }
            GameReportHelper.reportGameInfo(PkGamePlayer.this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - PkGamePlayer.this.getGameStartTime()), PkGamePlayer.this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.LOAD_FINISH.value(), 0, PkGamePlayer.this.isGoldGame);
        }

        void reportGameLoadFail() {
            if (PkGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("function_id", "load_fail").put("match_time", String.valueOf(System.currentTimeMillis() - PkGamePlayer.this.getGameStartTime())).put("gid", PkGamePlayer.this.gameRunningContext.getGameInfo().getGid()).put("game_type", String.valueOf(PkGamePlayer.this.gameRunningContext.getGameInfo().getGameMode())));
            }
            GameReportHelper.reportGameInfo(PkGamePlayer.this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - PkGamePlayer.this.getGameStartTime()), PkGamePlayer.this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.LOAD_FAIL.value(), 0, PkGamePlayer.this.isGoldGame);
        }

        void reportGameExit() {
            if (PkGamePlayer.this.gameRunningContext.getOtherUserInfo() != null && PkGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("is_exit", "1").put("game_type", String.valueOf(PkGamePlayer.this.gameRunningContext.getGameInfo().getGameMode())).put("gid", PkGamePlayer.this.gameRunningContext.getGameInfo().getGid()));
            }
        }

        void reportGameForceExit() {
            if (PkGamePlayer.this.gameRunningContext.getOtherUserInfo() != null && PkGamePlayer.this.gameRunningContext.getGameInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "ext").put("act_uid", String.valueOf(PkGamePlayer.this.gameRunningContext.getOtherUserInfo().getUid())).put("roomid", PkGamePlayer.this.gameRunningContext.getRoomId()).put("gid", PkGamePlayer.this.gameRunningContext.getGameInfo().getGid()));
                if (PkGamePlayer.this.isGameStarted() && PkGamePlayer.this.gameResultWebBean == null) {
                    GameDataModel.instance.postGameForceExit(PkGamePlayer.this.gameRunningContext.buildGameModel(), PkGamePlayer.this.gameRunningContext.getFrom().getId());
                }
            }
        }

        void reportOutMic(RoomSlot<AbsVoiceRoom> mRoomSlot) {
            HiidoEvent micEvent = HiidoEvent.obtain().eventId("20023777").put("act_uid", String.valueOf(PkGamePlayer.this.targetUid)).put("roomid", PkGamePlayer.this.gameRunningContext.getRoomId()).put("gid", PkGamePlayer.this.gameRunningContext.getGameInfo().getGid());
            if (mRoomSlot != null && mRoomSlot.room != null && mRoomSlot.room.mMyStatus != null) {
                micEvent.put("out_mic_state", String.valueOf(mRoomSlot.room.mMyStatus.isMicOpen() ? 1 : 0));
            } else {
                micEvent.put("out_mic_state", String.valueOf(0));
            }
            micEvent.put("enter_mic_state", String.valueOf(PkGamePlayer.this.micInitState));
            HiidoStatis.reportEvent((HiidoEvent)micEvent);
        }
    }
}

