/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame;

import com.yy.appbase.kvo.UserInfoKS;
import com.yy.framework.core.Environment;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.AbsGameController;
import com.yy.game.gamemodule.base.AbsGameMatcher;
import com.yy.game.gamemodule.base.AbsGamePlayer;
import com.yy.game.gamemodule.base.AbsGameSelecter;
import com.yy.game.gamemodule.pkgame.Pk2v2GamePlayer;
import com.yy.game.gamemodule.pkgame.PkGamePlayer;
import com.yy.game.gamemodule.pkgame.match.DoubleTeamMatch;
import com.yy.game.gamemodule.pkgame.match.PkGameMatcher;
import com.yy.game.gamemodule.pkgame.match.TwoVsTwoMatcher;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.Game2V2MatchContext;
import com.yy.hiyo.game.service.bean.Game2v2PlayContext;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.pkgame.PkGamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.game.service.protocol.ISelectCallBack;
import java.util.HashMap;
import java.util.Map;

public class PkGameController
extends AbsGameController {
    private final HashMap<Integer, AbsGameMatcher> mGameMatchers = new HashMap();
    private final HashMap<Integer, AbsGamePlayer> mGamePlayers = new HashMap();

    public PkGameController(Environment env, int gameModule) {
        super(env, gameModule);
    }

    @Override
    public synchronized AbsGamePlayer createPlayer(IGameLifecycle lifecycleCallback) {
        this.mPlayer = this.mGamePlayers.get(this.gameModule);
        if (this.mPlayer != null) {
            return this.mPlayer;
        }
        this.mPlayer = this.gameModule == 7 ? new Pk2v2GamePlayer(this.getEnvironment(), lifecycleCallback) : new PkGamePlayer(this.getEnvironment(), lifecycleCallback);
        this.mGamePlayers.put(this.gameModule, this.mPlayer);
        return this.mPlayer;
    }

    @Override
    public synchronized AbsGameMatcher createMatcher(IMatchGameLifecycle callback2) {
        AbsGameMatcher matcher = null;
        matcher = this.mGameMatchers.get(this.gameModule);
        if (matcher != null) {
            return matcher;
        }
        if (this.gameModule == 1) {
            matcher = new PkGameMatcher(this.getEnvironment(), callback2);
        } else if (this.gameModule == 5) {
            matcher = new DoubleTeamMatch(this.getEnvironment(), callback2);
        } else if (this.gameModule == 7) {
            matcher = new TwoVsTwoMatcher(this.getEnvironment(), callback2);
        }
        this.mGameMatchers.put(this.gameModule, matcher);
        return matcher;
    }

    @Override
    public AbsGameSelecter createSelecter(ISelectCallBack callBack) {
        return null;
    }

    @Override
    public int joinGame(GameInfo info, GamePlayContext context) {
        return super.joinGame(info, context);
    }

    @Override
    protected void onGameExitedInner(GamePlayContext context, int gameExitType) {
        super.onGameExitedInner(context, gameExitType);
    }

    @Override
    public void innerMatchFinish(GameInfo info, GameMatchContext matchConfig, int matchType) {
        super.innerMatchFinish(info, matchConfig, matchType);
        if (((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).isPlaying()) {
            GameLoger.error("baseGame", "pkGame\u5339\u914d\u6210\u529f\u540e\u6709\u6e38\u620f\u8fd0\u884c\u4e2d\u5f02\u5e38");
            return;
        }
        if (matchType == 0) {
            if (info.getGameMode() == 1 || info.getGameMode() == 5) {
                UserInfoKS myInfo = matchConfig.getMyUserInfoKS();
                UserInfoKS otherInfo = matchConfig.getOtherUserInfoKs();
                if (myInfo == null || otherInfo == null) {
                    GameLoger.error("baseGame", "pkGame\u5339\u914d\u6210\u529f\u540e\u8bfb\u53d6\u6211\u7684\u6216\u5bf9\u65b9\u7684\u4fe1\u606f\u4e3a\u7a7a");
                    return;
                }
                PkGamePlayContext gamePlayContext = new PkGamePlayContext(GameContextDef.JoinFrom.FROM_MATCH);
                gamePlayContext.setPkMatchContext(matchConfig);
                gamePlayContext.setGameUrl(matchConfig.getUrl());
                gamePlayContext.setGameInfo(info);
                gamePlayContext.setRoomId(matchConfig.getRoomId());
                gamePlayContext.updateUserInfo(myInfo.getUid(), myInfo);
                gamePlayContext.updateUserInfo(otherInfo.getUid(), otherInfo);
                if (matchConfig.getExtendData() != null) {
                    gamePlayContext.addAllExtendValue((Map)matchConfig.getExtendData());
                }
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(info, (GamePlayContext)gamePlayContext);
            } else if (info.getGameMode() == 7) {
                Game2v2PlayContext gamePlayContext = new Game2v2PlayContext(GameContextDef.JoinFrom.FROM_MATCH);
                gamePlayContext.setPkMatchContext(matchConfig);
                if (matchConfig instanceof Game2V2MatchContext) {
                    gamePlayContext.setMyUsersMap(((Game2V2MatchContext)matchConfig).getMineTeamUserMap());
                    gamePlayContext.setOtherUsersMap(((Game2V2MatchContext)matchConfig).getOtherTeamUserMap());
                }
                gamePlayContext.setGameUrl(matchConfig.getUrl());
                gamePlayContext.setGameInfo(info);
                gamePlayContext.setRoomId(matchConfig.getRoomId());
                if (matchConfig.getExtendData() != null) {
                    gamePlayContext.addAllExtendValue((Map)matchConfig.getExtendData());
                }
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(info, (GamePlayContext)gamePlayContext);
            }
        }
    }
}

