/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.pkgame;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.AppsFlyerEvent;
import com.yy.appbase.appsflyer.AppsFlyerHelper;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.service.model.RoomUserMicStatus;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.game.R;
import com.yy.game.bean.EmojiBean;
import com.yy.game.bean.GameDataModel;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.pkgame.PkGamePlayer;
import com.yy.game.module.gameroom.barrageview.IBarrageViewUiCallback;
import com.yy.game.module.gameroom.barrageview.MessageBarrageView;
import com.yy.game.module.gameroom.barrageview.MessageBarrageViewController;
import com.yy.game.module.gameroom.expressionbar.ExpressBarController;
import com.yy.game.module.gameroom.expressionbar.IExpressBarUiCallback;
import com.yy.game.module.gameroom.topbar.ITopBarUiCallback;
import com.yy.game.module.gameroom.topbar.TopBar2v2Controller;
import com.yy.game.module.gameroom.ui.CustomerFuntionLayer;
import com.yy.game.module.gameroom.ui.EmptyFuntionLayer;
import com.yy.game.module.gameroom.ui.Horizontal2V2FuntionLayer;
import com.yy.game.module.gameroom.ui.I2v2LayerFuntion;
import com.yy.game.module.gameroom.ui.IFunctionLayerCallback;
import com.yy.game.module.gameroom.ui.Vertical2V2FuntionLayer;
import com.yy.game.module.jscallappmodule.model.GetRelationBean;
import com.yy.game.msg.OnGameResultShowEvent;
import com.yy.game.utils.GameReportHelper;
import com.yy.game.utils.GameStateDef;
import com.yy.hiyo.game.base.BarrageInfo;
import com.yy.hiyo.game.base.IGameMsgListener;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameMessageService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.Game2V2MatchContext;
import com.yy.hiyo.game.service.bean.Game2v2PlayContext;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.voice.base.bean.GameUserSpeakStatus;
import com.yy.hiyo.voice.base.bean.MicStatusBean;
import com.yy.hiyo.voice.base.bean.UserSpeakStatus;
import com.yy.hiyo.voice.base.roomvoice.AbsVoiceRoom;
import com.yy.hiyo.voice.base.roomvoice.IRoomManagerService;
import com.yy.hiyo.voice.base.roomvoice.MultiplayerRoom;
import com.yy.hiyo.voice.base.roomvoice.RoomSlot;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Pk2v2GamePlayer
extends PkGamePlayer {
    private static final String TAG = "Pk2v2GamePlayer";
    TopBar2v2Controller mTopBar2v2Controller;
    UserInfoKS mineUserInfoKS;
    UserInfoKS friendsUserInfoKS;
    UserInfoKS otherLeftUserInfoKS;
    UserInfoKS otherRightUserInfoKS;
    boolean isFriendLeave = false;
    private RoomSlot<AbsVoiceRoom> m2V2VoiceRoom;
    IFunctionLayerCallback i2v2FunctionLayerCallback = new IFunctionLayerCallback(){

        @Override
        public synchronized TopBar2v2Controller getTopBarController() {
            if (Pk2v2GamePlayer.this.mTopBar2v2Controller == null) {
                Pk2v2GamePlayer.this.mTopBar2v2Controller = new TopBar2v2Controller(new ITopBarUiCallback(){

                    @Override
                    public void onBackClick() {
                        Pk2v2GamePlayer.this.onBackClick();
                    }

                    @Override
                    public void onMicClick() {
                        Pk2v2GamePlayer.this.onMicClickInner();
                    }

                    @Override
                    public void onUserClick(long uid) {
                        if (uid != AccountUtil.getUid()) {
                            Pk2v2GamePlayer.this.showProfileCard(uid);
                        }
                    }
                }, Pk2v2GamePlayer.this.getEnvironment());
            }
            return Pk2v2GamePlayer.this.mTopBar2v2Controller;
        }

        @Override
        public synchronized ExpressBarController getExpressBarController() {
            if (Pk2v2GamePlayer.this.mExpressBarController == null) {
                Pk2v2GamePlayer.this.mExpressBarController = new ExpressBarController(new IExpressBarUiCallback(){

                    @Override
                    public void onSendEmotionClick(final EmojiBean bean) {
                        if (bean == null) {
                            return;
                        }
                        if (Pk2v2GamePlayer.this.gameRunningContext.getOtherUserInfo() != null && Pk2v2GamePlayer.this.gameRunningContext.getGameInfo() != null) {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "emoji").put("emoji_id", String.valueOf(bean.getId())).put("act_uid", String.valueOf(((Pk2v2GamePlayer)Pk2v2GamePlayer.this).gameRunningContext.getOtherUserInfo().uid)).put("roomid", Pk2v2GamePlayer.this.gameRunningContext.getRoomId()).put("gid", Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid()));
                        }
                        if (Pk2v2GamePlayer.this.abstractFunctionLayer instanceof I2v2LayerFuntion) {
                            ((I2v2LayerFuntion)((Object)Pk2v2GamePlayer.this.abstractFunctionLayer)).showEmojMe(bean);
                        }
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (!Pk2v2GamePlayer.this.mHadSendEmoj) {
                                    ((IHonorService)Pk2v2GamePlayer.this.getServiceManager().getService(IHonorService.class)).reportSendEmojHonorTask();
                                }
                                Pk2v2GamePlayer.this.mHadSendEmoj = true;
                                ((IGameMessageService)Pk2v2GamePlayer.this.getServiceManager().getService(IGameMessageService.class)).sendMsgReqBroadcast(JsonParser.toJson((Object)bean), Pk2v2GamePlayer.this.gameRunningContext.getRoomId(), 1L);
                            }
                        });
                    }
                }, Pk2v2GamePlayer.this.getEnvironment());
            }
            return Pk2v2GamePlayer.this.mExpressBarController;
        }

        @Override
        public synchronized MessageBarrageViewController getMessageBarrageViewController() {
            if (Pk2v2GamePlayer.this.mMessageBarrageViewController == null) {
                Pk2v2GamePlayer.this.mMessageBarrageViewController = new MessageBarrageViewController(new IBarrageViewUiCallback(){

                    @Override
                    public void onSendMessageBarrage(String barrageMsg) {
                        if (TextUtils.isEmpty((CharSequence)barrageMsg)) {
                            return;
                        }
                        UserInfoBean myUserInfo = ((IUserInfoService)Pk2v2GamePlayer.this.getServiceManager().getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid(), null);
                        if (myUserInfo != null) {
                            ((IGameMessageService)Pk2v2GamePlayer.this.getServiceManager().getService(IGameMessageService.class)).sendMsgReq(Pk2v2GamePlayer.this.gameRunningContext.getRoomId(), myUserInfo, barrageMsg);
                        }
                    }
                }, Pk2v2GamePlayer.this.getEnvironment());
            }
            return Pk2v2GamePlayer.this.mMessageBarrageViewController;
        }
    };
    private IGameMsgListener m2v2GameMsgListener = new IGameMsgListener(){

        public void onExpressNotify(long senderUid, String value) {
        }

        public void onExpressBrocstNotify(final String barcastId, final long uid, final String value) {
            try {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!StringUtils.equals((String)barcastId, (String)Pk2v2GamePlayer.this.gameRunningContext.getRoomId())) {
                            return;
                        }
                        final EmojiBean emojiBean = (EmojiBean)JsonParser.parseJsonObject((String)value, EmojiBean.class);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (emojiBean != null && Pk2v2GamePlayer.this.abstractFunctionLayer instanceof I2v2LayerFuntion) {
                                    if (uid == Pk2v2GamePlayer.this.friendsUserInfoKS.getUid()) {
                                        ((I2v2LayerFuntion)((Object)Pk2v2GamePlayer.this.abstractFunctionLayer)).showEmojFriends(emojiBean);
                                    }
                                    if (uid == Pk2v2GamePlayer.this.otherLeftUserInfoKS.getUid()) {
                                        ((I2v2LayerFuntion)((Object)Pk2v2GamePlayer.this.abstractFunctionLayer)).showEmojOtherLeft(emojiBean);
                                    }
                                    if (uid == Pk2v2GamePlayer.this.otherRightUserInfoKS.getUid()) {
                                        ((I2v2LayerFuntion)((Object)Pk2v2GamePlayer.this.abstractFunctionLayer)).showEmojOtherRight(emojiBean);
                                    }
                                }
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                MLog.error((Object)Pk2v2GamePlayer.TAG, (Throwable)e);
            }
        }

        public void onSendMsgRes() {
        }

        public void onJoinRoomSuccess() {
        }

        public void onJoinRoomFail(long code) {
        }

        public void onBarrageNotify(final BarrageInfo value, final String id2, final int type) {
            try {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!(type != 1 || TextUtils.isEmpty((CharSequence)id2) || TextUtils.isEmpty((CharSequence)Pk2v2GamePlayer.this.gameRunningContext.getRoomId()) || id2.equals(Pk2v2GamePlayer.this.gameRunningContext.getRoomId()))) {
                            return;
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MessageBarrageView messageBarrageView = null;
                                if (value != null && value.user != null && value.mDanmu != null && Pk2v2GamePlayer.this.mMessageBarrageViewController != null && (messageBarrageView = Pk2v2GamePlayer.this.mMessageBarrageViewController.getMessageBarrageView(Pk2v2GamePlayer.this.gameRunningContext.getGameInfo())) != null) {
                                    messageBarrageView.showBarrageView(value.user.avatar, value.mDanmu.txt, -16126);
                                }
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                MLog.error((Object)Pk2v2GamePlayer.TAG, (Throwable)e);
            }
        }
    };

    public Pk2v2GamePlayer(Environment env, IGameLifecycle callback2) {
        super(env, callback2);
        this.bizCollector = new Biz2v2Conllector();
    }

    @Override
    public CocosProxyType[] getSupportedCocosProxyType() {
        return new CocosProxyType[]{CocosProxyType.hideKeyboard, CocosProxyType.getOpenScene, CocosProxyType.micStatusQuery, CocosProxyType.postGameResult, CocosProxyType.gameForceExit, CocosProxyType.showInputBarrageView, CocosProxyType.updateBarrageViewTopPosition, CocosProxyType.notifyTeamChange};
    }

    @Override
    public int preLoadGame(GamePlayContext gamePlayContext) {
        if (gamePlayContext instanceof Game2v2PlayContext && (((Game2v2PlayContext)gamePlayContext).getMyUsersMap() == null || ((Game2v2PlayContext)gamePlayContext).getOtherUsersMap() == null || this.gameRunningContext.getGameInfo() == null || StringUtils.isEmpty((String)gamePlayContext.getGameUrl()))) {
            return 1;
        }
        if (gamePlayContext instanceof Game2v2PlayContext) {
            int num = 0;
            for (UserInfoKS userInfoKS : ((Game2v2PlayContext)gamePlayContext).getOtherUsersMap().values()) {
                if (num == 0) {
                    this.otherLeftUserInfoKS = userInfoKS;
                } else {
                    this.otherRightUserInfoKS = userInfoKS;
                }
                ++num;
            }
            for (UserInfoKS userInfoKS : ((Game2v2PlayContext)gamePlayContext).getMyUsersMap().values()) {
                if (userInfoKS.getUid() != AccountUtil.getUid()) {
                    this.friendsUserInfoKS = userInfoKS;
                    continue;
                }
                this.mineUserInfoKS = userInfoKS;
            }
            if (this.mineUserInfoKS == null || this.friendsUserInfoKS == null || this.otherRightUserInfoKS == null || this.otherLeftUserInfoKS == null) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void initDate(GamePlayContext context) {
        this.mSessionId = context.getRoomId();
    }

    @Override
    public void initView(GamePlayContext context) {
        if (context instanceof Game2v2PlayContext) {
            Game2v2PlayContext game2v2PlayContext = (Game2v2PlayContext)context;
            HeadFrameType headFrameType = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getHeadFrameType();
            Kvo.addKvoBinding((KvoSource)headFrameType, (Object)this, (String)"onMyHeadFrameTypeUpdate");
            if (this.mTopBar2v2Controller != null) {
                this.mTopBar2v2Controller.updateMineInfoView(this.mineUserInfoKS);
                this.mTopBar2v2Controller.updateFriendInfoView(this.friendsUserInfoKS);
                this.mTopBar2v2Controller.updateOtherLeftInfoView(this.otherLeftUserInfoKS);
                this.mTopBar2v2Controller.updateOtherRightInfoView(this.otherRightUserInfoKS);
            }
        }
    }

    @Override
    public void initAfterWindowAttach() {
        this.m2V2VoiceRoom = ((IRoomManagerService)this.getServiceManager().getService(IRoomManagerService.class)).joinRoom(this.mSessionId, 8, null);
        this.bindingRoomData(this.m2V2VoiceRoom);
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).registerGameMsgListener(this.m2v2GameMsgListener);
    }

    @Override
    public void onPreloadGameInner(@NotNull GamePlayContext context) {
        super.onPreloadGameInner(context);
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).sendJoinRoomReq(this.gameRunningContext.getRoomId());
    }

    @Override
    public void onPreGameExitInner(GamePlayContext context) {
        super.onPreGameExitInner(context);
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).sendLeaveRoomReq(this.gameRunningContext.getRoomId());
    }

    private void bindingRoomData(RoomSlot<AbsVoiceRoom> roomSlot) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"bindingRoomData", (Object[])new Object[0]);
        }
        if (roomSlot.room != null) {
            this.mBinder.singleBindSourceWithFlag((KvoSource)roomSlot.room.mMyStatus, 1);
            this.mBinder.singleBindSourceTo((KvoSource)roomSlot.room);
            this.bindSpeak(this.mineUserInfoKS.getUid());
            this.bindSpeak(this.friendsUserInfoKS.getUid());
            this.bindSpeak(this.otherLeftUserInfoKS.getUid());
            this.bindSpeak(this.otherRightUserInfoKS.getUid());
        }
    }

    @KvoMethodAnnotation(sourceClass=MultiplayerRoom.class, name="mRoomUserMicStatusList", thread=1)
    public void onRoomMicStatusChanged(KvoEventIntent event) {
        if (event == null) {
            return;
        }
        if (event.newValue() != null && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)((MultiplayerRoom)event.source()).getRoomUserMicStatusList().toString(), (Object[])new Object[0]);
        }
        if (this.m2V2VoiceRoom == null || this.m2V2VoiceRoom.room == null) {
            return;
        }
        for (RoomUserMicStatus roomUserMicStatus : this.m2V2VoiceRoom.room.getRoomUserMicStatusList()) {
            if (roomUserMicStatus.getUid() == this.mineUserInfoKS.getUid()) {
                if (this.mTopBar2v2Controller == null) continue;
                this.mTopBar2v2Controller.updateMineLeftMicStatusView(roomUserMicStatus.isMicOpen());
                continue;
            }
            if (roomUserMicStatus.getUid() == this.friendsUserInfoKS.getUid()) {
                if (this.mTopBar2v2Controller == null) continue;
                this.mTopBar2v2Controller.updateMineRightMicStatusView(roomUserMicStatus.isMicOpen());
                continue;
            }
            if (roomUserMicStatus.getUid() == this.otherLeftUserInfoKS.getUid()) {
                if (this.mTopBar2v2Controller == null) continue;
                this.mTopBar2v2Controller.updateOtherLeftMicStatusView(roomUserMicStatus.isMicOpen());
                continue;
            }
            if (roomUserMicStatus.getUid() != this.otherRightUserInfoKS.getUid() || this.mTopBar2v2Controller == null) continue;
            this.mTopBar2v2Controller.updateOtherRightMicStatusView(roomUserMicStatus.isMicOpen());
        }
        this.sendMicStatus();
    }

    @Override
    @KvoMethodAnnotation(sourceClass=RoomUserMicStatus.class, thread=1, name="micOpen", flag=1)
    public void onMyMicStatusChange(KvoEventIntent event) {
        RoomUserMicStatus roomUserMicStatus = (RoomUserMicStatus)event.source();
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"RoomUserMicStatus %s", (Object[])new Object[]{roomUserMicStatus.isMicOpen()});
        }
        if (this.mTopBar2v2Controller == null) {
            return;
        }
        this.mTopBar2v2Controller.updateMineLeftMicStatusView(roomUserMicStatus.isMicOpen());
        this.mTopBar2v2Controller.updateMicView(roomUserMicStatus.isMicOpen());
        if (roomUserMicStatus.isMicOpen()) {
            this.mVoiceStartTime = System.currentTimeMillis();
        }
        this.sendMicStatus();
    }

    public void sendMicStatus() {
        if (this.gameRunningContext.getGameInfo().getVoiceType() != 1) {
            return;
        }
        ArrayList<MicStatusBean> micStatusBeanList = new ArrayList<MicStatusBean>();
        if (this.m2V2VoiceRoom != null && this.m2V2VoiceRoom.room != null) {
            for (RoomUserMicStatus roomUserMicStatus : this.m2V2VoiceRoom.room.getRoomUserMicStatusList()) {
                micStatusBeanList.add(new MicStatusBean(Long.valueOf(roomUserMicStatus.getUid()), roomUserMicStatus.isMicOpen() ? 1 : 0));
            }
        }
        this.getCocosMessageProxy().getCocosProxyController().appNotifyGame(this.gameRunningContext.getRoomId(), CocosProxyType.onMicStatusChange.getEvent(), micStatusBeanList);
    }

    @KvoMethodAnnotation(sourceClass=UserSpeakStatus.class, name="state", thread=1, flag=3)
    public void onSpeakStatusChange(KvoEventIntent event) {
        UserSpeakStatus userSpeakStatus = (UserSpeakStatus)event.source();
        if (this.m2V2VoiceRoom != null && this.m2V2VoiceRoom.room != null) {
            this.sendSpeakingStatus(userSpeakStatus);
        }
    }

    public synchronized void sendSpeakingStatus(UserSpeakStatus speakStatuses) {
        if (speakStatuses == null) {
            return;
        }
        ArrayList<GameUserSpeakStatus> speakStatusesList = new ArrayList<GameUserSpeakStatus>();
        GameUserSpeakStatus gameUserSpeakStatus = new GameUserSpeakStatus(speakStatuses.getUid(), speakStatuses.getStatus());
        speakStatusesList.add(gameUserSpeakStatus);
        if (!this.isExitIng()) {
            this.getCocosMessageProxy().getCocosProxyController().appNotifyGame(this.gameRunningContext.getRoomId(), CocosProxyType.appStateSpeaking.getEvent(), speakStatusesList);
        }
    }

    @Override
    public void initFunViews(RelativeLayout container) {
        GameInfo gameInfo = this.gameRunningContext.getGameInfo();
        this.abstractFunctionLayer = null;
        if (gameInfo.getScreenDire() == 1) {
            this.abstractFunctionLayer = gameInfo.getRoomTemplate() == 1 ? new Vertical2V2FuntionLayer((Activity)this.mContext, container) : (gameInfo.getRoomTemplate() == 3 ? new EmptyFuntionLayer((Activity)this.mContext, container) : new CustomerFuntionLayer((Activity)this.mContext, container));
        } else if (gameInfo.getScreenDire() == 2) {
            this.abstractFunctionLayer = gameInfo.getRoomTemplate() == 1 ? new Horizontal2V2FuntionLayer((Activity)this.mContext, container) : (gameInfo.getRoomTemplate() == 3 ? new EmptyFuntionLayer((Activity)this.mContext, container) : new CustomerFuntionLayer((Activity)this.mContext, container));
        }
        if (this.abstractFunctionLayer != null) {
            this.abstractFunctionLayer.setCallback(this.i2v2FunctionLayerCallback);
            this.abstractFunctionLayer.showViews(gameInfo);
        }
    }

    @Override
    protected void beforeShowGameResult(OnGameResultShowEvent event) {
        super.beforeShowGameResult(event);
        if (event != null) {
            event.set2v2Users(this.mineUserInfoKS, this.friendsUserInfoKS, this.otherLeftUserInfoKS, this.otherRightUserInfoKS);
        }
    }

    @Override
    void destoryMicWhenDetach() {
        ((IGameMessageService)this.getServiceManager().getService(IGameMessageService.class)).unRegisterGameMsgListener(this.m2v2GameMsgListener);
        if (this.m2V2VoiceRoom != null && this.m2V2VoiceRoom.room != null && this.m2V2VoiceRoom.room.getMyStatus().isMicOpen() && this.m2V2VoiceRoom.room.getOtherStatus().isMicOpen()) {
            ((IHonorService)this.getServiceManager().getService(IHonorService.class)).reportOpenSoundHonorTask();
        }
        if (this.m2V2VoiceRoom != null && this.m2V2VoiceRoom.room != null && this.gameRunningContext.getGameInfo() != null) {
            this.bizCollector.reportOutMic(this.m2V2VoiceRoom);
            this.unBindingRoomData();
            this.mRoomService.leaveRoom(this.m2V2VoiceRoom, 5);
        }
    }

    @Override
    public void onReceiveGameEvent(String context, long seqId, int event, Vector<String> args) {
        super.onReceiveGameEvent(context, seqId, event, args);
        String arg = "";
        if (args != null && args.size() > 0) {
            arg = args.get(0);
        }
        String reqJson = arg;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"context =JScall type = %s,reqJson=%s", (Object[])new Object[]{event, reqJson});
        }
        if (CocosProxyType.micStatusQuery.getEvent() == event) {
            this.queryUserMicStatus(context, seqId, reqJson);
        } else if (CocosProxyType.notifyTeamChange.getEvent() == event) {
            try {
                JSONObject jsonObject = JsonParser.obtainJSONObject((String)reqJson);
                JSONArray jsonArray = jsonObject.getJSONArray("uids");
                this.isFriendLeave = jsonArray.length() <= 1;
            }
            catch (JSONException e) {
                GameLoger.error("pkGame", e);
            }
        }
    }

    private void queryUserMicStatus(final String context, final long seqId, final String reqJson) {
        YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                if (Pk2v2GamePlayer.this.m2V2VoiceRoom != null && ((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room != null) {
                    try {
                        long tUid = ((GetRelationBean)JsonParser.parseJsonObject((String)reqJson, GetRelationBean.class)).getUid();
                        if (Pk2v2GamePlayer.this.m2V2VoiceRoom != null && ((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room != null) {
                            boolean isHaveUser = false;
                            for (RoomUserMicStatus roomUserMicStatus : ((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room.getRoomUserMicStatusList()) {
                                if (roomUserMicStatus.getUid() != tUid) continue;
                                isHaveUser = true;
                                MicStatusBean micStatusBean = new MicStatusBean(Long.valueOf(roomUserMicStatus.getUid()), roomUserMicStatus.isMicOpen() ? 1 : 0);
                                Pk2v2GamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.micStatusQueryCallBack, (Object)micStatusBean);
                            }
                            if (!isHaveUser) {
                                MicStatusBean micStatusBean = new MicStatusBean(Long.valueOf(tUid), 0);
                                Pk2v2GamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.micStatusQueryCallBack, (Object)micStatusBean);
                            }
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)Pk2v2GamePlayer.TAG, (Throwable)e);
                    }
                }
            }
        });
    }

    public void bindSpeak(long uid) {
        UserSpeakStatus userSpeakBean = (UserSpeakStatus)this.mRoomService.getSpeaks().get(uid);
        if (userSpeakBean == null) {
            userSpeakBean = new UserSpeakStatus(uid, 0);
            this.mRoomService.getSpeaks().put(uid, userSpeakBean);
        }
        this.mBinder.singleBindSourceWithFlag(uid + "", (KvoSource)userSpeakBean, 3);
    }

    public void unBindingRoomData() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"unRoomDataBinding", (Object[])new Object[0]);
        }
        this.mBinder.clearAllKvoConnections();
    }

    @Override
    public synchronized void exitRoom(int gameExitType) {
        if (gameExitType == 2 && !this.isFriendLeave && this.getCurrentStage() >= 6) {
            super.exitRoom(4);
            return;
        }
        super.exitRoom(gameExitType);
    }

    @Override
    public void gotoIM(GamePlayContext gameRunningContext) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.IM_ROOM_SHOW;
        Bundle bundle = new Bundle();
        bundle.putLong("target_uid", this.friendsUserInfoKS.getUid());
        bundle.putString("im_game_id", gameRunningContext.getGameInfo().getGid());
        bundle.putInt("bundle_im_from", 4);
        bundle.putInt("im_page_scene", 1);
        bundle.putBoolean("im_game_panel", true);
        msg.setData(bundle);
        this.sendMessageSync(msg);
    }

    private void onMicClickInner() {
        if (this.m2V2VoiceRoom != null && this.m2V2VoiceRoom.room != null) {
            if (!this.m2V2VoiceRoom.room.mMyStatus.isMicOpen()) {
                HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20023777").put("link_time", String.valueOf(this.tap)).put("act_uid", String.valueOf(this.friendsUserInfoKS.getUid())).put("roomid", this.gameRunningContext.getRoomId()).put("gid", this.gameRunningContext.getGameInfo().getGid());
                hiidoEvent.put("function_id", "strat_mic");
                HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
                PermissionHelper.requestRecordAudioPermission((Activity)this.mContext, (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        if (Pk2v2GamePlayer.this.m2V2VoiceRoom != null && ((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room != null && !((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room.mMyStatus.isMicOpen()) {
                            ((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room.changeMicStatus(!((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room.mMyStatus.isMicOpen());
                        }
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                    }
                });
            } else {
                this.tap = Math.abs((System.currentTimeMillis() - this.mVoiceStartTime) / 1000L);
                if (this.gameRunningContext.getGameInfo() != null && this.mVoiceStartTime > 0L) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("link_time", String.valueOf(this.tap)).put("act_uid", String.valueOf(this.friendsUserInfoKS.getUid())).put("roomid", this.gameRunningContext.getRoomId()).put("gid", this.gameRunningContext.getGameInfo().getGid()).put("function_id", "end_mic"));
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("link_time", String.valueOf(this.tap)).put("act_uid", String.valueOf(this.friendsUserInfoKS.getUid())).put("roomid", this.gameRunningContext.getRoomId()).put("gid", this.gameRunningContext.getGameInfo().getGid()).put("function_id", "off_mic"));
                }
                this.mVoiceStartTime = 0L;
                this.m2V2VoiceRoom.room.changeMicStatus(!this.m2V2VoiceRoom.room.mMyStatus.isMicOpen());
            }
        }
    }

    @Override
    void gotoMatch() {
        if (this.gameRunningContext.getPkMatchContext() instanceof Game2V2MatchContext) {
            Game2V2MatchContext gameMatchContext = new Game2V2MatchContext(GameContextDef.JoinFrom.FROM_GAME);
            gameMatchContext.setFriendUserInfo(((Game2V2MatchContext)this.gameRunningContext.getPkMatchContext()).getFriendUserInfo());
            gameMatchContext.setPkId(((Game2V2MatchContext)this.gameRunningContext.getPkMatchContext()).getPkId());
            gameMatchContext.setExtendData(new ConcurrentHashMap(this.gameRunningContext.getPkMatchContext().getExtendData()));
            ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).matchGame(this.gameRunningContext.getGameInfo(), (GameMatchContext)gameMatchContext, null);
        } else {
            this.mIsHiddenFinish = false;
            this.getBaseGameView().destroyGameView();
        }
    }

    @Override
    void onLoadFail() {
        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_loading_fail), (int)0);
        YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                Pk2v2GamePlayer.this.generateGameResult();
            }
        }, (Runnable)new Runnable(){

            @Override
            public void run() {
                Pk2v2GamePlayer.this.exitRoom(1);
            }
        });
        this.bizCollector.reportGameLoadFail();
    }

    @Override
    public int exitNoStart() {
        TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.user_escape), (int)0);
        GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.getGameStartTime()), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.NOT_START.value(), 0, this.isGoldGame);
        if (this.gameRunningContext.getFrom().getId() == IGameService.GAME_FROM.FROM_IM.value() || this.gameRunningContext.getFrom().getId() == IGameService.GAME_FROM.FROM_NOTIFY.value()) {
            return 1;
        }
        return 6;
    }

    public class Biz2v2Conllector
    extends PkGamePlayer.BizCollector {
        private static final String GAME_ID = "game_id";
        private static final String CRASH = "Crash_";

        public Biz2v2Conllector() {
            super(Pk2v2GamePlayer.this);
        }

        @Override
        void reportGame(boolean isStart) {
            String gameId = SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)Pk2v2GamePlayer.this.mContext, GAME_ID, 0).getString(GAME_ID, "");
            if (isStart) {
                if (StringUtils.isNotEmpty((String)gameId)) {
                    HiidoStatis.reportReturnCode((String)(CRASH + SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)Pk2v2GamePlayer.this.mContext, GAME_ID, 0).getString(GAME_ID, "")), (long)0L, (String)"");
                }
                gameId = Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid();
                if (Pk2v2GamePlayer.this.gameRunningContext.getGameInfo() != null) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("function_id", "load").put("gid", gameId).put("game_type", String.valueOf(Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGameMode())));
                }
                AppsFlyerHelper.INSTANCE.reportEvent(new AppsFlyerEvent().eventId("entergame"));
            } else {
                gameId = "";
                GameDataModel.instance.postGameLeave(Pk2v2GamePlayer.this.gameRunningContext, Pk2v2GamePlayer.this.gameRunningContext.getFrom().getId());
                if (((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room != null && ((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room.mMyStatus.isMicOpen()) {
                    if (Pk2v2GamePlayer.this.mVoiceStartTime > 0L) {
                        Pk2v2GamePlayer.this.tap = Math.abs((System.currentTimeMillis() - Pk2v2GamePlayer.this.mVoiceStartTime) / 1000L);
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "end_mic").put("link_time", String.valueOf(Pk2v2GamePlayer.this.tap)).put("act_uid", String.valueOf(Pk2v2GamePlayer.this.friendsUserInfoKS.getUid())).put("roomid", Pk2v2GamePlayer.this.gameRunningContext.getRoomId()).put("gid", Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid()));
                    }
                    Pk2v2GamePlayer.this.mVoiceStartTime = 0L;
                }
                if (Pk2v2GamePlayer.this.gameRunningContext.getGameInfo() != null && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)Pk2v2GamePlayer.TAG, (String)"GAME_ROOM_leave,current_gid=%s,room_id=%s", (Object[])new Object[]{Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid(), Pk2v2GamePlayer.this.gameRunningContext.getRoomId()});
                }
            }
            SharedPreferences mSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)Pk2v2GamePlayer.this.mContext, GAME_ID, 0);
            SharedPreferences.Editor edit = mSharedPreferences.edit();
            edit.putString(GAME_ID, gameId);
            edit.apply();
        }

        @Override
        void reportQuickMsgs() {
            if (Pk2v2GamePlayer.this.gameRunningContext.getGameInfo() != null && Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().isQuickNews() && Pk2v2GamePlayer.this.gameRunningContext.getOtherUserInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "quick_msg_show").put("act_uid", String.valueOf(Pk2v2GamePlayer.this.gameRunningContext.getOtherUserInfo().getUid())).put("roomid", Pk2v2GamePlayer.this.gameRunningContext.getRoomId()).put("gid", Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid()));
            }
        }

        @Override
        void reportGameLoadFinish() {
            if (Pk2v2GamePlayer.this.gameRunningContext.getGameInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("function_id", "load_success").put("match_time", String.valueOf(System.currentTimeMillis() - Pk2v2GamePlayer.this.mGameStartTime)).put("gid", Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid()).put("game_type", String.valueOf(Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGameMode())));
            }
            if (Pk2v2GamePlayer.this.gameRunningContext.getGameInfo() != null && Pk2v2GamePlayer.this.gameRunningContext.getOtherUserInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "show").put("act_uid", String.valueOf(Pk2v2GamePlayer.this.gameRunningContext.getOtherUserInfo().getUid())).put("roomid", Pk2v2GamePlayer.this.gameRunningContext.getRoomId()).put("gid", Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid()));
            }
            GameReportHelper.reportGameInfo(Pk2v2GamePlayer.this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - Pk2v2GamePlayer.this.mGameStartTime), Pk2v2GamePlayer.this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.LOAD_FINISH.value(), 0, Pk2v2GamePlayer.this.isGoldGame);
        }

        @Override
        void reportGameLoadFail() {
            if (Pk2v2GamePlayer.this.gameRunningContext.getGameInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("function_id", "load_fail").put("match_time", String.valueOf(System.currentTimeMillis() - Pk2v2GamePlayer.this.mGameStartTime)).put("gid", Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid()).put("game_type", String.valueOf(Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGameMode())));
            }
            GameReportHelper.reportGameInfo(Pk2v2GamePlayer.this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - Pk2v2GamePlayer.this.mGameStartTime), Pk2v2GamePlayer.this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.LOAD_FAIL.value(), 0, Pk2v2GamePlayer.this.isGoldGame);
        }

        @Override
        void reportGameExit() {
            if (Pk2v2GamePlayer.this.gameRunningContext != null && Pk2v2GamePlayer.this.gameRunningContext.getOtherUserInfo() != null && Pk2v2GamePlayer.this.gameRunningContext.getGameInfo() != null) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023777").put("function_id", "ext").put("act_uid", String.valueOf(Pk2v2GamePlayer.this.gameRunningContext.getOtherUserInfo().getUid())).put("roomid", Pk2v2GamePlayer.this.gameRunningContext.getRoomId()).put("gid", Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid()));
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023773").put("is_exit", "1").put("game_type", String.valueOf(Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGameMode())).put("gid", Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid()));
                if (Pk2v2GamePlayer.this.getGameExitType() == 2) {
                    GameDataModel.instance.postGameForceExit(Pk2v2GamePlayer.this.gameRunningContext.buildGameModel(), Pk2v2GamePlayer.this.gameRunningContext.getFrom().getId());
                }
            }
        }

        public void reportOutMic() {
            HiidoEvent micEvent = HiidoEvent.obtain().eventId("20023777").put("act_uid", String.valueOf(Pk2v2GamePlayer.this.friendsUserInfoKS.getUid())).put("roomid", Pk2v2GamePlayer.this.gameRunningContext.getRoomId()).put("gid", Pk2v2GamePlayer.this.gameRunningContext.getGameInfo().getGid());
            micEvent.put("out_mic_state", String.valueOf(((Pk2v2GamePlayer)Pk2v2GamePlayer.this).m2V2VoiceRoom.room.mMyStatus.isMicOpen() ? 1 : 0));
            micEvent.put("enter_mic_state", String.valueOf(Pk2v2GamePlayer.this.micInitState));
            HiidoStatis.reportEvent((HiidoEvent)micEvent);
        }
    }
}

