/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.newuser;

import android.content.SharedPreferences;
import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationDef;
import com.yy.game.gamemodule.newuser.NewUserMatchAIModel;
import com.yy.game.msg.GameMsgDef;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;

public class NewUserMatchAIController
extends DefaultController {
    private static final String TAG = "NewUserMatchAIController";
    private NewUserMatchAIModel matchAI = new NewUserMatchAIModel();
    private boolean isTest = false;
    private IGameCenterService iGameCenterService;
    private boolean isFirstPlay = false;
    private boolean isMatchAi = false;
    private boolean isAi = false;
    private static final int NEW_USER_GUIDE_AI_UID = 900000000;
    private static String KEY_PLAYED_GAME = "played_game";
    private boolean playedGame = false;
    GameLifeWrapper mGameLifeWrapper = new GameLifeWrapper(){

        public void onGameExited(GamePlayContext context, int gameExitType) {
        }

        public void onPreloadGame(GamePlayContext context) {
            if (!NewUserMatchAIController.this.playedGame) {
                SharedPreferences.Editor editor = SharedPreferencesUtils.INSTANCE.getDefaultPrf().edit();
                editor.putBoolean(KEY_PLAYED_GAME + AccountUtil.getUid(), true);
                editor.apply();
                NewUserMatchAIController.this.playedGame = true;
            }
            UserInfoKS userInfo = context.getOtherUserInfo();
            GameInfo gameInfo = context.getGameInfo();
            if (gameInfo != null) {
                NewUserMatchAIController.this.isHasGamePlayed(gameInfo.getGid());
            }
            if (context.getPkMatchContext() != null) {
                NewUserMatchAIController.this.isMatchAi(context.getPkMatchContext());
            } else {
                NewUserMatchAIController.this.isMatchAi = false;
            }
            if (userInfo != null) {
                long uid = userInfo.getUid();
                if (SystemUtils.isAI((long)uid)) {
                    NewUserMatchAIController.this.isNormalAi(uid);
                    NewUserMatchAIController.this.appendMatchAiCounts();
                } else {
                    NewUserMatchAIController.this.hasPlayWithRealMan();
                    NewUserMatchAIController.this.isAi = false;
                }
            }
        }
    };

    public NewUserMatchAIController(Environment env) {
        super(env);
        if (AccountUtil.getUid() > 0L) {
            this.matchAI.setNewRegisterAccount(this.isNewUserRegister());
            this.playedGame = SharedPreferencesUtils.INSTANCE.getDefaultPrf().getBoolean(KEY_PLAYED_GAME + AccountUtil.getUid(), false);
        }
        this.initGameService();
    }

    private boolean isNewUserRegister() {
        if (this.isTest) {
            return true;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isNewUserRegister playedGame = %s, is in 24h = %s", (Object[])new Object[]{this.playedGame, AccountUtil.isInTwentyFourHours()});
        }
        return AccountUtil.isInTwentyFourHours() && this.playedGame;
    }

    private synchronized void initGameService() {
        if (this.iGameCenterService == null) {
            this.iGameCenterService = (IGameCenterService)this.getServiceManager().getService(IGameCenterService.class);
            if (this.iGameCenterService != null) {
                this.iGameCenterService.registerGameLifecycle((IGameLifecycle)this.mGameLifeWrapper);
            }
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            if (AccountUtil.getUid() < 0L) {
                this.matchAI.setNewRegisterAccount(false);
                this.matchAI.setAiGameSum(0);
                this.matchAI.setHasPlayWithRealMan(false);
            } else {
                this.matchAI.setNewRegisterAccount(this.isNewUserRegister());
            }
        } else if (notification.id == GameNotificationDef.GAME_MODLE_INIT) {
            this.initGameService();
        }
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == GameMsgDef.NEW_REGISTER_FIRST_MATCH_AI) {
            return this.isFirstMatchAI();
        }
        return super.handleMessageSync(msg);
    }

    private void appendMatchAiCounts() {
        this.matchAI.setAiGameSum(this.matchAI.getAiGameSum() + 1);
    }

    private void hasPlayWithRealMan() {
        this.matchAI.setHasPlayWithRealMan(true);
    }

    private void isHasGamePlayed(String gid) {
        GameInfoModule gameInfoModule = (GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class);
        if (gameInfoModule != null) {
            this.isFirstPlay = !gameInfoModule.hasGamePlayedWithUser(gid);
        }
    }

    private boolean isFirstMatchAI() {
        if (this.isTest) {
            return true;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isFirstMatchAI isFirstPlay = %s, isAi = %s, isMatchAi = %s", (Object[])new Object[]{this.isFirstPlay, this.isAi, this.isMatchAi});
        }
        if (this.matchAI.isNewRegisterAccount() && !this.matchAI.isHasPlayWithRealMan() && this.matchAI.getAiGameSum() == 1) {
            return true;
        }
        return this.isFirstPlay && this.isAi || this.isMatchAi;
    }

    private void isMatchAi(GameMatchContext gameMatchContext) {
        if (gameMatchContext == null) {
            this.isMatchAi = false;
            return;
        }
        if (gameMatchContext.getExtendValue("isMatchAi", (Object)false) != null && ((Boolean)gameMatchContext.getExtendValue("isMatchAi", (Object)false)).booleanValue()) {
            gameMatchContext.addExtendValue("isMatchAi", (Object)false);
            this.isMatchAi = true;
        } else {
            this.isMatchAi = false;
        }
    }

    private void isNormalAi(long uid) {
        this.isAi = uid != 900000000L;
    }
}

