/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.newuser;

import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationDef;
import com.yy.game.gamemodule.newuser.CacheNewUserGameResultData;
import com.yy.game.gamemodule.newuser.NewUserGameResultShowModel;
import com.yy.game.msg.GameMsgDef;

public class NewUserGameResultGuideController
extends DefaultController {
    private static final String TAG = "NewUserGameResultGuideController";
    boolean isTest = false;
    private int curWin = 2;
    private CacheNewUserGameResultData newUserGameResultData = new CacheNewUserGameResultData();

    public NewUserGameResultGuideController(Environment env) {
        super(env);
        this.newUserGameResultData.loadData();
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED && AccountUtil.getUid() > 0L) {
            this.updateDataIfNotExist();
        }
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == GameMsgDef.NEW_REGISTER_NEED_SHOW_GAME_RESULT) {
            return this.needShowNewRegisterGameResult();
        }
        if (msg.what == GameMsgDef.NEW_REGISTER_LAST_WIN_COUNT) {
            return this.getLastWinCount();
        }
        if (msg.what == GameMsgDef.NEW_REGISTER_INCREASE_WIN_COUNT) {
            this.appendWinCounts();
        }
        return super.handleMessageSync(msg);
    }

    private boolean needShowNewRegisterGameResult() {
        if (this.isTest) {
            return true;
        }
        NewUserGameResultShowModel showModel = this.newUserGameResultData.getCacheData(AccountUtil.getUid());
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"model:%s, newUser:%b, winCount:%d, abTest:%s ", (Object[])new Object[]{showModel, showModel != null && showModel.isNewUser, showModel != null ? showModel.winCounts : 0});
        }
        return false;
    }

    private void updateDataIfNotExist() {
        long uid = AccountUtil.getUid();
        if (AccountUtil.getUid() > 0L) {
            this.newUserGameResultData.insertIfNewUserNotExist(uid, AccountUtil.isNewRegister());
        }
    }

    private void appendWinCounts() {
        if (this.isTest) {
            return;
        }
        this.newUserGameResultData.increaseWinCounts(AccountUtil.getUid());
    }

    private int getLastWinCount() {
        if (this.isTest) {
            return this.curWin;
        }
        NewUserGameResultShowModel model = this.newUserGameResultData.getCacheData(AccountUtil.getUid());
        if (model != null) {
            return model.winCounts;
        }
        return 0;
    }
}

