/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.newuser;

import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.game.gamemodule.newuser.NewUserGameResultShowModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CacheNewUserGameResultData {
    private File mCacheFile;
    private volatile boolean loadDataFinish = false;
    private Map<Long, NewUserGameResultShowModel> cacheData = new HashMap<Long, NewUserGameResultShowModel>();
    private List<Runnable> cacheTask = new ArrayList<Runnable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIfNewUserNotExist(final long uid, final boolean isNewUser) {
        if (!this.loadDataFinish) {
            this.cacheTask.add(new Runnable(){

                @Override
                public void run() {
                    CacheNewUserGameResultData.this.insertIfNewUserNotExist(uid, isNewUser);
                }
            });
            return;
        }
        CacheNewUserGameResultData cacheNewUserGameResultData = this;
        synchronized (cacheNewUserGameResultData) {
            NewUserGameResultShowModel model = this.cacheData.get(uid);
            if (model == null && isNewUser) {
                model = new NewUserGameResultShowModel();
                model.isNewUser = true;
                model.winCounts = 0;
                model.uid = uid;
                this.cacheData.put(uid, model);
                this.writeData();
            }
        }
    }

    private void writeData() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String cache = null;
                CacheNewUserGameResultData cacheNewUserGameResultData = CacheNewUserGameResultData.this;
                synchronized (cacheNewUserGameResultData) {
                    if (CacheNewUserGameResultData.this.cacheData != null && !CacheNewUserGameResultData.this.cacheData.isEmpty()) {
                        ArrayList jsonArray = new ArrayList();
                        for (Map.Entry entry : CacheNewUserGameResultData.this.cacheData.entrySet()) {
                            jsonArray.add(entry.getValue());
                        }
                        cache = JsonParser.toJson(jsonArray);
                    }
                    if (StringUtils.isNotEmpty(cache)) {
                        try {
                            YYFileUtils.writeBytesToFile((File)CacheNewUserGameResultData.this.getCacheFile(), (byte[])cache.getBytes(), (boolean)false);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    private synchronized File getCacheFile() {
        if (this.mCacheFile == null) {
            this.mCacheFile = new File(RuntimeContext.sApplicationContext.getFilesDir(), "newusergameresult.txt");
        }
        return this.mCacheFile;
    }

    public synchronized void loadData() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] cacheBytes = YYFileUtils.readBytes((File)CacheNewUserGameResultData.this.getCacheFile());
                if (cacheBytes != null && cacheBytes.length > 0) {
                    CacheNewUserGameResultData cacheNewUserGameResultData = CacheNewUserGameResultData.this;
                    synchronized (cacheNewUserGameResultData) {
                        String cacheStr = new String(cacheBytes);
                        List models = null;
                        try {
                            models = JsonParser.parseJsonList((String)cacheStr, NewUserGameResultShowModel.class);
                            if (models != null && models.size() > 0) {
                                for (int i = 0; i < models.size(); ++i) {
                                    NewUserGameResultShowModel model = (NewUserGameResultShowModel)models.get(i);
                                    if (model == null) continue;
                                    CacheNewUserGameResultData.this.cacheData.put(model.uid, model);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                CacheNewUserGameResultData.this.loadDataFinish = true;
                if (CacheNewUserGameResultData.this.cacheTask != null && !CacheNewUserGameResultData.this.cacheTask.isEmpty()) {
                    Iterator iterable = CacheNewUserGameResultData.this.cacheTask.iterator();
                    while (iterable.hasNext()) {
                        Runnable runnable2 = (Runnable)iterable.next();
                        if (runnable2 != null) {
                            runnable2.run();
                        }
                        iterable.remove();
                    }
                }
            }
        });
    }

    public synchronized NewUserGameResultShowModel getCacheData(long uid) {
        return this.cacheData.get(uid);
    }

    public synchronized void increaseWinCounts(long uid) {
        NewUserGameResultShowModel model = this.cacheData.get(uid);
        if (model != null) {
            ++model.winCounts;
            this.writeData();
        }
    }
}

