/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.loader;

import android.app.Activity;
import android.net.Uri;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.extensions.BaseExtensionKt;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.Environment;
import com.yy.game.gamemodule.base.GameDownloadPresenter;
import com.yy.game.gamemodule.base.GamePlayInfo;
import com.yy.game.gamemodule.loader.IGameLoader;
import com.yy.game.report.GameReport;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.IGameDownloadInterface;
import com.yy.hiyo.game.service.ICocosProxyService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.mvp.base.IMvpLifeCycleOwner;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 L2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004LMNOB\u000f\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020/H\u0016J\b\u00104\u001a\u00020/H\u0016J\b\u00105\u001a\u00020/H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u000e07H\u0017J\u0019\u00108\u001a\b\u0012\u0004\u0012\u00020\u000e0&2\u0006\u00100\u001a\u00020\u000e\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0016J\u0006\u0010?\u001a\u00020\u000eJ\b\u0010@\u001a\u00020\u000eH\u0002J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u000eH\u0016J$\u0010C\u001a\u00020/2\b\u0010B\u001a\u0004\u0018\u00010\u000e2\b\u0010D\u001a\u0004\u0018\u00010\u000e2\u0006\u0010E\u001a\u00020\u001eH\u0017J\u000e\u0010F\u001a\u00020/2\u0006\u0010G\u001a\u00020HJ\u0018\u0010I\u001a\u00020/2\u0006\u0010J\u001a\u00020\b2\b\b\u0002\u0010K\u001a\u00020\bR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0&X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0016\u00a8\u0006P"}, d2={"Lcom/yy/game/gamemodule/loader/BaseGameLoader;", "Lcom/yy/game/gamemodule/loader/IGameLoader;", "Lcom/yy/appbase/core/DefaultController;", "Lcom/yy/hiyo/mvp/base/IMvpLifeCycleOwner;", "env", "Lcom/yy/framework/core/Environment;", "(Lcom/yy/framework/core/Environment;)V", "errCode", "", "getErrCode", "()I", "setErrCode", "(I)V", "gamePath", "", "getGamePath", "()Ljava/lang/String;", "setGamePath", "(Ljava/lang/String;)V", "loadFailReason", "Landroidx/lifecycle/MutableLiveData;", "getLoadFailReason", "()Landroidx/lifecycle/MutableLiveData;", "mGameDownloader", "Lcom/yy/game/gamemodule/base/GameDownloadPresenter;", "getMGameDownloader", "()Lcom/yy/game/gamemodule/base/GameDownloadPresenter;", "setMGameDownloader", "(Lcom/yy/game/gamemodule/base/GameDownloadPresenter;)V", "mGameInfo", "Lcom/yy/hiyo/game/base/bean/GameInfo;", "getMGameInfo", "()Lcom/yy/hiyo/game/base/bean/GameInfo;", "setMGameInfo", "(Lcom/yy/hiyo/game/base/bean/GameInfo;)V", "mLifecycleRegistry", "Landroidx/lifecycle/LifecycleRegistry;", "pkgList", "", "getPkgList", "()[Ljava/lang/String;", "setPkgList", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "state", "getState", "addResPath", "", "path", "persist", "", "cancelDownload", "destory", "destroy", "getGameLoadingTips", "", "getGamePkgList", "(Ljava/lang/String;)[Ljava/lang/String;", "getLifeCycle", "Landroidx/lifecycle/LifecycleOwner;", "getLifecycle", "Landroidx/lifecycle/Lifecycle;", "getLoaderState", "getRandomRoomId", "getRandomString", "getResourseHost", "url", "initLoader", "roomId", "gameInfo", "onEvent", "event", "Landroidx/lifecycle/Lifecycle$Event;", "onLoadFail", "loadFailCode", "reasonCode", "Companion", "IGameloaderCallback", "LoadFailCode", "LoaderState", "game_debug"})
public abstract class BaseGameLoader
extends DefaultController
implements IGameLoader,
IMvpLifeCycleOwner {
    @Nullable
    private GameDownloadPresenter mGameDownloader;
    @NotNull
    private final MutableLiveData<Integer> state = new MutableLiveData();
    @NotNull
    private final MutableLiveData<Integer> loadFailReason = new MutableLiveData();
    private int errCode = -1;
    @Nullable
    private GameInfo mGameInfo;
    @NotNull
    private volatile String gamePath = "";
    @NotNull
    private volatile String[] pkgList = new String[0];
    private final LifecycleRegistry mLifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);
    public static final int START_INIT = 0;
    public static final int INIT_SUCCESS = 1;
    public static final int INIT_FAIL = -1;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public GameDownloadPresenter getMGameDownloader() {
        return this.mGameDownloader;
    }

    public void setMGameDownloader(@Nullable GameDownloadPresenter gameDownloadPresenter) {
        this.mGameDownloader = gameDownloadPresenter;
    }

    @NotNull
    public final MutableLiveData<Integer> getState() {
        return this.state;
    }

    @NotNull
    public final MutableLiveData<Integer> getLoadFailReason() {
        return this.loadFailReason;
    }

    public final int getErrCode() {
        return this.errCode;
    }

    public final void setErrCode(int n) {
        this.errCode = n;
    }

    @Nullable
    public final GameInfo getMGameInfo() {
        return this.mGameInfo;
    }

    public final void setMGameInfo(@Nullable GameInfo gameInfo) {
        this.mGameInfo = gameInfo;
    }

    @NotNull
    public final String getGamePath() {
        return this.gamePath;
    }

    public final void setGamePath(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.gamePath = string2;
    }

    @NotNull
    public final String[] getPkgList() {
        return this.pkgList;
    }

    public final void setPkgList(@NotNull String[] stringArray) {
        Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"<set-?>");
        this.pkgList = stringArray;
    }

    @CallSuper
    public void initLoader(@Nullable String url, @Nullable String roomId, @NotNull GameInfo gameInfo) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
            this.mGameInfo = gameInfo;
            this.setMGameDownloader(new GameDownloadPresenter(gameInfo));
            GameDownloadPresenter gameDownloadPresenter = this.getMGameDownloader();
            if (gameDownloadPresenter == null) break block0;
            gameDownloadPresenter.checkGameDownload(gameInfo, true);
        }
    }

    @NotNull
    public Lifecycle getLifecycle() {
        return (Lifecycle)this.mLifecycleRegistry;
    }

    public final void onEvent(@NotNull Lifecycle.Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.mLifecycleRegistry.handleLifecycleEvent(event);
    }

    @Override
    public void destory() {
        this.onEvent(Lifecycle.Event.ON_PAUSE);
        this.onEvent(Lifecycle.Event.ON_DESTROY);
    }

    @Override
    @NotNull
    public MutableLiveData<Integer> getLoaderState() {
        return this.state;
    }

    @Override
    @NotNull
    public LifecycleOwner getLifeCycle() {
        return (LifecycleOwner)this;
    }

    @NotNull
    public String getResourseHost(@NotNull String url) {
        Uri uri;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String resourceHostInner = "";
        Uri uri2 = uri = Uri.parse((String)url);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
        String string2 = uri2.getScheme();
        if (string2 == null) {
            string2 = "";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"uri.scheme ?: \"\"");
        String scheme = string2;
        resourceHostInner = scheme + "://" + uri.getHost();
        if (uri.getPort() > 0) {
            resourceHostInner = resourceHostInner + ":" + uri.getPort();
        }
        return resourceHostInner;
    }

    @NotNull
    public final String getRandomRoomId() {
        return this.getRandomString();
    }

    private final String getRandomString() {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 18) {
            int index = (int)(rnd.nextFloat() * (float)chars.length());
            salt.append(chars.charAt(index));
        }
        String string2 = salt.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"salt.toString()");
        return string2;
    }

    @NotNull
    public final String[] getGamePkgList(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (RuntimeContext.sIsDebuggable) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)BaseExtensionKt.getTAG((Object)this), (String)"game path:%s, fileExist:%b, ver:%s, url:%s", (Object[])new Object[]{path, YYFileUtils.isFileExisted((String)path)});
            }
        } else {
            YYTaskExecutor.execute((Runnable)new Runnable(this, path){
                final /* synthetic */ BaseGameLoader this$0;
                final /* synthetic */ String $path;

                public final void run() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)BaseExtensionKt.getTAG((Object)this.this$0), (String)"game path:%s, fileExist:%b, ver:%s, url:%s", (Object[])new Object[]{this.$path, YYFileUtils.isFileExisted((String)this.$path)});
                    }
                }
                {
                    this.this$0 = baseGameLoader;
                    this.$path = string2;
                }
            });
        }
        return new String[]{path};
    }

    public void addResPath(@NotNull String path, boolean persist) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
    }

    @NonNull
    @NotNull
    public List<String> getGameLoadingTips() {
        Object object;
        block3: {
            block2: {
                object = this.mGameInfo;
                if (object == null) break block2;
                GameInfo gameInfo = object;
                boolean bl = false;
                boolean bl2 = false;
                GameInfo it = gameInfo;
                boolean bl3 = false;
                GameDownloadPresenter gameDownloadPresenter = this.getMGameDownloader();
                object = gameDownloadPresenter != null ? gameDownloadPresenter.getDownloadTips(it) : null;
                if (object != null) break block3;
            }
            boolean bl = false;
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public void cancelDownload() {
        block0: {
            GameDownloadPresenter gameDownloadPresenter = this.getMGameDownloader();
            if (gameDownloadPresenter == null) break block0;
            gameDownloadPresenter.destroy();
        }
    }

    public void destroy() {
        super.destroy();
    }

    public final void onLoadFail(int loadFailCode, int reasonCode) {
        if (this.loadFailReason.getValue() != null) {
            this.loadFailReason.postValue((Object)loadFailCode);
            this.errCode = reasonCode;
        }
    }

    public static /* synthetic */ void onLoadFail$default(BaseGameLoader baseGameLoader, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onLoadFail");
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        baseGameLoader.onLoadFail(n, n2);
    }

    public BaseGameLoader(@Nullable Environment env) {
        super(env);
        this.onEvent(Lifecycle.Event.ON_CREATE);
        this.onEvent(Lifecycle.Event.ON_START);
        this.onEvent(Lifecycle.Event.ON_RESUME);
    }

    @Override
    public void updateDownloadInterface(@Nullable IGameDownloadInterface downloadInterface) {
        IGameLoader.DefaultImpls.updateDownloadInterface(this, downloadInterface);
    }

    @Override
    public void onTryDownLoadFileForWebGameInner(@NotNull String url, int tag) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        IGameLoader.DefaultImpls.onTryDownLoadFileForWebGameInner(this, url, tag);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/yy/game/gamemodule/loader/BaseGameLoader$LoaderState;", "", "game_debug"})
    public static @interface LoaderState {
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/yy/game/gamemodule/loader/BaseGameLoader$LoadFailCode;", "", "Companion", "game_debug"})
    public static @interface LoadFailCode {
        public static final Companion Companion = Companion.$$INSTANCE;
        public static final int DOWNLOAD_FAIL = 1001;
        public static final int REQUEST_TOKEN_FAIL = 1002;
        public static final int UNZIP_FAIL = 1003;

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/yy/game/gamemodule/loader/BaseGameLoader$LoadFailCode$Companion;", "", "()V", "DOWNLOAD_FAIL", "", "REQUEST_TOKEN_FAIL", "UNZIP_FAIL", "game_debug"})
        public static final class Companion {
            public static final int DOWNLOAD_FAIL = 1001;
            public static final int REQUEST_TOKEN_FAIL = 1002;
            public static final int UNZIP_FAIL = 1003;
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\n\u0010\b\u001a\u0004\u0018\u00010\tH&J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/yy/game/gamemodule/loader/BaseGameLoader$IGameloaderCallback;", "", "getActivity", "Landroid/app/Activity;", "getCocosProxyController", "Lcom/yy/hiyo/game/service/ICocosProxyService;", "getGamePlayInfo", "Lcom/yy/game/gamemodule/base/GamePlayInfo;", "getPlayerContext", "Lcom/yy/hiyo/game/service/bean/GamePlayContext;", "getReporter", "Lcom/yy/game/report/GameReport;", "onPreLoadGameError", "", "game_debug"})
    public static interface IGameloaderCallback {
        @Nullable
        public GamePlayContext getPlayerContext();

        @NotNull
        public ICocosProxyService getCocosProxyController();

        @Nullable
        public Activity getActivity();

        public void onPreLoadGameError();

        @NotNull
        public GameReport getReporter();

        @NotNull
        public GamePlayInfo getGamePlayInfo();

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onPreLoadGameError(IGameloaderCallback $this) {
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/yy/game/gamemodule/loader/BaseGameLoader$Companion;", "", "()V", "INIT_FAIL", "", "INIT_SUCCESS", "START_INIT", "game_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

