/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.gameplayer;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ViewGroup;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.Environment;
import com.yy.game.R;
import com.yy.game.gamemodule.BaseGameCallAppRouter;
import com.yy.game.gamemodule.CustomerGameCallAppRouterWrap;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.NormalGamePlayer;
import com.yy.game.gamemodule.base.gameview.ComponentGameView;
import com.yy.game.gamemodule.componentgame.RoomGameCallAppRouter;
import com.yy.game.gamemodule.webgame.WebGameCallAppRouter;
import com.yy.game.growth.GameExitHelper;
import com.yy.game.module.gameload.LoadGamePageManager;
import com.yy.game.module.gameroom.ui.GameViewComponent;
import com.yy.game.module.jscallappmodule.handlers.roomhandlers.IRoomGamePlayerCallback;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.IGameDialogCallback;
import com.yy.hiyo.game.base.module.ISupportHandler;
import com.yy.hiyo.game.base.module.appcallgamemodle.AppNotifyGameDefine;
import com.yy.hiyo.game.base.module.jscallappmodule.IGameCallAppHandler;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.OpenGameContext;
import com.yy.hiyo.game.service.callback.IComponentGameView;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import com.yy.hiyo.game.service.callback.IOpenGameFunc;
import com.yy.hiyo.game.service.callback.IOpenPlayerCallback;
import com.yy.hiyo.game.service.callback.IRoomGameBridge;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import java.util.Map;
import javax.annotation.Nonnull;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenGamePlayer
extends NormalGamePlayer
implements IRoomGamePlayerCallback,
WebGameCallAppRouter.IWebGameCallAppCallback {
    private static final String TAG = "OpenGamePlayer";
    private IOpenPlayerCallback iOpenPlayerCallback;
    private CustomerGameCallAppRouterWrap customerRouter;
    private ISupportHandler supportHandler;
    private IOpenGameFunc iOpenGameFunc = new IOpenGameFunc(){

        public void appCallGameWithType(String type, Map<String, Object> msgObj, int tag, int mode) {
            if (mode == -1) {
                if (OpenGamePlayer.this.getBaseGameView().getGameComponent().isWindowShown()) {
                    OpenGamePlayer.this.getCocosMessageProxy().appCallGame(type, msgObj, tag);
                }
            } else {
                OpenGamePlayer.this.getCocosMessageProxy().appCallGame(type, msgObj, tag);
            }
        }

        public void notifyGameWithOutRegister(String res, AppNotifyGameDefine baseGameNotify) {
            if (OpenGamePlayer.this.getAppNotifyGameRouter() != null) {
                OpenGamePlayer.this.getAppNotifyGameRouter().notifyGameWithOutRegister(res, baseGameNotify);
            }
        }

        public void exitGame() {
            OpenGamePlayer.this.exitRoom(1004, 2);
        }

        public IComponentGameView gameUiCallback() {
            return new IComponentGameView(){

                public void onShow() {
                    if (OpenGamePlayer.this.getBaseGameView() != null) {
                        OpenGamePlayer.this.getBaseGameView().onContainerShown();
                    }
                }

                public void onHide() {
                    if (OpenGamePlayer.this.getBaseGameView() != null) {
                        OpenGamePlayer.this.getBaseGameView().onContainerHidden();
                    }
                }

                public void onDetach(GamePlayContext context) {
                    if (OpenGamePlayer.this.getBaseGameView() != null) {
                        OpenGamePlayer.this.getBaseGameView().onContainerDetach();
                    }
                }
            };
        }

        public void appCallGame(String context, long reqId, CocosProxyType type, Object object) {
            OpenGamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, reqId, type, object);
        }

        public void appNotityGame(String context, int event, Object object) {
            OpenGamePlayer.this.getCocosMessageProxy().getCocosProxyController().appNotifyGame(context, event, object);
        }
    };
    private boolean mActivityPause = false;

    public OpenGamePlayer(Environment env, IGameLifecycle callback2) {
        super(env, callback2);
    }

    @Override
    public void initPlay() {
        this.setPlaying(false);
    }

    @Override
    public int preLoadGame(GamePlayContext context) {
        if (context.getGameInfo() == null) {
            GameLoger.error("componentGame", "\u8f93\u5165\u53c2\u6570\u9519\u8bef\uff1acontext:%s, gameUrl:%s, gameinfo:%s", context, context != null ? context.getGameUrl() : "", context != null ? context.getGameInfo() : "");
            return 1;
        }
        return 0;
    }

    @Override
    public CocosProxyType[] getSupportedCocosProxyType() {
        return new CocosProxyType[0];
    }

    @Override
    public BaseGameCallAppRouter getCustomerGameCallAPPRouter() {
        GamePlayContext context = this.getGameContext();
        if (this.customerRouter == null && context instanceof OpenGameContext) {
            this.customerRouter = new CustomerGameCallAppRouterWrap(this.getEnvironment(), this.getCocosMessageProxy().getCocosProxyController(), this.getSupportHandler((OpenGameContext)context));
        }
        return this.customerRouter;
    }

    private ISupportHandler getSupportHandler(OpenGameContext context) {
        if (this.supportHandler == null) {
            this.supportHandler = () -> {
                IGameCallAppHandler[] all;
                IGameCallAppHandler[] room = null;
                if (this.iOpenPlayerCallback != null && this.iOpenPlayerCallback.needSupportRoomHandler()) {
                    RoomGameCallAppRouter router = new RoomGameCallAppRouter(this.getEnvironment(), this.getCocosMessageProxy().getCocosProxyController(), this);
                    room = router.getSupportHandler();
                }
                IGameCallAppHandler[] webGame = null;
                if (context.getGameInfo().getGameType() == 2) {
                    WebGameCallAppRouter router = new WebGameCallAppRouter(this.getEnvironment(), this.getCocosMessageProxy().getCocosProxyController(), this);
                    webGame = router.getSupportHandler();
                }
                IGameCallAppHandler[] customer = null;
                if (this.iOpenPlayerCallback != null && this.iOpenPlayerCallback.getSupportHandler() != null) {
                    customer = this.iOpenPlayerCallback.getSupportHandler().getSupportHandler();
                }
                if ((all = this.concat(room, webGame, customer)) != null) {
                    return all;
                }
                return new IGameCallAppHandler[0];
            };
        }
        return this.supportHandler;
    }

    private IGameCallAppHandler[] concat(IGameCallAppHandler[] xs, IGameCallAppHandler[] ys, IGameCallAppHandler[] zs) {
        int length = FP.size((Object[])xs) + FP.size((Object[])ys) + FP.size((Object[])zs);
        IGameCallAppHandler[] all = new IGameCallAppHandler[length];
        int i = 0;
        if (xs != null) {
            for (IGameCallAppHandler x : xs) {
                all[i++] = x;
            }
        }
        if (ys != null) {
            for (IGameCallAppHandler y : ys) {
                all[i++] = y;
            }
        }
        if (zs != null) {
            for (IGameCallAppHandler z : zs) {
                all[i++] = z;
            }
        }
        return all;
    }

    @Override
    public void onPreloadGameInner(@Nonnull @NotNull GamePlayContext context) {
        super.onPreloadGameInner(context);
        if (context instanceof OpenGameContext) {
            this.iOpenPlayerCallback = ((OpenGameContext)context).iOpenPlayerCallback;
            if (this.iOpenPlayerCallback != null && this.iOpenPlayerCallback.getGameMessageHandler() != null) {
                this.getCocosMessageProxy().getCocosProxyController().addGameTypeMessageHandler(this.iOpenPlayerCallback.getGameMessageHandler());
            }
            ((OpenGameContext)context).gameFuncRegister.registerGameFunc(this.iOpenGameFunc);
            this.gameRunningContext.setGameUrl(this.getCurrentGameLoader().getResourseHost(this.gameRunningContext.getGameInfo().getModulerUrl()));
            this.gameRunningContext.setRoomId(this.getCurrentGameLoader().getRandomRoomId());
            this.getBaseGameView().showGameView();
        }
    }

    @Override
    public synchronized void onGameExitedInner(GamePlayContext context, int exitType) {
        super.onGameExitedInner(context, exitType);
        this.getBaseGameView().destroyGameView();
    }

    @Override
    public void leaveGame(ILeaveGameCallback callback2) {
        super.leaveGame(callback2);
    }

    @Override
    public void leaveGameExt() {
        this.exitRoom(1004, 2);
    }

    @Override
    public void onForegroundChanged(boolean isForeground) {
        super.onForegroundChanged(isForeground);
        if (isForeground) {
            if (!this.getBaseGameView().getGameComponent().isWindowShown() && this.mActivityPause) {
                this.mActivityPause = false;
                this.getBaseGameView().getGameComponent().onActivityResume();
            }
        } else if (this.getBaseGameView().getGameComponent().isWindowShown() && !this.mActivityPause) {
            this.mActivityPause = true;
            this.getBaseGameView().getGameComponent().onActivityPause();
        }
    }

    @Override
    public boolean onPreHandleTouchEventInner(MotionEvent event) {
        if (this.iOpenPlayerCallback != null) {
            return this.iOpenPlayerCallback.onPreHandleTouchEventInner(event);
        }
        return super.onPreHandleTouchEventInner(event);
    }

    @Override
    public void exitRoomGame(int exitCode, int exitType) {
        this.exitRoom(exitCode, exitType, 2);
    }

    @Override
    @NotNull
    public GameInfo getGameInfo() {
        return this.getCurPlayingGame();
    }

    @Override
    @Nullable
    public IRoomGameBridge getRoomGameBridge() {
        if (this.iOpenPlayerCallback != null) {
            return this.iOpenPlayerCallback.getRoomGameBridge();
        }
        return null;
    }

    @Override
    public void onBackExitGame(boolean showConfirm) {
        if (showConfirm) {
            this.onBackClick();
        } else {
            this.exitRoom(1002, 2);
        }
    }

    @Override
    protected void onBackClick() {
        String gid = "";
        if (this.gameRunningContext != null && this.gameRunningContext.getGameInfo() != null) {
            gid = this.gameRunningContext.getGameInfo().getGid();
        }
        GameExitHelper.INSTANCE.callBeforeExit(gid, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

            public Unit invoke(Boolean needConfirm) {
                if (needConfirm.booleanValue()) {
                    if (OpenGamePlayer.this.getBaseGameView() == null) {
                        MLog.error((Object)OpenGamePlayer.TAG, (String)"game gameViewComponent null ,return !!!", (Object[])new Object[0]);
                    } else {
                        OpenGamePlayer.this.getBaseGameView().showExitConfirmDialog(ResourceUtils.getString((int)R.string.samescreen_game_exit_confirm), ResourceUtils.getString((int)R.string.dialog_btn_yes), ResourceUtils.getString((int)R.string.dialog_btn_no), new IGameDialogCallback(){

                            public void onOk() {
                                OpenGamePlayer.this.exitRoom(1002, 2);
                            }

                            public void onCancel() {
                            }
                        });
                    }
                } else {
                    OpenGamePlayer.this.exitRoom(1002, 2);
                }
                return null;
            }
        });
    }

    @Override
    public void receiveGameResult(@NotNull String reqJson) {
    }

    public ComponentGameView initGameView() {
        GameViewComponent gameViewComponent = new GameViewComponent(null){
            OpenGameContext gameContext;
            {
                this.gameContext = null;
            }

            @Override
            @Nullable
            public ViewGroup getFunContainer() {
                return null;
            }

            @Override
            public void onLoadingGameBg(RecycleImageView recycleImageView, int defaultColor) {
                if (OpenGamePlayer.this.gameRunningContext instanceof OpenGameContext) {
                    this.gameContext = (OpenGameContext)OpenGamePlayer.this.gameRunningContext;
                }
                if (this.gameContext != null && this.gameContext.showLoadingPage && recycleImageView != null) {
                    LoadGamePageManager.getInstance().loadGameLoadingPage(recycleImageView, OpenGamePlayer.this.gameRunningContext.getGameInfo().getGid(), defaultColor);
                }
            }

            @Override
            public void initLoadingPage(Context context, GameInfo gameInfo) {
                if (OpenGamePlayer.this.gameRunningContext instanceof OpenGameContext) {
                    this.gameContext = (OpenGameContext)OpenGamePlayer.this.gameRunningContext;
                }
                if (this.gameContext != null && this.gameContext.showLoadingPage) {
                    super.initLoadingPage(context, gameInfo);
                }
            }
        };
        return new ComponentGameView(gameViewComponent, new ComponentGameView.IComponentGameViewCallback(){

            @Override
            @NotNull
            public ViewGroup getParent() {
                return OpenGamePlayer.this.iOpenPlayerCallback.getGameViewContainer();
            }
        });
    }
}

