/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.gameext;

import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.game.gamemodule.gameext.GameGudieVoiceRoomHandler;
import com.yy.hiyo.game.base.bean.GameInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0017\u0010\u000b\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\tH\u0002J\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/yy/game/gamemodule/gameext/GameGudieVoiceRoomHandler;", "", "()V", "SENDINVITE_GAP", "", "hasPlayGameTimes", "", "hasRejectInviteTimes", "addRejectInviteTimes", "", "mode", "checkGameMode", "", "(Ljava/lang/Integer;)Z", "handleSendVoiceRoomInvite", "onGameExited", "gameInfo", "Lcom/yy/hiyo/game/base/bean/GameInfo;", "gameExitType", "onInviteGameReject", "onInviteGameTimeOut", "sendVoiceRoomInvite", "game_debug"})
public final class GameGudieVoiceRoomHandler {
    private final long SENDINVITE_GAP = 15000L;
    private int hasPlayGameTimes;
    private volatile int hasRejectInviteTimes;

    public final void onGameExited(@NotNull GameInfo gameInfo, int gameExitType) {
        Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
        int mode = gameInfo.getGameMode();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"GameGudieVoiceRoomHandler", (String)"onGameExited", (Object[])new Object[0]);
        }
        if (this.checkGameMode(mode) && AccountUtil.isTodayRegister()) {
            int n = this.hasPlayGameTimes;
            this.hasPlayGameTimes = n + 1;
            this.handleSendVoiceRoomInvite();
        }
    }

    public final void onInviteGameReject(@NotNull GameInfo gameInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
        this.addRejectInviteTimes(gameInfo.getGameMode());
    }

    public final void onInviteGameTimeOut(@NotNull GameInfo gameInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
        this.addRejectInviteTimes(gameInfo.getGameMode());
    }

    public final void addRejectInviteTimes(int mode) {
        if (this.checkGameMode(mode) && AccountUtil.isTodayRegister()) {
            int n = this.hasRejectInviteTimes;
            this.hasRejectInviteTimes = n + 1;
        }
    }

    private final void handleSendVoiceRoomInvite() {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"GameGudieVoiceRoomHandler", (String)"handleSendVoiceRoomInvite,hasPlayGameTimes%s,hasRejectInviteTimes%s", (Object[])new Object[]{this.hasRejectInviteTimes, this.hasRejectInviteTimes});
        }
        if (this.hasPlayGameTimes <= 4 && this.hasRejectInviteTimes >= 2) {
            this.sendVoiceRoomInvite();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkGameMode(Integer mode) {
        Integer n = mode;
        int n2 = 1;
        if (n != null) {
            if (n == n2) return true;
        }
        Integer n3 = mode;
        n2 = 4;
        if (n3 != null) {
            if (n3 == n2) return true;
        }
        Integer n4 = mode;
        n2 = 7;
        if (n4 == null) return false;
        if (n4 != n2) return false;
        return true;
    }

    public final void sendVoiceRoomInvite() {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"GameGudieVoiceRoomHandler", (String)"sendVoiceRoomInvite", (Object[])new Object[0]);
        }
        YYTaskExecutor.postToMainThread((Runnable)sendVoiceRoomInvite.1.INSTANCE, (long)this.SENDINVITE_GAP);
    }
}

