/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.componentgame;

import android.view.ViewGroup;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.game.bean.GameDataModel;
import com.yy.game.gamemodule.BaseGameCallAppRouter;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.NormalGamePlayer;
import com.yy.game.gamemodule.base.gameview.ComponentGameView;
import com.yy.game.gamemodule.common.GameProfileCardHandler;
import com.yy.game.gamemodule.componentgame.RoomGameCallAppRouter;
import com.yy.game.module.gameload.LoadGamePageManager;
import com.yy.game.module.gameroom.ui.GameViewComponent;
import com.yy.game.module.jscallappmodule.handlers.roomhandlers.IRoomGamePlayerCallback;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.bean.GameComponentContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.IComponentGameFunc;
import com.yy.hiyo.game.service.callback.IComponentGameView;
import com.yy.hiyo.game.service.callback.IRoomGameBridge;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentGamePlayer
extends NormalGamePlayer
implements IRoomGamePlayerCallback {
    private static final long EXIT_ROOM_TIME_OUT = 500L;
    private IRoomGameBridge roomGameBridge;
    private IComponentGameFunc funCallback = new IComponentGameFunc(){

        public IComponentGameView gameUiCallback() {
            return new IComponentGameView(){

                public void onShow() {
                    if (ComponentGamePlayer.this.getBaseGameView() != null) {
                        ComponentGamePlayer.this.getBaseGameView().onContainerShown();
                    }
                }

                public void onHide() {
                    if (ComponentGamePlayer.this.getBaseGameView() != null) {
                        ComponentGamePlayer.this.getBaseGameView().onContainerHidden();
                    }
                }

                public void onDetach(GamePlayContext context) {
                    if (ComponentGamePlayer.this.getCurPlayingGameContext() == context) {
                        if (ComponentGamePlayer.this.getBaseGameView() != null) {
                            ComponentGamePlayer.this.getBaseGameView().onContainerDetach();
                        }
                        ComponentGamePlayer.this.roomGameBridge = null;
                    }
                }
            };
        }

        public void appCallGame(String context, long reqId, CocosProxyType type, Object object) {
            ComponentGamePlayer.this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, reqId, type, object);
        }

        public void appNotityGame(String context, int event, Object object) {
            ComponentGamePlayer.this.getCocosMessageProxy().getCocosProxyController().appNotifyGame(context, event, object);
        }
    };
    public Runnable mExitRunable = new YYTaskExecutor.RunnableEx(){

        public void run() {
            ComponentGamePlayer.this.exitRoom(1004, 2);
        }
    };

    public ComponentGamePlayer(Environment env, IGameLifecycle callback2) {
        super(env, callback2);
    }

    @Override
    public int preLoadGame(GamePlayContext context) {
        if (!(context instanceof GameComponentContext) || StringUtils.isEmpty((String)context.getGameUrl()) || context.getGameInfo() == null || ((GameComponentContext)context).gameViewCallback == null) {
            GameLoger.error("componentGame", "\u8f93\u5165\u53c2\u6570\u9519\u8bef\uff1acontext:%s, gameUrl:%s, gameinfo:%s", context, context != null ? context.getGameUrl() : "", context != null ? context.getGameInfo() : "");
            return 1;
        }
        return 0;
    }

    @Override
    public void onPreloadGameInner(@Nonnull @NotNull GamePlayContext context) {
        super.onPreloadGameInner(context);
        if (context instanceof GameComponentContext) {
            ((GameComponentContext)context).gameFuncRegister.registerGameFunc(this.funCallback);
            ((GameComponentContext)context).gameFuncRegister = null;
            this.roomGameBridge = ((GameComponentContext)context).roomGameBridge;
        }
        this.getBaseGameView().showGameView();
    }

    public ComponentGameView initGameView() {
        String windowTag = null;
        if (this.gameRunningContext instanceof GameComponentContext) {
            windowTag = ((GameComponentContext)this.gameRunningContext).windowTag;
        }
        GameViewComponent gameViewComponent = new GameViewComponent(windowTag){

            @Override
            @Nullable
            public ViewGroup getFunContainer() {
                return null;
            }

            @Override
            public void onLoadingGameBg(RecycleImageView recycleImageView, int defaultColor) {
                if (recycleImageView != null) {
                    LoadGamePageManager.getInstance().loadGameLoadingPage(recycleImageView, ComponentGamePlayer.this.gameRunningContext.getGameInfo().getGid(), defaultColor);
                }
            }
        };
        return new ComponentGameView(gameViewComponent, new ComponentGameView.IComponentGameViewCallback(){

            @Override
            @androidx.annotation.Nullable
            public ViewGroup getParent() {
                YYFrameLayout viewGroup = null;
                if (ComponentGamePlayer.this.gameRunningContext instanceof GameComponentContext) {
                    viewGroup = ((GameComponentContext)((ComponentGamePlayer)ComponentGamePlayer.this).gameRunningContext).gameViewCallback.getGameViewContainer();
                    ((GameComponentContext)((ComponentGamePlayer)ComponentGamePlayer.this).gameRunningContext).gameViewCallback = null;
                }
                return viewGroup;
            }
        });
    }

    @Override
    public synchronized void onGameExitedInner(GamePlayContext context, int exitType) {
        super.onGameExitedInner(context, exitType);
        this.getBaseGameView().destroyGameView();
    }

    @Override
    public void leaveGameExt() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mExitRunable);
        YYTaskExecutor.postToMainThread((Runnable)this.mExitRunable, (long)500L);
        this.getCocosMessageProxy().getGameProxyService().getBaseService().appGameExit(this.gameRunningContext.getRoomId());
        if (this.isGameStarted()) {
            GameDataModel.instance.postGameForceExit(this.gameRunningContext.getRoomId(), this.gameRunningContext.getGameInfo() != null ? this.gameRunningContext.getGameInfo().getGid() : null, 0L, this.gameRunningContext.mFrom.getId());
        }
    }

    @Override
    public void onPlayGameFinishInner(GamePlayContext context, int finishType) {
        super.onPlayGameFinishInner(context, finishType);
        if (finishType == 2) {
            this.exitRoom(13);
        } else {
            this.exitRoom(1);
        }
    }

    @Override
    public CocosProxyType[] getSupportedCocosProxyType() {
        return new CocosProxyType[0];
    }

    @Override
    public BaseGameCallAppRouter getCustomerGameCallAPPRouter() {
        return new RoomGameCallAppRouter(this.getEnvironment(), this.getCocosMessageProxy().getCocosProxyController(), this);
    }

    @Override
    protected GameProfileCardHandler getGameProfileCardHandler() {
        if (this.gameProfileCardHandler == null) {
            this.gameProfileCardHandler = new GameProfileCardHandler(this.getEnvironment()){

                @Override
                public void showProfileCard(long uid, GameInfo gameInfo) {
                    if (ComponentGamePlayer.this.roomGameBridge != null && uid != 0L) {
                        ComponentGamePlayer.this.roomGameBridge.openUserCard(uid);
                    }
                }
            };
        }
        return this.gameProfileCardHandler;
    }

    @Override
    public void exitRoomGame(int exitCode, int exitType) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mExitRunable);
        this.exitRoom(exitCode, exitType, 2);
    }

    @Override
    @NotNull
    public GameInfo getGameInfo() {
        return this.getCurPlayingGame();
    }

    @Override
    @Nullable
    public IRoomGameBridge getRoomGameBridge() {
        return this.roomGameBridge;
    }
}

