/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.common;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.game.R;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class GameProfileCardHandler
extends DefaultController {
    private GameInfo mGameInfo;
    private IGameLifecycle mGameLifeCycle = new GameLifeWrapper(){

        public void onGameExited(GamePlayContext context, int gameExitType) {
            super.onGameExited(context, gameExitType);
            GameProfileCardHandler.this.dismissProfileCard();
        }
    };

    public GameProfileCardHandler(Environment env) {
        super(env);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle(this.mGameLifeCycle);
    }

    public void showProfileCard(long uid, GameInfo gameInfo) {
        if (gameInfo == null) {
            return;
        }
        if (uid == AccountUtil.getUid()) {
            return;
        }
        this.mGameInfo = gameInfo;
        int direction = 1;
        if (gameInfo.getScreenDire() == 2) {
            direction = 0;
        }
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).showProfileCard((Context)this.mContext, direction, uid, null, true);
    }

    public void dismissProfileCard() {
        this.mDialogLinkManager.dismissDialog();
    }

    public void showFriendAcceptToast(long uid) {
        ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (userInfoKSList == null) {
                    return;
                }
                UserInfoKS userInfoKS = userInfoKSList.get(0);
                if (userInfoKS == null) {
                    return;
                }
                if (GameProfileCardHandler.this.getCurrentWindow() != null && GameProfileCardHandler.this.getCurrentWindow().getWindowType() == 103) {
                    ToastUtils.showToast((Context)GameProfileCardHandler.this.mContext, (String)ResourceUtils.getString((int)R.string.short_tips_game_result_accept_friend, (Object[])new Object[]{ShortNameUtils.getShortName((String)userInfoKS.nick, (int)7)}), (int)0);
                }
            }

            public void onFail(int id2, String msg, String response) {
            }

            public int id() {
                return 0;
            }
        });
    }

    private void showInternetError() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast((Context)GameProfileCardHandler.this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            }
        });
    }

    private void reportAddFriendClick(long uid, String gid) {
        HiidoEvent event = HiidoEvent.obtain().eventId("20023803").put("function_id", "1").put("ent_id", "16").put("act_uid", "" + uid).put("gid", gid);
        HiidoStatis.reportEvent((HiidoEvent)event);
    }
}

