/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.base;

import android.app.Activity;
import android.content.Context;
import android.view.KeyEvent;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import com.yy.appbase.data.GameResultDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.service.cocosproxy.IAppNotifyGameFunction;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.webview.WebViewPanel;
import com.yy.appbase.util.KeepScreenOnTask;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.game.R;
import com.yy.game.base.BaseGamePresenter;
import com.yy.game.base.GameMvpContext;
import com.yy.game.base.GameRunningEnv;
import com.yy.game.bean.GameResultDb;
import com.yy.game.bean.GameResultWebBean;
import com.yy.game.cocos2d.EngineContext;
import com.yy.game.cocos2d.NetMetricsMonitor;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.gamemodule.BaseGameCallAppRouter;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.INormalGameCallback;
import com.yy.game.gamemodule.base.AbsGamePlayer;
import com.yy.game.gamemodule.base.gameview.IGameView;
import com.yy.game.gamemodule.base.gameview.IPlayerGameView;
import com.yy.game.gamemodule.common.GameProfileCardHandler;
import com.yy.game.gameproxy.AppNotifyGameController;
import com.yy.game.module.ads.BannerAdPresent;
import com.yy.game.module.ads.RewardAdPresent;
import com.yy.game.module.appcallgamemodle.AppNotifyGameRouter;
import com.yy.game.module.audiorecord.GameAudioRecordRouter;
import com.yy.game.module.jscallappmodule.CallGameByEvent;
import com.yy.game.module.jscallappmodule.CallGameByType;
import com.yy.game.module.jscallappmodule.ComGameCallAppRouter;
import com.yy.game.module.jscallappmodule.GameCallAppController;
import com.yy.game.module.jscallappmodule.gamegroup.GameGroupRouter;
import com.yy.game.utils.GameReportHelper;
import com.yy.game.utils.GameResultHelper;
import com.yy.game.utils.GameStateDef;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.GameResultBean;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.helper.GameReportV1;
import com.yy.hiyo.game.base.module.appcallgamemodle.AppNotifyGameDefine;
import com.yy.hiyo.game.base.module.jscallappmodule.IComGameCallAppCallBack;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.voice.base.bean.UserSpeakStatus;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class NormalGamePlayer
extends AbsGamePlayer
implements INormalGameCallback {
    private static final String TAG = "NormalGamePlayer";
    private KeepScreenOnTask mKeepScreenOnTask;
    private boolean isLoadSuccess = false;
    protected long mGameStartTime = 0L;
    protected long mGameFirstFrameTime = 0L;
    private AppNotifyGameController mAppNotifyGameController;
    private CopyOnWriteArrayList<ILeaveGameCallback> mLeaveGameCallbacks = new CopyOnWriteArrayList();
    private CocoViewBean mCocosViewLocation = new CocoViewBean();
    protected GameProfileCardHandler gameProfileCardHandler;
    protected boolean isGoldGame = false;
    private long enterBackgroundTs;
    public AppNotifyGameRouter mAppNotifyGameRouter = new AppNotifyGameRouter();
    private BaseGameCallAppRouter mCustomerRouter;
    private GameAudioRecordRouter mGameAudioRecordRouter;
    private GameGroupRouter mGameGroupRouter;
    private GameCallAppController mGameCallAppController;
    private boolean mIsHiddenFinish = false;
    protected String mSessionId;
    Runnable mExitRunnable;

    public NormalGamePlayer(Environment env, IGameLifecycle callback2) {
        super(env, callback2);
        this.mKeepScreenOnTask = new KeepScreenOnTask();
        this.mAppNotifyGameController = new AppNotifyGameController(env, this.getCocosMessageProxy().getCocosProxyController());
    }

    @Override
    @CallSuper
    int joinGame(GameInfo info, GamePlayContext context) {
        this.gameRunningContext = context;
        this.isGoldGame = false;
        this.mIsHiddenFinish = false;
        this.mGameReport.initSession();
        this.mGameReport.setGameId(info.gid == null ? "" : info.gid);
        this.mGameReport.setGameVersion(info.getModulerVer() == null ? "" : info.getModulerVer());
        this.mGameReport.setMGamePlayContext(this.gameRunningContext);
        if (context != null) {
            context.setGameInfo(info);
            if (!this.gameRunningContext.getGameInfo().isWebGame()) {
                String tmpPath;
                String path = GameDownloadUtils.getGameLocalFullPath((BasicGameInfo)this.gameRunningContext.getGameInfo());
                if (SettingFlags.getBoolean((String)"key_game_local_dev", (boolean)false) && StringUtils.isNotEmpty((String)(tmpPath = SettingFlags.getStringValue((String)"key_game_local_dev_path")))) {
                    path = tmpPath;
                }
                this.gameRunningContext.gamePath = path;
            }
            this.isGoldGame = (Boolean)context.getExtendValue("isGoldGame", (Object)false);
        }
        this.mGameMvpContext = new GameMvpContext(this.mContext, gamePresenter -> {
            gamePresenter.gameContext = this.gameRunningContext;
            gamePresenter.env = this.getEnvironment();
            gamePresenter.msgService = this.getCocosMessageProxy().getCocosProxyController();
            gamePresenter.gameRunningEnv = new GameRunningEnv();
            gamePresenter.gameRunningEnv.mBaseGameView = this.getBaseGameView();
            gamePresenter.setAppNotifyGameRouter(this.mAppNotifyGameRouter);
        });
        this.mGameMvpContext.lifecycleOwner = this.getGameLifeCycle();
        this.mGamePlayInfo.onInitStart();
        if (this.preLoadGame(context) != 0) {
            this.onGamePreInitFail(1005);
            return 1;
        }
        this.onPreloadGame(context);
        return 0;
    }

    @Override
    void onPreloadGame(GamePlayContext context) {
        super.onPreloadGame(context);
        this.onPreInitPresent();
        this.preInitPresent();
        this.mGameAudioRecordRouter = new GameAudioRecordRouter(this.getEnvironment(), this.getCocosMessageProxy().getCocosProxyController(), this.mAppNotifyGameRouter);
        this.mGameAudioRecordRouter.init(context.getGameInfo());
        this.mAppNotifyGameController.init();
        this.mCustomerRouter = this.getCustomerGameCallAPPRouter();
        if (this.mCustomerRouter != null) {
            this.mCustomerRouter.init(context.getGameInfo());
        }
        this.mGameCallAppController = new GameCallAppController(this.getEnvironment(), this, this.getCocosMessageProxy().getCocosProxyController());
        this.mGameCallAppController.init();
        this.mGameGroupRouter = new GameGroupRouter(this.getEnvironment(), this.getCocosMessageProxy().getCocosProxyController(), this.getAppNotifyGameRouter());
        this.mGameGroupRouter.init(context.getGameInfo());
        this.getCocosMessageProxy().getCocosProxyController().addGameNotifyFunction((IAppNotifyGameFunction)this.mAppNotifyGameController);
    }

    private void preInitPresent() {
        for (Class<? extends BaseGamePresenter> item : this.getNeedPreInitPresent()) {
            this.mGameMvpContext.getPresenter(item);
        }
    }

    @CallSuper
    void onPreInitPresent() {
        this.mGameMvpContext.getPresenter(ComGameCallAppRouter.class).initInner(this);
    }

    @Override
    public int restartGame(GameInfo info, GamePlayContext context) {
        return 1;
    }

    @Override
    public GameInfo getCurPlayingGame() {
        return this.gameRunningContext.getGameInfo();
    }

    @Override
    public void onReceiveGameEvent(String context, long seqId, int event, Vector<String> args) {
    }

    public void insertAndGetResultDataFromDB(GameResultBean gameResultBean) {
        if (gameResultBean != null && gameResultBean.getWinners() != null) {
            MyBox myBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(GameResultDBBean.class);
            if (myBox == null) {
                return;
            }
            if (!gameResultBean.isDraw()) {
                GameResultDb.getInstance().insertGameResult(gameResultBean, myBox);
            }
        }
    }

    @Override
    protected void resetLocal() {
        super.resetLocal();
        this.gameResultWebBean = null;
    }

    protected synchronized void generateGameResult() {
        try {
            this.gameResultWebBean = (GameResultWebBean)JsonParser.parseJsonObject((String)this.gameRunningContext.getGameResult(), GameResultWebBean.class);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
        }
        GameResultBean gameResult = GameResultHelper.pkGameGenResult(this.gameResultWebBean, this.gameRunningContext);
        if (gameResult != null) {
            gameResult = GameResultBean.newBuilder((GameResultBean)gameResult).isExitFromGame(this.getGameExitType() == 2).sessionId(this.mSessionId).build();
        }
        this.gameRunningContext.setGameResultBean(gameResult);
    }

    public abstract int preLoadGame(GamePlayContext var1);

    @Override
    public void leaveGame(ILeaveGameCallback callback2) {
        if (callback2 != null) {
            this.mLeaveGameCallbacks.add(callback2);
        }
        this.leaveGameExt();
    }

    public abstract void leaveGameExt();

    @Override
    @CallSuper
    public void onPreloadGameInner(@Nonnull GamePlayContext context) {
        this.registerInner();
        this.mGameFirstFrameTime = 0L;
        this.mGameStartTime = System.currentTimeMillis();
        if (!RuntimeContext.sIsForeground) {
            this.enterBackgroundTs = System.currentTimeMillis();
        }
    }

    @Override
    public void onLoadGameFinishBase(GamePlayContext context, int finishType) {
        GameInfo gameInfo;
        if (finishType == 1) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_error), (int)0);
            if (context.mFrom == GameContextDef.JoinFrom.FROM_HAGO_GROUP) {
                this.exitRoom(14);
            } else {
                this.exitRoom(12);
            }
            if (this.gameRunningContext.getGameInfo() != null) {
                YYTaskExecutor.execute(() -> {
                    HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20027421").put("function_Id", "7").put("event_time", String.valueOf(System.currentTimeMillis())).put("error_code", "0").put("room_id", this.gameRunningContext.getRoomId()).put("gid", this.gameRunningContext.getGameInfo().getGid());
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)JsonParser.toJson((Object)hiidoEvent), (Object[])new Object[0]);
                    }
                    HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
                });
            }
            GameReportHelper.reportGameInfo(GameModel.newBuilder().gameInfo(this.gameRunningContext.getGameInfo()).roomid(this.gameRunningContext.getRoomId()).build(), (int)(System.currentTimeMillis() - this.mGameStartTime), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.INIT_ERROR.value(), 0, this.isGoldGame);
        } else if (finishType == 0) {
            this.mGameFirstFrameTime = System.currentTimeMillis();
            if (this.gameRunningContext.getGameInfo() != null) {
                YYTaskExecutor.execute(() -> {
                    HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20027421").put("function_Id", "5").put("event_time", String.valueOf(System.currentTimeMillis())).put("error_code", "0").put("room_id", this.gameRunningContext.getRoomId()).put("gid", this.gameRunningContext.getGameInfo().getGid());
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)JsonParser.toJson((Object)hiidoEvent.getEventProperty()), (Object[])new Object[0]);
                    }
                    HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
                });
            }
            Object iComGameCallAppCallBack = context.getGameInfo().isWebGame() ? new CallGameByType(0, this.getCocosMessageProxy().getCocosProxyController()) : new CallGameByEvent(context.getRoomId(), 0L, this.getCocosMessageProxy().getCocosProxyController());
            this.mAppNotifyGameRouter.setComCallGame((IComGameCallAppCallBack)iComGameCallAppCallBack);
        } else if (finishType == 3) {
            GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.mGameStartTime), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.OVER_TIME.value(), 0, this.isGoldGame);
        } else if (finishType == 4) {
            this.exitRoom(16);
        }
        this.onLoadGameFinishInner(context, finishType);
        GameInfo gameInfo2 = gameInfo = this.gameRunningContext != null ? this.gameRunningContext.getGameInfo() : null;
        if (gameInfo != null) {
            GameReportV1.Companion.reportGameFirstFrameTime(gameInfo.gid, finishType == 0 ? System.currentTimeMillis() - this.mGameStartTime : 0L, Integer.toString(finishType));
        }
    }

    @Override
    public void onPlayGameStartInner(GamePlayContext context) {
    }

    @Override
    public void onPlayGameFinishInner(GamePlayContext context, int finishType) {
    }

    @Override
    public void onPreGameExitInner(GamePlayContext context) {
    }

    @Override
    public void onGameLoadingFinishInner() {
        this.isLoadSuccess = true;
        if (this.gameRunningContext != null && this.gameRunningContext.getGameInfo() != null && this.gameRunningContext.getGameInfo().getGameMode() != 8) {
            this.mKeepScreenOnTask.keepScreenOn((Activity)this.mContext);
        }
    }

    protected void exitRoomWithType() {
        int exitType;
        GameResultBean gameResultBean = this.gameRunningContext.getGameResultBean();
        if (this.gameResultWebBean == null || this.gameResultWebBean.getResult() == null || this.gameResultWebBean.getResult().getUsers() == null) {
            if (RuntimeContext.sIsDebuggable) {
                boolean isGameFirstPageOpen = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
                boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
                exitType = isGameFirstPageOpen || isGameAutoOpen ? 1 : 5;
            } else {
                exitType = 5;
            }
        } else if (StringUtils.isEmpty((String)this.gameResultWebBean.getResult().getResulttype())) {
            exitType = 5;
        } else {
            switch (this.gameResultWebBean.getResult().getResulttype()) {
                case "not_draw": {
                    if (gameResultBean == null) {
                        exitType = 5;
                        break;
                    }
                    exitType = 1;
                    break;
                }
                case "notstart": {
                    exitType = this.exitNoStart();
                    break;
                }
                default: {
                    exitType = 1;
                }
            }
        }
        this.exitRoom(exitType);
    }

    protected int exitNoStart() {
        TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.user_escape), (int)0);
        GameReportHelper.reportGameInfo(this.gameRunningContext.buildGameModel(), (int)(System.currentTimeMillis() - this.getGameStartTime()), this.gameRunningContext.getFrom().getId(), GameStateDef.GAME_FINISH_REASON.NOT_START.value(), 0, this.isGoldGame);
        if (this.gameRunningContext.getFrom().getId() == IGameService.GAME_FROM.FROM_IM.value() || this.gameRunningContext.getFrom().getId() == IGameService.GAME_FROM.FROM_NOTIFY.value()) {
            return 1;
        }
        if (this.gameRunningContext.getFrom() == GameContextDef.JoinFrom.FROM_HAGO_GROUP) {
            return 5;
        }
        return 6;
    }

    @Override
    public synchronized void onGameExitedInner(GamePlayContext context, int exitType) {
        this.unRegisterInner();
        if (context != null && context.getGameInfo() != null && context.getGameInfo().getGameMode() != 8) {
            this.mKeepScreenOnTask.unDoKeepScreenOn((Activity)this.mContext);
        }
        if (this.mCustomerRouter != null) {
            this.mCustomerRouter.destroyRouter();
            this.mCustomerRouter = null;
        }
        if (this.mGameAudioRecordRouter != null) {
            this.mGameAudioRecordRouter.destroyRouter();
            this.mGameAudioRecordRouter = null;
        }
        if (this.mGameCallAppController != null) {
            this.mGameCallAppController.destory();
            this.mGameCallAppController = null;
        }
        if (this.mGameGroupRouter != null) {
            this.mGameGroupRouter.destroy();
            this.mGameGroupRouter = null;
        }
        this.mAppNotifyGameController.uninit();
        for (ILeaveGameCallback leaveGameCallback : this.mLeaveGameCallbacks) {
            if (leaveGameCallback == null) continue;
            leaveGameCallback.onGameLeaved(this.gameRunningContext.getGameInfo(), this.gameRunningContext);
        }
        this.mLeaveGameCallbacks.clear();
        Runnable exitRunnable = this.mExitRunnable;
        if (exitRunnable != null) {
            exitRunnable.run();
        }
        this.mExitRunnable = null;
    }

    private void registerInner() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_MAIN_ACTIVITY_STOP, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FULL_SCREEN_SHORTCUT_MODE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_APP_DESTROY, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.SPEAK_VOLUME_INDICATION, (INotify)this);
    }

    private void unRegisterInner() {
        this.unregisterFromMsgDispatcher();
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_MAIN_ACTIVITY_STOP, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_APP_DESTROY, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_FULL_SCREEN_SHORTCUT_MODE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationIdDef.SPEAK_VOLUME_INDICATION, (INotify)this);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_MAIN_ACTIVITY_STOP) {
            if (this.getBaseGameView() != null) {
                this.getBaseGameView().onActivityStop();
            }
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("N_FOREGROUND_CHANGE" + notification.extObj), (Object[])new Object[0]);
            }
            boolean isForeground = (Boolean)notification.extObj;
            if (this.getBaseGameView() != null) {
                this.onForegroundChanged(isForeground);
                this.getBaseGameView().onForegroundChanged(isForeground, this.mWindowMgr.getCurrentWindow());
                if (isForeground) {
                    this.getCocosMessageProxy().getGameProxyService().getInfoService().appEnterForeground(this.getCurPlayingGameContext().getRoomId());
                } else {
                    this.getCocosMessageProxy().getGameProxyService().getInfoService().appEnterBackground(this.getCurPlayingGameContext().getRoomId());
                }
                if (isForeground) {
                    long duration = System.currentTimeMillis() - this.enterBackgroundTs;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"enter background duration:%d", (Object[])new Object[]{duration});
                    }
                    if (this.isPlaying() && duration >= 86400000L) {
                        this.exitRoom(1);
                    }
                } else {
                    this.enterBackgroundTs = System.currentTimeMillis();
                }
            }
        } else if (notification.id == NotificationIdDef.SPEAK_VOLUME_INDICATION) {
            if (notification.extObj instanceof UserSpeakStatus) {
                UserSpeakStatus userSpeakStatus = (UserSpeakStatus)notification.extObj;
                this.onReceiveSpeakChange(userSpeakStatus);
            }
        } else if (notification.id == NotificationDef.N_FULL_SCREEN_SHORTCUT_MODE_CHANGE && notification.extObj instanceof Boolean) {
            this.onFullScreenShortCutChange((Boolean)notification.extObj);
        }
    }

    public void onFullScreenShortCutChange(boolean isShortCut) {
    }

    @Override
    protected CocosProxyType[] getSupportedCocosProxyTypeInner() {
        return new CocosProxyType[]{CocosProxyType.showUserCard, CocosProxyType.showUserInfoDialog, CocosProxyType.isEventCurrentSupport, CocosProxyType.showWebViewDialog};
    }

    @Override
    protected boolean onReceiveGameEventInner(String context, long seqId, int event, Vector<String> args) {
        String arg = "";
        if (args != null && args.size() > 0) {
            arg = args.get(0);
        }
        String reqJson = arg;
        if (event == CocosProxyType.showUserCard.getEvent()) {
            YYTaskExecutor.execute(() -> {
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)reqJson);
                    long targetUid = jsonObject.optLong("uid", 0L);
                    YYTaskExecutor.postToMainThread(() -> this.showProfileCard(targetUid));
                }
                catch (JSONException e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            });
            return true;
        }
        if (event == CocosProxyType.showUserInfoDialog.getEvent()) {
            YYTaskExecutor.execute(() -> {
                try {
                    JSONObject jo = JsonParser.obtainJSONObject((String)reqJson);
                    long uid = jo.optLong("uid", 0L);
                    YYTaskExecutor.postToMainThread(() -> this.showProfileCard(uid));
                }
                catch (JSONException e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            });
            return true;
        }
        if (event == CocosProxyType.showWebViewDialog.getEvent()) {
            YYTaskExecutor.execute(() -> {
                try {
                    JSONObject jo = JsonParser.obtainJSONObject((String)reqJson);
                    String url = jo.optString("url", "");
                    int width = jo.optInt("width", 0);
                    int height = jo.optInt("height", 0);
                    YYTaskExecutor.postToMainThread(() -> this.showWebViewPanel(url, width, height));
                }
                catch (JSONException e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            });
            return true;
        }
        if (event == CocosProxyType.isEventCurrentSupport.getEvent()) {
            this.isEventIdSupport(context, seqId, reqJson);
        }
        return super.onReceiveGameEventInner(context, seqId, event, args);
    }

    private void isEventIdSupport(String context, long seqId, String reqJson) {
        YYTaskExecutor.execute(() -> {
            boolean support = false;
            try {
                JSONObject jsonObject = JsonParser.obtainJSONObject((String)reqJson);
                int defaultId = -1;
                int eventId = jsonObject.optInt("eventId", defaultId);
                if (eventId == defaultId) {
                    support = false;
                } else if (this.cocosProxyService != null) {
                    support = this.cocosProxyService.isSupportFunction(eventId);
                }
                JSONObject jsonRet = JsonParser.obtainJSONObject();
                jsonRet.put("eventId", eventId);
                jsonRet.put("isSupport", support);
                this.getCocosMessageProxy().getCocosProxyController().callGameFunction(context, seqId, CocosProxyType.isEventCurrentSupportCallback, jsonRet.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
                GameLoger.error("normalPlayer", "isEventCurrentSupport parse exception,json:%s", reqJson);
            }
        });
    }

    @Override
    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (this.isLoadSuccess) {
            this.mKeepScreenOnTask.keepScreenOn((Activity)this.mContext);
        }
    }

    @Override
    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        if (this.isHiddenFinish() && this.getBaseGameView() != null) {
            this.getBaseGameView().destroyGameView();
        }
        this.mKeepScreenOnTask.unDoKeepScreenOn((Activity)this.mContext);
    }

    @Override
    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
    }

    public void onWindowExitEvent(boolean withAnimation) {
        super.onWindowExitEvent(withAnimation);
        this.mKeepScreenOnTask.unDoKeepScreenOn((Activity)this.mContext);
    }

    protected void onReceiveSpeakChange(UserSpeakStatus userSpeakStatus) {
    }

    protected final long getGameStartTime() {
        return this.mGameStartTime;
    }

    protected final long getGameFirstFrameTime() {
        return this.mGameFirstFrameTime;
    }

    @Override
    public void onCoCosViewLocationChangeInner(CocoViewBean cocoViewBean) {
        YYTaskExecutor.postToMainThread(() -> {
            if (this.mCocosViewLocation != null && cocoViewBean != null) {
                this.mCocosViewLocation.setHeight(cocoViewBean.getHeight());
                this.mCocosViewLocation.setWidth(cocoViewBean.getWidth());
                int[] cocosViewLocation = cocoViewBean.getLocation();
                if (this.mDeviceMgr != null && this.mDeviceMgr.isSysStatusBarShowing() && cocosViewLocation != null && cocosViewLocation.length == 2) {
                    cocosViewLocation[1] = cocosViewLocation[1] - SystemUtils.getStatusBarHeight((Context)this.mContext);
                }
                this.mCocosViewLocation.setLocation(cocosViewLocation);
            }
        });
    }

    @Override
    public CocoViewBean getCocosViewData() {
        return this.mCocosViewLocation;
    }

    protected GameProfileCardHandler getGameProfileCardHandler() {
        if (this.gameProfileCardHandler == null) {
            this.gameProfileCardHandler = new GameProfileCardHandler(this.getEnvironment());
        }
        return this.gameProfileCardHandler;
    }

    protected void showProfileCard(long uid) {
        GameInfo gameInfo = this.gameRunningContext.getGameInfo();
        this.getGameProfileCardHandler().showProfileCard(uid, gameInfo);
    }

    private void showWebViewPanel(String url, int width, int height) {
        if (this.getBaseGameView() == null) {
            return;
        }
        if (FP.empty((CharSequence)url)) {
            return;
        }
        WebViewPanel webViewPanel = new WebViewPanel((Context)this.mContext);
        webViewPanel.setData(url, width, height);
        this.getBaseGameView().getViewPanelLayer().showPanel((BasePanel)webViewPanel, false);
    }

    @Override
    public void notifyGameInvite(GameMessageModel gameMessageModel) {
        if (this.gameRunningContext == null) {
            return;
        }
        GameLoger.info("baseGame", "notifyGameInvite", new Object[0]);
        if (this.mAppNotifyGameRouter != null) {
            this.mAppNotifyGameRouter.notifyGame(gameMessageModel, AppNotifyGameDefine.NotifyInvitation);
        }
    }

    public void onForegroundChanged(boolean isForeground) {
    }

    public AppNotifyGameRouter getAppNotifyGameRouter() {
        return this.mAppNotifyGameRouter;
    }

    @Override
    public GameInfo getGamingInfo() {
        return this.getCurPlayingGame();
    }

    @Override
    public EngineContext getEngineContext() {
        if (this.mBaseGameView != null) {
            return this.mBaseGameView.getGameWindow().getEngineContext();
        }
        return null;
    }

    @Override
    public GamePlayContext getGameContext() {
        return this.getCurPlayingGameContext();
    }

    @Override
    public Activity getContext() {
        return this.mContext;
    }

    @Override
    public long getStartTime() {
        return this.mGameStartTime;
    }

    @Override
    @NotNull
    public PanelLayer getPlayerPanelLayer() {
        return this.getBaseGameView().getViewPanelLayer();
    }

    @Override
    public void exitGameNormal(@NotNull Runnable runnable2, boolean isHiddenFinish) {
        this.mExitRunnable = runnable2;
        this.mIsHiddenFinish = isHiddenFinish;
        this.exitRoom(1);
    }

    public boolean isHiddenFinish() {
        return this.mIsHiddenFinish;
    }

    @Override
    @Nullable
    public ViewGroup getVideoContainer() {
        if (this.getBaseGameView() != null && this.getBaseGameView().getGameWindow() != null) {
            return this.getBaseGameView().getGameWindow().getExtLayer();
        }
        return null;
    }

    public BaseGameCallAppRouter getCustomerGameCallAPPRouter() {
        return null;
    }

    public void onLoadGameFinishInner(GamePlayContext context, int finishType) {
    }

    @Override
    public IPlayerGameView<? extends IGameView> initGameView() {
        return null;
    }

    @Override
    public void onGamePreloadFinishInner() {
        NetMetricsMonitor netMetricsMonitor = new NetMetricsMonitor(this.gameRunningContext.getGameInfo().gid, "proxy", this.gameRunningContext.getRoomId() == null ? "" : this.gameRunningContext.getRoomId());
        this.getCocosMessageProxy().init(this.gameRunningContext);
        this.getCocosMessageProxy().getGameProxyService().getDataService().setGameProxyMonitor(netMetricsMonitor);
    }

    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        boolean retVal = false;
        if (keyCode == 4 && event.getAction() == 1) {
            if (this.isCocosInit != null && ((Boolean)this.isCocosInit.getValue()).booleanValue()) {
                this.onBackClick();
            }
            return true;
        }
        if (keyCode == 24 && event.getAction() == 0) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"KEYCODE_VOLUME_UP", (Object[])new Object[0]);
            }
            if (this.getBaseGameView() != null) {
                this.getBaseGameView().showVolumeView(true);
                return true;
            }
        } else if (keyCode == 25 && event.getAction() == 0) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"VOLUME_KEY_DOWN", (Object[])new Object[0]);
            }
            if (this.getBaseGameView() != null) {
                this.getBaseGameView().showVolumeView(false);
                return true;
            }
        }
        return retVal;
    }

    @Override
    List<Class<? extends BaseGamePresenter>> getNeedPreInitPresent() {
        ArrayList<Class<? extends BaseGamePresenter>> list = new ArrayList<Class<? extends BaseGamePresenter>>();
        list.add(ComGameCallAppRouter.class);
        list.add(BannerAdPresent.class);
        list.add(RewardAdPresent.class);
        list.addAll(super.getNeedPreInitPresent());
        return list;
    }
}

