/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.base;

import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.game.bean.GameDataModel;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.AbsGameMatcher;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.callback.IMatchGameCallback;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class NormalGameMatcher
extends AbsGameMatcher {
    private static final String TAG = "NormalGameMatcher";

    public NormalGameMatcher(Environment env, IMatchGameLifecycle lifeCallback) {
        super(env, lifeCallback);
    }

    @Override
    public void reset() {
        super.reset();
        this.mIsMatchSuccess = false;
        this.mStartTime = 0L;
        GameDataModel.instance.setMatchGameId("");
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20023775").put("function_id", "show").put("gid", NormalGameMatcher.this.mGameInfo.getGid());
                GameLoger.info(NormalGameMatcher.TAG, JsonParser.toJson((Object)hiidoEvent), new Object[0]);
                HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
            }
        });
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        GameDataModel.instance.stopGameMatchBeat();
        if (this.mMatchGameWindow != null) {
            this.mMatchGameWindow.stopMatchTipAnim();
        }
    }

    @Override
    public void onGameMatchStart(GameInfo info, GameMatchContext matchConfig) {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        super.onGameMatchStart(info, matchConfig);
    }

    @Override
    public void onMatchFinish(GameInfo gameInfo, GameMatchContext matchContext, int matchType) {
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        this.reset();
        super.onMatchFinish(gameInfo, matchContext, matchType);
    }

    @Override
    public void onBackGroundChange(boolean foreground) {
    }

    @Override
    public void onNetworkNotAvailable() {
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mMatchGameWindow != null) {
            this.mMatchGameWindow.stopMatchAnim();
            this.mMatchGameWindow = null;
        }
    }

    @Override
    public void destroyWindow(GameInfo gameInfo, GameMatchContext config) {
        this.popMatchGameWindow(true);
    }

    @Override
    public void matchGame(GameInfo gameInfo, GameMatchContext config, IMatchGameCallback callback2) {
        GameLoger.error("matchGame", "%s \u8fdb\u5165\u5339\u914d\u9875\uff0cgameInfo = %s,context=%s", "[\u6e38\u620f\u5339\u914d]", gameInfo, config);
        this.mMatchConfig = config;
        this.mGameInfo = gameInfo;
        GameDataModel.instance.setMatchGameId(gameInfo.getGid());
        if (this.prepareGameMatch(gameInfo, config)) {
            this.onPrepareGameMatchInner(gameInfo, config);
        }
    }

    @Override
    public boolean prepareGameMatch(GameInfo gameInfo, GameMatchContext matchConfig) {
        if (gameInfo == null) {
            GameLoger.error("matchGame", "%s \u8fdb\u5165\u5339\u914d\u9875\uff0c\u4f20\u5165\u7684gameInfo\u4e3a\u7a7a", "[\u6e38\u620f\u5339\u914d]");
            this.onMatchFinish(gameInfo, matchConfig, 1);
            return false;
        }
        return true;
    }

    @Override
    public void onPrepareGameMatchInner(GameInfo gameInfo, GameMatchContext matchConfig) {
    }
}

