/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.base;

import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.GameLoadingTipsConfig;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.game.download.version.GameVersion;
import com.yy.game.gamemodule.base.GameDownloadPresenter;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameService;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0016\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"J\u001e\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\b\u0010$\u001a\u00020\u001eH\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060'2\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010(\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\"J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0017J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0017J\b\u0010-\u001a\u00020\u001eH\u0002J\b\u0010.\u001a\u00020\u001eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0019\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0018\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Lcom/yy/game/gamemodule/base/GameDownloadPresenter;", "", "gameInfo", "Lcom/yy/hiyo/game/base/bean/GameInfo;", "(Lcom/yy/hiyo/game/base/bean/GameInfo;)V", "TAG", "", "downloadProgress", "Landroidx/lifecycle/MutableLiveData;", "", "getDownloadProgress", "()Landroidx/lifecycle/MutableLiveData;", "getGameInfo", "()Lcom/yy/hiyo/game/base/bean/GameInfo;", "hasDownloadPkg", "", "getHasDownloadPkg", "mBinder", "Lcom/yy/base/event/kvo/helper/KvoBinder;", "mCountdownTask", "Ljava/lang/Runnable;", "getMCountdownTask", "()Ljava/lang/Runnable;", "mCountdownTask$delegate", "Lkotlin/Lazy;", "mWaitTime", "getMWaitTime", "()J", "mWaitTime$delegate", "bindDownload", "", "gInfo", "checkGameDownload", "autoDownload", "", "ignoreNewGameLoad", "destroy", "downloadGame", "getDownloadTips", "", "isGameValid", "onDownloadProgress", "event", "Lcom/yy/base/event/kvo/KvoEventIntent;", "onDownloadStateChange", "startNonForceUpdateCountdown", "unBindAll", "LoaderState", "game_debug"})
public class GameDownloadPresenter {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final String TAG = "AbsGameDownloader";
    @NotNull
    private final MutableLiveData<Integer> hasDownloadPkg;
    @NotNull
    private final MutableLiveData<Long> downloadProgress;
    private final Lazy mWaitTime$delegate;
    private final Lazy mCountdownTask$delegate;
    private final KvoBinder mBinder;
    @NotNull
    private final GameInfo gameInfo;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GameDownloadPresenter.class), "mWaitTime", "getMWaitTime()J")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GameDownloadPresenter.class), "mCountdownTask", "getMCountdownTask()Ljava/lang/Runnable;"))};
    }

    @NotNull
    public final MutableLiveData<Integer> getHasDownloadPkg() {
        return this.hasDownloadPkg;
    }

    @NotNull
    public final MutableLiveData<Long> getDownloadProgress() {
        return this.downloadProgress;
    }

    private final long getMWaitTime() {
        Lazy lazy = this.mWaitTime$delegate;
        GameDownloadPresenter gameDownloadPresenter = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return ((Number)lazy.getValue()).longValue();
    }

    private final Runnable getMCountdownTask() {
        Lazy lazy = this.mCountdownTask$delegate;
        GameDownloadPresenter gameDownloadPresenter = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (Runnable)lazy.getValue();
    }

    private final void unBindAll() {
        this.mBinder.clearAllKvoConnections();
    }

    private final void bindDownload(GameInfo gInfo) {
        this.mBinder.singleBindSourceTo((KvoSource)gInfo.downloadInfo);
    }

    public final boolean isGameValid(@NotNull GameInfo gInfo, boolean ignoreNewGameLoad) {
        Intrinsics.checkParameterIsNotNull((Object)gInfo, (String)"gInfo");
        IGameService gameService2 = (IGameService)ServiceManagerProxy.getService(IGameService.class);
        return gInfo.isPkGame() ? (ignoreNewGameLoad || GameInfo.isNewGameLoad((GameInfo)gInfo) ? gameService2.isGamePkgValid(gInfo) : true) : gameService2.isGameValid(gInfo);
    }

    public final void checkGameDownload(@NotNull GameInfo gInfo, boolean autoDownload, boolean ignoreNewGameLoad) {
        Intrinsics.checkParameterIsNotNull((Object)gInfo, (String)"gInfo");
        YYTaskExecutor.execute((Runnable)new Runnable(this, gInfo, ignoreNewGameLoad, autoDownload){
            final /* synthetic */ GameDownloadPresenter this$0;
            final /* synthetic */ GameInfo $gInfo;
            final /* synthetic */ boolean $ignoreNewGameLoad;
            final /* synthetic */ boolean $autoDownload;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Class<GameDownloadPresenter> clazz = GameDownloadPresenter.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    boolean isPkGame = this.$gInfo.isPkGame();
                    boolean newGameLoad = GameInfo.isNewGameLoad((GameInfo)this.$gInfo);
                    boolean isReady = this.this$0.isGameValid(this.$gInfo, this.$ignoreNewGameLoad);
                    if (MLog.isLogLevelBlowInfo()) {
                        String string2 = GameDownloadPresenter.access$getTAG$p(this.this$0);
                        StringBuilder stringBuilder = new StringBuilder().append("checkDownloadGame isValid=").append(isReady).append(", download state=");
                        GameDownloadInfo gameDownloadInfo = this.$gInfo.downloadInfo;
                        Intrinsics.checkExpressionValueIsNotNull((Object)gameDownloadInfo, (String)"gInfo.downloadInfo");
                        MLog.info((Object)string2, (String)stringBuilder.append(gameDownloadInfo.getState()).toString(), (Object[])new Object[0]);
                    }
                    if (isReady) {
                        this.this$0.getHasDownloadPkg().postValue((Object)2);
                    } else {
                        this.this$0.getHasDownloadPkg().postValue((Object)0);
                    }
                    if (this.$autoDownload && !isReady) {
                        GameDownloadPresenter.access$downloadGame(this.this$0, this.$gInfo);
                        if (!this.$ignoreNewGameLoad && isPkGame && newGameLoad && GameVersion.INSTANCE.isNonforceUpdate((BasicGameInfo)this.$gInfo)) {
                            GameDownloadPresenter.access$startNonForceUpdateCountdown(this.this$0);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = gameDownloadPresenter;
                this.$gInfo = gameInfo;
                this.$ignoreNewGameLoad = bl;
                this.$autoDownload = bl2;
            }
        });
    }

    public final void checkGameDownload(@NotNull GameInfo gInfo, boolean autoDownload) {
        Intrinsics.checkParameterIsNotNull((Object)gInfo, (String)"gInfo");
        this.checkGameDownload(gInfo, autoDownload, false);
    }

    private final void startNonForceUpdateCountdown() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)this.TAG, (String)("startNonForceUpdateCountdown,gameInfo=" + this.gameInfo), (Object[])new Object[0]);
        }
        YYTaskExecutor.postToMainThread((Runnable)this.getMCountdownTask(), (long)this.getMWaitTime());
    }

    @NotNull
    public final List<String> getDownloadTips(@NotNull GameInfo gameInfo) {
        boolean bl;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
        GameLoadingTipsConfig config = (GameLoadingTipsConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.GAME_LOADING_TIPS);
        boolean bl2 = false;
        List list = CollectionsKt.emptyList();
        int type = ((IGameService)ServiceManagerProxy.getService(IGameService.class)).getGameDownloadType(gameInfo);
        if (type == 1) {
            object = config;
            if (object == null || (object = object.getFirstDownloadTips()) == null) {
                bl = false;
                object = CollectionsKt.emptyList();
            }
        } else {
            object = config;
            if (object == null || (object = object.getUpdateDownloadTips()) == null) {
                bl = false;
                object = CollectionsKt.emptyList();
            }
        }
        list = object;
        return list;
    }

    private final void downloadGame(GameInfo gameInfo) {
        ((IGameService)ServiceManagerProxy.getService(IGameService.class)).downloadGame(gameInfo, GameDownloadInfo.DownloadType.no_pause, 150);
        this.unBindAll();
        this.bindDownload(gameInfo);
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class, thread=1)
    public void onDownloadStateChange(@NotNull KvoEventIntent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        KvoSource kvoSource = event.source();
        Intrinsics.checkExpressionValueIsNotNull((Object)kvoSource, (String)"event.source<GameDownloadInfo>()");
        GameDownloadInfo info = (GameDownloadInfo)kvoSource;
        MLog.debug((Object)this.TAG, (String)"onDownloadStateChange gid: %s, state: %s", (Object[])new Object[]{info.gameId, info.getState()});
        GameDownloadInfo.DownloadState eventNewValue = (GameDownloadInfo.DownloadState)event.newValue();
        if (eventNewValue == GameDownloadInfo.DownloadState.download_finish) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.getMCountdownTask());
            this.hasDownloadPkg.setValue((Object)2);
        } else if (eventNewValue == GameDownloadInfo.DownloadState.download_fail) {
            this.hasDownloadPkg.setValue((Object)3);
        }
    }

    @KvoMethodAnnotation(name="progress", sourceClass=GameDownloadInfo.class)
    public void onDownloadProgress(@NotNull KvoEventIntent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        KvoSource kvoSource = event.source();
        Intrinsics.checkExpressionValueIsNotNull((Object)kvoSource, (String)"event.source<GameDownloadInfo>()");
        GameDownloadInfo info = (GameDownloadInfo)kvoSource;
        MLog.debug((Object)this.TAG, (String)"onUpdateProgress gid: %s, state: %s, cur: %s, total: %s", (Object[])new Object[]{info.gameId, info.getState(), info.getProgress(), info.getTotalBytes()});
        float progress = info.getProgress();
        float total = info.getTotalBytes();
        if (info.getTotalBytes() > 0L && info.getProgress() > 0L) {
            this.downloadProgress.postValue((Object)((long)(progress / total * (float)100)));
        }
    }

    public void destroy() {
        this.unBindAll();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.getMCountdownTask());
        GameDownloadInfo gameDownloadInfo = this.gameInfo.downloadInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)gameDownloadInfo, (String)"gameInfo.downloadInfo");
        if (gameDownloadInfo.isDownloading()) {
            ((IGameService)ServiceManagerProxy.getService(IGameService.class)).cancelDownload(this.gameInfo);
        }
        if (!((IGameService)ServiceManagerProxy.getService(IGameService.class)).isGamePkgValid(this.gameInfo)) {
            ((IGameService)ServiceManagerProxy.getService(IGameService.class)).downloadGame(this.gameInfo, GameDownloadInfo.DownloadType.silent, 150);
        }
    }

    @NotNull
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public GameDownloadPresenter(@NotNull GameInfo gameInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
        this.gameInfo = gameInfo;
        this.TAG = "AbsGameDownloader";
        this.hasDownloadPkg = new MutableLiveData();
        this.downloadProgress = new MutableLiveData();
        this.mWaitTime$delegate = LazyKt.lazy((Function0)mWaitTime.2.INSTANCE);
        this.mCountdownTask$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Runnable>(this){
            final /* synthetic */ GameDownloadPresenter this$0;

            @NotNull
            public final Runnable invoke() {
                return new Runnable(this){
                    final /* synthetic */ mCountdownTask.2 this$0;

                    public final void run() {
                        if (!((IGameService)ServiceManagerProxy.getService(IGameService.class)).isGamePkgValid(this.this$0.this$0.getGameInfo())) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)GameDownloadPresenter.access$getTAG$p(this.this$0.this$0), (String)("startNonForceUpdateCountdown, \u5012\u8ba1\u65f6\u5b8c\u6210\u540e\u672a\u4e0b\u8f7d\u6210\u529f\uff1a" + this.this$0.this$0.getGameInfo()), (Object[])new Object[0]);
                            }
                            this.this$0.this$0.getHasDownloadPkg().setValue((Object)2);
                            this.this$0.this$0.destroy();
                        }
                        GameDownloadPresenter.access$unBindAll(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
            }
            {
                this.this$0 = gameDownloadPresenter;
                super(0);
            }
        }));
        this.mBinder = new KvoBinder((Object)this);
    }

    public static final /* synthetic */ String access$getTAG$p(GameDownloadPresenter $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ void access$downloadGame(GameDownloadPresenter $this, GameInfo gameInfo) {
        $this.downloadGame(gameInfo);
    }

    public static final /* synthetic */ void access$startNonForceUpdateCountdown(GameDownloadPresenter $this) {
        $this.startNonForceUpdateCountdown();
    }

    public static final /* synthetic */ void access$unBindAll(GameDownloadPresenter $this) {
        $this.unBindAll();
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/yy/game/gamemodule/base/GameDownloadPresenter$LoaderState;", "", "Companion", "game_debug"})
    public static @interface LoaderState {
        public static final Companion Companion = Companion.$$INSTANCE;
        public static final int NOT_DOWNLOAD = 0;
        public static final int DOWNLOADING = 1;
        public static final int HAS_DOWNLOAD = 2;
        public static final int DOWNLOAD_FAIL = 3;

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/yy/game/gamemodule/base/GameDownloadPresenter$LoaderState$Companion;", "", "()V", "DOWNLOADING", "", "DOWNLOAD_FAIL", "HAS_DOWNLOAD", "NOT_DOWNLOAD", "game_debug"})
        public static final class Companion {
            public static final int NOT_DOWNLOAD = 0;
            public static final int DOWNLOADING = 1;
            public static final int HAS_DOWNLOAD = 2;
            public static final int DOWNLOAD_FAIL = 3;
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }
}

