/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.base;

import com.yy.appbase.core.DefaultController;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.game.gamemodule.GameLoger;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.protocol.ITeamMatchLifecycle;
import java.util.List;

public abstract class AbsTeamMatcher
extends DefaultController {
    private static final String TAG = "AbsTeamMatcher";
    protected ITeamMatchLifecycle teamMatchLifecycleCallback;
    protected GameTeamMatchContext teamMatchContext;
    private boolean isTeamMatching = false;

    public AbsTeamMatcher(Environment env, ITeamMatchLifecycle teamMatchLifecycleCallback) {
        super(env);
        this.teamMatchLifecycleCallback = teamMatchLifecycleCallback;
    }

    public void teamMatch(GameTeamMatchContext context) {
        this.teamMatchContext = context;
        if (!this.contextAvailable()) {
            return;
        }
        if (this.teamMatchLifecycleCallback != null) {
            this.teamMatchLifecycleCallback.onPrepareTeamMatch(context);
        }
        this.handleTeamMatch();
    }

    protected abstract void handleTeamMatch();

    protected void handleTeamMatchStart() {
        this.isTeamMatching = true;
    }

    protected void handleTeamReady(String teamId) {
        this.teamMatchContext.setTeamId(teamId);
        if (this.teamMatchLifecycleCallback != null) {
            this.teamMatchLifecycleCallback.onTeamReady(teamId);
        }
    }

    protected void handleMatchFinish(String teamId, String gameId, int modeId, String roomId, String url, List<TeamUserInfo> teamList) {
        GameLoger.info("teamGameMatch", "match finish,teamId=%s, gid=%s, modeId=%d, roomId=%s, team user count=%d, url=%s", teamId, gameId, modeId, roomId, teamList == null ? 0 : teamList.size(), url);
        this.teamMatchContext.setRoomId(roomId);
        this.teamMatchContext.setUrl(url);
        this.teamMatchContext.setTeamId(teamId);
        this.teamMatchContext.setTeamUserInfoList(teamList);
        this.teamMatchContext.setMultiModeCode(modeId);
        if (this.teamMatchLifecycleCallback != null) {
            this.teamMatchLifecycleCallback.onTeamMatchFinish(this.teamMatchContext);
        }
    }

    protected void handleDestroy() {
        if (this.teamMatchLifecycleCallback != null) {
            this.teamMatchLifecycleCallback.onDestroy();
        }
        this.isTeamMatching = false;
    }

    private boolean contextAvailable() {
        if (this.teamMatchContext == null) {
            MLog.error((Object)TAG, (String)"contextAvailable failed, teamMatchContext = null", (Object[])new Object[0]);
            return false;
        }
        if (this.teamMatchContext.getGameInfo() == null) {
            MLog.error((Object)TAG, (String)"contextAvailable failed, gameInfo = null", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public boolean isTeamMatching() {
        return this.isTeamMatching;
    }

    public void closeModeCenter() {
    }
}

