/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.base;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.MotionEvent;
import android.view.SurfaceView;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.common.CommonCallback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.cocosproxy.CocosProxyType;
import com.yy.appbase.service.cocosproxy.IGameCallAppFunction;
import com.yy.appbase.ui.dialog.GameErrorDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.util.BusinessUpdateHelper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.game.R;
import com.yy.game.base.BaseGamePresenter;
import com.yy.game.base.GameMvpContext;
import com.yy.game.bean.GameResultWebBean;
import com.yy.game.bean.GameTimeBean;
import com.yy.game.bean.QueueBean;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.download.version.GameVersion;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.base.GamePlayInfo;
import com.yy.game.gamemodule.base.gameview.IGameView;
import com.yy.game.gamemodule.base.gameview.IOuterGameViewCallback;
import com.yy.game.gamemodule.base.gameview.IPlayerGameView;
import com.yy.game.gamemodule.base.gameview.WindowGameView;
import com.yy.game.gamemodule.loader.BaseGameLoader;
import com.yy.game.gamemodule.loader.CloudGameLoader;
import com.yy.game.gamemodule.loader.NormalGameLoader;
import com.yy.game.gamemodule.loader.WebGameLoader;
import com.yy.game.gameproxy.appcallgame.AppCallGameProxy;
import com.yy.game.module.gameroom.ui.AbsGameWindow;
import com.yy.game.module.video.arloader.VideoRecorderLoader;
import com.yy.game.porxy.CocosMessageProxy;
import com.yy.game.report.GameReport;
import com.yy.game.utils.GameReportHelper;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.GameLifeBean;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.IGameDownloadInterface;
import com.yy.hiyo.game.base.gamemode.IGameMessageInterface;
import com.yy.hiyo.game.base.helper.GameReportV1;
import com.yy.hiyo.game.base.protocol.IGameLifeCallBack;
import com.yy.hiyo.game.service.ICocosProxyService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.mvp.base.IMvpLifeCycleOwner;
import com.yy.yylite.commonbase.hiido.HiidoGroupReporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"ClassComment"})
public abstract class AbsGamePlayer
extends DefaultController
implements IOuterGameViewCallback {
    private static final String TAG = "AbsGamePlayer";
    private static final long LOAD_TIME_OUT = 30000L;
    protected GamePlayContext gameRunningContext;
    GameMvpContext mGameMvpContext;
    IPlayerGameView<? extends IGameView> mBaseGameView;
    private IGameLifecycle lifecycleCallback;
    protected GameResultWebBean gameResultWebBean = null;
    ICocosProxyService cocosProxyService;
    private int mExitType = 0;
    private int mCurrentStage = 0;
    private boolean isExitIng = false;
    private boolean isPlaying = false;
    MutableLiveData<Boolean> isCocosInit = new MutableLiveData();
    private boolean isCocosInitCallBack = false;
    private List<Runnable> mRunnableList = new CopyOnWriteArrayList<Runnable>();
    private CocosMessageProxy mCocosMessageProxy = new CocosMessageProxy(this.getEnvironment());
    GamePlayInfo mGamePlayInfo = new GamePlayInfo();
    GameReport mGameReport = new GameReport();
    private VideoRecorderLoader mVideoRecorderLoader = new VideoRecorderLoader(this.mEnvironment, new VideoRecorderLoader.ILoaderCallback(){

        @Override
        @org.jetbrains.annotations.Nullable
        public DefaultWindow getDefaultWindow() {
            if (AbsGamePlayer.this.getBaseGameView() == null) {
                return null;
            }
            return AbsGamePlayer.this.getBaseGameView().getGameWindow();
        }

        @Override
        public void addCatchPath(@NotNull String path, boolean presist) {
            AbsGamePlayer.this.addCachePath(path, presist);
        }

        @Override
        @NotNull
        public GamePlayContext getGameContext() {
            return AbsGamePlayer.this.gameRunningContext;
        }
    });
    private final GameLifeCycle mGameLifeCycle = new GameLifeCycle();
    private BaseGameLoader mIGameLoader;
    private IGameCallAppFunction gameCallAppFunction = (context, seqId, event, args) -> {
        this.executeInMain(() -> {
            if (!this.onReceiveGameEventInner(context, seqId, event, args)) {
                this.onReceiveGameEvent(context, seqId, event, args);
            }
        });
        return null;
    };
    private Runnable loadingTimer = new Runnable(){

        @Override
        public void run() {
            Boolean isCocosInitInner = (Boolean)AbsGamePlayer.this.isCocosInit.getValue();
            if (isCocosInitInner != null && isCocosInitInner.booleanValue()) {
                YYTaskExecutor.postToMainThread(() -> AbsGamePlayer.this.onLoadGameFinish(AbsGamePlayer.this.gameRunningContext, 3));
            }
        }
    };
    private ExitRunable mExitRunable = new ExitRunable();
    private BaseGameLoader.IGameloaderCallback mIGameLoaderCallback = new BaseGameLoader.IGameloaderCallback(){

        @Override
        @NotNull
        public GamePlayInfo getGamePlayInfo() {
            return AbsGamePlayer.this.mGamePlayInfo;
        }

        @Override
        @NotNull
        public GameReport getReporter() {
            return AbsGamePlayer.this.mGameReport;
        }

        @Override
        public void onPreLoadGameError() {
            AbsGamePlayer.this.onLoadGameFinish(AbsGamePlayer.this.gameRunningContext, 1);
        }

        @Override
        @NotNull
        public ICocosProxyService getCocosProxyController() {
            return AbsGamePlayer.this.getCocosMessageProxy().getCocosProxyController();
        }

        @Override
        @NotNull
        public Activity getActivity() {
            return AbsGamePlayer.this.mContext;
        }

        @Override
        @org.jetbrains.annotations.Nullable
        public GamePlayContext getPlayerContext() {
            return AbsGamePlayer.this.getCurPlayingGameContext();
        }
    };
    private IGameLifeCallBack iGameLifeCallBack = (context, gameLifeBean) -> this.handleGameLife(gameLifeBean);
    protected WindowGameView.IWindowGameViewCallback mIWindowGameViewCallback = new WindowGameView.IWindowGameViewCallback(){

        @Override
        public void destroyWindow(@NotNull AbstractWindow gameWindow) {
            AbsGamePlayer.this.mWindowMgr.popWindow(false, gameWindow);
        }

        @Override
        public void showWindow(@NotNull AbstractWindow gameWindow) {
            AbsGamePlayer.this.mWindowMgr.pushWindow(gameWindow, false);
        }
    };

    @Override
    public void onQueueStatusChanged(@NotNull String status, @org.jetbrains.annotations.Nullable QueueBean data) {
        this.handleQueue(status, data);
    }

    @Override
    public void onPreInit(CommonCallback callback2) {
        if (this.gameRunningContext.getGameInfo().isARGame()) {
            this.checkCameraPermission(new GrantedRunnable(callback2), new DeniedRunnable());
        } else {
            YYTaskExecutor.postToMainThread(() -> ((CommonCallback)callback2).onFinish());
        }
    }

    @Override
    public void onExitGameSuccess() {
        MLog.error((Object)"baseGame", (String)"[\u5f15\u64ce\u52a0\u8f7d]\u5f15\u64ce\u9000\u51fa\u6210\u529f", (Object[])new Object[0]);
        GamePlayContext context = this.gameRunningContext;
        YYTaskExecutor.postToMainThread(() -> this.onGameExited(context, this.mExitType));
    }

    @Override
    public void setGameMessageInterface(@org.jetbrains.annotations.Nullable IGameMessageInterface iGameMessageInterface) {
        this.mCocosMessageProxy.updateGameMessageInterface(iGameMessageInterface);
    }

    @Override
    public void onTryDownloadFile(@org.jetbrains.annotations.Nullable String url, int tag) {
        this.onTryDownLoadFileForWebGameInner(url, tag);
    }

    @Override
    public void onStartGameSuccess() {
        this.executeInMain(() -> {
            MLog.error((Object)"baseGame", (String)"[\u5f15\u64ce\u52a0\u8f7d]\u6e38\u620f\u5f00\u59cb\u6210\u529f\uff01", (Object[])new Object[0]);
            YYTaskExecutor.removeTask((Runnable)this.loadingTimer);
            this.mGamePlayInfo.onLoadFinish();
            this.mGamePlayInfo.onGameStart();
            this.getCocosMessageProxy().getGameProxyService().getBaseService().appGameRedy(this.gameRunningContext.getRoomId());
            this.onLoadGameFinish(this.gameRunningContext, 0);
        });
    }

    @Override
    public void setGameDownloadInterface(IGameDownloadInterface iGameDownloadInterface) {
        this.onNeedSetDownLoadInterface(iGameDownloadInterface);
    }

    @Override
    public void onExitGameFailure(int errorCode, String message) {
        MLog.error((Object)"baseGame", (String)"%s \u5f15\u64ce\u9000\u51fa\u5931\u8d25\uff0c\u76f4\u63a5\u9000\u51fa,errcode=%s,message=%s", (Object[])new Object[]{"[\u5f15\u64ce\u52a0\u8f7d]", errorCode, message});
        this.executeInMain(() -> {
            GamePlayContext context = this.gameRunningContext;
            this.onGameExited(context, this.mExitType);
        });
    }

    @Override
    public void onCocosInitFinish() {
        this.executeInMain(() -> {
            MLog.error((Object)"baseGame", (String)"GameLogDef.GameLogKeyDef.COCOS_INIT: %s", (Object[])new Object[]{"\u5f15\u64ce\u52a0\u8f7d\u6210\u529f\uff01"});
            this.isCocosInitCallBack = true;
            this.isCocosInit.setValue((Object)true);
            this.mGameReport.reportStartRuntime(0, System.currentTimeMillis() - this.mGamePlayInfo.getEngineStartTime());
            YYTaskExecutor.removeTask((Runnable)this.loadingTimer);
            for (Runnable runnable2 : this.mRunnableList) {
                runnable2.run();
            }
        });
    }

    @Override
    public void onCoCosViewLocationChange(CocoViewBean cocoViewBean) {
        this.onCoCosViewLocationChangeInner(cocoViewBean);
    }

    @Override
    public void onPreCreateCocos(CommonCallback callback2) {
        AppCallGameProxy.getSingleton().addGameProxyService(this.getCurPlayingGameContext().getRoomId(), this.mCocosMessageProxy.getGameProxyService());
        YYTaskExecutor.execute(() -> this.preCreateCocos(callback2));
    }

    @Override
    public void onExitGameError() {
        MLog.error((Object)"baseGame", (String)"[\u5f15\u64ce\u52a0\u8f7d]\u5f15\u64ce\u5f3a\u5236\u9000\u51fa", (Object[])new Object[0]);
        GamePlayContext context = this.gameRunningContext;
        YYTaskExecutor.postToMainThread(() -> {
            context.setEngineExitType(1);
            this.onGameExited(context, this.mExitType);
        });
    }

    @Override
    public SurfaceView getOuterSurfaceView() {
        return this.mVideoRecorderLoader.getSurfaceView();
    }

    @Override
    public void onGameErrorReport(int type, String location, String message, String content, String extJson) {
        this.showGameErrorDialog(location, message, content, extJson);
        GameReportHelper.reportCoCosException(type, location, message, content, extJson, this.gameRunningContext.getGameInfo().getGid());
    }

    @Override
    public void onGameReady() {
        this.onGameReadyInner();
    }

    @Override
    public void onGameTimeNotify(@NonNull String status, @Nullable GameTimeBean data) {
        this.handleGameTime(status, data);
    }

    @Override
    public void onGameViewShow() {
        this.executeInMain(() -> {
            this.mVideoRecorderLoader.onResume();
            this.onGameViewShowInner();
        });
    }

    @Override
    public void onGameViewHide() {
        this.executeInMain(() -> {
            this.mVideoRecorderLoader.onPause();
            this.onGameViewHideInner();
        });
    }

    @Override
    public void onCocosInitError(int errorCode, String message) {
        this.executeInMain(() -> {
            GamePlayContext context = this.gameRunningContext;
            this.isCocosInitCallBack = true;
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)this.mContext, (String)"\u5f15\u64ce\u52a0\u8f7d\u5931\u8d25", (int)0);
            }
            this.mGameReport.reportStartRuntime(errorCode, System.currentTimeMillis() - this.mGamePlayInfo.getEngineStartTime());
            if (context == null || context.getGameInfo() == null) {
                MLog.error((Object)"baseGame", (String)"[\u5f15\u64ce\u52a0\u8f7d]\u5f15\u64ce\u52a0\u8f7d\u5931\u8d25\uff01\u9519\u8bef\u7801=%s \u9519\u8bef\u4fe1\u606f\uff1a%s,\u6e38\u620f\u4e0a\u4e0b\u6587\u4e3anull", (Object[])new Object[]{errorCode, message == null ? "" : message});
            } else {
                MLog.error((Object)"baseGame", (String)"[\u5f15\u64ce\u52a0\u8f7d]\u5f15\u64ce\u52a0\u8f7d\u5931\u8d25\uff01\u9519\u8bef\u7801=%s \u9519\u8bef\u4fe1\u606f\uff1a%s,\u5f53\u524d\u6e38\u620f\u4fe1\u606f\uff1a%s", (Object[])new Object[]{errorCode, message == null ? "" : message, context.getGameInfo().toString()});
                RemoteGameDebugService.Companion.writeLog("ERROR: game engine load code:" + errorCode + ", message :" + message);
                context.addExtendValue("cocos_error_code", (Object)errorCode);
                this.onLoadGameFinish(context, 1);
            }
        });
    }

    protected void handleQueue(@NonNull String status, @Nullable QueueBean data) {
    }

    protected void handleGameTime(@NonNull String status, @Nullable GameTimeBean data) {
    }

    private void preCreateCocos(CommonCallback callback2) {
        if (this.gameRunningContext.getGameInfo().isWebGame()) {
            MLog.error((Object)TAG, (String)"preCreateCocos %s", (Object[])new Object[]{GameDownloadUtils.checkSDCardAvailableSize()});
            if (!GameDownloadUtils.checkSDCardAvailableSize()) {
                TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.storage_free_up_msg), (int)1);
                if (SettingFlags.getBoolean((String)"key_game_exit_no_mem_switch", (boolean)false)) {
                    YYTaskExecutor.postToMainThread(() -> this.exitRoom(8));
                    return;
                }
            }
        }
        this.mGamePlayInfo.onEngineStartInit();
        YYTaskExecutor.postToMainThread(() -> ((CommonCallback)callback2).onFinish());
    }

    private void onNeedSetDownLoadInterface(IGameDownloadInterface iGameDownloadInterface) {
        this.getCurrentGameLoader().updateDownloadInterface(iGameDownloadInterface);
    }

    private void onTryDownLoadFileForWebGameInner(String url, int tag) {
        this.getCurrentGameLoader().onTryDownLoadFileForWebGameInner(url, tag);
    }

    public AbsGamePlayer(Environment env, IGameLifecycle callback2) {
        super(env);
        this.lifecycleCallback = callback2;
    }

    protected CocosProxyType[] getSupportedCocosProxyTypeInner() {
        return null;
    }

    @Deprecated
    protected boolean onReceiveGameEventInner(String context, long seqId, int event, Vector<String> args) {
        return false;
    }

    public synchronized void exitRoom(int gameExitType) {
        this.exitRoom(1003, gameExitType);
    }

    public synchronized void exitRoom(int exitReason, int gameExitType) {
        if (exitReason == 1002) {
            this.exitRoom(exitReason, 1002, gameExitType);
        } else {
            this.exitRoom(exitReason, 1003, gameExitType);
        }
    }

    public synchronized void exitRoom(int exitReason, int exitType, int gameExitAction) {
        GameLoger.error("baseGame", "[\u6e38\u620f\u751f\u547d\u5468\u671f]\u6e38\u620f\u9000\u51fa\uff0c\u9000\u51fa\u7c7b\u578b\uff1a%d", gameExitAction);
        if (this.gameRunningContext != null && gameExitAction == 2) {
            GameReportV1.Companion.reportUserCancel(this.gameRunningContext.getGameInfo().gid, "1");
        }
        if (this.isExitIng) {
            return;
        }
        this.mGameReport.reportGameExit(exitReason, exitType, System.currentTimeMillis() - this.mGamePlayInfo.getGameStartTime(), this.mGamePlayInfo);
        this.mExitType = gameExitAction;
        this.isExitIng = true;
        YYTaskExecutor.removeTask((Runnable)this.loadingTimer);
        this.onPreGameExit(this.gameRunningContext);
        if (gameExitAction == 8) {
            this.onGameExited(this.gameRunningContext, gameExitAction);
        } else if (this.isCocosInitCallBack) {
            this.exitCocos(gameExitAction);
        } else {
            this.mRunnableList.add(this.mExitRunable);
        }
    }

    private void exitCocos(int gameExitType) {
        if (this.getBaseGameView() != null) {
            this.getBaseGameView().notifyFinish(0);
            GameLoger.info("baseGame", "game exiting, type:%d", gameExitType);
        }
    }

    private void handleGameLife(GameLifeBean gameLifeBean) {
        if (this.gameRunningContext == null || this.gameRunningContext.getGameInfo() == null) {
            GameLoger.error("baseGame", "[\u6e38\u620f\u751f\u547d\u5468\u671f]handleGameLife \u4e0a\u4e0b\u6587\u5f02\u5e38");
            return;
        }
        this.mCurrentStage = gameLifeBean.getStage();
        GameLoger.error("baseGame", "[\u6e38\u620f\u751f\u547d\u5468\u671f]Stage=%s,result=%s", gameLifeBean.getStage(), gameLifeBean.getResult());
        if (gameLifeBean.getStage() == 6) {
            GameLoger.error("baseGame", "[\u6e38\u620f\u751f\u547d\u5468\u671f]\u6e38\u620f\u5f00\u59cb,gameId=%s", this.gameRunningContext.getGameInfo().getGid());
            String result = gameLifeBean.getResult();
            this.onPlayGameStart(this.gameRunningContext);
            GameReportV1.Companion.reportGameStartPlayedTime(this.gameRunningContext.getGameInfo().getGid(), 0L, "0", "");
        } else if (gameLifeBean.getStage() == 3) {
            GameLoger.error("baseGame", "[\u6e38\u620f\u751f\u547d\u5468\u671f]\u6e38\u620f\u52a0\u8f7d\u6210\u529f,gameId=%s", this.gameRunningContext.getGameInfo().getGid());
            YYTaskExecutor.removeTask((Runnable)this.loadingTimer);
            this.onGameLoadingFinishInner();
        } else if (gameLifeBean.getStage() == 4) {
            GameLoger.error("baseGame", "[\u6e38\u620f\u751f\u547d\u5468\u671f]\u6e38\u620f\u52a0\u8f7d\u5931\u8d25,gameId=%s", this.gameRunningContext.getGameInfo().getGid());
            GameReportV1.Companion.reportGameStartPlayedTime(this.gameRunningContext.getGameInfo().getGid(), 0L, "1", "");
            this.onLoadGameFinish(this.gameRunningContext, 2);
        } else if (gameLifeBean.getStage() == 8) {
            GameLoger.error("baseGame", "[\u6e38\u620f\u751f\u547d\u5468\u671f]\u6e38\u620f\u5f02\u5e38\u9000\u51fa,gameId=%s", this.gameRunningContext.getGameInfo().getGid());
            String result = gameLifeBean.getResult();
            this.gameRunningContext.setGameResult(result);
            this.gameRunningContext.setExceptionFinish(true);
            this.onPlayGameFinish(this.gameRunningContext, 2);
            GameReportV1.Companion.reportGameStartPlayedTime(this.gameRunningContext.getGameInfo().getGid(), 0L, "2", "");
        } else if (gameLifeBean.getStage() == 7) {
            GameLoger.error("baseGame", "[\u6e38\u620f\u751f\u547d\u5468\u671f]\u6e38\u620f\u6b63\u5e38\u9000\u51fa,gameId=%s", this.gameRunningContext.getGameInfo().getGid());
            String result = gameLifeBean.getResult();
            this.gameRunningContext.setGameResult(result);
            this.gameRunningContext.setExceptionFinish(false);
            this.onPlayGameFinish(this.gameRunningContext, 1);
        }
    }

    public void setGamePlayContext(GamePlayContext gamePlayContext) {
        this.gameRunningContext = gamePlayContext;
    }

    void onPreloadGame(GamePlayContext context) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPreloadGame", (Object[])new Object[0]);
        }
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onJoinGame(context);
        }
        this.mIGameLoader = context.getGameInfo().isWebGame() ? new WebGameLoader(this.getEnvironment(), this.mIGameLoaderCallback) : (context.getGameInfo().isCloudGame() ? new CloudGameLoader(this.getEnvironment(), this.mIGameLoaderCallback) : new NormalGameLoader(this.getEnvironment(), this.mIGameLoaderCallback));
        this.initBaseGameView();
        this.isCocosInit.setValue((Object)false);
        this.onGameLifeCreate();
        this.bindInitData();
        this.loadLoader();
        this.initPlay();
        this.initEngineMsg();
        YYTaskExecutor.execute((Runnable)this.loadingTimer, (long)30000L);
        this.onPreloadGameInner(context);
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onPreloadGame(context);
        }
    }

    void onGameLifeCreate() {
        this.isExitIng = false;
        this.mRunnableList.clear();
        this.isCocosInit.setValue((Object)false);
        this.mGameLifeCycle.onEvent(Lifecycle.Event.ON_CREATE);
    }

    private void initBaseGameView() {
        this.mBaseGameView = this.initGameView();
        this.mBaseGameView.init(this.gameRunningContext);
        this.mBaseGameView.setGameLifeCycle(this.lifecycleCallback);
        this.mBaseGameView.setGameViewCallback(this);
    }

    private void loadLoader() {
        if (this.mIGameLoader != null) {
            this.mIGameLoader.initLoader(this.gameRunningContext.getGameUrl(), this.gameRunningContext.getRoomId(), this.gameRunningContext.getGameInfo());
        }
    }

    public void initPlay() {
        this.setPlaying(true);
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    void onLoadGameFinish(GamePlayContext context, int finishType) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onLoadGameFinish:finishType-->%d", (Object[])new Object[]{finishType});
        }
        if (this.getBaseGameView() != null) {
            this.getBaseGameView().hideGameLoading();
        }
        if (finishType == 0) {
            this.bindEngineData();
        }
        this.onLoadGameFinishBase(context, finishType);
        if (this.lifecycleCallback != null) {
            AbsGameWindow absGameWindow = null;
            if (this.getBaseGameView() != null && this.getBaseGameView().getGameWindow() != null) {
                absGameWindow = this.getBaseGameView().getGameWindow();
            }
            this.lifecycleCallback.onLoadGameFinish(context, finishType, absGameWindow);
        }
    }

    private void bindEngineData() {
        if (this.getBaseGameView().getConnectState() != null) {
            this.getBaseGameView().getConnectState().observe(this.mIGameLoader.getLifeCycle(), this::onEngineConnectChange);
        }
    }

    public void onEngineConnectChange(int state) {
    }

    public void onGameReadyInner() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"baseGame", (String)"onGameReady", (Object[])new Object[0]);
        }
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onGameReady(this.getCurPlayingGameContext());
        }
    }

    void onGameViewShowInner() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"baseGame", (String)"onGameViewShow", (Object[])new Object[0]);
        }
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onGameViewShow(this.getCurPlayingGameContext());
        }
    }

    void onGameViewHideInner() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"baseGame", (String)"onGameViewHide", (Object[])new Object[0]);
        }
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onGameViewHide(this.getCurPlayingGameContext());
        }
    }

    private void onPlayGameStart(GamePlayContext context) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPlayGameStart", (Object[])new Object[0]);
        }
        YYTaskExecutor.removeTask((Runnable)this.loadingTimer);
        this.onPlayGameStartInner(context);
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onPlayGameStart(context);
        }
    }

    private void onPlayGameFinish(GamePlayContext context, int finishType) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPlayGameFinish:->finishType:%d", (Object[])new Object[]{finishType});
        }
        this.onPlayGameFinishInner(context, finishType);
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onPlayGameFinish(context, finishType);
        }
    }

    private void onPreGameExit(GamePlayContext context) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onPreGameExit", (Object[])new Object[0]);
        }
        this.onPreGameExitInner(context);
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onPreGameExit(context);
        }
    }

    private void onGameExited(GamePlayContext context, int gameExitType) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onGameExited", (Object[])new Object[0]);
        }
        this.executeInMain(() -> {
            this.unInitCoCos();
            this.mVideoRecorderLoader.destroy();
            this.mGameReport.destroy();
            this.resetLocal();
            this.mCurrentStage = 9;
            if (this.gameRunningContext.getRoomId() != null) {
                HiidoGroupReporter.INSTANCE.closeSession(this.gameRunningContext.getRoomId());
            }
            this.getCurrentGameLoader().cancelDownload();
            this.onGameExitedInner(context, gameExitType);
            if (this.lifecycleCallback != null) {
                this.lifecycleCallback.onGameExited(context, gameExitType);
            }
        });
    }

    protected void resetLocal() {
        this.isCocosInit.setValue((Object)false);
        this.isPlaying = false;
        this.isExitIng = false;
        this.mCurrentStage = 0;
        this.isCocosInitCallBack = false;
        this.mRunnableList.clear();
        this.mGameLifeCycle.onEvent(Lifecycle.Event.ON_PAUSE);
        this.mGameLifeCycle.onEvent(Lifecycle.Event.ON_DESTROY);
        YYTaskExecutor.removeTask((Runnable)this.loadingTimer);
        BaseGameLoader loader = this.mIGameLoader;
        if (this.getCurrentGameLoader() != null) {
            this.getCurrentGameLoader().destory();
        }
        this.unBindInitData();
    }

    public boolean isExitIng() {
        return this.isExitIng;
    }

    protected void onBackClick() {
    }

    private void initEngineMsg() {
        this.cocosProxyService = this.getCocosMessageProxy().getCocosProxyController();
        CocosProxyType[] types = this.getSupportedCocosProxyType();
        AppCallGameProxy.initGameJavascriptProxy(this.getEnvironment());
        if (this.gameRunningContext.getGameInfo().getGameType() != 2 && this.cocosProxyService != null && types != null && types.length > 0) {
            for (CocosProxyType type : types) {
                this.cocosProxyService.addGameCallAppFunction(type, this.gameCallAppFunction);
            }
        }
        this.mCocosMessageProxy.registerGameLife(this.iGameLifeCallBack);
        CocosProxyType[] innerTypes = this.getSupportedCocosProxyTypeInner();
        if (this.cocosProxyService != null && innerTypes != null && innerTypes.length > 0) {
            for (CocosProxyType type : innerTypes) {
                this.cocosProxyService.addGameCallAppFunction(type, this.gameCallAppFunction);
            }
        }
    }

    private void unInitCoCos() {
        CocosProxyType[] types = this.getSupportedCocosProxyType();
        if (this.cocosProxyService != null && types != null && types.length > 0) {
            for (CocosProxyType type : types) {
                this.cocosProxyService.removeGameCallAppFunction(type);
            }
        }
        this.mCocosMessageProxy.unregisterGameLife(this.iGameLifeCallBack);
        CocosProxyType[] innerTypes = this.getSupportedCocosProxyTypeInner();
        if (this.cocosProxyService != null && innerTypes != null && innerTypes.length > 0) {
            for (CocosProxyType type : innerTypes) {
                this.cocosProxyService.removeGameCallAppFunction(type);
            }
        }
        AppCallGameProxy.getSingleton().removeGameProxyService(this.getCurPlayingGameContext().getRoomId());
    }

    public GamePlayContext getCurPlayingGameContext() {
        return this.gameRunningContext;
    }

    public abstract IPlayerGameView<? extends IGameView> initGameView();

    abstract int joinGame(GameInfo var1, GamePlayContext var2);

    public abstract int restartGame(GameInfo var1, GamePlayContext var2);

    public abstract void leaveGame(ILeaveGameCallback var1);

    public abstract GameInfo getCurPlayingGame();

    public abstract CocosProxyType[] getSupportedCocosProxyType();

    @MainThread
    public abstract void onReceiveGameEvent(String var1, long var2, int var4, Vector<String> var5);

    public abstract void onPreloadGameInner(GamePlayContext var1);

    public abstract void onLoadGameFinishBase(GamePlayContext var1, int var2);

    public abstract void onPlayGameStartInner(GamePlayContext var1);

    public abstract void onGameLoadingFinishInner();

    public abstract void onGamePreloadFinishInner();

    public abstract void onPlayGameFinishInner(GamePlayContext var1, int var2);

    public abstract void onPreGameExitInner(GamePlayContext var1);

    @MainThread
    public abstract void onGameExitedInner(GamePlayContext var1, int var2);

    public void onCoCosViewLocationChangeInner(CocoViewBean location) {
    }

    public abstract CocoViewBean getCocosViewData();

    @org.jetbrains.annotations.Nullable
    public IPlayerGameView<? extends IGameView> getBaseGameView() {
        return this.mBaseGameView;
    }

    public int getGameExitType() {
        return this.mExitType;
    }

    public void setGameExitType(int mExitType) {
        this.mExitType = mExitType;
    }

    protected void executeInMain(Runnable command2) {
        if (command2 != null) {
            if (YYTaskExecutor.isMainThread()) {
                command2.run();
            } else {
                YYTaskExecutor.postToMainThread((Runnable)command2);
            }
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isGameStarted() {
        return this.mCurrentStage >= 6;
    }

    public int getCurrentStage() {
        return this.mCurrentStage;
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onGameViewAttach(this.gameRunningContext);
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.lifecycleCallback != null) {
            this.lifecycleCallback.onGameViewDetach(this.gameRunningContext);
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        BusinessUpdateHelper.INSTANCE.updateBusiness("game");
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        BusinessUpdateHelper.INSTANCE.updateBusiness("");
    }

    public IGameLifecycle getLifecycleCallback() {
        return this.lifecycleCallback;
    }

    public void notifyGameInvite(GameMessageModel gameMessageModel) {
    }

    public CocosMessageProxy getCocosMessageProxy() {
        return this.mCocosMessageProxy;
    }

    public boolean onPreHandleTouchEventInner(MotionEvent event) {
        return true;
    }

    public void showGameErrorDialog(String location, String message, String content, String extJson) {
        YYTaskExecutor.postToMainThread(() -> {
            if (RuntimeContext.sIsDebuggable || SystemUtils.isCpPackage()) {
                this.mDialogLinkManager.showDialog((BaseDialog)new GameErrorDialog("game load warning", (CharSequence)("location:" + location + "\nmessage:" + message + "\ncontent:" + content + "\nextJson:" + extJson + "\n"), (CharSequence)"OK", 0, true));
            }
        });
    }

    private void checkCameraPermission(final Runnable granted, final Runnable denied) {
        if (!PermissionHelper.hasCameraPermission((Activity)this.mContext)) {
            PermissionHelper.requestCameraPermission((Activity)this.mContext, (IPermissionListener)new IPermissionListener(){

                public void onPermissionGranted(@NonNull String[] permission) {
                    granted.run();
                }

                public void onPermissionDenied(@NonNull String[] permission) {
                    denied.run();
                }
            });
        } else {
            granted.run();
        }
    }

    public void addCachePath(@NotNull String path, boolean persist) {
    }

    private void bindInitData() {
        if (this.mIGameLoader != null) {
            this.isCocosInit.observe(this.mIGameLoader.getLifeCycle(), aBoolean -> {
                if (aBoolean.booleanValue()) {
                    this.checkPreLoader();
                }
            });
            this.mIGameLoader.getLoaderState().observe(this.mIGameLoader.getLifeCycle(), integer2 -> this.checkPreLoader());
        }
        this.mGamePlayInfo.getGameStage().observe((LifecycleOwner)this.mGameLifeCycle, this::onGameStageChange);
    }

    private void onGameStageChange(int stage) {
        if (stage == 1 || stage == 3 || stage == 5) {
            this.mGameReport.reportGameStage(this.mGamePlayInfo);
        }
    }

    private void unBindInitData() {
        this.isCocosInit.setValue((Object)false);
        if (this.mIGameLoader != null) {
            this.mIGameLoader.getLoaderState().removeObservers(this.mIGameLoader.getLifeCycle());
        }
    }

    private void onGamePreInitSuccess() {
        this.mGameReport.setRoomId(this.gameRunningContext.getRoomId() == null ? "" : this.gameRunningContext.getRoomId());
        this.onGamePreloadFinishInner();
        this.mGameLifeCycle.onEvent(Lifecycle.Event.ON_START);
        if (this.gameRunningContext.getGameInfo().isCloudGame() || GameVersion.INSTANCE.isGameInfoValid((BasicGameInfo)this.gameRunningContext.getGameInfo())) {
            String path = this.getCurrentGameLoader().getGamePath();
            String[] pkgList = this.getCurrentGameLoader().getPkgList();
            this.getBaseGameView().loadGame(path, pkgList);
        } else {
            this.onGamePreInitFail(1006);
            this.onLoadGameFinish(this.gameRunningContext, 4);
        }
    }

    private void checkPreLoader() {
        if (this.mIGameLoader == null) {
            return;
        }
        Boolean isCocoInitInner = (Boolean)this.isCocosInit.getValue();
        Integer loaderState = (Integer)this.mIGameLoader.getLoaderState().getValue();
        if (isCocoInitInner == null || loaderState == null) {
            return;
        }
        if (isCocoInitInner.booleanValue() && loaderState == 1) {
            this.mGamePlayInfo.onInitFinish(0);
            this.mGamePlayInfo.onLoadStart();
            this.onGamePreInitSuccess();
        } else if (this.isCocosInitCallBack && (!isCocoInitInner.booleanValue() || loaderState == -1)) {
            if (!isCocoInitInner.booleanValue()) {
                this.onGamePreInitFail(1004);
            } else {
                int initCode = 1003;
                if (this.mIGameLoader.getLoadFailReason().getValue() != null) {
                    switch ((Integer)this.mIGameLoader.getLoadFailReason().getValue()) {
                        case 1002: {
                            initCode = 1007;
                            break;
                        }
                        case 1001: {
                            initCode = 1008;
                            break;
                        }
                        case 1003: {
                            initCode = 1009;
                            break;
                        }
                    }
                }
                this.onGamePreInitFail(initCode);
            }
        }
    }

    void onGamePreInitFail(int failCode) {
        this.mGamePlayInfo.onInitFinish(failCode);
        this.onLoadGameFinish(this.gameRunningContext, 4);
    }

    public BaseGameLoader getCurrentGameLoader() {
        if (this.mIGameLoader == null) {
            this.mIGameLoader = this.gameRunningContext.getGameInfo().isWebGame() ? new WebGameLoader(this.getEnvironment(), this.mIGameLoaderCallback) : (this.gameRunningContext.getGameInfo().isCloudGame() ? new CloudGameLoader(this.getEnvironment(), this.mIGameLoaderCallback) : new NormalGameLoader(this.getEnvironment(), this.mIGameLoaderCallback));
        }
        return this.mIGameLoader;
    }

    public GameLifeCycle getGameLifeCycle() {
        return this.mGameLifeCycle;
    }

    List<Class<? extends BaseGamePresenter>> getNeedPreInitPresent() {
        return new ArrayList<Class<? extends BaseGamePresenter>>();
    }

    class GameLifeCycle
    implements IMvpLifeCycleOwner {
        private LifecycleRegistry mLifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);

        GameLifeCycle() {
        }

        public void onEvent(Lifecycle.Event event) {
            this.mLifecycleRegistry.handleLifecycleEvent(event);
        }

        @NonNull
        public Lifecycle getLifecycle() {
            return this.mLifecycleRegistry;
        }
    }

    class DeniedRunnable
    implements Runnable {
        DeniedRunnable() {
        }

        @Override
        public void run() {
            AbsGamePlayer.this.exitRoom(8);
        }
    }

    class GrantedRunnable
    implements Runnable {
        CommonCallback mCallback;

        GrantedRunnable(CommonCallback callback2) {
            this.mCallback = callback2;
        }

        @Override
        public void run() {
            if (AbsGamePlayer.this.gameRunningContext.getGameInfo().isARGame()) {
                if (AbsGamePlayer.this.mBaseGameView != null && AbsGamePlayer.this.mBaseGameView.getGameWindow() != null) {
                    AbsGamePlayer.this.mVideoRecorderLoader.initPlayer(AbsGamePlayer.this.mBaseGameView.getGameWindow().getBaseLayer(), AbsGamePlayer.this.getCocosMessageProxy().getCocosProxyController(), AbsGamePlayer.this.gameRunningContext.getGameInfo());
                }
                if (this.mCallback != null) {
                    this.mCallback.onFinish();
                }
            }
        }
    }

    class ExitRunable
    implements Runnable {
        ExitRunable() {
        }

        @Override
        public void run() {
            AbsGamePlayer.this.exitCocos(AbsGamePlayer.this.mExitType);
        }
    }
}

