/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.base;

import android.content.Context;
import android.os.SystemClock;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.game.R;
import com.yy.game.bean.GameDataModel;
import com.yy.game.metric.GameMetricCode;
import com.yy.game.metric.GameMetricHelper;
import com.yy.game.module.matchgame.ui.MatchGameWindow;
import com.yy.game.utils.GameReportHelper;
import com.yy.game.utils.GameStateDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.callback.IMatchGameCallback;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;

public abstract class AbsGameMatcher
extends DefaultController {
    private static final String TAG = "AbsGameMatcher";
    protected IMatchGameLifecycle lifeCallback;
    public MatchGameWindow mMatchGameWindow;
    private volatile boolean isMatching = false;
    protected volatile boolean mIsMatchSuccess = false;
    protected long mStartTime = 0L;
    public volatile GameMatchContext mMatchConfig;
    public volatile GameInfo mGameInfo;
    public volatile GameInfo mInviteGameInfo;

    public AbsGameMatcher(Environment env, IMatchGameLifecycle lifeCallback) {
        super(env);
        this.lifeCallback = lifeCallback;
    }

    public void showMatchGameView(MatchGameWindow matchGameWindow) {
        this.mMatchGameWindow = matchGameWindow;
        if (matchGameWindow != null) {
            this.mWindowMgr.pushWindow((AbstractWindow)matchGameWindow, false);
        }
    }

    public void popMatchGameWindow(boolean makeGameWindowNull) {
        if (this.mMatchGameWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mMatchGameWindow);
            if (makeGameWindowNull) {
                this.mMatchGameWindow = null;
            }
        }
    }

    public void setLifeCallback(IMatchGameLifecycle lifeCallback) {
        this.lifeCallback = lifeCallback;
    }

    public abstract boolean prepareGameMatch(GameInfo var1, GameMatchContext var2);

    public abstract void onPrepareGameMatchInner(GameInfo var1, GameMatchContext var2);

    public void onPareGameMatch(GameInfo ginfo, GameMatchContext matchConfig) {
        if (this.lifeCallback != null) {
            this.lifeCallback.prepareGameMatch(ginfo, matchConfig);
        }
    }

    public void onGameMatchStart(GameInfo info, GameMatchContext matchConfig) {
        this.isMatching = true;
        if (this.lifeCallback != null) {
            this.lifeCallback.onGameMatchStart(info, matchConfig);
        }
    }

    public void onMatchFinish(GameInfo gameInfo, GameMatchContext matchContext, int matchType) {
        this.isMatching = false;
        if (this.lifeCallback != null) {
            this.lifeCallback.onMatchFinish(gameInfo, matchContext, matchType);
        }
    }

    protected synchronized boolean onPreMatchSuccessInner(GameInfo gameInfo, GameMatchContext matchContext, String gid, String roomId) {
        if (this.mMatchGameWindow == null || gameInfo == null) {
            return false;
        }
        long time = GameMetricCode.USE_MATCH_TIME > 0L ? SystemClock.elapsedRealtime() - GameMetricCode.USE_MATCH_TIME : 0L;
        GameMetricCode.USE_MATCH_TIME = 0L;
        if (StringUtils.isEmpty((String)roomId)) {
            GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchNotify", time, "10006");
            return false;
        }
        if (this.mIsMatchSuccess) {
            GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchNotify", time, "10007");
            return false;
        }
        if (!StringUtils.equal((String)gid, (String)gameInfo.getGid())) {
            GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchNotify", time, "10005");
            return false;
        }
        this.mIsMatchSuccess = true;
        boolean isGoldGame = matchContext != null && (Boolean)matchContext.getExtendValue("isGoldGame", (Object)false) != false;
        GameDataModel.instance.postGameMatch(this.mMatchConfig.update2GameModel(gameInfo));
        GameReportHelper.reportGameInfo(this.mMatchConfig.update2GameModel(this.mGameInfo), (int)(System.currentTimeMillis() - this.mStartTime), 0, GameStateDef.GAME_FINISH_REASON.FINISH.value(), 1, isGoldGame);
        GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchNotify", time, "0");
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onGameMatchSuccess", (Object[])new Object[0]);
        }
        return true;
    }

    abstract void onBackGroundChange(boolean var1);

    abstract void onNetworkNotAvailable();

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            if (this.mMatchGameWindow != null) {
                if (((Boolean)notification.extObj).booleanValue()) {
                    this.onBackGroundChange(true);
                } else {
                    this.onBackGroundChange(false);
                }
            }
        } else if (notification.id == NotificationDef.N_NETWORK_STATE_CHANGE && !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            this.onNetworkNotAvailable();
        }
    }

    public void reset() {
        this.isMatching = false;
    }

    public abstract void destroyWindow(GameInfo var1, GameMatchContext var2);

    public abstract void matchGame(GameInfo var1, GameMatchContext var2, IMatchGameCallback var3);

    public boolean isMatching() {
        return this.isMatching;
    }
}

