/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule.base;

import com.yy.appbase.core.DefaultController;
import com.yy.appbase.im.GameMessageModel;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.game.gamemodule.base.AbsGameMatcher;
import com.yy.game.gamemodule.base.AbsGamePlayer;
import com.yy.game.gamemodule.base.AbsGameSelecter;
import com.yy.game.gamemodule.base.AbsTeamMatcher;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameSelectContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import com.yy.hiyo.game.service.callback.IMatchGameCallback;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.game.service.protocol.IInviteGameLifecycle;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.game.service.protocol.ISelectCallBack;
import com.yy.hiyo.game.service.protocol.ITeamMatchLifecycle;

public abstract class AbsGameController
extends DefaultController {
    private static final String TAG = "AbsGameController";
    protected AbsGamePlayer mPlayer;
    protected AbsGameMatcher mMatcher;
    protected AbsGameSelecter selecter;
    protected AbsTeamMatcher teamMatcher;
    protected IInviteGameLifecycle inviteLifecycleCallBack;
    protected IGameLifecycle gameLifecycleCallBak;
    protected IMatchGameLifecycle matchGameLifecycleCallBack;
    protected ITeamMatchLifecycle teamMatchLifecycleCallback;
    private IGameLifecycle innerGameLifecycle = new IGameLifecycle(){

        public void onJoinGame(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onJoinGame(context);
            }
        }

        public void onPreloadGame(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onPreloadGame(context);
            }
            AbsGameController.this.onPreloadGameInner(context);
        }

        public void onLoadGameFinish(GamePlayContext context, int finishType, DefaultWindow gameWindow) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onLoadGameFinish(context, finishType, gameWindow);
            }
            AbsGameController.this.onLoadGameFinishInner(context, finishType);
        }

        public void onGameReady(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onGameReady(context);
            }
        }

        public void onPlayGameStart(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onPlayGameStart(context);
            }
            AbsGameController.this.onPlayGameStartInner(context);
        }

        public void onPlayGameFinish(GamePlayContext context, int finishType) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onPlayGameFinish(context, finishType);
            }
            AbsGameController.this.onPlayGameFinishInner(context, finishType);
        }

        public void onPreGameExit(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onPreGameExit(context);
            }
            AbsGameController.this.onPreGameExitInner(context);
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onGameExited(context, gameExitType);
            }
            AbsGameController.this.onGameExitedInner(context, gameExitType);
        }

        public void onGameViewAttach(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onGameViewAttach(context);
            }
        }

        public void onGameViewInit(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onGameViewInit(context);
            }
        }

        public void onGameViewDetach(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onGameViewDetach(context);
            }
        }

        public void onGameViewShow(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onGameViewShow(context);
            }
        }

        public void onGameViewHide(GamePlayContext context) {
            if (AbsGameController.this.gameLifecycleCallBak != null) {
                AbsGameController.this.gameLifecycleCallBak.onGameViewHide(context);
            }
        }
    };
    private ISelectCallBack innerSelectCallBack = new ISelectCallBack(){

        public void onSelectToGame(GameSelectContext gameSelectContext) {
            AbsGameController.this.onGameSelectInner(gameSelectContext);
        }
    };
    protected int gameModule;
    protected IMatchGameLifecycle innerMatchGameLifecycleCallBack = new IMatchGameLifecycle(){

        public void prepareGameMatch(GameInfo ginfo, GameMatchContext matchConfig) {
            if (AbsGameController.this.matchGameLifecycleCallBack == null) {
                return;
            }
            AbsGameController.this.matchGameLifecycleCallBack.prepareGameMatch(ginfo, matchConfig);
        }

        public void onGameMatchStart(GameInfo info, GameMatchContext matchConfig) {
            if (AbsGameController.this.matchGameLifecycleCallBack == null) {
                return;
            }
            AbsGameController.this.matchGameLifecycleCallBack.onGameMatchStart(info, matchConfig);
        }

        public void onMatchFinish(GameInfo gameInfo, GameMatchContext matchContext, int matchType) {
            AbsGameController.this.innerMatchFinish(gameInfo, matchContext, matchType);
            if (AbsGameController.this.matchGameLifecycleCallBack == null) {
                return;
            }
            AbsGameController.this.matchGameLifecycleCallBack.onMatchFinish(gameInfo, matchContext, matchType);
        }
    };
    protected ITeamMatchLifecycle innerTeamMatchLifecycleCallback = new ITeamMatchLifecycle(){

        public void onPrepareTeamMatch(GameTeamMatchContext context) {
            if (AbsGameController.this.teamMatchLifecycleCallback != null) {
                AbsGameController.this.teamMatchLifecycleCallback.onPrepareTeamMatch(context);
            }
        }

        public void onTeamReady(String teamId) {
            if (AbsGameController.this.teamMatchLifecycleCallback != null) {
                AbsGameController.this.teamMatchLifecycleCallback.onTeamReady(teamId);
            }
        }

        public void onTeamMatchFinish(GameTeamMatchContext context) {
            AbsGameController.this.innerTeamMatchFinish(context);
            if (AbsGameController.this.teamMatchLifecycleCallback != null) {
                AbsGameController.this.teamMatchLifecycleCallback.onTeamMatchFinish(context);
            }
        }

        public void onDestroy() {
            if (AbsGameController.this.teamMatchLifecycleCallback != null) {
                AbsGameController.this.teamMatchLifecycleCallback.onDestroy();
            }
        }
    };

    public AbsGameController(Environment env, int gameModule) {
        super(env);
        this.gameModule = gameModule;
    }

    public void setInviteCallback(IInviteGameLifecycle callback2) {
        this.inviteLifecycleCallBack = callback2;
    }

    public void setMatchCallback(IMatchGameLifecycle callback2) {
        this.matchGameLifecycleCallBack = callback2;
    }

    public void setTeamMatchCallback(ITeamMatchLifecycle callback2) {
        this.teamMatchLifecycleCallback = callback2;
    }

    public void setGameLifecycleCallback(IGameLifecycle lifecycleCallback) {
        this.gameLifecycleCallBak = lifecycleCallback;
    }

    public int joinGame(GameInfo info, GamePlayContext context) {
        AbsGamePlayer player;
        this.mPlayer = player = this.createPlayer(this.innerGameLifecycle);
        if (player != null) {
            player.setGamePlayContext(context);
            return player.joinGame(info, context);
        }
        return 1;
    }

    public int restartGame(GameInfo info, GamePlayContext context) {
        if (this.mPlayer != null) {
            return this.mPlayer.restartGame(info, context);
        }
        if (RuntimeContext.sIsDebuggable) {
            throw new IllegalStateException("mPlayer must exit.");
        }
        return 1;
    }

    public void leaveGame(ILeaveGameCallback callback2) {
        AbsGamePlayer player = this.mPlayer;
        if (player != null) {
            player.leaveGame(callback2);
        } else {
            if (callback2 != null) {
                callback2.onGameLeaved(null, null);
            }
            MLog.error((Object)TAG, (String)"error game leave !!!!", (Object[])new Object[0]);
        }
    }

    public void toSelectPage(GameSelectContext gameSelectContext) {
        AbsGameSelecter selecter = this.createSelecter(this.innerSelectCallBack);
        if (selecter != null) {
            selecter.toSelectPage(gameSelectContext);
        }
    }

    public void matchGame(GameInfo gameInfo, GameMatchContext config, IMatchGameCallback callback2) {
        AbsGameMatcher matcher;
        this.mMatcher = matcher = this.createMatcher(this.innerMatchGameLifecycleCallBack);
        if (matcher != null) {
            matcher.matchGame(gameInfo, config, callback2);
        }
    }

    public void teamMatchGame(GameTeamMatchContext context) {
        AbsTeamMatcher matcher;
        this.teamMatcher = matcher = this.createTeamMatcher(this.innerTeamMatchLifecycleCallback);
        if (matcher != null) {
            matcher.teamMatch(context);
        }
    }

    public boolean isPlaying() {
        AbsGamePlayer player = this.mPlayer;
        if (player != null) {
            return player.isPlaying();
        }
        return false;
    }

    public boolean isMatching() {
        AbsGameMatcher matcher = this.mMatcher;
        if (matcher != null) {
            return matcher.isMatching();
        }
        return false;
    }

    public boolean isTeamMatching() {
        AbsTeamMatcher teamMatcher = this.teamMatcher;
        if (teamMatcher != null) {
            return teamMatcher.isTeamMatching();
        }
        return false;
    }

    public GameInfo getCurPlayingGame() {
        AbsGamePlayer player = this.mPlayer;
        if (player != null) {
            return player.getCurPlayingGame();
        }
        return null;
    }

    public GamePlayContext getCurPlayingGameContext() {
        AbsGamePlayer player = this.mPlayer;
        if (player != null) {
            return player.getCurPlayingGameContext();
        }
        return null;
    }

    public String getGameId() {
        GamePlayContext context = this.getCurPlayingGameContext();
        if (context != null) {
            return context.getGameInfo().gid;
        }
        return "";
    }

    public void innerMatchFinish(GameInfo info, GameMatchContext matchConfig, int matchType) {
    }

    public void innerTeamMatchFinish(GameTeamMatchContext context) {
    }

    public abstract AbsGamePlayer createPlayer(IGameLifecycle var1);

    public abstract AbsGameMatcher createMatcher(IMatchGameLifecycle var1);

    public abstract AbsGameSelecter createSelecter(ISelectCallBack var1);

    public AbsTeamMatcher createTeamMatcher(ITeamMatchLifecycle teamMatchLifecycle) {
        return null;
    }

    protected void onPreloadGameInner(GamePlayContext context) {
    }

    protected void onLoadGameFinishInner(GamePlayContext context, int finishType) {
    }

    protected void onPlayGameStartInner(GamePlayContext context) {
    }

    protected void onPlayGameFinishInner(GamePlayContext context, int finishType) {
    }

    protected void onPreGameExitInner(GamePlayContext context) {
    }

    protected void onGameExitedInner(GamePlayContext context, int gameExitType) {
    }

    protected void onGameSelectInner(GameSelectContext context) {
    }

    public CocoViewBean genGameViewDataInApp(int[] location, int width, int height) {
        if (location == null || location.length != 2) {
            MLog.error((Object)"baseGame", (String)"genGameViewDataInApp location\u53c2\u6570\u5f02\u5e38", (Object[])new Object[0]);
            return null;
        }
        if (this.mPlayer != null) {
            CocoViewBean cocoViewBean = new CocoViewBean();
            CocoViewBean gameViewData = this.mPlayer.getCocosViewData();
            int[] gameLocation = gameViewData.getLocation();
            if (gameLocation != null && gameLocation.length == 2) {
                int[] gameInAppLocatin = new int[2];
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"genGameViewDataInApp", (String)("gameLocation[0]=" + gameLocation[0] + " location[0]=" + location[0] + " gameLocation[1]=" + gameLocation[1] + " location[1]=" + location[1]), (Object[])new Object[0]);
                }
                gameInAppLocatin[0] = gameLocation[0] + location[0];
                gameInAppLocatin[1] = gameLocation[1] + location[1];
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"genGameViewDataInApp", (String)("gameInAppLocatin[0]" + gameInAppLocatin[0] + "," + gameLocation[0] + "," + location[0] + "--- gameInAppLocatin[1]" + gameInAppLocatin[1] + "," + gameLocation[1] + "," + location[1]), (Object[])new Object[0]);
                }
                cocoViewBean.setLocation(gameInAppLocatin);
                cocoViewBean.setWidth(width);
                cocoViewBean.setHeight(height);
                return cocoViewBean;
            }
        }
        return null;
    }

    public void notifyGameInvite(GameMessageModel gameMessageModel) {
        if (this.mPlayer != null) {
            this.mPlayer.notifyGameInvite(gameMessageModel);
        }
    }
}

