/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule;

import android.app.ActivityManager;
import android.content.pm.ConfigurationInfo;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.yy.appbase.core.DefaultController;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.game.download.version.GameVersion;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.tjgsdk.TjgSDK;
import com.yy.tjgsdk.event.Event;
import com.yy.tjgsdk.event.EventStage;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class GameReportController
extends DefaultController {
    private static final String TAG = "GameReportController";
    private long mGameStartTs = 0L;
    private IGameLifecycle iGameLifecycle = new GameLifeWrapper(){

        public void onGameViewInit(GamePlayContext context) {
            super.onGameViewInit(context);
            if (context == null) {
                MLog.error((Object)GameReportController.TAG, (String)"report game start error !!!!!!", (Object[])new Object[0]);
                return;
            }
            GameReportController.this.mGameStartTs = SystemClock.elapsedRealtime();
            String roomId = context.getRoomId();
            String gid = context.getGameInfo() != null ? context.getGameInfo().getGid() : "";
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20029429").put("room_id", roomId).put("function_id", "game_open").put("gid", gid).put("gid_ver", context.getGameInfo().getModulerVer()));
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameReportController.TAG, (String)"start game report,gid:%s, ts:%d, roomId:%s", (Object[])new Object[]{gid, GameReportController.this.mGameStartTs, roomId});
            }
            RuntimeContext.onGameStarted((String)context.getGameInfo().gid);
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    Event event = TjgSDK.Companion.getInstance().obtianEvent("game_state", "GameJoinGame", 4);
                    event.withRefState(1, "app_state");
                    TjgSDK.Companion.getInstance().fireEvent(event, EventStage.End, "");
                }
            }, (long)10000L);
            GameReportController.reportGameSource(context, "game_open_detail");
        }

        public void onGameViewDetach(GamePlayContext context) {
            super.onGameViewDetach(context);
            if (context == null) {
                MLog.error((Object)GameReportController.TAG, (String)"report game stop error !!!!!!", (Object[])new Object[0]);
                return;
            }
            if (GameReportController.this.mGameStartTs != 0L) {
                long duration = SystemClock.elapsedRealtime() - GameReportController.this.mGameStartTs;
                String roomId = context.getRoomId();
                String gid = context.getGameInfo() != null ? context.getGameInfo().getGid() : "";
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20029429").put("room_id", roomId).put("function_id", "game_close").put("gid", gid).put("game_dr", String.valueOf(duration)).put("gid_ver", context.getGameInfo().getModulerVer()));
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameReportController.TAG, (String)"stop game report,gid:%s, dr:%d, roomId:%s", (Object[])new Object[]{gid, duration, roomId});
                }
            }
            GameReportController.this.mGameStartTs = 0L;
            RuntimeContext.onGameStoped();
            Event event = TjgSDK.Companion.getInstance().obtianEvent("game_state", "GameLeaveGame", 4);
            event.withRefState(1, "app_state");
            TjgSDK.Companion.getInstance().fireEvent(event, EventStage.End, "");
        }

        public void onLoadGameFinish(GamePlayContext context, int finishType, @Nullable DefaultWindow window) {
            super.onLoadGameFinish(context, finishType, window);
            if (finishType == 0) {
                GameInfo gameInfo;
                long startTime = GameReportController.this.mGameStartTs;
                long endTime = SystemClock.elapsedRealtime();
                if (startTime > 0L && endTime > startTime) {
                    GameReportController.gameLoadReport(context.getGameInfo().gid, (int)(endTime - startTime));
                }
                if ((gameInfo = context.getGameInfo()) != null) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20029429").put("function_id", "load_game_pack").put("gid", context.getGameInfo().gid).put("gid_ver", GameVersion.INSTANCE.getVersion(context.getGameInfo().gid)).put("gid_ver_new", context.getGameInfo().getModulerVer()));
                }
            }
        }
    };

    public GameReportController(Environment env) {
        super(env);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle(this.iGameLifecycle);
        this.reportGameExt();
    }

    private void reportGameExt() {
        try {
            if (!SettingFlags.getBoolean((String)"hasreportgameext", (boolean)false)) {
                int isDeviceSupportsAEP = -1;
                if (Build.VERSION.SDK_INT >= 21) {
                    boolean deviceSupportsAEP = this.mContext.getPackageManager().hasSystemFeature("android.hardware.opengles.aep");
                    isDeviceSupportsAEP = deviceSupportsAEP ? 1 : 0;
                }
                ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
                int mGLESVersion = 0;
                if (activityManager != null) {
                    ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
                    mGLESVersion = configurationInfo.reqGlEsVersion >= 196608 ? 3 : 2;
                }
                GameReportController.engineSupportReport(isDeviceSupportsAEP, mGLESVersion);
                SettingFlags.setBoolean((String)"hasreportgameext", (boolean)true);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private static void engineSupportReport(int deviceSupportsAEP, int mGLESVersion) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "engine_support_ext");
        statContent.put("ifield", deviceSupportsAEP);
        statContent.put("ifieldtwo", mGLESVersion);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private static void gameLoadReport(String gid, int durTime) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "game_load");
        statContent.put("ifield", durTime);
        statContent.put("sfield", gid);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private static void reportGameSource(GamePlayContext context, String func) {
        String subSource;
        String gameSource = context.getExtendValue("game_from", (Object)"") instanceof String ? (String)context.getExtendValue("game_from", (Object)"") : "";
        String string2 = subSource = context.getExtendValue("h5_detail", (Object)"") instanceof String ? (String)context.getExtendValue("h5_detail", (Object)"") : "";
        if (StringUtils.equal((String)gameSource, (String)GameContextDef.GameFrom.ACTIVITY_PAGE_GAME.getId())) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20029429").put("function_id", func).put("game_open_source", gameSource).put("h5_detail", subSource));
        } else {
            String gid = context.getGameInfo() != null ? context.getGameInfo().getGid() : "";
            String gidVer = context.getGameInfo() != null ? context.getGameInfo().getModulerVer() : "";
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20029429").put("function_id", func).put("gid", gid).put("gid_ver", gidVer).put("room_id", context.getRoomId()).put("game_open_source", gameSource));
        }
    }
}

