/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule;

import android.content.Context;
import android.media.AudioManager;
import com.yy.appbase.abtest.serverab.IServerABService;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.game.R;
import com.yy.game.gamemodule.GameAppFlyerFirebaseHelper;
import com.yy.game.gamemodule.GameAppsFlyerHelper;
import com.yy.game.gamemodule.gameext.GameGudieVoiceRoomHandler;
import com.yy.game.utils.Utils;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.IMPKAcceptResBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInviteData;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.IGameInviteTimeoutListener;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;

public class GameControllerNew
extends DefaultController {
    private static final String TAG = "GameControllerNew";
    private int mOriAudioMode = -1;
    IGameCenterService mGameCenterService;
    private GameGudieVoiceRoomHandler mGameGuideVoiceRoomHandler = new GameGudieVoiceRoomHandler();
    private IGameLifecycle iGameLifecycle = new GameLifeWrapper(){

        public void onPreloadGame(GamePlayContext context) {
            if (context != null && context.getGameInfo() != null) {
                ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).startPlayGame(context.getGameInfo());
            }
        }

        public void onLoadGameFinish(GamePlayContext context, int finishType, DefaultWindow window) {
            super.onLoadGameFinish(context, finishType, window);
            if (finishType == 1) {
                if (context == null) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"cocosLua", (String)"GameControllerNewonLoadGameFinish GamePlayContext\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                    return;
                }
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_info_error), (int)0);
                Utils.checkGameFileValidOrDelete(context);
            } else {
                AudioManager audioManager = SystemServiceUtils.getAudioManager((Context)RuntimeContext.sApplicationContext);
                if (audioManager != null) {
                    GameControllerNew.this.mOriAudioMode = audioManager.getMode();
                }
            }
            if (finishType == 0) {
                ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).onGameJoinSuccess(context);
                if (ServiceManagerProxy.getService(IServerABService.class) != null) {
                    ((IServerABService)ServiceManagerProxy.getService(IServerABService.class)).getServerAB("social_game_match", null);
                }
            }
        }

        public void onPlayGameStart(GamePlayContext context) {
            super.onPlayGameStart(context);
            GameAppsFlyerHelper.reportGameStartCounts();
            GameAppFlyerFirebaseHelper.INSTANCE.reportGameStart(context);
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            try {
                if (context.getGameInfo() != null) {
                    ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).stopPlayGame(context.getGameInfo());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    block4: {
                        AudioManager audioManager = SystemServiceUtils.getAudioManager((Context)RuntimeContext.sApplicationContext);
                        if (audioManager != null) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)GameControllerNew.TAG, (String)("restore audio mode to " + GameControllerNew.this.mOriAudioMode), (Object[])new Object[0]);
                            }
                            try {
                                audioManager.setMode(GameControllerNew.this.mOriAudioMode);
                            }
                            catch (SecurityException e) {
                                MLog.error((Object)GameControllerNew.TAG, (Throwable)e);
                                if (!RuntimeContext.sIsDebuggable) break block4;
                                throw e;
                            }
                        }
                    }
                }
            });
            GameControllerNew.this.mGameGuideVoiceRoomHandler.onGameExited(context.getGameInfo(), gameExitType);
        }
    };

    GameControllerNew(Environment env, IGameCenterService gameCenterService2) {
        super(env);
        this.mGameCenterService = gameCenterService2;
        GameAppFlyerFirebaseHelper.INSTANCE.loadFromLocal();
        gameCenterService2.registerGameLifecycle(this.iGameLifecycle);
        NotificationCenter.getGlobalInstance().register(GameNotificationDef.GAME_REJECT_INVITE, (INotify)this);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == GameNotificationDef.GAME_REJECT_INVITE && notification.extObj instanceof IMPKAcceptResBean) {
            IMPKAcceptResBean bean = (IMPKAcceptResBean)notification.extObj;
            GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(bean.getGameId());
            if (gameInfo == null) {
                MLog.error((Object)TAG, (String)"GAME_REJECT_INVITE gameinfo == null", (Object[])new Object[0]);
            } else {
                this.mGameGuideVoiceRoomHandler.onInviteGameReject(gameInfo);
            }
        }
    }

    public void registerInviteListener() {
        ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).registerGameInviteTimeoutListener(new IGameInviteTimeoutListener(){

            public void onGameInviteTimeout(GameInviteData data) {
                GameInfo gameInfo;
                if (data != null && (gameInfo = data.mGameInfo) != null) {
                    GameControllerNew.this.mGameGuideVoiceRoomHandler.onInviteGameTimeOut(gameInfo);
                }
            }
        });
    }
}

