/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule;

import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.game.gamemodule.base.AbsGameController;
import com.yy.game.gamemodule.cloudgame.IndieCloudGameController;
import com.yy.game.gamemodule.componentgame.ComponentGameController;
import com.yy.game.gamemodule.gameplayer.OpenGameController;
import com.yy.game.gamemodule.pkgame.PkGameController;
import com.yy.game.gamemodule.simplegame.indie.IndieGameController;
import com.yy.game.gamemodule.simplegame.samescreen.SameScreenGameController;
import com.yy.game.gamemodule.simplegame.single.SingleGameController;
import com.yy.game.gamemodule.teamgame.TeamGameController;
import com.yy.game.gamemodule.webgame.WebGameController;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.game.service.protocol.ITeamMatchLifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class GameControllerFactory {
    private final HashMap<Integer, AbsGameController> mGameControllers = new HashMap();
    private final HashMap<GamePlayContext, AbsGameController> mOpenGameControllers = new HashMap();
    private ICallBack mCallBack;

    public GameControllerFactory(ICallBack callBack) {
        this.mCallBack = callBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsGameController getController(int gameModule, Environment env) {
        AbsGameController controller = null;
        HashMap<Integer, AbsGameController> hashMap = this.mGameControllers;
        synchronized (hashMap) {
            controller = this.mGameControllers.get(gameModule);
        }
        if (controller != null) {
            return controller;
        }
        if (gameModule == 1 || gameModule == 5 || gameModule == 7) {
            controller = new PkGameController(env, gameModule);
        } else if (gameModule == 4) {
            controller = new TeamGameController(env, gameModule);
        } else if (gameModule == 3) {
            controller = new SingleGameController(env, gameModule);
        } else if (gameModule == 2) {
            controller = new SameScreenGameController(env, gameModule);
        } else if (gameModule == 6) {
            controller = new IndieGameController(env, gameModule);
        } else if (gameModule == 8) {
            controller = new ComponentGameController(env, gameModule);
        } else if (gameModule == 9) {
            controller = new WebGameController(env, gameModule);
        } else if (gameModule == 11) {
            controller = new IndieCloudGameController(env, gameModule);
        }
        if (controller != null) {
            controller.setGameLifecycleCallback(this.mCallBack.getGameLifecycle());
            controller.setMatchCallback(this.mCallBack.getMatchLifecycle());
            controller.setTeamMatchCallback(this.mCallBack.getTeamMatchLifecycle());
            hashMap = this.mGameControllers;
            synchronized (hashMap) {
                this.mGameControllers.put(gameModule, controller);
            }
            return controller;
        }
        if (RuntimeContext.sIsDebuggable) {
            throw new RuntimeException(StringUtils.formatWitUSLocal((String)"no match game controller with game module:%d", (Object[])new Object[]{gameModule}));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsGameController getOpenGameController(GamePlayContext gamePlayContext, Environment environment) {
        AbsGameController controller = null;
        HashMap<GamePlayContext, AbsGameController> hashMap = this.mOpenGameControllers;
        synchronized (hashMap) {
            controller = this.mOpenGameControllers.get(gamePlayContext);
        }
        if (controller != null) {
            return controller;
        }
        controller = new OpenGameController(environment, gamePlayContext.getGameInfo().getGameMode());
        if (controller != null) {
            controller.setGameLifecycleCallback(this.mCallBack.getGameLifecycle());
            controller.setMatchCallback(this.mCallBack.getMatchLifecycle());
            controller.setTeamMatchCallback(this.mCallBack.getTeamMatchLifecycle());
            hashMap = this.mOpenGameControllers;
            synchronized (hashMap) {
                this.mOpenGameControllers.put(gamePlayContext, controller);
            }
            return controller;
        }
        if (RuntimeContext.sIsDebuggable) {
            throw new RuntimeException(StringUtils.formatWitUSLocal((String)"no match game controller with game gameinfo:%s", (Object[])new Object[]{gamePlayContext.getGameInfo()}));
        }
        return null;
    }

    public synchronized ArrayList<AbsGameController> getCacheControllers() {
        if (this.mGameControllers.size() <= 0) {
            return new ArrayList<AbsGameController>(0);
        }
        ArrayList<AbsGameController> result = new ArrayList<AbsGameController>();
        Set<Integer> keys = this.mGameControllers.keySet();
        AbsGameController item = null;
        for (Integer key : keys) {
            if (key == null || (item = this.mGameControllers.get(key)) == null) continue;
            result.add(item);
        }
        return result;
    }

    public synchronized ArrayList<AbsGameController> getOpenControllers() {
        if (this.mOpenGameControllers.size() <= 0) {
            return new ArrayList<AbsGameController>(0);
        }
        ArrayList<AbsGameController> result = new ArrayList<AbsGameController>();
        Set<GamePlayContext> keys = this.mOpenGameControllers.keySet();
        AbsGameController item = null;
        for (GamePlayContext key : keys) {
            if (key == null || (item = this.mOpenGameControllers.get(key)) == null) continue;
            result.add(item);
        }
        return result;
    }

    public void removeOpenController(GamePlayContext context) {
        this.mOpenGameControllers.remove(context);
    }

    public static interface ICallBack {
        public IGameLifecycle getGameLifecycle();

        public IMatchGameLifecycle getMatchLifecycle();

        public ITeamMatchLifecycle getTeamMatchLifecycle();
    }
}

