/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.gamemodule;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.game.R;
import com.yy.game.gamemodule.GameControllerFactory;
import com.yy.game.gamemodule.GameControllerNew;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gamemodule.InvalidIndieGameData;
import com.yy.game.gamemodule.base.AbsGameController;
import com.yy.game.gamemodule.simplegame.indie.IndieGameInfoInvalid;
import com.yy.game.module.Filter.GameJoinFilter;
import com.yy.game.utils.GameReportHelper;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.FilterRunnable;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.gamemode.IGameFliterInterface;
import com.yy.hiyo.game.base.helper.GameReportV1;
import com.yy.hiyo.game.base.singlegame.indie.IndieGamePlayContext;
import com.yy.hiyo.game.base.teamgame.utils.GameModeSP;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.AbstractGameContext;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameSelectContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.bean.OpenGameContext;
import com.yy.hiyo.game.service.bean.SameScreenPlayContext;
import com.yy.hiyo.game.service.bean.singlegame.SingleGamePlayContext;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import com.yy.hiyo.game.service.callback.IMatchGameCallback;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.game.service.protocol.IInviteGameLifecycle;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.game.service.protocol.ITeamMatchLifecycle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class GameCenterService
extends DefaultController
implements IGameCenterService {
    private static final String TAG = "GameCenterService";
    GameControllerNew gameControllerNew;
    GameJoinFilter mGameJoinFilter = new GameJoinFilter();
    private GameControllerFactory factory = null;
    private CopyOnWriteArrayList<WeakReference<IGameLifecycle>> gameLifecycleCallbackList = new CopyOnWriteArrayList();
    private List<WeakReference<IInviteGameLifecycle>> inviteGameLifecycleCallbackList = new ArrayList<WeakReference<IInviteGameLifecycle>>();
    private CopyOnWriteArrayList<WeakReference<IMatchGameLifecycle>> matchLifecycleCallbackList = new CopyOnWriteArrayList();
    private List<WeakReference<ITeamMatchLifecycle>> teamMatchLifecycleCallbackList = new ArrayList<WeakReference<ITeamMatchLifecycle>>();
    private GameReportV1.IReporter mIReporter = new GameReportV1.IReporter(){

        public void report(@NotNull Map<String, String> content) {
            StatisContent content1 = new StatisContent();
            if (content != null) {
                for (String key : content.keySet()) {
                    content1.put(key, content.get(key));
                }
                GameReportHelper.reportDownStart(content1);
            }
        }
    };
    private IGameLifecycle gameLifecycle = new IGameLifecycle(){

        public void onJoinGame(GamePlayContext context) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onJoinGame(context);
            }
        }

        public void onPreloadGame(GamePlayContext context) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onPreloadGame(context);
            }
        }

        public void onLoadGameFinish(GamePlayContext context, int finishType, DefaultWindow gameWindow) {
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                IGameLifecycle iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onLoadGameFinish(context, finishType, gameWindow);
            }
        }

        public void onGameReady(GamePlayContext context) {
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                IGameLifecycle iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onGameReady(context);
            }
        }

        public void onPlayGameStart(GamePlayContext context) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onPlayGameStart(context);
            }
        }

        public void onPlayGameFinish(GamePlayContext context, int finishType) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onPlayGameFinish(context, finishType);
            }
        }

        public void onPreGameExit(GamePlayContext context) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onPreGameExit(context);
            }
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onGameExited(context, gameExitType);
            }
            if (GameCenterService.this.factory != null) {
                GameCenterService.this.factory.removeOpenController(context);
            }
        }

        public void onGameViewAttach(GamePlayContext context) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onGameViewAttach(context);
            }
        }

        public void onGameViewInit(GamePlayContext context) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onGameViewInit(context);
            }
        }

        public void onGameViewDetach(GamePlayContext context) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onGameViewDetach(context);
            }
        }

        public void onGameViewShow(GamePlayContext context) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onGameViewShow(context);
            }
        }

        public void onGameViewHide(GamePlayContext context) {
            IGameLifecycle iGameLifecycle = null;
            for (WeakReference gameLifecycle : GameCenterService.this.gameLifecycleCallbackList) {
                iGameLifecycle = (IGameLifecycle)gameLifecycle.get();
                if (iGameLifecycle == null) continue;
                iGameLifecycle.onGameViewHide(context);
            }
        }
    };
    private IMatchGameLifecycle matchLifeCycle = new IMatchGameLifecycle(){

        public void prepareGameMatch(GameInfo ginfo, @NonNull GameMatchContext context) {
            IMatchGameLifecycle iMatchGameLifecycle = null;
            for (WeakReference lifecycle : GameCenterService.this.matchLifecycleCallbackList) {
                iMatchGameLifecycle = (IMatchGameLifecycle)lifecycle.get();
                if (iMatchGameLifecycle == null) continue;
                iMatchGameLifecycle.prepareGameMatch(ginfo, context);
            }
        }

        public void onGameMatchStart(GameInfo info, @NonNull GameMatchContext context) {
            IMatchGameLifecycle iMatchGameLifecycle = null;
            for (WeakReference lifecycle : GameCenterService.this.matchLifecycleCallbackList) {
                iMatchGameLifecycle = (IMatchGameLifecycle)lifecycle.get();
                if (iMatchGameLifecycle == null) continue;
                iMatchGameLifecycle.onGameMatchStart(info, context);
            }
        }

        public void onMatchFinish(GameInfo gameInfo, @Nonnull GameMatchContext matchContext, int matchType) {
            IMatchGameLifecycle iMatchGameLifecycle = null;
            for (WeakReference lifecycle : GameCenterService.this.matchLifecycleCallbackList) {
                iMatchGameLifecycle = (IMatchGameLifecycle)lifecycle.get();
                if (iMatchGameLifecycle == null) continue;
                iMatchGameLifecycle.onMatchFinish(gameInfo, matchContext, matchType);
            }
        }
    };
    private ITeamMatchLifecycle teamMatchLifecycle = new ITeamMatchLifecycle(){

        public void onPrepareTeamMatch(GameTeamMatchContext context) {
            ITeamMatchLifecycle iTeamMatchLifecycle = null;
            for (WeakReference lifecycle : GameCenterService.this.teamMatchLifecycleCallbackList) {
                iTeamMatchLifecycle = (ITeamMatchLifecycle)lifecycle.get();
                if (iTeamMatchLifecycle == null) continue;
                iTeamMatchLifecycle.onPrepareTeamMatch(context);
            }
        }

        public void onTeamReady(String teamId) {
            ITeamMatchLifecycle iTeamMatchLifecycle = null;
            for (WeakReference lifecycle : GameCenterService.this.teamMatchLifecycleCallbackList) {
                iTeamMatchLifecycle = (ITeamMatchLifecycle)lifecycle.get();
                if (iTeamMatchLifecycle == null) continue;
                iTeamMatchLifecycle.onTeamReady(teamId);
            }
        }

        public void onTeamMatchFinish(GameTeamMatchContext context) {
            ITeamMatchLifecycle iTeamMatchLifecycle = null;
            for (WeakReference lifecycle : GameCenterService.this.teamMatchLifecycleCallbackList) {
                iTeamMatchLifecycle = (ITeamMatchLifecycle)lifecycle.get();
                if (iTeamMatchLifecycle == null) continue;
                iTeamMatchLifecycle.onTeamMatchFinish(context);
            }
        }

        public void onDestroy() {
            ITeamMatchLifecycle iTeamMatchLifecycle = null;
            for (WeakReference lifecycle : GameCenterService.this.teamMatchLifecycleCallbackList) {
                iTeamMatchLifecycle = (ITeamMatchLifecycle)lifecycle.get();
                if (iTeamMatchLifecycle == null) continue;
                iTeamMatchLifecycle.onDestroy();
            }
        }
    };
    private InvalidIndieGameData mInvalidIndieGameData = new InvalidIndieGameData();

    public GameCenterService(Environment env) {
        super(env);
        this.gameControllerNew = new GameControllerNew(this.getEnvironment(), this);
        GameReportV1.Companion.setReport(this.mIReporter);
    }

    @MainThread
    public int joinGame(final GameInfo info, final GamePlayContext context) {
        this.checkInMainThread();
        if (info == null) {
            GameLoger.error("baseGame", "%s \u8fdb\u5165\u6e38\u620finfo == null", "[\u6e38\u620f\u751f\u547d\u5468\u671f]");
            return 1;
        }
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_MODLE_INIT));
        FilterRunnable runnable2 = new FilterRunnable(info, (AbstractGameContext)context){

            public void run() {
                GameCenterService.this.joinGameWithoutFilter(info, context);
            }
        };
        if (this.mGameJoinFilter.filter(4, runnable2)) {
            return 0;
        }
        return this.joinGameWithoutFilter(info, context);
    }

    private int joinGameWithoutFilter(GameInfo info, GamePlayContext context) {
        if (this.isPlaying() && info.getGameMode() != 10 && !this.isFloatGame(context)) {
            GameInfo gameInfo = this.getCurPlayingGame();
            GameLoger.error("baseGame", "\u6709\u6b63\u5728\u73a9\u7684\u6e38\u620f\uff0c\u91cd\u8fdb\u5165\u5931\u8d25\uff0c\u6b63\u5728\u73a9\u7684\u6e38\u620f\uff1a%s", gameInfo != null ? gameInfo : "");
            return 1;
        }
        if (info.isBetaTest()) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_beta_test_game), (int)1);
        } else {
            if (info.isFull()) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)1);
                return 1;
            }
            if (info.isFixing()) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)1);
                return 1;
            }
        }
        AbsGameController gameController = null;
        gameController = info.getGameMode() == 10 || this.isFloatGame(context) ? this.getOpenGameController(context) : this.getGameController(info);
        if (gameController != null) {
            return gameController.joinGame(info, context);
        }
        return 1;
    }

    public int restartGame(GameInfo info, GamePlayContext context) {
        AbsGameController gameController;
        this.checkInMainThread();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_MODLE_INIT));
        if (info != null && info.getGameMode() == 3 && (gameController = this.getGameController(info)) != null) {
            return gameController.restartGame(info, context);
        }
        if (RuntimeContext.sIsDebuggable) {
            throw new IllegalStateException("only single game can call this method.");
        }
        return 1;
    }

    public void leaveCurrentGame(ILeaveGameCallback callback2) {
        AbsGameController gameController;
        boolean hasLeave = false;
        if (this.isPlaying() && (gameController = this.getCurPlayGameController()) != null) {
            gameController.leaveGame(callback2);
            hasLeave = true;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"leaving game...", (Object[])new Object[0]);
            }
        }
        if (!hasLeave) {
            if (callback2 != null) {
                callback2.onGameLeaved(null, null);
            }
            MLog.error((Object)TAG, (String)"not match game controller,leave immediately!!!!", (Object[])new Object[0]);
        }
    }

    public void teamMatchGame(GameInfo gameInfo, GameTeamMatchContext context) {
        this.teamMatchGame(gameInfo, context, null);
    }

    public void teamMatchGame(GameInfo gameInfo, final GameTeamMatchContext context, final ITeamMatchLifecycle callBack) {
        this.checkInMainThread();
        if (gameInfo == null) {
            GameLoger.error("baseGame", "%s \u8fdb\u5165\u7ec4\u961f\u5339\u914dinfo == null", "[\u6e38\u620f\u751f\u547d\u5468\u671f]");
            return;
        }
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_MODLE_INIT));
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.MATCH_MODLE_INIT));
        FilterRunnable runnable2 = new FilterRunnable(gameInfo, (AbstractGameContext)context){

            public void run() {
                GameCenterService.this.teamMatchGameWithoutFilter(this.gameInfo, context, callBack);
            }
        };
        if (this.mGameJoinFilter.filter(16, runnable2)) {
            return;
        }
        this.teamMatchGameWithoutFilter(gameInfo, context, callBack);
    }

    private void teamMatchGameWithoutFilter(GameInfo gameInfo, GameTeamMatchContext context, ITeamMatchLifecycle callBack) {
        if (this.isTeamMatching()) {
            GameLoger.error("matchGame", "%s \u5df2\u5728\u7ec4\u961f\u5339\u914d\u4e2d\uff0c\u91cd\u590d\u8fdb\u5165\u7ec4\u961f\u5339\u914d \u6e38\u620f\u4fe1\u606f\uff1a%s\uff0c\u6e38\u620f\u4e0a\u4e0b\u6587\uff1a%s", "[\u6e38\u620f\u7ec4\u961f\u5339\u914d]", gameInfo, context);
            return;
        }
        AbsGameController gameController = this.getGameController(gameInfo);
        if (gameController != null) {
            gameController.teamMatchGame(context);
            gameController.setTeamMatchCallback(callBack);
        }
    }

    public void toSelectPage(GameSelectContext gameSelectContext, int gameMode) {
        this.checkInMainThread();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.MATCH_MODLE_INIT));
        AbsGameController gameController = this.getGameController(gameMode);
        if (gameController != null) {
            gameController.toSelectPage(gameSelectContext);
        }
    }

    public void matchGame(GameInfo gameInfo, final GameMatchContext config, final IMatchGameCallback callback2) {
        this.checkInMainThread();
        if (gameInfo == null) {
            GameLoger.error("baseGame", "%s \u8fdb\u5165\u5339\u914dinfo == null", "[\u6e38\u620f\u751f\u547d\u5468\u671f]");
            return;
        }
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.GAME_MODLE_INIT));
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)GameNotificationDef.MATCH_MODLE_INIT));
        FilterRunnable runnable2 = new FilterRunnable(gameInfo, (AbstractGameContext)config){

            public void run() {
                GameCenterService.this.matchGameWithoutFilter(this.gameInfo, config, callback2);
            }
        };
        if (this.mGameJoinFilter.filter(8, runnable2)) {
            return;
        }
        this.matchGameWithoutFilter(gameInfo, config, callback2);
    }

    private void matchGameWithoutFilter(GameInfo gameInfo, GameMatchContext config, IMatchGameCallback callback2) {
        if (this.isMatching()) {
            GameLoger.error("matchGame", "%s \u5df2\u5728\u5339\u914d\u4e2d\uff0c\u91cd\u590d\u8bf7\u6c42\u5339\u914d \u6e38\u620f\u4fe1\u606f\uff1a%s\uff0c\u6e38\u620f\u4e0a\u4e0b\u6587\uff1a%s", "[\u6e38\u620f\u5339\u914d]", gameInfo, config);
            return;
        }
        if (gameInfo.isBetaTest()) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_beta_test_game), (int)1);
        } else {
            if (gameInfo.isFull()) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)1);
                return;
            }
            if (gameInfo.isFixing()) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)1);
                return;
            }
        }
        AbsGameController gameController = this.getGameController(gameInfo);
        if (gameController != null) {
            gameController.matchGame(gameInfo, config, callback2);
        }
    }

    private AbsGameController getGameController(GameInfo info) {
        if (info == null) {
            return null;
        }
        return this.getGameController(info.getGameMode());
    }

    private AbsGameController getOpenGameController(GamePlayContext gamePlayContext) {
        GameInfo gameInfo = gamePlayContext.getGameInfo();
        if (gameInfo.getGameMode() != 10 && !this.isFloatGame(gamePlayContext)) {
            return null;
        }
        if (this.factory == null) {
            this.factory = new GameControllerFactory(new GameControllerFactory.ICallBack(){

                @Override
                public IGameLifecycle getGameLifecycle() {
                    return GameCenterService.this.gameLifecycle;
                }

                @Override
                public IMatchGameLifecycle getMatchLifecycle() {
                    return GameCenterService.this.matchLifeCycle;
                }

                @Override
                public ITeamMatchLifecycle getTeamMatchLifecycle() {
                    return GameCenterService.this.teamMatchLifecycle;
                }
            });
        }
        return this.factory.getOpenGameController(gamePlayContext, this.getEnvironment());
    }

    private AbsGameController getGameController(int gameMode) {
        if (gameMode <= 0) {
            return null;
        }
        if (this.factory == null) {
            this.factory = new GameControllerFactory(new GameControllerFactory.ICallBack(){

                @Override
                public IGameLifecycle getGameLifecycle() {
                    return GameCenterService.this.gameLifecycle;
                }

                @Override
                public IMatchGameLifecycle getMatchLifecycle() {
                    return GameCenterService.this.matchLifeCycle;
                }

                @Override
                public ITeamMatchLifecycle getTeamMatchLifecycle() {
                    return GameCenterService.this.teamMatchLifecycle;
                }
            });
        }
        return this.factory.getController(gameMode, this.getEnvironment());
    }

    private AbsGameController getCurPlayGameController() {
        ArrayList<AbsGameController> controllers;
        if (this.factory != null && (controllers = this.factory.getCacheControllers()) != null && controllers.size() > 0) {
            for (AbsGameController controller : controllers) {
                if (controller == null || !controller.isPlaying()) continue;
                return controller;
            }
        }
        return null;
    }

    private AbsGameController getPlayGameController(String gid) {
        ArrayList<AbsGameController> controllers;
        if (StringUtils.isEmpty((String)gid)) {
            return null;
        }
        if (this.factory != null && (controllers = this.factory.getCacheControllers()) != null && controllers.size() > 0) {
            for (AbsGameController controller : controllers) {
                if (controller == null || !StringUtils.equal((String)gid, (String)controller.getGameId())) continue;
                return controller;
            }
        }
        return null;
    }

    private AbsGameController getCurMatchGameController() {
        ArrayList<AbsGameController> controllers;
        if (this.factory != null && (controllers = this.factory.getCacheControllers()) != null && controllers.size() > 0) {
            for (AbsGameController controller : controllers) {
                if (controller == null || !controller.isMatching()) continue;
                return controller;
            }
        }
        return null;
    }

    private AbsGameController getCurTeamMatchGameController() {
        ArrayList<AbsGameController> controllers;
        if (this.factory != null && (controllers = this.factory.getCacheControllers()) != null && controllers.size() > 0) {
            for (AbsGameController controller : controllers) {
                if (controller == null || !controller.isTeamMatching()) continue;
                return controller;
            }
        }
        return null;
    }

    public boolean isPlaying() {
        return this.getCurPlayGameController() != null;
    }

    public boolean isPlaying(BasicGameInfo gameInfo) {
        if (gameInfo == null) {
            return false;
        }
        if (this.factory == null) {
            return false;
        }
        for (AbsGameController controller : this.factory.getOpenControllers()) {
            if (controller.getCurPlayingGame() == null) continue;
            return controller.getCurPlayingGame().getGid().equals(gameInfo.gid);
        }
        return false;
    }

    public boolean isMatching() {
        return this.getCurMatchGameController() != null;
    }

    public boolean isTeamMatching() {
        return this.getCurTeamMatchGameController() != null;
    }

    public GameInfo getCurPlayingGame() {
        AbsGameController gameController = this.getCurPlayGameController();
        if (gameController != null) {
            return gameController.getCurPlayingGame();
        }
        return null;
    }

    public GamePlayContext getCurPlayingGameContext() {
        ArrayList<AbsGameController> controllers = this.factory.getCacheControllers();
        if (controllers != null && controllers.size() > 0) {
            for (AbsGameController controller : controllers) {
                if (!controller.isPlaying()) continue;
                return controller.getCurPlayingGameContext();
            }
        }
        return null;
    }

    public void addFilter(int type, IGameFliterInterface gameFliterInterface) {
        this.mGameJoinFilter.addFilter(type, gameFliterInterface);
    }

    public void removeFilter(int type, IGameFliterInterface gameFliterInterface) {
        this.mGameJoinFilter.removeFilter(type, gameFliterInterface);
    }

    @MainThread
    public void registerGameLifecycle(IGameLifecycle lifecycle) {
        if (lifecycle != null && !this.isWeakListContainsObject(this.gameLifecycleCallbackList, lifecycle)) {
            this.gameLifecycleCallbackList.add(new WeakReference<IGameLifecycle>(lifecycle));
        }
    }

    @MainThread
    public void unRegisterGameLifecycle(IGameLifecycle lifecycle) {
        if (lifecycle != null && this.isWeakListContainsObject(this.gameLifecycleCallbackList, lifecycle)) {
            YYTaskExecutor.postToMainThread(() -> this.removeWeakListObject(this.gameLifecycleCallbackList, lifecycle));
        }
    }

    @MainThread
    public void registerGameMatchEvent(IMatchGameLifecycle matchGame) {
        if (matchGame != null && !this.isWeakListContainsObject(this.matchLifecycleCallbackList, matchGame)) {
            this.matchLifecycleCallbackList.add(new WeakReference<IMatchGameLifecycle>(matchGame));
        }
    }

    @MainThread
    public void unRegisterGameMatchEvent(IMatchGameLifecycle matchGame) {
        if (matchGame != null && this.isWeakListContainsObject(this.matchLifecycleCallbackList, matchGame)) {
            this.removeWeakListObject(this.matchLifecycleCallbackList, matchGame);
        }
    }

    @MainThread
    public void registerGameInviteLifecycle(IInviteGameLifecycle iInviteGame) {
        if (iInviteGame != null && !this.isWeakListContainsObject(this.inviteGameLifecycleCallbackList, iInviteGame)) {
            this.inviteGameLifecycleCallbackList.add(new WeakReference<IInviteGameLifecycle>(iInviteGame));
        }
    }

    @MainThread
    public void unRegisterGameInviteLifecycle(IInviteGameLifecycle iInviteGame) {
        if (iInviteGame != null && this.isWeakListContainsObject(this.inviteGameLifecycleCallbackList, iInviteGame)) {
            this.removeWeakListObject(this.inviteGameLifecycleCallbackList, iInviteGame);
        }
    }

    @MainThread
    public void registerTeamMatchLifecycle(ITeamMatchLifecycle teamMatchLifecycle) {
        if (teamMatchLifecycle != null && !this.isWeakListContainsObject(this.teamMatchLifecycleCallbackList, teamMatchLifecycle)) {
            this.teamMatchLifecycleCallbackList.add(new WeakReference<ITeamMatchLifecycle>(teamMatchLifecycle));
        }
    }

    @MainThread
    public void unregisterTeamMatchLifecycle(ITeamMatchLifecycle teamMatchLifecycle) {
        if (teamMatchLifecycle != null && this.isWeakListContainsObject(this.teamMatchLifecycleCallbackList, teamMatchLifecycle)) {
            this.removeWeakListObject(this.teamMatchLifecycleCallbackList, teamMatchLifecycle);
        }
    }

    private boolean checkInMainThread() {
        boolean mainThread = true;
        if (!YYTaskExecutor.isMainThread()) {
            mainThread = false;
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("must invoke in main thread");
            }
            MLog.error((Object)TAG, (String)"must invoke in main thread", (Object[])new Object[0]);
        }
        return mainThread;
    }

    private <T> boolean isWeakListContainsObject(List<WeakReference<T>> list, T t) {
        for (WeakReference<T> weakReference : list) {
            Object iWeakReference = weakReference.get();
            if (iWeakReference == null || iWeakReference != t) continue;
            return true;
        }
        return false;
    }

    private <T> void removeWeakListObject(List<WeakReference<T>> list, T t) {
        WeakReference<T> weakReferceObject = null;
        for (WeakReference<T> weakReference : list) {
            Object iWeakReference = weakReference.get();
            if (iWeakReference == null || iWeakReference != t) continue;
            weakReferceObject = weakReference;
        }
        if (weakReferceObject != null) {
            list.remove(weakReferceObject);
        }
    }

    public CocoViewBean genGameViewDataInApp(int[] location, int width, int height) {
        AbsGameController controller = this.getCurPlayGameController();
        return this.genGameViewDataInApp(controller, location, width, height);
    }

    public CocoViewBean genGameViewDataInApp(String gid, int[] location, int width, int height) {
        AbsGameController controller = this.getPlayGameController(gid);
        return this.genGameViewDataInApp(controller, location, width, height);
    }

    private CocoViewBean genGameViewDataInApp(AbsGameController controller, int[] location, int width, int height) {
        if (controller == null) {
            return new CocoViewBean();
        }
        CocoViewBean bean = controller.genGameViewDataInApp(location, width, height);
        if (bean == null) {
            bean = new CocoViewBean();
        }
        return bean;
    }

    public void notifyGameInvite(Object gameMessageModel) {
        AbsGameController gameController;
        if (gameMessageModel instanceof GameMessageModel && (gameController = this.getCurPlayGameController()) != null) {
            gameController.notifyGameInvite((GameMessageModel)gameMessageModel);
        }
    }

    public void startJoinGameFlow(GameInfo gameInfo, GameContextDef.JoinFrom from, Map<String, Object> ext) {
        if (gameInfo == null) {
            MLog.error((Object)TAG, (String)"startJoinGameFlow game info null!!!", (Object[])new Object[0]);
            return;
        }
        boolean isValid = ((IGameService)this.getServiceManager().getService(IGameService.class)).isGameValid(gameInfo);
        if (!isValid) {
            MLog.error((Object)TAG, (String)"startJoinGameFlow game info not valid!!!,gameInfo:%s", (Object[])new Object[]{gameInfo});
            return;
        }
        if (gameInfo.getGameMode() == 1) {
            GameMatchContext context = new GameMatchContext(from);
            if (ext != null) {
                context.addAllExtendValue(ext);
            }
            this.addGameFrom((AbstractGameContext)context, from);
            this.matchGame(gameInfo, context, null);
        } else if (gameInfo.getGameMode() == 2) {
            SameScreenPlayContext context = new SameScreenPlayContext(from);
            if (ext != null) {
                context.addAllExtendValue(ext);
            }
            context.setGameInfo(gameInfo);
            this.addGameFrom((AbstractGameContext)context, from);
            this.joinGame(gameInfo, (GamePlayContext)context);
        } else if (gameInfo.getGameMode() == 3) {
            SingleGamePlayContext context = new SingleGamePlayContext.Builder(from).build();
            if (ext != null) {
                context.addAllExtendValue(ext);
            }
            context.setGameInfo(gameInfo);
            this.addGameFrom((AbstractGameContext)context, from);
            this.joinGame(gameInfo, (GamePlayContext)context);
        } else if (gameInfo.getGameMode() == 4) {
            int multiMode = GameModeSP.getGameSelectedMode((String)gameInfo.gid);
            GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(from);
            if (ext != null) {
                teamMatchContext.addAllExtendValue(ext);
            }
            teamMatchContext.setGameInfo(gameInfo);
            teamMatchContext.setMultiModeCode(multiMode);
            teamMatchContext.setAutoMatch(true);
            this.addGameFrom((AbstractGameContext)teamMatchContext, from);
            this.teamMatchGame(gameInfo, teamMatchContext);
        } else if (gameInfo.getGameMode() == 5) {
            GameMatchContext gameMatchContext = new GameMatchContext(from);
            if (ext != null) {
                gameMatchContext.addAllExtendValue(ext);
            }
            this.addGameFrom((AbstractGameContext)gameMatchContext, from);
            this.matchGame(gameInfo, gameMatchContext, null);
        } else if (gameInfo.getGameMode() == 6) {
            IndieGamePlayContext playContext = new IndieGamePlayContext.Builder(from).build();
            if (ext != null) {
                playContext.addAllExtendValue(ext);
            }
            playContext.setGameInfo(gameInfo);
            this.addGameFrom((AbstractGameContext)playContext, from);
            this.joinGame(gameInfo, (GamePlayContext)playContext);
        } else if (gameInfo.getGameMode() == 7) {
            GameMatchContext gameMatchContext = new GameMatchContext(from);
            if (ext != null) {
                gameMatchContext.addAllExtendValue(ext);
            }
            this.addGameFrom((AbstractGameContext)gameMatchContext, from);
            this.matchGame(gameInfo, gameMatchContext, null);
        } else if (gameInfo.getGameMode() == 9) {
            GamePlayContext context = new GamePlayContext(from);
            if (ext != null) {
                context.addAllExtendValue(ext);
            }
            context.setGameInfo(gameInfo);
            this.addGameFrom((AbstractGameContext)context, from);
            this.joinGame(gameInfo, context);
        } else {
            MLog.error((Object)TAG, (String)"startJoinGameFlow not support opporation!!!,gameInfo:%s", (Object[])new Object[]{gameInfo});
        }
    }

    public void startJoinGameFlow(GameInfo gameInfo, GameContextDef.JoinFrom from) {
        Object extend;
        ArrayMap extMap = null;
        if (gameInfo != null && (extend = MsgDispatcher.getInstance().sendMessageSync(GrowthMsgDef.NO_ACTION_GAME_EXTEND, (Object)gameInfo.gid)) instanceof String) {
            extMap = new ArrayMap();
            extMap.put("extend_game_action", extend);
        }
        this.startJoinGameFlow(gameInfo, from, (Map<String, Object>)extMap);
    }

    private void addGameFrom(AbstractGameContext context, GameContextDef.JoinFrom from) {
        if (from != null && from.getGameFrom() != null) {
            context.addExtendValue("game_from", (Object)from.getGameFrom().getId());
        }
    }

    private boolean isFloatGame(GamePlayContext context) {
        return context instanceof OpenGameContext && context.getGameInfo().isPopupGame();
    }

    public void registerInviteListener() {
        this.gameControllerNew.registerInviteListener();
    }

    public void appendInvalidIndieGameInvite(Object data) {
        if (data instanceof IndieGameInfoInvalid) {
            this.mInvalidIndieGameData.append((IndieGameInfoInvalid)data);
        }
    }

    public boolean isInvalidIndieGameInvite(String roomId) {
        return this.mInvalidIndieGameData.isInValid(roomId);
    }
}

