/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.download.version;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.download.flag.GameFlag;
import com.yy.game.download.version.GameVersion;
import com.yy.game.download.version.GameVersionInfo;
import com.yy.game.module.gameroom.ui.EngineConfigGeneratorKt;
import com.yy.hago.gamesdk.cache.GameFile;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.service.IGameInfoService;
import java.io.File;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\\]B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J0\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u000f2\b\b\u0002\u0010*\u001a\u00020\u000fJ2\u0010+\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u000f2\b\b\u0002\u0010*\u001a\u00020\u000fH\u0002J\u0010\u0010,\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0006H\u0002J\u000e\u0010-\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u0006J\u001c\u0010.\u001a\u00020\u000f2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020%00H\u0002J\r\u00101\u001a\u00020#H\u0000\u00a2\u0006\u0002\b2J\u0010\u00103\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00104\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J\b\u00105\u001a\u00020\u000fH\u0002J&\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020\u00122\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020%\u0018\u000100H\u0002J$\u00108\u001a\u00020#2\u0006\u00107\u001a\u00020\u00122\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020%00H\u0002J\u0018\u00109\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010:\u001a\u00020\u0006H\u0002J\b\u0010;\u001a\u00020#H\u0002J\u0006\u0010<\u001a\u00020#J\"\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020\u00062\b\b\u0002\u0010*\u001a\u00020\u000f2\b\b\u0002\u0010?\u001a\u00020\u000fJ$\u0010@\u001a\u00020#2\u0006\u0010>\u001a\u00020\u00062\b\b\u0002\u0010*\u001a\u00020\u000f2\b\b\u0002\u0010?\u001a\u00020\u000fH\u0002J\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001f0BJ\u0010\u0010C\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010%J\u0012\u0010D\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0006H\u0002J\u0006\u0010E\u001a\u00020\tJ\u000e\u0010F\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010G\u001a\u00020#H\u0002J\u000e\u0010H\u001a\u00020#2\u0006\u0010I\u001a\u00020\u000fJ\u000e\u0010J\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u0006J\u0010\u0010K\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010%J\u0010\u0010L\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010%J\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u0006J\u000e\u0010M\u001a\u00020\u000f2\u0006\u0010N\u001a\u00020%J\u0006\u0010O\u001a\u00020#J\u000e\u0010(\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006J\b\u0010P\u001a\u00020#H\u0002J\u001c\u0010Q\u001a\u00020#2\u0006\u00107\u001a\u00020\u00122\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0BJ\u001e\u0010T\u001a\u00020#2\u0006\u00107\u001a\u00020\u00122\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0BH\u0002J\u0015\u0010U\u001a\u00020#2\u0006\u0010>\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\bVJ\u001d\u0010W\u001a\u00020#2\u0006\u0010>\u001a\u00020\u00062\u0006\u0010X\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bYJ\u0012\u0010Z\u001a\u00020#2\b\b\u0002\u0010[\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/yy/game/download/version/GameVersion;", "", "()V", "ALL_COUNT", "", "CHECK_OLD_CONFIG_KEY", "", "CHECK_OLD_DIR_KEY", "DAY_7", "", "OUT_DATE_INTERVAL", "TAG", "fileLock", "Ljava/util/concurrent/locks/ReentrantLock;", "hadInit", "", "mCheckTaskMap", "", "Lcom/yy/hiyo/game/base/bean/GameInfoSource;", "Lcom/yy/game/download/version/GameVersion$CheckGameFileTask;", "mJsonType", "Ljava/lang/reflect/Type;", "getMJsonType", "()Ljava/lang/reflect/Type;", "mJsonType$delegate", "Lkotlin/Lazy;", "mPendingTask", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/Runnable;", "mStorageGameInfos", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/yy/game/download/version/GameVersionInfo;", "saveLimitExecutor", "Lcom/yy/base/taskexecutor/IFrequencyLimitExecutor;", "addGame", "", "info", "Lcom/yy/hiyo/game/base/bean/BasicGameInfo;", "gid", "version", "md5", "isGrayGame", "write", "addGameInner", "addWithFile", "canSilentDownload", "checkAppGameFile", "gameInfoMap", "", "checkDeleteGame", "checkDeleteGame$game_debug", "checkFile", "checkFileNameVersionAndMd5", "checkFileState", "checkGameFile", "source", "checkOldDir", "checkVersion", "path", "configFromFile", "deleteAllGame", "deleteGame", "gameId", "canAutoDownload", "deleteGameInner", "getDownloadGame", "", "getGameDownloadType", "getGameInfo", "getTotalSize", "getVersion", "handlePendingTask", "init", "reset", "isAlreadyDownload", "isGameInfoValid", "isGamePkgValid", "isNonforceUpdate", "gameInfo", "logout", "readStateConfig", "setGameInfoList", "list", "Lcom/yy/hiyo/game/base/bean/GameInfo;", "setGameInfoListInner", "startGame", "startGame$game_debug", "updatePlayCount", "count", "updatePlayCount$game_debug", "writeStateConfig", "writeInterval", "CheckGameFileTask", "GameDownloadType", "game_debug"})
public final class GameVersion {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final String TAG = "GameVersion";
    private static final String CHECK_OLD_DIR_KEY = "check_old_dir_key-";
    private static final String CHECK_OLD_CONFIG_KEY = "check_old_config_key";
    private static final long OUT_DATE_INTERVAL;
    private static final long DAY_7;
    private static final int ALL_COUNT = 3;
    private static final ConcurrentHashMap<String, GameVersionInfo> mStorageGameInfos;
    private static final Map<GameInfoSource, CheckGameFileTask> mCheckTaskMap;
    private static final CopyOnWriteArrayList<Runnable> mPendingTask;
    private static final ReentrantLock fileLock;
    private static final Lazy mJsonType$delegate;
    private static volatile boolean hadInit;
    private static IFrequencyLimitExecutor saveLimitExecutor;
    public static final GameVersion INSTANCE;

    static {
        GameVersion gameVersion;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GameVersion.class), "mJsonType", "getMJsonType()Ljava/lang/reflect/Type;"))};
        INSTANCE = gameVersion = new GameVersion();
        OUT_DATE_INTERVAL = TimeUnit.DAYS.toMillis(30L);
        DAY_7 = TimeUnit.DAYS.toMillis(7L);
        mStorageGameInfos = new ConcurrentHashMap();
        boolean bl = false;
        mCheckTaskMap = new LinkedHashMap();
        mPendingTask = new CopyOnWriteArrayList();
        fileLock = new ReentrantLock();
        mJsonType$delegate = LazyKt.lazy((Function0)mJsonType.2.INSTANCE);
    }

    private final Type getMJsonType() {
        Lazy lazy = mJsonType$delegate;
        GameVersion gameVersion = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Type)lazy.getValue();
    }

    public final boolean isGameInfoValid(@Nullable BasicGameInfo info) {
        String currentMd5;
        if (info == null || TextUtils.isEmpty((CharSequence)info.getGid())) {
            return false;
        }
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"isGameValid not init source", (Object[])new Object[0]);
            return false;
        }
        GameVersionInfo gameVersionInfo = mStorageGameInfos.get(info.getGid());
        if (gameVersionInfo == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gameVersionInfo, (String)"mStorageGameInfos[info.getGid()] ?: return false");
        GameVersionInfo storage = gameVersionInfo;
        if (storage.getPreDelete$game_debug() > 0) {
            storage.setPreDelete$game_debug(0);
        }
        int localVersion = StringUtils.safeParseInt((String)storage.getVersion$game_debug());
        int infoVersion = StringUtils.safeParseInt((String)info.getModulerVer());
        boolean isCurrentGray = info.isModuleGray();
        boolean isSaveGray = storage.isGrayGame$game_debug();
        String saveMd5 = storage.getMd5$game_debug();
        if (StringUtils.equalsIgnoreCase((String)saveMd5, (String)(currentMd5 = info.getModulerMd5()))) {
            if (localVersion != 0 && localVersion != infoVersion) {
                info.setModulerVer(String.valueOf(localVersion));
            }
            return true;
        }
        if (RemoteGameDebugService.Companion.useRemoteIp(info.gid)) {
            return false;
        }
        if (isSaveGray) {
        } else {
            if (localVersion != 0 && infoVersion < localVersion) {
                info.setModulerVer(String.valueOf(localVersion));
            }
            return infoVersion <= localVersion || this.isNonforceUpdate(info);
        }
        return isCurrentGray ? infoVersion == localVersion || this.isNonforceUpdate(info) : false;
    }

    public final boolean isNonforceUpdate(@NotNull BasicGameInfo gameInfo) {
        boolean isNonforceUpdate;
        Intrinsics.checkParameterIsNotNull((Object)gameInfo, (String)"gameInfo");
        GameVersionInfo gameVersionInfo = mStorageGameInfos.get(gameInfo.getGid());
        if (gameVersionInfo == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gameVersionInfo, (String)"mStorageGameInfos[gameIn\u2026getGid()] ?: return false");
        GameVersionInfo storage = gameVersionInfo;
        int localVersion = StringUtils.safeParseInt((String)storage.getVersion$game_debug());
        int infoVersion = StringUtils.safeParseInt((String)gameInfo.getModulerVer());
        boolean isSaveGray = storage.isGrayGame$game_debug();
        if (localVersion <= 0 || gameInfo.isModuleGray() != isSaveGray) {
            return false;
        }
        long l = gameInfo.getMinCompatibleVer();
        boolean bl = isNonforceUpdate = 0L <= l && (long)localVersion >= l && localVersion < infoVersion;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("localVersion=" + localVersion + ", isNonforceUpdate=" + isNonforceUpdate + ", gameInfo:" + gameInfo), (Object[])new Object[0]);
        }
        return isNonforceUpdate;
    }

    public final boolean isGamePkgValid(@Nullable BasicGameInfo info) {
        String currentMd5;
        if (info == null || TextUtils.isEmpty((CharSequence)info.getGid())) {
            return false;
        }
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"isGameValid not init source", (Object[])new Object[0]);
            return false;
        }
        GameVersionInfo gameVersionInfo = mStorageGameInfos.get(info.getGid());
        if (gameVersionInfo == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gameVersionInfo, (String)"mStorageGameInfos[info.getGid()] ?: return false");
        GameVersionInfo storage = gameVersionInfo;
        if (storage.getPreDelete$game_debug() > 0) {
            storage.setPreDelete$game_debug(0);
        }
        int localVersion = StringUtils.safeParseInt((String)storage.getVersion$game_debug());
        int infoVersion = StringUtils.safeParseInt((String)info.getModulerVer());
        boolean isCurrentGray = info.isModuleGray();
        boolean isSaveGray = storage.isGrayGame$game_debug();
        String saveMd5 = storage.getMd5$game_debug();
        if (StringUtils.equalsIgnoreCase((String)saveMd5, (String)(currentMd5 = info.getModulerMd5()))) {
            if (localVersion != 0 && localVersion != infoVersion) {
                info.setModulerVer(String.valueOf(localVersion));
            }
            return true;
        }
        if (RemoteGameDebugService.Companion.useRemoteIp(info.gid)) {
            return false;
        }
        if (isSaveGray) {
        } else {
            if (localVersion != 0 && infoVersion < localVersion) {
                info.setModulerVer(String.valueOf(localVersion));
            }
            return infoVersion <= localVersion;
        }
        return isCurrentGray ? infoVersion == localVersion : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getGameDownloadType(@Nullable BasicGameInfo info) {
        String currentMd5;
        if (info == null) return 2;
        if (TextUtils.isEmpty((CharSequence)info.getGid())) {
            return 2;
        }
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"isGameValid not init source", (Object[])new Object[0]);
            return 2;
        }
        GameVersionInfo gameVersionInfo = mStorageGameInfos.get(info.getGid());
        if (gameVersionInfo == null) return 1;
        Intrinsics.checkExpressionValueIsNotNull((Object)gameVersionInfo, (String)"mStorageGameInfos[info.g\u2026 ?: return FIRST_DOWNLOAD");
        GameVersionInfo storage = gameVersionInfo;
        if (storage.getPreDelete$game_debug() > 0) {
            storage.setPreDelete$game_debug(0);
        }
        int localVersion = StringUtils.safeParseInt((String)storage.getVersion$game_debug());
        int infoVersion = StringUtils.safeParseInt((String)info.getModulerVer());
        boolean isCurrentGray = info.isModuleGray();
        boolean isSaveGray = storage.isGrayGame$game_debug();
        String saveMd5 = storage.getMd5$game_debug();
        if (StringUtils.equalsIgnoreCase((String)saveMd5, (String)(currentMd5 = info.getModulerMd5()))) {
            if (localVersion == 0) return 0;
            if (localVersion == infoVersion) return 0;
            info.setModulerVer(String.valueOf(localVersion));
            return 0;
        }
        if (RemoteGameDebugService.Companion.useRemoteIp(info.gid)) {
            return 2;
        }
        if (isSaveGray) {
            if (!isCurrentGray) return 2;
            if (infoVersion != localVersion) return 2;
            return 0;
        }
        if (localVersion != 0 && infoVersion < localVersion) {
            info.setModulerVer(String.valueOf(localVersion));
        }
        if (localVersion == 0) {
            return 1;
        }
        if (infoVersion > localVersion) return 2;
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GameVersionInfo> getDownloadGame() {
        void $this$filterTo$iv$iv;
        boolean bl = false;
        List list = new ArrayList();
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"getDownloadGame not init source", (Object[])new Object[0]);
            return list;
        }
        Collection<GameVersionInfo> collection = mStorageGameInfos.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"mStorageGameInfos.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GameVersionInfo it = (GameVersionInfo)element$iv$iv;
            boolean bl2 = false;
            if (!(!it.getHadDelete$game_debug())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GameVersionInfo it = (GameVersionInfo)element$iv;
            boolean bl3 = false;
            GameVersionInfo gameVersionInfo = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)gameVersionInfo, (String)"it");
            list.add(gameVersionInfo);
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getDownloadGame size: %d", (Object[])new Object[]{list.size()});
        }
        return list;
    }

    public final long getTotalSize() {
        long total = 0L;
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"getTotalSize not init source", (Object[])new Object[0]);
            return total;
        }
        Collection<GameVersionInfo> collection = mStorageGameInfos.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"mStorageGameInfos.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GameVersionInfo it = (GameVersionInfo)element$iv;
            boolean bl = false;
            total += it.getSize$game_debug();
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getTotalSize: %d", (Object[])new Object[]{total});
        }
        return total;
    }

    public final boolean isAlreadyDownload(@NotNull String gid) {
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"isAlreadyDownload not init source, gid: %s", (Object[])new Object[]{gid});
            return false;
        }
        GameVersionInfo info = mStorageGameInfos.get(gid);
        return info != null && info.isDownload();
    }

    public final boolean isGrayGame(@NotNull String gid) {
        GameVersionInfo info;
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"isGrayGame not init source, gid: %s", (Object[])new Object[]{gid});
            return false;
        }
        GameVersionInfo gameVersionInfo = info = mStorageGameInfos.get(gid);
        if (gameVersionInfo != null) {
            GameVersionInfo gameVersionInfo2 = gameVersionInfo;
            boolean bl = false;
            boolean bl2 = false;
            GameVersionInfo it = gameVersionInfo2;
            boolean bl3 = false;
            return it.isGrayGame$game_debug();
        }
        return false;
    }

    @NotNull
    public final String md5(@NotNull String gid) {
        GameVersionInfo info;
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"md5 not init source, gid: %s", (Object[])new Object[]{gid});
            return "";
        }
        GameVersionInfo gameVersionInfo = info = mStorageGameInfos.get(gid);
        if (gameVersionInfo != null) {
            GameVersionInfo gameVersionInfo2 = gameVersionInfo;
            boolean bl = false;
            boolean bl2 = false;
            GameVersionInfo it = gameVersionInfo2;
            boolean bl3 = false;
            return it.getMd5$game_debug();
        }
        return "";
    }

    @NotNull
    public final String getVersion(@NotNull String gid) {
        GameVersionInfo info;
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"md5 not init source, gid: %s", (Object[])new Object[]{gid});
            return "";
        }
        GameVersionInfo gameVersionInfo = info = mStorageGameInfos.get(gid);
        if (gameVersionInfo != null) {
            GameVersionInfo gameVersionInfo2 = gameVersionInfo;
            boolean bl = false;
            boolean bl2 = false;
            GameVersionInfo it = gameVersionInfo2;
            boolean bl3 = false;
            return it.getVersion$game_debug();
        }
        return "";
    }

    public final void setGameInfoList(@NotNull GameInfoSource source, @NotNull List<? extends GameInfo> list) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        if (list.isEmpty()) {
            return;
        }
        if (this.hadInit()) {
            this.setGameInfoListInner(source, list);
        } else {
            MLog.error((Object)TAG, (String)"setGameInfoList not init source: %s", (Object[])new Object[]{source});
            mPendingTask.add(new Runnable(source, list){
                final /* synthetic */ GameInfoSource $source;
                final /* synthetic */ List $list;

                public final void run() {
                    GameVersion.access$setGameInfoListInner(GameVersion.INSTANCE, this.$source, this.$list);
                }
                {
                    this.$source = gameInfoSource;
                    this.$list = list;
                }
            });
        }
    }

    public final boolean canSilentDownload(@NotNull String gid) {
        GameVersionInfo info;
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"md5 not init source, gid: %s", (Object[])new Object[]{gid});
            return true;
        }
        GameVersionInfo gameVersionInfo = info = mStorageGameInfos.get(gid);
        if (gameVersionInfo != null) {
            GameVersionInfo gameVersionInfo2 = gameVersionInfo;
            boolean bl = false;
            boolean bl2 = false;
            GameVersionInfo it = gameVersionInfo2;
            boolean bl3 = false;
            return it.getCanAutoDownload$game_debug();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void setGameInfoListInner(GameInfoSource source, List<? extends GameInfo> list) {
        boolean bl = false;
        Map gameInfoMap = new LinkedHashMap();
        if (!FP.empty((Collection)list)) {
            for (GameInfo gameInfo : list) {
                String string2 = gameInfo.getGid();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info.getGid()");
                gameInfoMap.put(string2, gameInfo);
            }
        }
        if (!FP.empty((Map)gameInfoMap)) {
            void var4_7;
            CheckGameFileTask checkGameFileTask = mCheckTaskMap.get(source);
            if (checkGameFileTask == null) {
                CheckGameFileTask checkGameFileTask2 = new CheckGameFileTask(source);
                mCheckTaskMap.put(source, checkGameFileTask2);
            }
            var4_7.setGameInfoMap(gameInfoMap);
            YYTaskExecutor.removeTask((Runnable)((Runnable)var4_7));
            YYTaskExecutor.execute((Runnable)((Runnable)var4_7), (long)1000L);
        }
    }

    public final void addGame(@NotNull BasicGameInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        String string2 = info.gid;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info.gid");
        String string3 = info.getModulerVer();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"info.modulerVer");
        String string4 = info.getModulerMd5();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"info.modulerMd5");
        this.addGame(string2, string3, string4, info.isModuleGray(), true);
    }

    public final void addGame(@NotNull String gid, @NotNull String version, @NotNull String md5, boolean isGrayGame, boolean write) {
        Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)md5, (String)"md5");
        if (TextUtils.isEmpty((CharSequence)gid)) {
            return;
        }
        if (this.hadInit()) {
            this.addGameInner(gid, version, md5, isGrayGame, write);
        } else {
            MLog.error((Object)TAG, (String)"addGame not init gid: %s", (Object[])new Object[]{gid});
            mPendingTask.add(new Runnable(gid, version, md5, isGrayGame, write){
                final /* synthetic */ String $gid;
                final /* synthetic */ String $version;
                final /* synthetic */ String $md5;
                final /* synthetic */ boolean $isGrayGame;
                final /* synthetic */ boolean $write;

                public final void run() {
                    GameVersion.access$addGameInner(GameVersion.INSTANCE, this.$gid, this.$version, this.$md5, this.$isGrayGame, this.$write);
                }
                {
                    this.$gid = string2;
                    this.$version = string3;
                    this.$md5 = string4;
                    this.$isGrayGame = bl;
                    this.$write = bl2;
                }
            });
        }
    }

    public static /* synthetic */ void addGame$default(GameVersion gameVersion, String string2, String string3, String string4, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        gameVersion.addGame(string2, string3, string4, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addGameInner(String gid, String version, String md5, boolean isGrayGame, boolean write) {
        void info;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"addGameInner gid: %s, version: %s", (Object[])new Object[]{gid, version});
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = mStorageGameInfos.get(gid);
        if ((GameVersionInfo)info.element == null) {
            info.element = new GameVersionInfo();
            ((Map)mStorageGameInfos).put(gid, (GameVersionInfo)info.element);
        }
        ((GameVersionInfo)info.element).setGameId$game_debug(gid);
        ((GameVersionInfo)info.element).setVersion$game_debug(version);
        ((GameVersionInfo)info.element).setMd5$game_debug(md5);
        ((GameVersionInfo)info.element).setGrayGame$game_debug(isGrayGame);
        ((GameVersionInfo)info.element).setDownloadTime$game_debug(System.currentTimeMillis());
        ((GameVersionInfo)info.element).setCanAutoDownload$game_debug(true);
        ((GameVersionInfo)info.element).setHadDelete$game_debug(false);
        ((GameVersionInfo)info.element).setPreDelete$game_debug(0);
        YYTaskExecutor.execute((Runnable)new Runnable(gid, version, (Ref.ObjectRef)info, write){
            final /* synthetic */ String $gid;
            final /* synthetic */ String $version;
            final /* synthetic */ Ref.ObjectRef $info;
            final /* synthetic */ boolean $write;

            public final void run() {
                String path = GameDownloadUtils.getGameFullPath(this.$gid, this.$version);
                long size = YYFileUtils.getFileSize((File)new File(path));
                ((GameVersionInfo)this.$info.element).setSize$game_debug(size);
                if (this.$write) {
                    GameVersion.access$writeStateConfig(GameVersion.INSTANCE, 5000L);
                }
            }
            {
                this.$gid = string2;
                this.$version = string3;
                this.$info = objectRef;
                this.$write = bl;
            }
        });
    }

    static /* synthetic */ void addGameInner$default(GameVersion gameVersion, String string2, String string3, String string4, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        gameVersion.addGameInner(string2, string3, string4, bl, bl2);
    }

    public final void deleteAllGame() {
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"deleteAllGame not init", (Object[])new Object[0]);
            return;
        }
        MLog.debug((Object)TAG, (String)"deleteAllGame mStorageGameInfos: %s", (Object[])new Object[]{mStorageGameInfos});
        YYFileUtils.delete((File)new File(GameDownloadUtils.getAppGameDir()));
        mStorageGameInfos.clear();
    }

    public final void deleteGame(@NotNull String gameId, boolean write, boolean canAutoDownload) {
        Intrinsics.checkParameterIsNotNull((Object)gameId, (String)"gameId");
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            return;
        }
        if (this.hadInit()) {
            this.deleteGameInner(gameId, write, canAutoDownload);
        } else {
            MLog.error((Object)TAG, (String)"deleteGame not init gid: %s, write: %b", (Object[])new Object[]{gameId, write});
            mPendingTask.add(new Runnable(gameId, write, canAutoDownload){
                final /* synthetic */ String $gameId;
                final /* synthetic */ boolean $write;
                final /* synthetic */ boolean $canAutoDownload;

                public final void run() {
                    GameVersion.access$deleteGameInner(GameVersion.INSTANCE, this.$gameId, this.$write, this.$canAutoDownload);
                }
                {
                    this.$gameId = string2;
                    this.$write = bl;
                    this.$canAutoDownload = bl2;
                }
            });
        }
    }

    public static /* synthetic */ void deleteGame$default(GameVersion gameVersion, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        gameVersion.deleteGame(string2, bl, bl2);
    }

    private final void deleteGameInner(String gameId, boolean write, boolean canAutoDownload) {
        block4: {
            String version;
            String gid;
            block5: {
                GameVersionInfo info;
                boolean bl;
                BasicGameInfo gameInfo;
                BasicGameInfo basicGameInfo;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"deleteGameInner gameId: %s", (Object[])new Object[]{gameId});
                }
                if ((basicGameInfo = (gameInfo = this.getGameInfo(gameId))) != null && (basicGameInfo = basicGameInfo.downloadInfo) != null) {
                    basicGameInfo.setState(GameDownloadInfo.DownloadState.download_not);
                }
                String cachePath = "";
                BasicGameInfo basicGameInfo2 = gameInfo;
                if (basicGameInfo2 != null) {
                    BasicGameInfo basicGameInfo3 = basicGameInfo2;
                    boolean bl2 = false;
                    bl = false;
                    BasicGameInfo it = basicGameInfo3;
                    boolean bl3 = false;
                    cachePath = EngineConfigGeneratorKt.getSDGameCacheDir(it);
                }
                GameVersionInfo gameVersionInfo = info = mStorageGameInfos.get(gameId);
                if (gameVersionInfo == null) break block4;
                GameVersionInfo gameVersionInfo2 = gameVersionInfo;
                bl = false;
                boolean bl4 = false;
                GameVersionInfo it = gameVersionInfo2;
                boolean bl5 = false;
                info.setCanAutoDownload$game_debug(canAutoDownload);
                gid = it.getGameId$game_debug();
                version = it.getVersion$game_debug();
                info.deleteGame();
                if (write) {
                    GameVersion.writeStateConfig$default(INSTANCE, 0L, 1, null);
                }
                boolean $i$f$onWork = false;
                if (!YYTaskExecutor.isMainThread()) break block5;
                YYTaskExecutor.execute((Runnable)new Runnable(gid, version){
                    final /* synthetic */ String $gid$inlined;
                    final /* synthetic */ String $version$inlined;
                    {
                        this.$gid$inlined = string2;
                        this.$version$inlined = string3;
                    }

                    public final void run() {
                        boolean bl = false;
                        String path = GameDownloadUtils.getGameFullPath(this.$gid$inlined, this.$version$inlined);
                        String cachePath = EngineConfigGeneratorKt.getSDGameCacheDirByGid(this.$gid$inlined);
                        Context context = RuntimeContext.sApplicationContext;
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
                        String webGamePath = GameFile.getGameFileRootDir((Context)context, (String)this.$gid$inlined);
                        YYFileUtils.delete((File)new File(path));
                        YYFileUtils.delete((File)new File(cachePath));
                        if (!TextUtils.isEmpty((CharSequence)webGamePath)) {
                            YYFileUtils.delete((File)new File(webGamePath));
                        }
                    }
                });
                break block4;
            }
            boolean bl = false;
            String path = GameDownloadUtils.getGameFullPath(gid, version);
            String cachePath = EngineConfigGeneratorKt.getSDGameCacheDirByGid(gid);
            Context context = RuntimeContext.sApplicationContext;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
            String webGamePath = GameFile.getGameFileRootDir((Context)context, (String)gid);
            YYFileUtils.delete((File)new File(path));
            YYFileUtils.delete((File)new File(cachePath));
            if (TextUtils.isEmpty((CharSequence)webGamePath)) break block4;
            YYFileUtils.delete((File)new File(webGamePath));
        }
    }

    static /* synthetic */ void deleteGameInner$default(GameVersion gameVersion, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        gameVersion.deleteGameInner(string2, bl, bl2);
    }

    public final void init(boolean reset) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"init hadInit: %b, reset: %b", (Object[])new Object[]{this.hadInit(), reset});
        }
        if (reset) {
            hadInit = false;
        }
        if (this.hadInit()) {
            return;
        }
        this.readStateConfig();
    }

    private final void readStateConfig() {
        if (this.hadInit()) {
            return;
        }
        if (AccountUtil.getUid() < 0L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"readStateConfig not login", (Object[])new Object[0]);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)readStateConfig.1.INSTANCE);
    }

    public final void checkDeleteGame$game_debug() {
        if (!this.hadInit()) {
            MLog.error((Object)TAG, (String)"checkDeleteGame not init", (Object[])new Object[0]);
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"checkDeleteGame size: %d", (Object[])new Object[]{mStorageGameInfos.size()});
        }
        boolean changed = false;
        Collection<GameVersionInfo> collection = mStorageGameInfos.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"mStorageGameInfos.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GameVersionInfo it = (GameVersionInfo)element$iv;
            boolean bl = false;
            long dif = System.currentTimeMillis() - it.getLastPlay$game_debug();
            long downloadDif = System.currentTimeMillis() - it.getDownloadTime$game_debug();
            if (dif > OUT_DATE_INTERVAL && downloadDif > DAY_7) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"checkDeleteGame \u8fd130\u5929\u6ca1\u6709\u73a9\u8fc7\u8be5\u6e38\u620f gid: %s", (Object[])new Object[]{it.getGameId$game_debug()});
                }
                GameVersion.deleteGame$default(INSTANCE, it.getGameId$game_debug(), false, false, 4, null);
                changed = true;
                continue;
            }
            if (dif <= DAY_7 || downloadDif <= DAY_7 || it.getCount$game_debug() >= 3) continue;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkDeleteGame \u6e38\u620f\u603b\u5c40\u6570\u5c0f\u4e8e3\u5c40\uff0c\u4e14\u8fd17\u5929\u6ca1\u6709\u73a9\u8fc7\u7684\u6e38\u620f gid: %s, total: %d", (Object[])new Object[]{it.getGameId$game_debug(), it.getCount$game_debug()});
            }
            GameVersion.deleteGame$default(INSTANCE, it.getGameId$game_debug(), false, false, 4, null);
            changed = true;
        }
        if (changed) {
            this.writeStateConfig(8000L);
        }
    }

    private final boolean hadInit() {
        return hadInit;
    }

    private final void handlePendingTask() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handlePendingTask %d", (Object[])new Object[]{mPendingTask.size()});
        }
        Collection collection = mPendingTask;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Iterable $this$forEach$iv = mPendingTask;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Runnable it = (Runnable)element$iv;
                boolean bl2 = false;
                it.run();
            }
            mPendingTask.clear();
        }
    }

    public final void startGame$game_debug(@NotNull String gameId) {
        Intrinsics.checkParameterIsNotNull((Object)gameId, (String)"gameId");
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            return;
        }
        GameVersionInfo info = mStorageGameInfos.get(gameId);
        if (info != null) {
            info.setLastPlay$game_debug(System.currentTimeMillis());
            GameVersion.writeStateConfig$default(this, 0L, 1, null);
        }
    }

    public final void updatePlayCount$game_debug(@NotNull String gameId, int count) {
        Intrinsics.checkParameterIsNotNull((Object)gameId, (String)"gameId");
        if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updatePlayCount gameId: %s, count: %d", (Object[])new Object[]{gameId, count});
        }
        if (TextUtils.isEmpty((CharSequence)gameId)) {
            return;
        }
        GameVersionInfo info = mStorageGameInfos.get(gameId);
        if (info != null) {
            info.setCount$game_debug(count);
            GameVersion.writeStateConfig$default(this, 0L, 1, null);
        }
    }

    public final void logout() {
        mStorageGameInfos.clear();
    }

    private final void writeStateConfig(long writeInterval) {
        block2: {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"writeStateConfig start mStorageGameInfos.size: %s", (Object[])new Object[]{mStorageGameInfos.size()});
            }
            MLog.debug((Object)TAG, (String)"writeStateConfig start mStorageGameInfos: %s", (Object[])new Object[]{mStorageGameInfos});
            Runnable runnable2 = writeStateConfig.runnable.1.INSTANCE;
            if (saveLimitExecutor == null) {
                saveLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)writeInterval, (boolean)false);
            }
            IFrequencyLimitExecutor iFrequencyLimitExecutor = saveLimitExecutor;
            if (iFrequencyLimitExecutor == null) break block2;
            iFrequencyLimitExecutor.execute(runnable2);
        }
    }

    static /* synthetic */ void writeStateConfig$default(GameVersion gameVersion, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 100L;
        }
        gameVersion.writeStateConfig(l);
    }

    private final void checkGameFile(GameInfoSource source, Map<String, ? extends BasicGameInfo> gameInfoMap) {
        if (FP.empty(gameInfoMap)) {
            return;
        }
        Map<String, ? extends BasicGameInfo> map = gameInfoMap;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        boolean write = this.checkAppGameFile(map);
        boolean bl = write = this.checkFileState() || write;
        if (write) {
            this.writeStateConfig(8000L);
        }
    }

    private final void checkOldDir(GameInfoSource source, Map<String, ? extends BasicGameInfo> gameInfoMap) {
        if (!SettingFlags.getBoolean((String)(CHECK_OLD_DIR_KEY + source.getSource()), (boolean)false)) {
            Iterable $this$forEach$iv = gameInfoMap.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicGameInfo it = (BasicGameInfo)element$iv;
                boolean bl = false;
                String oldPath = GameDownloadUtils.getGameFullPathOld(it);
                File oldFile = new File(oldPath);
                if (!oldFile.exists()) continue;
                String newPath = GameDownloadUtils.getGameLocalFullPath(it);
                YYFileUtils.copy((File)oldFile, (File)new File(newPath));
                YYFileUtils.delete((File)oldFile);
            }
            SettingFlags.setBoolean((String)(CHECK_OLD_DIR_KEY + source.getSource()), (boolean)true);
        }
    }

    private final boolean checkAppGameFile(Map<String, ? extends BasicGameInfo> gameInfoMap) {
        File[] files;
        String app = GameDownloadUtils.getAppGameDir();
        File file = new File(app);
        boolean change = false;
        if (file.exists() && file.isDirectory() && files != null) {
            File[] $this$forEach$iv = files = file.listFiles();
            boolean $i$f$forEach = false;
            File[] fileArray = $this$forEach$iv;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray[i];
                boolean bl = false;
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                String id2 = file2.getName();
                GameVersionInfo info = mStorageGameInfos.get(id2);
                if (!gameInfoMap.containsKey(id2)) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = id2;
                    GameVersionInfo gameVersionInfo = info;
                    objectArray[1] = gameVersionInfo != null ? Integer.valueOf(gameVersionInfo.getPreDelete$game_debug()) : null;
                    MLog.debug((Object)TAG, (String)"checkAppGameFile id: %s, preDelete: %d", (Object[])objectArray);
                    change = true;
                    if (info == null || info.getPreDelete$game_debug() > 20) continue;
                    GameVersionInfo gameVersionInfo2 = info;
                    int n2 = gameVersionInfo2.getPreDelete$game_debug();
                    gameVersionInfo2.setPreDelete$game_debug(n2 + 1);
                    continue;
                }
                GameVersionInfo gameVersionInfo = info;
                if (gameVersionInfo != null) {
                    gameVersionInfo.setPreDelete$game_debug(0);
                }
            }
        }
        return change;
    }

    private final boolean checkFileState() {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("checkFileState start mStorageGameInfos: " + mStorageGameInfos), (Object[])new Object[0]);
        }
        boolean stateChange = false;
        String appGameDir = GameDownloadUtils.getAppGameDir();
        File file = new File(appGameDir);
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            ArrayList<String> ids = new ArrayList<String>(files != null ? files.length : 0);
            File[] fileArray = files;
            boolean bl = false;
            boolean bl2 = false;
            File[] it = fileArray;
            boolean bl3 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            File[] $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                BasicGameInfo basicGameInfo;
                File element$iv;
                File file2 = element$iv = fileArray2[i];
                boolean bl4 = false;
                File file3 = file2;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
                String id2 = file3.getName();
                ids.add(id2);
                String string2 = id2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"id");
                BasicGameInfo info = INSTANCE.getGameInfo(string2);
                if (info == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                BasicGameInfo it2 = basicGameInfo;
                boolean bl7 = false;
                GameVersionInfo versionInfo = mStorageGameInfos.get(id2);
                if (INSTANCE.checkFile(info)) {
                    MLog.debug((Object)TAG, (String)("checkFileState versionInfo: " + versionInfo), (Object[])new Object[0]);
                    if (versionInfo == null) {
                        stateChange = true;
                        String string3 = info.gid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"info.gid");
                        String string4 = info.getModulerVer();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"info.modulerVer");
                        String string5 = info.getModulerMd5();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"info.modulerMd5");
                        INSTANCE.addGame(string3, string4, string5, info.isModuleGray(), false);
                        continue;
                    }
                    versionInfo.setHadDelete$game_debug(false);
                    stateChange = versionInfo.updateInfo(info);
                    continue;
                }
                MLog.debug((Object)TAG, (String)"checkFileState invalid gid: %s", (Object[])new Object[]{info.gid});
                stateChange = true;
                if (versionInfo == null || !MLog.isLogLevelBlowInfo()) continue;
                MLog.info((Object)TAG, (String)"checkFileState check file not valid and delete, id: %s", (Object[])new Object[]{id2});
            }
            ArrayList<String> rm = new ArrayList<String>();
            Set set = mStorageGameInfos.keySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"mStorageGameInfos.keys");
            Iterable $this$forEach$iv2 = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String key = (String)element$iv;
                boolean bl8 = false;
                if (ids.contains(key)) continue;
                rm.add(key);
            }
            Collection collection = rm;
            boolean bl9 = false;
            if (!collection.isEmpty()) {
                stateChange = true;
                mStorageGameInfos.keySet().removeAll((Collection)rm);
            }
        }
        return stateChange;
    }

    private final boolean checkFile(BasicGameInfo info) {
        String path;
        File file;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"checkFile, info: %s", (Object[])new Object[]{info});
        }
        if (!(file = new File(path = GameDownloadUtils.getGameLocalFullPath(info))).exists() || file.isDirectory()) {
            return false;
        }
        return this.checkFileNameVersionAndMd5(info);
    }

    private final boolean checkFileNameVersionAndMd5(BasicGameInfo info) {
        String path = GameDownloadUtils.getGameLocalFullPath(info);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"checkFileNameVersionAndMd5 path: %s, info: %s", (Object[])new Object[]{path, info});
        }
        String string2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        if (this.checkVersion(info, string2)) {
            return true;
        }
        File file = new File(path);
        return !RemoteGameDebugService.Companion.checkMD5(info.getGid()) ? true : YYFileUtils.checkFileMd5((File)file, (String)info.getModulerMd5(), (long)0L);
    }

    private final boolean checkVersion(BasicGameInfo info, String path) {
        List ps = StringsKt.split$default((CharSequence)path, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null);
        Collection collection = ps;
        boolean bl = false;
        if (!collection.isEmpty()) {
            String vStr;
            String string2 = vStr = (String)ps.get(ps.size() - 1);
            int n = 0;
            int n2 = StringsKt.lastIndexOf$default((CharSequence)vStr, (String)".", (int)0, (boolean)false, (int)6, null);
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            vStr = string4;
            int builtInV = StringUtils.safeParseInt((String)vStr);
            int version = StringUtils.safeParseInt((String)info.getModulerVer());
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"checkVersion builtInV: %s, game list version: %s", (Object[])new Object[]{builtInV, version});
            }
            if (builtInV != 0 && builtInV >= version) {
                info.setModulerVer(String.valueOf(builtInV));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void configFromFile() {
        File[] files;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"configFromFile", (Object[])new Object[0]);
        }
        SettingFlags.setBoolean((String)CHECK_OLD_CONFIG_KEY, (boolean)true);
        String app = GameDownloadUtils.getAppGameLuaDir();
        File file = new File(app);
        boolean change = false;
        if (file.exists() && file.isDirectory() && files != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = files = file.listFiles();
            boolean $i$f$filter = false;
            File[] fileArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var10_11 = $this$filterTo$iv$iv;
            int n = ((void)var10_11).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var10_11[i];
                boolean bl = false;
                void v0 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                if (!v0.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File gameDir = (File)element$iv;
                boolean bl = false;
                File file2 = gameDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"gameDir");
                String gid = file2.getName();
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)"configFromFile gid: %s", (Object[])new Object[]{gid});
                }
                if (TextUtils.isEmpty((CharSequence)gid)) continue;
                String string2 = gid;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gid");
                INSTANCE.addWithFile(string2);
                change = true;
            }
        }
        if (change) {
            GameVersion.writeStateConfig$default(this, 0L, 1, null);
        }
    }

    private final void addWithFile(String gid) {
        String version = GameFlag.getGameVersion(gid);
        String md5 = GameFlag.getGameMd5(gid);
        boolean isGray = GameFlag.isGrayGame(gid);
        String path = GameDownloadUtils.getGameFullPath(gid, version);
        File file = new File(path);
        if (file.exists() && !file.isDirectory()) {
            String string2 = version;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"version");
            String string3 = md5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"md5");
            this.addGame(gid, string2, string3, isGray, false);
        }
    }

    private final BasicGameInfo getGameInfo(String gid) {
        if (!ServiceManagerProxy.hadInit()) {
            return null;
        }
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        return (BasicGameInfo)(iServiceManager != null && (iServiceManager = (IGameInfoService)iServiceManager.getService(IGameInfoService.class)) != null ? iServiceManager.getGameInfoByGid(gid) : null);
    }

    private GameVersion() {
    }

    public static final /* synthetic */ void access$setGameInfoListInner(GameVersion $this, GameInfoSource source, List list) {
        $this.setGameInfoListInner(source, list);
    }

    public static final /* synthetic */ void access$addGameInner(GameVersion $this, String gid, String version, String md5, boolean isGrayGame, boolean write) {
        $this.addGameInner(gid, version, md5, isGrayGame, write);
    }

    public static final /* synthetic */ void access$writeStateConfig(GameVersion $this, long writeInterval) {
        $this.writeStateConfig(writeInterval);
    }

    public static final /* synthetic */ void access$deleteGameInner(GameVersion $this, String gameId, boolean write, boolean canAutoDownload) {
        $this.deleteGameInner(gameId, write, canAutoDownload);
    }

    public static final /* synthetic */ boolean access$hadInit(GameVersion $this) {
        return $this.hadInit();
    }

    public static final /* synthetic */ ReentrantLock access$getFileLock$p(GameVersion $this) {
        GameVersion gameVersion = $this;
        return fileLock;
    }

    public static final /* synthetic */ void access$configFromFile(GameVersion $this) {
        $this.configFromFile();
    }

    public static final /* synthetic */ Type access$getMJsonType$p(GameVersion $this) {
        return $this.getMJsonType();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getMStorageGameInfos$p(GameVersion $this) {
        GameVersion gameVersion = $this;
        return mStorageGameInfos;
    }

    public static final /* synthetic */ boolean access$checkFileState(GameVersion $this) {
        return $this.checkFileState();
    }

    public static final /* synthetic */ void access$handlePendingTask(GameVersion $this) {
        $this.handlePendingTask();
    }

    public static final /* synthetic */ boolean access$getHadInit$p(GameVersion $this) {
        GameVersion gameVersion = $this;
        return hadInit;
    }

    public static final /* synthetic */ void access$setHadInit$p(GameVersion $this, boolean bl) {
        GameVersion gameVersion = $this;
        hadInit = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016R(\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/yy/game/download/version/GameVersion$CheckGameFileTask;", "Ljava/lang/Runnable;", "source", "Lcom/yy/hiyo/game/base/bean/GameInfoSource;", "(Lcom/yy/hiyo/game/base/bean/GameInfoSource;)V", "gameInfoMap", "", "", "Lcom/yy/hiyo/game/base/bean/BasicGameInfo;", "getGameInfoMap", "()Ljava/util/Map;", "setGameInfoMap", "(Ljava/util/Map;)V", "getSource", "()Lcom/yy/hiyo/game/base/bean/GameInfoSource;", "run", "", "game_debug"})
    private static final class CheckGameFileTask
    implements Runnable {
        @Nullable
        private Map<String, ? extends BasicGameInfo> gameInfoMap;
        @NotNull
        private final GameInfoSource source;

        @Nullable
        public final Map<String, BasicGameInfo> getGameInfoMap() {
            return this.gameInfoMap;
        }

        public final void setGameInfoMap(@Nullable Map<String, ? extends BasicGameInfo> map) {
            this.gameInfoMap = map;
        }

        @Override
        public void run() {
            INSTANCE.checkGameFile(this.source, this.gameInfoMap);
        }

        @NotNull
        public final GameInfoSource getSource() {
            return this.source;
        }

        public CheckGameFileTask(@NotNull GameInfoSource source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            this.source = source;
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/yy/game/download/version/GameVersion$GameDownloadType;", "", "Companion", "game_debug"})
    public static @interface GameDownloadType {
        public static final Companion Companion = Companion.$$INSTANCE;
        public static final int HAS_DOWNLOAD = 0;
        public static final int FIRST_DOWNLOAD = 1;
        public static final int UPDATE_DOWNLOAD = 2;
        public static final int UNKOWN = 3;

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/yy/game/download/version/GameVersion$GameDownloadType$Companion;", "", "()V", "FIRST_DOWNLOAD", "", "HAS_DOWNLOAD", "UNKOWN", "UPDATE_DOWNLOAD", "game_debug"})
        public static final class Companion {
            public static final int HAS_DOWNLOAD = 0;
            public static final int FIRST_DOWNLOAD = 1;
            public static final int UPDATE_DOWNLOAD = 2;
            public static final int UNKOWN = 3;
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }
}

