/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.download.stat;

import android.content.Context;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.game.download.DownloadTaskTag;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class GameDownloadStat {
    private static final String TAG = "GameDownloadStat";
    private static final String METRIC_URI_DOWNLOAD = "hydl_";
    private static final String METRIC_URI_PATCH = "hydl_patch/";
    private static String CONTENT_ACT_DYNAMIC_LOAD_DOWNLOAD = "hagodownload";
    private static final String SUCESS = "load_success";
    private static final String FAIL = "load_fail";
    private static final String START = "load_start";

    public static void statDownloadComplete(String gid, GameDownloadInfo.DownloadType type, long useTime, boolean isPreDownload) {
        GameDownloadStat.stat(gid, type, useTime, SUCESS, isPreDownload);
    }

    public static void statDownloadStart(String gid, GameDownloadInfo.DownloadType type, boolean isPreDownload) {
        GameDownloadStat.stat(gid, type, 0L, START, isPreDownload);
    }

    public static void statDownloadError(String gid, GameDownloadInfo.DownloadType type, long useTime, boolean isPreDownload) {
        GameDownloadStat.stat(gid, type, useTime, FAIL, isPreDownload);
    }

    private static void stat(String gid, GameDownloadInfo.DownloadType type, long useTime, String status, boolean isPreDownload) {
        HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20024991").put("function_id", status).put("gid", gid).put("load_page", AccountUtil.getUid() > 0L ? "0" : "1").put("download_type", type == GameDownloadInfo.DownloadType.silent ? "1" : "0").put("network_environment", NetworkUtils.isWifiActive((Context)RuntimeContext.sApplicationContext) ? "1" : "0").put("pre_download_mode", RuntimeContext.sPreLoadGameId.equals(gid) ? "1" : "0").put("deeplink", RuntimeContext.sFirstGameDeepLink).put("is_pre_download", isPreDownload ? "1" : "0");
        if (!StringUtils.equalsIgnoreCase((String)status, (String)START)) {
            hiidoEvent.put("load_time", String.valueOf(useTime));
        }
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
    }

    public static void statCancel(Context context, GameInfo gameInfo, int downloadType) {
        StatisContent statContent = new StatisContent();
        statContent.put("res", 2);
        statContent.put("uid", String.valueOf(AccountUtil.getUid()));
        statContent.put("net", String.valueOf(NetworkUtils.getNetworkType((Context)context)));
        statContent.put("dgroup", "1");
        statContent.put("subgroup", String.valueOf(gameInfo.getGameMode()));
        statContent.put("hynet", String.valueOf(NetworkUtils.getNetworkType((Context)context)));
        statContent.put("downloadtype", downloadType);
        statContent.put("netc", NetworkUtils.isNetworkAvailable((Context)context) ? "1" : "0");
        statContent.put("act", CONTENT_ACT_DYNAMIC_LOAD_DOWNLOAD);
        MLog.debug((Object)TAG, (String)("cancel " + statContent.toString()), (Object[])new Object[0]);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public static void addStats(Context context, DownloadTaskTag downloadTaskTag, boolean isCancel) {
        StatisContent statContent = new StatisContent();
        statContent.put("res", isCancel ? 2 : downloadTaskTag.mDownloadMetric.result);
        statContent.put("uid", String.valueOf(AccountUtil.getUid()));
        statContent.put("net", String.valueOf(NetworkUtils.getNetworkType((Context)context)));
        statContent.put("tust", downloadTaskTag.mDownloadMetric.tust);
        statContent.put("useuptime", downloadTaskTag.mDownloadMetric.useTime);
        statContent.put("retry", downloadTaskTag.mDownloadMetric.retryTimes);
        statContent.put("excex", "0");
        statContent.put("contentlength", downloadTaskTag.mDownloadMetric.contentLength);
        statContent.put("dgroup", downloadTaskTag.mDownloadMetric.taskGroup);
        statContent.put("subgroup", downloadTaskTag.mDownloadMetric.subGroup);
        statContent.put("hynet", String.valueOf(NetworkUtils.getNetworkType((Context)context)));
        statContent.put("filesize", String.valueOf(downloadTaskTag.mDownloadMetric.fileSize));
        statContent.put("name", downloadTaskTag.mDownloadMetric.fileName);
        statContent.put("downloadtype", downloadTaskTag.mDownloadMetric.downloadType);
        statContent.put("url", downloadTaskTag.mDownloadMetric.realHost);
        statContent.put("netlib", downloadTaskTag.mDownloadMetric.netLib);
        statContent.put("thread_num", downloadTaskTag.mDownloadMetric.threadNum);
        statContent.put("ab_value", NAB.B.getHiidoValue());
        if (downloadTaskTag.mDownloadMetric.result == 0) {
            statContent.put("httpcode", downloadTaskTag.mDownloadMetric.httpCode);
            statContent.put("errno", downloadTaskTag.mDownloadMetric.errCode);
            statContent.put("relativeinfo", downloadTaskTag.mDownloadMetric.errMsg);
            statContent.put("netc", NetworkUtils.isNetworkAvailable((Context)context) ? "1" : "0");
        } else {
            statContent.put("netc", "1");
        }
        statContent.put("act", CONTENT_ACT_DYNAMIC_LOAD_DOWNLOAD);
        MLog.debug((Object)TAG, (String)statContent.toString(), (Object[])new Object[0]);
        HiidoStatis.reportContent((StatisContent)statContent);
        if (!isCancel) {
            GameDownloadStat.reportMetric(context, downloadTaskTag);
        }
    }

    private static void reportMetric(Context context, DownloadTaskTag downloadTaskTag) {
        String url = downloadTaskTag.mUrl;
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            if (downloadTaskTag.mDownloadMetric.result == 0) {
                if (url != null && url.endsWith(".patch")) {
                    HiidoStatis.reportAppMonitorReturnCode((String)METRIC_URI_PATCH, (long)downloadTaskTag.mDownloadMetric.useTime, (String)String.valueOf(downloadTaskTag.mDownloadMetric.errCode));
                } else {
                    String uri = METRIC_URI_DOWNLOAD + DownloadBussinessGroup.getGroupDesc((int)downloadTaskTag.mDownloadMetric.taskGroup);
                    HiidoStatis.reportAppMonitorReturnCode((String)uri, (long)downloadTaskTag.mDownloadMetric.useTime, (String)String.valueOf(downloadTaskTag.mDownloadMetric.errCode));
                    if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("error uri = " + uri), (Object[])new Object[0]);
                    }
                }
            } else if (url != null && url.endsWith(".patch")) {
                HiidoStatis.reportAppMonitorReturnCode((String)METRIC_URI_PATCH, (long)downloadTaskTag.mDownloadMetric.useTime, (String)"0");
            } else {
                String uri = METRIC_URI_DOWNLOAD + DownloadBussinessGroup.getGroupDesc((int)downloadTaskTag.mDownloadMetric.taskGroup);
                HiidoStatis.reportAppMonitorReturnCode((String)uri, (long)downloadTaskTag.mDownloadMetric.useTime, (String)"0");
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)("sucess uri = " + uri), (Object[])new Object[0]);
                }
            }
        }
    }
}

