/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.download.patch;

import android.content.Context;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.download.patch.Patch;
import com.yy.game.download.patch.PatchCallback;
import com.yy.game.download.patch.PatchPathImpl;
import com.yy.game.download.version.GameVersion;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import downloader.bspatch.BSPatch;
import java.io.File;
import java.io.IOException;

public class PatchImpl
implements Patch {
    @Override
    public void patch(final String oldFilePath, final BasicGameInfo gameInfo, final String patchPath, final PatchCallback patchCallback) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTPatch", (String)("gameid = " + gameInfo.getGid() + " oldFilePath = " + oldFilePath + "   patchPath = " + patchPath), (Object[])new Object[0]);
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (patchCallback == null) {
                    return;
                }
                if (StringUtils.equalsIgnoreCase((String)GameVersion.INSTANCE.md5(gameInfo.gid), (String)gameInfo.getModulerMd5())) {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTPatch", (String)("gameid = " + gameInfo.gid + "\u5f53\u524d\u6587\u4ef6\u5df2\u7ecf\u662f\u6700\u65b0\u6587\u4ef6"), (Object[])new Object[0]);
                    }
                    return;
                }
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"start patch", (int)0);
                }
                if (StringUtils.isEmpty((String)oldFilePath) || StringUtils.isEmpty((String)patchPath) || !patchPath.contains(GameDownloadUtils.getPatchName(gameInfo))) {
                    String error = "gameid = " + gameInfo.getGid() + " patch onError oldFilePath = " + oldFilePath + "  patchPath = " + patchPath + " !patchPath.contains(GameDownloadUtils.getPatchName(gameInfo)) = " + !patchPath.contains(GameDownloadUtils.getPatchName(gameInfo));
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTPatch", (String)error, (Object[])new Object[0]);
                    }
                    patchCallback.onError(gameInfo, error);
                }
                String newFilePath = PatchPathImpl.getInstance().getGameNewFilePath(gameInfo);
                File oldFile = new File(oldFilePath);
                File patchFile = new File(patchPath);
                boolean oldFileExists = oldFile.exists();
                boolean patchFileExists = patchFile.exists();
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTPatch", (String)("gameid = " + gameInfo.getGid() + " oldFileExists = " + oldFileExists + "  patchFileExists = " + patchFileExists), (Object[])new Object[0]);
                }
                if (!oldFileExists || !patchFileExists) {
                    String error = "gameid = " + gameInfo.getGid() + " patch onError !oldFileExists = " + !oldFileExists + "  !patchFileExists = " + !patchFileExists;
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTPatch", (String)error, (Object[])new Object[0]);
                    }
                    patchCallback.onError(gameInfo, error);
                    return;
                }
                try {
                    int sucess = BSPatch.patchFast((File)new File(oldFilePath), (File)new File(newFilePath), (File)new File(patchPath), (int)0);
                    if (sucess == 1) {
                        boolean isQquals = YYFileUtils.checkFileMd5((File)new File(newFilePath), (String)gameInfo.getModulerMd5(), (long)0L);
                        if (FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)"FTPatch", (String)("gameid = " + gameInfo.getGid() + " patch md5  isQquals = " + isQquals), (Object[])new Object[0]);
                        }
                        if (isQquals) {
                            if (RuntimeContext.sIsDebuggable) {
                                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("gameid = " + gameInfo.getGid() + "patch sucess"), (int)0);
                            }
                            patchCallback.onSucess(gameInfo);
                        } else {
                            if (RuntimeContext.sIsDebuggable) {
                                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("gameid = " + gameInfo.getGid() + "patch fail! md5 \u4e0d\u6b63\u786e"), (int)0);
                            }
                            String error = "gameid = " + gameInfo.getGid() + " patch onError md5  isQquals = false";
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTPatch", (String)error, (Object[])new Object[0]);
                            }
                            YYFileUtils.delete((File)new File(newFilePath));
                            patchCallback.onError(gameInfo, error);
                        }
                        return;
                    }
                }
                catch (IOException e) {
                    if (RuntimeContext.sIsDebuggable) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("gameid = " + gameInfo.getGid() + " patch exception, \u6587\u4ef6\u975epatch\u6587\u4ef6\uff1f"), (int)0);
                    }
                    String error = "gameid = " + gameInfo.getGid() + " patch exception = " + e;
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTPatch", (String)error, (Object[])new Object[0]);
                    }
                    e.printStackTrace();
                    YYFileUtils.delete((File)new File(newFilePath));
                    patchCallback.onError(gameInfo, error);
                    return;
                }
                YYFileUtils.delete((File)new File(newFilePath));
                patchCallback.onError(gameInfo, "\u672a\u77e5\u9519\u8bef\uff01");
            }
        });
    }
}

