/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.download.outdate;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.data.GamePlayInfoDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.download.flag.GameFlag;
import com.yy.game.download.version.GameVersion;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.bean.GamePlayInfo;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.callback.OnGameInfoChangedListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Deprecated
public class OutDateGameManager {
    private static final String TAG = "FTGame OutDateGameManager";
    private static final long OUT_DATE_INTERVAL = TimeUnit.DAYS.toMillis(15L);
    private static final int MIN_GAME_COUNT = 30;
    private static final int CACHE_COUNT = 8;
    private static final int MAX_DOWNLOAD_GAME_COUNT = 38;
    private static final long MAX_DOWNLOAD_SIZE = 0x6400000L;
    private final long now = System.currentTimeMillis();
    private List<GamePlayInfo> mGamePlayInfoList = Collections.emptyList();
    private boolean isInit = false;
    private MutableLiveData<Boolean> isOutDateChecked = new MutableLiveData();
    private int mGameCount = 0;
    private final Object mdeleteLock = new Object();

    public void init() {
        if (!this.isInit) {
            this.isInit = true;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"init now %s", (Object[])new Object[]{this.format(this.now)});
            }
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    long startAt = System.nanoTime();
                    if (OutDateGameManager.this.isNeedCheckOutDate()) {
                        OutDateGameManager.this.initCheckOutDate();
                    } else {
                        OutDateGameManager.this.setIsOutDateChecked();
                    }
                    long endAt = System.nanoTime();
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)OutDateGameManager.TAG, (String)"init use time: %d ms", (Object[])new Object[]{(endAt - startAt) / 1000000L});
                    }
                }
            });
        }
    }

    private boolean isNeedCheckOutDate() {
        return this.isCountExceed();
    }

    private boolean isSizeExceed() {
        boolean result;
        String dir = GameDownloadUtils.getAppGameDir();
        long size = YYFileUtils.getFolderSize((File)new File(dir));
        boolean bl = result = size > 0x6400000L;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isSizeExceed: %b, size: %d", (Object[])new Object[]{result, size});
        }
        return result;
    }

    private boolean isCountExceed() {
        String dir = GameDownloadUtils.getAppGameDir();
        File file = new File(dir);
        int subDirCount = 0;
        if (file.isDirectory()) {
            for (File item : file.listFiles()) {
                if (!item.isDirectory() || FP.size((Object[])item.list()) <= 0) continue;
                ++subDirCount;
            }
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isCountExceed subDirCount %d, max: %d", (Object[])new Object[]{subDirCount, 38});
        }
        this.mGameCount = subDirCount;
        return subDirCount > 38;
    }

    private void initCheckOutDate() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initCheckOutDate", (Object[])new Object[0]);
        }
        ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).getMatchGamePlayInfo(new GameInfoModuleData.Matcher(){

            public boolean match(GamePlayInfoDBBean infoDBBean) {
                return true;
            }
        }, new GameInfoModuleData.MatchCallback(){

            public void onGetResult(List<GamePlayInfo> gamePlayInfos) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)OutDateGameManager.TAG, (String)"initCheckOutDate onGetResult size: %s", (Object[])new Object[]{FP.size(gamePlayInfos)});
                }
                MLog.debug((Object)OutDateGameManager.TAG, (String)"initCheckOutDate onGetResult infos: %s", (Object[])new Object[]{gamePlayInfos});
                OutDateGameManager.this.mGamePlayInfoList = gamePlayInfos;
                ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).addGameInfoListener(new OnGameInfoChangedListener(){

                    public void onGameInfoChanged(GameInfoSource source, List<GameInfo> list) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)OutDateGameManager.TAG, (String)"initCheckOutDate onGameInfoChanged, size %d", (Object[])new Object[]{FP.size(list)});
                        }
                        if (!FP.empty(list)) {
                            if (OutDateGameManager.this.shouldAutoDelete()) {
                                OutDateGameManager.this.checkOutDate(OutDateGameManager.this.mGamePlayInfoList, list);
                            } else {
                                OutDateGameManager.this.setIsOutDateChecked();
                            }
                        }
                    }
                }, true);
            }
        });
    }

    private void checkOutDate(final List<GamePlayInfo> gamePlayInfos, final List<GameInfo> list) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = OutDateGameManager.this.mdeleteLock;
                synchronized (object) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)OutDateGameManager.TAG, (String)"checkOutDate thread %s, gamePlayInfos: %d, gameInfoList: %d", (Object[])new Object[]{Thread.currentThread(), FP.size((Collection)gamePlayInfos), FP.size((Collection)list)});
                    }
                    ArrayList<GameInfo> outDateList = new ArrayList<GameInfo>();
                    for (GameInfo item : list) {
                        if (!GameVersion.INSTANCE.isGamePkgValid((BasicGameInfo)item) || !OutDateGameManager.this.isOutDate(item.gid)) continue;
                        outDateList.add(item);
                    }
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)OutDateGameManager.TAG, (String)"mGameCount %d, outData size: %d, MIN_GAME_COUNT: %d", (Object[])new Object[]{OutDateGameManager.this.mGameCount, FP.size(outDateList), 30});
                    }
                    int size = OutDateGameManager.this.mGameCount;
                    int maxSize = FP.size(outDateList);
                    for (int i = 0; size > 30 && i < maxSize; --size, ++i) {
                        MLog.debug((Object)OutDateGameManager.TAG, (String)"delete mGameCount %d, size %d, maxSize %d, i %d", (Object[])new Object[]{OutDateGameManager.this.mGameCount, size, maxSize, i});
                        OutDateGameManager.this.deleteOutDate((GameInfo)outDateList.get(i));
                    }
                    OutDateGameManager.this.setIsOutDateChecked();
                }
            }
        });
    }

    private void setIsOutDateChecked() {
        if (!Boolean.TRUE.equals(this.isOutDateChecked.getValue())) {
            this.isOutDateChecked.postValue((Object)true);
        }
    }

    private boolean isOutDate(long now, long end) {
        if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"isOutDate, now: %d, end: %d, interval: %d, isOutDate\uff1a %b", (Object[])new Object[]{now, end, OUT_DATE_INTERVAL, now - end > OUT_DATE_INTERVAL});
        }
        return now - end > OUT_DATE_INTERVAL;
    }

    private void deleteOutDate(GameInfo info) {
        MLog.debug((Object)TAG, (String)"deleteOutDate %s", (Object[])new Object[]{info});
        GameDownloadUtils.deleteGame((BasicGameInfo)info);
        YYFileUtils.removeDir((String)GameDownloadUtils.getSingleGameDir((BasicGameInfo)info));
    }

    public boolean isOutDate(String gid) {
        for (GamePlayInfo item : this.mGamePlayInfoList) {
            if (!StringUtils.equal((String)gid, (String)item.getGameId())) continue;
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)"isOutDate, \u73a9\u8fc7\u8fd9\u4e2a\u6e38\u620f, gameId: %s, getLatestPlayTs\uff1a %d, %s", (Object[])new Object[]{gid, item.getLatestPlayTs(), this.format(item.getLatestPlayTs())});
            }
            GameFlag.removeOutDate(gid);
            return this.isOutDate(this.now, item.getLatestPlayTs());
        }
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gid);
        if (gameInfo != null && GameVersion.INSTANCE.isGameInfoValid((BasicGameInfo)gameInfo)) {
            boolean result;
            long downloadAt;
            String path = GameDownloadUtils.getGameLocalFullPath((BasicGameInfo)gameInfo);
            File file = new File(path);
            long l = downloadAt = file.exists() ? file.lastModified() : 0L;
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)"isOutDate \u6ca1\u73a9\u8fc7\u8fd9\u4e2a\u6e38\u620f\uff0c%s\uff0cdownload at: %d, %s", (Object[])new Object[]{gid, downloadAt, this.format(downloadAt)});
            }
            boolean bl = result = downloadAt > 0L && this.isOutDate(this.now, downloadAt);
            if (downloadAt > 0L) {
                GameFlag.setOutDate(gid, result);
            }
            return result;
        }
        return GameFlag.isOutDate(gid);
    }

    private String format(long date) {
        if (date <= 0L) {
            return "";
        }
        return TimeUtils.getFormatTimeString((long)date, (String)"year-mon-day");
    }

    public LiveData<Boolean> getIsOutDateChecked() {
        return this.isOutDateChecked;
    }

    private boolean shouldAutoDelete() {
        if (!StringUtils.isEmpty((String)RuntimeContext.getVoiceRoomId())) {
            return false;
        }
        if (ServiceManagerProxy.getServiceManager() == null) {
            return false;
        }
        IGameCenterService gameCenterService2 = (IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class);
        if (gameCenterService2 != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"shouldAutoDelete isMatching: %b, isPlaying: %b, isTeamMatching: %b", (Object[])new Object[]{gameCenterService2.isMatching(), gameCenterService2.isPlaying(), gameCenterService2.isTeamMatching()});
            }
            if (gameCenterService2.isMatching() || gameCenterService2.isPlaying() || gameCenterService2.isTeamMatching()) {
                return false;
            }
        }
        return true;
    }
}

