/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.download.flag;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.base.bean.GameInfo;

@Deprecated
public class GameFlag {
    private static final String PREFIX = "game_flag_";
    private static final String PREFIX_MD5 = "game_flag_md5_";
    private static final String PREFIX_VERSION = "game_flag_version_";
    private static final String PREFIX_IS_DOWNLOAD = "game_flag_is_downloaded_";
    private static final String PREFIX_IS_OUT_DATE = "is_out_date_";
    private static final String PREFIX_IS_GRAY = "is_gray_";
    private static SharedPreferences mGameSP;

    public static boolean isGameValid(GameInfo info) {
        if (GameFlag.isAlreadyDownload(info.getGid())) {
            int localVersion = StringUtils.safeParseInt((String)GameFlag.getGameVersion(info.getGid()));
            int infoVersion = StringUtils.safeParseInt((String)info.getModulerVer());
            boolean isCurrentGray = info.isModuleGray();
            boolean isSaveGray = GameFlag.isGrayGame(info.getGid());
            String saveMd5 = GameFlag.getGameMd5(info.getGid());
            String currentMd5 = info.getModulerMd5();
            if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"GameFlag", (String)"gid: %s, localVersion: %s, cur: %s, localGray: %b, cur: %b, localMd5: %s, cur: %s", (Object[])new Object[]{info.getGid(), localVersion, infoVersion, isSaveGray, isCurrentGray, saveMd5, currentMd5});
            }
            if (StringUtils.equalsIgnoreCase((String)saveMd5, (String)currentMd5)) {
                if (localVersion != infoVersion) {
                    info.setModulerVer(String.valueOf(localVersion));
                }
                return true;
            }
            if (RemoteGameDebugService.Companion.useRemoteIp(info.gid)) {
                return false;
            }
            if (isSaveGray) {
                if (isCurrentGray) {
                    return infoVersion == localVersion;
                }
                return false;
            }
            return infoVersion <= localVersion;
        }
        return false;
    }

    public static boolean isAlreadyDownload(String gameId) {
        String key = PREFIX_IS_DOWNLOAD + gameId;
        if (!GameFlag.getGameSP().contains(key) && SettingFlags.containKey((String)key)) {
            boolean result = SettingFlags.getBoolean((String)key, (boolean)false);
            SettingFlags.removeKey((String)key);
            GameFlag.getGameSP().edit().putBoolean(key, result).apply();
            return result;
        }
        return GameFlag.getGameSP().getBoolean(key, false);
    }

    public static String getGameMd5(String gameId) {
        String key = PREFIX_MD5 + gameId;
        if (!GameFlag.getGameSP().contains(key) && SettingFlags.containKey((String)key)) {
            String result = SettingFlags.getStringValue((String)key, (String)"");
            SettingFlags.removeKey((String)key);
            GameFlag.getGameSP().edit().putString(key, result).apply();
            return result;
        }
        return GameFlag.getGameSP().getString(PREFIX_MD5 + gameId, "");
    }

    public static void modifyGameMd5(String gameId, String md5) {
        String key = PREFIX_MD5 + gameId;
        GameFlag.getGameSP().edit().putString(key, md5).apply();
        if (SettingFlags.containKey((String)key)) {
            SettingFlags.removeKey((String)key);
        }
    }

    public static String getGameVersion(String gameId) {
        String key = PREFIX_VERSION + gameId;
        if (!GameFlag.getGameSP().contains(key) && SettingFlags.containKey((String)key)) {
            String result = SettingFlags.getStringValue((String)key, (String)"");
            SettingFlags.removeKey((String)key);
            GameFlag.getGameSP().edit().putString(key, result).apply();
            return result;
        }
        return GameFlag.getGameSP().getString(key, "");
    }

    public static void modifyGameVersion(String gameId, String version) {
        String key = PREFIX_VERSION + gameId;
        GameFlag.getGameSP().edit().putString(key, version).apply();
        if (SettingFlags.containKey((String)key)) {
            SettingFlags.removeKey((String)key);
        }
    }

    public static void notifyGameDownloaded(String gameId) {
        String key = PREFIX_IS_DOWNLOAD + gameId;
        GameFlag.getGameSP().edit().putBoolean(key, true).apply();
        if (SettingFlags.containKey((String)key)) {
            SettingFlags.removeKey((String)key);
        }
    }

    public static void notifyGameDelete(String gameId) {
        GameFlag.removeKeys(gameId);
    }

    public static boolean isOutDate(String gameId) {
        return GameFlag.getGameSP().getBoolean(PREFIX_IS_OUT_DATE + gameId, false);
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void clear(boolean sync) {
        if (sync) {
            GameFlag.getGameSP().edit().clear().commit();
        } else {
            GameFlag.getGameSP().edit().clear().apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SharedPreferences getGameSP() {
        if (mGameSP != null) return mGameSP;
        Class<GameFlag> clazz = GameFlag.class;
        synchronized (GameFlag.class) {
            if (mGameSP != null) return mGameSP;
            mGameSP = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, "gamesp", 0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mGameSP;
        }
    }

    public static void setOutDate(String gameId, boolean isOutDate) {
        GameFlag.getGameSP().edit().putBoolean(PREFIX_IS_OUT_DATE + gameId, isOutDate).apply();
    }

    public static void removeOutDate(String gameId) {
        if (GameFlag.getGameSP().contains(PREFIX_IS_OUT_DATE + gameId)) {
            GameFlag.getGameSP().edit().remove(PREFIX_IS_OUT_DATE + gameId).apply();
        }
    }

    public static void removeKeys(String gameId) {
        String[] keys;
        for (String key : keys = new String[]{PREFIX_IS_DOWNLOAD + gameId, PREFIX_MD5 + gameId, PREFIX_VERSION + gameId, PREFIX_IS_OUT_DATE + gameId, PREFIX_IS_GRAY + gameId}) {
            if (GameFlag.getGameSP().contains(key)) {
                GameFlag.getGameSP().edit().remove(key).apply();
            }
            if (!SettingFlags.containKey((String)key)) continue;
            SettingFlags.removeKey((String)key);
        }
    }

    public static void modifyGameGray(String gid, boolean gray) {
        GameFlag.getGameSP().edit().putBoolean(PREFIX_IS_GRAY + gid, gray).apply();
    }

    public static boolean isGrayGame(String gid) {
        return GameFlag.getGameSP().getBoolean(PREFIX_IS_GRAY + gid, false);
    }

    public static void removeGameGray(String gid) {
        GameFlag.getGameSP().edit().remove(PREFIX_IS_GRAY + gid).apply();
    }

    public static String getOld30MatchAi(String key) {
        return GameFlag.getGameSP().getString(key, "");
    }

    public static void updateOld30MatchAI(String key, String value) {
        GameFlag.getGameSP().edit().putString(key, value).apply();
    }
}

